/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets;

import docking.DialogComponentProvider;
import docking.widgets.checkbox.GCheckBox;
import docking.widgets.combobox.GComboBox;
import docking.widgets.label.GLabel;
import ghidra.framework.preferences.Preferences;
import ghidra.util.MessageType;
import ghidra.util.layout.PairLayout;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import org.apache.commons.lang3.StringUtils;

public class PasswordDialog
extends DialogComponentProvider {
    private JPanel workPanel;
    private JTextField nameField;
    private JPasswordField passwordField;
    private JComboBox<String> choiceCB;
    private JCheckBox anonymousAccess;
    private boolean okPressed = false;
    private String defaultUserId;
    private String userIdPreferenceKey;

    public PasswordDialog(String title, String serverType, String serverName, String passPrompt, boolean allowUserIdEntry, String userIdPrompt, String defaultUserId, String choicePrompt, String[] choices, int defaultChoice, boolean includeAnonymousOption) {
        this(title, serverType, serverName, passPrompt, allowUserIdEntry, userIdPrompt, defaultUserId, true);
        if (choicePrompt != null) {
            this.workPanel.add(new GLabel(choicePrompt));
            this.choiceCB = new GComboBox<String>(choices);
            this.choiceCB.setName("CHOICES-COMPONENT");
            this.choiceCB.setSelectedIndex(defaultChoice);
            this.workPanel.add(this.choiceCB);
        }
        if (includeAnonymousOption) {
            this.anonymousAccess = new GCheckBox("Request Anonymous Access");
            this.anonymousAccess.setName("ANONYMOUS-COMPONENT");
            this.anonymousAccess.addChangeListener(e -> {
                boolean enableOtherFields;
                boolean anonymousAccessRequested = this.anonymousAccess.isSelected();
                boolean bl = enableOtherFields = !anonymousAccessRequested;
                if (anonymousAccessRequested) {
                    this.passwordField.setText("");
                }
                this.passwordField.setEnabled(enableOtherFields);
                if (this.nameField != null) {
                    this.nameField.setEnabled(enableOtherFields);
                }
                if (this.choiceCB != null) {
                    this.choiceCB.setEnabled(enableOtherFields);
                }
            });
            this.workPanel.add(new GLabel(""));
            this.workPanel.add(this.anonymousAccess);
        }
    }

    public PasswordDialog(String title, String serverType, String serverName, String passPrompt) {
        this(title, serverType, serverName, passPrompt, true);
    }

    public PasswordDialog(String title, String serverType, String serverName, String passPrompt, boolean hasMessages) {
        this(title, serverType, serverName, passPrompt, false, null, null, hasMessages);
    }

    public PasswordDialog(String title, String serverType, String serverName, String passPrompt, boolean allowUserIdEntry, String userIdPrompt, String defaultUserId, boolean hasMessages) {
        super(title, true);
        this.defaultUserId = defaultUserId;
        this.setRememberSize(false);
        this.setTransient(true);
        if (hasMessages) {
            this.setMinimumSize(350, 150);
        }
        this.workPanel = new JPanel((LayoutManager)new PairLayout(5, 5));
        this.workPanel.setBorder(BorderFactory.createEmptyBorder(5, 10, 0, 10));
        if (serverName != null) {
            this.workPanel.add(new GLabel(serverType + ":"));
            this.workPanel.add(new GLabel(serverName));
        }
        if (StringUtils.isBlank((CharSequence)userIdPrompt)) {
            userIdPrompt = "User ID:";
        }
        if (StringUtils.isBlank((CharSequence)passPrompt)) {
            passPrompt = "Password:";
        }
        if (allowUserIdEntry) {
            String userId = defaultUserId;
            if (serverName != null) {
                userId = this.getPreferredUserId(serverType, serverName);
            }
            this.workPanel.add(new GLabel(userIdPrompt));
            this.nameField = new JTextField(userId, 16);
            this.nameField.setName("NAME-ENTRY-COMPONENT");
            this.nameField.getAccessibleContext().setAccessibleName("Name");
            this.workPanel.add(this.nameField);
        } else if (defaultUserId != null) {
            this.workPanel.add(new GLabel(userIdPrompt));
            GLabel nameLabel = new GLabel(defaultUserId);
            nameLabel.setName("NAME-COMPONENT");
            nameLabel.getAccessibleContext().setAccessibleName("Name");
            this.workPanel.add(nameLabel);
        }
        this.workPanel.add(new GLabel(passPrompt));
        this.passwordField = new JPasswordField(16);
        this.passwordField.setName("PASSWORD-ENTRY-COMPONENT");
        this.passwordField.getAccessibleContext().setAccessibleName("Password Entry");
        this.workPanel.add(this.passwordField);
        this.passwordField.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
            }

            private void displayWarning() {
                try {
                    boolean capsLockOn = Toolkit.getDefaultToolkit().getLockingKeyState(20);
                    if (capsLockOn) {
                        PasswordDialog.this.setStatusText("Warning! Caps-Lock is on", MessageType.WARNING);
                    } else {
                        PasswordDialog.this.clearStatusText();
                    }
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                    // empty catch block
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
                if (e.getKeyCode() != 10) {
                    this.displayWarning();
                }
            }

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() != 10) {
                    this.displayWarning();
                }
            }
        });
        this.workPanel.getAccessibleContext().setAccessibleName("Password");
        this.addWorkPanel(this.workPanel);
        this.addOKButton();
        this.addCancelButton();
        this.setStatusJustification(0);
        this.setFocusComponent(this.passwordField);
        this.passwordField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                if (e.getModifiersEx() == 0 && e.getKeyChar() == '\n') {
                    PasswordDialog.this.okCallback();
                }
            }
        });
    }

    public static String getPreferredUserIdPreferenceKey(String serverType, String serverName) {
        return "UserID_" + PasswordDialog.sanitizeString(serverType) + "_" + PasswordDialog.sanitizeString(serverName);
    }

    private static String sanitizeString(String str) {
        if (str == null) {
            return "_";
        }
        String newStr = str.replaceAll("[^a-zA-Z0-9_-]", "");
        return newStr.length() == 0 ? "_" : newStr;
    }

    private String getPreferredUserId(String serverType, String serverName) {
        this.userIdPreferenceKey = PasswordDialog.getPreferredUserIdPreferenceKey(serverType, serverName);
        return Preferences.getProperty((String)this.userIdPreferenceKey, (String)this.defaultUserId);
    }

    private void savePreferredUserId(String userId) {
        if (this.userIdPreferenceKey != null) {
            Preferences.setProperty((String)this.userIdPreferenceKey, (String)userId);
        }
    }

    public void setErrorText(String text) {
        super.setStatusText(text, MessageType.ERROR);
    }

    public char[] getPassword() {
        return this.passwordField.getPassword();
    }

    public boolean anonymousAccessRequested() {
        if (this.anonymousAccess != null) {
            return this.anonymousAccess.isSelected();
        }
        return false;
    }

    public String getUserID() {
        String userId = this.defaultUserId;
        if (this.nameField != null) {
            userId = this.nameField.getText().trim();
            this.savePreferredUserId(userId);
        }
        return userId;
    }

    public int getChoice() {
        if (this.choiceCB != null) {
            return this.choiceCB.getSelectedIndex();
        }
        return -1;
    }

    public boolean okWasPressed() {
        return this.okPressed;
    }

    @Override
    protected void okCallback() {
        this.okPressed = true;
        this.close();
    }

    @Override
    public void close() {
        this.closeDialog();
    }

    @Override
    public void dispose() {
        this.passwordField.setText("");
        this.rootPanel.remove(this.passwordField);
    }
}

