/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.table;

import docking.widgets.filter.FilterOptions;
import docking.widgets.filter.TermSplitter;
import docking.widgets.filter.TextFilter;
import docking.widgets.filter.TextFilterFactory;
import docking.widgets.table.InvertedTableFilter;
import docking.widgets.table.MultiTextFilterTableFilter;
import docking.widgets.table.RowFilterTransformer;
import docking.widgets.table.TableFilter;
import docking.widgets.table.TableTextFilter;
import docking.widgets.table.TableTextFilterFactory;
import java.util.ArrayList;

public class DefaultTableTextFilterFactory<ROW_OBJECT>
implements TableTextFilterFactory<ROW_OBJECT> {
    private final TextFilterFactory textFilterFactory;
    private final boolean inverted;
    private final FilterOptions filterOptions;

    public DefaultTableTextFilterFactory(FilterOptions filterOptions) {
        this.filterOptions = filterOptions;
        this.textFilterFactory = filterOptions.getTextFilterFactory();
        this.inverted = filterOptions.isInverted();
    }

    @Override
    public TableFilter<ROW_OBJECT> getTableFilter(String text, RowFilterTransformer<ROW_OBJECT> transformer) {
        TableFilter<ROW_OBJECT> tableFilter = this.getBaseFilter(text, transformer);
        if (this.inverted && tableFilter != null) {
            tableFilter = new InvertedTableFilter<ROW_OBJECT>(tableFilter);
        }
        return tableFilter;
    }

    private TableFilter<ROW_OBJECT> getBaseFilter(String text, RowFilterTransformer<ROW_OBJECT> transformer) {
        if (this.filterOptions.isMultiterm() && text.trim().length() > 0) {
            return this.getMultiWordFilter(text, transformer);
        }
        TextFilter textFilter = this.textFilterFactory.getTextFilter(text);
        if (textFilter == null) {
            return null;
        }
        return new TableTextFilter<ROW_OBJECT>(textFilter, transformer);
    }

    private TableFilter<ROW_OBJECT> getMultiWordFilter(String text, RowFilterTransformer<ROW_OBJECT> transformer) {
        ArrayList<TextFilter> filters = new ArrayList<TextFilter>();
        TermSplitter splitter = this.filterOptions.getTermSplitter();
        for (String term : splitter.split(text)) {
            TextFilter textFilter = this.textFilterFactory.getTextFilter(term);
            if (textFilter == null) continue;
            filters.add(textFilter);
        }
        return new MultiTextFilterTableFilter<ROW_OBJECT>(filters, transformer, this.filterOptions.getMultitermEvaluationMode());
    }
}

