/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.execution.plan;

import java.util.LinkedHashSet;
import java.util.Set;
import org.gradle.execution.plan.Node;
import org.gradle.execution.plan.NodeGroup;
import org.gradle.execution.plan.OrdinalNode;
import org.jspecify.annotations.Nullable;

public class OrdinalGroup
extends NodeGroup {
    private final int ordinal;
    private final @Nullable OrdinalGroup previous;
    private final Set<Node> entryNodes = new LinkedHashSet<Node>();
    private OrdinalNode producerLocationsNode;
    private OrdinalNode destroyerLocationsNode;

    OrdinalGroup(int ordinal, @Nullable OrdinalGroup previous) {
        this.ordinal = ordinal;
        this.previous = previous;
    }

    public String toString() {
        return "task group " + this.ordinal;
    }

    public @Nullable OrdinalGroup getPrevious() {
        return this.previous;
    }

    @Override
    public @Nullable OrdinalGroup asOrdinal() {
        return this;
    }

    @Override
    public NodeGroup withOrdinalGroup(OrdinalGroup newOrdinal) {
        return newOrdinal;
    }

    @Override
    public NodeGroup reachableFrom(OrdinalGroup newOrdinal) {
        return newOrdinal;
    }

    public OrdinalNode getProducerLocationsNode() {
        if (this.producerLocationsNode == null) {
            this.producerLocationsNode = new OrdinalNode(OrdinalNode.Type.PRODUCER, this);
            if (this.previous != null) {
                this.producerLocationsNode.addDependencySuccessor(this.previous.getProducerLocationsNode());
            }
        }
        return this.producerLocationsNode;
    }

    public OrdinalNode getDestroyerLocationsNode() {
        if (this.destroyerLocationsNode == null) {
            this.destroyerLocationsNode = new OrdinalNode(OrdinalNode.Type.DESTROYER, this);
            if (this.previous != null) {
                this.destroyerLocationsNode.addDependencySuccessor(this.previous.getDestroyerLocationsNode());
            }
        }
        return this.destroyerLocationsNode;
    }

    @Override
    public boolean isReachableFromEntryPoint() {
        return true;
    }

    public int getOrdinal() {
        return this.ordinal;
    }

    public void addEntryNode(Node node) {
        this.entryNodes.add(node);
    }

    public String diagnostics() {
        return "group " + this.ordinal + " entry nodes: " + Node.formatNodes(this.entryNodes);
    }

    public OrdinalNode locationsNode(OrdinalNode.Type ordinalType) {
        if (ordinalType == OrdinalNode.Type.PRODUCER) {
            return this.getProducerLocationsNode();
        }
        return this.getDestroyerLocationsNode();
    }
}

