/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.provider;

import com.google.common.collect.ImmutableCollection;
import groovy.lang.GString;
import org.gradle.api.internal.provider.ValueCollector;
import org.gradle.api.internal.provider.ValueSanitizer;
import org.gradle.internal.Cast;
import org.gradle.internal.deprecation.DeprecationLogger;
import org.gradle.internal.deprecation.DeprecationMessageBuilder;
import org.gradle.util.internal.GUtil;
import org.jspecify.annotations.Nullable;

public class ValueSanitizers {
    private static final ValueSanitizer<Object> STRING_VALUE_SANITIZER = new ValueSanitizer<Object>(){

        @Override
        public @Nullable Object sanitize(@Nullable Object value) {
            if (value instanceof GString) {
                return value.toString();
            }
            return value;
        }
    };
    private static final ValueSanitizer<Object> LONG_VALUE_SANITIZER = new ValueSanitizer<Object>(){

        @Override
        public @Nullable Object sanitize(@Nullable Object value) {
            if (value instanceof Integer) {
                return ((Integer)value).longValue();
            }
            return value;
        }
    };
    private static final ValueSanitizer<Object> IDENTITY_SANITIZER = new ValueSanitizer<Object>(){

        @Override
        public @Nullable Object sanitize(@Nullable Object value) {
            return value;
        }
    };
    private static final ValueCollector<Object> IDENTITY_VALUE_COLLECTOR = ValueSanitizers.valueCollectorWithValueSanitizer(IDENTITY_SANITIZER);
    private static final ValueCollector<Object> STRING_VALUE_COLLECTOR = ValueSanitizers.valueCollectorWithValueSanitizer(STRING_VALUE_SANITIZER);
    private static final ValueCollector<Object> LONG_VALUE_COLLECTOR = ValueSanitizers.valueCollectorWithValueSanitizer(LONG_VALUE_SANITIZER);

    private static <T extends Enum<T>> ValueSanitizer<Object> getEnumValueSanitizer(final Class<T> enumType) {
        return new ValueSanitizer<Object>(){

            @Override
            public @Nullable Object sanitize(@Nullable Object value) {
                if (value instanceof CharSequence) {
                    ((DeprecationMessageBuilder.WithDocumentation)DeprecationLogger.deprecateBehaviour((String)String.format("Assigning String value '%s' to property of enum type '%s'.", value, enumType.getCanonicalName())).willBecomeAnErrorInGradle10().withUpgradeGuideSection(8, "deprecated_string_to_enum_coercion_for_rich_properties")).nagUser();
                }
                return GUtil.toEnum((Class)enumType, (Object)value);
            }
        };
    }

    public static <T> ValueSanitizer<T> forType(@Nullable Class<? extends T> targetType) {
        ValueSanitizer<Object> valueSanitizer = String.class.equals(targetType) ? STRING_VALUE_SANITIZER : (Long.class.equals(targetType) ? LONG_VALUE_SANITIZER : (targetType != null && targetType.isEnum() ? ValueSanitizers.getEnumValueSanitizer((Class)Cast.uncheckedCast(targetType)) : IDENTITY_SANITIZER));
        return (ValueSanitizer)Cast.uncheckedCast(valueSanitizer);
    }

    public static <T> ValueCollector<T> collectorFor(@Nullable Class<? extends T> elementType) {
        ValueCollector<Object> valueCollector;
        if (String.class.equals(elementType)) {
            valueCollector = STRING_VALUE_COLLECTOR;
        } else if (Long.class.equals(elementType)) {
            valueCollector = LONG_VALUE_COLLECTOR;
        } else if (elementType != null && elementType.isEnum()) {
            ValueSanitizer<Object> valueSanitizer = ValueSanitizers.getEnumValueSanitizer((Class)Cast.uncheckedCast(elementType));
            valueCollector = ValueSanitizers.valueCollectorWithValueSanitizer(valueSanitizer);
        } else {
            valueCollector = IDENTITY_VALUE_COLLECTOR;
        }
        return (ValueCollector)Cast.uncheckedCast(valueCollector);
    }

    private static ValueCollector<Object> valueCollectorWithValueSanitizer(final ValueSanitizer<Object> sanitizer) {
        return new ValueCollector<Object>(){

            @Override
            public void add(@Nullable Object value, ImmutableCollection.Builder<Object> dest) {
                dest.add(sanitizer.sanitize(value));
            }

            @Override
            public void addAll(Iterable<?> values, ImmutableCollection.Builder<Object> dest) {
                for (Object value : values) {
                    this.add(value, dest);
                }
            }
        };
    }
}

