import '@grafana/data';
import '@grafana/ui';
import { toCompletionItem } from '../utils/toCompletionItem.js';

const getStandardSuggestions = async (monaco, currentToken, suggestionKinds, positionContext, suggestionsRegistry) => {
  let suggestions = [];
  const invalidRangeToken = (currentToken == null ? undefined : currentToken.isWhiteSpace()) || (currentToken == null ? undefined : currentToken.isParenthesis()) || (currentToken == null ? undefined : currentToken.isIdentifier()) && currentToken.value.endsWith(".");
  const range = invalidRangeToken || !(currentToken == null ? undefined : currentToken.range) ? monaco.Range.fromPositions(positionContext.position) : currentToken == null ? undefined : currentToken.range;
  for (const suggestion of [...new Set(suggestionKinds)]) {
    const registeredSuggestions = suggestionsRegistry.getIfExists(suggestion);
    if (registeredSuggestions) {
      const su = await registeredSuggestions.suggestions({ ...positionContext, range }, monaco);
      suggestions = [...suggestions, ...su.map((s) => toCompletionItem(s.label, range, { kind: s.kind, ...s }))];
    }
  }
  return Promise.resolve(suggestions);
};

export { getStandardSuggestions };
//# sourceMappingURL=getStandardSuggestions.js.map
