/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.script;

import org.jmol.script.ScriptParallelProcessor;
import org.jmol.script.ScriptProcess;
import org.jmol.util.Logger;
import org.jmol.viewer.ShapeManager;

public class ScriptProcessRunnable
implements Runnable {
    private final ScriptParallelProcessor parallelProcessor;
    private final ScriptProcess process;
    private Object processLock;
    private ShapeManager shapeManager;

    public ScriptProcessRunnable(ScriptParallelProcessor parallelProcessor, ScriptProcess process, Object lock, ShapeManager shapeManager) {
        this.parallelProcessor = parallelProcessor;
        this.process = process;
        this.processLock = lock;
        this.shapeManager = shapeManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            if (this.parallelProcessor.error == null) {
                if (Logger.debugging) {
                    Logger.debug("Running process " + this.process.processName + " " + this.process.context.pc + " - " + (this.process.context.pcEnd - 1));
                }
                this.parallelProcessor.eval(this.process.context, this.shapeManager);
                if (Logger.debugging) {
                    Logger.debug("Process " + this.process.processName + " complete");
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        catch (Error er) {
            this.parallelProcessor.clearShapeManager(er);
        }
        finally {
            Object e = this.processLock;
            synchronized (e) {
                --this.parallelProcessor.counter;
                this.processLock.notifyAll();
            }
        }
    }
}

