/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.saml.processing.core.parsers.saml.xmldsig;

import javax.xml.stream.XMLEventReader;
import javax.xml.stream.events.StartElement;
import org.keycloak.dom.xmlsec.w3.xmldsig.DSAKeyValueType;
import org.keycloak.saml.common.constants.GeneralConstants;
import org.keycloak.saml.common.exceptions.ParsingException;
import org.keycloak.saml.common.util.StaxParserUtil;
import org.keycloak.saml.processing.core.parsers.saml.xmldsig.AbstractStaxXmlDSigParser;
import org.keycloak.saml.processing.core.parsers.saml.xmldsig.XmlDSigQNames;

public class DsaKeyValueParser
extends AbstractStaxXmlDSigParser<DSAKeyValueType> {
    public static final DsaKeyValueParser INSTANCE = new DsaKeyValueParser();

    private DsaKeyValueParser() {
        super(XmlDSigQNames.DSA_KEY_VALUE);
    }

    public static DsaKeyValueParser getInstance() {
        return INSTANCE;
    }

    @Override
    protected DSAKeyValueType instantiateElement(XMLEventReader xmlEventReader, StartElement element) throws ParsingException {
        return new DSAKeyValueType();
    }

    @Override
    protected void processSubElement(XMLEventReader xmlEventReader, DSAKeyValueType target, XmlDSigQNames element, StartElement elementDetail) throws ParsingException {
        switch (element) {
            case P: {
                StaxParserUtil.advance(xmlEventReader);
                String text = StaxParserUtil.getElementText(xmlEventReader);
                target.setP(text.getBytes(GeneralConstants.SAML_CHARSET));
                break;
            }
            case Q: {
                StaxParserUtil.advance(xmlEventReader);
                String text = StaxParserUtil.getElementText(xmlEventReader);
                target.setQ(text.getBytes(GeneralConstants.SAML_CHARSET));
                break;
            }
            case G: {
                StaxParserUtil.advance(xmlEventReader);
                String text = StaxParserUtil.getElementText(xmlEventReader);
                target.setG(text.getBytes(GeneralConstants.SAML_CHARSET));
                break;
            }
            case Y: {
                StaxParserUtil.advance(xmlEventReader);
                String text = StaxParserUtil.getElementText(xmlEventReader);
                target.setY(text.getBytes(GeneralConstants.SAML_CHARSET));
                break;
            }
            case J: {
                StaxParserUtil.advance(xmlEventReader);
                String text = StaxParserUtil.getElementText(xmlEventReader);
                target.setJ(text.getBytes(GeneralConstants.SAML_CHARSET));
                break;
            }
            case SEED: {
                StaxParserUtil.advance(xmlEventReader);
                String text = StaxParserUtil.getElementText(xmlEventReader);
                target.setSeed(text.getBytes(GeneralConstants.SAML_CHARSET));
                break;
            }
            case PGEN_COUNTER: {
                StaxParserUtil.advance(xmlEventReader);
                String text = StaxParserUtil.getElementText(xmlEventReader);
                target.setPgenCounter(text.getBytes(GeneralConstants.SAML_CHARSET));
                break;
            }
            default: {
                throw LOGGER.parserUnknownTag(StaxParserUtil.getElementName(elementDetail), elementDetail.getLocation());
            }
        }
    }
}

