/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query;

import java.util.List;
import org.hibernate.Incubating;
import org.hibernate.query.KeyedPage;

@Incubating
public class KeyedResultList<R> {
    private final List<R> resultList;
    private final List<List<?>> keyList;
    private final KeyedPage<R> page;
    private final KeyedPage<R> nextPage;
    private final KeyedPage<R> previousPage;

    public KeyedResultList(List<R> resultList, List<List<?>> keyList, KeyedPage<R> page, KeyedPage<R> nextPage, KeyedPage<R> previousPage) {
        this.resultList = resultList;
        this.keyList = keyList;
        this.page = page;
        this.nextPage = nextPage;
        this.previousPage = previousPage;
    }

    public List<R> getResultList() {
        return this.resultList;
    }

    public List<List<?>> getKeyList() {
        return this.keyList;
    }

    public KeyedPage<R> getPage() {
        return this.page;
    }

    public KeyedPage<R> getNextPage() {
        return this.nextPage;
    }

    public KeyedPage<R> getPreviousPage() {
        return this.previousPage;
    }

    public boolean isLastPage() {
        return this.nextPage == null;
    }

    public boolean isFirstPage() {
        return this.page.getPage().isFirst();
    }
}

