/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.openapi.internal.models;

import io.smallrye.openapi.model.BaseExtensibleModel;
import io.smallrye.openapi.model.DataType;
import io.smallrye.openapi.model.OpenApiVersion;
import io.smallrye.openapi.model.PropertyMetadata;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.eclipse.microprofile.openapi.models.PathItem;
import org.eclipse.microprofile.openapi.models.callbacks.Callback;
import org.eclipse.microprofile.openapi.models.examples.Example;
import org.eclipse.microprofile.openapi.models.headers.Header;
import org.eclipse.microprofile.openapi.models.links.Link;
import org.eclipse.microprofile.openapi.models.media.Schema;
import org.eclipse.microprofile.openapi.models.parameters.Parameter;
import org.eclipse.microprofile.openapi.models.parameters.RequestBody;
import org.eclipse.microprofile.openapi.models.responses.APIResponse;
import org.eclipse.microprofile.openapi.models.security.SecurityScheme;

public class Components
extends BaseExtensibleModel<org.eclipse.microprofile.openapi.models.Components>
implements org.eclipse.microprofile.openapi.models.Components {
    public static final PropertyMetadata PROPERTIES = new Properties();

    public PropertyMetadata getPropertyMetadata() {
        return PROPERTIES;
    }

    public Map<String, Schema> getSchemas() {
        return this.getMapProperty("schemas");
    }

    public void setSchemas(Map<String, Schema> newValue) {
        this.setMapProperty("schemas", newValue);
    }

    public Components addSchema(String newKey, Schema newValue) {
        Objects.requireNonNull(newKey, "Key must not be null");
        Objects.requireNonNull(newValue, "Value must not be null");
        this.putMapPropertyEntry("schemas", newKey, newValue);
        return this;
    }

    public void removeSchema(String key) {
        this.removeMapPropertyEntry("schemas", key);
    }

    public Map<String, APIResponse> getResponses() {
        return this.getMapProperty("responses");
    }

    public void setResponses(Map<String, APIResponse> newValue) {
        this.setMapProperty("responses", newValue);
    }

    public Components addResponse(String newKey, APIResponse newValue) {
        Objects.requireNonNull(newKey, "Key must not be null");
        Objects.requireNonNull(newValue, "Value must not be null");
        this.putMapPropertyEntry("responses", newKey, newValue);
        return this;
    }

    public void removeResponse(String key) {
        this.removeMapPropertyEntry("responses", key);
    }

    public Map<String, Parameter> getParameters() {
        return this.getMapProperty("parameters");
    }

    public void setParameters(Map<String, Parameter> newValue) {
        this.setMapProperty("parameters", newValue);
    }

    public Components addParameter(String newKey, Parameter newValue) {
        Objects.requireNonNull(newKey, "Key must not be null");
        Objects.requireNonNull(newValue, "Value must not be null");
        this.putMapPropertyEntry("parameters", newKey, newValue);
        return this;
    }

    public void removeParameter(String key) {
        this.removeMapPropertyEntry("parameters", key);
    }

    public Map<String, Example> getExamples() {
        return this.getMapProperty("examples");
    }

    public void setExamples(Map<String, Example> newValue) {
        this.setMapProperty("examples", newValue);
    }

    public Components addExample(String newKey, Example newValue) {
        Objects.requireNonNull(newKey, "Key must not be null");
        Objects.requireNonNull(newValue, "Value must not be null");
        this.putMapPropertyEntry("examples", newKey, newValue);
        return this;
    }

    public void removeExample(String key) {
        this.removeMapPropertyEntry("examples", key);
    }

    public Map<String, RequestBody> getRequestBodies() {
        return this.getMapProperty("requestBodies");
    }

    public void setRequestBodies(Map<String, RequestBody> newValue) {
        this.setMapProperty("requestBodies", newValue);
    }

    public Components addRequestBody(String newKey, RequestBody newValue) {
        Objects.requireNonNull(newKey, "Key must not be null");
        Objects.requireNonNull(newValue, "Value must not be null");
        this.putMapPropertyEntry("requestBodies", newKey, newValue);
        return this;
    }

    public void removeRequestBody(String key) {
        this.removeMapPropertyEntry("requestBodies", key);
    }

    public Map<String, Header> getHeaders() {
        return this.getMapProperty("headers");
    }

    public void setHeaders(Map<String, Header> newValue) {
        this.setMapProperty("headers", newValue);
    }

    public Components addHeader(String newKey, Header newValue) {
        Objects.requireNonNull(newKey, "Key must not be null");
        Objects.requireNonNull(newValue, "Value must not be null");
        this.putMapPropertyEntry("headers", newKey, newValue);
        return this;
    }

    public void removeHeader(String key) {
        this.removeMapPropertyEntry("headers", key);
    }

    public Map<String, SecurityScheme> getSecuritySchemes() {
        return this.getMapProperty("securitySchemes");
    }

    public void setSecuritySchemes(Map<String, SecurityScheme> newValue) {
        this.setMapProperty("securitySchemes", newValue);
    }

    public Components addSecurityScheme(String newKey, SecurityScheme newValue) {
        Objects.requireNonNull(newKey, "Key must not be null");
        Objects.requireNonNull(newValue, "Value must not be null");
        this.putMapPropertyEntry("securitySchemes", newKey, newValue);
        return this;
    }

    public void removeSecurityScheme(String key) {
        this.removeMapPropertyEntry("securitySchemes", key);
    }

    public Map<String, Link> getLinks() {
        return this.getMapProperty("links");
    }

    public void setLinks(Map<String, Link> newValue) {
        this.setMapProperty("links", newValue);
    }

    public Components addLink(String newKey, Link newValue) {
        Objects.requireNonNull(newKey, "Key must not be null");
        Objects.requireNonNull(newValue, "Value must not be null");
        this.putMapPropertyEntry("links", newKey, newValue);
        return this;
    }

    public void removeLink(String key) {
        this.removeMapPropertyEntry("links", key);
    }

    public Map<String, Callback> getCallbacks() {
        return this.getMapProperty("callbacks");
    }

    public void setCallbacks(Map<String, Callback> newValue) {
        this.setMapProperty("callbacks", newValue);
    }

    public Components addCallback(String newKey, Callback newValue) {
        Objects.requireNonNull(newKey, "Key must not be null");
        Objects.requireNonNull(newValue, "Value must not be null");
        this.putMapPropertyEntry("callbacks", newKey, newValue);
        return this;
    }

    public void removeCallback(String key) {
        this.removeMapPropertyEntry("callbacks", key);
    }

    public Map<String, PathItem> getPathItems() {
        return this.getMapProperty("pathItems");
    }

    public void setPathItems(Map<String, PathItem> newValue) {
        this.setMapProperty("pathItems", newValue);
    }

    public Components addPathItem(String newKey, PathItem newValue) {
        Objects.requireNonNull(newKey, "Key must not be null");
        Objects.requireNonNull(newValue, "Value must not be null");
        this.putMapPropertyEntry("pathItems", newKey, newValue);
        return this;
    }

    public void removePathItem(String key) {
        this.removeMapPropertyEntry("pathItems", key);
    }

    public static class Properties
    implements PropertyMetadata {
        private final Map<String, DataType> types = new HashMap<String, DataType>(10);
        private final Map<String, OpenApiVersion> minVersions = new HashMap<String, OpenApiVersion>(10);

        public Properties() {
            this.types.put("schemas", DataType.mapOf((DataType)DataType.type(Schema.class)));
            this.minVersions.put("schemas", OpenApiVersion.V3_0);
            this.types.put("responses", DataType.mapOf((DataType)DataType.type(APIResponse.class)));
            this.minVersions.put("responses", OpenApiVersion.V3_0);
            this.types.put("parameters", DataType.mapOf((DataType)DataType.type(Parameter.class)));
            this.minVersions.put("parameters", OpenApiVersion.V3_0);
            this.types.put("examples", DataType.mapOf((DataType)DataType.type(Example.class)));
            this.minVersions.put("examples", OpenApiVersion.V3_0);
            this.types.put("requestBodies", DataType.mapOf((DataType)DataType.type(RequestBody.class)));
            this.minVersions.put("requestBodies", OpenApiVersion.V3_0);
            this.types.put("headers", DataType.mapOf((DataType)DataType.type(Header.class)));
            this.minVersions.put("headers", OpenApiVersion.V3_0);
            this.types.put("securitySchemes", DataType.mapOf((DataType)DataType.type(SecurityScheme.class)));
            this.minVersions.put("securitySchemes", OpenApiVersion.V3_0);
            this.types.put("links", DataType.mapOf((DataType)DataType.type(Link.class)));
            this.minVersions.put("links", OpenApiVersion.V3_0);
            this.types.put("callbacks", DataType.mapOf((DataType)DataType.type(Callback.class)));
            this.minVersions.put("callbacks", OpenApiVersion.V3_0);
            this.types.put("pathItems", DataType.mapOf((DataType)DataType.type(PathItem.class)));
            this.minVersions.put("pathItems", OpenApiVersion.V3_1);
        }

        public DataType getPropertyType(String name) {
            if (this.types.containsKey(name)) {
                return this.types.get(name);
            }
            return DataType.type(Object.class);
        }

        public OpenApiVersion getMinVersion(String name) {
            return this.minVersions.getOrDefault(name, OpenApiVersion.V3_0);
        }
    }
}

