/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.jdbc.oracle;

import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.stream.Collectors;
import javax.sql.XAConnection;
import oracle.jdbc.OracleConnection;
import oracle.jdbc.OracleShardingKey;
import oracle.jdbc.clio.annotations.Debug;
import oracle.jdbc.diagnostics.SecurityLabel;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.pool.OraclePooledConnection;
import oracle.ucp.ConnectionRetrievalInfo;
import oracle.ucp.UniversalConnectionPoolException;
import oracle.ucp.UniversalPooledConnection;
import oracle.ucp.UniversalPooledConnectionStatus;
import oracle.ucp.admin.UniversalConnectionPoolManagerBase;
import oracle.ucp.common.Clock;
import oracle.ucp.jdbc.JDBCConnectionPool;
import oracle.ucp.jdbc.JDBCConnectionRetrievalInfo;
import oracle.ucp.jdbc.JDBCUniversalPooledConnection;
import oracle.ucp.jdbc.oracle.FailoverablePooledConnection;
import oracle.ucp.jdbc.oracle.FailoverablePooledConnectionHelper;
import oracle.ucp.jdbc.oracle.OracleFailoverablePooledConnection;
import oracle.ucp.jdbc.oracle.OracleJDBCConnectionPool;
import oracle.ucp.jdbc.oracle.rlb.RLBInfo;
import oracle.ucp.util.UCPErrorHandler;

public class OracleUniversalPooledConnection
extends JDBCUniversalPooledConnection
implements OracleFailoverablePooledConnection,
FailoverablePooledConnection {
    static final String CLASS_NAME = OracleUniversalPooledConnection.class.getName();
    public static final int CANCELLATION_TIMEOUT = 15;
    private static final String DEFAULT_DRCP_VALUE = "NULL";
    private static final char DRCP_KEY_VALUE_SEPARATOR = '=';
    private static final char DRCP_MULTITAG_SEPARATOR = ';';
    private static final String AUTH_DB_TYPE_FLG = "AUTH_DB_SHRD_CLS";
    private static final int DB_SHARDING_ENABLED = 1;
    private static final int DB_DATA_AFFINITY_ENABLED = 2;
    private static final int DB_SHARD_CATALOG = 4;
    private static final short DB_VERSION_122 = 12200;
    private static final short DB_VERSION_18c = 18000;
    private String m_dataSourceInstanceName;
    private String m_dbUniqueName;
    private String m_hostName;
    private String m_serviceName;
    private int m_instanceId = -1;
    private JDBCConnectionPool m_cp = null;
    private boolean m_isNamedInstanceConn = false;
    private boolean isDRCPTagMatched = true;
    private Date m_instanceStartTime;
    private AtomicReference<RLBInfo.Frame> rlbBorrowStats = new AtomicReference<Object>(null);
    private AtomicReference<RLBInfo.Frame> rlbOpenStats = new AtomicReference<Object>(null);
    private boolean isPdbSessionInitialized = false;
    private OracleConnection.DRCPState initialDrcpState;

    public OracleUniversalPooledConnection(JDBCConnectionPool connectionPool, Object connection, ConnectionRetrievalInfo connectionRetrievalInfo, boolean connectionFailoverEnabled) throws UniversalConnectionPoolException {
        super(connectionPool, connection, connectionRetrievalInfo, connectionFailoverEnabled);
        this.trace(Level.FINEST, CLASS_NAME, "OracleUniversalPooledConnection", "connectionFailoverEnabled: {0}", null, null, connectionFailoverEnabled);
        this.m_cp = connectionPool;
        this.m_isNamedInstanceConn = false;
        try {
            Connection conn = this.getSQLConnection(connection);
            oracle.jdbc.OracleConnection oConn = (oracle.jdbc.OracleConnection)conn;
            this.initialDrcpState = oConn.getDRCPState();
        }
        catch (SQLException e) {
            this.trace(Level.FINEST, CLASS_NAME, "OracleUniversalPooledConnection", "", null, e, new Object[0]);
        }
    }

    private static OracleConnection.ConnectionValidation convertToEffort(UniversalPooledConnection.ValidationType validationType) {
        switch (validationType) {
            case NONE: {
                return OracleConnection.ConnectionValidation.NONE;
            }
            case LOCAL: {
                return OracleConnection.ConnectionValidation.LOCAL;
            }
            case INBAND_DOWN: {
                return OracleConnection.ConnectionValidation.INBAND_DOWN;
            }
            case SOCKET: {
                return OracleConnection.ConnectionValidation.SOCKET;
            }
            case NETWORK: {
                return OracleConnection.ConnectionValidation.NETWORK;
            }
            case SERVER: {
                return OracleConnection.ConnectionValidation.SERVER;
            }
            case COMPLETE: {
                return OracleConnection.ConnectionValidation.COMPLETE;
            }
        }
        throw new IllegalArgumentException("unknown validation type");
    }

    private static boolean isHardValidation(UniversalPooledConnection.ValidationType validationType) {
        return validationType == UniversalPooledConnection.ValidationType.NETWORK || validationType == UniversalPooledConnection.ValidationType.SERVER || validationType == UniversalPooledConnection.ValidationType.COMPLETE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @Debug(level=Debug.Level.FINEST)
    public void validate(UniversalPooledConnection.ValidationType validationType, int n) {
        try {
            void validationType2;
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.oracle.OracleUniversalPooledConnection", "validate", "entering args ({0}, {1})", null, null, new Object[]{validationType, n});
            boolean valid = true;
            try {
                OracleConnection oconn;
                Connection conn = this.getSQLConnection(this.getPhysicalConnection());
                if (null != conn && (valid = (oconn = conn.unwrap(OracleConnection.class)).isUsable(false))) {
                    void timeout;
                    String strSql = this.m_cp.getSQLForValidateConnection();
                    if (null == strSql || "".equals(strSql)) {
                        valid = null == validationType2 ? conn.isValid((int)timeout) : oconn.isValid(OracleUniversalPooledConnection.convertToEffort((UniversalPooledConnection.ValidationType)validationType2), (int)timeout);
                    } else {
                        this.trace(Level.FINEST, CLASS_NAME, "validate", "Using SQL command to validate", null, null, new Object[0]);
                        super.validate((UniversalPooledConnection.ValidationType)validationType2, (int)timeout);
                    }
                }
            }
            catch (Exception e) {
                valid = false;
            }
            finally {
                if (valid) {
                    if (OracleUniversalPooledConnection.isHardValidation((UniversalPooledConnection.ValidationType)validationType2)) {
                        this.setLastConnectionValidationTime(Clock.clock());
                    }
                    this.debug(Level.FINEST, CLASS_NAME, "validate", "connection is good", null, null, new Object[0]);
                } else {
                    this.setStatus(UniversalPooledConnectionStatus.STATUS_BAD, "connection is bad");
                    this.setLastConnectionValidationTime(0L);
                }
            }
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.oracle.OracleUniversalPooledConnection", "validate", "returning void", null, null, new Object[0]);
            return;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.oracle.OracleUniversalPooledConnection", "validate", "throwing", null, throwable, new Object[0]);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Debug(level=Debug.Level.FINEST)
    public boolean isValid(UniversalPooledConnection.ValidationType validationType, int n) {
        try {
            void timeout;
            void validationType2;
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.oracle.OracleUniversalPooledConnection", "isValid", "entering args ({0}, {1})", null, null, new Object[]{validationType, n});
            if (this.m_cp.getShardingMode()) {
                JDBCConnectionRetrievalInfo jdbcCri = (JDBCConnectionRetrievalInfo)this.getConnectionRetrievalInfo();
                OracleShardingKey key = jdbcCri.getShardingKey();
                OracleShardingKey superKey = jdbcCri.getSuperShardingKey();
                if (key != null && (validationType2 == UniversalPooledConnection.ValidationType.SERVER || validationType2 == UniversalPooledConnection.ValidationType.COMPLETE)) {
                    boolean bl = this.setShardingKeyIfValid(key, superKey, (int)timeout);
                    this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.oracle.OracleUniversalPooledConnection", "isValid", "returning {0}", null, null, bl);
                    return bl;
                }
            }
            boolean bl = super.isValid((UniversalPooledConnection.ValidationType)validationType2, (int)timeout);
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.oracle.OracleUniversalPooledConnection", "isValid", "returning {0}", null, null, bl);
            return bl;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.oracle.OracleUniversalPooledConnection", "isValid", "throwing", null, throwable, new Object[0]);
            throw throwable;
        }
    }

    @Override
    public long getLastNetworkAccessTime() {
        try {
            Connection conn = this.getSQLConnection(this.getPhysicalConnection());
            if (null != conn) {
                return FailoverablePooledConnectionHelper.getLastNetworkAccessTime(conn);
            }
        }
        catch (Exception e) {
            this.trace(Level.WARNING, CLASS_NAME, "getLastNetworkAccessTime", "", null, e, new Object[0]);
        }
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Debug(level=Debug.Level.FINEST)
    public boolean setShardingKeyIfValid(OracleShardingKey oracleShardingKey, OracleShardingKey oracleShardingKey2, int n) {
        try {
            boolean isValid;
            block13: {
                boolean bl;
                block12: {
                    this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.oracle.OracleUniversalPooledConnection", "setShardingKeyIfValid", "entering args ({0}, {1}, {2})", null, null, oracleShardingKey, oracleShardingKey2, n);
                    isValid = false;
                    try {
                        void timeout;
                        void superKey;
                        void key;
                        Connection conn = this.getSQLConnection(this.getPhysicalConnection());
                        if (!(conn instanceof oracle.jdbc.OracleConnection)) {
                            boolean bl2 = true;
                            bl = bl2;
                            break block12;
                        }
                        oracle.jdbc.OracleConnection oconn = (oracle.jdbc.OracleConnection)conn;
                        isValid = oconn.setShardingKeyIfValid((OracleShardingKey)key, (OracleShardingKey)superKey, (int)timeout);
                        break block13;
                    }
                    catch (SQLException e) {
                        isValid = false;
                        if (e.getCause() instanceof IOException || e.getCause() instanceof TimeoutException || e.getCause() instanceof InterruptedException) {
                            this.setStatus(UniversalPooledConnectionStatus.STATUS_BAD, "connection is bad");
                        }
                        break block13;
                    }
                }
                this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.oracle.OracleUniversalPooledConnection", "setShardingKeyIfValid", "returning {0}", null, null, bl);
                return bl;
                finally {
                    if (isValid) {
                        this.setLastConnectionValidationTime(Clock.clock());
                        this.trace(Level.FINEST, CLASS_NAME, "setShardingKeyIfValid", "connection is good", null, null, new Object[0]);
                    } else {
                        this.setStatus(UniversalPooledConnectionStatus.STATUS_BAD, "connection is bad");
                        this.setLastConnectionValidationTime(0L);
                    }
                }
            }
            boolean bl = isValid;
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.oracle.OracleUniversalPooledConnection", "setShardingKeyIfValid", "returning {0}", null, null, bl);
            return bl;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.oracle.OracleUniversalPooledConnection", "setShardingKeyIfValid", "throwing", null, throwable, new Object[0]);
            throw throwable;
        }
    }

    @Override
    @Debug(level=Debug.Level.FINEST)
    protected void initFailoverParameters() throws UniversalConnectionPoolException {
        try {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.oracle.OracleUniversalPooledConnection", "initFailoverParameters", "entering args ()", null, null, new Object[0]);
            Connection oracleConn = null;
            try {
                oracleConn = this.getSQLConnection(this.getPhysicalConnection());
            }
            catch (Exception e) {
                UCPErrorHandler.throwUniversalConnectionPoolException(301, e);
            }
            Properties prop = FailoverablePooledConnectionHelper.getSessionInfoOnOracleConnection(oracleConn);
            String val = prop.getProperty("INSTANCE_NAME");
            if (val != null) {
                this.setDataSourceInstanceName(val.trim().toLowerCase());
            }
            if ((val = prop.getProperty("SERVER_HOST")) != null) {
                this.setHostName(val.trim().toLowerCase());
            }
            if ((val = prop.getProperty("SERVICE_NAME")) != null) {
                this.setServiceName(val.trim().toLowerCase());
            }
            if ((val = prop.getProperty("DATABASE_NAME")) != null) {
                this.setDbUniqueName(val.trim().toLowerCase());
            }
            if ((val = prop.getProperty("AUTH_SC_INSTANCE_START_TIME")) != null) {
                this.setInstanceStartTime(FailoverablePooledConnectionHelper.getInstanceStartTime(val));
            }
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.oracle.OracleUniversalPooledConnection", "initFailoverParameters", "returning void", null, null, new Object[0]);
            return;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.oracle.OracleUniversalPooledConnection", "initFailoverParameters", "throwing", null, throwable, new Object[0]);
            throw throwable;
        }
    }

    @Override
    public int getInstanceNumber() {
        if (this.m_instanceId >= 0) {
            return this.m_instanceId;
        }
        try {
            Connection oconn = this.getSQLConnection(this.getPhysicalConnection());
            if (oconn != null) {
                this.m_instanceId = FailoverablePooledConnectionHelper.getInstanceNumber(oconn);
                return this.m_instanceId;
            }
        }
        catch (Exception exc) {
            this.trace(Level.WARNING, CLASS_NAME, "getInstanceNumber", "", null, exc, new Object[0]);
            Object oconn = null;
        }
        return -1;
    }

    @Debug(level=Debug.Level.FINEST)
    void updateInstanceNumber() {
        try {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.oracle.OracleUniversalPooledConnection", "updateInstanceNumber", "entering args ()", null, null, new Object[0]);
            try {
                Connection oconn = this.getSQLConnection(this.getPhysicalConnection());
                if (oconn != null) {
                    this.m_instanceId = FailoverablePooledConnectionHelper.getInstanceNumber(oconn);
                }
            }
            catch (Exception exc) {
                this.trace(Level.WARNING, CLASS_NAME, "updateInstanceNumber", "", null, exc, new Object[0]);
                this.m_instanceId = -1;
                Object oconn = null;
            }
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.oracle.OracleUniversalPooledConnection", "updateInstanceNumber", "returning void", null, null, new Object[0]);
            return;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.oracle.OracleUniversalPooledConnection", "updateInstanceNumber", "throwing", null, throwable, new Object[0]);
            throw throwable;
        }
    }

    @Override
    public String getDataSourceInstanceName() {
        return this.m_dataSourceInstanceName;
    }

    @Override
    public void setDataSourceInstanceName(String dataSourceInstanceName) {
        this.m_dataSourceInstanceName = dataSourceInstanceName;
    }

    @Override
    public String getDbUniqueName() {
        return this.m_dbUniqueName;
    }

    @Override
    public void setDbUniqueName(String dbUniqueName) {
        this.m_dbUniqueName = dbUniqueName;
    }

    @Override
    public String getHostName() {
        return this.m_hostName;
    }

    @Override
    public void setHostName(String hostName) {
        this.m_hostName = hostName;
    }

    @Override
    public String getServiceName() {
        return this.m_serviceName;
    }

    @Override
    public void setServiceName(String serviceName) {
        this.m_serviceName = serviceName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @Debug(level=Debug.Level.FINEST)
    public void setMaxStatements(int n) throws SQLException {
        try {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.oracle.OracleUniversalPooledConnection", "setMaxStatements", "entering args ({0})", null, null, n);
            this.lock.lock();
            try {
                void maxStatements;
                Connection oconn = null;
                try {
                    oconn = this.getSQLConnection(this.getPhysicalConnection());
                }
                catch (Exception exc) {
                    this.trace(Level.WARNING, CLASS_NAME, "setMaxStatements", "", null, exc, new Object[0]);
                    oconn = null;
                }
                if (this.getMaxStatements() != maxStatements) {
                    if (maxStatements > 0) {
                        FailoverablePooledConnectionHelper.enableStatementPooling(oconn, (int)maxStatements);
                    } else {
                        FailoverablePooledConnectionHelper.disableStatementPooling(oconn);
                    }
                }
                super.setMaxStatements((int)maxStatements);
            }
            finally {
                this.lock.unlock();
            }
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.oracle.OracleUniversalPooledConnection", "setMaxStatements", "returning void", null, null, new Object[0]);
            return;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.oracle.OracleUniversalPooledConnection", "setMaxStatements", "throwing", null, throwable, new Object[0]);
            throw throwable;
        }
    }

    @Override
    @Debug(level=Debug.Level.FINEST)
    public void abort() {
        try {
            Connection oconn;
            block6: {
                this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.oracle.OracleUniversalPooledConnection", "abort", "entering args ()", null, null, new Object[0]);
                oconn = this.getSQLConnection(this.getPhysicalConnection());
                if (oconn != null) break block6;
                this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.oracle.OracleUniversalPooledConnection", "abort", "returning void", null, null, new Object[0]);
                return;
            }
            try {
                this.trace(Level.FINEST, CLASS_NAME, "abort", "aborting connection: {0}", null, null, oconn);
                if (!UniversalPooledConnectionStatus.STATUS_RECONNECTING.equals(this.getStatus())) {
                    this.setStatus(UniversalPooledConnectionStatus.STATUS_BAD);
                }
                oconn.abort(UniversalConnectionPoolManagerBase.getShrinkingExecutor());
                this.trace(Level.FINEST, CLASS_NAME, "abort", "successfilly aborted", null, null, new Object[0]);
            }
            catch (Exception e) {
                this.trace(Level.WARNING, CLASS_NAME, "abort", "failed", null, e, new Object[0]);
            }
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.oracle.OracleUniversalPooledConnection", "abort", "returning void", null, null, new Object[0]);
            return;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.oracle.OracleUniversalPooledConnection", "abort", "throwing", null, throwable, new Object[0]);
            throw throwable;
        }
    }

    @Override
    @Debug(level=Debug.Level.FINEST)
    public void handleTimeout() {
        try {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.oracle.OracleUniversalPooledConnection", "handleTimeout", "entering args ()", null, null, new Object[0]);
            try {
                this.validitySemaphore.acquire();
                this.handleTimeoutHelper();
            }
            catch (InterruptedException interruptedException) {
            }
            finally {
                this.validitySemaphore.release();
            }
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.oracle.OracleUniversalPooledConnection", "handleTimeout", "returning void", null, null, new Object[0]);
            return;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.oracle.OracleUniversalPooledConnection", "handleTimeout", "throwing", null, throwable, new Object[0]);
            throw throwable;
        }
    }

    private void handleTimeoutHelper() {
        Connection oconn;
        Object physConn;
        block7: {
            Executor shrinkingExecutor = UniversalConnectionPoolManagerBase.getShrinkingExecutor();
            physConn = Objects.requireNonNull(this.getPhysicalConnection());
            oconn = null;
            try {
                oconn = this.getSQLConnection(physConn);
                if (null == oconn) {
                    return;
                }
                oconn.setNetworkTimeout(shrinkingExecutor, 15000);
                this.trace(Level.FINEST, CLASS_NAME, "handleTimeoutHelper", "conn set network timeout successfully", null, null, new Object[0]);
                FailoverablePooledConnectionHelper.cancelOnOracleConnection(oconn);
                this.trace(Level.FINEST, CLASS_NAME, "handleTimeoutHelper", "conn cancelled successfully", null, null, new Object[0]);
            }
            catch (SQLException e) {
                this.trace(Level.WARNING, CLASS_NAME, "handleTimeoutHelper", "failed", null, e, new Object[0]);
                if (null != oconn) break block7;
                return;
            }
        }
        if (this.getStatus() == UniversalPooledConnectionStatus.STATUS_NORMAL && !(physConn instanceof XAConnection)) {
            try {
                if (!oconn.getAutoCommit()) {
                    oconn.rollback();
                    this.trace(Level.FINEST, CLASS_NAME, "handleTimeoutHelper", "rolled back successfully", null, null, new Object[0]);
                }
            }
            catch (SQLException e) {
                this.trace(Level.WARNING, CLASS_NAME, "handleTimeoutHelper", "rollback failed", null, e, new Object[0]);
            }
        }
    }

    @Override
    public Connection getSQLConnection(Object physicalConnection) throws SQLException {
        return physicalConnection instanceof OraclePooledConnection ? ((OraclePooledConnection)physicalConnection).getPhysicalHandle() : super.getSQLConnection(physicalConnection);
    }

    @Override
    public boolean setAvailable() {
        boolean res;
        try {
            if (((OracleJDBCConnectionPool)this.m_cp).isDRCPEnabled(this) && this.initialDrcpState == OracleConnection.DRCPState.DETACHED) {
                this.detachServerConnection(null);
            }
        }
        catch (SQLException e) {
            this.trace(Level.WARNING, CLASS_NAME, "setAvailable", "", null, e, new Object[0]);
        }
        catch (UniversalConnectionPoolException e) {
            this.trace(Level.WARNING, CLASS_NAME, "setAvailable", "", null, e, new Object[0]);
        }
        finally {
            res = super.setAvailable();
        }
        return res;
    }

    /*
     * WARNING - void declaration
     */
    @Debug(level=Debug.Level.FINEST)
    public boolean attachServerConnection(Properties properties) throws SQLException {
        try {
            void requestedLabels;
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.oracle.OracleUniversalPooledConnection", "attachServerConnection", "entering args ({0})", null, null, properties);
            Connection oconn = null;
            try {
                oconn = this.getSQLConnection(this.getPhysicalConnection());
            }
            catch (Exception exc) {
                this.trace(Level.WARNING, CLASS_NAME, "attachServerConnection", "", null, exc, new Object[0]);
            }
            boolean value = FailoverablePooledConnectionHelper.attachServerConnection(oconn);
            if (requestedLabels != null && requestedLabels.size() > 0) {
                try {
                    int cost = super.labelingCost((Properties)requestedLabels);
                    this.isDRCPTagMatched = value && cost == 0;
                }
                catch (Throwable e) {
                    this.trace(Level.WARNING, CLASS_NAME, "attachServerConnection", "got unchecked exception from user-defined connection labeling callback", null, e, new Object[0]);
                    try {
                        super.setStatus(UniversalPooledConnectionStatus.STATUS_BAD);
                        this.m_cp.returnConnection(this);
                    }
                    catch (UniversalConnectionPoolException ucpe) {
                        this.trace(Level.WARNING, CLASS_NAME, "attachServerConnection", "", null, ucpe, new Object[0]);
                    }
                    throw e;
                }
            }
            boolean bl = this.isDRCPTagMatched;
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.oracle.OracleUniversalPooledConnection", "attachServerConnection", "returning {0}", null, null, bl);
            return bl;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.oracle.OracleUniversalPooledConnection", "attachServerConnection", "throwing", null, throwable, new Object[0]);
            throw throwable;
        }
    }

    @Debug(level=Debug.Level.FINEST)
    public void detachServerConnection(String string) throws SQLException {
        try {
            String tag;
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.oracle.OracleUniversalPooledConnection", "detachServerConnection", "entering args ({0})", null, null, string);
            Connection oconn = null;
            try {
                oconn = this.getSQLConnection(this.getPhysicalConnection());
            }
            catch (Exception exc) {
                this.trace(Level.WARNING, CLASS_NAME, "detachServerConnection", "", null, exc, new Object[0]);
            }
            ConnectionRetrievalInfo cri = this.getConnectionRetrievalInfo();
            if (cri != null && cri.getLabels() != null) {
                try {
                    tag = ((OracleJDBCConnectionPool)this.m_cp).isDRCPMultiTagEnabled(this) ? this.getDRCPTag(cri.getLabels()) : cri.getLabels().toString();
                }
                catch (UniversalConnectionPoolException e) {
                    this.trace(Level.WARNING, CLASS_NAME, "detachServerConnection", "", null, e, new Object[0]);
                }
            }
            if (this.isDRCPEnabled() && ((OracleJDBCConnectionPool)this.m_cp).isShareable()) {
                tag = tag == null ? "serviceName=" + this.getDelegator().serviceName() : tag + ";serviceName=" + this.getDelegator().serviceName();
            }
            FailoverablePooledConnectionHelper.detachServerConnection(oconn, tag);
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.oracle.OracleUniversalPooledConnection", "detachServerConnection", "returning void", null, null, new Object[0]);
            return;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.oracle.OracleUniversalPooledConnection", "detachServerConnection", "throwing", null, throwable, new Object[0]);
            throw throwable;
        }
    }

    protected String getDRCPTag(Properties labelProperties) throws SQLException {
        Iterator<Map.Entry<Object, Object>> labelEntries = labelProperties.entrySet().iterator();
        StringBuilder drcpTagBuilder = new StringBuilder();
        while (labelEntries.hasNext()) {
            Map.Entry<Object, Object> labelEntry = labelEntries.next();
            String key = (String)labelEntry.getKey();
            String value = (String)labelEntry.getValue();
            if (value == null || value.trim().length() == 0) {
                value = DEFAULT_DRCP_VALUE;
            }
            this.validateDRCPKeyAndValue(key, value);
            drcpTagBuilder.append(key);
            drcpTagBuilder.append('=');
            drcpTagBuilder.append(value);
            if (!labelEntries.hasNext()) continue;
            drcpTagBuilder.append(';');
        }
        return drcpTagBuilder.toString();
    }

    /*
     * WARNING - void declaration
     */
    @Debug(level=Debug.Level.FINEST)
    protected void validateDRCPKeyAndValue(String string, String string2) throws SQLException {
        try {
            void value;
            void key;
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.oracle.OracleUniversalPooledConnection", "validateDRCPKeyAndValue", "entering args ({0}, {1})", null, null, string, string2);
            if (key.indexOf(61) != -1 || key.indexOf(59) != -1) {
                throw UCPErrorHandler.newSQLException(70, key);
            }
            if (value.indexOf(61) != -1 || value.indexOf(59) != -1) {
                throw UCPErrorHandler.newSQLException(71, value);
            }
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.oracle.OracleUniversalPooledConnection", "validateDRCPKeyAndValue", "returning void", null, null, new Object[0]);
            return;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.oracle.OracleUniversalPooledConnection", "validateDRCPKeyAndValue", "throwing", null, throwable, new Object[0]);
            throw throwable;
        }
    }

    public boolean isDRCPEnabled() throws SQLException {
        Connection oconn = null;
        try {
            oconn = this.getSQLConnection(this.getPhysicalConnection());
        }
        catch (Exception exc) {
            this.trace(Level.WARNING, CLASS_NAME, "isDRCPEnabled", "", null, exc, new Object[0]);
        }
        return FailoverablePooledConnectionHelper.isDRCPEnabled(oconn);
    }

    public boolean isDRCPMultitagEnabled() throws SQLException {
        Connection oconn = null;
        oconn = this.getSQLConnection(this.getPhysicalConnection());
        return FailoverablePooledConnectionHelper.isDRCPMultitagEnabled(oconn);
    }

    public String getDRCPReturnTag() throws UniversalConnectionPoolException {
        Connection oconn = null;
        try {
            oconn = this.getSQLConnection(this.getPhysicalConnection());
            return FailoverablePooledConnectionHelper.getDRCPReturnTag(oconn);
        }
        catch (Exception exc) {
            this.trace(Level.WARNING, CLASS_NAME, "getDRCPReturnTag", "", null, exc, new Object[0]);
            throw new UniversalConnectionPoolException(exc);
        }
    }

    public String getDRCPPLSQLCallbackName() throws UniversalConnectionPoolException {
        Connection oconn = null;
        try {
            oconn = this.getSQLConnection(this.getPhysicalConnection());
            return FailoverablePooledConnectionHelper.getDRCPPLSQLCallbackName(oconn);
        }
        catch (Exception exc) {
            this.trace(Level.WARNING, CLASS_NAME, "getDRCPPLSQLCallbackName", "", null, exc, new Object[0]);
            throw new UniversalConnectionPoolException(exc);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Debug(level=Debug.Level.FINEST)
    public Properties getUnmatchedConnectionLabels(Properties properties) throws UniversalConnectionPoolException {
        try {
            void requestedLabels;
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.oracle.OracleUniversalPooledConnection", "getUnmatchedConnectionLabels", "entering args ({0})", null, null, properties);
            if (this.getConnectionLabels() != null && ((OracleJDBCConnectionPool)this.m_cp).isDRCPEnabled(this)) {
                if (((OracleJDBCConnectionPool)this.m_cp).isDRCPMultiTagEnabled(this)) {
                    Properties properties2 = this.findUnmatchedTags((Properties)requestedLabels);
                    this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.oracle.OracleUniversalPooledConnection", "getUnmatchedConnectionLabels", "returning {0}", null, null, properties2);
                    return properties2;
                }
                Properties properties3 = this.isDRCPTagMatched ? null : requestedLabels;
                this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.oracle.OracleUniversalPooledConnection", "getUnmatchedConnectionLabels", "returning {0}", null, null, properties3);
                return properties3;
            }
            Properties properties4 = super.getUnmatchedConnectionLabels((Properties)requestedLabels);
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.oracle.OracleUniversalPooledConnection", "getUnmatchedConnectionLabels", "returning {0}", null, null, properties4);
            return properties4;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.oracle.OracleUniversalPooledConnection", "getUnmatchedConnectionLabels", "throwing", null, throwable, new Object[0]);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Debug(level=Debug.Level.FINEST)
    protected Properties findUnmatchedTags(Properties properties) throws UniversalConnectionPoolException {
        try {
            String drcpReturnTag;
            void requestedLabels;
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.oracle.OracleUniversalPooledConnection", "findUnmatchedTags", "entering args ({0})", null, null, properties);
            Properties unmatchedTags = new Properties();
            if (requestedLabels != null) {
                unmatchedTags.putAll((Map<?, ?>)requestedLabels);
            }
            if ((drcpReturnTag = this.getDRCPReturnTag()) != null && drcpReturnTag.trim().length() > 0) {
                StringTokenizer tokenizer = new StringTokenizer(drcpReturnTag, ";");
                while (tokenizer.hasMoreTokens()) {
                    String currentToken = tokenizer.nextToken();
                    int eqIndex = currentToken.indexOf(61);
                    if (eqIndex == -1) continue;
                    unmatchedTags.remove(currentToken.substring(0, eqIndex));
                }
            }
            if (unmatchedTags.isEmpty()) {
                Properties properties2 = null;
                this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.oracle.OracleUniversalPooledConnection", "findUnmatchedTags", "returning {0}", null, null, properties2);
                return properties2;
            }
            Properties properties3 = unmatchedTags;
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.oracle.OracleUniversalPooledConnection", "findUnmatchedTags", "returning {0}", null, null, properties3);
            return properties3;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.oracle.OracleUniversalPooledConnection", "findUnmatchedTags", "throwing", null, throwable, new Object[0]);
            throw throwable;
        }
    }

    @Override
    public int getDatabaseVersion() throws UniversalConnectionPoolException {
        int dbVersion = 0;
        try {
            Connection oconn = this.getSQLConnection(this.getPhysicalConnection());
            return FailoverablePooledConnectionHelper.getDatabaseVersion(oconn);
        }
        catch (Exception exc) {
            dbVersion = 0;
            this.trace(Level.WARNING, CLASS_NAME, "getDatabaseVersion", "", null, exc, new Object[0]);
            return dbVersion;
        }
    }

    @Override
    public boolean isNamedInstanceConnection() {
        return this.m_isNamedInstanceConn;
    }

    @Override
    public void setAsNamedInstanceConnection() {
        this.m_isNamedInstanceConn = true;
    }

    @Override
    public String getInstance() {
        return this.getDataSourceInstanceName();
    }

    @Override
    public String getService() {
        return this.getServiceName();
    }

    @Override
    public String getHost() {
        return this.getHostName();
    }

    @Override
    public String getDatabase() {
        return this.getDbUniqueName();
    }

    @Override
    public void close(boolean isConnectionBorrowed) throws UniversalConnectionPoolException {
        throw new IllegalStateException("obsolete");
    }

    @Override
    public Date getInstanceStartTime() {
        return this.m_instanceStartTime;
    }

    @Override
    public Properties getConnectionInfo() throws UniversalConnectionPoolException {
        Properties connInfo = null;
        try {
            Connection oconn = this.getSQLConnection(this.getPhysicalConnection());
            connInfo = FailoverablePooledConnectionHelper.getSessionInfoOnOracleConnection(oconn);
        }
        catch (Exception exc) {
            connInfo = null;
            this.trace(Level.WARNING, CLASS_NAME, "getConnectionInfo", "", null, exc, new Object[0]);
        }
        return connInfo;
    }

    void setInstanceStartTime(Date time) {
        this.m_instanceStartTime = time;
    }

    public RLBInfo.Frame getRlbBorrowStats() {
        return this.rlbBorrowStats.get();
    }

    public void setRlbBorrowStats(RLBInfo.Frame rlbStats) {
        this.rlbBorrowStats.set(rlbStats);
    }

    public boolean isMultitenantDatabase() {
        try {
            Properties connProps = this.getConnectionInfo();
            if (connProps != null && connProps.containsKey("AUTH_PDB_UID")) {
                return true;
            }
        }
        catch (UniversalConnectionPoolException e) {
            this.trace(Level.WARNING, CLASS_NAME, "isMultitenantDatabase", "", null, e, new Object[0]);
        }
        return false;
    }

    public boolean[] getShardingMode() {
        boolean[] shardingMode = new boolean[]{false, false, false};
        short dbver = 0;
        try {
            dbver = ((OracleConnection)this.getSQLConnection(this.getPhysicalConnection())).getVersionNumber();
        }
        catch (SQLException e) {
            this.trace(Level.WARNING, CLASS_NAME, "getShardingMode", "", null, e, new Object[0]);
        }
        if (dbver < 12200) {
            return shardingMode;
        }
        if (dbver < 18000) {
            return this.checkShardMetadataTables();
        }
        try (Statement stmt = this.getSQLConnection(this.getPhysicalConnection()).createStatement();
             ResultSet rs = stmt.executeQuery("select GSMADMIN_INTERNAL.GETSHARDINGMODE from dual");){
            if (rs.next()) {
                int shardMode = rs.getInt(1);
                shardingMode[0] = (shardMode & 1) != 0;
                shardingMode[1] = (shardMode & 4) != 0;
                shardingMode[2] = (shardMode & 2) != 0;
            }
        }
        catch (SQLException e) {
            this.trace(Level.WARNING, CLASS_NAME, "getShardingMode", "", null, e, new Object[0]);
            shardingMode = this.checkShardMetadataTables();
        }
        return shardingMode;
    }

    private boolean[] checkShardMetadataTables() {
        Throwable throwable;
        ResultSet rs2;
        Throwable throwable2;
        Statement stmt;
        boolean[] shardingMode = new boolean[]{false, false, false};
        try {
            stmt = this.getSQLConnection(this.getPhysicalConnection()).createStatement();
            throwable2 = null;
            try {
                rs2 = stmt.executeQuery("select * from LOCAL_CHUNK_TYPES");
                throwable = null;
                try {
                    if (rs2.next()) {
                        shardingMode[0] = true;
                    }
                }
                catch (Throwable throwable3) {
                    throwable = throwable3;
                    throw throwable3;
                }
                finally {
                    if (rs2 != null) {
                        if (throwable != null) {
                            try {
                                rs2.close();
                            }
                            catch (Throwable throwable4) {
                                throwable.addSuppressed(throwable4);
                            }
                        } else {
                            rs2.close();
                        }
                    }
                }
            }
            catch (Throwable rs2) {
                throwable2 = rs2;
                throw rs2;
            }
            finally {
                if (stmt != null) {
                    if (throwable2 != null) {
                        try {
                            stmt.close();
                        }
                        catch (Throwable rs2) {
                            throwable2.addSuppressed(rs2);
                        }
                    } else {
                        stmt.close();
                    }
                }
            }
        }
        catch (SQLException e) {
            this.trace(Level.WARNING, CLASS_NAME, "checkShardMetadataTables", "", null, e, new Object[0]);
            shardingMode[0] = false;
        }
        if (shardingMode[0]) {
            try {
                stmt = this.getSQLConnection(this.getPhysicalConnection()).createStatement();
                throwable2 = null;
                try {
                    rs2 = stmt.executeQuery("select * from gsmadmin_internal.cloud");
                    throwable = null;
                    try {
                        if (rs2.next()) {
                            shardingMode[0] = false;
                            shardingMode[1] = true;
                        }
                    }
                    catch (Throwable throwable5) {
                        throwable = throwable5;
                        throw throwable5;
                    }
                    finally {
                        if (rs2 != null) {
                            if (throwable != null) {
                                try {
                                    rs2.close();
                                }
                                catch (Throwable throwable6) {
                                    throwable.addSuppressed(throwable6);
                                }
                            } else {
                                rs2.close();
                            }
                        }
                    }
                }
                catch (Throwable throwable7) {
                    throwable2 = throwable7;
                    throw throwable7;
                }
                finally {
                    if (stmt != null) {
                        if (throwable2 != null) {
                            try {
                                stmt.close();
                            }
                            catch (Throwable throwable8) {
                                throwable2.addSuppressed(throwable8);
                            }
                        } else {
                            stmt.close();
                        }
                    }
                }
            }
            catch (SQLException e) {
                this.trace(Level.WARNING, CLASS_NAME, "checkShardMetadataTables", "", null, e, new Object[0]);
            }
        }
        return shardingMode;
    }

    @Override
    public Properties getDatabaseConnectionProperties() {
        Object physicalConnection = this.getPhysicalConnection();
        try {
            if (physicalConnection instanceof oracle.jdbc.OracleConnection) {
                return ((OracleConnection)physicalConnection).getServerSessionInfo();
            }
            if (physicalConnection instanceof OraclePooledConnection) {
                OracleConnection oracleConnection = (OracleConnection)((OraclePooledConnection)physicalConnection).getConnection();
                return oracleConnection.getServerSessionInfo();
            }
        }
        catch (SQLException e) {
            this.trace(Level.WARNING, CLASS_NAME, "getDatabaseConnectionProperties", "", null, e, new Object[0]);
        }
        return super.getDatabaseConnectionProperties();
    }

    public void setPdbSessionInitialized(boolean initialized) {
        this.isPdbSessionInitialized = initialized;
    }

    /*
     * WARNING - void declaration
     */
    @Debug(level=Debug.Level.FINEST)
    public void initPdbSession(ConnectionRetrievalInfo connectionRetrievalInfo) throws SQLException {
        try {
            void cri;
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.oracle.OracleUniversalPooledConnection", "initPdbSession", "entering args ({0})", null, null, connectionRetrievalInfo);
            if (this.isPdbSessionInitialized) {
                this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.oracle.OracleUniversalPooledConnection", "initPdbSession", "returning void", null, null, new Object[0]);
                return;
            }
            JDBCConnectionRetrievalInfo jdbcCri = (JDBCConnectionRetrievalInfo)cri;
            Properties roles = jdbcCri.getPdbRoles();
            if (roles == null || roles.isEmpty()) {
                this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.oracle.OracleUniversalPooledConnection", "initPdbSession", "returning void", null, null, new Object[0]);
                return;
            }
            String sqlOp = "set role " + roles.entrySet().stream().map(e -> {
                String name = (String)e.getKey();
                String pwd = (String)e.getValue();
                return name + ("".equals(pwd) ? "" : " identified by " + pwd);
            }).collect(Collectors.joining(", "));
            try (Statement stmt = this.getSQLConnection(this.getPhysicalConnection()).createStatement();){
                stmt.execute(sqlOp);
                this.isPdbSessionInitialized = true;
            }
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.oracle.OracleUniversalPooledConnection", "initPdbSession", "returning void", null, null, new Object[0]);
            return;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.jdbc.oracle.OracleUniversalPooledConnection", "initPdbSession", "throwing", null, throwable, new Object[0]);
            throw throwable;
        }
    }

    @Override
    public int labelingCost(Properties labels) {
        OracleJDBCConnectionPool ocp = (OracleJDBCConnectionPool)Objects.requireNonNull(this.m_cp);
        try {
            if (ocp.isDRCPMultiTagEnabled(this)) {
                Properties connLabels = this.getConnectionLabels();
                if (connLabels != null && labels != null && connLabels.equals(labels) || connLabels == null && labels == null) {
                    return 0;
                }
                return 0x7FFFFFFE;
            }
            return super.labelingCost(labels);
        }
        catch (UniversalConnectionPoolException e) {
            this.trace(Level.WARNING, CLASS_NAME, "labelingCost", "", null, e, new Object[0]);
            return Integer.MAX_VALUE;
        }
    }
}

