/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.calcite.utils;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlLibraryOperators;
import org.apache.calcite.util.Pair;
import org.opensearch.sql.ast.tree.Join;
import org.opensearch.sql.ast.tree.Lookup;
import org.opensearch.sql.calcite.CalcitePlanContext;

public interface JoinAndLookupUtils {
    public static JoinRelType translateJoinType(Join.JoinType joinType) {
        switch (joinType) {
            case LEFT: {
                return JoinRelType.LEFT;
            }
            case RIGHT: {
                return JoinRelType.RIGHT;
            }
            case FULL: {
                return JoinRelType.FULL;
            }
            case SEMI: {
                return JoinRelType.SEMI;
            }
            case ANTI: {
                return JoinRelType.ANTI;
            }
        }
        return JoinRelType.INNER;
    }

    public static Map<String, String> findDuplicatedFields(Lookup node, List<String> sourceFieldsNames, List<String> providedFieldNames) {
        return providedFieldNames.stream().map(k -> Pair.of((Object)node.getOutputAliasMap().getOrDefault(k, (String)k), (Object)k)).filter(pair -> sourceFieldsNames.contains(pair.getKey())).collect(Collectors.toMap(Pair::getKey, Pair::getValue));
    }

    public static void addProjectionIfNecessary(Lookup node, CalcitePlanContext context) {
        List mappingField = node.getMappingAliasMap().keySet().stream().toList();
        List outputField = node.getOutputAliasMap().keySet().stream().toList();
        if (!outputField.isEmpty()) {
            HashSet lookupMappingFields = new HashSet(outputField);
            lookupMappingFields.addAll(mappingField);
            if (lookupMappingFields.size() != context.relBuilder.fields().size()) {
                List<RexNode> projectList = lookupMappingFields.stream().map(fieldName -> context.relBuilder.field((String)fieldName)).toList();
                context.relBuilder.project(projectList);
            }
        }
    }

    public static void addJoinForLookUp(Lookup node, CalcitePlanContext context) {
        RexNode joinCondition = node.getMappingAliasMap().entrySet().stream().map(entry -> {
            RexNode lookupKey = JoinAndLookupUtils.analyzeFieldsForLookUp((String)entry.getKey(), false, context);
            RexNode sourceKey = JoinAndLookupUtils.analyzeFieldsForLookUp((String)entry.getValue(), true, context);
            return context.rexBuilder.equals(sourceKey, lookupKey);
        }).reduce(context.rexBuilder::and).orElse((RexNode)context.relBuilder.literal(true));
        context.relBuilder.join(JoinRelType.LEFT, joinCondition);
    }

    public static RexNode analyzeFieldsForLookUp(String fieldName, boolean isSourceTable, CalcitePlanContext context) {
        return context.relBuilder.field(2, isSourceTable ? 0 : 1, fieldName);
    }

    public static void renameToExpectedFields(List<String> expectedProvidedFieldNames, int sourceFieldsCountLeft, CalcitePlanContext context) {
        int dynamicFieldsCount;
        List oldFields = context.relBuilder.peek().getRowType().getFieldNames();
        boolean hasDynamicFields = oldFields.contains("_MAP");
        int n = dynamicFieldsCount = hasDynamicFields ? 1 : 0;
        if (!2.$assertionsDisabled && sourceFieldsCountLeft + expectedProvidedFieldNames.size() + dynamicFieldsCount != oldFields.size()) {
            throw new AssertionError((Object)"The source fields count left plus new provided fields count must equal to the output fields count of current plan(i.e project-join).");
        }
        ArrayList newFields = new ArrayList(oldFields.size());
        newFields.addAll(oldFields.subList(0, sourceFieldsCountLeft));
        newFields.addAll(expectedProvidedFieldNames);
        if (hasDynamicFields) {
            newFields.add("_MAP");
        }
        context.relBuilder.rename(newFields);
    }

    public static void mergeDynamicFieldsAsNeeded(CalcitePlanContext context, OverwriteMode overwriteMode) {
        List fieldNames = context.relBuilder.peek().getRowType().getFieldNames();
        ImmutableList fields = context.relBuilder.fields();
        ArrayList<RexNode> dynamicFieldMaps = new ArrayList<RexNode>();
        ArrayList<RexNode> result = new ArrayList<RexNode>();
        for (int i = 0; i < fieldNames.size(); ++i) {
            String fieldName = (String)fieldNames.get(i);
            RexNode field = (RexNode)fields.get(i);
            if (fieldName.startsWith("_MAP")) {
                dynamicFieldMaps.add(field);
                continue;
            }
            result.add(field);
        }
        if (dynamicFieldMaps.size() <= 1) {
            return;
        }
        if (dynamicFieldMaps.size() == 2) {
            RexNode concat = overwriteMode == OverwriteMode.RIGHT_WINS ? context.relBuilder.call((SqlOperator)SqlLibraryOperators.MAP_CONCAT, new RexNode[]{(RexNode)dynamicFieldMaps.getFirst(), (RexNode)dynamicFieldMaps.getLast()}) : context.relBuilder.call((SqlOperator)SqlLibraryOperators.MAP_CONCAT, new RexNode[]{(RexNode)dynamicFieldMaps.getLast(), (RexNode)dynamicFieldMaps.getFirst()});
            result.add(context.relBuilder.alias(concat, "_MAP"));
        } else if (dynamicFieldMaps.size() > 2) {
            throw new IllegalStateException("More than two _MAP exist while joining dynamic fields.");
        }
        context.relBuilder.project(result);
    }

    static {
        if (2.$assertionsDisabled) {
            // empty if block
        }
    }

    public static enum OverwriteMode {
        LEFT_WINS,
        RIGHT_WINS;

    }
}

