"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SPARK_TIMESTAMP_DATATYPE = exports.SPARK_STRING_DATATYPE = exports.SPARK_PARTITION_INFO = exports.SPARK_HIVE_TABLE_REGEX = exports.SKIPPING_INDEX_ACCELERATION_METHODS = exports.SECURITY_DASHBOARDS_LOGOUT_URL = exports.SANITIZE_QUERY_REGEX = exports.S3_DATA_SOURCE_GROUP_SPARK_DISPLAY_NAME = exports.S3_DATA_SOURCE_GROUP_DISPLAY_NAME = exports.QUERY_LANGUAGE = exports.OLLY_QUESTION_URL_PARAM_KEY = exports.OBS_S3_DATA_SOURCE = exports.OBS_DEFAULT_CLUSTER = exports.INDEX_URL_PARAM_KEY = exports.DEFAULT_DATA_SOURCE_TYPE_NAME = exports.DEFAULT_DATA_SOURCE_TYPE = exports.DEFAULT_DATA_SOURCE_OBSERVABILITY_DISPLAY_NAME = exports.DEFAULT_DATA_SOURCE_NAME = exports.DATA_SOURCE_TYPE_URL_PARAM_KEY = exports.DATA_SOURCE_TYPES = exports.DATA_SOURCE_NAME_URL_PARAM_KEY = exports.CATALOG_CACHE_VERSION = exports.ASYNC_POLLING_INTERVAL = exports.ACC_INDEX_TYPE_DOCUMENTATION_URL = exports.ACC_CHECKPOINT_DOCUMENTATION_URL = exports.ACCELERATION_TIME_INTERVAL = exports.ACCELERATION_S3_URL_REGEX = exports.ACCELERATION_REFRESH_TIME_INTERVAL = exports.ACCELERATION_INDEX_TYPES = exports.ACCELERATION_INDEX_NAME_REGEX = exports.ACCELERATION_INDEX_NAME_INFO = exports.ACCELERATION_DEFUALT_SKIPPING_INDEX_NAME = exports.ACCELERATION_AGGREGRATION_FUNCTIONS = exports.ACCELERATION_ADD_FIELDS_TEXT = void 0;
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

const DATA_SOURCE_NAME_URL_PARAM_KEY = exports.DATA_SOURCE_NAME_URL_PARAM_KEY = 'datasourceName';
const DATA_SOURCE_TYPE_URL_PARAM_KEY = exports.DATA_SOURCE_TYPE_URL_PARAM_KEY = 'datasourceType';
const OLLY_QUESTION_URL_PARAM_KEY = exports.OLLY_QUESTION_URL_PARAM_KEY = 'olly_q';
const INDEX_URL_PARAM_KEY = exports.INDEX_URL_PARAM_KEY = 'indexPattern';
const DEFAULT_DATA_SOURCE_TYPE = exports.DEFAULT_DATA_SOURCE_TYPE = 'DEFAULT_INDEX_PATTERNS';
const DEFAULT_DATA_SOURCE_NAME = exports.DEFAULT_DATA_SOURCE_NAME = 'Default cluster';
const DEFAULT_DATA_SOURCE_OBSERVABILITY_DISPLAY_NAME = exports.DEFAULT_DATA_SOURCE_OBSERVABILITY_DISPLAY_NAME = 'OpenSearch';
const DEFAULT_DATA_SOURCE_TYPE_NAME = exports.DEFAULT_DATA_SOURCE_TYPE_NAME = 'Default Group';
let QUERY_LANGUAGE = exports.QUERY_LANGUAGE = /*#__PURE__*/function (QUERY_LANGUAGE) {
  QUERY_LANGUAGE["PPL"] = "PPL";
  QUERY_LANGUAGE["SQL"] = "SQL";
  QUERY_LANGUAGE["DQL"] = "DQL";
  return QUERY_LANGUAGE;
}({});
let DATA_SOURCE_TYPES = exports.DATA_SOURCE_TYPES = /*#__PURE__*/function (DATA_SOURCE_TYPES) {
  DATA_SOURCE_TYPES["DEFAULT_CLUSTER_TYPE"] = "DEFAULT_INDEX_PATTERNS";
  DATA_SOURCE_TYPES["SPARK"] = "spark";
  DATA_SOURCE_TYPES["S3Glue"] = "s3glue";
  return DATA_SOURCE_TYPES;
}({});
const ASYNC_POLLING_INTERVAL = exports.ASYNC_POLLING_INTERVAL = 2000;
const CATALOG_CACHE_VERSION = exports.CATALOG_CACHE_VERSION = '1.0';
const ACCELERATION_DEFUALT_SKIPPING_INDEX_NAME = exports.ACCELERATION_DEFUALT_SKIPPING_INDEX_NAME = 'skipping';
const ACCELERATION_TIME_INTERVAL = exports.ACCELERATION_TIME_INTERVAL = [{
  text: 'millisecond(s)',
  value: 'millisecond'
}, {
  text: 'second(s)',
  value: 'second'
}, {
  text: 'minutes(s)',
  value: 'minute'
}, {
  text: 'hour(s)',
  value: 'hour'
}, {
  text: 'day(s)',
  value: 'day'
}, {
  text: 'week(s)',
  value: 'week'
}];
const ACCELERATION_REFRESH_TIME_INTERVAL = exports.ACCELERATION_REFRESH_TIME_INTERVAL = [{
  text: 'minutes(s)',
  value: 'minute'
}, {
  text: 'hour(s)',
  value: 'hour'
}, {
  text: 'day(s)',
  value: 'day'
}, {
  text: 'week(s)',
  value: 'week'
}];
const ACCELERATION_ADD_FIELDS_TEXT = exports.ACCELERATION_ADD_FIELDS_TEXT = '(add fields here)';
const ACCELERATION_INDEX_NAME_REGEX = exports.ACCELERATION_INDEX_NAME_REGEX = /^[a-z0-9_]+$/;
const ACCELERATION_S3_URL_REGEX = exports.ACCELERATION_S3_URL_REGEX = /^(s3|s3a):\/\/[a-zA-Z0-9.\-]+/;
const SPARK_HIVE_TABLE_REGEX = exports.SPARK_HIVE_TABLE_REGEX = /Provider:\s*hive/;
const SANITIZE_QUERY_REGEX = exports.SANITIZE_QUERY_REGEX = /\s+/g;
const SPARK_TIMESTAMP_DATATYPE = exports.SPARK_TIMESTAMP_DATATYPE = 'timestamp';
const SPARK_STRING_DATATYPE = exports.SPARK_STRING_DATATYPE = 'string';
const ACCELERATION_INDEX_TYPES = exports.ACCELERATION_INDEX_TYPES = [{
  label: 'Skipping Index',
  value: 'skipping'
}, {
  label: 'Covering Index',
  value: 'covering'
}, {
  label: 'Materialized View',
  value: 'materialized'
}];
const ACC_INDEX_TYPE_DOCUMENTATION_URL = exports.ACC_INDEX_TYPE_DOCUMENTATION_URL = 'https://github.com/opensearch-project/opensearch-spark/blob/main/docs/index.md';
const ACC_CHECKPOINT_DOCUMENTATION_URL = exports.ACC_CHECKPOINT_DOCUMENTATION_URL = 'https://github.com/opensearch-project/opensearch-spark/blob/main/docs/index.md#create-index-options';
const ACCELERATION_INDEX_NAME_INFO = exports.ACCELERATION_INDEX_NAME_INFO = `All OpenSearch acceleration indices have a naming format of pattern: \`prefix_<index name>_suffix\`. They share a common prefix structure, which is \`flint_<data source name>_<database name>_<table name>_\`. Additionally, they may have a suffix that varies based on the index type. 
##### Skipping Index
- For 'Skipping' indices, a fixed index name 'skipping' is used, and this name cannot be modified by the user. The suffix added to this type is \`_index\`.
  - An example of a 'Skipping' index name would be: \`flint_mydatasource_mydb_mytable_skipping_index\`.
##### Covering Index
- 'Covering' indices allow users to specify their index name. The suffix added to this type is \`_index\`.
  - For instance, a 'Covering' index name could be: \`flint_mydatasource_mydb_mytable_myindexname_index\`.
##### Materialized View Index
- 'Materialized View' indices also enable users to define their index name, but they do not have a suffix.
  - An example of a 'Materialized View' index name might look like: \`flint_mydatasource_mydb_mytable_myindexname\`.
##### Note:
- All user given index names must be in lowercase letters, numbers and underscore. Spaces, commas, and characters -, :, ", *, +, /, \, |, ?, #, >, or < are not allowed.  
  `;
const SKIPPING_INDEX_ACCELERATION_METHODS = exports.SKIPPING_INDEX_ACCELERATION_METHODS = [{
  value: 'PARTITION',
  text: 'Partition'
}, {
  value: 'VALUE_SET',
  text: 'Value Set'
}, {
  value: 'MIN_MAX',
  text: 'Min Max'
}, {
  value: 'BLOOM_FILTER',
  text: 'Bloom Filter'
}];
const ACCELERATION_AGGREGRATION_FUNCTIONS = exports.ACCELERATION_AGGREGRATION_FUNCTIONS = [{
  label: 'window.start'
}, {
  label: 'count'
}, {
  label: 'sum'
}, {
  label: 'avg'
}, {
  label: 'max'
}, {
  label: 'min'
}];
const SPARK_PARTITION_INFO = exports.SPARK_PARTITION_INFO = `# Partition Information`;
const OBS_DEFAULT_CLUSTER = exports.OBS_DEFAULT_CLUSTER = 'observability-default'; // prefix key for generating data source id for default cluster in data selector
const OBS_S3_DATA_SOURCE = exports.OBS_S3_DATA_SOURCE = 'observability-s3'; // prefix key for generating data source id for s3 data sources in data selector
const S3_DATA_SOURCE_GROUP_DISPLAY_NAME = exports.S3_DATA_SOURCE_GROUP_DISPLAY_NAME = 'Amazon S3'; // display group name for Amazon-managed-s3 data sources in data selector
const S3_DATA_SOURCE_GROUP_SPARK_DISPLAY_NAME = exports.S3_DATA_SOURCE_GROUP_SPARK_DISPLAY_NAME = 'Spark'; // display group name for OpenSearch-spark-s3 data sources in data selector
const SECURITY_DASHBOARDS_LOGOUT_URL = exports.SECURITY_DASHBOARDS_LOGOUT_URL = '/logout';
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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