/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.indexmanagement.rollup.model;

import java.io.IOException;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.apache.commons.codec.digest.DigestUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.Version;
import org.opensearch.common.settings.Settings;
import org.opensearch.commons.authuser.User;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;
import org.opensearch.indexmanagement.common.model.dimension.DateHistogram;
import org.opensearch.indexmanagement.common.model.dimension.Dimension;
import org.opensearch.indexmanagement.common.model.dimension.Histogram;
import org.opensearch.indexmanagement.common.model.dimension.Terms;
import org.opensearch.indexmanagement.rollup.model.Rollup;
import org.opensearch.indexmanagement.rollup.model.RollupMetrics;
import org.opensearch.indexmanagement.rollup.model.metric.Metric;
import org.opensearch.jobscheduler.spi.schedule.IntervalSchedule;
import org.opensearch.jobscheduler.spi.schedule.Schedule;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0086\b\u0018\u0000 ;2\u00020\u00012\u00020\u0002:\u0001;BQ\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u0012\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\u000b\u0012\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0004\b\u0010\u0010\u0011B\u0011\b\u0016\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\u0004\b\u0010\u0010\u0014J\u0018\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020!2\u0006\u0010#\u001a\u00020$H\u0016J\u001a\u0010%\u001a\u00020&2\u0006\u0010\u000f\u001a\u00020\u00042\n\b\u0002\u0010'\u001a\u0004\u0018\u00010(J\b\u0010)\u001a\u00020\u0004H\u0016J\u0010\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020-H\u0016J\t\u0010.\u001a\u00020\u0004H\u00c6\u0003J\t\u0010/\u001a\u00020\u0004H\u00c6\u0003J\u000b\u00100\u001a\u0004\u0018\u00010\u0007H\u00c6\u0003J\t\u00101\u001a\u00020\tH\u00c6\u0003J\u000f\u00102\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u00c6\u0003J\u000f\u00103\u001a\b\u0012\u0004\u0012\u00020\u000e0\u000bH\u00c6\u0003J\u000b\u00104\u001a\u0004\u0018\u00010\u0004H\u00c6\u0003J_\u00105\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u00042\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00072\b\b\u0002\u0010\b\u001a\u00020\t2\u000e\b\u0002\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u000e\b\u0002\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\u000b2\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u0004H\u00c6\u0001J\u0013\u00106\u001a\u0002072\b\u00108\u001a\u0004\u0018\u000109H\u00d6\u0003J\t\u0010:\u001a\u00020\tH\u00d6\u0001R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0016R\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0017\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001dR\u0013\u0010\u000f\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u0016\u00a8\u0006<"}, d2={"Lorg/opensearch/indexmanagement/rollup/model/ISMRollup;", "Lorg/opensearch/core/xcontent/ToXContentObject;", "Lorg/opensearch/core/common/io/stream/Writeable;", "description", "", "targetIndex", "targetIndexSettings", "Lorg/opensearch/common/settings/Settings;", "pageSize", "", "dimensions", "", "Lorg/opensearch/indexmanagement/common/model/dimension/Dimension;", "metrics", "Lorg/opensearch/indexmanagement/rollup/model/RollupMetrics;", "sourceIndex", "<init>", "(Ljava/lang/String;Ljava/lang/String;Lorg/opensearch/common/settings/Settings;ILjava/util/List;Ljava/util/List;Ljava/lang/String;)V", "sin", "Lorg/opensearch/core/common/io/stream/StreamInput;", "(Lorg/opensearch/core/common/io/stream/StreamInput;)V", "getDescription", "()Ljava/lang/String;", "getTargetIndex", "getTargetIndexSettings", "()Lorg/opensearch/common/settings/Settings;", "getPageSize", "()I", "getDimensions", "()Ljava/util/List;", "getMetrics", "getSourceIndex", "toXContent", "Lorg/opensearch/core/xcontent/XContentBuilder;", "builder", "params", "Lorg/opensearch/core/xcontent/ToXContent$Params;", "toRollup", "Lorg/opensearch/indexmanagement/rollup/model/Rollup;", "user", "Lorg/opensearch/commons/authuser/User;", "toString", "writeTo", "", "out", "Lorg/opensearch/core/common/io/stream/StreamOutput;", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "copy", "equals", "", "other", "", "hashCode", "Companion", "opensearch-index-management"})
@SourceDebugExtension(value={"SMAP\nISMRollup.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ISMRollup.kt\norg/opensearch/indexmanagement/rollup/model/ISMRollup\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,262:1\n1#2:263\n774#3:264\n865#3,2:265\n1869#3,2:267\n1869#3:269\n1869#3,2:270\n1870#3:272\n*S KotlinDebug\n*F\n+ 1 ISMRollup.kt\norg/opensearch/indexmanagement/rollup/model/ISMRollup\n*L\n49#1:264\n49#1:265,2\n147#1:267,2\n151#1:269\n153#1:270,2\n151#1:272\n*E\n"})
public final class ISMRollup
implements ToXContentObject,
Writeable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String description;
    @NotNull
    private final String targetIndex;
    @Nullable
    private final Settings targetIndexSettings;
    private final int pageSize;
    @NotNull
    private final List<Dimension> dimensions;
    @NotNull
    private final List<RollupMetrics> metrics;
    @Nullable
    private final String sourceIndex;

    /*
     * WARNING - void declaration
     */
    public ISMRollup(@NotNull String description, @NotNull String targetIndex, @Nullable Settings targetIndexSettings, int pageSize, @NotNull List<? extends Dimension> dimensions, @NotNull List<RollupMetrics> metrics, @Nullable String sourceIndex) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)description, (String)"description");
        Intrinsics.checkNotNullParameter((Object)targetIndex, (String)"targetIndex");
        Intrinsics.checkNotNullParameter(dimensions, (String)"dimensions");
        Intrinsics.checkNotNullParameter(metrics, (String)"metrics");
        this.description = description;
        this.targetIndex = targetIndex;
        this.targetIndexSettings = targetIndexSettings;
        this.pageSize = pageSize;
        this.dimensions = dimensions;
        this.metrics = metrics;
        this.sourceIndex = sourceIndex;
        int n = this.pageSize;
        if (!(1 <= n ? n < 10001 : false)) {
            boolean $i$a$-require-ISMRollup$42 = false;
            String $i$a$-require-ISMRollup$42 = "Page size must be between 1 and 10000";
            throw new IllegalArgumentException($i$a$-require-ISMRollup$42.toString());
        }
        if (!(((CharSequence)this.description).length() > 0)) {
            boolean $i$a$-require-ISMRollup$72 = false;
            String $i$a$-require-ISMRollup$72 = "Description cannot be empty";
            throw new IllegalArgumentException($i$a$-require-ISMRollup$72.toString());
        }
        if (!(((CharSequence)this.targetIndex).length() > 0)) {
            boolean $i$a$-require-ISMRollup$82 = false;
            String $i$a$-require-ISMRollup$82 = "Target Index cannot be empty";
            throw new IllegalArgumentException($i$a$-require-ISMRollup$82.toString());
        }
        Iterable $this$filter$iv = this.dimensions;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Dimension it = (Dimension)element$iv$iv;
            boolean bl = false;
            if (!(it.getType() == Dimension.Type.DATE_HISTOGRAM)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        if (!(((List)destination$iv$iv).size() == 1)) {
            boolean $i$a$-require-ISMRollup$92 = false;
            String $i$a$-require-ISMRollup$92 = "Must specify precisely one date histogram dimension";
            throw new IllegalArgumentException($i$a$-require-ISMRollup$92.toString());
        }
        if (!(((Dimension)CollectionsKt.first(this.dimensions)).getType() == Dimension.Type.DATE_HISTOGRAM)) {
            boolean bl = false;
            String string = "The first dimension must be a date histogram";
            throw new IllegalArgumentException(string.toString());
        }
    }

    public /* synthetic */ ISMRollup(String string, String string2, Settings settings, int n, List list, List list2, String string3, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 0x40) != 0) {
            string3 = null;
        }
        this(string, string2, settings, n, list, list2, string3);
    }

    @NotNull
    public final String getDescription() {
        return this.description;
    }

    @NotNull
    public final String getTargetIndex() {
        return this.targetIndex;
    }

    @Nullable
    public final Settings getTargetIndexSettings() {
        return this.targetIndexSettings;
    }

    public final int getPageSize() {
        return this.pageSize;
    }

    @NotNull
    public final List<Dimension> getDimensions() {
        return this.dimensions;
    }

    @NotNull
    public final List<RollupMetrics> getMetrics() {
        return this.metrics;
    }

    @Nullable
    public final String getSourceIndex() {
        return this.sourceIndex;
    }

    @NotNull
    public XContentBuilder toXContent(@NotNull XContentBuilder builder, @NotNull ToXContent.Params params) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        builder.startObject().field("description", this.description).field("target_index", this.targetIndex).field("page_size", this.pageSize).field("dimensions", (Iterable)this.dimensions).field("metrics", (Iterable)this.metrics);
        if (this.sourceIndex != null) {
            builder.field("source_index", this.sourceIndex);
        }
        if (this.targetIndexSettings != null) {
            builder.startObject("target_index_settings");
            this.targetIndexSettings.toXContent(builder, params);
            builder.endObject();
        }
        builder.endObject();
        return builder;
    }

    @NotNull
    public final Rollup toRollup(@NotNull String sourceIndex, @Nullable User user) {
        Intrinsics.checkNotNullParameter((Object)sourceIndex, (String)"sourceIndex");
        String string = this.sourceIndex;
        if (string == null) {
            string = sourceIndex;
        }
        String resolvedSourceIndex = string;
        String id = resolvedSourceIndex + this;
        Instant currentTime = Instant.now();
        String string2 = DigestUtils.sha1Hex((String)id);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"sha1Hex(...)");
        Schedule schedule = (Schedule)new IntervalSchedule(Instant.now(), 1, ChronoUnit.MINUTES);
        Intrinsics.checkNotNull((Object)currentTime);
        return new Rollup(string2, -2L, 0L, true, 1L, schedule, currentTime, currentTime, this.description, resolvedSourceIndex, this.targetIndex, this.targetIndexSettings, null, null, this.pageSize, null, false, this.dimensions, this.metrics, user, 8192, null);
    }

    public static /* synthetic */ Rollup toRollup$default(ISMRollup iSMRollup, String string, User user, int n, Object object) {
        if ((n & 2) != 0) {
            user = null;
        }
        return iSMRollup.toRollup(string, user);
    }

    /*
     * WARNING - void declaration
     */
    public ISMRollup(@NotNull StreamInput sin) throws IOException {
        void it;
        Intrinsics.checkNotNullParameter((Object)sin, (String)"sin");
        String string = sin.readString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"readString(...)");
        String string2 = sin.readString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"readString(...)");
        StreamInput streamInput = sin;
        int n = sin.readInt();
        Settings settings = sin.getVersion().onOrAfter(Version.V_3_0_0) && sin.readBoolean() ? Settings.readSettingsFromStream((StreamInput)sin) : null;
        String string3 = string2;
        String string4 = string;
        ISMRollup iSMRollup = this;
        boolean bl = false;
        List dimensionsList = new ArrayList();
        int size = it.readVInt();
        for (int i = 0; i < size; ++i) {
            boolean bl2 = false;
            Dimension.Type type = (Dimension.Type)it.readEnum(Dimension.Type.class);
            List list = dimensionsList;
            Dimension.Type type2 = type;
            if (type2 == null) {
                List list2 = list;
                boolean bl3 = false;
                List list3 = list2;
                String string5 = "Dimension type cannot be null";
                throw new IllegalArgumentException(string5.toString());
            }
            list.add(switch (WhenMappings.$EnumSwitchMapping$0[type2.ordinal()]) {
                case 1 -> new DateHistogram(sin);
                case 2 -> new Terms(sin);
                case 3 -> new Histogram(sin);
                default -> throw new NoWhenBranchMatchedException();
            });
        }
        List list = CollectionsKt.toList((Iterable)dimensionsList);
        List list4 = sin.readList(RollupMetrics::new);
        Intrinsics.checkNotNullExpressionValue((Object)list4, (String)"readList(...)");
        iSMRollup(string4, string3, settings, n, list, list4, sin.getVersion().onOrAfter(Version.V_3_5_0) && sin.readBoolean() ? sin.readString() : null);
    }

    @NotNull
    public String toString() {
        Object it;
        StringBuffer sb = new StringBuffer();
        sb.append(this.targetIndex);
        sb.append(this.targetIndexSettings);
        sb.append(this.pageSize);
        Iterable $this$forEach$iv = this.dimensions;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (Dimension)element$iv;
            boolean bl = false;
            sb.append((Object)((Dimension)it).getType());
            sb.append(((Dimension)it).getSourceField());
        }
        $this$forEach$iv = this.metrics;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (RollupMetrics)element$iv;
            boolean bl = false;
            sb.append(((RollupMetrics)it).getSourceField());
            Iterable $this$forEach$iv2 = ((RollupMetrics)it).getMetrics();
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                Metric metric = (Metric)element$iv2;
                boolean bl2 = false;
                sb.append((Object)metric.getType());
            }
        }
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    public void writeTo(@NotNull StreamOutput out) {
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        out.writeString(this.description);
        out.writeString(this.targetIndex);
        if (out.getVersion().onOrAfter(Version.V_3_0_0)) {
            out.writeBoolean(this.targetIndexSettings != null);
            if (this.targetIndexSettings != null) {
                Settings.writeSettingsToStream((Settings)this.targetIndexSettings, (StreamOutput)out);
            }
        }
        out.writeInt(this.pageSize);
        out.writeVInt(this.dimensions.size());
        for (Dimension dimension : this.dimensions) {
            out.writeEnum((Enum)dimension.getType());
            Dimension dimension2 = dimension;
            if (dimension2 instanceof DateHistogram) {
                ((DateHistogram)dimension).writeTo(out);
                continue;
            }
            if (dimension2 instanceof Terms) {
                ((Terms)dimension).writeTo(out);
                continue;
            }
            if (!(dimension2 instanceof Histogram)) continue;
            ((Histogram)dimension).writeTo(out);
        }
        out.writeCollection((Collection)this.metrics);
        if (out.getVersion().onOrAfter(Version.V_3_5_0)) {
            out.writeBoolean(this.sourceIndex != null);
            if (this.sourceIndex != null) {
                out.writeString(this.sourceIndex);
            }
        }
    }

    @NotNull
    public final String component1() {
        return this.description;
    }

    @NotNull
    public final String component2() {
        return this.targetIndex;
    }

    @Nullable
    public final Settings component3() {
        return this.targetIndexSettings;
    }

    public final int component4() {
        return this.pageSize;
    }

    @NotNull
    public final List<Dimension> component5() {
        return this.dimensions;
    }

    @NotNull
    public final List<RollupMetrics> component6() {
        return this.metrics;
    }

    @Nullable
    public final String component7() {
        return this.sourceIndex;
    }

    @NotNull
    public final ISMRollup copy(@NotNull String description, @NotNull String targetIndex, @Nullable Settings targetIndexSettings, int pageSize, @NotNull List<? extends Dimension> dimensions, @NotNull List<RollupMetrics> metrics, @Nullable String sourceIndex) {
        Intrinsics.checkNotNullParameter((Object)description, (String)"description");
        Intrinsics.checkNotNullParameter((Object)targetIndex, (String)"targetIndex");
        Intrinsics.checkNotNullParameter(dimensions, (String)"dimensions");
        Intrinsics.checkNotNullParameter(metrics, (String)"metrics");
        return new ISMRollup(description, targetIndex, targetIndexSettings, pageSize, dimensions, metrics, sourceIndex);
    }

    public static /* synthetic */ ISMRollup copy$default(ISMRollup iSMRollup, String string, String string2, Settings settings, int n, List list, List list2, String string3, int n2, Object object) {
        if ((n2 & 1) != 0) {
            string = iSMRollup.description;
        }
        if ((n2 & 2) != 0) {
            string2 = iSMRollup.targetIndex;
        }
        if ((n2 & 4) != 0) {
            settings = iSMRollup.targetIndexSettings;
        }
        if ((n2 & 8) != 0) {
            n = iSMRollup.pageSize;
        }
        if ((n2 & 0x10) != 0) {
            list = iSMRollup.dimensions;
        }
        if ((n2 & 0x20) != 0) {
            list2 = iSMRollup.metrics;
        }
        if ((n2 & 0x40) != 0) {
            string3 = iSMRollup.sourceIndex;
        }
        return iSMRollup.copy(string, string2, settings, n, list, list2, string3);
    }

    public int hashCode() {
        int result2 = this.description.hashCode();
        result2 = result2 * 31 + this.targetIndex.hashCode();
        result2 = result2 * 31 + (this.targetIndexSettings == null ? 0 : this.targetIndexSettings.hashCode());
        result2 = result2 * 31 + Integer.hashCode(this.pageSize);
        result2 = result2 * 31 + ((Object)this.dimensions).hashCode();
        result2 = result2 * 31 + ((Object)this.metrics).hashCode();
        result2 = result2 * 31 + (this.sourceIndex == null ? 0 : this.sourceIndex.hashCode());
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ISMRollup)) {
            return false;
        }
        ISMRollup iSMRollup = (ISMRollup)other;
        if (!Intrinsics.areEqual((Object)this.description, (Object)iSMRollup.description)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.targetIndex, (Object)iSMRollup.targetIndex)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.targetIndexSettings, (Object)iSMRollup.targetIndexSettings)) {
            return false;
        }
        if (this.pageSize != iSMRollup.pageSize) {
            return false;
        }
        if (!Intrinsics.areEqual(this.dimensions, iSMRollup.dimensions)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.metrics, iSMRollup.metrics)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.sourceIndex, (Object)iSMRollup.sourceIndex);
    }

    @JvmStatic
    @NotNull
    public static final ISMRollup parse(@NotNull XContentParser xcp) throws IOException {
        return Companion.parse(xcp);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007\u00a8\u0006\b"}, d2={"Lorg/opensearch/indexmanagement/rollup/model/ISMRollup$Companion;", "", "<init>", "()V", "parse", "Lorg/opensearch/indexmanagement/rollup/model/ISMRollup;", "xcp", "Lorg/opensearch/core/xcontent/XContentParser;", "opensearch-index-management"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final ISMRollup parse(@NotNull XContentParser xcp) throws IOException {
            Intrinsics.checkNotNullParameter((Object)xcp, (String)"xcp");
            String description = "";
            String targetIndex = "";
            String sourceIndex = null;
            Settings targetIndexSettings = null;
            int pageSize = 0;
            List dimensions = new ArrayList();
            List metrics = new ArrayList();
            XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)xcp.currentToken(), (XContentParser)xcp);
            block18: while (xcp.nextToken() != XContentParser.Token.END_OBJECT) {
                String fieldName;
                block28: {
                    fieldName = xcp.currentName();
                    xcp.nextToken();
                    String string = fieldName;
                    if (string == null) break block28;
                    int n = -1;
                    switch (string.hashCode()) {
                        case -207303516: {
                            if (string.equals("target_index")) {
                                n = 1;
                            }
                            break;
                        }
                        case -1724546052: {
                            if (string.equals("description")) {
                                n = 2;
                            }
                            break;
                        }
                        case 1156913502: {
                            if (string.equals("target_index_settings")) {
                                n = 3;
                            }
                            break;
                        }
                        case 955826371: {
                            if (string.equals("metrics")) {
                                n = 4;
                            }
                            break;
                        }
                        case 1661088686: {
                            if (string.equals("source_index")) {
                                n = 5;
                            }
                            break;
                        }
                        case 883849137: {
                            if (string.equals("page_size")) {
                                n = 6;
                            }
                            break;
                        }
                        case 414334925: {
                            if (string.equals("dimensions")) {
                                n = 7;
                            }
                            break;
                        }
                    }
                    switch (n) {
                        case 2: {
                            Intrinsics.checkNotNullExpressionValue((Object)xcp.text(), (String)"text(...)");
                            continue block18;
                        }
                        case 1: {
                            Intrinsics.checkNotNullExpressionValue((Object)xcp.text(), (String)"text(...)");
                            continue block18;
                        }
                        case 5: {
                            sourceIndex = xcp.text();
                            continue block18;
                        }
                        case 3: {
                            XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)xcp.currentToken(), (XContentParser)xcp);
                            targetIndexSettings = Settings.fromXContent((XContentParser)xcp);
                            continue block18;
                        }
                        case 6: {
                            pageSize = xcp.intValue();
                            continue block18;
                        }
                        case 7: {
                            XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_ARRAY, (XContentParser.Token)xcp.currentToken(), (XContentParser)xcp);
                            while (xcp.nextToken() != XContentParser.Token.END_ARRAY) {
                                dimensions.add(Dimension.Companion.parse(xcp));
                            }
                            continue block18;
                        }
                        case 4: {
                            XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_ARRAY, (XContentParser.Token)xcp.currentToken(), (XContentParser)xcp);
                            while (xcp.nextToken() != XContentParser.Token.END_ARRAY) {
                                metrics.add(RollupMetrics.Companion.parse(xcp));
                            }
                            continue block18;
                        }
                    }
                }
                throw new IllegalArgumentException("Invalid field, [" + fieldName + "] not supported in ISM Rollup.");
            }
            return new ISMRollup(description, targetIndex, targetIndexSettings, pageSize, dimensions, metrics, sourceIndex);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Dimension.Type.values().length];
            try {
                nArray[Dimension.Type.DATE_HISTOGRAM.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Dimension.Type.TERMS.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Dimension.Type.HISTOGRAM.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

