/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.neuralsearch.sparse.algorithm.seismic;

import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.util.BytesRef;
import org.opensearch.neuralsearch.sparse.accessor.ClusteredPostingWriter;
import org.opensearch.neuralsearch.sparse.algorithm.seismic.SeismicPostingClusterer;
import org.opensearch.neuralsearch.sparse.data.DocWeight;
import org.opensearch.neuralsearch.sparse.data.DocumentCluster;
import org.opensearch.neuralsearch.sparse.data.PostingClusters;

public class ClusteringTask
implements Supplier<PostingClusters> {
    @Generated
    private static final Logger log = LogManager.getLogger(ClusteringTask.class);
    private final BytesRef term;
    private final List<DocWeight> docs;
    private final SeismicPostingClusterer seismicPostingClusterer;
    private final ClusteredPostingWriter writer;

    public ClusteringTask(BytesRef term, Collection<DocWeight> docs, ClusteredPostingWriter writer, SeismicPostingClusterer seismicPostingClusterer) {
        this.docs = docs.stream().toList();
        this.term = BytesRef.deepCopyOf((BytesRef)term);
        this.writer = writer;
        this.seismicPostingClusterer = seismicPostingClusterer;
    }

    @Override
    public PostingClusters get() {
        List<DocumentCluster> clusters;
        try {
            clusters = this.seismicPostingClusterer.cluster(this.docs);
        }
        catch (IOException e) {
            log.error("cluster failed", (Throwable)e);
            throw new RuntimeException(e);
        }
        this.writer.insert(this.term, clusters);
        return new PostingClusters(clusters);
    }
}

