/*
 * Decompiled with CFR 0.152.
 */
package com.azure.identity.implementation;

import com.azure.core.http.HttpResponse;
import com.azure.core.http.policy.RequestRetryCondition;
import com.azure.core.http.policy.RetryStrategy;
import java.io.IOException;
import java.time.Duration;
import java.util.function.Predicate;

public class ImdsRetryStrategy
implements RetryStrategy {
    private static final int MAX_RETRIES = 5;
    private final int maxRetries;
    private final Duration baseDelay;
    private final Predicate<RequestRetryCondition> shouldRetryCondition;

    public ImdsRetryStrategy() {
        this(5, Duration.ofMillis(800L));
    }

    public ImdsRetryStrategy(int maxRetries) {
        this(maxRetries, Duration.ofMillis(800L));
    }

    public ImdsRetryStrategy(int maxRetries, Duration baseDelay) {
        this.maxRetries = maxRetries;
        this.baseDelay = baseDelay;
        this.shouldRetryCondition = this::defaultShouldRetryCondition;
    }

    public int getMaxRetries() {
        return this.maxRetries;
    }

    public Duration calculateRetryDelay(int retryAttempts) {
        long delay = (long)((double)this.baseDelay.toMillis() * Math.pow(2.0, retryAttempts));
        return Duration.ofMillis(delay);
    }

    public boolean shouldRetryCondition(RequestRetryCondition requestRetryCondition) {
        return this.shouldRetryCondition.test(requestRetryCondition);
    }

    public boolean shouldRetry(HttpResponse httpResponse) {
        if (httpResponse != null) {
            int statusCode = httpResponse.getStatusCode();
            if (statusCode == 400) {
                return false;
            }
            if (statusCode == 403) {
                String headerValue = httpResponse.getHeaderValue("ResponseMessage");
                if (headerValue != null) {
                    return headerValue.contains("A socket operation was attempted to an unreachable");
                }
                return false;
            }
            if (statusCode == 410 || statusCode == 429 || statusCode == 404 || statusCode >= 500 && statusCode <= 599) {
                return true;
            }
        }
        return false;
    }

    public boolean shouldRetryException(Throwable throwable) {
        return throwable instanceof IOException;
    }

    private boolean defaultShouldRetryCondition(RequestRetryCondition condition) {
        HttpResponse response = condition.getResponse();
        Throwable throwable = condition.getThrowable();
        if (response != null) {
            return this.shouldRetry(response);
        }
        return this.shouldRetryException(throwable);
    }
}

