//
// PipeImpl_WIN32.h
//
// Library: Foundation
// Package: Processes
// Module:  PipeImpl
//
// Definition of the PipeImpl class for WIN32.
//
// Copyright (c) 2004-2006, Applied Informatics Software Engineering GmbH.
// and Contributors.
//
// SPDX-License-Identifier:	BSL-1.0
//


#ifndef Foundation_PipeImpl_WIN32_INCLUDED
#define Foundation_PipeImpl_WIN32_INCLUDED


#include "Poco/Foundation.h"
#include "Poco/RefCountedObject.h"
#include "Poco/IOLock.h"
#include "Poco/UnWindows.h"
#include <atomic>


namespace Poco {


class Foundation_API PipeImpl: public RefCountedObject
	/// A dummy implementation of PipeImpl for platforms
	/// that do not support pipes.
{
public:
	typedef HANDLE Handle;

	PipeImpl();
	~PipeImpl();
	int writeBytes(const void* buffer, int length);
	int readBytes(void* buffer, int length);
	Handle readHandle() const;
	Handle writeHandle() const;
	void closeRead();
	void closeWrite();

private:
	std::atomic<HANDLE> _readHandle{INVALID_HANDLE_VALUE};
	std::atomic<HANDLE> _writeHandle{INVALID_HANDLE_VALUE};
	IOLock _readLock;
	IOLock _writeLock;
};


} // namespace Poco


#endif // Foundation_PipeImpl_WIN32_INCLUDED
