\name{BinaryReconstructionByErosionImageFilter}
\alias{BinaryReconstructionByErosionImageFilter}
\title{BinaryReconstructionByErosionImageFilter}
\Rdversion{1.1}
\docType{class}
\description{
binary reconstruction by erosion of an image
BinaryReconstructionByErosionImageFilter}
\details{
Reconstruction by erosion operates on a "marker" image and a
"mask" image, and is defined as the erosion of the marker image with
respect to the mask image iterated until stability.
Geodesic morphology is described in Chapter 6.2 of Pierre Soille's
book "Morphological Image Analysis: Principles and Applications",
Second Edition, Springer, 2003.
Gaetan Lehmann. Biologie du Developpement et de la Reproduction, INRA
de Jouy-en-Josas, France.
 This implementation was taken from the Insight Journal paper: https://www.insight-journal.org/browse/publication/176
See:
MorphologyImageFilter , ReconstructionByErosionImageFilter , BinaryReconstructionByDilationImageFilter
BinaryReconstructionByErosion for the procedural interface
itk::BinaryReconstructionByErosionImageFilter for the Doxygen on the original ITK class.
BinaryReconstructionByErosionImageFilter}
%C++ includes: sitkBinaryReconstructionByErosionImageFilter.h
\section{Methods}{
\describe{
\item{ BinaryReconstructionByErosionImageFilter():}{
Default Constructor that takes no arguments and initializes default
parameters
}
\item{Image Execute(const Image &markerImage, const Image &maskImage):}{
Execute the filter on the input image
}
\item{Self FullyConnectedOff():}{}
\item{Self FullyConnectedOn():}{
Set the value of FullyConnected to true or false respectfully.
}
\item{double GetBackgroundValue() const:}{
Set/Get the value used as "background" in the output image. Defaults
to NumericTraits<PixelType>::NonpositiveMin() .
}
\item{double GetForegroundValue() const:}{
Set/Get the value used as "foreground" in the output image. Defaults
to NumericTraits<PixelType>::max() .
}
\item{bool GetFullyConnected() const:}{
Set/Get whether the connected components are defined strictly by face
connectivity or by face+edge+vertex connectivity. Default is
FullyConnectedOff. For objects that are 1 pixel wide, use
FullyConnectedOn.
}
\item{std::string GetName() const:}{
Name of this class
}
\item{Self SetBackgroundValue(double BackgroundValue):}{
Set/Get the value used as "background" in the output image. Defaults
to NumericTraits<PixelType>::NonpositiveMin() .
}
\item{Self SetForegroundValue(double ForegroundValue):}{
Set/Get the value used as "foreground" in the output image. Defaults
to NumericTraits<PixelType>::max() .
}
\item{Self SetFullyConnected(bool FullyConnected):}{
Set/Get whether the connected components are defined strictly by face
connectivity or by face+edge+vertex connectivity. Default is
FullyConnectedOff. For objects that are 1 pixel wide, use
FullyConnectedOn.
}
\item{std::string ToString() const:}{
Print ourselves out
}
\item{ ~BinaryReconstructionByErosionImageFilter():}{
Destructor
}
}
}
