/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.modules.cext;

import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.modules.cext.PythonCextBuiltins;
import com.oracle.graal.python.builtins.modules.cext.PythonCextMethodBuiltins;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.cext.capi.ExternalFunctionNodes;
import com.oracle.graal.python.builtins.objects.cext.capi.transitions.CApiTiming;
import com.oracle.graal.python.builtins.objects.cext.capi.transitions.CApiTransitions;
import com.oracle.graal.python.builtins.objects.cext.common.CExtCommonNodes;
import com.oracle.graal.python.builtins.objects.cext.structs.CFields;
import com.oracle.graal.python.builtins.objects.cext.structs.CStructAccess;
import com.oracle.graal.python.builtins.objects.module.PythonModule;
import com.oracle.graal.python.builtins.objects.object.ObjectBuiltins;
import com.oracle.graal.python.builtins.objects.str.StringBuiltins;
import com.oracle.graal.python.lib.PyUnicodeCheckNode;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.SpecialAttributeNames;
import com.oracle.graal.python.nodes.StringLiterals;
import com.oracle.graal.python.nodes.attributes.ReadAttributeFromObjectNode;
import com.oracle.graal.python.nodes.attributes.ReadAttributeFromPythonObjectNode;
import com.oracle.graal.python.nodes.attributes.WriteAttributeToObjectNode;
import com.oracle.graal.python.nodes.call.CallNode;
import com.oracle.graal.python.nodes.classes.IsSubtypeNode;
import com.oracle.graal.python.nodes.object.GetClassNode;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.TruffleString;

public final class PythonCextModuleBuiltins {
    static boolean isModuleSubtype(Node inliningTarget, Object obj, GetClassNode getClassNode, IsSubtypeNode isSubtypeNode) {
        return isSubtypeNode.execute(getClassNode.execute(inliningTarget, obj), (Object)PythonBuiltinClassType.PythonModule);
    }

    static abstract class GraalPyPrivate_Module_SetState
    extends PythonCextBuiltins.CApiBinaryBuiltinNode {
        GraalPyPrivate_Module_SetState() {
        }

        @Specialization
        static Object set(PythonModule object, Object value) {
            object.setNativeModuleState(value);
            return PNone.NO_VALUE;
        }
    }

    static abstract class GraalPyPrivate_Module_SetDef
    extends PythonCextBuiltins.CApiBinaryBuiltinNode {
        GraalPyPrivate_Module_SetDef() {
        }

        @Specialization
        static Object set(PythonModule object, Object value) {
            object.setNativeModuleDef(value);
            return PNone.NO_VALUE;
        }
    }

    static abstract class PyModule_GetFilenameObject
    extends PythonCextBuiltins.CApiUnaryBuiltinNode {
        PyModule_GetFilenameObject() {
        }

        @Specialization
        static Object getFilename(PythonModule module, @Bind Node inliningTarget, @Cached ReadAttributeFromObjectNode read, @Cached PyUnicodeCheckNode check, @Cached PRaiseNode raiseNode) {
            Object file = read.execute(module, SpecialAttributeNames.T___FILE__);
            if (file != PNone.NO_VALUE && check.execute(inliningTarget, file)) {
                return file;
            }
            throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.SystemError, ErrorMessages.MODULE_FILENAME_MISSING);
        }

        @Fallback
        static Object error(Object module, @Bind Node inliningTarget) {
            throw PRaiseNode.raiseStatic(inliningTarget, PythonBuiltinClassType.TypeError, ErrorMessages.BAD_ARG_TO_INTERNAL_FUNC);
        }
    }

    static abstract class GraalPyPrivate_Module_Traverse
    extends PythonCextBuiltins.CApiTernaryBuiltinNode {
        private static final String J__M_TRAVERSE = "m_traverse";
        private static final TruffleString T__M_TRAVERSE = PythonUtils.tsLiteral("m_traverse");
        private static final CApiTiming TIMING = CApiTiming.create(true, "m_traverse");

        GraalPyPrivate_Module_Traverse() {
        }

        @Specialization
        static int doGeneric(PythonModule self, Object visitFun, Object arg, @Bind Node inliningTarget, @Cached CStructAccess.ReadPointerNode readPointerNode, @Cached CStructAccess.ReadI64Node readI64Node, @CachedLibrary(limit="1") InteropLibrary lib, @Cached CExtCommonNodes.EnsureExecutableNode ensureExecutableNode, @Cached PythonContext.GetThreadStateNode getThreadStateNode, @Cached ExternalFunctionNodes.ExternalFunctionInvokeNode externalFunctionInvokeNode, @Cached ExternalFunctionNodes.CheckPrimitiveFunctionResultNode checkPrimitiveFunctionResultNode, @Cached CApiTransitions.PythonToNativeNode toNativeNode) {
            Object mTraverse;
            Object mdDef = self.getNativeModuleDef();
            if (mdDef != null && !lib.isNull(mTraverse = readPointerNode.read(mdDef, CFields.PyModuleDef__m_traverse))) {
                Object traverseExecutable;
                Object res;
                PythonContext.PythonThreadState threadState;
                int ires;
                long mSize = readI64Node.read(mdDef, CFields.PyModuleDef__m_size);
                Object mdState = self.getNativeModuleState();
                if ((mSize <= 0L || mdState != null && !lib.isNull(mdState)) && (ires = (int)checkPrimitiveFunctionResultNode.executeLong(threadState = getThreadStateNode.execute(inliningTarget), StringLiterals.T_VISIT, res = externalFunctionInvokeNode.call(null, inliningTarget, threadState, TIMING, T__M_TRAVERSE, traverseExecutable = ensureExecutableNode.execute(inliningTarget, mTraverse, ExternalFunctionNodes.PExternalFunctionWrapper.TRAVERSEPROC), toNativeNode.execute(self), visitFun, arg))) != 0) {
                    return ires;
                }
            }
            return 0;
        }
    }

    static abstract class GraalPyPrivate_Module_AddFunctionToModule
    extends PythonCextBuiltins.CApi7BuiltinNode {
        GraalPyPrivate_Module_AddFunctionToModule() {
        }

        @Specialization
        static Object moduleFunction(Object methodDefPtr, PythonModule mod, TruffleString name, Object cfunc, int flags, int wrapper, Object doc, @Bind Node inliningTarget, @Cached ObjectBuiltins.SetattrNode setattrNode, @Cached ReadAttributeFromPythonObjectNode readAttrNode, @Cached PythonCextMethodBuiltins.CFunctionNewExMethodNode cFunctionNewExMethodNode) {
            Object modName = readAttrNode.execute(mod, SpecialAttributeNames.T___NAME__, (Object)null);
            assert (modName != null) : "module name is missing!";
            Object func = cFunctionNewExMethodNode.execute(inliningTarget, methodDefPtr, name, cfunc, flags, wrapper, mod, modName, doc);
            setattrNode.executeSetAttr(null, mod, name, func);
            return 0;
        }
    }

    @ImportStatic(value={PythonCextModuleBuiltins.class})
    static abstract class PyModule_AddIntConstant
    extends PythonCextBuiltins.CApiTernaryBuiltinNode {
        PyModule_AddIntConstant() {
        }

        @Specialization(guards={"isModuleSubtype(inliningTarget, m, getClassNode, isSubtypeNode)"})
        static Object addObject(Object m, TruffleString k, long o, @Bind Node inliningTarget, @Cached.Shared @Cached GetClassNode getClassNode, @Cached.Shared @Cached IsSubtypeNode isSubtypeNode, @Cached WriteAttributeToObjectNode writeAtrrNode) {
            writeAtrrNode.execute(m, k, o);
            return 0;
        }

        @Specialization(guards={"!isModuleSubtype(inliningTarget, m, getClassNode, isSubtypeNode)"})
        static Object pop(Object m, Object key, Object defaultValue, @Cached.Shared @Cached GetClassNode getClassNode, @Cached.Shared @Cached IsSubtypeNode isSubtypeNode, @Bind Node inliningTarget) {
            throw PRaiseNode.raiseStatic(inliningTarget, PythonBuiltinClassType.TypeError, ErrorMessages.S_NEEDS_S_AS_FIRST_ARG, "PyModule_AddIntConstant", "module");
        }
    }

    @ImportStatic(value={PythonCextModuleBuiltins.class})
    static abstract class PyModule_AddObjectRef
    extends PythonCextBuiltins.CApiTernaryBuiltinNode {
        PyModule_AddObjectRef() {
        }

        @Specialization(guards={"isModuleSubtype(inliningTarget, m, getClassNode, isSubtypeNode)"})
        static Object addObject(Object m, TruffleString k, Object o, @Bind Node inliningTarget, @Cached.Shared @Cached GetClassNode getClassNode, @Cached.Shared @Cached IsSubtypeNode isSubtypeNode, @Cached WriteAttributeToObjectNode writeAtrrNode) {
            writeAtrrNode.execute(m, k, o);
            return 0;
        }

        @Specialization(guards={"!isModuleSubtype(inliningTarget, m, getClassNode, isSubtypeNode)"})
        static Object pop(Object m, Object key, Object defaultValue, @Cached.Shared @Cached GetClassNode getClassNode, @Cached.Shared @Cached IsSubtypeNode isSubtypeNode, @Bind Node inliningTarget) {
            throw PRaiseNode.raiseStatic(inliningTarget, PythonBuiltinClassType.TypeError, ErrorMessages.S_NEEDS_S_AS_FIRST_ARG, "PyModule_AddObjectRef", "module");
        }
    }

    static abstract class PyModule_GetNameObject
    extends PythonCextBuiltins.CApiUnaryBuiltinNode {
        PyModule_GetNameObject() {
        }

        @Specialization
        static Object getName(PythonModule module, @Bind Node inliningTarget, @Cached PythonCextBuiltins.PromoteBorrowedValue promoteBorrowedValue, @Cached PyUnicodeCheckNode pyUnicodeCheckNode, @Cached ReadAttributeFromObjectNode read, @Cached WriteAttributeToObjectNode write) {
            Object nameAttr = read.execute(module, SpecialAttributeNames.T___NAME__);
            if (!pyUnicodeCheckNode.execute(inliningTarget, nameAttr)) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw PRaiseNode.raiseStatic(inliningTarget, PythonBuiltinClassType.SystemError, ErrorMessages.NAMELESS_MODULE);
            }
            Object promotedName = promoteBorrowedValue.execute(inliningTarget, nameAttr);
            if (promotedName == null) {
                return nameAttr;
            }
            write.execute(module, SpecialAttributeNames.T___NAME__, promotedName);
            return promotedName;
        }
    }

    static abstract class GraalPyPrivate_Module_CreateInitialized_PyModule_New
    extends PythonCextBuiltins.CApiUnaryBuiltinNode {
        GraalPyPrivate_Module_CreateInitialized_PyModule_New() {
        }

        @Specialization
        Object run(TruffleString name, @Cached CallNode callNode, @Cached ObjectBuiltins.SetattrNode setattrNode, @Cached TruffleString.CodePointLengthNode codePointLengthNode, @Cached StringBuiltins.PrefixSuffixNode prefixSuffixNode, @Cached TruffleString.LastIndexOfCodePointNode lastIndexNode, @Cached TruffleString.SubstringNode substringNode) {
            TruffleString pyPackageContext;
            TruffleString newModuleName = name;
            PythonContext ctx = this.getContext();
            TruffleString truffleString = pyPackageContext = ctx.getPyPackageContext() == null ? null : ctx.getPyPackageContext();
            if (pyPackageContext != null && prefixSuffixNode.endsWith(pyPackageContext, newModuleName, 0, codePointLengthNode.execute((AbstractTruffleString)pyPackageContext, PythonUtils.TS_ENCODING))) {
                newModuleName = pyPackageContext;
                ctx.setPyPackageContext(null);
            }
            Object newModule = callNode.executeWithoutFrame((Object)PythonBuiltinClassType.PythonModule, newModuleName);
            int nameLength = codePointLengthNode.execute((AbstractTruffleString)newModuleName, PythonUtils.TS_ENCODING);
            int idx = lastIndexNode.execute((AbstractTruffleString)newModuleName, 46, nameLength, 0, PythonUtils.TS_ENCODING);
            if (idx > -1) {
                setattrNode.executeSetAttr(null, newModule, SpecialAttributeNames.T___PACKAGE__, substringNode.execute((AbstractTruffleString)newModuleName, 0, idx, PythonUtils.TS_ENCODING, false));
            }
            return newModule;
        }
    }

    static abstract class PyModule_NewObject
    extends PythonCextBuiltins.CApiUnaryBuiltinNode {
        PyModule_NewObject() {
        }

        @Specialization
        static Object run(TruffleString name, @Cached CallNode callNode) {
            return callNode.executeWithoutFrame((Object)PythonBuiltinClassType.PythonModule, name);
        }
    }

    static abstract class PyModule_SetDocString
    extends PythonCextBuiltins.CApiBinaryBuiltinNode {
        PyModule_SetDocString() {
        }

        @Specialization
        static int run(PythonModule module, Object doc, @Cached ObjectBuiltins.SetattrNode setattrNode) {
            setattrNode.executeSetAttr(null, module, SpecialAttributeNames.T___DOC__, doc);
            return 0;
        }
    }
}

