/*=========================================================================
*
*  Copyright NumFOCUS
*
*  Licensed under the Apache License, Version 2.0 (the "License");
*  you may not use this file except in compliance with the License.
*  You may obtain a copy of the License at
*
*         http://www.apache.org/licenses/LICENSE-2.0.txt
*
*  Unless required by applicable law or agreed to in writing, software
*  distributed under the License is distributed on an "AS IS" BASIS,
*  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
*  See the License for the specific language governing permissions and
*  limitations under the License.
*
*=========================================================================*/
#ifndef sitkComposeImageFilter_h
#define sitkComposeImageFilter_h

/*
 * WARNING: DO NOT EDIT THIS FILE!
 * THIS FILE IS AUTOMATICALLY GENERATED BY THE SIMPLEITK BUILD PROCESS.
 * Please look at sitkMultiInputImageFilterTemplate.h.in to make changes.
 */

#include <memory>

#include "sitkBasicFilters.h"
#include "sitkImageFilter.h"

namespace itk::simple {

   /**\class ComposeImageFilter

\brief ComposeImageFilter combine several scalar images into a multicomponent image.

ComposeImageFilter combine several scalar images into an itk::Image of vector pixel (itk::Vector , itk::RGBPixel , ...), of std::complex pixel, or in an itk::VectorImage .

\par Inputs and Usage
\code
filter->SetInput( 0, image0 );

filter->SetInput( 1, image1 );

...

filter->Update();

itk::VectorImage< PixelType, dimension >::Pointer = filter->GetOutput();

\endcode
 All input images are expected to have the same template parameters and have the same size and origin.


\see VectorImage 


\see VectorIndexSelectionCastImageFilter

\sa itk::simple::Compose for the procedural interface
   */
    class SITKBasicFilters_EXPORT ComposeImageFilter
      : public ImageFilter
    {
    public:
      using Self = ComposeImageFilter;

      /** Destructor */
      virtual ~ComposeImageFilter();


      /** Default Constructor that takes no arguments and initializes
       * default parameters */
      ComposeImageFilter();

      /** Define the pixels types supported by this filter */
      using PixelIDTypeList = BasicPixelIDTypeList;




      /** Name of this class */
      std::string GetName() const { return std::string ("ComposeImageFilter"); }

      /** Print ourselves out */
      std::string ToString() const;

      /** Execute the filter on the input images */
      Image Execute ( const std::vector<Image> &images);
      Image Execute ( const Image& image1 );
      Image Execute ( const Image& image1, const Image& image2 );
      Image Execute ( const Image& image1, const Image& image2, const Image& image3 );
      Image Execute ( const Image& image1, const Image& image2, const Image& image3, const Image& image4 );
      Image Execute ( const Image& image1, const Image& image2, const Image& image3, const Image& image4, const Image& image5 );




    private:

      /** Setup for member function dispatching */

      using MemberFunctionType = Image (Self::*)( const std::vector<Image> & );
      template <class TImageType> Image ExecuteInternal ( const std::vector<Image> &images );



      friend struct detail::MemberFunctionAddressor<MemberFunctionType>;

      std::unique_ptr<detail::MemberFunctionFactory<MemberFunctionType> > m_MemberFactory;



    };


    /**
     * \brief ComposeImageFilter combine several scalar images into a multicomponent image.
     *
     * This function directly calls the execute method of ComposeImageFilter
     * in order to support a procedural API
     *
     * \sa itk::simple::ComposeImageFilter for the object oriented interface
     * @{
     */
     SITKBasicFilters_EXPORT Image Compose ( const std::vector<Image> &images  );

     SITKBasicFilters_EXPORT Image Compose ( const Image& image1 );
     SITKBasicFilters_EXPORT Image Compose ( const Image& image1, const Image& image2 );
     SITKBasicFilters_EXPORT Image Compose ( const Image& image1, const Image& image2, const Image& image3 );
     SITKBasicFilters_EXPORT Image Compose ( const Image& image1, const Image& image2, const Image& image3, const Image& image4 );
     SITKBasicFilters_EXPORT Image Compose ( const Image& image1, const Image& image2, const Image& image3, const Image& image4, const Image& image5 );

     /** @{ */

}
#endif
