/*
 * Decompiled with CFR 0.152.
 */
package org.apache.naming.factory;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.RefAddr;
import javax.naming.spi.ObjectFactory;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.naming.LookupRef;
import org.apache.naming.StringManager;

public class LookupFactory
implements ObjectFactory {
    private static final Log log = LogFactory.getLog(LookupFactory.class);
    private static final StringManager sm = StringManager.getManager(LookupFactory.class);
    private static final ThreadLocal<Set<String>> names = ThreadLocal.withInitial(HashSet::new);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getObjectInstance(Object object, Name name, Context context, Hashtable<?, ?> hashtable) throws Exception {
        Object object2;
        block21: {
            String string = null;
            object2 = null;
            if (object instanceof LookupRef) {
                LookupRef lookupRef = (LookupRef)object;
                ObjectFactory objectFactory = null;
                RefAddr refAddr = lookupRef.get("lookup-name");
                if (refAddr != null) {
                    string = refAddr.getContent().toString();
                }
                try {
                    Serializable serializable;
                    Object object3;
                    Object object4;
                    if (string != null && !names.get().add(string)) {
                        String string2 = sm.getString("lookupFactory.circularReference", string);
                        NamingException namingException = new NamingException(string2);
                        log.warn((Object)string2, (Throwable)namingException);
                        throw namingException;
                    }
                    RefAddr refAddr2 = lookupRef.get("factory");
                    if (refAddr2 != null) {
                        object4 = refAddr2.getContent().toString();
                        object3 = Thread.currentThread().getContextClassLoader();
                        if (object3 != null) {
                            try {
                                serializable = ((ClassLoader)object3).loadClass((String)object4);
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                NamingException namingException = new NamingException(sm.getString("lookupFactory.loadFailed"));
                                namingException.initCause(classNotFoundException);
                                throw namingException;
                            }
                        }
                        try {
                            serializable = Class.forName((String)object4);
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            NamingException namingException = new NamingException(sm.getString("lookupFactory.loadFailed"));
                            namingException.initCause(classNotFoundException);
                            throw namingException;
                        }
                        if (serializable != null) {
                            try {
                                objectFactory = (ObjectFactory)serializable.getConstructor(new Class[0]).newInstance(new Object[0]);
                            }
                            catch (Throwable throwable) {
                                NamingException namingException = new NamingException(sm.getString("lookupFactory.createFailed"));
                                namingException.initCause(throwable);
                                throw namingException;
                            }
                        }
                    }
                    if (objectFactory != null) {
                        object2 = objectFactory.getObjectInstance(object, name, context, hashtable);
                    } else {
                        if (string == null) {
                            throw new NamingException(sm.getString("lookupFactory.createFailed"));
                        }
                        object2 = new InitialContext().lookup(string);
                    }
                    object4 = Class.forName(lookupRef.getClassName());
                    if (object2 == null || ((Class)object4).isAssignableFrom(object2.getClass())) break block21;
                    object3 = sm.getString("lookupFactory.typeMismatch", name, lookupRef.getClassName(), string, object2.getClass().getName());
                    serializable = new NamingException((String)object3);
                    log.warn(object3, serializable);
                    if (object2 instanceof AutoCloseable) {
                        try {
                            ((AutoCloseable)object2).close();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    throw serializable;
                }
                finally {
                    names.get().remove(string);
                }
            }
        }
        return object2;
    }
}

