
#include <string.h>
#include <stdint.h>

const char *
pnp_id_table(const char *key);

const char *
pnp_id_table(const char *key)
{
    size_t len = strlen(key);
    size_t i;
    uint32_t u = 0;

    if (len > 4)
        return NULL;

    for (i = 0; i < len; i++)
        u = (u << 8) | (uint8_t)key[i];

    switch (u) {
    case 4276545: return "Avolites Ltd";
    case 4276549: return "Anatek Electronics Inc.";
    case 4276557: return "Aava Mobile Oy";
    case 4276558: return "AAEON Technology Inc.";
    case 4276564: return "Ann Arbor Technologies";
    case 4276801: return "ABBAHOME INC.";
    case 4276803: return "AboCom System Inc.";
    case 4276804: return "Allen Bradley Company";
    case 4276805: return "Alcatel Bell";
    case 4276815: return "D\055Link Systems Inc";
    case 4276819: return "Abaco Systems, Inc.";
    case 4276820: return "Anchor Bay Technologies, Inc.";
    case 4276822: return "Advanced Research Technology";
    case 4277057: return "Ariel Corporation";
    case 4277058: return "Aculab Ltd";
    case 4277059: return "Accton Technology Corporation";
    case 4277060: return "AWETA BV";
    case 4277061: return "Actek Engineering Pty Ltd";
    case 4277063: return "A\046R Cambridge Ltd.";
    case 4277064: return "Archtek Telecom Corporation";
    case 4277065: return "Ancor Communications Inc";
    case 4277067: return "Acksys";
    case 4277068: return "Apricot Computers";
    case 4277069: return "Acroloop Motion Control Systems Inc";
    case 4277071: return "Allion Computer Inc.";
    case 4277072: return "Aspen Tech Inc";
    case 4277074: return "Acer Technologies";
    case 4277075: return "Altos Computer Systems";
    case 4277076: return "Applied Creative Technology";
    case 4277077: return "Acculogic";
    case 4277078: return "ActivCard S.A";
    case 4277313: return "Addi\055Data GmbH";
    case 4277314: return "Aldebbaron";
    case 4277315: return "Acnhor Datacomm";
    case 4277316: return "Advanced Peripheral Devices Inc";
    case 4277317: return "Arithmos, Inc.";
    case 4277319: return "Airdrop Gaming LLC";
    case 4277320: return "Aerodata Holdings Ltd";
    case 4277321: return "ADI Systems Inc";
    case 4277323: return "Adtek System Science Company Ltd";
    case 4277324: return "ASTRA Security Products Ltd";
    case 4277325: return "Ad Lib MultiMedia Inc";
    case 4277326: return "Analog \046 Digital Devices Tel. Inc";
    case 4277328: return "Adaptec Inc";
    case 4277330: return "Nasa Ames Research Center";
    case 4277331: return "Analog Devices Inc";
    case 4277332: return "Adtek";
    case 4277334: return "Advanced Micro Devices Inc";
    case 4277336: return "Adax Inc";
    case 4277338: return "ADDER TECHNOLOGY LTD";
    case 4277571: return "Antex Electronics Corporation";
    case 4277572: return "Advanced Electronic Designs, Inc.";
    case 4277577: return "Actiontec Electric Inc";
    case 4277578: return "Alpha Electronics Company";
    case 4277581: return "ASEM S.p.A.";
    case 4277582: return "Avencall";
    case 4277584: return "Aetas Peripheral International";
    case 4277588: return "Aethra Telecomunicazioni S.r.l.";
    case 4277825: return "Alfa Inc";
    case 4278083: return "Beijing Aerospace Golden Card Electronic Engineering Co.,Ltd.";
    case 4278089: return "Artish Graphics Inc";
    case 4278092: return "Argolis";
    case 4278093: return "Advan Int\047l Corporation";
    case 4278095: return "AlgolTek, Inc.";
    case 4278100: return "Agilent Technologies";
    case 4278339: return "Advantech Co., Ltd.";
    case 4278353: return "Astro HQ LLC";
    case 4278355: return "Beijing AnHeng SecoTech Information Technology Co., Ltd.";
    case 4278595: return "Arnos Insturments \046 Computer Systems";
    case 4278597: return "Altmann Industrieelektronik";
    case 4278601: return "Amptron International Inc.";
    case 4278603: return "Dongguan Alllike Electronics Co., Ltd.";
    case 4278604: return "Altos India Ltd";
    case 4278605: return "AIMS Lab Inc";
    case 4278610: return "Advanced Integ. Research Inc";
    case 4278611: return "Alien Internet Services";
    case 4278615: return "Aiwa Company Ltd";
    case 4278616: return "ALTINEX, INC.";
    case 4278849: return "AJA Video Systems, Inc.";
    case 4279106: return "Akebia Ltd";
    case 4279109: return "AKAMI Electric Co.,Ltd";
    case 4279113: return "AKIA Corporation";
    case 4279116: return "AMiT Ltd";
    case 4279117: return "Asahi Kasei Microsystems Company Ltd";
    case 4279120: return "Atom Komplex Prylad";
    case 4279122: return "Anker Innovations Limited";
    case 4279129: return "Askey Computer Corporation";
    case 4279361: return "Alacron Inc";
    case 4279363: return "Altec Corporation";
    case 4279364: return "In4S Inc";
    case 4279365: return "Alenco BV";
    case 4279367: return "Realtek Semiconductor Corp.";
    case 4279368: return "AL Systems";
    case 4279369: return "Acer Labs";
    case 4279370: return "Altec Lansing";
    case 4279371: return "Acrolink Inc";
    case 4279372: return "Alliance Semiconductor Corporation";
    case 4279373: return "Acutec Ltd.";
    case 4279374: return "Alana Technologies";
    case 4279375: return "Algolith Inc.";
    case 4279376: return "ALPS ALPINE CO., LTD.";
    case 4279378: return "Advanced Logic";
    case 4279379: return "Avance Logic Inc";
    case 4279380: return "Altra";
    case 4279382: return "AlphaView LCD";
    case 4279384: return "ALEXON Co.,Ltd.";
    case 4279617: return "Asia Microelectronic Development Inc";
    case 4279618: return "Ambient Technologies, Inc.";
    case 4279619: return "Attachmate Corporation";
    case 4279620: return "Amdek Corporation";
    case 4279625: return "American Megatrends Inc";
    case 4279628: return "Anderson Multimedia Communications \050HK\051 Limited";
    case 4279630: return "Amimon LTD.";
    case 4279631: return "Amino Technologies PLC and Amino Communications Limited";
    case 4279632: return "AMP Inc";
    case 4279634: return "AmTRAN Technology Co., Ltd.";
    case 4279635: return "ARMSTEL, Inc.";
    case 4279636: return "AMT International Industry";
    case 4279640: return "AMX LLC";
    case 4279873: return "Anakron";
    case 4279875: return "Ancot";
    case 4279876: return "Adtran Inc";
    case 4279881: return "Anigma Inc";
    case 4279883: return "Anko Electronic Company Ltd";
    case 4279884: return "Analogix Semiconductor, Inc";
    case 4279887: return "Anorad Corporation";
    case 4279888: return "Andrew Network Production";
    case 4279890: return "ANR Ltd";
    case 4279891: return "Ansel Communication Company";
    case 4279892: return "Ace CAD Enterprise Company Ltd";
    case 4279894: return "Beijing ANTVR Technology Co., Ltd.";
    case 4279895: return "Analog Way SAS";
    case 4279896: return "Acer Netxus Inc";
    case 4280129: return "AOpen Inc.";
    case 4280133: return "Advanced Optics Electronics, Inc.";
    case 4280140: return "America OnLine";
    case 4280148: return "Alcatel";
    case 4280387: return "American Power Conversion";
    case 4280388: return "AppliAdata";
    case 4280389: return "ALPS ALPINE CO., LTD.";
    case 4280391: return "Horner Electric Inc";
    case 4280393: return "A Plus Info Corporation";
    case 4280396: return "Aplicom Oy";
    case 4280397: return "Applied Memory Tech";
    case 4280398: return "Appian Tech Inc";
    case 4280400: return "Apple Computer Inc";
    case 4280402: return "Aprilia s.p.a.";
    case 4280403: return "Autologic Inc";
    case 4280404: return "Audio Processing Technology  Ltd";
    case 4280406: return "A\053V Link";
    case 4280408: return "AP Designs Ltd";
    case 4280899: return "Alta Research Corporation";
    case 4280900: return "AREC Inc.";
    case 4280901: return "ICET S.p.A.";
    case 4280903: return "Argus Electronics Co., LTD";
    case 4280905: return "Argosy Research Inc";
    case 4280907: return "Ark Logic Inc";
    case 4280908: return "Arlotto Comnet Inc";
    case 4280909: return "Arima";
    case 4280911: return "Poso International B.V.";
    case 4280914: return "ARRIS Group, Inc.";
    case 4280915: return "Arescom Inc";
    case 4280916: return "Corion Industrial Corporation";
    case 4281155: return "Ascom Strategic Technology Unit";
    case 4281156: return "USC Information Sciences Institute";
    case 4281157: return "AseV Display Labs";
    case 4281160: return "Ashton Bentley Concepts";
    case 4281161: return "Ahead Systems";
    case 4281163: return "Ask A\057S";
    case 4281164: return "AccuScene Corporation Ltd";
    case 4281165: return "ASEM S.p.A.";
    case 4281166: return "Asante Tech Inc";
    case 4281168: return "ASP Microelectronics Ltd";
    case 4281172: return "AST Research Inc";
    case 4281173: return "Asuscom Network Inc";
    case 4281176: return "AudioScience";
    case 4281177: return "Rockwell Collins \057 Airshow Systems";
    case 4281409: return "Allied Telesyn International \050Asia\051 Pte Ltd";
    case 4281411: return "Ably\055Tech Corporation";
    case 4281412: return "Alpha Telecom Inc";
    case 4281413: return "Innovate Ltd";
    case 4281416: return "Athena Informatica S.R.L.";
    case 4281417: return "Allied Telesis KK";
    case 4281418: return "ArchiTek Corporation";
    case 4281419: return "Allied Telesyn Int\047l";
    case 4281420: return "Arcus Technology Ltd";
    case 4281421: return "ATM Ltd";
    case 4281422: return "Athena Smartcard Solutions Ltd.";
    case 4281423: return "ASTRO DESIGN, INC.";
    case 4281424: return "Alpha\055Top Corporation";
    case 4281428: return "AT\046T";
    case 4281429: return "Avocor Technologies USA, Inc";
    case 4281430: return "Office Depot, Inc.";
    case 4281432: return "Athenix Corporation";
    case 4281668: return "AudioControl";
    case 4281671: return "August Home, Inc.";
    case 4281673: return "ALPS ALPINE CO., LTD.";
    case 4281679: return "AU Optronics";
    case 4281682: return "Aureal Semiconductor";
    case 4281683: return "ASUSTek COMPUTER INC";
    case 4281684: return "Autotime Corporation";
    case 4281686: return "Auvidea GmbH";
    case 4281921: return "Avaya Communication";
    case 4281923: return "Auravision Corporation";
    case 4281924: return "Avid Electronics Corporation";
    case 4281925: return "Add Value Enterpises \050Asia\051 Pte Ltd";
    case 4281927: return "Avegant Corporation";
    case 4281929: return "Nippon Avionics Co.,Ltd";
    case 4281930: return "Atelier Vision Corporation";
    case 4281932: return "Avalue Technology Inc.";
    case 4281933: return "AVM GmbH";
    case 4281934: return "Advance Computer Corporation";
    case 4281935: return "Avocent Corporation";
    case 4281938: return "AVer Information Inc.";
    case 4281939: return "Avatron Software Inc.";
    case 4281940: return "Avtek \050Electronics\051 Pty Ltd";
    case 4281942: return "SBS Technologies \050Canada\051, Inc. \050was Avvida Systems, Inc.\051";
    case 4281944: return "A\057Vaux Electronics";
    case 4282179: return "Access Works Comm Inc";
    case 4282188: return "Aironet Wireless Communications, Inc";
    case 4282195: return "Wave Systems";
    case 4282434: return "Adrienne Electronics Corporation";
    case 4282435: return "AXIOMTEK CO., LTD.";
    case 4282437: return "Axell Corporation";
    case 4282441: return "American Magnetics";
    case 4282444: return "Axel";
    case 4282447: return "Axonic Labs LLC";
    case 4282448: return "American Express";
    case 4282452: return "Axtend Technologies Inc";
    case 4282456: return "Axxon Computer Corporation";
    case 4282457: return "AXYZ Automation Services, Inc";
    case 4282692: return "Aydin Displays";
    case 4282706: return "Airlib, Inc";
    case 4282952: return "Shenzhen three Connaught Information Technology Co., Ltd. \0503nod Group\051";
    case 4282957: return "AZ Middelheim \055 Radiotherapy";
    case 4282964: return "Aztech Systems Ltd";
    case 4342083: return "Biometric Access Corporation";
    case 4342094: return "Banyan";
    case 4342338: return "an\055najah university";
    case 4342344: return "B\046Bh";
    case 4342348: return "Brain Boxes Limited";
    case 4342358: return "BlueBox Video Limited";
    case 4342360: return "Black Box Corporation";
    case 4342595: return "Beaver Computer Corporaton";
    case 4342596: return "Barco GmbH";
    case 4342601: return "Broadata Communications Inc.";
    case 4342603: return "Beck GmbH \046 Co. Elektronik Bauelemente KG";
    case 4342605: return "Broadcom";
    case 4342609: return "Deutsche Telekom Berkom GmbH";
    case 4342611: return "Booria CAD\057CAM systems";
    case 4342863: return "Brahler ICS";
    case 4342866: return "Blonder Tongue Labs, Inc.";
    case 4342867: return "Barco Display Systems";
    case 4343107: return "Beckhoff Automation";
    case 4343113: return "Beckworth Enterprises Inc";
    case 4343115: return "Beko Elektronik A.S.";
    case 4343116: return "Beltronic Industrieelektronik GmbH";
    case 4343119: return "Baug \046 Olufsen";
    case 4343365: return "B.F. Engineering Corporation";
    case 4343380: return "Barnfind Technologies";
    case 4343618: return "Barco Graphics N.V";
    case 4343636: return "Budzetron Inc";
    case 4343898: return "BitHeadz, Inc.";
    case 4344129: return "Biamp Systems Corporation";
    case 4344131: return "Big Island Communications";
    case 4344135: return "Bigscreen, Inc.";
    case 4344137: return "Boeckeler Instruments Inc";
    case 4344140: return "Billion Electric Company Ltd";
    case 4344143: return "BioLink Technologies International, Inc.";
    case 4344148: return "Bit 3 Computer";
    case 4344900: return "BILD INNOVATIVE TECHNOLOGY LLC";
    case 4344905: return "Busicom";
    case 4344910: return "BioLink Technologies";
    case 4344912: return "Bloomberg L.P.";
    case 4345156: return "Blackmagic Design";
    case 4345161: return "Benson Medical Instruments Company";
    case 4345164: return "BIOMED Lab";
    case 4345171: return "BIOMEDISYS";
    case 4345413: return "Bull AB";
    case 4345419: return "Banksia Tech Pty Ltd";
    case 4345423: return "Bang \046 Olufsen";
    case 4345427: return "Boulder Nonlinear Systems";
    case 4345666: return "Rainy Orchard";
    case 4345669: return "BOE";
    case 4345673: return "NINGBO BOIGLE DIGITAL TECHNOLOGY CO.,LTD";
    case 4345683: return "BOS";
    case 4345924: return "Micro Solutions, Inc.";
    case 4345939: return "Barco, N.V.";
    case 4345941: return "Best Power";
    case 4346433: return "Braemac Pty Ltd";
    case 4346435: return "BARC";
    case 4346439: return "Bridge Information Co., Ltd";
    case 4346441: return "Boca Research Inc";
    case 4346444: return "Brainlab AG";
    case 4346445: return "Braemar Inc";
    case 4346447: return "BROTHER INDUSTRIES,LTD.";
    case 4346693: return "Bose Corporation";
    case 4346695: return "Robert Bosch GmbH";
    case 4346700: return "Biomedical Systems Laboratory";
    case 4346702: return "BRIGHTSIGN, LLC";
    case 4346708: return "BodySound Technologies, Inc.";
    case 4346947: return "Bit 3 Computer";
    case 4346949: return "Brilliant Technology";
    case 4346950: return "Bitfield Oy";
    case 4346953: return "BusTech Inc";
    case 4346959: return "BioTao Ltd";
    case 4347206: return "Yasuhiko Shirai Melco Inc";
    case 4347207: return "B.U.G., Inc.";
    case 4347210: return "ATI Tech Inc";
    case 4347212: return "Bull";
    case 4347218: return "B\046R Industrial Automation GmbH";
    case 4347219: return "BusTek";
    case 4347220: return "21ST CENTURY ENTERTAINMENT";
    case 4347723: return "Bitworks Inc.";
    case 4347973: return "Buxco Electronics";
    case 4348228: return "byd\072sign corporation";
    case 4407617: return "Castles Automation Co., Ltd";
    case 4407619: return "CA \046 F Elettronica";
    case 4407623: return "CalComp";
    case 4407625: return "Canon Inc.";
    case 4407628: return "Acon";
    case 4407629: return "Cambridge Audio";
    case 4407630: return "Canopus Company Ltd";
    case 4407634: return "Cardinal Company Ltd";
    case 4407635: return "CASIO COMPUTER CO.,LTD";
    case 4407636: return "Consultancy in Advanced Technology";
    case 4407638: return "Cavium Networks, Inc";
    case 4407881: return "ComputerBoards Inc";
    case 4407890: return "Cebra Tech A\057S";
    case 4407892: return "Cabletime Ltd";
    case 4407896: return "Cybex Computer Products Corporation";
    case 4408131: return "C\055Cube Microsystems";
    case 4408137: return "Cache";
    case 4408138: return "CONTEC CO.,LTD.";
    case 4408140: return "CCL\057ITRI";
    case 4408144: return "Capetronic USA Inc";
    case 4408387: return "Core Dynamics Corporation";
    case 4408388: return "Convergent Data Devices";
    case 4408389: return "Colin.de";
    case 4408391: return "Christie Digital Systems Inc";
    case 4408393: return "Concept Development Inc";
    case 4408395: return "Cray Communications";
    case 4408398: return "Codenoll Technical Corporation";
    case 4408400: return "CalComp";
    case 4408403: return "Computer Diagnostic Systems";
    case 4408404: return "IBM Corporation";
    case 4408406: return "Convergent Design Inc.";
    case 4408641: return "Consumer Electronics Association";
    case 4408643: return "Chicony Electronics Company Ltd";
    case 4408644: return "Cambridge Electronic Design Ltd";
    case 4408646: return "Cefar Digital Vision";
    case 4408649: return "Crestron Electronics, Inc.";
    case 4408653: return "MEC Electronics GmbH";
    case 4408654: return "Centurion Technologies P\057L";
    case 4408656: return "C\055DAC";
    case 4408658: return "Ceronix";
    case 4408660: return "TEC CORPORATION";
    case 4408903: return "Atlantis";
    case 4408914: return "Meta View, Inc.";
    case 4409153: return "Chunghwa Picture Tubes, LTD";
    case 4409171: return "Chyron Corp";
    case 4409172: return "congatec AG";
    case 4409409: return "Chase Research PLC";
    case 4409412: return "ChangHong Electric Co.,Ltd";
    case 4409413: return "Acer Inc";
    case 4409415: return "Sichuan Changhong Electric CO, LTD.";
    case 4409417: return "Chrontel Inc";
    case 4409420: return "Chloride\055R\046D";
    case 4409421: return "CHIC TECHNOLOGY CORP.";
    case 4409423: return "Sichuang Changhong Corporation";
    case 4409424: return "CH Products";
    case 4409426: return "christmann informationstechnik \053 medien GmbH \046 Co. KG";
    case 4409427: return "Agentur Chairos";
    case 4409428: return "Chunghwa Picture Tubes,LTD.";
    case 4409433: return "Cherry GmbH";
    case 4409667: return "Comm. Intelligence Corporation";
    case 4409668: return "Indicates an identity defined by CTS\057DID Standards other than EDID";
    case 4409669: return "Convergent Engineering, Inc.";
    case 4409673: return "Cromack Industries Inc";
    case 4409676: return "Citicom Infotech Private Limited";
    case 4409678: return "Citron GmbH";
    case 4409680: return "Ciprico Inc";
    case 4409682: return "Cirrus Logic Inc";
    case 4409683: return "Cisco Systems Inc";
    case 4409684: return "Citifax Limited";
    case 4410179: return "The Concept Keyboard Company Ltd";
    case 4410186: return "Carina System Co., Ltd.";
    case 4410433: return "Clarion Company Ltd";
    case 4410436: return "COMMAT L.t.d.";
    case 4410437: return "Classe Audio";
    case 4410439: return "CoreLogic";
    case 4410441: return "Cirrus Logic Inc";
    case 4410445: return "CrystaLake Multimedia";
    case 4410447: return "Clone Computers";
    case 4410450: return "Clover Electronics";
    case 4410452: return "automated computer control systems";
    case 4410454: return "Clevo Company";
    case 4410456: return "CardLogix";
    case 4410691: return "CMC Ltd";
    case 4410692: return "Colorado MicroDisplay, Inc.";
    case 4410695: return "Chenming Mold Ind. Corp.";
    case 4410697: return "C\055Media Electronics";
    case 4410699: return "Comark LLC";
    case 4410701: return "Comtime GmbH";
    case 4410702: return "Chimei Innolux Corporation";
    case 4410703: return "Chi Mei Optoelectronics corp.";
    case 4410706: return "Cambridge Research Systems Ltd";
    case 4410707: return "CompuMaster Srl";
    case 4410712: return "Comex Electronics AB";
    case 4410946: return "American Power Conversion";
    case 4410947: return "Alvedon Computers Ltd";
    case 4410948: return "Micro\055Star Int\047l Co., Ltd.";
    case 4410949: return "Cine\055tal";
    case 4410953: return "Connect Int\047l A\057S";
    case 4410958: return "Canon Inc";
    case 4410964: return "COINT Multimedia Systems";
    case 4411202: return "COBY Electronics Co., Ltd";
    case 4411204: return "CODAN Pty. Ltd.";
    case 4411209: return "Codec Inc.";
    case 4411212: return "Rockwell Collins, Inc.";
    case 4411213: return "Comtrol Corporation";
    case 4411214: return "Contec Company Ltd";
    case 4411215: return "coolux GmbH";
    case 4411218: return "Corollary Inc";
    case 4411219: return "CoStar Corporation";
    case 4411220: return "Core Technology Inc";
    case 4411223: return "Polycow Productions";
    case 4411224: return "Comrex";
    case 4411459: return "Ciprico Inc";
    case 4411460: return "CompuAdd";
    case 4411465: return "Computer Peripherals Inc";
    case 4411468: return "Compal Electronics Inc";
    case 4411469: return "Capella Microsystems Inc.";
    case 4411472: return "Compound Photonics";
    case 4411473: return "Compaq Computer Company";
    case 4411476: return "cPATH";
    case 4411480: return "Powermatic Data Systems";
    case 4411969: return "CRALTECH ELECTRONICA, S.L.";
    case 4411971: return "CONRAC GmbH";
    case 4411972: return "Cardinal Technical Inc";
    case 4411973: return "Creative Labs Inc";
    case 4411976: return "Contemporary Research Corp.";
    case 4411977: return "Crio Inc.";
    case 4411980: return "Creative Logic";
    case 4411981: return "CORSAIR MEMORY Inc.";
    case 4411982: return "Cornerstone Imaging";
    case 4411983: return "Extraordinary Technologies PTY Limited";
    case 4411985: return "Cirque Corporation";
    case 4411987: return "Crescendo Communication Inc";
    case 4411990: return "Cerevo Inc.";
    case 4411991: return "Cammegh Limited";
    case 4411992: return "Cyrix Corporation";
    case 4412226: return "Transtex SA";
    case 4412227: return "Crystal Semiconductor";
    case 4412228: return "Cresta Systems Inc";
    case 4412229: return "Concept Solutions \046 Engineering";
    case 4412233: return "Cabletron System Inc";
    case 4412236: return "Cloudium Systems Ltd.";
    case 4412237: return "Cosmic Engineering Inc.";
    case 4412239: return "California Institute of Technology";
    case 4412243: return "CSS Laboratories";
    case 4412244: return "CSTI Inc";
    case 4412247: return "China Star Optoelectronics Technology Co., Ltd";
    case 4412481: return "CoSystems Inc";
    case 4412483: return "CTC Communication Development Company Ltd";
    case 4412485: return "Chunghwa Telecom Co., Ltd.";
    case 4412492: return "Creative Technology Ltd";
    case 4412493: return "Computerm Corporation";
    case 4412494: return "Computone Products";
    case 4412496: return "Computer Technology Corporation";
    case 4412498: return "Control4 Corporation";
    case 4412499: return "Comtec Systems Co., Ltd.";
    case 4412504: return "Creatix Polymedia GmbH";
    case 4412738: return "Cubix Corporation";
    case 4412747: return "Calibre UK Ltd";
    case 4412993: return "Covia Inc.";
    case 4413001: return "Colorado Video, Inc.";
    case 4413008: return "Chromatec Video Products Ltd";
    case 4413011: return "Clarity Visual Systems";
    case 4413251: return "Curtiss\055Wright Controls, Inc.";
    case 4413266: return "Connectware Inc";
    case 4413524: return "Conexant Systems";
    case 4413762: return "CyberVision";
    case 4413763: return "Cylink Corporation";
    case 4413764: return "Cyclades Corporation";
    case 4413772: return "Cyberlabs";
    case 4413776: return "CYPRESS SEMICONDUCTOR CORPORATION";
    case 4413780: return "Cytechinfo Inc";
    case 4413782: return "Cyviz AS";
    case 4413783: return "Cyberware";
    case 4413784: return "Cyrix Corporation";
    case 4414019: return "Shenzhen ChuangZhiCheng Technology Co., Ltd.";
    case 4414021: return "Carl Zeiss AG";
    case 4473155: return "Digital Acoustics Corporation";
    case 4473157: return "Digatron Industrie Elektronik GmbH";
    case 4473161: return "DAIS SET Ltd.";
    case 4473163: return "Daktronics";
    case 4473164: return "Digital Audio Labs Inc";
    case 4473166: return "Danelec Marine A\057S";
    case 4473171: return "DAVIS AS";
    case 4473172: return "Datel Inc";
    case 4473173: return "Daou Tech Inc";
    case 4473174: return "Davicom Semiconductor Inc";
    case 4473175: return "DA2 Technologies Inc";
    case 4473176: return "Data Apex Ltd";
    case 4473412: return "Diebold Inc.";
    case 4473417: return "DigiBoard Inc";
    case 4473419: return "Databook Inc";
    case 4473420: return "Doble Engineering Company";
    case 4473422: return "DB Networks Inc";
    case 4473665: return "Digital Communications Association";
    case 4473667: return "Dale Computer Corporation";
    case 4473668: return "Datacast LLC";
    case 4473669: return "dSPACE GmbH";
    case 4473673: return "Concepts Inc";
    case 4473676: return "Dynamic Controls Ltd";
    case 4473677: return "DCM Data Products";
    case 4473679: return "Dialogue Technology Corporation";
    case 4473682: return "Decros Ltd";
    case 4473683: return "Diamond Computer Systems Inc";
    case 4473684: return "Dancall Telecom A\057S";
    case 4473686: return "Datatronics Technology Inc";
    case 4473921: return "DA2 Technologies Corporation";
    case 4473924: return "Danka Data Devices";
    case 4473925: return "Datasat Digital Entertainment";
    case 4473929: return "Data Display AG";
    case 4473939: return "Barco, N.V.";
    case 4473940: return "Datadesk Technologies Inc";
    case 4473942: return "Delta Information Systems, Inc";
    case 4474179: return "Digital Equipment Corporation";
    case 4474182: return "DEIF A\057S";
    case 4474185: return "Deico Electronics";
    case 4474188: return "Dell Inc.";
    case 4474189: return "DemoPad\240Software\240Ltd";
    case 4474190: return "Densitron Computers Ltd";
    case 4474200: return "idex displays";
    case 4474441: return "DFI";
    case 4474443: return "SharkTec A\057S";
    case 4474452: return "DEI Holdings dba Definitive Technology";
    case 4474689: return "Digiital Arts Inc";
    case 4474691: return "Data General Corporation";
    case 4474697: return "DIGI International";
    case 4474699: return "DugoTech Co., LTD";
    case 4474704: return "Digicorp European sales S.A.";
    case 4474707: return "Diagsoft Inc";
    case 4474708: return "Dearborn Group Technology";
    case 4474948: return "Dension Audio Systems";
    case 4474960: return "DH Print";
    case 4474961: return "Quadram";
    case 4474964: return "Projectavision Inc";
    case 4475201: return "Diadem";
    case 4475207: return "Digicom S.p.A.";
    case 4475209: return "Dataq Instruments Inc";
    case 4475213: return "dPict Imaging, Inc.";
    case 4475214: return "Daintelecom Co., Ltd";
    case 4475219: return "Diseda S.A.";
    case 4475220: return "Dragon Information Technology";
    case 4475461: return "Capstone Visual Product Development";
    case 4475472: return "Maygay Machines, Ltd";
    case 4475737: return "Datakey Inc";
    case 4475970: return "Dolby Laboratories Inc.";
    case 4475971: return "Diamond Lane Comm. Corporation";
    case 4475972: return "Delem";
    case 4475975: return "Digital\055Logic GmbH";
    case 4475979: return "D\055Link Systems Inc";
    case 4475980: return "Dell Inc";
    case 4475981: return "DLOGIC Ltd.";
    case 4475983: return "Shenzhen Dlodlo Technologies Co., Ltd.";
    case 4475988: return "Digitelec Informatique Park Cadera";
    case 4476226: return "Digicom Systems Inc";
    case 4476227: return "Dune Microsystems Corporation";
    case 4476231: return "Monoprice.Inc";
    case 4476237: return "Dimond Multimedia Systems Inc";
    case 4476238: return "Dimension Engineering LLC";
    case 4476239: return "Data Modul AG";
    case 4476240: return "D\046M Holdings Inc, Professional Business Company";
    case 4476243: return "DOME imaging systems";
    case 4476244: return "Distributed Management Task Force, Inc. \050DMTF\051";
    case 4476246: return "NDS Ltd";
    case 4476481: return "DNA Enterprises, Inc.";
    case 4476487: return "Apache Micro Peripherals Inc";
    case 4476489: return "Deterministic Networks Inc.";
    case 4476500: return "Dr. Neuhous Telekommunikation GmbH";
    case 4476502: return "DiCon";
    case 4476748: return "Dolman Technologies Group Inc";
    case 4476749: return "Dome Imaging Systems";
    case 4476750: return "DENON, Ltd.";
    case 4476756: return "Dotronic Mikroelektronik GmbH";
    case 4476993: return "DigiTalk Pro AV";
    case 4476995: return "Delta Electronics Inc";
    case 4477000: return "Delphi Automotive LLP";
    case 4477001: return "DocuPoint";
    case 4477004: return "Digital Projection Limited";
    case 4477005: return "ADPM Synthesis sas";
    case 4477006: return "Shanghai Lexiang Technology Limited";
    case 4477011: return "Digital Processing Systems";
    case 4477012: return "DPT";
    case 4477016: return "DpiX, Inc.";
    case 4477250: return "Datacube Inc";
    case 4477506: return "Dr. Bott KG";
    case 4477507: return "Data Ray Corp.";
    case 4477508: return "DIGITAL REFLECTION INC.";
    case 4477513: return "Data Race Inc";
    case 4477523: return "DRS Defense Solutions, LLC";
    case 4477761: return "Display Solution AG";
    case 4477764: return "DS Multimedia Pte Ltd";
    case 4477767: return "Disguise Technologies";
    case 4477769: return "Digitan Systems Inc";
    case 4477770: return "VR Technology Holdings Limited";
    case 4477773: return "DSM Digital Services GmbH";
    case 4477776: return "Domain Technology Inc";
    case 4478017: return "DELTATEC";
    case 4478019: return "DTC Tech Corporation";
    case 4478021: return "Dimension Technologies, Inc.";
    case 4478025: return "Diversified Technology, Inc.";
    case 4478027: return "Dynax Electronics \050HK\051 Ltd";
    case 4478028: return "e\055Net Inc";
    case 4478029: return "Daten Tecnologia";
    case 4478030: return "Datang  Telephone Co";
    case 4478031: return "Deutsche Thomson OHG";
    case 4478036: return "Design \046 Test Technology, Inc.";
    case 4478040: return "Data Translation";
    case 4478273: return "Dosch \046 Amand GmbH \046 Company KG";
    case 4478286: return "NCR Corporation";
    case 4478532: return "Dictaphone Corporation";
    case 4478540: return "Devolo AG";
    case 4478547: return "Digital Video System";
    case 4478548: return "Data Video";
    case 4478789: return "Daewoo Electronics Company Ltd";
    case 4479043: return "Digipronix Control Systems";
    case 4479044: return "DECIMATOR DESIGN PTY LTD";
    case 4479052: return "Dextera Labs Inc";
    case 4479054: return "Dixon Technologies \050India\051 Limited";
    case 4479056: return "Data Expert Corporation";
    case 4479059: return "Signet";
    case 4479299: return "Dycam Inc";
    case 4479309: return "Dymo\055CoStar Corporation";
    case 4479310: return "Askey Computer Corporation";
    case 4479320: return "Dynax Electronics \050HK\051 Ltd";
    case 4538691: return "Emotiva Audio Corp.";
    case 4538695: return "ELTEC Elektronik AG";
    case 4538707: return "Evans and Sutherland Computer";
    case 4538952: return "Data Price Informatica";
    case 4538963: return "EBS Euchner Büro\055 und Schulsysteme GmbH";
    case 4538964: return "HUALONG TECHNOLOGY CO., LTD";
    case 4539201: return "Electro Cam Corp.";
    case 4539203: return "ESSential Comm. Corporation";
    case 4539208: return "EchoStar Corporation";
    case 4539209: return "Enciris Technologies";
    case 4539211: return "Eugene Chukhlomin Sole Proprietorship, d.b.a.";
    case 4539212: return "Excel Company Ltd";
    case 4539213: return "E\055Cmos Tech Corporation";
    case 4539215: return "Echo Speech Corporation";
    case 4539216: return "Elecom Company Ltd";
    case 4539219: return "Elitegroup Computer Systems Company Ltd";
    case 4539220: return "Enciris Technologies";
    case 4539459: return "e.Digital Corporation";
    case 4539463: return "Electronic\055Design GmbH";
    case 4539465: return "Edimax Tech. Company Ltd";
    case 4539469: return "EDMI";
    case 4539476: return "Emerging Display Technologies Corp";
    case 4539717: return "ET\046T Technology Company Ltd";
    case 4539720: return "EEH Datalink GmbH";
    case 4539721: return "ELARABY COMPANY FOR ENGINEERING INDUSTRIES";
    case 4539728: return "E.E.P.D. GmbH";
    case 4539731: return "EE Solutions, Inc.";
    case 4540225: return "Elgato Systems LLC";
    case 4540228: return "EIZO GmbH Display Technologies";
    case 4540236: return "Eagle Technology";
    case 4540238: return "Egenera, Inc.";
    case 4540239: return "Ergo Electronics";
    case 4540490: return "Epson Research";
    case 4540494: return "Enhansoft";
    case 4540739: return "Eicon Technology Corporation";
    case 4540750: return "Elegant Invention";
    case 4541249: return "MagTek Inc.";
    case 4541251: return "Eastman Kodak Company";
    case 4541267: return "EKSEN YAZILIM";
    case 4541505: return "ELAD srl";
    case 4541507: return "Electro Scientific Ind";
    case 4541508: return "Express Luck, Inc.";
    case 4541509: return "Elecom Company Ltd";
    case 4541511: return "Elmeg GmbH Kommunikationstechnik";
    case 4541513: return "Edsun Laboratories";
    case 4541516: return "Electrosonic Ltd";
    case 4541517: return "Elmic Systems Inc";
    case 4541519: return "Elo TouchSystems Inc";
    case 4541523: return "ELSA GmbH";
    case 4541524: return "Element Labs, Inc.";
    case 4541525: return "Express Industrial, Ltd.";
    case 4541528: return "Elonex PLC";
    case 4541762: return "Embedded computing inc ltd";
    case 4541763: return "eMicro Corporation";
    case 4541764: return "Embrionix Design Inc.";
    case 4541765: return "EMiNE TECHNOLOGY COMPANY, LTD.";
    case 4541767: return "EMG Consultants Inc";
    case 4541769: return "Ex Machina Inc";
    case 4541771: return "Emcore Corporation";
    case 4541775: return "ELMO COMPANY, LIMITED";
    case 4541778: return "ICC Intelligent Platforms GmbH";
    case 4541781: return "Emulex Corporation";
    case 4542019: return "Eizo Nanao Corporation";
    case 4542020: return "ENIDAN Technologies Ltd";
    case 4542021: return "ENE Technology Inc.";
    case 4542025: return "Efficient Networks";
    case 4542035: return "Ensoniq Corporation";
    case 4542036: return "Enterprise Comm. \046 Computing Inc";
    case 4542286: return "Eon Instrumentation, Inc.";
    case 4542531: return "Empac";
    case 4542536: return "Epiphan Systems Inc.";
    case 4542537: return "Envision Peripherals, Inc";
    case 4542542: return "EPiCON Inc.";
    case 4542547: return "KEPS";
    case 4542800: return "Equipe Electronics Ltd.";
    case 4542808: return "Equinox Systems Inc";
    case 4543047: return "Ergo System";
    case 4543049: return "Ericsson Mobile Communications AB";
    case 4543054: return "Ericsson, Inc.";
    case 4543056: return "Euraplan GmbH";
    case 4543059: return "Eizo Rugged Solutions";
    case 4543060: return "Escort Insturments Corporation";
    case 4543297: return "Elbit Systems of America";
    case 4543298: return "ScioTeq";
    case 4543299: return "Eden Sistemas de Computacao S\057A";
    case 4543300: return "Ensemble Designs, Inc";
    case 4543303: return "ELCON Systemtechnik GmbH";
    case 4543305: return "Extended Systems, Inc.";
    case 4543307: return "ES\046S";
    case 4543308: return "Esterline Technologies";
    case 4543310: return "eSATURNUS";
    case 4543315: return "ESS Technology Inc";
    case 4543316: return "Embedded Solution Technology";
    case 4543321: return "E\055Systems Inc";
    case 4543555: return "Everton Technology Company Ltd";
    case 4543556: return "ELAN MICROELECTRONICS CORPORATION";
    case 4543559: return "Eizo Technologies GmbH";
    case 4543560: return "Etherboot Project";
    case 4543561: return "Eclipse Tech Inc";
    case 4543563: return "eTEK Labs Inc.";
    case 4543564: return "Evertz Microsystems Ltd.";
    case 4543571: return "Electronic Trade Solutions Ltd";
    case 4543572: return "E\055Tech Inc";
    case 4543828: return "Ericsson Mobile Networks B.V.";
    case 4544069: return "Advanced Micro Peripherals Ltd";
    case 4544073: return "eviateg GmbH";
    case 4544080: return "EverPro Technologies Company Limited";
    case 4544088: return "Everex";
    case 4544577: return "Exabyte";
    case 4544579: return "Excession Audio";
    case 4544585: return "Exide Electronics";
    case 4544590: return "RGB Systems, Inc. dba Extron Electronics";
    case 4544592: return "Data Export Corporation";
    case 4544594: return "Explorer Inc.";
    case 4544596: return "Exatech Computadores \046 Servicos Ltda";
    case 4544600: return "Exxact GmbH";
    case 4544601: return "Exterity Ltd";
    case 4544837: return "eyevis GmbH";
    case 4544838: return "eyefactive Gmbh";
    case 4545093: return "EzE Technologies";
    case 4545104: return "Storm Technology";
    case 4604238: return "Fantalooks Co., Ltd.";
    case 4604242: return "Farallon Computing";
    case 4604489: return "Interface Corporation";
    case 4604738: return "Furukawa Electric Company Ltd";
    case 4604743: return "First International Computer Ltd";
    case 4604755: return "Focus Enhancements, Inc.";
    case 4604995: return "Future Domain";
    case 4604996: return "Forth Dimension Displays Ltd";
    case 4605001: return "Future Designs, Inc.";
    case 4605012: return "Fujitsu Display Technologies Corp.";
    case 4605016: return "Findex, Inc.";
    case 4605251: return "FURUNO ELECTRIC CO., LTD.";
    case 4605260: return "Fellowes \046 Questec";
    case 4605262: return "Fen Systems Ltd.";
    case 4605266: return "Ferranti Int\047L";
    case 4605507: return "FUJIFILM Corporation";
    case 4605513: return "Fairfield Industries";
    case 4605764: return "Lisa Draexlmaier GmbH";
    case 4605772: return "Fujitsu General Limited.";
    case 4606028: return "FHLP";
    case 4606275: return "Formosa Industrial Computing Inc";
    case 4606284: return "Forefront Int\047l Ltd";
    case 4606286: return "Finecom Co., Ltd.";
    case 4606290: return "Chaplet Systems Inc";
    case 4606291: return "FLY\055IT Simulators";
    case 4606292: return "Feature Integration Technology Inc.";
    case 4606531: return "FCL COMPONENTS LIMITED";
    case 4606547: return "Fujitsu Spain";
    case 4606548: return "F.J. Tieman BV";
    case 4607045: return "ADTI Media, Inc";
    case 4607049: return "Faroudja Laboratories";
    case 4607065: return "Butterfly Communications";
    case 4607297: return "Fast Multimedia AG";
    case 4607299: return "Ford Microelectronics Inc";
    case 4607305: return "Fellowes, Inc.";
    case 4607308: return "Fujitsu Microelect Ltd";
    case 4607322: return "Formoza\055Altair";
    case 4607555: return "Fanuc LTD";
    case 4607561: return "Funai Electric Co., Ltd.";
    case 4607809: return "FOR\055A Company Limited";
    case 4607819: return "Fokus Technologies GmbH";
    case 4607827: return "Foss Tecator";
    case 4607830: return "FOVE INC";
    case 4607832: return "HON HAI PRECISION IND.CO.,LTD.";
    case 4608067: return "Fingerprint Cards AB";
    case 4608069: return "Fujitsu Peripherals Ltd";
    case 4608083: return "Deltec Corporation";
    case 4608088: return "Cirel Systemes";
    case 4608579: return "Force Computers";
    case 4608580: return "Freedom Scientific BLV";
    case 4608581: return "Forvus Research Inc";
    case 4608585: return "Fibernet Research Inc";
    case 4608591: return "FARO Technologies";
    case 4608595: return "South Mountain Technologies, LTD";
    case 4608835: return "Future Systems Consulting KK";
    case 4608841: return "Fore Systems Inc";
    case 4608852: return "Modesto PC Inc";
    case 4609091: return "Futuretouch Corporation";
    case 4609093: return "Frontline Test Equipment Inc.";
    case 4609095: return "FTG Data Systems";
    case 4609097: return "FastPoint Technologies, Inc.";
    case 4609100: return "FUJITSU TEN LIMITED";
    case 4609102: return "Fountain Technologies Inc";
    case 4609106: return "Mediasonic";
    case 4609107: return "FocalTech Systems Co., Ltd.";
    case 4609111: return "MindTribe Product Engineering, Inc.";
    case 4609354: return "Fujitsu Ltd";
    case 4609356: return "Fun Technology Innovation INC.";
    case 4609358: return "sisel muhendislik";
    case 4609363: return "Fujitsu Siemens Computers GmbH";
    case 4609603: return "First Virtual Corporation";
    case 4609624: return "C\055C\055C Group Plc";
    case 4609857: return "Attero Tech, LLC";
    case 4609874: return "Flat Connections Inc";
    case 4610136: return "Fuji Xerox";
    case 4610627: return "Founder Group Shenzhen Co.";
    case 4610633: return "FZI Forschungszentrum Informatik";
    case 4669763: return "GreenArrays, Inc.";
    case 4669767: return "Gage Applied Sciences Inc";
    case 4669772: return "Galil Motion Control";
    case 4669781: return "Gaudi Co., Ltd.";
    case 4670036: return "GIGA\055BYTE TECHNOLOGY CO., LTD.";
    case 4670275: return "GCC Technologies Inc";
    case 4670281: return "Gateway Comm. Inc";
    case 4670291: return "Grey Cell Systems Ltd";
    case 4670531: return "General Datacom";
    case 4670537: return "G. Diehl ISDN GmbH";
    case 4670547: return "GDS";
    case 4670548: return "Vortex Computersysteme GmbH";
    case 4670787: return "Gechic Corporation";
    case 4670788: return "General Dynamics C4 Systems";
    case 4670790: return "GE Fanuc Embedded Systems";
    case 4670792: return "Abaco Systems, Inc.";
    case 4670797: return "Gem Plus";
    case 4670798: return "Genesys ATE Inc";
    case 4670799: return "GEO Sense";
    case 4670802: return "GERMANEERS GmbH";
    case 4670803: return "GES Singapore Pte Ltd";
    case 4670804: return "Getac Technology Corporation";
    case 4671053: return "GFMesstechnik GmbH";
    case 4671054: return "Gefen Inc.";
    case 4671308: return "Google Inc.";
    case 4671316: return "G2TOUCH KOREA";
    case 4671811: return "General Inst. Corporation";
    case 4671821: return "Guillemont International";
    case 4671824: return "GI Provision Ltd";
    case 4671827: return "AT\046T Global Info Solutions";
    case 4672078: return "Grand Junction Networks";
    case 4672580: return "Goldmund \055 Digital Audio SA";
    case 4672581: return "AD electronics";
    case 4672589: return "Genesys Logic";
    case 4672595: return "Gadget Labs LLC";
    case 4672843: return "GMK Electronic Design GmbH";
    case 4672844: return "General Information Systems";
    case 4672845: return "GMM Research Inc";
    case 4672846: return "GEMINI 2000 Ltd";
    case 4672856: return "GMX Inc";
    case 4673092: return "Gennum Corporation";
    case 4673102: return "GN Nettest Inc";
    case 4673114: return "Gunze Ltd";
    case 4673349: return "GOEPEL electronic GmbH";
    case 4673618: return "GoPro, Inc.";
    case 4674113: return "Graphica Computer";
    case 4674117: return "GOLD RAIN ENTERPRISES CORP.";
    case 4674120: return "Granch Ltd";
    case 4674125: return "Garmin International";
    case 4674134: return "Advanced Gravis";
    case 4674137: return "Robert Gray Company";
    case 4674370: return "NIPPONDENCHI CO,.LTD";
    case 4674371: return "General Standards Corporation";
    case 4674381: return "LG Electronics";
    case 4674382: return "Grandstream Networks, Inc.";
    case 4674388: return "Graphic SystemTechnology";
    case 4674393: return "Grossenbacher Systeme AG";
    case 4674627: return "Graphtec Corporation";
    case 4674633: return "Goldtouch";
    case 4674635: return "G\055Tech Corporation";
    case 4674637: return "Garnet System Company Ltd";
    case 4674643: return "Geotest Marvin Test Systems Inc";
    case 4674644: return "General Touch Technology Co., Ltd.";
    case 4674884: return "Guntermann \046 Drunck GmbH";
    case 4674896: return "GoUp Co.,Ltd";
    case 4674906: return "Guzik Technical Enterprises";
    case 4675139: return "GVC Corporation";
    case 4675148: return "Global Village Communication";
    case 4675155: return "G.VISION";
    case 4675401: return "GW Instruments";
    case 4675403: return "Gateworks Corporation";
    case 4675417: return "Gateway 2000";
    case 4675660: return "Galaxy Microsystems Ltd.";
    case 4676165: return "GUNZE Limited";
    case 4735301: return "Haider electronics";
    case 4735305: return "Haivision Systems Inc.";
    case 4735308: return "Halberthal";
    case 4735310: return "Hanchang System Corporation";
    case 4735314: return "Harris Corporation";
    case 4735321: return "Hayes Microcomputer Products Inc";
    case 4735809: return "DAT";
    case 4735813: return "Hitachi Consumer Electronics Co., Ltd";
    case 4735820: return "HCL America Inc";
    case 4735821: return "HCL Peripherals";
    case 4735824: return "Hitachi Computer Products Inc";
    case 4735831: return "Hauppauge Computer Works Inc";
    case 4736067: return "HardCom Elektronik \046 Datateknik";
    case 4736073: return "HD\055INFO d.o.o.";
    case 4736086: return "Holografika kft.";
    case 4736323: return "Hisense Electric Co., Ltd.";
    case 4736332: return "Hitachi Micro Systems Europe Ltd";
    case 4736338: return "Ascom Business Systems";
    case 4736340: return "HETEC Datensysteme GmbH";
    case 4737091: return "HIRAKAWA HEWTECH CORP.";
    case 4737097: return "Fraunhofer Heinrich\055Hertz\055Institute";
    case 4737108: return "Hitevision Group";
    case 4737346: return "Hibino Corporation";
    case 4737347: return "Hitachi Information Technology Co., Ltd.";
    case 4737353: return "Harman International Industries, Inc";
    case 4737355: return "Hikom Co., Ltd.";
    case 4737356: return "Hilevel Technology";
    case 4737361: return "Kaohsiung Opto Electronics Americas, Inc.";
    case 4737363: return "Hope Industrial Systems, Inc.";
    case 4737364: return "Hitachi America Ltd";
    case 4737609: return "Harris \046 Jeffries Inc";
    case 4737857: return "HONKO MFG. CO., LTD.";
    case 4737859: return "HKC OVERSEAS LIMITED";
    case 4737863: return "Josef Heim KG";
    case 4738119: return "China Hualu Group Co., Ltd.";
    case 4738371: return "Hualon Microelectric Corporation";
    case 4738379: return "hmk Daten\055System\055Technik BmbH";
    case 4738392: return "HUMAX Co., Ltd.";
    case 4738637: return "HONOR Device Co., Ltd.";
    case 4738643: return "Hughes Network Systems";
    case 4738882: return "HOB Electronic GmbH";
    case 4738885: return "Hosiden Corporation";
    case 4738892: return "Holoeye Photonics AG";
    case 4738894: return "Sonitronix";
    case 4739137: return "Zytor Communications";
    case 4739139: return "Hewlett\055Packard Co.";
    case 4739140: return "Hewlett Packard";
    case 4739141: return "Hewlett Packard Enterprise";
    case 4739145: return "Headplay, Inc.";
    case 4739147: return "HAMAMATSU PHOTONICS K.K.";
    case 4739150: return "HP Inc.";
    case 4739153: return "Hewlett\055Packard Co.";
    case 4739154: return "H.P.R. Electronics GmbH";
    case 4739651: return "Hercules";
    case 4739653: return "Qingdao Haier Electronics Co., Ltd.";
    case 4739657: return "Hall Research";
    case 4739660: return "Herolab GmbH";
    case 4739667: return "Harris Semiconductor";
    case 4739668: return "HERCULES";
    case 4739907: return "Hagiwara Sys\055Com Company Ltd";
    case 4739908: return "HannStar Display Corp";
    case 4739917: return "AT\046T Microelectronics";
    case 4739918: return "Hansung Co., Ltd";
    case 4739920: return "HannStar Display Corp";
    case 4739924: return "Horsent Technology Co., Ltd.";
    case 4740163: return "Hitachi Ltd";
    case 4740169: return "Hampshire Company, Inc.";
    case 4740171: return "Holtek Microelectronics Inc";
    case 4740172: return "HTBLuVA Mödling";
    case 4740178: return "Shenzhen ZhuoYi HengTong Computer Technology Limited";
    case 4740184: return "Hitex Systementwicklung GmbH";
    case 4740418: return "GAI\055Tronics, A Hubbell Company";
    case 4740427: return "Hoffmann \053 Krippner GmbH";
    case 4740429: return "IMP Electronics Ltd.";
    case 4740690: return "HTC Corportation";
    case 4740929: return "Harris Canada Inc";
    case 4740931: return "DBA Hans Wedemeyer";
    case 4740932: return "Highwater Designs Ltd";
    case 4740944: return "Hewlett Packard";
    case 4740950: return "Huawei Technologies Co., Inc.";
    case 4741197: return "Hexium Ltd.";
    case 4741443: return "Hypercope Gmbh Aachen";
    case 4741444: return "Hydis Technologies.Co.,LTD";
    case 4741452: return "Shanghai Chai Ming Huang Info\046Tech Co, Ltd";
    case 4741455: return "HYC CO., LTD.";
    case 4741456: return "Hyphen Ltd";
    case 4741458: return "Hypertec Pty Ltd";
    case 4741460: return "Heng Yu Technology \050HK\051 Limited";
    case 4741462: return "Hynix Semiconductor";
    case 4800836: return "IAdea Corporation";
    case 4800838: return "Institut f r angewandte Funksystemtechnik GmbH";
    case 4800841: return "Integration Associates, Inc.";
    case 4800852: return "IAT Germany GmbH";
    case 4801091: return "Integrated Business Systems";
    case 4801097: return "INBINE.CO.LTD";
    case 4801101: return "IBM Brasil";
    case 4801104: return "IBP Instruments GmbH";
    case 4801106: return "IBR GmbH";
    case 4801345: return "ICA Inc";
    case 4801347: return "BICC Data Networks Ltd";
    case 4801348: return "ICD Inc";
    case 4801349: return "IC Ensemble";
    case 4801353: return "Infotek Communication Inc";
    case 4801357: return "Intracom SA";
    case 4801358: return "Sanyo Icon";
    case 4801359: return "Intel Corp";
    case 4801360: return "ICP Electronics, Inc.\057iEi Technology Corp.";
    case 4801362: return "Icron";
    case 4801363: return "Integrated Circuit Systems";
    case 4801366: return "Inside Contactless";
    case 4801368: return "ICCC A\057S";
    case 4801603: return "International Datacasting Corporation";
    case 4801605: return "IDE Associates";
    case 4801611: return "IDK Corporation";
    case 4801614: return "Idneo Technologies";
    case 4801615: return "IDEO Product Development";
    case 4801616: return "Integrated Device Technology, Inc.";
    case 4801619: return "Interdigital Sistemas de Informacao";
    case 4801620: return "International Display Technology";
    case 4801624: return "IDEXX Labs";
    case 4801859: return "Interlace Engineering Corporation";
    case 4801861: return "IEE";
    case 4801865: return "Interlink Electronics";
    case 4802131: return "In Focus Systems Inc";
    case 4802132: return "Informtech";
    case 4802136: return "Infineon Technologies AG";
    case 4802138: return "Infinite Z";
    case 4802371: return "Intergate Pty Ltd";
    case 4802381: return "IGM Communi";
    case 4802629: return "InHand Electronics";
    case 4802883: return "ISIC Innoscan Industrial Computers A\057S";
    case 4802889: return "Intelligent Instrumentation";
    case 4802894: return "IINFRA Co., Ltd";
    case 4802900: return "Informatik Information Technologies";
    case 4803397: return "Ikegami Tsushinki Co. Ltd.";
    case 4803411: return "Ikos Systems Inc";
    case 4803651: return "Image Logic Corporation";
    case 4803667: return "Innotech Corporation";
    case 4803905: return "Imagraph";
    case 4803906: return "ART s.r.l.";
    case 4803907: return "IMC Networks";
    case 4803908: return "ImasDe Canarias S.A.";
    case 4803909: return "Imagraph";
    case 4803910: return "Immersive Audio Technologies France";
    case 4803911: return "IMAGENICS Co., Ltd.";
    case 4803913: return "International Microsystems Inc";
    case 4803917: return "Immersion Corporation";
    case 4803918: return "Impossible Production";
    case 4803920: return "Impinj";
    case 4803924: return "Inmax Technology Corporation";
    case 4803928: return "arpara Technology Co., Ltd.";
    case 4804161: return "Inventec Corporation";
    case 4804163: return "Home Row Inc";
    case 4804164: return "ILC";
    case 4804165: return "Inventec Electronics \050M\051 Sdn. Bhd.";
    case 4804166: return "Inframetrics Inc";
    case 4804167: return "Integraph Corporation";
    case 4804169: return "Initio Corporation";
    case 4804171: return "Indtek Co., Ltd.";
    case 4804172: return "InnoLux Display Corporation";
    case 4804173: return "InnoMedia Inc";
    case 4804174: return "Innovent Systems, Inc.";
    case 4804175: return "Innolab Pte Ltd";
    case 4804176: return "Interphase Corporation";
    case 4804179: return "Ines GmbH";
    case 4804180: return "Interphase Corporation";
    case 4804182: return "Inviso, Inc.";
    case 4804184: return "Communications Supply Corporation \050A division of WESCO\051";
    case 4804186: return "Best Buy";
    case 4804417: return "CRE Technology Corporation";
    case 4804419: return "Guangxi Century Innovation Display Electronics Co., Ltd";
    case 4804420: return "I\055O Data Device Inc";
    case 4804429: return "Iomega";
    case 4804430: return "Inside Out Networks";
    case 4804435: return "i\055O Display System";
    case 4804436: return "I\057OTech Inc";
    case 4804675: return "IPC Corporation";
    case 4804676: return "Industrial Products Design, Inc.";
    case 4804681: return "Intelligent Platform Management Interface \050IPMI\051 forum \050Intel, HP, NEC, Dell\051";
    case 4804685: return "IPM Industria Politecnica Meridionale SpA";
    case 4804686: return "Performance Technologies";
    case 4804688: return "IP Power Technologies GmbH";
    case 4804689: return "IP3 Technology Ltd.";
    case 4804690: return "Ithaca Peripherals";
    case 4804691: return "IPS, Inc. \050Intellectual Property Solutions, Inc.\051";
    case 4804692: return "International Power Technologies";
    case 4804695: return "IPWireless, Inc";
    case 4804937: return "IneoQuest Technologies, Inc";
    case 4804948: return "IMAGEQUEST Co., Ltd";
    case 4805188: return "Irdata";
    case 4805441: return "Symbol Technologies";
    case 4805443: return "Id3 Semiconductors";
    case 4805447: return "Insignia Solutions Inc";
    case 4805449: return "Interface Solutions";
    case 4805452: return "Isolation Systems";
    case 4805453: return "Image Stream Medical";
    case 4805456: return "IntreSource Systems Pte Ltd";
    case 4805458: return "INSIS Co., LTD.";
    case 4805459: return "ISS Inc";
    case 4805460: return "Intersolve Technologies";
    case 4805465: return "International Integrated Systems,Inc.\050IISI\051";
    case 4805697: return "Itausa Export North America";
    case 4805699: return "Intercom Inc";
    case 4805700: return "Internet Technology Corporation";
    case 4805701: return "Integrated Tech Express Inc";
    case 4805705: return "VanErum Group";
    case 4805707: return "ITK Telekommunikation AG";
    case 4805708: return "Inter\055Tel";
    case 4805709: return "ITM inc.";
    case 4805710: return "The NTI Group";
    case 4805712: return "IT\055PRO Consulting und Systemhaus GmbH";
    case 4805714: return "Infotronic America, Inc.";
    case 4805715: return "IDTECH";
    case 4805716: return "I\046T Telecom.";
    case 4805720: return "integrated Technology Express Inc";
    case 4805955: return "ICSL";
    case 4806217: return "Intervoice Inc";
    case 4806221: return "Iiyama North America";
    case 4806223: return "InfoVision Optoelectronics \050Kunshan\051 Co.,Ltd China";
    case 4806226: return "Inlife\055Handnet Co., Ltd.";
    case 4806227: return "Intevac Photonics Inc.";
    case 4806482: return "Icuiti Corporation";
    case 4806488: return "Intelliworxx, Inc.";
    case 4806724: return "Intertex Data AB";
    case 4806734: return "Shenzhen Inet Mobile Internet Technology Co., LTD";
    case 4866371: return "Astec Inc";
    case 4866373: return "Japan Aviation Electronics Industry, Limited";
    case 4866387: return "Janz Automationssysteme AG";
    case 4866388: return "Jaton Corporation";
    case 4866394: return "Carrera Computer Inc";
    case 4866885: return "Jace Tech Inc";
    case 4867145: return "Japan Display Inc.";
    case 4867148: return "Japan Digital Laboratory Co.,Ltd.";
    case 4867405: return "Japan E.M.Solutions Co., Ltd.";
    case 4867406: return "N\055Vision";
    case 4867412: return "JET POWER TECHNOLOGY CO., LTD.";
    case 4867672: return "Jones Futurex Inc";
    case 4867908: return "University College";
    case 4868419: return "Jaeik Information \046 Communication Co., Ltd.";
    case 4868931: return "JVC KENWOOD Corporation";
    case 4869195: return "UNIONMAN TECHNOLOGY CO., LTD";
    case 4869460: return "Micro Technical Company Ltd";
    case 4870211: return "JPC Technology Limited";
    case 4870231: return "Wallis Hamilton Industries";
    case 4870469: return "CNet Technical Inc";
    case 4870980: return "JS DigiTech, Inc";
    case 4870985: return "Jupiter Systems, Inc.";
    case 4870987: return "SANKEN ELECTRIC CO., LTD";
    case 4871251: return "JS Motorsports";
    case 4871257: return "jetway security micro,inc";
    case 4871499: return "Janich \046 Klass Computertechnik GmbH";
    case 4871504: return "Jupiter Systems";
    case 4871747: return "JVC";
    case 4872004: return "Video International Inc.";
    case 4872012: return "Jewell Instruments, LLC";
    case 4872019: return "JWSpencer \046 Co.";
    case 4872025: return "Jetway Information Co., Ltd";
    case 4931922: return "Karna";
    case 4932169: return "Kidboard Inc";
    case 4932172: return "Kobil Systems GmbH";
    case 4932420: return "Chunichi Denshi Co.,LTD.";
    case 4932428: return "Keycorp Ltd";
    case 4932677: return "KDE";
    case 4932683: return "Kodiak Tech";
    case 4932685: return "Korea Data Systems Co., Ltd.";
    case 4932691: return "KDS USA";
    case 4932692: return "KDDI Technology Corporation";
    case 4932931: return "Kyushu Electronics Systems Inc";
    case 4932941: return "Kontron Embedded Modules GmbH";
    case 4932947: return "Kesa Corporation";
    case 4932949: return "Kontron Europe GmbH";
    case 4932953: return "Key Tech Inc";
    case 4933187: return "SCD Tech";
    case 4933189: return "Komatsu Forest";
    case 4933208: return "Kofax Image Products";
    case 4933449: return "Klipsch Group, Inc";
    case 4933452: return "KEISOKU GIKEN Co.,Ltd.";
    case 4933454: return "KOGAN AUSTRALIA PTY LTD";
    case 4933967: return "Kionix, Inc.";
    case 4933971: return "KiSS Technology A\057S";
    case 4934740: return "Colorlight";
    case 4934979: return "Mitsumi Company Ltd";
    case 4934981: return "KIMIN Electronics Co., Ltd.";
    case 4934988: return "Kensington Microware Ltd";
    case 4934994: return "Kramer Electronics Ltd. International";
    case 4935235: return "Konica corporation";
    case 4935256: return "Nutech Marketing PTL";
    case 4935490: return "Kobil Systems GmbH";
    case 4935492: return "Eastman Kodak Company";
    case 4935493: return "KOLTER ELECTRONIC";
    case 4935500: return "Kollmorgen Motion Technologies Group";
    case 4935501: return "Kontron GmbH";
    case 4935504: return "Kopin Corporation";
    case 4935509: return "KOUZIRO Co.,Ltd.";
    case 4935511: return "KOWA Company,LTD.";
    case 4935747: return "King Phoenix Company";
    case 4935764: return "TPK Holding Co., Ltd";
    case 4936268: return "Krell Industries Inc.";
    case 4936269: return "Kroma Telecom";
    case 4936281: return "Kroy LLC";
    case 4936515: return "Kinetic Systems Corporation";
    case 4936519: return "KUPA China Shenzhen Micro Technology Co., Ltd. Gold Institute";
    case 4936524: return "Karn Solutions Ltd.";
    case 4936536: return "King Tester Corporation";
    case 4936771: return "Kingston Tech Corporation";
    case 4936772: return "Takahata Electronics Co.,Ltd.";
    case 4936773: return "K\055Tech";
    case 4936775: return "Kayser\055Threde GmbH";
    case 4936777: return "Konica Technical Inc";
    case 4936779: return "Key Tronic Corporation";
    case 4936782: return "Katron Tech Inc";
    case 4936787: return "Kyokko Communication System Co., Ltd.";
    case 4937042: return "Kurta Corporation";
    case 4937281: return "Kvaser AB";
    case 4937304: return "KeyView";
    case 4937540: return "Kenwood Corporation";
    case 4938051: return "Kyocera Corporation";
    case 4938053: return "KYE Syst Corporation";
    case 4938059: return "Samsung Electronics America Inc";
    case 4938062: return "KEYENCE CORPORATION";
    case 4938313: return "K\055Zone International co. Ltd.";
    case 4938318: return "K\055Zone International";
    case 4997442: return "ACT Labs Ltd";
    case 4997443: return "LaCie";
    case 4997446: return "Microline";
    case 4997447: return "Laguna Systems";
    case 4997454: return "Sodeman Lancom Inc";
    case 4997459: return "LASAT Comm. A\057S";
    case 4997462: return "Lava Computer MFG Inc";
    case 4997699: return "LABAU Technology Corp.";
    case 4997711: return "Lubosoft";
    case 4997955: return "LCI";
    case 4997956: return "Toshiba Matsushita Display Technology Co., Ltd";
    case 4997957: return "La Commande Electronique";
    case 4997961: return "Lite\055On Communication Inc";
    case 4997965: return "Latitude Comm.";
    case 4997966: return "LEXICON";
    case 4997968: return "Silent Power Electronics GmbH";
    case 4997971: return "Longshine Electronics Company";
    case 4997972: return "Labcal Technologies";
    case 4998222: return "Laserdyne Technologies";
    case 4998228: return "LogiDataTech Electronic GmbH";
    case 4998467: return "Lectron Company Ltd";
    case 4998468: return "Long Engineering Design Inc";
    case 4998471: return "Legerity, Inc";
    case 4998478: return "Lenovo Group Limited";
    case 4998479: return "First International Computer Inc";
    case 4998488: return "Lexical Ltd";
    case 4998979: return "Logic Ltd";
    case 4998980: return "LG Display";
    case 4998985: return "Logitech Inc";
    case 4998995: return "LG Semicom Company Ltd";
    case 4999000: return "Lasergraphics, Inc.";
    case 4999233: return "Lars Haagh ApS";
    case 4999235: return "Beihai Century Joint Innovation Technology Co.,Ltd";
    case 4999237: return "Lung Hwa Electronics Company Ltd";
    case 4999252: return "Lighthouse Technologies Limited";
    case 4999502: return "Lenovo Beijing Co. Ltd.";
    case 4999504: return "Linked IP GmbH";
    case 4999507: return "Life is Style Inc.";
    case 4999508: return "Lithics Silicon Technology";
    case 4999768: return "Datalogic Corporation";
    case 5000013: return "Likom Technology Sdn. Bhd.";
    case 5000268: return "L\0553 Communications";
    case 5000276: return "LUMINO Licht Elektronik GmbH";
    case 5000519: return "Lucent Technologies";
    case 5000521: return "Lexmark Int\047l Inc";
    case 5000528: return "Leda Media Products";
    case 5000531: return "Lumens Digital Optics Inc.";
    case 5000532: return "Laser Master";
    case 5000771: return "Lincoln Technology Solutions";
    case 5000772: return "Land Computer Company Ltd";
    case 5000779: return "Link Tech Inc";
    case 5000786: return "Linear Systems Ltd.";
    case 5000788: return "LANETCO International";
    case 5000790: return "Lenovo";
    case 5000792: return "The Linux Foundation";
    case 5001027: return "Locamation B.V.";
    case 5001029: return "Loewe Opta GmbH";
    case 5001031: return "Logicode Technology Inc";
    case 5001036: return "Litelogic Operations Ltd";
    case 5001285: return "El\055PUSK Co., Ltd.";
    case 5001289: return "Design Technology";
    case 5001292: return "LG Philips";
    case 5002051: return "LifeSize Communications";
    case 5002052: return "Intersil Corporation";
    case 5002057: return "Loughborough Sound Images";
    case 5002058: return "LSI Japan Company Ltd";
    case 5002060: return "Logical Solutions";
    case 5002064: return "Lightspace Technologies";
    case 5002073: return "LSI Systems Inc";
    case 5002307: return "Labtec Inc";
    case 5002313: return "Jongshine Tech Inc";
    case 5002315: return "Lucidity Technology Company Ltd";
    case 5002318: return "Litronic Inc";
    case 5002323: return "LTS Scale LLC";
    case 5002326: return "Leitch Technology International Inc.";
    case 5002327: return "Lightware, Inc";
    case 5002563: return "Lucent Technologies";
    case 5002573: return "Lumagen, Inc.";
    case 5002584: return "Luxxell Research Inc";
    case 5002825: return "LVI Low Vision International AB";
    case 5003075: return "Labway Corporation";
    case 5003090: return "Lightware Visual Engineering";
    case 5003095: return "Lanier Worldwide";
    case 5003331: return "LXCO Technologies AG";
    case 5003342: return "Luxeon";
    case 5003347: return "ELEA CardWare";
    case 5003864: return "Lightwell Company Ltd";
    case 5062979: return "MAC System Company Ltd";
    case 5062980: return "Xedia Corporation";
    case 5062981: return "Maestro Pty Ltd";
    case 5062983: return "MAG InnoVision";
    case 5062985: return "Mutoh America Inc";
    case 5062988: return "Meridian Audio Ltd";
    case 5062990: return "LGIC";
    case 5062995: return "Mass Inc.";
    case 5062996: return "Panasonic Connect Co.,Ltd.";
    case 5063000: return "Rogen Tech Distribution Inc";
    case 5063001: return "Maynard Electronics";
    case 5063002: return "MAZeT GmbH";
    case 5063235: return "MBC";
    case 5063236: return "Microbus PLC";
    case 5063245: return "Marshall Electronics";
    case 5063254: return "Moreton Bay";
    case 5063489: return "American Nuclear Systems Inc";
    case 5063491: return "Micro Industries";
    case 5063492: return "McDATA Corporation";
    case 5063493: return "Metz\055Werke GmbH \046 Co KG";
    case 5063495: return "Motorola Computer Group";
    case 5063497: return "Micronics Computers";
    case 5063498: return "Medicaroid Corporation";
    case 5063500: return "Motorola Communications Israel";
    case 5063501: return "Metricom Inc";
    case 5063502: return "Micron Electronics Inc";
    case 5063503: return "Motion Computing Inc.";
    case 5063504: return "Magni Systems Inc";
    case 5063505: return "Mat\047s Computers";
    case 5063506: return "Marina Communicaitons";
    case 5063507: return "Micro Computer Systems";
    case 5063508: return "Microtec";
    case 5063512: return "Millson Custom Solutions Inc.";
    case 5063745: return "Media4 Inc";
    case 5063747: return "Midori Electronics";
    case 5063748: return "MODIS";
    case 5063750: return "MILDEF AB";
    case 5063751: return "Madge Networks";
    case 5063753: return "Micro Design Inc";
    case 5063755: return "Mediatek Corporation";
    case 5063759: return "Panasonic";
    case 5063762: return "Medar Inc";
    case 5063763: return "Micro Display Systems Inc";
    case 5063764: return "Magus Data Tech";
    case 5063766: return "MET Development Inc";
    case 5063768: return "MicroDatec GmbH";
    case 5063769: return "Microdyne Inc";
    case 5064003: return "Mega System Technologies Inc";
    case 5064004: return "Messeltronik Dresden GmbH";
    case 5064005: return "Mitsubishi Electric Engineering Co., Ltd.";
    case 5064007: return "Abeam Tech Ltd.";
    case 5064009: return "Panasonic Industry Company";
    case 5064010: return "Mac\055Eight Co., LTD.";
    case 5064011: return "Mediaedge Corporation";
    case 5064012: return "Mitsubishi Electric Corporation";
    case 5064014: return "MEN Mikroelectronik Nueruberg GmbH";
    case 5064016: return "Meld Technology";
    case 5064017: return "Matelect Ltd.";
    case 5064020: return "Metheus Corporation";
    case 5064021: return "MPL AG, Elektronik\055Unternehmen";
    case 5064024: return "MSC Vertriebs GmbH";
    case 5064263: return "MicroField Graphics Inc";
    case 5064265: return "Micro Firmware";
    case 5064274: return "MediaFire Corp.";
    case 5064513: return "Mega System Technologies, Inc.";
    case 5064515: return "Mentor Graphics Corporation";
    case 5064517: return "Schneider Electric S.A.";
    case 5064524: return "M\055G Technology Ltd";
    case 5064532: return "Megatech R \046 D Company";
    case 5064785: return "Moxa Inc.";
    case 5065027: return "Micom Communications Inc";
    case 5065028: return "miro Displays";
    case 5065033: return "Mitec Inc";
    case 5065036: return "Marconi Instruments Ltd";
    case 5065037: return "Mimio \20023 A Newell Rubbermaid Company";
    case 5065038: return "Minicom Digital Signage";
    case 5065040: return "micronpc.com";
    case 5065042: return "Miro Computer Prod.";
    case 5065043: return "Modular Industrial Solutions Inc";
    case 5065044: return "MCM Industrial Technology GmbH";
    case 5065046: return "MicroImage Video Systems";
    case 5065289: return "MARANTZ JAPAN, INC.";
    case 5065299: return "MJS Designs";
    case 5065539: return "Media Tek Inc.";
    case 5065555: return "MK Seiko Co., Ltd.";
    case 5065556: return "MICROTEK Inc.";
    case 5065558: return "Trtheim Technology";
    case 5065795: return "MILCOTS";
    case 5065796: return "Deep Video Imaging Ltd";
    case 5065799: return "Micrologica AG";
    case 5065801: return "McIntosh Laboratory Inc.";
    case 5065804: return "Millogic Ltd.";
    case 5065805: return "Millennium Engineering Inc";
    case 5065806: return "Mark Levinson";
    case 5065808: return "Magic Leap";
    case 5065811: return "Milestone EPE";
    case 5065812: return "Wanlida Group Co., Ltd.";
    case 5065816: return "Mylex Corporation";
    case 5066049: return "Micromedia AG";
    case 5066052: return "Micromed Biotecnologia Ltd";
    case 5066054: return "Minnesota Mining and Manufacturing";
    case 5066057: return "Multimax";
    case 5066061: return "Electronic Measurements";
    case 5066062: return "MiniMan Inc";
    case 5066067: return "MMS Electronics";
    case 5066068: return "MIMO Monitors";
    case 5066307: return "Mini Micro Methods Ltd";
    case 5066313: return "Marseille, Inc.";
    case 5066316: return "Monorail Inc";
    case 5066320: return "Microcom";
    case 5066323: return "Maxnerva Technology Services Limited";
    case 5066563: return "Matrix Orbital Corporation";
    case 5066564: return "Modular Technology";
    case 5066571: return "Moka International limited";
    case 5066573: return "Momentum Data Systems";
    case 5066579: return "Moses Corporation";
    case 5066580: return "Motorola UDS";
    case 5066819: return "M\055Pact Inc";
    case 5066825: return "Mediatrix Peripherals Inc";
    case 5066826: return "Microlab";
    case 5066828: return "Maple Research Inst. Company Ltd";
    case 5066830: return "Mainpine Limited";
    case 5066835: return "mps Software GmbH";
    case 5066838: return "Megapixel Visual Realty";
    case 5066840: return "Micropix Technologies, Ltd.";
    case 5067088: return "MultiQ Products AB";
    case 5067329: return "Miranda Technologies Inc";
    case 5067331: return "Marconi Simulation \046 Ty\055Coch Way Training";
    case 5067332: return "MicroDisplay Corporation";
    case 5067335: return "Nreal";
    case 5067339: return "Maruko \046 Company Ltd";
    case 5067340: return "Miratel";
    case 5067343: return "Medikro Oy";
    case 5067348: return "Merging Technologies";
    case 5067585: return "Micro Systemation AB";
    case 5067587: return "Mouse Systems Corporation";
    case 5067588: return "Datenerfassungs\055 und Informationssysteme";
    case 5067590: return "M\055Systems Flash Disk Pioneers";
    case 5067591: return "MSI GmbH";
    case 5067592: return "Microsoft";
    case 5067593: return "Microstep";
    case 5067595: return "Megasoft Inc";
    case 5067596: return "MicroSlate Inc.";
    case 5067597: return "Advanced Digital Systems";
    case 5067600: return "Mistral Solutions \133P\135 Ltd.";
    case 5067602: return "MASPRO DENKOH Corp.";
    case 5067604: return "MS Telematica";
    case 5067605: return "motorola";
    case 5067606: return "Mosgi Corporation";
    case 5067608: return "Micomsoft Co., Ltd.";
    case 5067609: return "MicroTouch Systems Inc";
    case 5067841: return "Meta Watch Ltd";
    case 5067842: return "Media Technologies Ltd.";
    case 5067843: return "Mars\055Tech Corporation";
    case 5067844: return "MindTech Display Co. Ltd";
    case 5067845: return "MediaTec GmbH";
    case 5067848: return "Micro\055Tech Hearing Instruments";
    case 5067849: return "MaxCom Technical Inc";
    case 5067850: return "MicroTechnica Co.,Ltd.";
    case 5067851: return "Microtek International Inc.";
    case 5067852: return "Mitel Corporation";
    case 5067853: return "Motium";
    case 5067854: return "Mtron Storage Technology Co., Ltd.";
    case 5067858: return "Mitron computer Inc";
    case 5067859: return "Multi\055Tech Systems";
    case 5067860: return "Moore Threads Virtual Display";
    case 5067861: return "Mark of the Unicorn Inc";
    case 5067864: return "Matrox";
    case 5068100: return "Multi\055Dimension Institute";
    case 5068107: return "Mainpine Limited";
    case 5068356: return "Microvitec PLC";
    case 5068361: return "Media Vision Inc";
    case 5068365: return "SOBO VISION";
    case 5068366: return "Meta Company";
    case 5068370: return "MediCapture, Inc.";
    case 5068371: return "Microvision";
    case 5068376: return "COM 1";
    case 5068617: return "Multiwave Innovation Pte Ltd";
    case 5068626: return "mware";
    case 5068633: return "Microway Inc";
    case 5068868: return "MaxData Computer GmbH \046 Co.KG";
    case 5068873: return "Macronix Inc";
    case 5068876: return "Hitachi Maxell, Ltd.";
    case 5068877: return "C\046T Solution Inc.";
    case 5068880: return "Maxpeed Corporation";
    case 5068884: return "Maxtech Corporation";
    case 5068886: return "MaxVision Corporation";
    case 5069121: return "Monydata";
    case 5069138: return "Myriad Solutions Ltd";
    case 5069144: return "Micronyx Inc";
    case 5128515: return "Ncast Corporation";
    case 5128516: return "NAD Electronics";
    case 5128518: return "NAFASAE INDIA Pvt. Ltd";
    case 5128523: return "Nakano Engineering Co.,Ltd.";
    case 5128524: return "Network Alchemy";
    case 5128532: return "NaturalPoint Inc.";
    case 5128534: return "Navigation Corporation";
    case 5128536: return "Naxos Tecnologia";
    case 5128780: return "N\052Able Technologies Inc";
    case 5128787: return "National Key Lab. on ISN";
    case 5128788: return "NingBo Bestwinning Technology CO., Ltd";
    case 5129025: return "Nixdorf Company";
    case 5129027: return "NCR Corporation";
    case 5129029: return "Norcent Technology, Inc.";
    case 5129033: return "NewCom Inc";
    case 5129036: return "NetComm Ltd";
    case 5129040: return "Najing CEC Panda FPD Technology CO. ltd";
    case 5129042: return "NCR Electronics";
    case 5129043: return "Northgate Computer Systems";
    case 5129044: return "NEC CustomTechnica, Ltd.";
    case 5129046: return "NewCoSemi \050Beijing\051 Technology CO.,Ltd.";
    case 5129283: return "National DataComm Corporaiton";
    case 5129286: return "NDF Special Light Products B.V.";
    case 5129289: return "National Display Systems";
    case 5129291: return "Naitoh Densei CO., LTD.";
    case 5129292: return "Network Designers";
    case 5129299: return "Nokia Data";
    case 5129539: return "NEC Corporation";
    case 5129551: return "NEO TELECOM CO.,LTD.";
    case 5129555: return "INNES";
    case 5129556: return "Mettler Toledo";
    case 5129557: return "NEUROTEC \055 EMPRESA DE PESQUISA E DESENVOLVIMENTO EM BIOMEDICINA";
    case 5129560: return "Nexgen Mediatech Inc.,";
    case 5129795: return "BTC Korea Co., Ltd";
    case 5129811: return "Number Five Software";
    case 5130051: return "Network General";
    case 5130067: return "A D S Exports";
    case 5130307: return "New H3C Technology Co., Ltd.";
    case 5130324: return "Vinci Labs";
    case 5130563: return "National Instruments Corporation";
    case 5130579: return "Nissei Electric Company";
    case 5130580: return "Network Info Technology";
    case 5130584: return "Seanix Technology Inc";
    case 5131331: return "Next Level Communications";
    case 5131589: return "Navico, Inc.";
    case 5131600: return "Nokia Mobile Phones";
    case 5131603: return "Natural Micro System";
    case 5131606: return "NEC\055Mitsubishi Electric Visual Systems Corporation";
    case 5131608: return "Neomagic";
    case 5131843: return "NNC";
    case 5132100: return "3NOD Digital Technology Co. Ltd.";
    case 5132101: return "NordicEye AB";
    case 5132105: return "North Invent A\057S";
    case 5132107: return "Nokia Display Products";
    case 5132114: return "Norand Corporation";
    case 5132116: return "Not Limited Inc";
    case 5132353: return "Arvanics";
    case 5132361: return "Network Peripherals Inc";
    case 5132873: return "Noritake Itron Corporation";
    case 5132876: return "U.S. Naval Research Lab";
    case 5132884: return "Beijing Northern Radiantelecom Co.";
    case 5132886: return "Taugagreining hf";
    case 5133121: return "NeuroSky, Inc.";
    case 5133123: return "National Semiconductor Corporation";
    case 5133129: return "NISSEI ELECTRIC CO.,LTD";
    case 5133136: return "Nspire System Inc.";
    case 5133139: return "Newport Systems Solutions";
    case 5133140: return "Network Security Technology Co";
    case 5133379: return "NeoTech S.R.L";
    case 5133385: return "New Tech Int\047l Company";
    case 5133387: return "NewTek";
    case 5133388: return "National Transcomm. Ltd";
    case 5133390: return "Nuvoton Technology Corporation";
    case 5133394: return "N\055trig Innovative Technologies, Inc.";
    case 5133395: return "Nits Technology Inc.";
    case 5133396: return "NTT Advanced Technology Corporation";
    case 5133399: return "Networth Inc";
    case 5133400: return "Netaccess Inc";
    case 5133639: return "NU Technology, Inc.";
    case 5133641: return "NU Inc.";
    case 5133891: return "NetVision Corporation";
    case 5133892: return "Nvidia";
    case 5133897: return "NuVision US, Inc.";
    case 5133900: return "Novell Inc";
    case 5133903: return "Netvio Ltd.";
    case 5133906: return "NOLO CO., LTD.";
    case 5133908: return "Navatek Engineering Corporation";
    case 5134147: return "NW Computer Engineering";
    case 5134156: return "Newline Interactive Inc.";
    case 5134160: return "NovaWeb Technologies Inc";
    case 5134163: return "Newisys, Inc.";
    case 5134403: return "NextCom K.K.";
    case 5134405: return "Norxe AS";
    case 5134407: return "Nexgen";
    case 5134416: return "NXP Semiconductors bv.";
    case 5134417: return "Nexiq Technologies, Inc.";
    case 5134418: return "Nextorage Corporation";
    case 5134419: return "Technology Nexus Secure Open Systems AB";
    case 5134420: return "NZXT \050PNP same EDID\051\137";
    case 5134659: return "Nakayo Relecommunications, Inc.";
    case 5194059: return "Oak Tech Inc";
    case 5194067: return "Oasys Technology Company";
    case 5194323: return "Optibase Technologies";
    case 5194564: return "Macraigor Systems Inc";
    case 5194574: return "Olfan";
    case 5194579: return "Open Connect Solutions";
    case 5194829: return "ODME Inc.";
    case 5194834: return "Odrac";
    case 5195075: return "ORION ELECTRIC CO.,LTD";
    case 5195081: return "Optum Engineering Inc.";
    case 5195337: return "Jiangxi Jinghao Optical Co., Ltd.";
    case 5195863: return "M\055Labs Limited";
    case 5196099: return "Option Industrial Computers";
    case 5196109: return "Option International";
    case 5196110: return "Option International";
    case 5196617: return "OKI Electric Industrial Company Ltd";
    case 5196867: return "Olicom A\057S";
    case 5196868: return "Olidata S.p.A.";
    case 5196873: return "Olivetti";
    case 5196884: return "Olitec S.A.";
    case 5196886: return "Olitec S.A.";
    case 5196889: return "OLYMPUS CORPORATION";
    case 5197123: return "OBJIX Multimedia Corporation";
    case 5197127: return "RODE";
    case 5197134: return "Omnitel";
    case 5197138: return "Omron Corporation";
    case 5197381: return "Oneac Corporation";
    case 5197387: return "ONKYO Corporation";
    case 5197388: return "OnLive, Inc";
    case 5197395: return "On Systems Inc";
    case 5197399: return "OPEN Networks Ltd";
    case 5197400: return "SOMELEC Z.I. Du Vert Galanta";
    case 5197651: return "OSRAM";
    case 5197891: return "Opcode Inc";
    case 5197897: return "D.N.S. Corporation";
    case 5197904: return "OPPO Digital, Inc.";
    case 5197908: return "OPTi Inc";
    case 5197910: return "Optivision Inc";
    case 5198153: return "Oksori Company Ltd";
    case 5198407: return "ORGA Kartensysteme GmbH";
    case 5198409: return "OSR Open Systems Resources, Inc.";
    case 5198414: return "ORION ELECTRIC CO., LTD.";
    case 5198657: return "OSAKA Micro Computer, Inc.";
    case 5198660: return "Optical Systems Design Pty Ltd";
    case 5198665: return "Open Stack, Inc.";
    case 5198672: return "OPTI\055UPS Corporation";
    case 5198674: return "Oksori Company Ltd";
    case 5198914: return "outsidetheboxstuff.com";
    case 5198921: return "Orchid Technology";
    case 5198923: return "OmniTek";
    case 5198925: return "Optoma Corporation";
    case 5198932: return "OPTO22, Inc.";
    case 5199179: return "OUK Company Ltd";
    case 5199442: return "Oculus VR, Inc.";
    case 5199692: return "Mediacom Technologies Pte Ltd";
    case 5199957: return "Oxus Research S.A.";
    case 5200207: return "Shadow Systems";
    case 5200451: return "OZ Corporation";
    case 5200452: return "OZO Co.Ltd";
    case 5200463: return "Tribe Computer Works Inc";
    case 5259587: return "Pacific Avionics Corporation";
    case 5259588: return "Promotion and Display Technology Ltd.";
    case 5259589: return "PreSonus Audio Electronics";
    case 5259595: return "Many CNC System Co., Ltd.";
    case 5259597: return "Peter Antesberger Messtechnik";
    case 5259598: return "The Panda Project";
    case 5259602: return "Parallan Comp Inc";
    case 5259849: return "Pitney Bowes";
    case 5259852: return "Packard Bell Electronics";
    case 5259854: return "Packard Bell NEC";
    case 5259862: return "Pitney Bowes";
    case 5260097: return "Philips BU Add On Card";
    case 5260098: return "OCTAL S.A.";
    case 5260099: return "PowerCom Technology Company Ltd";
    case 5260103: return "First Industrial Computer Inc";
    case 5260105: return "Pioneer Computer Inc";
    case 5260107: return "PCBANK21";
    case 5260108: return "pentel.co.,ltd";
    case 5260109: return "PCM Systems Corporation";
    case 5260111: return "Performance Concepts Inc.,";
    case 5260112: return "Procomp USA Inc";
    case 5260115: return "TOSHIBA PERSONAL COMPUTER SYSTEM CORPRATION";
    case 5260116: return "PC\055Tel Inc";
    case 5260119: return "Pacific CommWare Inc";
    case 5260120: return "PC Xperten";
    case 5260365: return "Psion Dacom Plc.";
    case 5260366: return "AT\046T Paradyne";
    case 5260370: return "Pure Data Inc";
    case 5260371: return "PD Systems International Ltd";
    case 5260372: return "PDTS \055 Prozessdatentechnik und Systeme";
    case 5260374: return "Prodrive B.V.";
    case 5260611: return "POTRANS Electrical Corp.";
    case 5260615: return "Pegatron Corporation";
    case 5260617: return "PEI Electronics Inc";
    case 5260620: return "Primax Electric Ltd";
    case 5260622: return "Interactive Computer Products Inc";
    case 5260624: return "Peppercon AG";
    case 5260626: return "Perceptive Signal Technologies";
    case 5260628: return "Practical Electronic Tools";
    case 5260884: return "Telia ProSoft AB";
    case 5261129: return "PACSGEAR, Inc.";
    case 5261133: return "Paradigm Advanced Research Centre";
    case 5261136: return "propagamma kommunikation";
    case 5261139: return "Princeton Graphic Systems";
    case 5261379: return "Pijnenburg Beheer N.V.";
    case 5261381: return "Philips Medical Systems Boeblingen GmbH";
    case 5261385: return "Invalid Vendor Codename \055 PHI";
    case 5261388: return "Philips Consumer Electronics Company";
    case 5261391: return "Photonics Systems Inc.";
    case 5261395: return "Philips Communication Systems";
    case 5261401: return "Phylon Communications";
    case 5261635: return "Picturall Ltd.";
    case 5261637: return "Pacific Image Electronics Company Ltd";
    case 5261645: return "Prism, LLC";
    case 5261647: return "Pioneer Electronic Corporation";
    case 5261650: return "Pico Technology Inc.";
    case 5261651: return "TECNART CO.,LTD.";
    case 5261656: return "Pixie Tech Inc";
    case 5261889: return "Projecta";
    case 5261892: return "Projectiondesign AS";
    case 5261908: return "Pan Jit International Inc.";
    case 5262145: return "Acco UK Ltd.";
    case 5262403: return "Pro\055Log Corporation";
    case 5262406: return "Panasonic Avionics Corporation";
    case 5262413: return "PROLINK Microsystems Corp.";
    case 5262420: return "PT Hartono Istana Teknologi";
    case 5262422: return "PLUS Vision Corp.";
    case 5262424: return "Parallax Graphics";
    case 5262425: return "Polycom Inc.";
    case 5262659: return "PMC Consumer Electronics Ltd";
    case 5262660: return "TDK USA Corporation";
    case 5262669: return "Point Multimedia System";
    case 5262675: return "Pabian Embedded Systems";
    case 5262676: return "Promate Electronic Co., Ltd.";
    case 5262680: return "Photomatrix";
    case 5262919: return "Microsoft";
    case 5262924: return "Panelview, Inc.";
    case 5262928: return "Microsoft";
    case 5262930: return "Planar Systems, Inc.";
    case 5262931: return "PanaScope";
    case 5262932: return "HOYA Corporation PENTAX Lifecare Division";
    case 5262936: return "Phoenix Technologies, Ltd.";
    case 5263180: return "PolyComp \050PTY\051 Ltd.";
    case 5263182: return "Perpetual Technologies, LLC";
    case 5263186: return "Portalis LC";
    case 5263187: return "Positivo Tecnologia S.A.";
    case 5263188: return "Parrot";
    case 5263427: return "Phoenixtec Power Company Ltd";
    case 5263428: return "MEPhI";
    case 5263433: return "Practical Peripherals";
    case 5263437: return "Clinton Electronics Corp.";
    case 5263440: return "Purup Prepress AS";
    case 5263442: return "PicPro";
    case 5263448: return "Perceptive Pixel Inc.";
    case 5263689: return "Pixel Qi";
    case 5263937: return "PRO\057AUTOMATION";
    case 5263939: return "PerComm";
    case 5263940: return "Praim S.R.L.";
    case 5263942: return "Schneider Electric Japan Holdings, Ltd.";
    case 5263943: return "The Phoenix Research Group Inc";
    case 5263945: return "Priva Hortimation BV";
    case 5263949: return "Prometheus";
    case 5263951: return "Proteon";
    case 5263952: return "UEFI Forum";
    case 5263955: return "Leutron Vision";
    case 5263956: return "Parade Technologies, Ltd.";
    case 5263960: return "Proxima Corporation";
    case 5264193: return "Advanced Signal Processing Technologies";
    case 5264195: return "Philips Semiconductors";
    case 5264196: return "Peus\055Systems GmbH";
    case 5264197: return "Practical Solutions Pte., Ltd.";
    case 5264201: return "PSI\055Perceptive Solutions Inc";
    case 5264204: return "Perle Systems Limited";
    case 5264205: return "Prosum";
    case 5264212: return "Global Data SA";
    case 5264217: return "Prodea Systems Inc.";
    case 5264449: return "PAR Tech Inc.";
    case 5264451: return "PS Technology Corporation";
    case 5264455: return "Cipher Systems Inc";
    case 5264456: return "Pathlight Technology Inc";
    case 5264457: return "Promise Technology Inc";
    case 5264460: return "Pantel Inc";
    case 5264467: return "Plain Tree Systems Inc";
    case 5264471: return "Invalid Vendor Codename \055 PTW";
    case 5264472: return "Printronix LLC";
    case 5264716: return "Pulse\055Eight Ltd";
    case 5264963: return "Invalid Vendor Codename \055 PVC";
    case 5264967: return "Proview Global Co., Ltd";
    case 5264969: return "Prime view international Co., Ltd";
    case 5264973: return "Penta Studiotechnik GmbH";
    case 5264974: return "Pixel Vision";
    case 5264976: return "Klos Technologies, Inc.";
    case 5264978: return "Pimax Tech. CO., LTD";
    case 5265475: return "Phoenix Contact";
    case 5265477: return "PIXELA CORPORATION";
    case 5265484: return "The Moving Pixel Company";
    case 5265485: return "Proxim Inc";
    case 5265486: return "PixelNext Inc";
    case 5265487: return "Pixio USA";
    case 5325635: return "QuakeCom Company Ltd";
    case 5325640: return "Metronics Inc";
    case 5325641: return "Quanta Computer Inc";
    case 5325643: return "Quick Corporation";
    case 5325644: return "Quadrant Components Inc";
    case 5325648: return "Qualcomm Inc";
    case 5325897: return "Quantum Data Incorporated";
    case 5325900: return "QD Laser, Inc.";
    case 5325901: return "Quadram";
    case 5325907: return "Quanta Display Inc.";
    case 5326406: return "Padix Co., Inc.";
    case 5326409: return "Quickflex, Inc";
    case 5327939: return "Q\055Logic";
    case 5329233: return "Chuomusen Co., Ltd.";
    case 5329731: return "QSC, LLC";
    case 5329737: return "Quantum Solutions, Inc.";
    case 5329988: return "Quantum 3D Inc";
    case 5329992: return "Questech Ltd";
    case 5329993: return "Quicknet Technologies Inc";
    case 5329997: return "Quantum";
    case 5330002: return "Qtronix Corporation";
    case 5330241: return "Quatographic AG";
    case 5330245: return "Questra Consulting";
    case 5330517: return "Quartics";
    case 5390659: return "Racore Computer Products Inc";
    case 5390660: return "Radisys Corporation";
    case 5390665: return "Rockwell Automation\057Intecolor";
    case 5390670: return "Rancho Tech Inc";
    case 5390674: return "Raritan, Inc.";
    case 5390675: return "RAScom Inc";
    case 5390676: return "Rent\055A\055Tech";
    case 5390681: return "Raylar Design, Inc.";
    case 5391173: return "Parc d\047Activite des Bellevues";
    case 5391176: return "Reach Technology Inc";
    case 5391177: return "RC International";
    case 5391182: return "Radio Consult SRL";
    case 5391183: return "Rockwell Collins";
    case 5391433: return "Rainbow Displays, Inc.";
    case 5391436: return "Riedel Communications Canada Inc.";
    case 5391437: return "Tremon Enterprises Company Ltd";
    case 5391438: return "RADIODATA GmbH";
    case 5391443: return "Radius Inc";
    case 5391681: return "Real D";
    case 5391683: return "ReCom";
    case 5391684: return "Research Electronics Development Inc";
    case 5391686: return "Reflectivity, Inc.";
    case 5391688: return "Rehan Electronics Ltd.";
    case 5391692: return "Reliance Electric Ind Corporation";
    case 5391693: return "SCI Systems Inc.";
    case 5391694: return "Renesas Technology Corp.";
    case 5391699: return "ResMed Pty Ltd";
    case 5391700: return "Resonance Technology, Inc.";
    case 5391702: return "Revolution Display, Inc.";
    case 5391704: return "RATOC Systems, Inc.";
    case 5391945: return "RAFI GmbH \046 Co. KG";
    case 5391960: return "Redfox Technologies Inc.";
    case 5392194: return "RGB Spectrum";
    case 5392204: return "Robertson Geologging Ltd";
    case 5392452: return "RightHand Technologies";
    case 5392461: return "Rohm Company Ltd";
    case 5392468: return "Red Hat, Inc.";
    case 5392707: return "RICOH COMPANY, LTD.";
    case 5392713: return "Racal Interlan Inc";
    case 5392719: return "Rios Systems Company Ltd";
    case 5392724: return "Ritech Inc";
    case 5392726: return "Rivulet Communications";
    case 5392961: return "Roland Corporation";
    case 5392979: return "Advanced Engineering";
    case 5393219: return "Reakin Technolohy Corporation";
    case 5393476: return "MEPCO";
    case 5393486: return "RadioLAN Inc";
    case 5393731: return "Raritan Computer, Inc";
    case 5393744: return "Research Machines";
    case 5393747: return "Shenzhen Ramos Digital Technology Co., Ltd";
    case 5393748: return "Roper Mobile";
    case 5393986: return "Rainbow Technologies";
    case 5393996: return "Reonel Oy";
    case 5394242: return "Robust Electronics GmbH";
    case 5394248: return "Rohm Co., Ltd.";
    case 5394251: return "Rockwell International";
    case 5394256: return "Roper International Ltd";
    case 5394259: return "Rohde \046 Schwarz";
    case 5394505: return "RoomPro Technologies";
    case 5394508: return "Raspberry PI";
    case 5394516: return "R.P.T.Intergroups";
    case 5395017: return "Radicom Research Inc";
    case 5395023: return "AVARRO";
    case 5395267: return "PhotoTelesis";
    case 5395272: return "ADC\055Centre";
    case 5395273: return "Rampage Systems Inc";
    case 5395278: return "Radiospire Networks, Inc.";
    case 5395281: return "R Squared";
    case 5395282: return "Zhong Shan City Richsound Electronic Industrial Ltd.";
    case 5395283: return "Rockwell Semiconductor Systems";
    case 5395286: return "Ross Video Ltd";
    case 5395288: return "Rapid Tech Corporation";
    case 5395523: return "Relia Technologies";
    case 5395529: return "Rancho Tech Inc";
    case 5395531: return "Invalid Vendor Codename \055 RTK";
    case 5395532: return "Realtek Semiconductor Company Ltd";
    case 5395539: return "Raintree Systems";
    case 5395790: return "RUNCO International";
    case 5395792: return "Ups Manufactoring s.r.l.";
    case 5396035: return "RSI Systems Inc";
    case 5396041: return "Realvision Inc";
    case 5396044: return "Reveal Computer Prod";
    case 5396291: return "Red Wing Corporation";
    case 5396564: return "Tectona SoftSolutions \050P\051 Ltd.,";
    case 5397074: return "Razer Taiwan Co. Ltd.";
    case 5397075: return "Rozsnyó, s.r.o.";
    case 5456193: return "Sanritz Automation Co.,Ltd.";
    case 5456197: return "Saab Aerotech";
    case 5456199: return "Sedlbauer";
    case 5456201: return "Sage Inc";
    case 5456203: return "Saitek Ltd";
    case 5456205: return "Samsung Electric Company";
    case 5456206: return "Sanyo Electric Co.,Ltd.";
    case 5456211: return "Stores Automated Systems Inc";
    case 5456212: return "Shuttle Tech";
    case 5456451: return "Shanghai Bell Telephone Equip Mfg Co";
    case 5456452: return "Softbed \055 Consulting \046 Development Ltd";
    case 5456457: return "SMART Technologies Inc.";
    case 5456467: return "SBS\055or Industrial Computers GmbH";
    case 5456468: return "Senseboard Technologies AB";
    case 5456705: return "Schneider Consumer Group";
    case 5456706: return "SeeCubic B.V.";
    case 5456707: return "SORD Computer Corporation";
    case 5456708: return "Sanyo Electric Company Ltd";
    case 5456709: return "Sun Corporation";
    case 5456711: return "Seco S.p.A.";
    case 5456712: return "Schlumberger Cards";
    case 5456713: return "System Craft";
    case 5456716: return "Sigmacom Co., Ltd.";
    case 5456717: return "SCM Microsystems Inc";
    case 5456718: return "Scanport, Inc.";
    case 5456719: return "SORCUS Computer GmbH";
    case 5456720: return "Scriptel Corporation";
    case 5456722: return "Systran Corporation";
    case 5456723: return "Nanomach Anstalt";
    case 5456724: return "Smart Card Technology";
    case 5456728: return "Socionext Inc.";
    case 5456961: return "SAT \050Societe Anonyme\051";
    case 5456963: return "Samsung Display Corp.";
    case 5456964: return "Intrada\055SDD Ltd";
    case 5456965: return "Sherwood Digital Electronics Corporation";
    case 5456966: return "SODIFF E\046T CO., Ltd.";
    case 5456968: return "Communications Specialies, Inc.";
    case 5456969: return "Samtron Displays Inc";
    case 5456971: return "SAIT\055Devlonics";
    case 5456978: return "SDR Systems";
    case 5456979: return "SunRiver Data System";
    case 5456980: return "Siemens AG";
    case 5456984: return "SDX Business Systems Ltd";
    case 5457217: return "Seanix Technology Inc.";
    case 5457218: return "system elektronik GmbH";
    case 5457219: return "Seiko Epson Corporation";
    case 5457221: return "SeeColor Corporation";
    case 5457223: return "Invalid Vendor Codename \055 SEG";
    case 5457225: return "Seitz \046 Associates Inc";
    case 5457228: return "Way2Call Communications";
    case 5457229: return "Samsung Electronics Company Ltd";
    case 5457230: return "Sencore";
    case 5457231: return "SEOS Ltd";
    case 5457232: return "SEP Eletronica Ltda.";
    case 5457234: return "Sony Ericsson Mobile Communications Inc.";
    case 5457235: return "Session Control LLC";
    case 5457236: return "SendTek Corporation";
    case 5457484: return "Shiftall Inc.";
    case 5457485: return "TORNADO Company";
    case 5457492: return "Mikroforum Ring 3";
    case 5457731: return "Spectragraphics Corporation";
    case 5457732: return "Sigma Designs, Inc.";
    case 5457733: return "Kansai Electric Company Ltd";
    case 5457737: return "Scan Group Ltd";
    case 5457740: return "Super Gate Technology Company Ltd";
    case 5457741: return "SAGEM";
    case 5457742: return "Shenzhen Soogeen Electronics Co., LTD.";
    case 5457743: return "Logos Design A\057S";
    case 5457748: return "Stargate Technology";
    case 5457751: return "Shanghai Guowei Science and Technology Co., Ltd.";
    case 5457752: return "Silicon Graphics Inc";
    case 5457754: return "Systec Computer GmbH";
    case 5457987: return "ShibaSoku Co., Ltd.";
    case 5457991: return "Soft \046 Hardware development Goldammer GmbH";
    case 5457993: return "Jiangsu Shinco Electronic Group Co., Ltd";
    case 5458000: return "Sharp Corporation";
    case 5458002: return "Digital Discovery";
    case 5458004: return "Shin Ho Tech";
    case 5458005: return "Shure Inc.";
    case 5458241: return "SIEMENS AG";
    case 5458242: return "Sanyo Electric Company Ltd";
    case 5458243: return "Sysmate Corporation";
    case 5458244: return "Seiko Instruments Information Devices Inc";
    case 5458245: return "Siemens";
    case 5458247: return "Sigma Designs Inc";
    case 5458249: return "Silicon Image, Inc.";
    case 5458252: return "Silicon Laboratories, Inc";
    case 5458253: return "S3 Inc";
    case 5458254: return "Singular Technology Co., Ltd.";
    case 5458258: return "Sirius Technologies Pty Ltd";
    case 5458259: return "Silicon Integrated Systems Corporation";
    case 5458260: return "Sitintel";
    case 5458261: return "Seiko Instruments USA Inc";
    case 5458264: return "Zuniq Data Corporation";
    case 5458501: return "Sejin Electron Inc";
    case 5458756: return "Schneider \046 Koch";
    case 5458759: return "Shenzhen KTC Technology Group";
    case 5458761: return "LLC SKTB \20034SKIT\20035";
    case 5458765: return "Guangzhou Teclast Information Technology Limited";
    case 5458772: return "Samsung Electro\055Mechanics Company Ltd";
    case 5458775: return "Skyworth";
    case 5458777: return "SKYDATA S.P.A.";
    case 5459009: return "Systeme Lauer GmbH\046Co KG";
    case 5459010: return "Shlumberger Ltd";
    case 5459011: return "Syslogic Datentechnik AG";
    case 5459014: return "StarLeaf";
    case 5459016: return "Silicon Library Inc.";
    case 5459017: return "Symbios Logic Inc";
    case 5459019: return "Silitek Corporation";
    case 5459021: return "Solomon Technology Corporation";
    case 5459026: return "Schlumberger Technology Corporate";
    case 5459027: return "Schnick\055Schnack\055Systems GmbH";
    case 5459028: return "Salt Internatioinal Corp.";
    case 5459032: return "Specialix";
    case 5459265: return "SMART Modular Technologies";
    case 5459266: return "Schlumberger";
    case 5459267: return "Standard Microsystems Corporation";
    case 5459269: return "Sysmate Company";
    case 5459273: return "SpaceLabs Medical Inc";
    case 5459275: return "SMK CORPORATION";
    case 5459276: return "Sumitomo Metal Industries, Ltd.";
    case 5459277: return "Shark Multimedia Inc";
    case 5459278: return "Somnium Space Ltd.";
    case 5459279: return "STMicroelectronics";
    case 5459280: return "Simple Computing";
    case 5459282: return "B.\046 V. s.r.l.";
    case 5459283: return "Silicom Multimedia Systems Inc";
    case 5459284: return "Silcom Manufacturing Tech Inc";
    case 5459523: return "Sentronic International Corp.";
    case 5459529: return "Siemens Microdesign GmbH";
    case 5459531: return "S\046K Electronics";
    case 5459534: return "SUNNY ELEKTRONIK";
    case 5459535: return "SINOSUN TECHNOLOGY CO., LTD";
    case 5459536: return "Siemens Nixdorf Info Systems";
    case 5459539: return "Cirtech \050UK\051 Ltd";
    case 5459540: return "SuperNet Inc";
    case 5459542: return "SONOVE GmbH";
    case 5459543: return "Snell \046 Wilcox";
    case 5459544: return "Sonix Comm. Ltd";
    case 5459545: return "Sony";
    case 5459779: return "Santec Corporation";
    case 5459785: return "Silicon Optix Corporation";
    case 5459788: return "Solitron Technologies Inc";
    case 5459790: return "Sony";
    case 5459794: return "Sorcus Computer GmbH";
    case 5459796: return "Sotec Company Ltd";
    case 5459801: return "SOYO Group, Inc";
    case 5460035: return "SpinCore Technologies, Inc";
    case 5460037: return "SPEA Software AG";
    case 5460040: return "G\046W Instruments GmbH";
    case 5460041: return "SPACE\055I Co., Ltd.";
    case 5460043: return "SpeakerCraft";
    case 5460044: return "Smart Silicon Systems Pty Ltd";
    case 5460046: return "Sapience Corporation";
    case 5460047: return "SAMPO CORPORATION";
    case 5460050: return "pmns GmbH";
    case 5460051: return "Synopsys Inc";
    case 5460052: return "Sceptre Tech Inc";
    case 5460053: return "SIM2 Multimedia S.P.A.";
    case 5460056: return "Simplex Time Recorder Co.";
    case 5460308: return "Sequent Computer Systems Inc";
    case 5460547: return "Integrated Tech Express Inc";
    case 5460548: return "Setred";
    case 5460550: return "Surf Communication Solutions Ltd";
    case 5460551: return "Intuitive Surgical, Inc.";
    case 5460563: return "SR\055Systems e.K.";
    case 5460564: return "SeeReal Technologies GmbH";
    case 5460803: return "Sierra Semiconductor Inc";
    case 5460804: return "FlightSafety International";
    case 5460805: return "Samsung Electronic Co.";
    case 5460807: return "Steelseries ApS";
    case 5460809: return "S\055S Technology Inc";
    case 5460810: return "Sankyo Seiki Mfg.co., Ltd";
    case 5460812: return "Shenzhen South\055Top Computer Co., Ltd.";
    case 5460816: return "Spectrum Signal Proecessing Inc";
    case 5460819: return "S3 Inc";
    case 5460820: return "SystemSoft Corporation";
    case 5461057: return "ST Electronics Systems Assembly Pte Ltd";
    case 5461058: return "STB Systems Inc";
    case 5461059: return "STAC Electronics";
    case 5461060: return "STD Computer Inc";
    case 5461061: return "SII Ido\055Tsushin Inc";
    case 5461062: return "Starflight Electronics";
    case 5461063: return "StereoGraphics Corp.";
    case 5461064: return "Semtech Corporation";
    case 5461065: return "Smart Tech Inc";
    case 5461067: return "SANTAK CORP.";
    case 5461068: return "SigmaTel Inc";
    case 5461069: return "SGS Thomson Microelectronics";
    case 5461070: return "Samsung Electronics America";
    case 5461071: return "Stollmann E\053V GmbH";
    case 5461072: return "StreamPlay Ltd";
    case 5461073: return "Synthetel Corporation";
    case 5461074: return "Starlight Networks Inc";
    case 5461075: return "SITECSYSTEM CO., LTD.";
    case 5461076: return "Star Paging Telecom Tech \050Shenzhen\051 Co. Ltd.";
    case 5461077: return "Sentelic Corporation";
    case 5461078: return "Beijing Guochengwantong Information Technology Co., Ltd.";
    case 5461079: return "Starwin Inc.";
    case 5461080: return "ST\055Ericsson";
    case 5461081: return "SDS Technologies";
    case 5461314: return "Subspace Comm. Inc";
    case 5461325: return "Summagraphics Corporation";
    case 5461326: return "Sun Electronics Corporation";
    case 5461328: return "Supra Corporation";
    case 5461330: return "Surenam Computer Corporation";
    case 5461569: return "SGEG";
    case 5461571: return "Intellix Corp.";
    case 5461572: return "SVD Computer";
    case 5461577: return "Sun Microsystems";
    case 5461586: return "Sensics, Inc.";
    case 5461587: return "SVSI";
    case 5461588: return "SEVIT Co., Ltd.";
    case 5461827: return "Software Café";
    case 5461833: return "Sierra Wireless Inc.";
    case 5461836: return "Sharedware Ltd";
    case 5461839: return "Guangzhou Shirui Electronics Co., Ltd.";
    case 5461843: return "Static";
    case 5461844: return "Software Technologies Group,Inc.";
    case 5462082: return "Syntax\055Brillian";
    case 5462084: return "Silex technology, Inc.";
    case 5462087: return "SELEX GALILEO";
    case 5462089: return "Silex Inside";
    case 5462092: return "SolutionInside";
    case 5462100: return "SHARP TAKAYA ELECTRONIC INDUSTRY CO.,LTD.";
    case 5462339: return "Sysmic";
    case 5462341: return "SY Electronics Ltd";
    case 5462347: return "Stryker Communications";
    case 5462348: return "Sylvania Computer Products";
    case 5462349: return "Symicron Computer Communications Ltd.";
    case 5462350: return "Synaptics Inc";
    case 5462352: return "SYPRO Co Ltd";
    case 5462355: return "Sysgration Ltd";
    case 5462356: return "Seyeon Tech Company Ltd";
    case 5462358: return "SYVAX Inc";
    case 5462360: return "Prime Systems, Inc.";
    case 5462605: return "Shenzhen MTC Co., Ltd";
    case 5521729: return "Tandberg";
    case 5521730: return "Todos Data System AB";
    case 5521735: return "Teles AG";
    case 5521737: return "Toshiba America Info Systems Inc";
    case 5521741: return "Tamura Seisakusyo Ltd";
    case 5521747: return "Taskit Rechnertechnik GmbH";
    case 5521748: return "Teleliaison Inc";
    case 5521750: return "Thales Avionics";
    case 5521752: return "Taxan \050Europe\051 Ltd";
    case 5521986: return "Triple S Engineering Inc";
    case 5521987: return "Turbo Communication, Inc";
    case 5522003: return "Turtle Beach System";
    case 5522243: return "Tandon Corporation";
    case 5522244: return "Taicom Data Systems Co., Ltd.";
    case 5522245: return "Century Corporation";
    case 5522246: return "Televic Conference";
    case 5522248: return "Interaction Systems, Inc";
    case 5522249: return "Tulip Computers Int\047l B.V.";
    case 5522250: return "TEAC America Inc";
    case 5522252: return "Technical Concepts Ltd";
    case 5522253: return "3Com Corporation";
    case 5522254: return "Tecnetics \050PTY\051 Ltd";
    case 5522255: return "Thomas\055Conrad Corporation";
    case 5522258: return "Thomson Consumer Electronics";
    case 5522259: return "Tatung Company of America Inc";
    case 5522260: return "Telecom Technology Centre Co. Ltd.";
    case 5522264: return "FREEMARS Heavy Industries";
    case 5522499: return "Teradici";
    case 5522500: return "Tandberg Data Display AS";
    case 5522503: return "Six15 Technologies";
    case 5522509: return "Tandem Computer Europe Inc";
    case 5522512: return "3D Perception";
    case 5522515: return "Tri\055Data Systems Inc";
    case 5522516: return "TDT";
    case 5522518: return "TDVision Systems, Inc.";
    case 5522521: return "Tandy Electronics";
    case 5522753: return "TEAC System Corporation";
    case 5522755: return "Tecmar Inc";
    case 5522763: return "Tektronix Inc";
    case 5522764: return "Promotion and Display Technology Ltd.";
    case 5522766: return "Tencent";
    case 5522770: return "TerraTec Electronic GmbH";
    case 5522772: return "TETRADYNE CO., LTD.";
    case 5522774: return "Televés, S.A.";
    case 5522778: return "Tech Source Inc.";
    case 5523267: return "Toshiba Global Commerce Solutions, Inc.";
    case 5523273: return "TriGem Computer Inc";
    case 5523277: return "TriGem Computer,Inc.";
    case 5523283: return "Torus Systems Ltd";
    case 5523286: return "Grass Valley Germany GmbH";
    case 5523287: return "TECHNOGYM S.p.A.";
    case 5523534: return "Thundercom Holdings Sdn. Bhd.";
    case 5523779: return "Trigem KinfoComm";
    case 5523788: return "Technical Illusions Inc.";
    case 5523792: return "TIPTEL AG";
    case 5523798: return "OOO Technoinvest";
    case 5523800: return "Tixi.Com GmbH";
    case 5524291: return "Taiko Electric Works.LTD";
    case 5524295: return "Tek Gear";
    case 5524302: return "Teknor Microsystem Inc";
    case 5524303: return "TouchKo, Inc.";
    case 5524307: return "TimeKeeping Systems, Inc.";
    case 5524545: return "Ferrari Electronic GmbH";
    case 5524548: return "Telindus";
    case 5524549: return "Zhejiang Tianle Digital Electric Co., Ltd.";
    case 5524550: return "Teleforce.,co,ltd";
    case 5524553: return "TOSHIBA TELI CORPORATION";
    case 5524555: return "Telelink AG";
    case 5524556: return "Thinklogical";
    case 5524558: return "Techlogix Networx";
    case 5524563: return "Teleste Educational OY";
    case 5524564: return "Dai Telecom S.p.A.";
    case 5524566: return "S3 Inc";
    case 5524568: return "Telxon Corporation";
    case 5524569: return "Truly Semiconductors Ltd.";
    case 5524801: return "Tianma Microelectronics Ltd.";
    case 5524803: return "Techmedia Computer Systems Corporation";
    case 5524805: return "AT\046T Microelectronics";
    case 5524809: return "Texas Microsystem";
    case 5524813: return "Time Management, Inc.";
    case 5524815: return "Terumo Corporation";
    case 5524818: return "Taicom International Inc";
    case 5524819: return "Trident Microsystems Ltd";
    case 5524820: return "T\055Metrics Inc.";
    case 5524822: return "TeamViewer Germany GmbH";
    case 5524824: return "Thermotrex Corporation";
    case 5525059: return "TNC Industrial Company Ltd";
    case 5525066: return "Invalid Vendor Codename \055 TNJ";
    case 5525069: return "TECNIMAGEN SA";
    case 5525081: return "Tennyson Tech Pty Ltd";
    case 5525317: return "TOEI Electronics Co., Ltd.";
    case 5525319: return "The OPEN Group";
    case 5525324: return "TCL Corporation";
    case 5525325: return "Ceton Corporation";
    case 5525326: return "TONNA";
    case 5525328: return "Orion Communications Co., Ltd.";
    case 5525331: return "Dynabook Inc.";
    case 5525333: return "Touchstone Technology";
    case 5525571: return "Touch Panel Systems Corporation";
    case 5525572: return "Times \050Shanghai\051 Computer Co., Ltd.";
    case 5525573: return "Technology Power Enterprises Inc";
    case 5525578: return "Junnila";
    case 5525579: return "TOPRE CORPORATION";
    case 5525586: return "Topro Technology Inc";
    case 5525587: return "Teleprocessing Systeme GmbH";
    case 5525588: return "Thruput Ltd";
    case 5525590: return "Top Victory Electronics \050 Fujian \051 Company Ltd";
    case 5525594: return "Ypoaz Systems Inc";
    case 5526081: return "TriTech Microelectronics International";
    case 5526082: return "Triumph Board a.s.";
    case 5526083: return "Trioc AB";
    case 5526084: return "Trident Microsystem Inc";
    case 5526085: return "Tremetrics";
    case 5526089: return "Tricord Systems";
    case 5526092: return "Royal Information";
    case 5526093: return "Tekram Technology Company Ltd";
    case 5526094: return "Datacommunicatie Tron B.V.";
    case 5526096: return "TRAPEZE GROUP";
    case 5526099: return "Torus Systems Ltd";
    case 5526100: return "Tritec Electronic AG";
    case 5526101: return "Aashima Technology B.V.";
    case 5526102: return "Trivisio Prototyping GmbH";
    case 5526104: return "Trex Enterprises";
    case 5526338: return "Toshiba America Info Systems Inc";
    case 5526339: return "Sanyo Electric Company Ltd";
    case 5526340: return "TechniSat Digital GmbH";
    case 5526341: return "Tottori Sanyo Electric";
    case 5526342: return "Racal\055Airtech Software Forge Ltd";
    case 5526343: return "The Software Group Ltd";
    case 5526344: return "ELAN MICROELECTRONICS CORPORATION";
    case 5526345: return "TeleVideo Systems";
    case 5526348: return "Tottori SANYO Electric Co., Ltd.";
    case 5526352: return "U.S. Navy";
    case 5526356: return "Transtream Inc";
    case 5526358: return "TRANSVIDEO";
    case 5526359: return "VRSHOW Technology Limited";
    case 5526361: return "TouchSystems";
    case 5526593: return "Topson Technology Co., Ltd.";
    case 5526594: return "National Semiconductor Japan Ltd";
    case 5526595: return "Telecommunications Techniques Corporation";
    case 5526597: return "TTE, Inc.";
    case 5526601: return "Trenton Terminals Inc";
    case 5526603: return "Totoku Electric Company Ltd";
    case 5526604: return "2\055Tel B.V";
    case 5526608: return "Toshiba Corporation";
    case 5526610: return "Hubei Century Joint Innovation Technology Co.Ltd";
    case 5526611: return "TechnoTrend Systemtechnik GmbH";
    case 5526616: return "Taitex Corporation";
    case 5526617: return "TRIDELITY Display Solutions GmbH";
    case 5526849: return "T\053A elektroakustik GmbH";
    case 5526868: return "Tut Systems";
    case 5527108: return "Tecnovision";
    case 5527113: return "Truevision";
    case 5527116: return "Total Vision LTD";
    case 5527117: return "Taiwan Video \046 Monitor Corporation";
    case 5527119: return "TV One Ltd";
    case 5527122: return "TV Interactive Corporation";
    case 5527123: return "TVS Electronics Limited";
    case 5527126: return "TV1 GmbH";
    case 5527361: return "Tidewater Association";
    case 5527365: return "Kontron Electronik";
    case 5527368: return "Twinhead International Corporation";
    case 5527369: return "Easytel oy";
    case 5527371: return "TOWITOKO electronics GmbH";
    case 5527384: return "TEKWorx Limited";
    case 5527628: return "Trixel Ltd";
    case 5527630: return "Texas Insturments";
    case 5527636: return "Textron Defense System";
    case 5527886: return "Tyan Computer Corporation";
    case 5587283: return "Ultima Associates Pte Ltd";
    case 5587529: return "Ungermann\055Bass Inc";
    case 5587532: return "Ubinetics Ltd.";
    case 5587541: return "Canonical Ltd.";
    case 5588046: return "Uniden Corporation";
    case 5588291: return "Ultima Electronics Corporation";
    case 5588295: return "Elitegroup Computer Systems Company Ltd";
    case 5588297: return "Universal Electronics Inc";
    case 5588308: return "Universal Empowering Technologies";
    case 5588551: return "UNIGRAF\055USA";
    case 5588559: return "UFO Systems Inc";
    case 5588818: return "Ugreen Group Ltd.";
    case 5589058: return "XOCECO";
    case 5589315: return "Uniform Industrial Corporation";
    case 5589586: return "Ueda Japan Radio Co., Ltd.";
    case 5590100: return "Ultra Network Tech";
    case 5590339: return "United Microelectr Corporation";
    case 5590343: return "Umezawa Giken Co.,Ltd";
    case 5590349: return "Universal Multimedia";
    case 5590356: return "UltiMachine";
    case 5590593: return "Unisys DSD";
    case 5590594: return "Unisys Corporation";
    case 5590595: return "Unisys Corporation";
    case 5590596: return "Unisys Corporation";
    case 5590597: return "Unisys Corporation";
    case 5590598: return "Unisys Corporation";
    case 5590601: return "Uniform Industry Corp.";
    case 5590605: return "Unisys Corporation";
    case 5590607: return "Unisys Corporation";
    case 5590608: return "Unitop";
    case 5590611: return "Unisys Corporation";
    case 5590612: return "Unisys Corporation";
    case 5590617: return "Unicate";
    case 5591120: return "UPPI";
    case 5591123: return "Systems Enhancement";
    case 5591620: return "Video Computer S.p.A.";
    case 5591873: return "Utimaco Safeware AG";
    case 5591876: return "U.S. Digital Corporation";
    case 5591877: return "U. S. Electronics Inc.";
    case 5591881: return "Universal Scientific Industrial Co., Ltd.";
    case 5591890: return "U.S. Robotics Inc";
    case 5592131: return "Unicompute Technology Co., Ltd.";
    case 5592132: return "Up to Date Tech";
    case 5592899: return "Uniwill Computer Corp.";
    case 5652804: return "Vaddio, LLC";
    case 5652809: return "VAIO Corporation";
    case 5652812: return "Valence Computing Corporation";
    case 5652818: return "Varian Australia Pty Ltd";
    case 5652820: return "VADATECH INC";
    case 5652822: return "aviica";
    case 5653074: return "VBrick Systems Inc.";
    case 5653076: return "Valley Board Ltda";
    case 5653315: return "Virtual Computer Corporation";
    case 5653317: return "VARCem";
    case 5653321: return "VistaCom Inc";
    case 5653322: return "Victor Company of Japan, Limited";
    case 5653325: return "Vector Magnetics, LLC";
    case 5653336: return "VCONEX";
    case 5653569: return "Victor Data Systems";
    case 5653571: return "VDC Display Systems";
    case 5653581: return "Vadem";
    case 5653583: return "Video \046 Display Oriented Corporation";
    case 5653587: return "Vidisys GmbH \046 Company";
    case 5653588: return "Viditec, Inc.";
    case 5653827: return "Vector Informatik GmbH";
    case 5653835: return "Vektrex";
    case 5653843: return "Vestel Elektronik Sanayi ve Ticaret A. S.";
    case 5654089: return "VeriFone Inc";
    case 5654601: return "Macrocad Development Inc.";
    case 5654849: return "VIA Tech Inc";
    case 5654850: return "Tatung UK Ltd";
    case 5654851: return "Victron B.V.";
    case 5654852: return "Ingram Macrotron Germany";
    case 5654859: return "Viking Connectors";
    case 5654861: return "Via Mons Ltd.";
    case 5654862: return "Vine Micros Ltd";
    case 5654863: return "Zake IP Holdings LLC \0503B tech\051";
    case 5654866: return "Visual Interface, Inc";
    case 5654867: return "Visioneer";
    case 5654868: return "Visitech AS";
    case 5654874: return "VIZIO, Inc";
    case 5655618: return "ValleyBoard Ltda.";
    case 5655619: return "VersaLogic Corporation";
    case 5655627: return "Vislink International Ltd";
    case 5655629: return "LENOVO BEIJING CO. LTD.";
    case 5655636: return "VideoLan Technologies";
    case 5655638: return "Valve Corporation";
    case 5655881: return "Vermont Microsystems";
    case 5655884: return "Vine Micros Limited";
    case 5655895: return "VMware Inc.,";
    case 5656131: return "Vinca Corporation";
    case 5656152: return "Venetex Corporation";
    case 5656386: return "MaxData Computer AG";
    case 5656649: return "Video Products Inc";
    case 5656658: return "Best Buy";
    case 5656664: return "VPixx Technologies Inc.";
    case 5656896: return "Vision Quest";
    case 5657155: return "Virtual Resources Corporation";
    case 5657159: return "VRgineers, Inc.";
    case 5657165: return "VRmagic Holding AG";
    case 5657171: return "VRstudios, Inc.";
    case 5657172: return "Varjo Technologies";
    case 5657411: return "ViewSonic Corporation";
    case 5657412: return "3M";
    case 5657417: return "VideoServer";
    case 5657422: return "Ingram Macrotron";
    case 5657424: return "Vision Systems GmbH";
    case 5657426: return "V\055Star Electronics Inc.";
    case 5657666: return "Videotechnik Breithaupt";
    case 5657667: return "VTel Corporation";
    case 5657671: return "Voice Technologies Group Inc";
    case 5657673: return "VLSI Tech Inc";
    case 5657675: return "Viewteck Co., Ltd.";
    case 5657676: return "Vivid Technology Pte Ltd";
    case 5657677: return "Miltope Corporation";
    case 5657678: return "VIDEOTRON CORP.";
    case 5657683: return "VTech Computers Ltd";
    case 5657686: return "VATIV Technologies";
    case 5657688: return "Vestax Corporation";
    case 5657940: return "Vutrix \050UK\051 Ltd";
    case 5658185: return "VITEC";
    case 5658434: return "Vweb Corp.";
    case 5718339: return "Wacom Tech";
    case 5718348: return "Wave Access";
    case 5718350: return "Invalid Vendor Codename \055 WAN";
    case 5718358: return "Wavephore";
    case 5718606: return "MicroSoftWare";
    case 5718611: return "WB Systemtechnik GmbH";
    case 5718857: return "Wisecom Inc";
    case 5718867: return "Woodwind Communications Systems Inc";
    case 5719107: return "Western Digital";
    case 5719109: return "Westinghouse Digital Electronics";
    case 5719362: return "WebGear Inc";
    case 5719363: return "Winbond Electronics Corporation";
    case 5719372: return "W\055DEV";
    case 5719385: return "WEY Design AG";
    case 5720137: return "Whistle Communications";
    case 5720393: return "Innoware Inc";
    case 5720396: return "WIPRO Information Technology Ltd";
    case 5720398: return "Wintop Technology Inc";
    case 5720400: return "Wipro Infotech";
    case 5720904: return "Uni\055Take Int\047l Inc.";
    case 5721156: return "Wildfire Communications Inc";
    case 5721158: return "WOLF Advanced Technology";
    case 5721417: return "Weidmuller Interface GmbH \046 Co. KG";
    case 5721420: return "Wolfson Microelectronics Ltd";
    case 5721423: return "Westermo Teleindustri AB";
    case 5721428: return "Winmate Communication Inc";
    case 5721673: return "WillNet Inc.";
    case 5721686: return "Winnov L.P.";
    case 5721688: return "Diebold Nixdorf Systems GmbH";
    case 5722177: return "Matsushita Communication Industrial Co., Ltd.";
    case 5722185: return "Wearnes Peripherals International \050Pte\051 Ltd";
    case 5722691: return "WiNRADiO Communications";
    case 5722947: return "CIS Technology Inc";
    case 5722960: return "Wireless And Smart Products Inc.";
    case 5722964: return "Wistron Corporation";
    case 5723203: return "ACC Microelectronics";
    case 5723209: return "WorkStation Tech";
    case 5723211: return "Wearnes Thakral Pte";
    case 5723219: return "Restek Electric Company Ltd";
    case 5723725: return "Wave Systems Corporation";
    case 5723734: return "WolfVision GmbH";
    case 5723984: return "Wipotec Wiege\055 und Positioniersysteme GmbH";
    case 5723990: return "World Wide Video, Inc.";
    case 5724244: return "Woxter Technology Co. Ltd";
    case 5724498: return "WyreStorm Technologies LLC";
    case 5724499: return "Wyse Technology";
    case 5724500: return "Wooyoung Image \046 Information Co.,Ltd.";
    case 5783875: return "XAC Automation Corp";
    case 5783876: return "Alpha Data";
    case 5784653: return "XDM Ltd.";
    case 5784914: return "Invalid Vendor Codename \055 XER";
    case 5784915: return "Extreme Engineering Solutions, Inc.";
    case 5785159: return "Jan Strapko \055 FOTO";
    case 5785167: return "EXFO Electro Optical Engineering";
    case 5785934: return "Xinex Networks Inc";
    case 5785935: return "Xiotech Corporation";
    case 5785938: return "Xirocm Inc";
    case 5785940: return "Xitel Pty ltd";
    case 5786712: return "Xilinx, Inc.";
    case 5786953: return "Xiaomi Corporation";
    case 5786957: return "C3PO S.L.";
    case 5787220: return "XN Technologies, Inc.";
    case 5787459: return "Invalid Vendor Codename \055 XOC";
    case 5787989: return "SHANGHAI SVA\055DAV ELECTRONICS CO., LTD";
    case 5788227: return "Xircom Inc";
    case 5788239: return "XORO ELECTRONICS \050CHENGDU\051 LIMITED";
    case 5788494: return "Xscreen AS";
    case 5788500: return "XS Technologies Inc";
    case 5788505: return "XSYS";
    case 5788740: return "Icuiti Corporation";
    case 5788741: return "X2E GmbH";
    case 5788748: return "Crystal Computer";
    case 5788750: return "X\05510 \050USA\051 Inc";
    case 5790019: return "Xycotec Computer GmbH";
    case 5790021: return "Shenzhen Zhuona Technology Co., Ltd.";
    case 5850436: return "Y\055E Data Inc";
    case 5851217: return "Yokogawa Electric Corporation";
    case 5851223: return "Exacom SA";
    case 5852488: return "Yamaha Corporation";
    case 5853015: return "American Biometric Company";
    case 5914958: return "Zandar Technologies plc";
    case 5914968: return "Zefiro Acoustics";
    case 5914970: return "ZeeVee, Inc.";
    case 5915218: return "Zebra Technologies International, LLC";
    case 5915224: return "Zebax Technologies";
    case 5915476: return "ZeitControl cardsystems GmbH";
    case 5915731: return "Zenith Data Systems";
    case 5915982: return "ZENIC Inc.";
    case 5916500: return "Zenith Data Systems";
    case 5916995: return "Nationz Technologies Inc.";
    case 5918019: return "HangZhou ZMCHIVIN";
    case 5918036: return "Zalman Tech Co., Ltd.";
    case 5918042: return "Z Microsystems";
    case 5918281: return "Zetinet Inc";
    case 5918296: return "Znyx Adv. Systems";
    case 5918551: return "Zowie Intertainment, Inc";
    case 5919310: return "Zoran Corporation";
    case 5919557: return "Zenith Data Systems";
    case 5919811: return "ZyDAS Technology Corporation";
    case 5919813: return "ZTE Corporation";
    case 5919817: return "Zoom Telephonics Inc";
    case 5919821: return "ZT Group Int\047l Inc.";
    case 5919828: return "Z3 Technology";
    case 5920581: return "Shenzhen Zowee Technology Co., LTD";
    case 5921092: return "Zydacron Inc";
    case 5921104: return "Zypcom Inc";
    case 5921108: return "Zytex Computers";
    case 5921112: return "Zyxel";
    case 5921370: return "Boca Research Inc";
    case 6909557: return "Inovatec S.p.A.";

    default:
        return NULL;
    }
}
