/* screenshot.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from screenshot.vala, do not modify */

/*
 * This file is part of budgie-desktop
 *
 * Copyright Budgie Desktop Developers
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Code has been inspired by the elementaryOS Gala ScreenshotManager.vala
 * and the GNOME 42 shell-screenshot.c techniques.
 */

#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>

#define BUDGIE_EXTENSION ".png"
#define BUDGIE_DBUS_SCREENSHOT "org.buddiesofbudgie.BudgieScreenshot"
#define BUDGIE_DBUS_SCREENSHOT_PATH "/org/buddiesofbudgie/Screenshot"
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define BUDGIE_TYPE_SCREENSHOT_MANAGER (budgie_screenshot_manager_get_type ())
#define BUDGIE_SCREENSHOT_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BUDGIE_TYPE_SCREENSHOT_MANAGER, BudgieScreenshotManager))
#define BUDGIE_SCREENSHOT_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BUDGIE_TYPE_SCREENSHOT_MANAGER, BudgieScreenshotManagerClass))
#define BUDGIE_IS_SCREENSHOT_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BUDGIE_TYPE_SCREENSHOT_MANAGER))
#define BUDGIE_IS_SCREENSHOT_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BUDGIE_TYPE_SCREENSHOT_MANAGER))
#define BUDGIE_SCREENSHOT_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BUDGIE_TYPE_SCREENSHOT_MANAGER, BudgieScreenshotManagerClass))

typedef struct _BudgieScreenshotManager BudgieScreenshotManager;
typedef struct _BudgieScreenshotManagerClass BudgieScreenshotManagerClass;
typedef struct _BudgieScreenshotManagerPrivate BudgieScreenshotManagerPrivate;
enum  {
	BUDGIE_SCREENSHOT_MANAGER_0_PROPERTY,
	BUDGIE_SCREENSHOT_MANAGER_NUM_PROPERTIES
};
static GParamSpec* budgie_screenshot_manager_properties[BUDGIE_SCREENSHOT_MANAGER_NUM_PROPERTIES];
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _BudgieScreenshotManagerScreenshotData BudgieScreenshotManagerScreenshotData;
typedef struct _BudgieScreenshotManagerScreenshotAreaData BudgieScreenshotManagerScreenshotAreaData;
typedef struct _BudgieScreenshotManagerScreenshotWindowData BudgieScreenshotManagerScreenshotWindowData;
typedef struct _BudgieScreenshotManagerScreenshotReadyData BudgieScreenshotManagerScreenshotReadyData;
typedef struct _BudgieScreenshotManagerScreenshotAreaReadyData BudgieScreenshotManagerScreenshotAreaReadyData;
typedef struct _BudgieScreenshotManagerScreenshotWindowReadyData BudgieScreenshotManagerScreenshotWindowReadyData;

struct _BudgieScreenshotManager {
	GObject parent_instance;
	BudgieScreenshotManagerPrivate * priv;
};

struct _BudgieScreenshotManagerClass {
	GObjectClass parent_class;
};

struct _BudgieScreenshotManagerScreenshotData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	BudgieScreenshotManager* self;
	gboolean include_cursor;
	gboolean flash;
	gchar* filename;
	gboolean success;
	gchar* filename_used;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	GError* _tmp5_;
	GError* _inner_error0_;
};

struct _BudgieScreenshotManagerScreenshotAreaData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	BudgieScreenshotManager* self;
	gint x;
	gint y;
	gint width;
	gint height;
	gboolean include_cursor;
	gboolean flash;
	gchar* filename;
	gboolean success;
	gchar* filename_used;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	GError* _tmp5_;
	GError* _inner_error0_;
};

struct _BudgieScreenshotManagerScreenshotWindowData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	BudgieScreenshotManager* self;
	gboolean include_frame;
	gboolean include_cursor;
	gboolean flash;
	gchar* filename;
	gboolean success;
	gchar* filename_used;
	GError* _tmp0_;
	GError* _inner_error0_;
};

struct _BudgieScreenshotManagerScreenshotReadyData {
	GDBusMethodInvocation* _invocation_;
	gboolean include_cursor;
	gboolean flash;
	gchar* filename;
};

struct _BudgieScreenshotManagerScreenshotAreaReadyData {
	GDBusMethodInvocation* _invocation_;
	gint x;
	gint y;
	gint width;
	gint height;
	gboolean include_cursor;
	gboolean flash;
	gchar* filename;
};

struct _BudgieScreenshotManagerScreenshotWindowReadyData {
	GDBusMethodInvocation* _invocation_;
	gboolean include_frame;
	gboolean include_cursor;
	gboolean flash;
	gchar* filename;
};

static gpointer budgie_screenshot_manager_parent_class = NULL;

VALA_EXTERN GType budgie_screenshot_manager_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BudgieScreenshotManager, g_object_unref)
VALA_EXTERN guint budgie_screenshot_manager_register_object (void* object,
                                                 GDBusConnection* connection,
                                                 const gchar* path,
                                                 GError** error);
VALA_EXTERN BudgieScreenshotManager* budgie_screenshot_manager_new (void);
VALA_EXTERN BudgieScreenshotManager* budgie_screenshot_manager_construct (GType object_type);
VALA_EXTERN void budgie_screenshot_manager_serve (BudgieScreenshotManager* self);
static void budgie_screenshot_manager_on_bus_acquired (BudgieScreenshotManager* self,
                                                GDBusConnection* conn);
static void _budgie_screenshot_manager_on_bus_acquired_gbus_acquired_callback (GDBusConnection* connection,
                                                                        const gchar* name,
                                                                        gpointer self);
static void __lambda52_ (BudgieScreenshotManager* self);
static void ___lambda52__gbus_name_acquired_callback (GDBusConnection* connection,
                                               const gchar* name,
                                               gpointer self);
static void __lambda53_ (BudgieScreenshotManager* self);
static void ___lambda53__gbus_name_lost_callback (GDBusConnection* connection,
                                           const gchar* name,
                                           gpointer self);
VALA_EXTERN gboolean budgie_screenshot_manager_SupportScreenshotWindow (BudgieScreenshotManager* self,
                                                            GError** error);
static void budgie_screenshot_manager_screenshot_data_free (gpointer _data);
VALA_EXTERN void budgie_screenshot_manager_screenshot (BudgieScreenshotManager* self,
                                           gboolean include_cursor,
                                           gboolean flash,
                                           const gchar* filename,
                                           GAsyncReadyCallback _callback_,
                                           gpointer _user_data_);
VALA_EXTERN void budgie_screenshot_manager_screenshot_finish (BudgieScreenshotManager* self,
                                                  GAsyncResult* _res_,
                                                  gboolean* success,
                                                  gchar** filename_used,
                                                  GError** error);
static gboolean budgie_screenshot_manager_screenshot_co (BudgieScreenshotManagerScreenshotData* _data_);
static gchar* budgie_screenshot_manager_take_screenshot (BudgieScreenshotManager* self,
                                                  const gchar* filename,
                                                  gint x,
                                                  gint y,
                                                  gint width,
                                                  gint height,
                                                  gboolean include_cursor,
                                                  GError** error);
static void budgie_screenshot_manager_screenshot_area_data_free (gpointer _data);
VALA_EXTERN void budgie_screenshot_manager_screenshot_area (BudgieScreenshotManager* self,
                                                gint x,
                                                gint y,
                                                gint width,
                                                gint height,
                                                gboolean include_cursor,
                                                gboolean flash,
                                                const gchar* filename,
                                                GAsyncReadyCallback _callback_,
                                                gpointer _user_data_);
VALA_EXTERN void budgie_screenshot_manager_screenshot_area_finish (BudgieScreenshotManager* self,
                                                       GAsyncResult* _res_,
                                                       gboolean* success,
                                                       gchar** filename_used,
                                                       GError** error);
static gboolean budgie_screenshot_manager_screenshot_area_co (BudgieScreenshotManagerScreenshotAreaData* _data_);
static void budgie_screenshot_manager_screenshot_window_data_free (gpointer _data);
VALA_EXTERN void budgie_screenshot_manager_screenshot_window (BudgieScreenshotManager* self,
                                                  gboolean include_frame,
                                                  gboolean include_cursor,
                                                  gboolean flash,
                                                  const gchar* filename,
                                                  GAsyncReadyCallback _callback_,
                                                  gpointer _user_data_);
VALA_EXTERN void budgie_screenshot_manager_screenshot_window_finish (BudgieScreenshotManager* self,
                                                         GAsyncResult* _res_,
                                                         gboolean* success,
                                                         gchar** filename_used,
                                                         GError** error);
static gboolean budgie_screenshot_manager_screenshot_window_co (BudgieScreenshotManagerScreenshotWindowData* _data_);
static GType budgie_screenshot_manager_get_type_once (void);
static void _dbus_budgie_screenshot_manager_SupportScreenshotWindow (BudgieScreenshotManager* self,
                                                              GVariant* _parameters_,
                                                              GDBusMethodInvocation* invocation);
static void _dbus_budgie_screenshot_manager_screenshot (BudgieScreenshotManager* self,
                                                 GVariant* _parameters_,
                                                 GDBusMethodInvocation* invocation);
static void _dbus_budgie_screenshot_manager_screenshot_ready (GObject * source_object,
                                                       GAsyncResult * _res_,
                                                       gpointer _user_data_);
static void _dbus_budgie_screenshot_manager_screenshot_area (BudgieScreenshotManager* self,
                                                      GVariant* _parameters_,
                                                      GDBusMethodInvocation* invocation);
static void _dbus_budgie_screenshot_manager_screenshot_area_ready (GObject * source_object,
                                                            GAsyncResult * _res_,
                                                            gpointer _user_data_);
static void _dbus_budgie_screenshot_manager_screenshot_window (BudgieScreenshotManager* self,
                                                        GVariant* _parameters_,
                                                        GDBusMethodInvocation* invocation);
static void _dbus_budgie_screenshot_manager_screenshot_window_ready (GObject * source_object,
                                                              GAsyncResult * _res_,
                                                              gpointer _user_data_);
static void budgie_screenshot_manager_dbus_interface_method_call (GDBusConnection* connection,
                                                           const gchar* sender,
                                                           const gchar* object_path,
                                                           const gchar* interface_name,
                                                           const gchar* method_name,
                                                           GVariant* parameters,
                                                           GDBusMethodInvocation* invocation,
                                                           gpointer user_data);
static GVariant* budgie_screenshot_manager_dbus_interface_get_property (GDBusConnection* connection,
                                                                 const gchar* sender,
                                                                 const gchar* object_path,
                                                                 const gchar* interface_name,
                                                                 const gchar* property_name,
                                                                 GError** error,
                                                                 gpointer user_data);
static gboolean budgie_screenshot_manager_dbus_interface_set_property (GDBusConnection* connection,
                                                                const gchar* sender,
                                                                const gchar* object_path,
                                                                const gchar* interface_name,
                                                                const gchar* property_name,
                                                                GVariant* value,
                                                                GError** error,
                                                                gpointer user_data);
static void _budgie_screenshot_manager_unregister_object (gpointer user_data);

static const GDBusArgInfo _budgie_screenshot_manager_dbus_arg_info_SupportScreenshotWindow_result = {-1, "result", "b", NULL};
static const GDBusArgInfo * const _budgie_screenshot_manager_dbus_arg_info_SupportScreenshotWindow_in[] = {NULL};
static const GDBusArgInfo * const _budgie_screenshot_manager_dbus_arg_info_SupportScreenshotWindow_out[] = {&_budgie_screenshot_manager_dbus_arg_info_SupportScreenshotWindow_result, NULL};
static const GDBusMethodInfo _budgie_screenshot_manager_dbus_method_info_SupportScreenshotWindow = {-1, "SupportScreenshotWindow", (GDBusArgInfo **) (&_budgie_screenshot_manager_dbus_arg_info_SupportScreenshotWindow_in), (GDBusArgInfo **) (&_budgie_screenshot_manager_dbus_arg_info_SupportScreenshotWindow_out), NULL};
static const GDBusArgInfo _budgie_screenshot_manager_dbus_arg_info_screenshot_include_cursor = {-1, "include_cursor", "b", NULL};
static const GDBusArgInfo _budgie_screenshot_manager_dbus_arg_info_screenshot_flash = {-1, "flash", "b", NULL};
static const GDBusArgInfo _budgie_screenshot_manager_dbus_arg_info_screenshot_filename = {-1, "filename", "s", NULL};
static const GDBusArgInfo _budgie_screenshot_manager_dbus_arg_info_screenshot_success = {-1, "success", "b", NULL};
static const GDBusArgInfo _budgie_screenshot_manager_dbus_arg_info_screenshot_filename_used = {-1, "filename_used", "s", NULL};
static const GDBusArgInfo * const _budgie_screenshot_manager_dbus_arg_info_screenshot_in[] = {&_budgie_screenshot_manager_dbus_arg_info_screenshot_include_cursor, &_budgie_screenshot_manager_dbus_arg_info_screenshot_flash, &_budgie_screenshot_manager_dbus_arg_info_screenshot_filename, NULL};
static const GDBusArgInfo * const _budgie_screenshot_manager_dbus_arg_info_screenshot_out[] = {&_budgie_screenshot_manager_dbus_arg_info_screenshot_success, &_budgie_screenshot_manager_dbus_arg_info_screenshot_filename_used, NULL};
static const GDBusMethodInfo _budgie_screenshot_manager_dbus_method_info_screenshot = {-1, "Screenshot", (GDBusArgInfo **) (&_budgie_screenshot_manager_dbus_arg_info_screenshot_in), (GDBusArgInfo **) (&_budgie_screenshot_manager_dbus_arg_info_screenshot_out), NULL};
static const GDBusArgInfo _budgie_screenshot_manager_dbus_arg_info_screenshot_area_x = {-1, "x", "i", NULL};
static const GDBusArgInfo _budgie_screenshot_manager_dbus_arg_info_screenshot_area_y = {-1, "y", "i", NULL};
static const GDBusArgInfo _budgie_screenshot_manager_dbus_arg_info_screenshot_area_width = {-1, "width", "i", NULL};
static const GDBusArgInfo _budgie_screenshot_manager_dbus_arg_info_screenshot_area_height = {-1, "height", "i", NULL};
static const GDBusArgInfo _budgie_screenshot_manager_dbus_arg_info_screenshot_area_include_cursor = {-1, "include_cursor", "b", NULL};
static const GDBusArgInfo _budgie_screenshot_manager_dbus_arg_info_screenshot_area_flash = {-1, "flash", "b", NULL};
static const GDBusArgInfo _budgie_screenshot_manager_dbus_arg_info_screenshot_area_filename = {-1, "filename", "s", NULL};
static const GDBusArgInfo _budgie_screenshot_manager_dbus_arg_info_screenshot_area_success = {-1, "success", "b", NULL};
static const GDBusArgInfo _budgie_screenshot_manager_dbus_arg_info_screenshot_area_filename_used = {-1, "filename_used", "s", NULL};
static const GDBusArgInfo * const _budgie_screenshot_manager_dbus_arg_info_screenshot_area_in[] = {&_budgie_screenshot_manager_dbus_arg_info_screenshot_area_x, &_budgie_screenshot_manager_dbus_arg_info_screenshot_area_y, &_budgie_screenshot_manager_dbus_arg_info_screenshot_area_width, &_budgie_screenshot_manager_dbus_arg_info_screenshot_area_height, &_budgie_screenshot_manager_dbus_arg_info_screenshot_area_include_cursor, &_budgie_screenshot_manager_dbus_arg_info_screenshot_area_flash, &_budgie_screenshot_manager_dbus_arg_info_screenshot_area_filename, NULL};
static const GDBusArgInfo * const _budgie_screenshot_manager_dbus_arg_info_screenshot_area_out[] = {&_budgie_screenshot_manager_dbus_arg_info_screenshot_area_success, &_budgie_screenshot_manager_dbus_arg_info_screenshot_area_filename_used, NULL};
static const GDBusMethodInfo _budgie_screenshot_manager_dbus_method_info_screenshot_area = {-1, "ScreenshotArea", (GDBusArgInfo **) (&_budgie_screenshot_manager_dbus_arg_info_screenshot_area_in), (GDBusArgInfo **) (&_budgie_screenshot_manager_dbus_arg_info_screenshot_area_out), NULL};
static const GDBusArgInfo _budgie_screenshot_manager_dbus_arg_info_screenshot_window_include_frame = {-1, "include_frame", "b", NULL};
static const GDBusArgInfo _budgie_screenshot_manager_dbus_arg_info_screenshot_window_include_cursor = {-1, "include_cursor", "b", NULL};
static const GDBusArgInfo _budgie_screenshot_manager_dbus_arg_info_screenshot_window_flash = {-1, "flash", "b", NULL};
static const GDBusArgInfo _budgie_screenshot_manager_dbus_arg_info_screenshot_window_filename = {-1, "filename", "s", NULL};
static const GDBusArgInfo _budgie_screenshot_manager_dbus_arg_info_screenshot_window_success = {-1, "success", "b", NULL};
static const GDBusArgInfo _budgie_screenshot_manager_dbus_arg_info_screenshot_window_filename_used = {-1, "filename_used", "s", NULL};
static const GDBusArgInfo * const _budgie_screenshot_manager_dbus_arg_info_screenshot_window_in[] = {&_budgie_screenshot_manager_dbus_arg_info_screenshot_window_include_frame, &_budgie_screenshot_manager_dbus_arg_info_screenshot_window_include_cursor, &_budgie_screenshot_manager_dbus_arg_info_screenshot_window_flash, &_budgie_screenshot_manager_dbus_arg_info_screenshot_window_filename, NULL};
static const GDBusArgInfo * const _budgie_screenshot_manager_dbus_arg_info_screenshot_window_out[] = {&_budgie_screenshot_manager_dbus_arg_info_screenshot_window_success, &_budgie_screenshot_manager_dbus_arg_info_screenshot_window_filename_used, NULL};
static const GDBusMethodInfo _budgie_screenshot_manager_dbus_method_info_screenshot_window = {-1, "ScreenshotWindow", (GDBusArgInfo **) (&_budgie_screenshot_manager_dbus_arg_info_screenshot_window_in), (GDBusArgInfo **) (&_budgie_screenshot_manager_dbus_arg_info_screenshot_window_out), NULL};
static const GDBusMethodInfo * const _budgie_screenshot_manager_dbus_method_info[] = {&_budgie_screenshot_manager_dbus_method_info_SupportScreenshotWindow, &_budgie_screenshot_manager_dbus_method_info_screenshot, &_budgie_screenshot_manager_dbus_method_info_screenshot_area, &_budgie_screenshot_manager_dbus_method_info_screenshot_window, NULL};
static const GDBusSignalInfo * const _budgie_screenshot_manager_dbus_signal_info[] = {NULL};
static const GDBusPropertyInfo * const _budgie_screenshot_manager_dbus_property_info[] = {NULL};
static const GDBusInterfaceInfo _budgie_screenshot_manager_dbus_interface_info = {-1, "org.buddiesofbudgie.BudgieScreenshot", (GDBusMethodInfo **) (&_budgie_screenshot_manager_dbus_method_info), (GDBusSignalInfo **) (&_budgie_screenshot_manager_dbus_signal_info), (GDBusPropertyInfo **) (&_budgie_screenshot_manager_dbus_property_info), NULL};
static const GDBusInterfaceVTable _budgie_screenshot_manager_dbus_interface_vtable = {budgie_screenshot_manager_dbus_interface_method_call, budgie_screenshot_manager_dbus_interface_get_property, budgie_screenshot_manager_dbus_interface_set_property};

BudgieScreenshotManager*
budgie_screenshot_manager_construct (GType object_type)
{
	BudgieScreenshotManager * self = NULL;
	self = (BudgieScreenshotManager*) g_object_new (object_type, NULL);
	return self;
}

BudgieScreenshotManager*
budgie_screenshot_manager_new (void)
{
	return budgie_screenshot_manager_construct (BUDGIE_TYPE_SCREENSHOT_MANAGER);
}

static void
_budgie_screenshot_manager_on_bus_acquired_gbus_acquired_callback (GDBusConnection* connection,
                                                                   const gchar* name,
                                                                   gpointer self)
{
	budgie_screenshot_manager_on_bus_acquired ((BudgieScreenshotManager*) self, connection);
}

static void
__lambda52_ (BudgieScreenshotManager* self)
{
}

static void
___lambda52__gbus_name_acquired_callback (GDBusConnection* connection,
                                          const gchar* name,
                                          gpointer self)
{
	__lambda52_ ((BudgieScreenshotManager*) self);
}

static void
__lambda53_ (BudgieScreenshotManager* self)
{
	g_warning ("screenshot.vala:34: serve Could not acquire name\n");
}

static void
___lambda53__gbus_name_lost_callback (GDBusConnection* connection,
                                      const gchar* name,
                                      gpointer self)
{
	__lambda53_ ((BudgieScreenshotManager*) self);
}

void
budgie_screenshot_manager_serve (BudgieScreenshotManager* self)
{
	g_return_if_fail (self != NULL);
	g_bus_own_name_with_closures (G_BUS_TYPE_SESSION, BUDGIE_DBUS_SCREENSHOT, G_BUS_NAME_OWNER_FLAGS_REPLACE, (GClosure*) ((_budgie_screenshot_manager_on_bus_acquired_gbus_acquired_callback == NULL) ? NULL : g_cclosure_new ((GCallback) _budgie_screenshot_manager_on_bus_acquired_gbus_acquired_callback, g_object_ref (self), (GClosureNotify) g_object_unref)), (GClosure*) ((___lambda52__gbus_name_acquired_callback == NULL) ? NULL : g_cclosure_new ((GCallback) ___lambda52__gbus_name_acquired_callback, g_object_ref (self), (GClosureNotify) g_object_unref)), (GClosure*) ((___lambda53__gbus_name_lost_callback == NULL) ? NULL : g_cclosure_new ((GCallback) ___lambda53__gbus_name_lost_callback, g_object_ref (self), (GClosureNotify) g_object_unref)));
}

static void
budgie_screenshot_manager_on_bus_acquired (BudgieScreenshotManager* self,
                                           GDBusConnection* conn)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (conn != NULL);
	{
		budgie_screenshot_manager_register_object (self, conn, BUDGIE_DBUS_SCREENSHOT_PATH, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp0_;
		const gchar* _tmp1_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp0_ = e;
		_tmp1_ = _tmp0_->message;
		g_message ("screenshot.vala:41: Unable to register Screenshot: %s", _tmp1_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

gboolean
budgie_screenshot_manager_SupportScreenshotWindow (BudgieScreenshotManager* self,
                                                   GError** error)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = FALSE;
	return result;
}

static void
budgie_screenshot_manager_screenshot_data_free (gpointer _data)
{
	BudgieScreenshotManagerScreenshotData* _data_;
	_data_ = _data;
	_g_free0 (_data_->filename);
	_g_object_unref0 (_data_->self);
	g_slice_free (BudgieScreenshotManagerScreenshotData, _data_);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

void
budgie_screenshot_manager_screenshot (BudgieScreenshotManager* self,
                                      gboolean include_cursor,
                                      gboolean flash,
                                      const gchar* filename,
                                      GAsyncReadyCallback _callback_,
                                      gpointer _user_data_)
{
	BudgieScreenshotManagerScreenshotData* _data_;
	BudgieScreenshotManager* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (filename != NULL);
	_data_ = g_slice_new0 (BudgieScreenshotManagerScreenshotData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, budgie_screenshot_manager_screenshot_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_data_->include_cursor = include_cursor;
	_data_->flash = flash;
	_tmp1_ = g_strdup (filename);
	_g_free0 (_data_->filename);
	_data_->filename = _tmp1_;
	budgie_screenshot_manager_screenshot_co (_data_);
}

void
budgie_screenshot_manager_screenshot_finish (BudgieScreenshotManager* self,
                                             GAsyncResult* _res_,
                                             gboolean* success,
                                             gchar** filename_used,
                                             GError** error)
{
	BudgieScreenshotManagerScreenshotData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
	if (success) {
		*success = _data_->success;
	}
	if (filename_used) {
		*filename_used = _data_->filename_used;
	} else {
		_g_free0 (_data_->filename_used);
	}
	_data_->filename_used = NULL;
}

static gboolean
budgie_screenshot_manager_screenshot_co (BudgieScreenshotManagerScreenshotData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->success = FALSE;
	_data_->_tmp0_ = g_strdup ("");
	_g_free0 (_data_->filename_used);
	_data_->filename_used = _data_->_tmp0_;
	{
		_data_->_tmp2_ = budgie_screenshot_manager_take_screenshot (_data_->self, _data_->filename, 0, 0, 0, 0, _data_->include_cursor, &_data_->_inner_error0_);
		_data_->_tmp1_ = _data_->_tmp2_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_data_->_tmp3_ = _data_->_tmp1_;
		_data_->_tmp1_ = NULL;
		_g_free0 (_data_->filename_used);
		_data_->filename_used = _data_->_tmp3_;
		_data_->_tmp4_ = _data_->filename_used;
		if (g_strcmp0 (_data_->_tmp4_, "") != 0) {
			_data_->success = TRUE;
		}
		_g_free0 (_data_->_tmp1_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_data_->_inner_error0_);
		_data_->_tmp5_ = g_error_new_literal (G_DBUS_ERROR, G_DBUS_ERROR_FAILED, "Failed to take the screenshot");
		_data_->_inner_error0_ = _data_->_tmp5_;
		goto __finally0;
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		if ((_data_->_inner_error0_->domain == G_DBUS_ERROR) || (_data_->_inner_error0_->domain == G_IO_ERROR)) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			_g_free0 (_data_->filename_used);
			g_object_unref (_data_->_async_result);
			return FALSE;
		} else {
			_g_free0 (_data_->filename_used);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
			g_clear_error (&_data_->_inner_error0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
	}
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static gchar*
budgie_screenshot_manager_take_screenshot (BudgieScreenshotManager* self,
                                           const gchar* filename,
                                           gint x,
                                           gint y,
                                           gint width,
                                           gint height,
                                           gboolean include_cursor,
                                           GError** error)
{
	gchar* used_filename = NULL;
	gchar* _tmp0_;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (filename != NULL, NULL);
	_tmp0_ = g_strdup (filename);
	used_filename = _tmp0_;
	{
		gchar* cmd = NULL;
		gchar* _tmp1_;
		gboolean _tmp4_ = FALSE;
		gboolean _tmp5_ = FALSE;
		gboolean _tmp6_ = FALSE;
		gboolean _tmp11_ = FALSE;
		const gchar* _tmp12_;
		const gchar* _tmp22_;
		const gchar* _tmp23_;
		gchar* _tmp24_;
		gchar* _tmp25_;
		gchar* _tmp26_;
		const gchar* _tmp27_;
		const gchar* _tmp28_;
		_tmp1_ = g_strdup ("grim");
		cmd = _tmp1_;
		if (include_cursor) {
			const gchar* _tmp2_;
			gchar* _tmp3_;
			_tmp2_ = cmd;
			_tmp3_ = g_strconcat (_tmp2_, " -c", NULL);
			_g_free0 (cmd);
			cmd = _tmp3_;
		}
		if (x != 0) {
			_tmp6_ = TRUE;
		} else {
			_tmp6_ = y != 0;
		}
		if (_tmp6_) {
			_tmp5_ = TRUE;
		} else {
			_tmp5_ = width != 0;
		}
		if (_tmp5_) {
			_tmp4_ = TRUE;
		} else {
			_tmp4_ = height != 0;
		}
		if (_tmp4_) {
			const gchar* _tmp7_;
			gchar* _tmp8_;
			gchar* _tmp9_;
			gchar* _tmp10_;
			_tmp7_ = cmd;
			_tmp8_ = g_strdup_printf (" -g \"%d,%d %dx%d\"", x, y, width, height);
			_tmp9_ = _tmp8_;
			_tmp10_ = g_strconcat (_tmp7_, _tmp9_, NULL);
			_g_free0 (cmd);
			cmd = _tmp10_;
			_g_free0 (_tmp9_);
		}
		_tmp12_ = used_filename;
		if (g_strcmp0 (_tmp12_, "") != 0) {
			const gchar* _tmp13_;
			_tmp13_ = used_filename;
			_tmp11_ = !g_path_is_absolute (_tmp13_);
		} else {
			_tmp11_ = FALSE;
		}
		if (_tmp11_) {
			const gchar* _tmp14_;
			gchar* path = NULL;
			const gchar* _tmp17_;
			gchar* _tmp18_;
			const gchar* _tmp19_;
			const gchar* _tmp20_;
			gchar* _tmp21_;
			_tmp14_ = used_filename;
			if (!g_str_has_suffix (_tmp14_, BUDGIE_EXTENSION)) {
				const gchar* _tmp15_;
				gchar* _tmp16_;
				_tmp15_ = used_filename;
				_tmp16_ = g_strconcat (_tmp15_, BUDGIE_EXTENSION, NULL);
				_g_free0 (used_filename);
				used_filename = _tmp16_;
			}
			_tmp17_ = g_get_tmp_dir ();
			_tmp18_ = g_strdup (_tmp17_);
			path = _tmp18_;
			_tmp19_ = path;
			_tmp20_ = used_filename;
			_tmp21_ = g_build_filename (_tmp19_, _tmp20_, NULL, NULL);
			_g_free0 (used_filename);
			used_filename = _tmp21_;
			_g_free0 (path);
		}
		_tmp22_ = cmd;
		_tmp23_ = used_filename;
		_tmp24_ = g_strconcat (" ", _tmp23_, NULL);
		_tmp25_ = _tmp24_;
		_tmp26_ = g_strconcat (_tmp22_, _tmp25_, NULL);
		_g_free0 (cmd);
		cmd = _tmp26_;
		_g_free0 (_tmp25_);
		_tmp27_ = cmd;
		g_spawn_command_line_sync (_tmp27_, NULL, NULL, NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (cmd);
			if (_inner_error0_->domain == G_SPAWN_ERROR) {
				goto __catch0_g_spawn_error;
			}
			_g_free0 (used_filename);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp28_ = cmd;
		g_warning ("screenshot.vala:92: command %s", _tmp28_);
		_g_free0 (cmd);
	}
	goto __finally0;
	__catch0_g_spawn_error:
	{
		GError* e = NULL;
		GError* _tmp29_;
		const gchar* _tmp30_;
		gchar* _tmp31_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp29_ = e;
		_tmp30_ = _tmp29_->message;
		g_warning ("screenshot.vala:94: Error: %s\n", _tmp30_);
		_tmp31_ = g_strdup ("");
		_g_free0 (used_filename);
		used_filename = _tmp31_;
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_free0 (used_filename);
		return NULL;
	}
	result = used_filename;
	return result;
}

static void
budgie_screenshot_manager_screenshot_area_data_free (gpointer _data)
{
	BudgieScreenshotManagerScreenshotAreaData* _data_;
	_data_ = _data;
	_g_free0 (_data_->filename);
	_g_object_unref0 (_data_->self);
	g_slice_free (BudgieScreenshotManagerScreenshotAreaData, _data_);
}

void
budgie_screenshot_manager_screenshot_area (BudgieScreenshotManager* self,
                                           gint x,
                                           gint y,
                                           gint width,
                                           gint height,
                                           gboolean include_cursor,
                                           gboolean flash,
                                           const gchar* filename,
                                           GAsyncReadyCallback _callback_,
                                           gpointer _user_data_)
{
	BudgieScreenshotManagerScreenshotAreaData* _data_;
	BudgieScreenshotManager* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (filename != NULL);
	_data_ = g_slice_new0 (BudgieScreenshotManagerScreenshotAreaData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, budgie_screenshot_manager_screenshot_area_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_data_->x = x;
	_data_->y = y;
	_data_->width = width;
	_data_->height = height;
	_data_->include_cursor = include_cursor;
	_data_->flash = flash;
	_tmp1_ = g_strdup (filename);
	_g_free0 (_data_->filename);
	_data_->filename = _tmp1_;
	budgie_screenshot_manager_screenshot_area_co (_data_);
}

void
budgie_screenshot_manager_screenshot_area_finish (BudgieScreenshotManager* self,
                                                  GAsyncResult* _res_,
                                                  gboolean* success,
                                                  gchar** filename_used,
                                                  GError** error)
{
	BudgieScreenshotManagerScreenshotAreaData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
	if (success) {
		*success = _data_->success;
	}
	if (filename_used) {
		*filename_used = _data_->filename_used;
	} else {
		_g_free0 (_data_->filename_used);
	}
	_data_->filename_used = NULL;
}

static gboolean
budgie_screenshot_manager_screenshot_area_co (BudgieScreenshotManagerScreenshotAreaData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->success = FALSE;
	_data_->_tmp0_ = g_strdup ("");
	_g_free0 (_data_->filename_used);
	_data_->filename_used = _data_->_tmp0_;
	{
		_data_->_tmp2_ = budgie_screenshot_manager_take_screenshot (_data_->self, _data_->filename, _data_->x, _data_->y, _data_->width, _data_->height, _data_->include_cursor, &_data_->_inner_error0_);
		_data_->_tmp1_ = _data_->_tmp2_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_data_->_tmp3_ = _data_->_tmp1_;
		_data_->_tmp1_ = NULL;
		_g_free0 (_data_->filename_used);
		_data_->filename_used = _data_->_tmp3_;
		_data_->_tmp4_ = _data_->filename_used;
		if (g_strcmp0 (_data_->_tmp4_, "") != 0) {
			_data_->success = TRUE;
		}
		_g_free0 (_data_->_tmp1_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_data_->_inner_error0_);
		_data_->_tmp5_ = g_error_new_literal (G_DBUS_ERROR, G_DBUS_ERROR_FAILED, "Failed to take the screenshot");
		_data_->_inner_error0_ = _data_->_tmp5_;
		goto __finally0;
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		if ((_data_->_inner_error0_->domain == G_DBUS_ERROR) || (_data_->_inner_error0_->domain == G_IO_ERROR)) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			_g_free0 (_data_->filename_used);
			g_object_unref (_data_->_async_result);
			return FALSE;
		} else {
			_g_free0 (_data_->filename_used);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
			g_clear_error (&_data_->_inner_error0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
	}
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
budgie_screenshot_manager_screenshot_window_data_free (gpointer _data)
{
	BudgieScreenshotManagerScreenshotWindowData* _data_;
	_data_ = _data;
	_g_free0 (_data_->filename);
	_g_object_unref0 (_data_->self);
	g_slice_free (BudgieScreenshotManagerScreenshotWindowData, _data_);
}

void
budgie_screenshot_manager_screenshot_window (BudgieScreenshotManager* self,
                                             gboolean include_frame,
                                             gboolean include_cursor,
                                             gboolean flash,
                                             const gchar* filename,
                                             GAsyncReadyCallback _callback_,
                                             gpointer _user_data_)
{
	BudgieScreenshotManagerScreenshotWindowData* _data_;
	BudgieScreenshotManager* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (filename != NULL);
	_data_ = g_slice_new0 (BudgieScreenshotManagerScreenshotWindowData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, budgie_screenshot_manager_screenshot_window_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_data_->include_frame = include_frame;
	_data_->include_cursor = include_cursor;
	_data_->flash = flash;
	_tmp1_ = g_strdup (filename);
	_g_free0 (_data_->filename);
	_data_->filename = _tmp1_;
	budgie_screenshot_manager_screenshot_window_co (_data_);
}

void
budgie_screenshot_manager_screenshot_window_finish (BudgieScreenshotManager* self,
                                                    GAsyncResult* _res_,
                                                    gboolean* success,
                                                    gchar** filename_used,
                                                    GError** error)
{
	BudgieScreenshotManagerScreenshotWindowData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
	if (success) {
		*success = _data_->success;
	}
	if (filename_used) {
		*filename_used = _data_->filename_used;
	} else {
		_g_free0 (_data_->filename_used);
	}
	_data_->filename_used = NULL;
}

static gboolean
budgie_screenshot_manager_screenshot_window_co (BudgieScreenshotManagerScreenshotWindowData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = g_error_new_literal (G_DBUS_ERROR, G_DBUS_ERROR_FAILED, "Failed to save image");
	_data_->_inner_error0_ = _data_->_tmp0_;
	if ((_data_->_inner_error0_->domain == G_DBUS_ERROR) || (_data_->_inner_error0_->domain == G_IO_ERROR)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_free0 (_data_->filename_used);
		g_object_unref (_data_->_async_result);
		return FALSE;
	} else {
		_g_free0 (_data_->filename_used);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
budgie_screenshot_manager_class_init (BudgieScreenshotManagerClass * klass,
                                      gpointer klass_data)
{
	budgie_screenshot_manager_parent_class = g_type_class_peek_parent (klass);
}

static void
budgie_screenshot_manager_instance_init (BudgieScreenshotManager * self,
                                         gpointer klass)
{
}

static GType
budgie_screenshot_manager_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BudgieScreenshotManagerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) budgie_screenshot_manager_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BudgieScreenshotManager), 0, (GInstanceInitFunc) budgie_screenshot_manager_instance_init, NULL };
	GType budgie_screenshot_manager_type_id;
	budgie_screenshot_manager_type_id = g_type_register_static (G_TYPE_OBJECT, "BudgieScreenshotManager", &g_define_type_info, 0);
	g_type_set_qdata (budgie_screenshot_manager_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) budgie_screenshot_manager_register_object);
	return budgie_screenshot_manager_type_id;
}

GType
budgie_screenshot_manager_get_type (void)
{
	static volatile gsize budgie_screenshot_manager_type_id__once = 0;
	if (g_once_init_enter (&budgie_screenshot_manager_type_id__once)) {
		GType budgie_screenshot_manager_type_id;
		budgie_screenshot_manager_type_id = budgie_screenshot_manager_get_type_once ();
		g_once_init_leave (&budgie_screenshot_manager_type_id__once, budgie_screenshot_manager_type_id);
	}
	return budgie_screenshot_manager_type_id__once;
}

static void
_dbus_budgie_screenshot_manager_SupportScreenshotWindow (BudgieScreenshotManager* self,
                                                         GVariant* _parameters_,
                                                         GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	gboolean result;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	result = budgie_screenshot_manager_SupportScreenshotWindow (self, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_reply_builder, g_variant_new_boolean (result));
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}

static void
_dbus_budgie_screenshot_manager_screenshot (BudgieScreenshotManager* self,
                                            GVariant* _parameters_,
                                            GDBusMethodInvocation* invocation)
{
	GVariantIter _arguments_iter;
	BudgieScreenshotManagerScreenshotReadyData* _ready_data;
	GVariant* _tmp58_;
	GVariant* _tmp59_;
	GVariant* _tmp60_;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_ready_data = g_slice_new0 (BudgieScreenshotManagerScreenshotReadyData);
	_ready_data->_invocation_ = invocation;
	_tmp58_ = g_variant_iter_next_value (&_arguments_iter);
	_ready_data->include_cursor = g_variant_get_boolean (_tmp58_);
	g_variant_unref (_tmp58_);
	_tmp59_ = g_variant_iter_next_value (&_arguments_iter);
	_ready_data->flash = g_variant_get_boolean (_tmp59_);
	g_variant_unref (_tmp59_);
	_tmp60_ = g_variant_iter_next_value (&_arguments_iter);
	_ready_data->filename = g_variant_dup_string (_tmp60_, NULL);
	g_variant_unref (_tmp60_);
	budgie_screenshot_manager_screenshot (self, _ready_data->include_cursor, _ready_data->flash, _ready_data->filename, (GAsyncReadyCallback) _dbus_budgie_screenshot_manager_screenshot_ready, _ready_data);
	_error:
	;
}

static void
_dbus_budgie_screenshot_manager_screenshot_ready (GObject * source_object,
                                                  GAsyncResult * _res_,
                                                  gpointer _user_data_)
{
	BudgieScreenshotManagerScreenshotReadyData* _ready_data;
	GDBusMethodInvocation* invocation;
	GError* error = NULL;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	gboolean success = FALSE;
	gchar* filename_used = NULL;
	_ready_data = _user_data_;
	invocation = _ready_data->_invocation_;
	budgie_screenshot_manager_screenshot_finish ((BudgieScreenshotManager*) source_object, _res_, &success, &filename_used, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		goto _error;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_reply_builder, g_variant_new_boolean (success));
	g_variant_builder_add_value (&_reply_builder, g_variant_new_string (filename_used));
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	_error:
	_g_free0 (_ready_data->filename);
	_g_free0 (filename_used);
	g_slice_free (BudgieScreenshotManagerScreenshotReadyData, _ready_data);
}

static void
_dbus_budgie_screenshot_manager_screenshot_area (BudgieScreenshotManager* self,
                                                 GVariant* _parameters_,
                                                 GDBusMethodInvocation* invocation)
{
	GVariantIter _arguments_iter;
	BudgieScreenshotManagerScreenshotAreaReadyData* _ready_data;
	GVariant* _tmp61_;
	GVariant* _tmp62_;
	GVariant* _tmp63_;
	GVariant* _tmp64_;
	GVariant* _tmp65_;
	GVariant* _tmp66_;
	GVariant* _tmp67_;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_ready_data = g_slice_new0 (BudgieScreenshotManagerScreenshotAreaReadyData);
	_ready_data->_invocation_ = invocation;
	_tmp61_ = g_variant_iter_next_value (&_arguments_iter);
	_ready_data->x = g_variant_get_int32 (_tmp61_);
	g_variant_unref (_tmp61_);
	_tmp62_ = g_variant_iter_next_value (&_arguments_iter);
	_ready_data->y = g_variant_get_int32 (_tmp62_);
	g_variant_unref (_tmp62_);
	_tmp63_ = g_variant_iter_next_value (&_arguments_iter);
	_ready_data->width = g_variant_get_int32 (_tmp63_);
	g_variant_unref (_tmp63_);
	_tmp64_ = g_variant_iter_next_value (&_arguments_iter);
	_ready_data->height = g_variant_get_int32 (_tmp64_);
	g_variant_unref (_tmp64_);
	_tmp65_ = g_variant_iter_next_value (&_arguments_iter);
	_ready_data->include_cursor = g_variant_get_boolean (_tmp65_);
	g_variant_unref (_tmp65_);
	_tmp66_ = g_variant_iter_next_value (&_arguments_iter);
	_ready_data->flash = g_variant_get_boolean (_tmp66_);
	g_variant_unref (_tmp66_);
	_tmp67_ = g_variant_iter_next_value (&_arguments_iter);
	_ready_data->filename = g_variant_dup_string (_tmp67_, NULL);
	g_variant_unref (_tmp67_);
	budgie_screenshot_manager_screenshot_area (self, _ready_data->x, _ready_data->y, _ready_data->width, _ready_data->height, _ready_data->include_cursor, _ready_data->flash, _ready_data->filename, (GAsyncReadyCallback) _dbus_budgie_screenshot_manager_screenshot_area_ready, _ready_data);
	_error:
	;
}

static void
_dbus_budgie_screenshot_manager_screenshot_area_ready (GObject * source_object,
                                                       GAsyncResult * _res_,
                                                       gpointer _user_data_)
{
	BudgieScreenshotManagerScreenshotAreaReadyData* _ready_data;
	GDBusMethodInvocation* invocation;
	GError* error = NULL;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	gboolean success = FALSE;
	gchar* filename_used = NULL;
	_ready_data = _user_data_;
	invocation = _ready_data->_invocation_;
	budgie_screenshot_manager_screenshot_area_finish ((BudgieScreenshotManager*) source_object, _res_, &success, &filename_used, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		goto _error;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_reply_builder, g_variant_new_boolean (success));
	g_variant_builder_add_value (&_reply_builder, g_variant_new_string (filename_used));
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	_error:
	_g_free0 (_ready_data->filename);
	_g_free0 (filename_used);
	g_slice_free (BudgieScreenshotManagerScreenshotAreaReadyData, _ready_data);
}

static void
_dbus_budgie_screenshot_manager_screenshot_window (BudgieScreenshotManager* self,
                                                   GVariant* _parameters_,
                                                   GDBusMethodInvocation* invocation)
{
	GVariantIter _arguments_iter;
	BudgieScreenshotManagerScreenshotWindowReadyData* _ready_data;
	GVariant* _tmp68_;
	GVariant* _tmp69_;
	GVariant* _tmp70_;
	GVariant* _tmp71_;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_ready_data = g_slice_new0 (BudgieScreenshotManagerScreenshotWindowReadyData);
	_ready_data->_invocation_ = invocation;
	_tmp68_ = g_variant_iter_next_value (&_arguments_iter);
	_ready_data->include_frame = g_variant_get_boolean (_tmp68_);
	g_variant_unref (_tmp68_);
	_tmp69_ = g_variant_iter_next_value (&_arguments_iter);
	_ready_data->include_cursor = g_variant_get_boolean (_tmp69_);
	g_variant_unref (_tmp69_);
	_tmp70_ = g_variant_iter_next_value (&_arguments_iter);
	_ready_data->flash = g_variant_get_boolean (_tmp70_);
	g_variant_unref (_tmp70_);
	_tmp71_ = g_variant_iter_next_value (&_arguments_iter);
	_ready_data->filename = g_variant_dup_string (_tmp71_, NULL);
	g_variant_unref (_tmp71_);
	budgie_screenshot_manager_screenshot_window (self, _ready_data->include_frame, _ready_data->include_cursor, _ready_data->flash, _ready_data->filename, (GAsyncReadyCallback) _dbus_budgie_screenshot_manager_screenshot_window_ready, _ready_data);
	_error:
	;
}

static void
_dbus_budgie_screenshot_manager_screenshot_window_ready (GObject * source_object,
                                                         GAsyncResult * _res_,
                                                         gpointer _user_data_)
{
	BudgieScreenshotManagerScreenshotWindowReadyData* _ready_data;
	GDBusMethodInvocation* invocation;
	GError* error = NULL;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	gboolean success = FALSE;
	gchar* filename_used = NULL;
	_ready_data = _user_data_;
	invocation = _ready_data->_invocation_;
	budgie_screenshot_manager_screenshot_window_finish ((BudgieScreenshotManager*) source_object, _res_, &success, &filename_used, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		goto _error;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_reply_builder, g_variant_new_boolean (success));
	g_variant_builder_add_value (&_reply_builder, g_variant_new_string (filename_used));
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	_error:
	_g_free0 (_ready_data->filename);
	_g_free0 (filename_used);
	g_slice_free (BudgieScreenshotManagerScreenshotWindowReadyData, _ready_data);
}

static void
budgie_screenshot_manager_dbus_interface_method_call (GDBusConnection* connection,
                                                      const gchar* sender,
                                                      const gchar* object_path,
                                                      const gchar* interface_name,
                                                      const gchar* method_name,
                                                      GVariant* parameters,
                                                      GDBusMethodInvocation* invocation,
                                                      gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (method_name, "SupportScreenshotWindow") == 0) {
		_dbus_budgie_screenshot_manager_SupportScreenshotWindow (object, parameters, invocation);
	} else if (strcmp (method_name, "Screenshot") == 0) {
		_dbus_budgie_screenshot_manager_screenshot (object, parameters, invocation);
	} else if (strcmp (method_name, "ScreenshotArea") == 0) {
		_dbus_budgie_screenshot_manager_screenshot_area (object, parameters, invocation);
	} else if (strcmp (method_name, "ScreenshotWindow") == 0) {
		_dbus_budgie_screenshot_manager_screenshot_window (object, parameters, invocation);
	} else {
		g_object_unref (invocation);
	}
}

static GVariant*
budgie_screenshot_manager_dbus_interface_get_property (GDBusConnection* connection,
                                                       const gchar* sender,
                                                       const gchar* object_path,
                                                       const gchar* interface_name,
                                                       const gchar* property_name,
                                                       GError** error,
                                                       gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return NULL;
}

static gboolean
budgie_screenshot_manager_dbus_interface_set_property (GDBusConnection* connection,
                                                       const gchar* sender,
                                                       const gchar* object_path,
                                                       const gchar* interface_name,
                                                       const gchar* property_name,
                                                       GVariant* value,
                                                       GError** error,
                                                       gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return FALSE;
}

guint
budgie_screenshot_manager_register_object (gpointer object,
                                           GDBusConnection* connection,
                                           const gchar* path,
                                           GError** error)
{
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_budgie_screenshot_manager_dbus_interface_info), &_budgie_screenshot_manager_dbus_interface_vtable, data, _budgie_screenshot_manager_unregister_object, error);
	if (!result) {
		return 0;
	}
	return result;
}

static void
_budgie_screenshot_manager_unregister_object (gpointer user_data)
{
	gpointer* data;
	data = user_data;
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}

