// SPDX-FileCopyrightText: 2020 - 2022 UnionTech Software Technology Co., Ltd.
//
// SPDX-License-Identifier: GPL-3.0-or-later

#include "drawdialog.h"
#include "utils/baseutils.h"
#include "drawshape/cdrawparamsigleton.h"
#include "application.h"

#include <QHBoxLayout>
#include <DLabel>
#include <QLineEdit>
#include <QKeyEvent>
#include <QDebug>
#include <QApplication>

DrawDialog::DrawDialog(DWidget *parent)
    : DDialog(parent)
{
    qDebug() << "Initializing DrawDialog";
    setModal(true);

    setWgtAccesibleName(this, "Notice save dialog");

    setIcon(QIcon::fromTheme("deepin-draw"));

    addButton(tr("Cancel"), false, DDialog::ButtonNormal);
    addButton(tr("Discard"), false, DDialog::ButtonNormal);
    addButton(tr("Save"), true, DDialog::ButtonRecommend);

    // Input content
    DLabel *title = new DLabel(tr("Save the current contents?"), this);
    title->setWordWrap(true);
    title->setAlignment(Qt::AlignCenter);

    DWidget *w = new DWidget(this);
    w->setFixedHeight(this->height() - 80);

    QVBoxLayout *layout = new QVBoxLayout(w);
    layout->setContentsMargins(0, 0, 0, 0);
    layout->setSpacing(8);
    layout->addStretch();
    layout->addWidget(title);
    layout->addStretch();
    addContent(w);
}

void DrawDialog::keyPressEvent(QKeyEvent *e)
{
    if (e->key() == Qt::Key_Escape) {
        qDebug() << "Escape key pressed, closing dialog";
        this->close();
    }
}

extern QWidget *defaultParentWindow();
void DrawDialog::showEvent(QShowEvent *event)
{
    qDebug() << "Showing DrawDialog";
    QMetaObject::invokeMethod(this, [ = ]() {
        QMetaObject::invokeMethod(this, [ = ]() {
            auto window = this->parentWidget() != nullptr ? this->parentWidget()->window() : defaultParentWindow();
            if (window != nullptr) {
                QPoint centerPos = window->geometry().center() - this->geometry().center();
                QRect parentWindowGem = window->geometry();

                centerPos = parentWindowGem.topLeft() + QPoint((parentWindowGem.width() - this->width()) / 2,
                                                               (parentWindowGem.height() - this->height()) / 2);

                qDebug() << "Positioning dialog at:" << centerPos;
                this->move(centerPos);
            } else {
                qWarning() << "No parent window found for dialog positioning";
            }
        }, Qt::QueuedConnection);
    }, Qt::QueuedConnection);

    DDialog::showEvent(event);
}

