/* Generated by wayland-scanner 1.24.0 */

#ifndef EFL_HINTS_SERVER_PROTOCOL_H
#define EFL_HINTS_SERVER_PROTOCOL_H

#include <stdint.h>
#include <stddef.h>
#include "wayland-server.h"

#ifdef  __cplusplus
extern "C" {
#endif

struct wl_client;
struct wl_resource;

/**
 * @page page_efl_hints The efl_hints protocol
 * @section page_ifaces_efl_hints Interfaces
 * - @subpage page_iface_efl_hints - 
 */
struct efl_hints;
struct xdg_surface;

#ifndef EFL_HINTS_INTERFACE
#define EFL_HINTS_INTERFACE
/**
 * @page page_iface_efl_hints efl_hints
 * @section page_iface_efl_hints_api API
 * See @ref iface_efl_hints.
 */
/**
 * @defgroup iface_efl_hints The efl_hints interface
 */
extern const struct wl_interface efl_hints_interface;
#endif

#ifndef EFL_HINTS_ASPECT_ENUM
#define EFL_HINTS_ASPECT_ENUM
enum efl_hints_aspect {
	EFL_HINTS_ASPECT_NONE = 0,
	EFL_HINTS_ASPECT_NEITHER = 1,
	EFL_HINTS_ASPECT_HORIZONTAL = 2,
	EFL_HINTS_ASPECT_VERTICAL = 3,
	EFL_HINTS_ASPECT_BOTH = 4,
};
#endif /* EFL_HINTS_ASPECT_ENUM */

#ifndef EFL_HINTS_ASPECT_ENUM_IS_VALID
#define EFL_HINTS_ASPECT_ENUM_IS_VALID
/**
 * @ingroup iface_efl_hints
 * Validate a efl_hints aspect value.
 *
 * @return true on success, false on error.
 * @ref efl_hints_aspect
 */
static inline bool
efl_hints_aspect_is_valid(uint32_t value, uint32_t version) {
	switch (value) {
	case EFL_HINTS_ASPECT_NONE:
		return version >= 1;
	case EFL_HINTS_ASPECT_NEITHER:
		return version >= 1;
	case EFL_HINTS_ASPECT_HORIZONTAL:
		return version >= 1;
	case EFL_HINTS_ASPECT_VERTICAL:
		return version >= 1;
	case EFL_HINTS_ASPECT_BOTH:
		return version >= 1;
	default:
		return false;
	}
}
#endif /* EFL_HINTS_ASPECT_ENUM_IS_VALID */

/**
 * @ingroup iface_efl_hints
 * @struct efl_hints_interface
 */
struct efl_hints_interface {
	/**
	 */
	void (*set_aspect)(struct wl_client *client,
			   struct wl_resource *resource,
			   struct wl_resource *surface,
			   uint32_t width,
			   uint32_t height,
			   uint32_t aspect);
	/**
	 */
	void (*set_weight)(struct wl_client *client,
			   struct wl_resource *resource,
			   struct wl_resource *surface,
			   int32_t width,
			   int32_t height);
};


/**
 * @ingroup iface_efl_hints
 */
#define EFL_HINTS_SET_ASPECT_SINCE_VERSION 1
/**
 * @ingroup iface_efl_hints
 */
#define EFL_HINTS_SET_WEIGHT_SINCE_VERSION 1

#ifdef  __cplusplus
}
#endif

#endif
