/* Generated by wayland-scanner 1.24.0 */

#ifndef WL_EGLSTREAM_CONTROLLER_CLIENT_PROTOCOL_H
#define WL_EGLSTREAM_CONTROLLER_CLIENT_PROTOCOL_H

#include <stdint.h>
#include <stddef.h>
#include "wayland-client.h"

#ifdef  __cplusplus
extern "C" {
#endif

/**
 * @page page_wl_eglstream_controller The wl_eglstream_controller protocol
 * @section page_ifaces_wl_eglstream_controller Interfaces
 * - @subpage page_iface_wl_eglstream_controller - 
 * @section page_copyright_wl_eglstream_controller Copyright
 * <pre>
 *
 * Copyright (c) 2017-2018, NVIDIA CORPORATION. All rights reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 * </pre>
 */
struct wl_buffer;
struct wl_eglstream_controller;
struct wl_surface;

#ifndef WL_EGLSTREAM_CONTROLLER_INTERFACE
#define WL_EGLSTREAM_CONTROLLER_INTERFACE
/**
 * @page page_iface_wl_eglstream_controller wl_eglstream_controller
 * @section page_iface_wl_eglstream_controller_api API
 * See @ref iface_wl_eglstream_controller.
 */
/**
 * @defgroup iface_wl_eglstream_controller The wl_eglstream_controller interface
 */
extern const struct wl_interface wl_eglstream_controller_interface;
#endif

#ifndef WL_EGLSTREAM_CONTROLLER_PRESENT_MODE_ENUM
#define WL_EGLSTREAM_CONTROLLER_PRESENT_MODE_ENUM
/**
 * @ingroup iface_wl_eglstream_controller
 * Stream present mode
 *
 * - dont_care: Using this enum will tell the server to make its own
 * decisions regarding present mode.
 *
 * - fifo:      Tells the server to use a fifo present mode. The decision to
 * use fifo synchronous is left up to the server.
 *
 * - mailbox:   Tells the server to use a mailbox present mode.
 */
enum wl_eglstream_controller_present_mode {
	/**
	 * Let the Server decide present mode
	 */
	WL_EGLSTREAM_CONTROLLER_PRESENT_MODE_DONT_CARE = 0,
	/**
	 * Use a fifo present mode
	 */
	WL_EGLSTREAM_CONTROLLER_PRESENT_MODE_FIFO = 1,
	/**
	 * Use a mailbox mode
	 */
	WL_EGLSTREAM_CONTROLLER_PRESENT_MODE_MAILBOX = 2,
};
#endif /* WL_EGLSTREAM_CONTROLLER_PRESENT_MODE_ENUM */

#ifndef WL_EGLSTREAM_CONTROLLER_ATTRIB_ENUM
#define WL_EGLSTREAM_CONTROLLER_ATTRIB_ENUM
/**
 * @ingroup iface_wl_eglstream_controller
 * Stream consumer attachment attributes
 *
 * - present_mode: Must be one of wl_eglstream_controller_present_mode. Tells the
 * server the desired present mode that should be used.
 *
 * - fifo_length:  Only valid when the present_mode attrib is provided and its
 * value is specified as fifo. Tells the server the desired fifo
 * length to be used when the desired present_mode is fifo.
 */
enum wl_eglstream_controller_attrib {
	/**
	 * Tells the server the desired present mode
	 */
	WL_EGLSTREAM_CONTROLLER_ATTRIB_PRESENT_MODE = 0,
	/**
	 * Tells the server the desired fifo length when the desired presenation_mode is fifo.
	 */
	WL_EGLSTREAM_CONTROLLER_ATTRIB_FIFO_LENGTH = 1,
};
#endif /* WL_EGLSTREAM_CONTROLLER_ATTRIB_ENUM */

#define WL_EGLSTREAM_CONTROLLER_ATTACH_EGLSTREAM_CONSUMER 0
#define WL_EGLSTREAM_CONTROLLER_ATTACH_EGLSTREAM_CONSUMER_ATTRIBS 1


/**
 * @ingroup iface_wl_eglstream_controller
 */
#define WL_EGLSTREAM_CONTROLLER_ATTACH_EGLSTREAM_CONSUMER_SINCE_VERSION 1
/**
 * @ingroup iface_wl_eglstream_controller
 */
#define WL_EGLSTREAM_CONTROLLER_ATTACH_EGLSTREAM_CONSUMER_ATTRIBS_SINCE_VERSION 2

/** @ingroup iface_wl_eglstream_controller */
static inline void
wl_eglstream_controller_set_user_data(struct wl_eglstream_controller *wl_eglstream_controller, void *user_data)
{
	wl_proxy_set_user_data((struct wl_proxy *) wl_eglstream_controller, user_data);
}

/** @ingroup iface_wl_eglstream_controller */
static inline void *
wl_eglstream_controller_get_user_data(struct wl_eglstream_controller *wl_eglstream_controller)
{
	return wl_proxy_get_user_data((struct wl_proxy *) wl_eglstream_controller);
}

static inline uint32_t
wl_eglstream_controller_get_version(struct wl_eglstream_controller *wl_eglstream_controller)
{
	return wl_proxy_get_version((struct wl_proxy *) wl_eglstream_controller);
}

/** @ingroup iface_wl_eglstream_controller */
static inline void
wl_eglstream_controller_destroy(struct wl_eglstream_controller *wl_eglstream_controller)
{
	wl_proxy_destroy((struct wl_proxy *) wl_eglstream_controller);
}

/**
 * @ingroup iface_wl_eglstream_controller
 *
 * Creates the corresponding server side EGLStream from the given wl_buffer
 * and attaches a consumer to it.
 */
static inline void
wl_eglstream_controller_attach_eglstream_consumer(struct wl_eglstream_controller *wl_eglstream_controller, struct wl_surface *wl_surface, struct wl_buffer *wl_resource)
{
	wl_proxy_marshal_flags((struct wl_proxy *) wl_eglstream_controller,
			 WL_EGLSTREAM_CONTROLLER_ATTACH_EGLSTREAM_CONSUMER, NULL, wl_proxy_get_version((struct wl_proxy *) wl_eglstream_controller), 0, wl_surface, wl_resource);
}

/**
 * @ingroup iface_wl_eglstream_controller
 *
 * It contains key-value pairs compatible with intptr_t type. A key must
 * be one of wl_eglstream_controller_attrib enumeration values. What a value
 * represents is attribute-specific.
 */
static inline void
wl_eglstream_controller_attach_eglstream_consumer_attribs(struct wl_eglstream_controller *wl_eglstream_controller, struct wl_surface *wl_surface, struct wl_buffer *wl_resource, struct wl_array *attribs)
{
	wl_proxy_marshal_flags((struct wl_proxy *) wl_eglstream_controller,
			 WL_EGLSTREAM_CONTROLLER_ATTACH_EGLSTREAM_CONSUMER_ATTRIBS, NULL, wl_proxy_get_version((struct wl_proxy *) wl_eglstream_controller), 0, wl_surface, wl_resource, attribs);
}

#ifdef  __cplusplus
}
#endif

#endif
