// SPDX-FileCopyrightText: Copyright (c) Ken Martin, Will Schroeder, Bill Lorensen
// SPDX-License-Identifier: BSD-3-Clause
#include "vtkF3DBitonicSortLocalSortCS.h"

const char *vtkF3DBitonicSortLocalSortCS =
"#version 430\n"
"\n"
"//VTK::BitonicDefines::Dec\n"
"\n"
"layout(local_size_x = WorkgroupSize) in;\n"
"layout(std430) buffer;\n"
"\n"
"layout(binding = 0) buffer Keys\n"
"{\n"
"  KeyType key[];\n"
"};\n"
"\n"
"layout(binding = 1) buffer Values\n"
"{\n"
"  ValueType value[];\n"
"};\n"
"\n"
"layout(location = 0) uniform int count;\n"
"\n"
"//VTK::BitonicFunctions::Dec\n"
"\n"
"void main()\n"
"{\n"
"  for (uint h = 1; h <= WorkgroupSize; h *= 2)\n"
"  {\n"
"    barrier();\n"
"    compare_and_swap(flip(h));\n"
"\n"
"    for (uint hh = h; hh >= 1; hh /= 2)\n"
"    {\n"
"      barrier();\n"
"      compare_and_swap(disperse(hh));\n"
"    }\n"
"  }\n"
"}\n"
"";
