#ifndef DOM_BINDINGNAMES_H_
#define DOM_BINDINGNAMES_H_

#include <stddef.h>
#include <stdint.h>
#include "mozilla/Attributes.h"

namespace mozilla::dom {

enum class BindingNamesOffset : uint16_t {
  ANGLE_instanced_arrays = 0,
  APZHitResultFlags = 23,
  AbortController = 41,
  AbortSignal = 57,
  AbstractRange = 69,
  AccessibleNode = 83,
  Addon = 98,
  AddonEvent = 104,
  AddonInstall = 115,
  AddonManager = 128,
  AddonManagerPermissions = 141,
  AnalyserNode = 165,
  Animation = 178,
  AnimationEffect = 188,
  AnimationEvent = 204,
  AnimationPlaybackEvent = 219,
  AnimationTimeline = 242,
  AnonymousContent = 260,
  Attr = 277,
  Audio = 282,
  AudioBuffer = 288,
  AudioBufferSourceNode = 300,
  AudioContext = 322,
  AudioData = 335,
  AudioDecoder = 345,
  AudioDestinationNode = 358,
  AudioEncoder = 379,
  AudioListener = 392,
  AudioNode = 406,
  AudioParam = 416,
  AudioParamMap = 427,
  AudioProcessingEvent = 441,
  AudioScheduledSourceNode = 462,
  AudioTrack = 487,
  AudioTrackList = 498,
  AudioWorklet = 513,
  AudioWorkletGlobalScope = 526,
  AudioWorkletNode = 550,
  AudioWorkletProcessor = 567,
  AuthenticatorAssertionResponse = 589,
  AuthenticatorAttestationResponse = 620,
  AuthenticatorResponse = 653,
  BarProp = 675,
  BaseAudioContext = 683,
  BatteryManager = 700,
  BeforeUnloadEvent = 715,
  BiquadFilterNode = 733,
  Blob = 750,
  BlobEvent = 755,
  BroadcastChannel = 765,
  BrowsingContext = 782,
  BrowsingContextGroup = 798,
  ByteLengthQueuingStrategy = 819,
  CDATASection = 845,
  CSPViolationReportBody = 858,
  CSS = 881,
  CSSAnimation = 885,
  CSSColor = 898,
  CSSColorValue = 907,
  CSSConditionRule = 921,
  CSSContainerRule = 938,
  CSSCounterStyleRule = 955,
  CSSCustomMediaRule = 975,
  CSSCustomPropertyRegisteredEvent = 994,
  CSSFontFaceRule = 1027,
  CSSFontFeatureValuesRule = 1043,
  CSSFontPaletteValuesRule = 1068,
  CSSGroupingRule = 1093,
  CSSHSL = 1109,
  CSSHWB = 1116,
  CSSImageValue = 1123,
  CSSImportRule = 1137,
  CSSKeyframeRule = 1151,
  CSSKeyframesRule = 1167,
  CSSKeywordValue = 1184,
  CSSLCH = 1200,
  CSSLab = 1207,
  CSSLayerBlockRule = 1214,
  CSSLayerStatementRule = 1232,
  CSSMarginRule = 1254,
  CSSMathClamp = 1268,
  CSSMathInvert = 1281,
  CSSMathMax = 1295,
  CSSMathMin = 1306,
  CSSMathNegate = 1317,
  CSSMathProduct = 1331,
  CSSMathSum = 1346,
  CSSMathValue = 1357,
  CSSMatrixComponent = 1370,
  CSSMediaRule = 1389,
  CSSMozDocumentRule = 1402,
  CSSNamespaceRule = 1421,
  CSSNestedDeclarations = 1438,
  CSSNumericArray = 1460,
  CSSNumericValue = 1476,
  CSSOKLCH = 1492,
  CSSOKLab = 1501,
  CSSPageDescriptors = 1510,
  CSSPageRule = 1529,
  CSSPerspective = 1541,
  CSSPositionTryDescriptors = 1556,
  CSSPositionTryRule = 1582,
  CSSPropertyRule = 1601,
  CSSPseudoElement = 1617,
  CSSRGB = 1634,
  CSSRotate = 1641,
  CSSRule = 1651,
  CSSRuleList = 1659,
  CSSScale = 1671,
  CSSScopeRule = 1680,
  CSSSkew = 1693,
  CSSSkewX = 1701,
  CSSSkewY = 1710,
  CSSStartingStyleRule = 1719,
  CSSStyleDeclaration = 1740,
  CSSStyleProperties = 1760,
  CSSStyleRule = 1779,
  CSSStyleSheet = 1792,
  CSSStyleValue = 1806,
  CSSSupportsRule = 1820,
  CSSTransformComponent = 1836,
  CSSTransformValue = 1858,
  CSSTransition = 1876,
  CSSTranslate = 1890,
  CSSUnitValue = 1903,
  CSSUnparsedValue = 1916,
  CSSVariableReferenceValue = 1933,
  Cache = 1959,
  CacheStorage = 1965,
  CallbackDebuggerNotification = 1978,
  CanonicalBrowsingContext = 2007,
  CanvasCaptureMediaStream = 2032,
  CanvasGradient = 2057,
  CanvasPattern = 2072,
  CanvasRenderingContext2D = 2086,
  CaretPosition = 2111,
  CaretStateChangedEvent = 2125,
  ChannelMergerNode = 2148,
  ChannelSplitterNode = 2166,
  ChannelWrapper = 2186,
  CharacterData = 2201,
  CheckerboardReportService = 2215,
  ChildProcessMessageManager = 2241,
  ChildSHistory = 2268,
  ChromeMessageBroadcaster = 2282,
  ChromeMessageSender = 2307,
  ChromeNodeList = 2327,
  ChromeUtils = 2342,
  ChromeWorker = 2354,
  Client = 2367,
  Clients = 2374,
  Clipboard = 2382,
  ClipboardEvent = 2392,
  ClipboardItem = 2407,
  ClonedErrorHolder = 2421,
  CloseEvent = 2439,
  CloseWatcher = 2450,
  CommandEvent = 2463,
  Comment = 2476,
  CompositionEvent = 2484,
  CompressionStream = 2501,
  ConsoleInstance = 2519,
  ConstantSourceNode = 2535,
  ContentFrameMessageManager = 2554,
  ContentProcessMessageManager = 2581,
  ContentVisibilityAutoStateChangeEvent = 2610,
  ConvolverNode = 2648,
  CookieChangeEvent = 2662,
  CookieStore = 2680,
  CookieStoreManager = 2692,
  CountQueuingStrategy = 2711,
  CreateOfferRequest = 2732,
  Credential = 2751,
  CredentialsContainer = 2762,
  Crypto = 2783,
  CryptoKey = 2790,
  CustomElementRegistry = 2800,
  CustomEvent = 2822,
  CustomStateSet = 2834,
  DOMException = 2849,
  DOMImplementation = 2862,
  DOMLocalization = 2880,
  DOMMatrix = 2896,
  DOMMatrixReadOnly = 2906,
  DOMParser = 2924,
  DOMPoint = 2934,
  DOMPointReadOnly = 2943,
  DOMQuad = 2960,
  DOMRect = 2968,
  DOMRectList = 2976,
  DOMRectReadOnly = 2988,
  DOMStringList = 3004,
  DOMStringMap = 3018,
  DOMTokenList = 3031,
  DataTransfer = 3044,
  DataTransferItem = 3057,
  DataTransferItemList = 3074,
  DebuggerNotification = 3095,
  DebuggerNotificationObserver = 3116,
  DecompressionStream = 3145,
  DedicatedWorkerGlobalScope = 3165,
  DelayNode = 3192,
  DeprecationReportBody = 3202,
  DeviceAcceleration = 3224,
  DeviceLightEvent = 3243,
  DeviceMotionEvent = 3260,
  DeviceOrientationEvent = 3278,
  DeviceRotationRate = 3301,
  DigitalCredential = 3320,
  Directory = 3338,
  Document = 3348,
  DocumentFragment = 3357,
  DocumentL10n = 3374,
  DocumentPictureInPicture = 3387,
  DocumentPictureInPictureEvent = 3412,
  DocumentTimeline = 3442,
  DocumentType = 3459,
  DominatorTree = 3472,
  DragEvent = 3486,
  DynamicsCompressorNode = 3496,
  EXT_blend_minmax = 3519,
  EXT_color_buffer_float = 3536,
  EXT_color_buffer_half_float = 3559,
  EXT_depth_clamp = 3587,
  EXT_disjoint_timer_query = 3603,
  EXT_float_blend = 3628,
  EXT_frag_depth = 3644,
  EXT_sRGB = 3659,
  EXT_shader_texture_lod = 3668,
  EXT_texture_compression_bptc = 3691,
  EXT_texture_compression_rgtc = 3720,
  EXT_texture_filter_anisotropic = 3749,
  EXT_texture_norm16 = 3780,
  Element = 3799,
  ElementInternals = 3807,
  EncodedAudioChunk = 3824,
  EncodedVideoChunk = 3842,
  ErrorEvent = 3860,
  Event = 3871,
  EventCallbackDebuggerNotification = 3877,
  EventCounts = 3911,
  EventSource = 3923,
  EventTarget = 3935,
  Exception = 3947,
  ExtendableCookieChangeEvent = 3957,
  ExtendableEvent = 3985,
  ExtendableMessageEvent = 4001,
  ExtensionAlarms = 4024,
  ExtensionBrowser = 4040,
  ExtensionBrowserSettings = 4057,
  ExtensionBrowserSettingsColorManagement = 4082,
  ExtensionDns = 4122,
  ExtensionEventManager = 4135,
  ExtensionMockAPI = 4157,
  ExtensionPort = 4174,
  ExtensionProxy = 4188,
  ExtensionRuntime = 4203,
  ExtensionScripting = 4220,
  ExtensionSetting = 4239,
  ExtensionTest = 4256,
  External = 4270,
  FeaturePolicy = 4279,
  FeaturePolicyViolationReportBody = 4293,
  FetchEvent = 4326,
  FetchObserver = 4337,
  File = 4351,
  FileList = 4356,
  FileReader = 4365,
  FileReaderSync = 4376,
  FileSystem = 4391,
  FileSystemDirectoryEntry = 4402,
  FileSystemDirectoryHandle = 4427,
  FileSystemDirectoryHandle_AsyncIterator = 4453,
  FileSystemDirectoryIterator = 4493,
  FileSystemDirectoryReader = 4521,
  FileSystemEntry = 4547,
  FileSystemFileEntry = 4563,
  FileSystemFileHandle = 4583,
  FileSystemHandle = 4604,
  FileSystemSyncAccessHandle = 4621,
  FileSystemWritableFileStream = 4648,
  Flex = 4677,
  FlexItemValues = 4682,
  FlexLineValues = 4697,
  FluentBundle = 4712,
  FluentBundleAsyncIterator = 4725,
  FluentBundleIterator = 4751,
  FluentPattern = 4772,
  FluentResource = 4786,
  FocusEvent = 4801,
  FontFace = 4812,
  FontFaceSet = 4821,
  FontFaceSetIterator = 4833,
  FontFaceSetLoadEvent = 4853,
  FormData = 4874,
  FormData_Iterator = 4883,
  FormDataEvent = 4901,
  FragmentDirective = 4915,
  FrameCrashedEvent = 4933,
  FrameLoader = 4951,
  GPU = 4963,
  GPUAdapter = 4967,
  GPUAdapterInfo = 4978,
  GPUBindGroup = 4993,
  GPUBindGroupLayout = 5006,
  GPUBuffer = 5025,
  GPUBufferUsage = 5035,
  GPUCanvasContext = 5050,
  GPUColorWrite = 5067,
  GPUCommandBuffer = 5081,
  GPUCommandEncoder = 5098,
  GPUCompilationInfo = 5116,
  GPUCompilationMessage = 5135,
  GPUComputePassEncoder = 5157,
  GPUComputePipeline = 5179,
  GPUDevice = 5198,
  GPUDeviceLostInfo = 5208,
  GPUError = 5226,
  GPUExternalTexture = 5235,
  GPUInternalError = 5254,
  GPUMapMode = 5271,
  GPUOutOfMemoryError = 5282,
  GPUPipelineError = 5302,
  GPUPipelineLayout = 5319,
  GPUQuerySet = 5337,
  GPUQueue = 5349,
  GPURenderBundle = 5358,
  GPURenderBundleEncoder = 5374,
  GPURenderPassEncoder = 5397,
  GPURenderPipeline = 5418,
  GPUSampler = 5436,
  GPUShaderModule = 5447,
  GPUShaderStage = 5463,
  GPUSupportedFeatures = 5478,
  GPUSupportedLimits = 5499,
  GPUTexture = 5518,
  GPUTextureUsage = 5529,
  GPUTextureView = 5545,
  GPUUncapturedErrorEvent = 5560,
  GPUValidationError = 5584,
  GainNode = 5603,
  Gamepad = 5612,
  GamepadAxisMoveEvent = 5620,
  GamepadButton = 5641,
  GamepadButtonEvent = 5655,
  GamepadEvent = 5674,
  GamepadHapticActuator = 5687,
  GamepadLightIndicator = 5709,
  GamepadPose = 5731,
  GamepadServiceTest = 5743,
  GamepadTouch = 5762,
  Geolocation = 5775,
  GeolocationCoordinates = 5787,
  GeolocationPosition = 5810,
  GeolocationPositionError = 5830,
  GetUserMediaRequest = 5855,
  GleanBoolean = 5875,
  GleanCategory = 5888,
  GleanCounter = 5902,
  GleanCustomDistribution = 5915,
  GleanDatetime = 5939,
  GleanDenominator = 5953,
  GleanDualLabeledCounter = 5970,
  GleanEvent = 5994,
  GleanImpl = 6005,
  GleanLabeled = 6015,
  GleanMemoryDistribution = 6028,
  GleanMetric = 6052,
  GleanNumerator = 6064,
  GleanObject = 6079,
  GleanPingsImpl = 6091,
  GleanQuantity = 6106,
  GleanRate = 6120,
  GleanString = 6130,
  GleanStringList = 6142,
  GleanText = 6158,
  GleanTimespan = 6168,
  GleanTimingDistribution = 6182,
  GleanUrl = 6206,
  GleanUuid = 6215,
  Grid = 6225,
  GridArea = 6230,
  GridDimension = 6239,
  GridLine = 6253,
  GridLines = 6262,
  GridTrack = 6272,
  GridTracks = 6282,
  HTMLAllCollection = 6293,
  HTMLAnchorElement = 6311,
  HTMLAreaElement = 6329,
  HTMLAudioElement = 6345,
  HTMLBRElement = 6362,
  HTMLBaseElement = 6376,
  HTMLBodyElement = 6392,
  HTMLButtonElement = 6408,
  HTMLCanvasElement = 6426,
  HTMLCollection = 6444,
  HTMLDListElement = 6459,
  HTMLDataElement = 6476,
  HTMLDataListElement = 6492,
  HTMLDetailsElement = 6512,
  HTMLDialogElement = 6531,
  HTMLDirectoryElement = 6549,
  HTMLDivElement = 6570,
  HTMLDocument = 6585,
  HTMLElement = 6598,
  HTMLEmbedElement = 6610,
  HTMLFieldSetElement = 6627,
  HTMLFontElement = 6647,
  HTMLFormControlsCollection = 6663,
  HTMLFormElement = 6690,
  HTMLFrameElement = 6706,
  HTMLFrameSetElement = 6723,
  HTMLHRElement = 6743,
  HTMLHeadElement = 6757,
  HTMLHeadingElement = 6773,
  HTMLHtmlElement = 6792,
  HTMLIFrameElement = 6808,
  HTMLImageElement = 6826,
  HTMLInputElement = 6843,
  HTMLLIElement = 6860,
  HTMLLabelElement = 6874,
  HTMLLegendElement = 6891,
  HTMLLinkElement = 6909,
  HTMLMapElement = 6925,
  HTMLMarqueeElement = 6940,
  HTMLMediaElement = 6959,
  HTMLMenuElement = 6976,
  HTMLMetaElement = 6992,
  HTMLMeterElement = 7008,
  HTMLModElement = 7025,
  HTMLOListElement = 7040,
  HTMLObjectElement = 7057,
  HTMLOptGroupElement = 7075,
  HTMLOptionElement = 7095,
  HTMLOptionsCollection = 7113,
  HTMLOutputElement = 7135,
  HTMLParagraphElement = 7153,
  HTMLParamElement = 7174,
  HTMLPictureElement = 7191,
  HTMLPreElement = 7210,
  HTMLProgressElement = 7225,
  HTMLQuoteElement = 7245,
  HTMLScriptElement = 7262,
  HTMLSelectElement = 7280,
  HTMLSlotElement = 7298,
  HTMLSourceElement = 7314,
  HTMLSpanElement = 7332,
  HTMLStyleElement = 7348,
  HTMLTableCaptionElement = 7365,
  HTMLTableCellElement = 7389,
  HTMLTableColElement = 7410,
  HTMLTableElement = 7430,
  HTMLTableRowElement = 7447,
  HTMLTableSectionElement = 7467,
  HTMLTemplateElement = 7491,
  HTMLTextAreaElement = 7511,
  HTMLTimeElement = 7531,
  HTMLTitleElement = 7547,
  HTMLTrackElement = 7564,
  HTMLUListElement = 7581,
  HTMLUnknownElement = 7598,
  HTMLVideoElement = 7617,
  HashChangeEvent = 7634,
  Headers = 7650,
  Headers_Iterator = 7658,
  HeapSnapshot = 7675,
  Highlight = 7688,
  HighlightRegistry = 7698,
  History = 7716,
  IDBCursor = 7724,
  IDBCursorWithValue = 7734,
  IDBDatabase = 7753,
  IDBFactory = 7765,
  IDBIndex = 7776,
  IDBKeyRange = 7785,
  IDBObjectStore = 7797,
  IDBOpenDBRequest = 7812,
  IDBRequest = 7829,
  IDBTransaction = 7840,
  IDBVersionChangeEvent = 7855,
  IIRFilterNode = 7877,
  IOUtils = 7891,
  IdentityCredential = 7899,
  IdentityProvider = 7918,
  IdleDeadline = 7935,
  Image = 7948,
  ImageBitmap = 7954,
  ImageBitmapRenderingContext = 7966,
  ImageCapture = 7994,
  ImageCaptureError = 8007,
  ImageCaptureErrorEvent = 8025,
  ImageData = 8048,
  ImageDecoder = 8058,
  ImageDocument = 8071,
  ImageTrack = 8085,
  ImageTrackList = 8096,
  InferenceSession = 8111,
  InputEvent = 8128,
  InspectorCSSParser = 8139,
  InspectorFontFace = 8158,
  InspectorUtils = 8176,
  IntegrityViolationReportBody = 8191,
  IntersectionObserver = 8220,
  IntersectionObserverEntry = 8241,
  IntlUtils = 8267,
  JSActorTypeUtils = 8277,
  JSProcessActorChild = 8294,
  JSProcessActorParent = 8314,
  JSWindowActorChild = 8335,
  JSWindowActorParent = 8354,
  KeyEvent = 8374,
  KeyboardEvent = 8383,
  KeyframeEffect = 8397,
  L10nFileSource = 8412,
  L10nOverlays = 8427,
  L10nRegistry = 8440,
  LargestContentfulPaint = 8453,
  LegacyMozTCPSocket = 8476,
  LlamaRunner = 8495,
  Localization = 8507,
  Location = 8520,
  Lock = 8529,
  LockManager = 8534,
  MIDIAccess = 8546,
  MIDIConnectionEvent = 8557,
  MIDIInput = 8577,
  MIDIInputMap = 8587,
  MIDIMessageEvent = 8600,
  MIDIOutput = 8617,
  MIDIOutputMap = 8628,
  MIDIPort = 8642,
  MLS = 8651,
  MLSGroupView = 8655,
  MOZ_debug = 8668,
  MatchGlob = 8678,
  MatchPattern = 8688,
  MatchPatternSet = 8701,
  MathMLElement = 8717,
  MediaCapabilities = 8731,
  MediaControlService = 8749,
  MediaController = 8769,
  MediaDeviceInfo = 8785,
  MediaDevices = 8801,
  MediaElementAudioSourceNode = 8814,
  MediaEncryptedEvent = 8842,
  MediaError = 8862,
  MediaKeyError = 8873,
  MediaKeyMessageEvent = 8887,
  MediaKeySession = 8908,
  MediaKeyStatusMap = 8924,
  MediaKeyStatusMap_Iterator = 8942,
  MediaKeySystemAccess = 8969,
  MediaKeys = 8990,
  MediaList = 9000,
  MediaMetadata = 9010,
  MediaQueryList = 9024,
  MediaQueryListEvent = 9039,
  MediaRecorder = 9059,
  MediaRecorderErrorEvent = 9073,
  MediaSession = 9097,
  MediaSource = 9110,
  MediaStream = 9122,
  MediaStreamAudioDestinationNode = 9134,
  MediaStreamAudioSourceNode = 9166,
  MediaStreamError = 9193,
  MediaStreamEvent = 9210,
  MediaStreamTrack = 9227,
  MediaStreamTrackAudioSourceNode = 9244,
  MediaStreamTrackEvent = 9276,
  MerchantValidationEvent = 9298,
  MessageBroadcaster = 9322,
  MessageChannel = 9341,
  MessageEvent = 9356,
  MessageListenerManager = 9369,
  MessagePort = 9392,
  MessageSender = 9404,
  MimeType = 9418,
  MimeTypeArray = 9427,
  MouseEvent = 9441,
  MouseScrollEvent = 9452,
  MozCanvasPrintState = 9469,
  MozDocumentMatcher = 9489,
  MozDocumentObserver = 9508,
  MozQueryInterface = 9528,
  MozSharedMap = 9546,
  MozSharedMap_Iterator = 9559,
  MozSharedMapChangeEvent = 9581,
  MozStorageAsyncStatementParams = 9605,
  MozStorageStatementParams = 9636,
  MozStorageStatementRow = 9662,
  MozWritableSharedMap = 9685,
  MutationObserver = 9706,
  MutationRecord = 9723,
  NamedNodeMap = 9738,
  NavigateEvent = 9751,
  Navigation = 9765,
  NavigationActivation = 9776,
  NavigationCurrentEntryChangeEvent = 9797,
  NavigationDestination = 9831,
  NavigationHistoryEntry = 9853,
  NavigationPrecommitController = 9876,
  NavigationPreloadManager = 9906,
  NavigationTransition = 9931,
  Navigator = 9952,
  NavigatorLogin = 9962,
  NetworkInformation = 9977,
  Node = 9996,
  NodeFilter = 10001,
  NodeIterator = 10012,
  NodeList = 10025,
  Notification = 10034,
  NotificationEvent = 10047,
  NotifyPaintEvent = 10065,
  OES_draw_buffers_indexed = 10082,
  OES_element_index_uint = 10107,
  OES_fbo_render_mipmap = 10130,
  OES_standard_derivatives = 10152,
  OES_texture_float = 10177,
  OES_texture_float_linear = 10195,
  OES_texture_half_float = 10220,
  OES_texture_half_float_linear = 10243,
  OES_vertex_array_object = 10273,
  OVR_multiview2 = 10297,
  OfflineAudioCompletionEvent = 10312,
  OfflineAudioContext = 10340,
  OffscreenCanvas = 10360,
  OffscreenCanvasRenderingContext2D = 10376,
  Option = 10410,
  OscillatorNode = 10417,
  PageRevealEvent = 10432,
  PageSwapEvent = 10448,
  PageTransitionEvent = 10462,
  PaintRequest = 10482,
  PaintRequestList = 10495,
  PaintWorkletGlobalScope = 10512,
  PannerNode = 10536,
  ParentProcessMessageManager = 10547,
  Path2D = 10575,
  PathUtils = 10582,
  PaymentAddress = 10592,
  PaymentMethodChangeEvent = 10607,
  PaymentRequest = 10632,
  PaymentRequestUpdateEvent = 10647,
  PaymentResponse = 10673,
  PeerConnectionImpl = 10689,
  PeerConnectionObserver = 10708,
  Performance = 10731,
  PerformanceEntry = 10743,
  PerformanceEntryEvent = 10760,
  PerformanceEventTiming = 10782,
  PerformanceMark = 10805,
  PerformanceMeasure = 10821,
  PerformanceNavigation = 10840,
  PerformanceNavigationTiming = 10862,
  PerformanceObserver = 10890,
  PerformanceObserverEntryList = 10910,
  PerformancePaintTiming = 10939,
  PerformanceResourceTiming = 10962,
  PerformanceServerTiming = 10988,
  PerformanceTiming = 11012,
  PeriodicWave = 11030,
  PermissionStatus = 11043,
  Permissions = 11060,
  PlacesBookmark = 11072,
  PlacesBookmarkAddition = 11087,
  PlacesBookmarkChanged = 11110,
  PlacesBookmarkGuid = 11132,
  PlacesBookmarkKeyword = 11151,
  PlacesBookmarkMoved = 11173,
  PlacesBookmarkRemoved = 11193,
  PlacesBookmarkTags = 11215,
  PlacesBookmarkTime = 11234,
  PlacesBookmarkTitle = 11253,
  PlacesBookmarkUrl = 11273,
  PlacesEvent = 11291,
  PlacesEventCounts = 11303,
  PlacesFavicon = 11321,
  PlacesHistoryCleared = 11335,
  PlacesObservers = 11356,
  PlacesPurgeCaches = 11372,
  PlacesRanking = 11390,
  PlacesVisit = 11404,
  PlacesVisitRemoved = 11416,
  PlacesVisitTitle = 11435,
  PlacesWeakCallbackWrapper = 11452,
  Plugin = 11478,
  PluginArray = 11485,
  PluginCrashedEvent = 11497,
  PointerEvent = 11516,
  PopStateEvent = 11529,
  PopupBlockedEvent = 11543,
  PopupPositionedEvent = 11561,
  PositionStateEvent = 11582,
  PrecompiledScript = 11601,
  PrivateAttribution = 11619,
  ProcessMessageManager = 11638,
  ProcessingInstruction = 11660,
  ProgressEvent = 11682,
  PromiseDebugging = 11696,
  PromiseNativeHandler = 11713,
  PromiseRejectionEvent = 11734,
  PublicKeyCredential = 11756,
  PushEvent = 11776,
  PushManager = 11786,
  PushManagerImpl = 11798,
  PushMessageData = 11814,
  PushSubscription = 11830,
  PushSubscriptionChangeEvent = 11847,
  PushSubscriptionOptions = 11875,
  RTCCertificate = 11899,
  RTCDTMFSender = 11914,
  RTCDTMFToneChangeEvent = 11928,
  RTCDataChannel = 11951,
  RTCDataChannelEvent = 11966,
  RTCDtlsTransport = 11986,
  RTCEncodedAudioFrame = 12003,
  RTCEncodedVideoFrame = 12024,
  RTCIceCandidate = 12045,
  RTCIceTransport = 12061,
  RTCIdentityProviderRegistrar = 12077,
  RTCPeerConnection = 12106,
  RTCPeerConnectionIceEvent = 12124,
  RTCPeerConnectionStatic = 12150,
  RTCRtpReceiver = 12174,
  RTCRtpScriptTransform = 12189,
  RTCRtpScriptTransformer = 12211,
  RTCRtpSender = 12235,
  RTCRtpTransceiver = 12248,
  RTCSctpTransport = 12266,
  RTCSessionDescription = 12283,
  RTCStatsReport = 12305,
  RTCTrackEvent = 12320,
  RTCTransformEvent = 12334,
  RadioNodeList = 12352,
  Range = 12366,
  ReadableByteStreamController = 12372,
  ReadableStream = 12401,
  ReadableStream_AsyncIterator = 12416,
  ReadableStreamBYOBReader = 12445,
  ReadableStreamBYOBRequest = 12470,
  ReadableStreamDefaultController = 12496,
  ReadableStreamDefaultReader = 12528,
  RedirectBlockedEvent = 12556,
  Report = 12577,
  ReportBody = 12584,
  ReportingObserver = 12595,
  Request = 12613,
  ResizeObserver = 12621,
  ResizeObserverEntry = 12636,
  ResizeObserverSize = 12656,
  Response = 12675,
  SVGAElement = 12684,
  SVGAngle = 12696,
  SVGAnimateElement = 12705,
  SVGAnimateMotionElement = 12723,
  SVGAnimateTransformElement = 12747,
  SVGAnimatedAngle = 12774,
  SVGAnimatedBoolean = 12791,
  SVGAnimatedEnumeration = 12810,
  SVGAnimatedInteger = 12833,
  SVGAnimatedLength = 12852,
  SVGAnimatedLengthList = 12870,
  SVGAnimatedNumber = 12892,
  SVGAnimatedNumberList = 12910,
  SVGAnimatedPreserveAspectRatio = 12932,
  SVGAnimatedRect = 12963,
  SVGAnimatedString = 12979,
  SVGAnimatedTransformList = 12997,
  SVGAnimationElement = 13022,
  SVGCircleElement = 13042,
  SVGClipPathElement = 13059,
  SVGComponentTransferFunctionElement = 13078,
  SVGDefsElement = 13114,
  SVGDescElement = 13129,
  SVGElement = 13144,
  SVGEllipseElement = 13155,
  SVGFEBlendElement = 13173,
  SVGFEColorMatrixElement = 13191,
  SVGFEComponentTransferElement = 13215,
  SVGFECompositeElement = 13245,
  SVGFEConvolveMatrixElement = 13267,
  SVGFEDiffuseLightingElement = 13294,
  SVGFEDisplacementMapElement = 13322,
  SVGFEDistantLightElement = 13350,
  SVGFEDropShadowElement = 13375,
  SVGFEFloodElement = 13398,
  SVGFEFuncAElement = 13416,
  SVGFEFuncBElement = 13434,
  SVGFEFuncGElement = 13452,
  SVGFEFuncRElement = 13470,
  SVGFEGaussianBlurElement = 13488,
  SVGFEImageElement = 13513,
  SVGFEMergeElement = 13531,
  SVGFEMergeNodeElement = 13549,
  SVGFEMorphologyElement = 13571,
  SVGFEOffsetElement = 13594,
  SVGFEPointLightElement = 13613,
  SVGFESpecularLightingElement = 13636,
  SVGFESpotLightElement = 13665,
  SVGFETileElement = 13687,
  SVGFETurbulenceElement = 13704,
  SVGFilterElement = 13727,
  SVGForeignObjectElement = 13744,
  SVGGElement = 13768,
  SVGGeometryElement = 13780,
  SVGGradientElement = 13799,
  SVGGraphicsElement = 13818,
  SVGImageElement = 13837,
  SVGLength = 13853,
  SVGLengthList = 13863,
  SVGLineElement = 13877,
  SVGLinearGradientElement = 13892,
  SVGMPathElement = 13917,
  SVGMarkerElement = 13933,
  SVGMaskElement = 13950,
  SVGMatrix = 13965,
  SVGMetadataElement = 13975,
  SVGNumber = 13994,
  SVGNumberList = 14004,
  SVGPathElement = 14018,
  SVGPathSegment = 14033,
  SVGPatternElement = 14048,
  SVGPoint = 14066,
  SVGPointList = 14075,
  SVGPolygonElement = 14088,
  SVGPolylineElement = 14106,
  SVGPreserveAspectRatio = 14125,
  SVGRadialGradientElement = 14148,
  SVGRect = 14173,
  SVGRectElement = 14181,
  SVGSVGElement = 14196,
  SVGScriptElement = 14210,
  SVGSetElement = 14227,
  SVGStopElement = 14241,
  SVGStringList = 14256,
  SVGStyleElement = 14270,
  SVGSwitchElement = 14286,
  SVGSymbolElement = 14303,
  SVGTSpanElement = 14320,
  SVGTextContentElement = 14336,
  SVGTextElement = 14358,
  SVGTextPathElement = 14373,
  SVGTextPositioningElement = 14392,
  SVGTitleElement = 14418,
  SVGTransform = 14434,
  SVGTransformList = 14447,
  SVGUnitTypes = 14464,
  SVGUseElement = 14477,
  SVGViewElement = 14491,
  Sanitizer = 14506,
  Scheduler = 14516,
  Screen = 14526,
  ScreenLuminance = 14533,
  ScreenOrientation = 14549,
  ScriptProcessorNode = 14567,
  ScrollAreaEvent = 14587,
  SecurityPolicyViolationEvent = 14603,
  Selection = 14632,
  ServiceWorker = 14642,
  ServiceWorkerContainer = 14656,
  ServiceWorkerGlobalScope = 14679,
  ServiceWorkerRegistration = 14704,
  SessionStoreFormData = 14730,
  SessionStoreScrollData = 14751,
  SessionStoreUtils = 14774,
  ShadowRoot = 14792,
  SharedWorker = 14803,
  SharedWorkerGlobalScope = 14816,
  SimpleGestureEvent = 14840,
  SourceBuffer = 14859,
  SourceBufferList = 14872,
  SpeechGrammar = 14889,
  SpeechGrammarList = 14903,
  SpeechRecognition = 14921,
  SpeechRecognitionAlternative = 14939,
  SpeechRecognitionError = 14968,
  SpeechRecognitionEvent = 14991,
  SpeechRecognitionResult = 15014,
  SpeechRecognitionResultList = 15038,
  SpeechSynthesis = 15066,
  SpeechSynthesisErrorEvent = 15082,
  SpeechSynthesisEvent = 15108,
  SpeechSynthesisUtterance = 15129,
  SpeechSynthesisVoice = 15154,
  StaticRange = 15175,
  StereoPannerNode = 15187,
  Storage = 15204,
  StorageEvent = 15212,
  StorageManager = 15225,
  StreamFilter = 15240,
  StreamFilterDataEvent = 15253,
  StructuredCloneHolder = 15275,
  StructuredCloneTester = 15297,
  StylePropertyMap = 15319,
  StylePropertyMapReadOnly = 15336,
  StylePropertyMapReadOnly_Iterator = 15361,
  StyleSheet = 15395,
  StyleSheetApplicableStateChangeEvent = 15406,
  StyleSheetList = 15443,
  StyleSheetRemovedEvent = 15458,
  SubmitEvent = 15481,
  SubtleCrypto = 15493,
  SyncMessageSender = 15506,
  SyncReadFile = 15524,
  TCPServerSocket = 15537,
  TCPServerSocketEvent = 15553,
  TCPSocket = 15574,
  TCPSocketErrorEvent = 15584,
  TCPSocketEvent = 15604,
  TaskController = 15619,
  TaskPriorityChangeEvent = 15634,
  TaskSignal = 15658,
  Tensor = 15669,
  TestReportBody = 15676,
  TestReportGenerator = 15691,
  TestUtils = 15711,
  TestingDeprecatedInterface = 15721,
  Text = 15748,
  TextClause = 15753,
  TextDecoder = 15764,
  TextDecoderStream = 15776,
  TextEncoder = 15794,
  TextEncoderStream = 15806,
  TextEvent = 15824,
  TextMetrics = 15834,
  TextTrack = 15846,
  TextTrackCue = 15856,
  TextTrackCueList = 15869,
  TextTrackList = 15886,
  TimeEvent = 15900,
  TimeRanges = 15910,
  ToggleEvent = 15921,
  Touch = 15933,
  TouchEvent = 15939,
  TouchList = 15950,
  TrackEvent = 15960,
  TransformStream = 15971,
  TransformStreamDefaultController = 15987,
  TransitionEvent = 16020,
  TreeColumn = 16036,
  TreeColumns = 16047,
  TreeContentView = 16059,
  TreeWalker = 16075,
  TrustedHTML = 16086,
  TrustedScript = 16098,
  TrustedScriptURL = 16112,
  TrustedTypePolicy = 16129,
  TrustedTypePolicyFactory = 16147,
  UDPMessageEvent = 16172,
  UDPSocket = 16188,
  UIEvent = 16198,
  URL = 16206,
  URLPattern = 16210,
  URLSearchParams = 16221,
  URLSearchParams_Iterator = 16237,
  UniFFIPointer = 16262,
  UniFFIScaffolding = 16276,
  UserActivation = 16294,
  UserInteraction = 16309,
  UserProximityEvent = 16325,
  VRDisplay = 16344,
  VRDisplayCapabilities = 16354,
  VRDisplayEvent = 16376,
  VREyeParameters = 16391,
  VRFieldOfView = 16407,
  VRFrameData = 16421,
  VRMockController = 16433,
  VRMockDisplay = 16450,
  VRPose = 16464,
  VRServiceTest = 16471,
  VRStageParameters = 16485,
  VTTCue = 16503,
  VTTRegion = 16510,
  ValidityState = 16520,
  VideoColorSpace = 16534,
  VideoDecoder = 16550,
  VideoEncoder = 16563,
  VideoFrame = 16576,
  VideoPlaybackQuality = 16587,
  VideoTrack = 16608,
  VideoTrackList = 16619,
  ViewTransition = 16634,
  ViewTransitionTypeSet = 16649,
  VisualViewport = 16671,
  WEBGL_color_buffer_float = 16686,
  WEBGL_compressed_texture_astc = 16711,
  WEBGL_compressed_texture_etc = 16741,
  WEBGL_compressed_texture_etc1 = 16770,
  WEBGL_compressed_texture_pvrtc = 16800,
  WEBGL_compressed_texture_s3tc = 16831,
  WEBGL_compressed_texture_s3tc_srgb = 16861,
  WEBGL_debug_renderer_info = 16896,
  WEBGL_debug_shaders = 16922,
  WEBGL_depth_texture = 16942,
  WEBGL_draw_buffers = 16962,
  WEBGL_explicit_present = 16981,
  WEBGL_lose_context = 17004,
  WEBGL_provoking_vertex = 17023,
  WGSLLanguageFeatures = 17046,
  WakeLock = 17067,
  WakeLockSentinel = 17076,
  WaveShaperNode = 17093,
  WebExtensionContentScript = 17108,
  WebExtensionPolicy = 17134,
  WebGL2RenderingContext = 17153,
  WebGLActiveInfo = 17176,
  WebGLBuffer = 17192,
  WebGLContextEvent = 17204,
  WebGLFramebuffer = 17222,
  WebGLProgram = 17239,
  WebGLQuery = 17252,
  WebGLRenderbuffer = 17263,
  WebGLRenderingContext = 17281,
  WebGLSampler = 17303,
  WebGLShader = 17316,
  WebGLShaderPrecisionFormat = 17328,
  WebGLSync = 17355,
  WebGLTexture = 17365,
  WebGLTransformFeedback = 17378,
  WebGLUniformLocation = 17401,
  WebGLVertexArrayObject = 17422,
  WebKitCSSMatrix = 17445,
  WebSocket = 17461,
  WebTransport = 17471,
  WebTransportBidirectionalStream = 17484,
  WebTransportDatagramDuplexStream = 17516,
  WebTransportError = 17549,
  WebTransportReceiveStream = 17567,
  WebTransportSendStream = 17593,
  WebrtcGlobalInformation = 17616,
  WheelEvent = 17640,
  Window = 17651,
  WindowClient = 17658,
  WindowContext = 17671,
  WindowGlobalChild = 17685,
  WindowGlobalParent = 17703,
  WindowRoot = 17722,
  Worker = 17733,
  WorkerDebuggerGlobalScope = 17740,
  WorkerGlobalScope = 17766,
  WorkerLocation = 17784,
  WorkerNavigator = 17799,
  WorkerTestUtils = 17815,
  Worklet = 17831,
  WorkletGlobalScope = 17839,
  WritableStream = 17858,
  WritableStreamDefaultController = 17873,
  WritableStreamDefaultWriter = 17905,
  XMLDocument = 17933,
  XMLHttpRequest = 17945,
  XMLHttpRequestEventTarget = 17960,
  XMLHttpRequestUpload = 17986,
  XMLSerializer = 18007,
  XPathEvaluator = 18021,
  XPathExpression = 18036,
  XPathResult = 18052,
  XRBoundedReferenceSpace = 18064,
  XRFrame = 18088,
  XRInputSource = 18096,
  XRInputSourceArray = 18110,
  XRInputSourceEvent = 18129,
  XRInputSourcesChangeEvent = 18148,
  XRPose = 18174,
  XRReferenceSpace = 18181,
  XRReferenceSpaceEvent = 18198,
  XRRenderState = 18220,
  XRRigidTransform = 18234,
  XRSession = 18251,
  XRSessionEvent = 18261,
  XRSpace = 18276,
  XRSystem = 18284,
  XRView = 18293,
  XRViewerPose = 18300,
  XRViewport = 18313,
  XRWebGLLayer = 18324,
  XSLTProcessor = 18337,
  XULCommandEvent = 18351,
  XULElement = 18367,
  XULFrameElement = 18378,
  XULMenuElement = 18394,
  XULPopupElement = 18409,
  XULResizerElement = 18425,
  XULTextElement = 18443,
  XULTreeElement = 18458,
  console = 18473,
  webkitSpeechGrammar = 18481,
  webkitSpeechGrammarList = 18501,
  webkitSpeechRecognition = 18525,
  webkitURL = 18549,
};

namespace binding_detail {
extern const char sBindingNames[];
}  // namespace binding_detail

MOZ_ALWAYS_INLINE const char* BindingName(BindingNamesOffset aOffset) {
  return binding_detail::sBindingNames + static_cast<size_t>(aOffset);
}

} // namespace mozilla::dom


#endif // DOM_BINDINGNAMES_H_
