/* THIS FILE IS AUTOGENERATED FROM Document.webidl BY Codegen.py - DO NOT EDIT */

#ifndef DOM_DOCUMENTBINDING_H_
#define DOM_DOCUMENTBINDING_H_

#include "ReferrerPolicyBinding.h"
#include "js/CallAndConstruct.h"
#include "jsapi.h"
#include "mozilla/ArrayUtils.h"
#include "mozilla/EnumTypeTraits.h"
#include "mozilla/Span.h"
#include "mozilla/dom/BindingDeclarations.h"
#include "mozilla/dom/CallbackFunction.h"
#include "mozilla/dom/FakeString.h"
#include "mozilla/dom/Nullable.h"
#include "mozilla/dom/PrototypeList.h"
#include "mozilla/dom/ShadowRoot.h"
#include "mozilla/dom/ToJSValue.h"
#include "mozilla/dom/UnionMember.h"
#include "nsCycleCollectionParticipant.h"
#include "nsIContent.h"

class nsINode;

namespace mozilla {

class StyleSheet;

namespace dom {

struct BlockParsingOptionsAtoms;
struct CaretPositionFromPointOptionsAtoms;
class Document;
struct ElementCreationOptionsAtoms;
struct NativePropertyHooks;
class OwningViewTransitionUpdateCallbackOrStartViewTransitionOptions;
class Promise;
class ProtoAndIfaceCache;
class ShadowRoot;
struct StartViewTransitionOptionsAtoms;
class ViewTransitionUpdateCallback;
struct WireframeAtoms;
struct WireframeTaggedRect;
struct WireframeTaggedRectAtoms;

} // namespace dom

} // namespace mozilla

namespace mozilla {

namespace dom {

enum class VisibilityState : uint8_t {
  Hidden,
  Visible,
};

namespace binding_detail {
template <> struct EnumStrings<VisibilityState> {
  static constexpr nsLiteralCString Values[2] {
    "hidden"_ns,
    "visible"_ns,
  };
};
} // namespace binding_detail

bool
ToJSValue(JSContext* aCx, VisibilityState aArgument, JS::MutableHandle<JS::Value> aValue);


enum class WireframeRectType : uint8_t {
  Image,
  Background,
  Text,
  Unknown,
};

namespace binding_detail {
template <> struct EnumStrings<WireframeRectType> {
  static constexpr nsLiteralCString Values[4] {
    "image"_ns,
    "background"_ns,
    "text"_ns,
    "unknown"_ns,
  };
};
} // namespace binding_detail

bool
ToJSValue(JSContext* aCx, WireframeRectType aArgument, JS::MutableHandle<JS::Value> aValue);


void
ImplCycleCollectionTraverse(nsCycleCollectionTraversalCallback& aCallback, OwningViewTransitionUpdateCallbackOrStartViewTransitionOptions& aUnion, const char* aName, uint32_t aFlags = 0);


void
ImplCycleCollectionUnlink(OwningViewTransitionUpdateCallbackOrStartViewTransitionOptions& aUnion);


struct BlockParsingOptions : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR bool mBlockScriptCreated;

  BlockParsingOptions();

  explicit inline BlockParsingOptions(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  BlockParsingOptions(BlockParsingOptions&& aOther) = default;

  explicit inline BlockParsingOptions(const BlockParsingOptions& aOther)
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);

  BlockParsingOptions&
  operator=(const BlockParsingOptions& aOther);

private:
  static bool
  InitIds(JSContext* cx, BlockParsingOptionsAtoms* atomsCache);
};

namespace binding_detail {
struct FastBlockParsingOptions : public BlockParsingOptions
{
  inline FastBlockParsingOptions()
    : BlockParsingOptions(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct CaretPositionFromPointOptions : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR Sequence<OwningNonNull<mozilla::dom::ShadowRoot>> mShadowRoots;

  CaretPositionFromPointOptions();

  explicit inline CaretPositionFromPointOptions(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  CaretPositionFromPointOptions(CaretPositionFromPointOptions&& aOther) = default;

  explicit inline CaretPositionFromPointOptions(const CaretPositionFromPointOptions& aOther)
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);

  inline void
  TraverseForCC(nsCycleCollectionTraversalCallback& aCallback, uint32_t aFlags)
  {
    ImplCycleCollectionTraverse(aCallback, mShadowRoots, "mShadowRoots", aFlags);
  }

  inline void
  UnlinkForCC()
  {
    ImplCycleCollectionUnlink(mShadowRoots);
  }

  CaretPositionFromPointOptions&
  operator=(const CaretPositionFromPointOptions& aOther);

private:
  static bool
  InitIds(JSContext* cx, CaretPositionFromPointOptionsAtoms* atomsCache);
};

namespace binding_detail {
struct FastCaretPositionFromPointOptions : public CaretPositionFromPointOptions
{
  inline FastCaretPositionFromPointOptions()
    : CaretPositionFromPointOptions(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct ElementCreationOptions : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR Optional<nsString> mIs;
  MOZ_INIT_OUTSIDE_CTOR Optional<nsString> mPseudo;

  ElementCreationOptions();

  explicit inline ElementCreationOptions(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  ElementCreationOptions(ElementCreationOptions&& aOther) = default;

  explicit inline ElementCreationOptions(const ElementCreationOptions& aOther)
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);

  ElementCreationOptions&
  operator=(const ElementCreationOptions& aOther);

private:
  static bool
  InitIds(JSContext* cx, ElementCreationOptionsAtoms* atomsCache);
};

namespace binding_detail {
struct FastElementCreationOptions : public ElementCreationOptions
{
  inline FastElementCreationOptions()
    : ElementCreationOptions(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


struct StartViewTransitionOptions : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR Nullable<Sequence<nsString>> mTypes;
  MOZ_INIT_OUTSIDE_CTOR RefPtr<ViewTransitionUpdateCallback> mUpdate;

  StartViewTransitionOptions();

  explicit inline StartViewTransitionOptions(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  StartViewTransitionOptions(StartViewTransitionOptions&& aOther) = default;

private:
  StartViewTransitionOptions(const StartViewTransitionOptions&) = delete;
  StartViewTransitionOptions& operator=(const StartViewTransitionOptions&) = delete;

  static bool
  InitIds(JSContext* cx, StartViewTransitionOptionsAtoms* atomsCache);

public:
  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);

  inline void
  TraverseForCC(nsCycleCollectionTraversalCallback& aCallback, uint32_t aFlags)
  {
    ImplCycleCollectionTraverse(aCallback, mUpdate, "mUpdate", aFlags);
  }

  inline void
  UnlinkForCC()
  {
    ImplCycleCollectionUnlink(mUpdate);
  }
};

namespace binding_detail {
struct FastStartViewTransitionOptions : public StartViewTransitionOptions
{
  inline FastStartViewTransitionOptions()
    : StartViewTransitionOptions(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


class ViewTransitionUpdateCallback : public CallbackFunction
{
public:
  explicit inline ViewTransitionUpdateCallback(JSContext* aCx, JS::Handle<JSObject*> aCallback, JS::Handle<JSObject*> aCallbackGlobal, nsIGlobalObject* aIncumbentGlobal)
    : CallbackFunction(aCx, aCallback, aCallbackGlobal, aIncumbentGlobal)
  {
    MOZ_ASSERT(JS::IsCallable(mCallback));
  }

  explicit inline ViewTransitionUpdateCallback(JSObject* aCallback, JSObject* aCallbackGlobal, const FastCallbackConstructor& )
    : CallbackFunction(aCallback, aCallbackGlobal, FastCallbackConstructor())
  {
    MOZ_ASSERT(JS::IsCallable(mCallback));
  }

  explicit inline ViewTransitionUpdateCallback(JSObject* aCallback, JSObject* aCallbackGlobal, JSObject* aAsyncStack, nsIGlobalObject* aIncumbentGlobal)
    : CallbackFunction(aCallback, aCallbackGlobal, aAsyncStack, aIncumbentGlobal)
  {
    MOZ_ASSERT(JS::IsCallable(mCallback));
  }

  explicit inline ViewTransitionUpdateCallback(CallbackFunction* aOther)
    : CallbackFunction(aOther)
  {
  }

  template <typename T>
  MOZ_CAN_RUN_SCRIPT inline already_AddRefed<Promise>
  Call(const T& thisVal, ErrorResult& aRv, const char* aExecutionReason = nullptr, ExceptionHandling aExceptionHandling = eReportExceptions, JS::Realm* aRealm = nullptr)
  {
    MOZ_ASSERT(!aRv.Failed(), "Don't pass an already-failed ErrorResult to a callback!");
    if (!aExecutionReason) {
      aExecutionReason = "ViewTransitionUpdateCallback";
    }
    CallSetup s(this, aRv, aExecutionReason, aExceptionHandling, aRealm);
    if (!s.GetContext()) {
      MOZ_ASSERT(aRv.Failed());
      return nullptr;
    }
    JS::Rooted<JS::Value> thisValJS(s.GetContext());
    if (!ToJSValue(s.GetContext(), thisVal, &thisValJS)) {
      aRv.Throw(NS_ERROR_FAILURE);
      return nullptr;
    }
    return Call(s.GetCallContext(), thisValJS, aRv);
  }

  MOZ_CAN_RUN_SCRIPT inline already_AddRefed<Promise>
  Call(ErrorResult& aRv, const char* aExecutionReason = nullptr, ExceptionHandling aExceptionHandling = eReportExceptions, JS::Realm* aRealm = nullptr)
  {
    MOZ_ASSERT(!aRv.Failed(), "Don't pass an already-failed ErrorResult to a callback!");
    if (!aExecutionReason) {
      aExecutionReason = "ViewTransitionUpdateCallback";
    }
    CallSetup s(this, aRv, aExecutionReason, aExceptionHandling, aRealm);
    if (!s.GetContext()) {
      MOZ_ASSERT(aRv.Failed());
      return nullptr;
    }
    return Call(s.GetCallContext(), JS::UndefinedHandleValue, aRv);
  }

  template <typename T>
  MOZ_CAN_RUN_SCRIPT inline already_AddRefed<Promise>
  Call(const T& thisVal, const char* aExecutionReason = nullptr)
  {
    return Call(thisVal, IgnoreErrors(), aExecutionReason);
  }

  MOZ_CAN_RUN_SCRIPT inline already_AddRefed<Promise>
  Call(const char* aExecutionReason = nullptr)
  {
    return Call(IgnoreErrors(), aExecutionReason, eReportExceptions, nullptr);
  }

  inline bool
  operator==(const ViewTransitionUpdateCallback& aOther) const
  {
    return CallbackFunction::operator==(aOther);
  }

private:
  MOZ_CAN_RUN_SCRIPT already_AddRefed<Promise> Call(BindingCallContext& cx, JS::Handle<JS::Value> aThisVal, ErrorResult& aRv);
};


namespace binding_detail {
class FastViewTransitionUpdateCallback : public ViewTransitionUpdateCallback
{
public:
  explicit inline FastViewTransitionUpdateCallback(JSObject* aCallback, JSObject* aCallbackGlobal)
    : ViewTransitionUpdateCallback(aCallback, aCallbackGlobal, FastCallbackConstructor())
  {
  }

  inline void
  Trace(JSTracer* aTracer)
  {
    ViewTransitionUpdateCallback::Trace(aTracer);
  }

  inline void
  FinishSlowJSInitIfMoreThanOneOwner(JSContext* aCx)
  {
    ViewTransitionUpdateCallback::FinishSlowJSInitIfMoreThanOneOwner(aCx);
  }
};
} // namespace binding_detail


struct WireframeTaggedRect : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR uint32_t mColor;
  MOZ_INIT_OUTSIDE_CTOR double mHeight;
  MOZ_INIT_OUTSIDE_CTOR Optional<RefPtr<nsINode>> mNode;
  MOZ_INIT_OUTSIDE_CTOR Optional<WireframeRectType> mType;
  MOZ_INIT_OUTSIDE_CTOR double mWidth;
  MOZ_INIT_OUTSIDE_CTOR double mX;
  MOZ_INIT_OUTSIDE_CTOR double mY;

  WireframeTaggedRect();

  explicit inline WireframeTaggedRect(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  WireframeTaggedRect(WireframeTaggedRect&& aOther) = default;

  explicit inline WireframeTaggedRect(const WireframeTaggedRect& aOther)
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const;

  void
  TraceDictionary(JSTracer* trc);

  inline void
  TraverseForCC(nsCycleCollectionTraversalCallback& aCallback, uint32_t aFlags)
  {
    ImplCycleCollectionTraverse(aCallback, mNode, "mNode", aFlags);
  }

  inline void
  UnlinkForCC()
  {
    ImplCycleCollectionUnlink(mNode);
  }

  WireframeTaggedRect&
  operator=(const WireframeTaggedRect& aOther);

private:
  static bool
  InitIds(JSContext* cx, WireframeTaggedRectAtoms* atomsCache);
};

namespace binding_detail {
struct FastWireframeTaggedRect : public WireframeTaggedRect
{
  inline FastWireframeTaggedRect()
    : WireframeTaggedRect(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


class ElementCreationOptionsOrString : public AllUnionBase
{
  enum TypeOrUninit
  {
    eUninitialized,
    eElementCreationOptions,
    eString
  };
public:
  enum class Type
  {
    eElementCreationOptions = TypeOrUninit::eElementCreationOptions,
    eString = TypeOrUninit::eString
  };

private:
  union Value
  {
    UnionMember<binding_detail::FastElementCreationOptions > mElementCreationOptions;
    UnionMember<binding_detail::FakeString<char16_t> > mString;

  };

  TypeOrUninit mType;
  Value mValue;

  ElementCreationOptionsOrString(const ElementCreationOptionsOrString&) = delete;
  ElementCreationOptionsOrString& operator=(const ElementCreationOptionsOrString&) = delete;
public:
  explicit inline ElementCreationOptionsOrString()
    : mType(eUninitialized)
  {
  }

  inline ~ElementCreationOptionsOrString()
  {
    Uninit();
  }

  [[nodiscard]] inline binding_detail::FastElementCreationOptions&
  RawSetAsElementCreationOptions()
  {
    if (mType == eElementCreationOptions) {
      return mValue.mElementCreationOptions.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eElementCreationOptions;
    return mValue.mElementCreationOptions.SetValue();
  }

  [[nodiscard]] inline binding_detail::FastElementCreationOptions&
  SetAsElementCreationOptions()
  {
    if (mType == eElementCreationOptions) {
      return mValue.mElementCreationOptions.Value();
    }
    Uninit();
    mType = eElementCreationOptions;
    return mValue.mElementCreationOptions.SetValue();
  }

  inline bool
  IsElementCreationOptions() const
  {
    return mType == eElementCreationOptions;
  }

  inline binding_detail::FastElementCreationOptions&
  GetAsElementCreationOptions()
  {
    MOZ_RELEASE_ASSERT(IsElementCreationOptions(), "Wrong type!");
    return mValue.mElementCreationOptions.Value();
  }

  inline const ElementCreationOptions&
  GetAsElementCreationOptions() const
  {
    MOZ_RELEASE_ASSERT(IsElementCreationOptions(), "Wrong type!");
    return mValue.mElementCreationOptions.Value();
  }

  [[nodiscard]] inline binding_detail::FakeString<char16_t>&
  RawSetAsString()
  {
    if (mType == eString) {
      return mValue.mString.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eString;
    return mValue.mString.SetValue();
  }

  [[nodiscard]] inline binding_detail::FakeString<char16_t>&
  SetAsString()
  {
    if (mType == eString) {
      return mValue.mString.Value();
    }
    Uninit();
    mType = eString;
    return mValue.mString.SetValue();
  }

  template <int N>
  inline void
  SetStringLiteral(const nsString::char_type (&aData)[N])
  {
    RawSetAsString().AssignLiteral(aData);
  }

  inline bool
  IsString() const
  {
    return mType == eString;
  }

  inline binding_detail::FakeString<char16_t>&
  GetAsString()
  {
    MOZ_RELEASE_ASSERT(IsString(), "Wrong type!");
    return mValue.mString.Value();
  }

  inline const nsAString&
  GetAsString() const
  {
    MOZ_RELEASE_ASSERT(IsString(), "Wrong type!");
    return mValue.mString.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  inline void
  Uninit()
  {
    switch (mType) {
      case eUninitialized: {
        break;
      }
      case eElementCreationOptions: {
        DestroyElementCreationOptions();
        break;
      }
      case eString: {
        DestroyString();
        break;
      }
    }
  }

private:
  bool
  TrySetToElementCreationOptions(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToElementCreationOptions(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyElementCreationOptions()
  {
    MOZ_RELEASE_ASSERT(IsElementCreationOptions(), "Wrong type!");
    mValue.mElementCreationOptions.Destroy();
    mType = eUninitialized;
  }

  bool
  TrySetToString(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyString()
  {
    MOZ_RELEASE_ASSERT(IsString(), "Wrong type!");
    mValue.mString.Destroy();
    mType = eUninitialized;
  }
};


class OwningElementCreationOptionsOrString : public AllOwningUnionBase
{
  enum TypeOrUninit
  {
    eUninitialized,
    eElementCreationOptions,
    eString
  };
public:
  enum class Type
  {
    eElementCreationOptions = TypeOrUninit::eElementCreationOptions,
    eString = TypeOrUninit::eString
  };

private:
  union Value
  {
    UnionMember<ElementCreationOptions > mElementCreationOptions;
    UnionMember<nsString > mString;

  };

  TypeOrUninit mType;
  Value mValue;

public:
  explicit inline OwningElementCreationOptionsOrString()
    : mType(eUninitialized)
  {
  }

  OwningElementCreationOptionsOrString(OwningElementCreationOptionsOrString&& aOther);

  explicit inline OwningElementCreationOptionsOrString(const OwningElementCreationOptionsOrString& aOther)
    : mType(eUninitialized)
  {
    *this = aOther;
  }

  inline ~OwningElementCreationOptionsOrString()
  {
    Uninit();
  }

  [[nodiscard]] ElementCreationOptions&
  RawSetAsElementCreationOptions();

  [[nodiscard]] ElementCreationOptions&
  SetAsElementCreationOptions();

  inline bool
  IsElementCreationOptions() const
  {
    return mType == eElementCreationOptions;
  }

  inline ElementCreationOptions&
  GetAsElementCreationOptions()
  {
    MOZ_RELEASE_ASSERT(IsElementCreationOptions(), "Wrong type!");
    return mValue.mElementCreationOptions.Value();
  }

  inline ElementCreationOptions const &
  GetAsElementCreationOptions() const
  {
    MOZ_RELEASE_ASSERT(IsElementCreationOptions(), "Wrong type!");
    return mValue.mElementCreationOptions.Value();
  }

  [[nodiscard]] nsString&
  RawSetAsString();

  [[nodiscard]] nsString&
  SetAsString();

  template <int N>
  inline void
  SetStringLiteral(const nsString::char_type (&aData)[N])
  {
    RawSetAsString().AssignLiteral(aData);
  }

  inline bool
  IsString() const
  {
    return mType == eString;
  }

  inline nsString&
  GetAsString()
  {
    MOZ_RELEASE_ASSERT(IsString(), "Wrong type!");
    return mValue.mString.Value();
  }

  inline nsString const &
  GetAsString() const
  {
    MOZ_RELEASE_ASSERT(IsString(), "Wrong type!");
    return mValue.mString.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  Uninit();

  OwningElementCreationOptionsOrString&
  operator=(OwningElementCreationOptionsOrString&& aOther);

  inline Type
  GetType() const
  {
    MOZ_RELEASE_ASSERT(mType != eUninitialized);
    return static_cast<Type>(mType);
  }

  OwningElementCreationOptionsOrString&
  operator=(const OwningElementCreationOptionsOrString& aOther);

private:
  bool
  TrySetToElementCreationOptions(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToElementCreationOptions(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyElementCreationOptions();

  bool
  TrySetToString(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyString();
};


class ViewTransitionUpdateCallbackOrStartViewTransitionOptions : public AllUnionBase
{
  enum TypeOrUninit
  {
    eUninitialized,
    eViewTransitionUpdateCallback,
    eStartViewTransitionOptions
  };
public:
  enum class Type
  {
    eViewTransitionUpdateCallback = TypeOrUninit::eViewTransitionUpdateCallback,
    eStartViewTransitionOptions = TypeOrUninit::eStartViewTransitionOptions
  };

private:
  union Value
  {
    UnionMember<RootedCallback<OwningNonNull<binding_detail::FastViewTransitionUpdateCallback>> > mViewTransitionUpdateCallback;
    UnionMember<binding_detail::FastStartViewTransitionOptions > mStartViewTransitionOptions;

  };

  TypeOrUninit mType;
  Value mValue;

  ViewTransitionUpdateCallbackOrStartViewTransitionOptions(const ViewTransitionUpdateCallbackOrStartViewTransitionOptions&) = delete;
  ViewTransitionUpdateCallbackOrStartViewTransitionOptions& operator=(const ViewTransitionUpdateCallbackOrStartViewTransitionOptions&) = delete;
public:
  explicit inline ViewTransitionUpdateCallbackOrStartViewTransitionOptions()
    : mType(eUninitialized)
  {
  }

  inline ~ViewTransitionUpdateCallbackOrStartViewTransitionOptions()
  {
    Uninit();
  }

  [[nodiscard]] inline RootedCallback<OwningNonNull<binding_detail::FastViewTransitionUpdateCallback>>&
  RawSetAsViewTransitionUpdateCallback(JSContext* cx)
  {
    if (mType == eViewTransitionUpdateCallback) {
      return mValue.mViewTransitionUpdateCallback.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eViewTransitionUpdateCallback;
    return mValue.mViewTransitionUpdateCallback.SetValue(cx);
  }

  [[nodiscard]] inline RootedCallback<OwningNonNull<binding_detail::FastViewTransitionUpdateCallback>>&
  SetAsViewTransitionUpdateCallback(JSContext* cx)
  {
    if (mType == eViewTransitionUpdateCallback) {
      return mValue.mViewTransitionUpdateCallback.Value();
    }
    Uninit();
    mType = eViewTransitionUpdateCallback;
    return mValue.mViewTransitionUpdateCallback.SetValue(cx);
  }

  inline bool
  IsViewTransitionUpdateCallback() const
  {
    return mType == eViewTransitionUpdateCallback;
  }

  inline RootedCallback<OwningNonNull<binding_detail::FastViewTransitionUpdateCallback>>&
  GetAsViewTransitionUpdateCallback()
  {
    MOZ_RELEASE_ASSERT(IsViewTransitionUpdateCallback(), "Wrong type!");
    return mValue.mViewTransitionUpdateCallback.Value();
  }

  inline ViewTransitionUpdateCallback&
  GetAsViewTransitionUpdateCallback() const
  {
    MOZ_RELEASE_ASSERT(IsViewTransitionUpdateCallback(), "Wrong type!");
    return mValue.mViewTransitionUpdateCallback.Value();
  }

  [[nodiscard]] inline binding_detail::FastStartViewTransitionOptions&
  RawSetAsStartViewTransitionOptions()
  {
    if (mType == eStartViewTransitionOptions) {
      return mValue.mStartViewTransitionOptions.Value();
    }
    MOZ_ASSERT(mType == eUninitialized);
    mType = eStartViewTransitionOptions;
    return mValue.mStartViewTransitionOptions.SetValue();
  }

  [[nodiscard]] inline binding_detail::FastStartViewTransitionOptions&
  SetAsStartViewTransitionOptions()
  {
    if (mType == eStartViewTransitionOptions) {
      return mValue.mStartViewTransitionOptions.Value();
    }
    Uninit();
    mType = eStartViewTransitionOptions;
    return mValue.mStartViewTransitionOptions.SetValue();
  }

  inline bool
  IsStartViewTransitionOptions() const
  {
    return mType == eStartViewTransitionOptions;
  }

  inline binding_detail::FastStartViewTransitionOptions&
  GetAsStartViewTransitionOptions()
  {
    MOZ_RELEASE_ASSERT(IsStartViewTransitionOptions(), "Wrong type!");
    return mValue.mStartViewTransitionOptions.Value();
  }

  inline const StartViewTransitionOptions&
  GetAsStartViewTransitionOptions() const
  {
    MOZ_RELEASE_ASSERT(IsStartViewTransitionOptions(), "Wrong type!");
    return mValue.mStartViewTransitionOptions.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  inline void
  Uninit()
  {
    switch (mType) {
      case eUninitialized: {
        break;
      }
      case eViewTransitionUpdateCallback: {
        DestroyViewTransitionUpdateCallback();
        break;
      }
      case eStartViewTransitionOptions: {
        DestroyStartViewTransitionOptions();
        break;
      }
    }
  }

private:
  bool
  TrySetToViewTransitionUpdateCallback(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToViewTransitionUpdateCallback(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyViewTransitionUpdateCallback()
  {
    MOZ_RELEASE_ASSERT(IsViewTransitionUpdateCallback(), "Wrong type!");
    mValue.mViewTransitionUpdateCallback.Destroy();
    mType = eUninitialized;
  }

  bool
  TrySetToStartViewTransitionOptions(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToStartViewTransitionOptions(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  inline void
  DestroyStartViewTransitionOptions()
  {
    MOZ_RELEASE_ASSERT(IsStartViewTransitionOptions(), "Wrong type!");
    mValue.mStartViewTransitionOptions.Destroy();
    mType = eUninitialized;
  }
};


class OwningViewTransitionUpdateCallbackOrStartViewTransitionOptions : public AllOwningUnionBase
{
  friend void ImplCycleCollectionUnlink(OwningViewTransitionUpdateCallbackOrStartViewTransitionOptions& aUnion);
  enum TypeOrUninit
  {
    eUninitialized,
    eViewTransitionUpdateCallback,
    eStartViewTransitionOptions
  };
public:
  enum class Type
  {
    eViewTransitionUpdateCallback = TypeOrUninit::eViewTransitionUpdateCallback,
    eStartViewTransitionOptions = TypeOrUninit::eStartViewTransitionOptions
  };

private:
  union Value
  {
    UnionMember<OwningNonNull<ViewTransitionUpdateCallback> > mViewTransitionUpdateCallback;
    UnionMember<StartViewTransitionOptions > mStartViewTransitionOptions;

  };

  TypeOrUninit mType;
  Value mValue;

  OwningViewTransitionUpdateCallbackOrStartViewTransitionOptions(const OwningViewTransitionUpdateCallbackOrStartViewTransitionOptions&) = delete;
  OwningViewTransitionUpdateCallbackOrStartViewTransitionOptions& operator=(const OwningViewTransitionUpdateCallbackOrStartViewTransitionOptions&) = delete;
public:
  explicit inline OwningViewTransitionUpdateCallbackOrStartViewTransitionOptions()
    : mType(eUninitialized)
  {
  }

  OwningViewTransitionUpdateCallbackOrStartViewTransitionOptions(OwningViewTransitionUpdateCallbackOrStartViewTransitionOptions&& aOther);

  inline ~OwningViewTransitionUpdateCallbackOrStartViewTransitionOptions()
  {
    Uninit();
  }

  [[nodiscard]] OwningNonNull<ViewTransitionUpdateCallback>&
  RawSetAsViewTransitionUpdateCallback();

  [[nodiscard]] OwningNonNull<ViewTransitionUpdateCallback>&
  SetAsViewTransitionUpdateCallback();

  inline bool
  IsViewTransitionUpdateCallback() const
  {
    return mType == eViewTransitionUpdateCallback;
  }

  inline OwningNonNull<ViewTransitionUpdateCallback>&
  GetAsViewTransitionUpdateCallback()
  {
    MOZ_RELEASE_ASSERT(IsViewTransitionUpdateCallback(), "Wrong type!");
    return mValue.mViewTransitionUpdateCallback.Value();
  }

  inline OwningNonNull<ViewTransitionUpdateCallback> const &
  GetAsViewTransitionUpdateCallback() const
  {
    MOZ_RELEASE_ASSERT(IsViewTransitionUpdateCallback(), "Wrong type!");
    return mValue.mViewTransitionUpdateCallback.Value();
  }

  [[nodiscard]] StartViewTransitionOptions&
  RawSetAsStartViewTransitionOptions();

  [[nodiscard]] StartViewTransitionOptions&
  SetAsStartViewTransitionOptions();

  inline bool
  IsStartViewTransitionOptions() const
  {
    return mType == eStartViewTransitionOptions;
  }

  inline StartViewTransitionOptions&
  GetAsStartViewTransitionOptions()
  {
    MOZ_RELEASE_ASSERT(IsStartViewTransitionOptions(), "Wrong type!");
    return mValue.mStartViewTransitionOptions.Value();
  }

  inline StartViewTransitionOptions const &
  GetAsStartViewTransitionOptions() const
  {
    MOZ_RELEASE_ASSERT(IsStartViewTransitionOptions(), "Wrong type!");
    return mValue.mStartViewTransitionOptions.Value();
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  Uninit();

  OwningViewTransitionUpdateCallbackOrStartViewTransitionOptions&
  operator=(OwningViewTransitionUpdateCallbackOrStartViewTransitionOptions&& aOther);

  inline Type
  GetType() const
  {
    MOZ_RELEASE_ASSERT(mType != eUninitialized);
    return static_cast<Type>(mType);
  }

private:
  bool
  TrySetToViewTransitionUpdateCallback(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToViewTransitionUpdateCallback(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyViewTransitionUpdateCallback();

  bool
  TrySetToStartViewTransitionOptions(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  bool
  TrySetToStartViewTransitionOptions(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl = false);

  void
  DestroyStartViewTransitionOptions();
};


struct Wireframe : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR uint32_t mCanvasBackground;
  MOZ_INIT_OUTSIDE_CTOR Optional<Sequence<WireframeTaggedRect>> mRects;
  MOZ_INIT_OUTSIDE_CTOR uint32_t mVersion;

  Wireframe();

  explicit inline Wireframe(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  Wireframe(Wireframe&& aOther) = default;

  explicit inline Wireframe(const Wireframe& aOther)
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const;

  void
  TraceDictionary(JSTracer* trc);

  inline void
  TraverseForCC(nsCycleCollectionTraversalCallback& aCallback, uint32_t aFlags)
  {
    ImplCycleCollectionTraverse(aCallback, mRects, "mRects", aFlags);
  }

  inline void
  UnlinkForCC()
  {
    ImplCycleCollectionUnlink(mRects);
  }

  Wireframe&
  operator=(const Wireframe& aOther);

private:
  static bool
  InitIds(JSContext* cx, WireframeAtoms* atomsCache);
};

namespace binding_detail {
struct FastWireframe : public Wireframe
{
  inline FastWireframe()
    : Wireframe(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


namespace Document_Binding {

  typedef mozilla::dom::Document NativeType;

  constexpr uint16_t KEYPRESS_EVENT_MODEL_DEFAULT = 0;
  constexpr uint16_t KEYPRESS_EVENT_MODEL_SPLIT = 1;
  constexpr uint16_t KEYPRESS_EVENT_MODEL_CONFLATED = 2;
  namespace AdoptedStyleSheetsHelpers {
  already_AddRefed<StyleSheet>
  ElementAt(mozilla::dom::Document* self, uint32_t aIndex, ErrorResult& aRv);

  void
  ReplaceElementAt(mozilla::dom::Document* self, uint32_t aIndex, StyleSheet& aValue, ErrorResult& aRv);

  void
  AppendElement(mozilla::dom::Document* self, StyleSheet& aValue, ErrorResult& aRv);

  void
  RemoveLastElement(mozilla::dom::Document* self, ErrorResult& aRv);

  uint32_t
  Length(mozilla::dom::Document* self, ErrorResult& aRv);
  } // namespace AdoptedStyleSheetsHelpers

  bool
  Wrap(JSContext* aCx, mozilla::dom::Document* aObject, nsWrapperCache* aCache, JS::Handle<JSObject*> aGivenProto, JS::MutableHandle<JSObject*> aReflector);

  template <class T>
  inline JSObject* Wrap(JSContext* aCx, T* aObject, JS::Handle<JSObject*> aGivenProto)
  {
    JS::Rooted<JSObject*> reflector(aCx);
    return Wrap(aCx, aObject, aObject, aGivenProto, &reflector) ? reflector.get() : nullptr;
  }

  void
  ClearCachedAdoptedStyleSheetsValue(mozilla::dom::Document* aObject);

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, DefineInterfaceProperty aDefineOnGlobal);

  JS::Handle<JSObject*>
  GetProtoObjectHandle(JSContext* aCx);

  JSObject*
  GetProtoObject(JSContext* aCx);

  JS::Handle<JSObject*>
  GetConstructorObjectHandle(JSContext* aCx);

  inline bool CreateAndDefineOnGlobal(JSContext* aCx)
  {
    // Get the interface or namespace object for this class. This will
    // create the object as needed and always define the properties for
    // it on the global. The caller should make sure the interface or
    // namespace is exposed on the global before calling this.
    return GetPerInterfaceObjectHandle(aCx, constructors::id::Document,
                                       &CreateInterfaceObjects,
                                       DefineInterfaceProperty::Always);

  }

} // namespace Document_Binding



} // namespace dom


template <>
struct MaxContiguousEnumValue<dom::VisibilityState>
{
  static constexpr dom::VisibilityState value = dom::VisibilityState::Visible;

  static_assert(static_cast<uint8_t>(dom::VisibilityState::Hidden) == 0,
                "We rely on this in ContiguousEnumValues");
  static_assert(std::size(dom::binding_detail::EnumStrings<dom::VisibilityState>::Values) - 1 == UnderlyingValue(value),
                "Mismatch between enum strings and enum count");
};

template <>
struct MaxContiguousEnumValue<dom::WireframeRectType>
{
  static constexpr dom::WireframeRectType value = dom::WireframeRectType::Unknown;

  static_assert(static_cast<uint8_t>(dom::WireframeRectType::Image) == 0,
                "We rely on this in ContiguousEnumValues");
  static_assert(std::size(dom::binding_detail::EnumStrings<dom::WireframeRectType>::Values) - 1 == UnderlyingValue(value),
                "Mismatch between enum strings and enum count");
};


} // namespace mozilla

#endif // DOM_DOCUMENTBINDING_H_
