// -*- mode: C++ -*-

// AUTOGENERATED BY glean_parser.  DO NOT EDIT.

/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

#ifndef mozilla_GleanDomCanvasMetrics_h
#define mozilla_GleanDomCanvasMetrics_h

#include "mozilla/glean/bindings/MetricTypes.h"

namespace mozilla::glean {

namespace canvas {
  /**
   * generated from canvas.used_2d
   */
  enum class Used2dLabel: uint16_t {
    eFalse = 0,
    eTrue = 1,
    e__Other__,
  };
  /**
   * 2D canvas used
   * This metric was generated to correspond to the Legacy Telemetry boolean histogram CANVAS_2D_USED.
   */
  constexpr impl::Labeled<impl::CounterMetric<impl::CounterType::eBaseOrLabeled>, Used2dLabel> used_2d(3785);

  /**
   * generated from canvas.webgl2_success
   */
  enum class Webgl2SuccessLabel: uint16_t {
    eFalse = 0,
    eTrue = 1,
    e__Other__,
  };
  /**
   * WebGL2 creation success
   * This metric was generated to correspond to the Legacy Telemetry boolean histogram CANVAS_WEBGL2_SUCCESS.
   */
  constexpr impl::Labeled<impl::CounterMetric<impl::CounterType::eBaseOrLabeled>, Webgl2SuccessLabel> webgl2_success(3786);

  /**
   * generated from canvas.webgl_accl_failure_id
   * Track the failure IDs that lead us to reject attempting to create an accelerated context. CANVAS_WEBGL_FAILURE_ID reports the overall WebGL status with the attempt to fallback.
   * This metric was generated to correspond to the Legacy Telemetry count histogram CANVAS_WEBGL_ACCL_FAILURE_ID.
   */
  constexpr impl::Labeled<impl::CounterMetric<impl::CounterType::eBaseOrLabeled>, DynamicLabel> webgl_accl_failure_id(3787);

  /**
   * generated from canvas.webgl_failure_id
   * WebGL runtime and dynamic failure IDs. This will record a count for each context creation success or failure. Each failure id is a unique identifier that can be traced back to a particular failure branch or blocklist rule.
   * This metric was generated to correspond to the Legacy Telemetry count histogram CANVAS_WEBGL_FAILURE_ID.
   */
  constexpr impl::Labeled<impl::CounterMetric<impl::CounterType::eBaseOrLabeled>, DynamicLabel> webgl_failure_id(3788);

  /**
   * generated from canvas.webgl_success
   */
  enum class WebglSuccessLabel: uint16_t {
    eFalse = 0,
    eTrue = 1,
    e__Other__,
  };
  /**
   * WebGL1 creation success
   * This metric was generated to correspond to the Legacy Telemetry boolean histogram CANVAS_WEBGL_SUCCESS.
   */
  constexpr impl::Labeled<impl::CounterMetric<impl::CounterType::eBaseOrLabeled>, WebglSuccessLabel> webgl_success(3789);

  /**
   * generated from canvas.webgl_used
   */
  enum class WebglUsedLabel: uint16_t {
    eFalse = 0,
    eTrue = 1,
    e__Other__,
  };
  /**
   * WebGL canvas used
   * This metric was generated to correspond to the Legacy Telemetry boolean histogram CANVAS_WEBGL_USED.
   */
  constexpr impl::Labeled<impl::CounterMetric<impl::CounterType::eBaseOrLabeled>, WebglUsedLabel> webgl_used(3790);
}

} // namespace mozilla::glean

#endif // mozilla_GleanDomCanvasMetrics_h
