// -*- mode: C++ -*-

// AUTOGENERATED BY glean_parser.  DO NOT EDIT.

/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

#ifndef mozilla_GleanDomPushMetrics_h
#define mozilla_GleanDomPushMetrics_h

#include "mozilla/glean/bindings/MetricTypes.h"

namespace mozilla::glean {

namespace web_push {
  /**
   * generated from web_push.api_notify
   * Number of push messages that were successfully decrypted and delivered to a ServiceWorker when required.
   * This metric was generated to correspond to the Legacy Telemetry count histogram PUSH_API_NOTIFY.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> api_notify(3985);

  /**
   * generated from web_push.content_encoding
   */
  enum class ContentEncodingLabel: uint16_t {
    eAes128gcm = 0,
    eAesgcm = 1,
    e__Other__,
  };
  /**
   * Which content encoding is being used for push.
   */
  constexpr impl::Labeled<impl::CounterMetric<impl::CounterType::eBaseOrLabeled>, ContentEncodingLabel> content_encoding(3986);

  /**
   * generated from web_push.declarative
   * Number of push messages in the Declarative Web Push format.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> declarative(3987);

  /**
   * generated from web_push.declarative_mutable
   * Number of push messages in the Declarative Web Push format with mutable: true.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> declarative_mutable(3988);

  /**
   * generated from web_push.detected_duplicated_message_ids
   * Counts the duplicated IDs from the server. The ability to detect depends on the pref `dom.push.maxRecentMessageIDsPerSubscription`.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> detected_duplicated_message_ids(3989);

  /**
   * generated from web_push.error_code
   */
  enum class ErrorCodeLabel: uint16_t {
    eDecryptionError = 0,
    eNotDelivered = 1,
    eUncaughtException = 2,
    eUnhandledRejection = 3,
    eInternalError = 4,
    e__Other__,
  };
  /**
   * The code indicating why the push message couldn't be processed.
   */
  constexpr impl::Labeled<impl::CounterMetric<impl::CounterType::eBaseOrLabeled>, ErrorCodeLabel> error_code(3990);

  /**
   * generated from web_push.unsubscribed_by_clearing_data
   * Counts unsubscriptions triggered by ClearDataService.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> unsubscribed_by_clearing_data(3991);
}

} // namespace mozilla::glean

#endif // mozilla_GleanDomPushMetrics_h
