// -*- mode: C++ -*-

// AUTOGENERATED BY glean_parser.  DO NOT EDIT.

/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

#ifndef mozilla_GleanResistfingerprintingMetrics_h
#define mozilla_GleanResistfingerprintingMetrics_h

#include "mozilla/glean/bindings/MetricTypes.h"

namespace mozilla::glean {

namespace characteristics {
  /**
   * generated from characteristics.any_pointer_type
   * Union of pointers available. We apply union to determine if the user have both coarse and fine pointer.
   */
  constexpr impl::QuantityMetric any_pointer_type(5420);

  /**
   * generated from characteristics.audio_channels
   * Audio sampling rate
   */
  constexpr impl::QuantityMetric audio_channels(5421);

  /**
   * generated from characteristics.audio_compressor_gain_reduction
   * WebAudio DynamicsCompressorNode gain reduction value from OfflineAudioContext rendering. This is most likely consistent for all/most users but we wish to verify that experimentally.
   */
  constexpr impl::StringMetric audio_compressor_gain_reduction(5422);

  /**
   * generated from characteristics.audio_fingerprint
   * Audio fingerprint of the user. A float number multiplied by 10e7.
   */
  constexpr impl::QuantityMetric audio_fingerprint(5423);

  /**
   * generated from characteristics.audio_fingerprint2
   * A second method to calculate an audio fingerprint, used by a different fingerprinter. Hash of audio buffer sample snapshot (100 samples from 4500-4600 range) from OfflineAudioContext rendering.
   */
  constexpr impl::StringMetric audio_fingerprint2(5424);

  /**
   * generated from characteristics.audio_float_frequency_sum
   * Sum of float frequency data from AnalyserNode.getFloatFrequencyData() during OfflineAudioContext rendering. Collected as string to preserve floating-point precision.
   */
  constexpr impl::StringMetric audio_float_frequency_sum(5425);

  /**
   * generated from characteristics.audio_float_time_domain_sum
   * Sum of float time domain data from AnalyserNode.getFloatTimeDomainData() during OfflineAudioContext rendering. Collected as string to preserve floating-point precision.
   */
  constexpr impl::StringMetric audio_float_time_domain_sum(5426);

  /**
   * generated from characteristics.audio_frames
   * Audio frames
   */
  constexpr impl::QuantityMetric audio_frames(5427);

  /**
   * generated from characteristics.audio_rate
   * Audio sampling rate
   */
  constexpr impl::QuantityMetric audio_rate(5428);

  /**
   * generated from characteristics.audio_unique_samples
   * Count of unique sample values in the OfflineAudioContext audio buffer. This is used by fingerprinting scripts to detect anamolies - they expect 1-3k unique samples, not 5000. We are collecting it to ensure we are behaving as they generally expect non-anomalous browsers to behave.
   */
  constexpr impl::QuantityMetric audio_unique_samples(5429);

  /**
   * generated from characteristics.avail_height
   * Available height property
   */
  constexpr impl::QuantityMetric avail_height(5430);

  /**
   * generated from characteristics.avail_width
   * Available width property
   */
  constexpr impl::QuantityMetric avail_width(5431);

  /**
   * generated from characteristics.build_date
   * Firefox build's build date in unix time
   */
  constexpr impl::QuantityMetric build_date(5432);

  /**
   * generated from characteristics.camera_count
   * Number of cameras available on the device.
   */
  constexpr impl::QuantityMetric camera_count(5433);

  /**
   * generated from characteristics.canvas_dpr
   * The device pixel ratio of the canvas rendering context
   */
  constexpr impl::StringMetric canvas_dpr(5434);

  /**
   * generated from characteristics.canvas_feature_status
   * Status of and failure id (if failed) of ACCELERATED_CANVAS2D feature
   */
  constexpr impl::StringMetric canvas_feature_status(5435);

  /**
   * generated from characteristics.canvasdata1
   * The sha1 hash of an image rendered on a canvas. The image is a simple organge box and used as a control image
   */
  constexpr impl::StringMetric canvasdata1(5436);

  /**
   * generated from characteristics.canvasdata10
   * The sha1 hash of an image rendered on a canvas. The image is a font shipped with Firefox rendered with italics, rotation, and shadow-blur.
   */
  constexpr impl::StringMetric canvasdata10(5437);

  /**
   * generated from characteristics.canvasdata10_raw
   * Gzip-compressed, base64-encoded raw pixel data from canvasdata10 rendering
   */
  constexpr impl::TextMetric canvasdata10_raw(5438);

  /**
   * generated from characteristics.canvasdata10_software
   * The sha1 hash of an image rendered on a canvas. The image is a font shipped with Firefox rendered with italics, rotation, and shadow-blur.
   */
  constexpr impl::StringMetric canvasdata10_software(5439);

  /**
   * generated from characteristics.canvasdata10_software_raw
   * Gzip-compressed, base64-encoded raw pixel data from canvasdata10 software rendering
   */
  constexpr impl::TextMetric canvasdata10_software_raw(5440);

  /**
   * generated from characteristics.canvasdata11_webgl
   * The sha1 hash of an image rendered on a WebGL canvas (instead of Canvas2D). IT is a RGB gradient cube.
   */
  constexpr impl::StringMetric canvasdata11_webgl(5441);

  /**
   * generated from characteristics.canvasdata11_webgl_raw
   * Gzip-compressed, base64-encoded raw pixel data from canvasdata11_webgl rendering
   */
  constexpr impl::TextMetric canvasdata11_webgl_raw(5442);

  /**
   * generated from characteristics.canvasdata11_webgl_software
   * The sha1 hash of an image rendered on a WebGL canvas (instead of Canvas2D). IT is a RGB gradient cube.
   */
  constexpr impl::StringMetric canvasdata11_webgl_software(5443);

  /**
   * generated from characteristics.canvasdata11_webgl_software_raw
   * Gzip-compressed, base64-encoded raw pixel data from canvasdata11_webgl software rendering
   */
  constexpr impl::TextMetric canvasdata11_webgl_software_raw(5444);

  /**
   * generated from characteristics.canvasdata12_fingerprintjs1
   * The sha1 hash of an image rendered on a canvas, it is a copy of fingerprintjs' text canvas
   */
  constexpr impl::StringMetric canvasdata12_fingerprintjs1(5445);

  /**
   * generated from characteristics.canvasdata12_fingerprintjs1_raw
   * Gzip-compressed, base64-encoded raw pixel data from canvasdata12_fingerprintjs1 rendering
   */
  constexpr impl::TextMetric canvasdata12_fingerprintjs1_raw(5446);

  /**
   * generated from characteristics.canvasdata12_fingerprintjs1_software
   * The sha1 hash of an image rendered on a canvas, it is a copy of fingerprintjs' text canvas
   */
  constexpr impl::StringMetric canvasdata12_fingerprintjs1_software(5447);

  /**
   * generated from characteristics.canvasdata12_fingerprintjs1_software_raw
   * Gzip-compressed, base64-encoded raw pixel data from canvasdata12_fingerprintjs1 software rendering
   */
  constexpr impl::TextMetric canvasdata12_fingerprintjs1_software_raw(5448);

  /**
   * generated from characteristics.canvasdata13_fingerprintjs2
   * The sha1 hash of an image rendered on a canvas, it is a copy of fingerprintjs' geometry canvas
   */
  constexpr impl::StringMetric canvasdata13_fingerprintjs2(5449);

  /**
   * generated from characteristics.canvasdata13_fingerprintjs2_raw
   * Gzip-compressed, base64-encoded raw pixel data from canvasdata13_fingerprintjs2 rendering
   */
  constexpr impl::TextMetric canvasdata13_fingerprintjs2_raw(5450);

  /**
   * generated from characteristics.canvasdata13_fingerprintjs2_software
   * The sha1 hash of an image rendered on a canvas, it is a copy of fingerprintjs' geometry canvas
   */
  constexpr impl::StringMetric canvasdata13_fingerprintjs2_software(5451);

  /**
   * generated from characteristics.canvasdata13_fingerprintjs2_software_raw
   * Gzip-compressed, base64-encoded raw pixel data from canvasdata13_fingerprintjs2 software rendering
   */
  constexpr impl::TextMetric canvasdata13_fingerprintjs2_software_raw(5452);

  /**
   * generated from characteristics.canvasdata1_raw
   * Gzip-compressed, base64-encoded raw pixel data from canvasdata1 rendering
   */
  constexpr impl::TextMetric canvasdata1_raw(5453);

  /**
   * generated from characteristics.canvasdata1_software
   * The sha1 hash of an image rendered on a canvas. The image is a simple organge box and used as a control image
   */
  constexpr impl::StringMetric canvasdata1_software(5454);

  /**
   * generated from characteristics.canvasdata1_software_raw
   * Gzip-compressed, base64-encoded raw pixel data from canvasdata1 software rendering
   */
  constexpr impl::TextMetric canvasdata1_software_raw(5455);

  /**
   * generated from characteristics.canvasdata2
   * The sha1 hash of an image rendered on a canvas. The image is a bordered triage, and used to test point interpolation
   */
  constexpr impl::StringMetric canvasdata2(5456);

  /**
   * generated from characteristics.canvasdata2_raw
   * Gzip-compressed, base64-encoded raw pixel data from canvasdata2 rendering
   */
  constexpr impl::TextMetric canvasdata2_raw(5457);

  /**
   * generated from characteristics.canvasdata2_software
   * The sha1 hash of an image rendered on a canvas. The image is a bordered triage, and used to test point interpolation
   */
  constexpr impl::StringMetric canvasdata2_software(5458);

  /**
   * generated from characteristics.canvasdata2_software_raw
   * Gzip-compressed, base64-encoded raw pixel data from canvasdata2 software rendering
   */
  constexpr impl::TextMetric canvasdata2_software_raw(5459);

  /**
   * generated from characteristics.canvasdata3
   * The sha1 hash of an image rendered on a canvas. The image is a stretched photographic image, used to test image operations.
   */
  constexpr impl::StringMetric canvasdata3(5460);

  /**
   * generated from characteristics.canvasdata3_raw
   * Gzip-compressed, base64-encoded raw pixel data from canvasdata3 rendering
   */
  constexpr impl::TextMetric canvasdata3_raw(5461);

  /**
   * generated from characteristics.canvasdata3_software
   * The sha1 hash of an image rendered on a canvas. The image is a stretched photographic image, used to test image operations.
   */
  constexpr impl::StringMetric canvasdata3_software(5462);

  /**
   * generated from characteristics.canvasdata3_software_raw
   * Gzip-compressed, base64-encoded raw pixel data from canvasdata3 software rendering
   */
  constexpr impl::TextMetric canvasdata3_software_raw(5463);

  /**
   * generated from characteristics.canvasdata4
   * The sha1 hash of an image rendered on a canvas. The image is two rotated, semi-transparenct overlapping squares, used to test transparency and point interpolation.
   */
  constexpr impl::StringMetric canvasdata4(5464);

  /**
   * generated from characteristics.canvasdata4_raw
   * Gzip-compressed, base64-encoded raw pixel data from canvasdata4 rendering
   */
  constexpr impl::TextMetric canvasdata4_raw(5465);

  /**
   * generated from characteristics.canvasdata4_software
   * The sha1 hash of an image rendered on a canvas. The image is two rotated, semi-transparenct overlapping squares, used to test transparency and point interpolation.
   */
  constexpr impl::StringMetric canvasdata4_software(5466);

  /**
   * generated from characteristics.canvasdata4_software_raw
   * Gzip-compressed, base64-encoded raw pixel data from canvasdata4 software rendering
   */
  constexpr impl::TextMetric canvasdata4_software_raw(5467);

  /**
   * generated from characteristics.canvasdata5
   * The sha1 hash of an image rendered on a canvas. The image is a local font rendered normally.
   */
  constexpr impl::StringMetric canvasdata5(5468);

  /**
   * generated from characteristics.canvasdata5_raw
   * Gzip-compressed, base64-encoded raw pixel data from canvasdata5 rendering
   */
  constexpr impl::TextMetric canvasdata5_raw(5469);

  /**
   * generated from characteristics.canvasdata5_software
   * The sha1 hash of an image rendered on a canvas. The image is a local font rendered normally.
   */
  constexpr impl::StringMetric canvasdata5_software(5470);

  /**
   * generated from characteristics.canvasdata5_software_raw
   * Gzip-compressed, base64-encoded raw pixel data from canvasdata5 software rendering
   */
  constexpr impl::TextMetric canvasdata5_software_raw(5471);

  /**
   * generated from characteristics.canvasdata6
   * The sha1 hash of an image rendered on a canvas. The image is a local font rendered with italics, rotation, and shadow-blur.
   */
  constexpr impl::StringMetric canvasdata6(5472);

  /**
   * generated from characteristics.canvasdata6_raw
   * Gzip-compressed, base64-encoded raw pixel data from canvasdata6 rendering
   */
  constexpr impl::TextMetric canvasdata6_raw(5473);

  /**
   * generated from characteristics.canvasdata6_software
   * The sha1 hash of an image rendered on a canvas. The image is a local font rendered with italics, rotation, and shadow-blur.
   */
  constexpr impl::StringMetric canvasdata6_software(5474);

  /**
   * generated from characteristics.canvasdata6_software_raw
   * Gzip-compressed, base64-encoded raw pixel data from canvasdata6 software rendering
   */
  constexpr impl::TextMetric canvasdata6_software_raw(5475);

  /**
   * generated from characteristics.canvasdata7
   * The sha1 hash of an image rendered on a canvas. The image is a system-ui font rendered normally.
   */
  constexpr impl::StringMetric canvasdata7(5476);

  /**
   * generated from characteristics.canvasdata7_raw
   * Gzip-compressed, base64-encoded raw pixel data from canvasdata7 rendering
   */
  constexpr impl::TextMetric canvasdata7_raw(5477);

  /**
   * generated from characteristics.canvasdata7_software
   * The sha1 hash of an image rendered on a canvas. The image is a system-ui font rendered normally.
   */
  constexpr impl::StringMetric canvasdata7_software(5478);

  /**
   * generated from characteristics.canvasdata7_software_raw
   * Gzip-compressed, base64-encoded raw pixel data from canvasdata7 software rendering
   */
  constexpr impl::TextMetric canvasdata7_software_raw(5479);

  /**
   * generated from characteristics.canvasdata8
   * The sha1 hash of an image rendered on a canvas. The image is a system-ui font rendered with italics, rotation, and shadow-blur.
   */
  constexpr impl::StringMetric canvasdata8(5480);

  /**
   * generated from characteristics.canvasdata8_raw
   * Gzip-compressed, base64-encoded raw pixel data from canvasdata8 rendering
   */
  constexpr impl::TextMetric canvasdata8_raw(5481);

  /**
   * generated from characteristics.canvasdata8_software
   * The sha1 hash of an image rendered on a canvas. The image is a system-ui font rendered with italics, rotation, and shadow-blur.
   */
  constexpr impl::StringMetric canvasdata8_software(5482);

  /**
   * generated from characteristics.canvasdata8_software_raw
   * Gzip-compressed, base64-encoded raw pixel data from canvasdata8 software rendering
   */
  constexpr impl::TextMetric canvasdata8_software_raw(5483);

  /**
   * generated from characteristics.canvasdata9
   * The sha1 hash of an image rendered on a canvas. The image is a font shipped with Firefox rendered normally.
   */
  constexpr impl::StringMetric canvasdata9(5484);

  /**
   * generated from characteristics.canvasdata9_raw
   * Gzip-compressed, base64-encoded raw pixel data from canvasdata9 rendering
   */
  constexpr impl::TextMetric canvasdata9_raw(5485);

  /**
   * generated from characteristics.canvasdata9_software
   * The sha1 hash of an image rendered on a canvas. The image is a font shipped with Firefox rendered normally.
   */
  constexpr impl::StringMetric canvasdata9_software(5486);

  /**
   * generated from characteristics.canvasdata9_software_raw
   * Gzip-compressed, base64-encoded raw pixel data from canvasdata9 software rendering
   */
  constexpr impl::TextMetric canvasdata9_software_raw(5487);

  /**
   * generated from characteristics.changed_media_prefs
   * Changed media prefs and their values.
   */
  constexpr impl::StringMetric changed_media_prefs(5488);

  /**
   * generated from characteristics.channel
   * Firefox build channel
   */
  constexpr impl::StringMetric channel(5489);

  /**
   * generated from characteristics.client_identifier
   * A unique identifier for a user, not the same as the normal Telemetry client_id, but needed so we can deduplicate reports and only take the most recent one per user.
   */
  constexpr impl::UuidMetric client_identifier(5490);

  /**
   * generated from characteristics.clientrects_element_gbcr_01
   * DOMRect JSON from Element.getBoundingClientRect() for test element 1. Format: {"b":N,"h":N,"l":N,"r":N,"t":N,"w":N,"x":N,"y":N}
   */
  constexpr impl::StringMetric clientrects_element_gbcr_01(5491);

  /**
   * generated from characteristics.clientrects_element_gbcr_02
   * DOMRect JSON from Element.getBoundingClientRect() for test element 2. Format: {"b":N,"h":N,"l":N,"r":N,"t":N,"w":N,"x":N,"y":N}
   */
  constexpr impl::StringMetric clientrects_element_gbcr_02(5492);

  /**
   * generated from characteristics.clientrects_element_gbcr_03
   * DOMRect JSON from Element.getBoundingClientRect() for test element 3. Format: {"b":N,"h":N,"l":N,"r":N,"t":N,"w":N,"x":N,"y":N}
   */
  constexpr impl::StringMetric clientrects_element_gbcr_03(5493);

  /**
   * generated from characteristics.clientrects_element_gbcr_04
   * DOMRect JSON from Element.getBoundingClientRect() for test element 4. Format: {"b":N,"h":N,"l":N,"r":N,"t":N,"w":N,"x":N,"y":N}
   */
  constexpr impl::StringMetric clientrects_element_gbcr_04(5494);

  /**
   * generated from characteristics.clientrects_element_gbcr_05
   * DOMRect JSON from Element.getBoundingClientRect() for test element 5. Format: {"b":N,"h":N,"l":N,"r":N,"t":N,"w":N,"x":N,"y":N}
   */
  constexpr impl::StringMetric clientrects_element_gbcr_05(5495);

  /**
   * generated from characteristics.clientrects_element_gbcr_06
   * DOMRect JSON from Element.getBoundingClientRect() for test element 6. Format: {"b":N,"h":N,"l":N,"r":N,"t":N,"w":N,"x":N,"y":N}
   */
  constexpr impl::StringMetric clientrects_element_gbcr_06(5496);

  /**
   * generated from characteristics.clientrects_element_gbcr_07
   * DOMRect JSON from Element.getBoundingClientRect() for test element 7. Format: {"b":N,"h":N,"l":N,"r":N,"t":N,"w":N,"x":N,"y":N}
   */
  constexpr impl::StringMetric clientrects_element_gbcr_07(5497);

  /**
   * generated from characteristics.clientrects_element_gbcr_08
   * DOMRect JSON from Element.getBoundingClientRect() for test element 8. Format: {"b":N,"h":N,"l":N,"r":N,"t":N,"w":N,"x":N,"y":N}
   */
  constexpr impl::StringMetric clientrects_element_gbcr_08(5498);

  /**
   * generated from characteristics.clientrects_element_gbcr_09
   * DOMRect JSON from Element.getBoundingClientRect() for test element 9. Format: {"b":N,"h":N,"l":N,"r":N,"t":N,"w":N,"x":N,"y":N}
   */
  constexpr impl::StringMetric clientrects_element_gbcr_09(5499);

  /**
   * generated from characteristics.clientrects_element_gbcr_10
   * DOMRect JSON from Element.getBoundingClientRect() for test element 10. Format: {"b":N,"h":N,"l":N,"r":N,"t":N,"w":N,"x":N,"y":N}
   */
  constexpr impl::StringMetric clientrects_element_gbcr_10(5500);

  /**
   * generated from characteristics.clientrects_element_gbcr_11
   * DOMRect JSON from Element.getBoundingClientRect() for test element 11. Format: {"b":N,"h":N,"l":N,"r":N,"t":N,"w":N,"x":N,"y":N}
   */
  constexpr impl::StringMetric clientrects_element_gbcr_11(5501);

  /**
   * generated from characteristics.clientrects_element_gbcr_12
   * DOMRect JSON from Element.getBoundingClientRect() for test element 12. Format: {"b":N,"h":N,"l":N,"r":N,"t":N,"w":N,"x":N,"y":N}
   */
  constexpr impl::StringMetric clientrects_element_gbcr_12(5502);

  /**
   * generated from characteristics.clientrects_element_gcr_01
   * DOMRect JSON from Element.getClientRects()[0] for test element 1. Element style: border 2.715px, padding 3.98px, margin-left 12.12px. Format: {"b":N,"h":N,"l":N,"r":N,"t":N,"w":N,"x":N,"y":N}
   */
  constexpr impl::StringMetric clientrects_element_gcr_01(5503);

  /**
   * generated from characteristics.clientrects_element_gcr_02
   * DOMRect JSON from Element.getClientRects()[0] for test element 2. Element style: transform skewY(23.1753218deg) rotate3d(10.00099, 90, 0.100000000100009, 60000000000008.00000009deg). Format: {"b":N,"h":N,"l":N,"r":N,"t":N,"w":N,"x":N,"y":N}
   */
  constexpr impl::StringMetric clientrects_element_gcr_02(5504);

  /**
   * generated from characteristics.clientrects_element_gcr_03
   * DOMRect JSON from Element.getClientRects()[0] for test element 3. Element style: transform skewY(-23.1753218deg) scale(1099.0000000099, 1.89) matrix(1.11, 2.0001, -1.0001, 1.009, 150, 94.4). Format: {"b":N,"h":N,"l":N,"r":N,"t":N,"w":N,"x":N,"y":N}
   */
  constexpr impl::StringMetric clientrects_element_gcr_03(5505);

  /**
   * generated from characteristics.clientrects_element_gcr_04
   * DOMRect JSON from Element.getClientRects()[0] for test element 4. Element style: transform matrix(1.11, 2.0001, -1.0001, 1.009, 150, 94.4), position absolute. Format: {"b":N,"h":N,"l":N,"r":N,"t":N,"w":N,"x":N,"y":N}
   */
  constexpr impl::StringMetric clientrects_element_gcr_04(5506);

  /**
   * generated from characteristics.clientrects_element_gcr_05
   * DOMRect JSON from Element.getClientRects()[0] for test element 5. Element style: margin-left 42.395pt (point units). Format: {"b":N,"h":N,"l":N,"r":N,"t":N,"w":N,"x":N,"y":N}
   */
  constexpr impl::StringMetric clientrects_element_gcr_05(5507);

  /**
   * generated from characteristics.clientrects_element_gcr_06
   * DOMRect JSON from Element.getClientRects()[0] for test element 6. Element style: transform perspective(12890px) translateZ(101.5px). Format: {"b":N,"h":N,"l":N,"r":N,"t":N,"w":N,"x":N,"y":N}
   */
  constexpr impl::StringMetric clientrects_element_gcr_06(5508);

  /**
   * generated from characteristics.clientrects_element_gcr_07
   * DOMRect JSON from Element.getClientRects()[0] for test element 7. Element style: margin-top -350.552px, margin-left 0.9099rem, position absolute. Format: {"b":N,"h":N,"l":N,"r":N,"t":N,"w":N,"x":N,"y":N}
   */
  constexpr impl::StringMetric clientrects_element_gcr_07(5509);

  /**
   * generated from characteristics.clientrects_element_gcr_08
   * DOMRect JSON from Element.getClientRects()[0] for test element 8. Element style: margin-top -150.552px, margin-left 15.9099rem, position absolute. Format: {"b":N,"h":N,"l":N,"r":N,"t":N,"w":N,"x":N,"y":N}
   */
  constexpr impl::StringMetric clientrects_element_gcr_08(5510);

  /**
   * generated from characteristics.clientrects_element_gcr_09
   * DOMRect JSON from Element.getClientRects()[0] for test element 9. Element style: margin-top -110.552px, margin-left 15.9099rem, position absolute. Format: {"b":N,"h":N,"l":N,"r":N,"t":N,"w":N,"x":N,"y":N}
   */
  constexpr impl::StringMetric clientrects_element_gcr_09(5511);

  /**
   * generated from characteristics.clientrects_element_gcr_10
   * DOMRect JSON from Element.getClientRects()[0] for test element 10. Element style: margin-top -315.552px, margin-left 15.9099rem, position absolute. Format: {"b":N,"h":N,"l":N,"r":N,"t":N,"w":N,"x":N,"y":N}
   */
  constexpr impl::StringMetric clientrects_element_gcr_10(5512);

  /**
   * generated from characteristics.clientrects_element_gcr_11
   * DOMRect JSON from Element.getClientRects()[0] for test element 11. Element style: width 10px, height 10px, margin-left 15.0000009099rem. Format: {"b":N,"h":N,"l":N,"r":N,"t":N,"w":N,"x":N,"y":N}
   */
  constexpr impl::StringMetric clientrects_element_gcr_11(5513);

  /**
   * generated from characteristics.clientrects_element_gcr_12
   * DOMRect JSON from Element.getClientRects()[0] for test element 12. Element style: identical to element 11 (for equal-element consistency check). Format: {"b":N,"h":N,"l":N,"r":N,"t":N,"w":N,"x":N,"y":N}
   */
  constexpr impl::StringMetric clientrects_element_gcr_12(5514);

  /**
   * generated from characteristics.clientrects_emoji_01
   * Bounding rect dimensions for emoji 👾 (alien monster). Format: JSON object with w,h keys.
   */
  constexpr impl::StringMetric clientrects_emoji_01(5515);

  /**
   * generated from characteristics.clientrects_emoji_02
   * Bounding rect dimensions for emoji 🤖 (robot). Format: JSON object with w,h keys.
   */
  constexpr impl::StringMetric clientrects_emoji_02(5516);

  /**
   * generated from characteristics.clientrects_emoji_03
   * Bounding rect dimensions for emoji 🦄 (unicorn). Format: JSON object with w,h keys.
   */
  constexpr impl::StringMetric clientrects_emoji_03(5517);

  /**
   * generated from characteristics.clientrects_emoji_04
   * Bounding rect dimensions for emoji 🎃 (jack-o-lantern). Format: JSON object with w,h keys.
   */
  constexpr impl::StringMetric clientrects_emoji_04(5518);

  /**
   * generated from characteristics.clientrects_emoji_05
   * Bounding rect dimensions for emoji 🎨 (artist palette). Format: JSON object with w,h keys.
   */
  constexpr impl::StringMetric clientrects_emoji_05(5519);

  /**
   * generated from characteristics.clientrects_emoji_06
   * Bounding rect dimensions for emoji 🌈 (rainbow). Format: JSON object with w,h keys.
   */
  constexpr impl::StringMetric clientrects_emoji_06(5520);

  /**
   * generated from characteristics.clientrects_emoji_font_family
   * The computed font-family used for emoji elements in clientrects measurements.
   */
  constexpr impl::StringMetric clientrects_emoji_font_family(5521);

  /**
   * generated from characteristics.clientrects_ghost_dimensions
   * DOMRect JSON for .rect-ghost element (0x0px, should be all zeros). Non-zero values indicate API tampering or lie detection failure. Format: {"b":N,"h":N,"l":N,"r":N,"t":N,"w":N,"x":N,"y":N}
   */
  constexpr impl::StringMetric clientrects_ghost_dimensions(5522);

  /**
   * generated from characteristics.clientrects_known_dimensions
   * Full DOMRect JSON for .rect-known element (100x100px, transform rotate(45deg)). Format: {"b":N,"h":N,"l":N,"r":N,"t":N,"w":N,"x":N,"y":N}
   */
  constexpr impl::StringMetric clientrects_known_dimensions(5523);

  /**
   * generated from characteristics.clientrects_range_gbcr_01
   * DOMRect JSON from Element.getBoundingClientRect() after Range.selectNode() for test element 1. Format: {"b":N,"h":N,"l":N,"r":N,"t":N,"w":N,"x":N,"y":N}
   */
  constexpr impl::StringMetric clientrects_range_gbcr_01(5524);

  /**
   * generated from characteristics.clientrects_range_gbcr_02
   * DOMRect JSON from Element.getBoundingClientRect() after Range.selectNode() for test element 2. Format: {"b":N,"h":N,"l":N,"r":N,"t":N,"w":N,"x":N,"y":N}
   */
  constexpr impl::StringMetric clientrects_range_gbcr_02(5525);

  /**
   * generated from characteristics.clientrects_range_gbcr_03
   * DOMRect JSON from Element.getBoundingClientRect() after Range.selectNode() for test element 3. Format: {"b":N,"h":N,"l":N,"r":N,"t":N,"w":N,"x":N,"y":N}
   */
  constexpr impl::StringMetric clientrects_range_gbcr_03(5526);

  /**
   * generated from characteristics.clientrects_range_gbcr_04
   * DOMRect JSON from Element.getBoundingClientRect() after Range.selectNode() for test element 4. Format: {"b":N,"h":N,"l":N,"r":N,"t":N,"w":N,"x":N,"y":N}
   */
  constexpr impl::StringMetric clientrects_range_gbcr_04(5527);

  /**
   * generated from characteristics.clientrects_range_gbcr_05
   * DOMRect JSON from Element.getBoundingClientRect() after Range.selectNode() for test element 5. Format: {"b":N,"h":N,"l":N,"r":N,"t":N,"w":N,"x":N,"y":N}
   */
  constexpr impl::StringMetric clientrects_range_gbcr_05(5528);

  /**
   * generated from characteristics.clientrects_range_gbcr_06
   * DOMRect JSON from Element.getBoundingClientRect() after Range.selectNode() for test element 6. Format: {"b":N,"h":N,"l":N,"r":N,"t":N,"w":N,"x":N,"y":N}
   */
  constexpr impl::StringMetric clientrects_range_gbcr_06(5529);

  /**
   * generated from characteristics.clientrects_range_gbcr_07
   * DOMRect JSON from Element.getBoundingClientRect() after Range.selectNode() for test element 7. Format: {"b":N,"h":N,"l":N,"r":N,"t":N,"w":N,"x":N,"y":N}
   */
  constexpr impl::StringMetric clientrects_range_gbcr_07(5530);

  /**
   * generated from characteristics.clientrects_range_gbcr_08
   * DOMRect JSON from Element.getBoundingClientRect() after Range.selectNode() for test element 8. Format: {"b":N,"h":N,"l":N,"r":N,"t":N,"w":N,"x":N,"y":N}
   */
  constexpr impl::StringMetric clientrects_range_gbcr_08(5531);

  /**
   * generated from characteristics.clientrects_range_gbcr_09
   * DOMRect JSON from Element.getBoundingClientRect() after Range.selectNode() for test element 9. Format: {"b":N,"h":N,"l":N,"r":N,"t":N,"w":N,"x":N,"y":N}
   */
  constexpr impl::StringMetric clientrects_range_gbcr_09(5532);

  /**
   * generated from characteristics.clientrects_range_gbcr_10
   * DOMRect JSON from Element.getBoundingClientRect() after Range.selectNode() for test element 10. Format: {"b":N,"h":N,"l":N,"r":N,"t":N,"w":N,"x":N,"y":N}
   */
  constexpr impl::StringMetric clientrects_range_gbcr_10(5533);

  /**
   * generated from characteristics.clientrects_range_gbcr_11
   * DOMRect JSON from Element.getBoundingClientRect() after Range.selectNode() for test element 11. Format: {"b":N,"h":N,"l":N,"r":N,"t":N,"w":N,"x":N,"y":N}
   */
  constexpr impl::StringMetric clientrects_range_gbcr_11(5534);

  /**
   * generated from characteristics.clientrects_range_gbcr_12
   * DOMRect JSON from Element.getBoundingClientRect() after Range.selectNode() for test element 12. Format: {"b":N,"h":N,"l":N,"r":N,"t":N,"w":N,"x":N,"y":N}
   */
  constexpr impl::StringMetric clientrects_range_gbcr_12(5535);

  /**
   * generated from characteristics.clientrects_range_gcr_01
   * DOMRect JSON from Range.getClientRects()[0] after Range.selectNode() for test element 1. Format: {"b":N,"h":N,"l":N,"r":N,"t":N,"w":N,"x":N,"y":N}
   */
  constexpr impl::StringMetric clientrects_range_gcr_01(5536);

  /**
   * generated from characteristics.clientrects_range_gcr_02
   * DOMRect JSON from Range.getClientRects()[0] after Range.selectNode() for test element 2. Format: {"b":N,"h":N,"l":N,"r":N,"t":N,"w":N,"x":N,"y":N}
   */
  constexpr impl::StringMetric clientrects_range_gcr_02(5537);

  /**
   * generated from characteristics.clientrects_range_gcr_03
   * DOMRect JSON from Range.getClientRects()[0] after Range.selectNode() for test element 3. Format: {"b":N,"h":N,"l":N,"r":N,"t":N,"w":N,"x":N,"y":N}
   */
  constexpr impl::StringMetric clientrects_range_gcr_03(5538);

  /**
   * generated from characteristics.clientrects_range_gcr_04
   * DOMRect JSON from Range.getClientRects()[0] after Range.selectNode() for test element 4. Format: {"b":N,"h":N,"l":N,"r":N,"t":N,"w":N,"x":N,"y":N}
   */
  constexpr impl::StringMetric clientrects_range_gcr_04(5539);

  /**
   * generated from characteristics.clientrects_range_gcr_05
   * DOMRect JSON from Range.getClientRects()[0] after Range.selectNode() for test element 5. Format: {"b":N,"h":N,"l":N,"r":N,"t":N,"w":N,"x":N,"y":N}
   */
  constexpr impl::StringMetric clientrects_range_gcr_05(5540);

  /**
   * generated from characteristics.clientrects_range_gcr_06
   * DOMRect JSON from Range.getClientRects()[0] after Range.selectNode() for test element 6. Format: {"b":N,"h":N,"l":N,"r":N,"t":N,"w":N,"x":N,"y":N}
   */
  constexpr impl::StringMetric clientrects_range_gcr_06(5541);

  /**
   * generated from characteristics.clientrects_range_gcr_07
   * DOMRect JSON from Range.getClientRects()[0] after Range.selectNode() for test element 7. Format: {"b":N,"h":N,"l":N,"r":N,"t":N,"w":N,"x":N,"y":N}
   */
  constexpr impl::StringMetric clientrects_range_gcr_07(5542);

  /**
   * generated from characteristics.clientrects_range_gcr_08
   * DOMRect JSON from Range.getClientRects()[0] after Range.selectNode() for test element 8. Format: {"b":N,"h":N,"l":N,"r":N,"t":N,"w":N,"x":N,"y":N}
   */
  constexpr impl::StringMetric clientrects_range_gcr_08(5543);

  /**
   * generated from characteristics.clientrects_range_gcr_09
   * DOMRect JSON from Range.getClientRects()[0] after Range.selectNode() for test element 9. Format: {"b":N,"h":N,"l":N,"r":N,"t":N,"w":N,"x":N,"y":N}
   */
  constexpr impl::StringMetric clientrects_range_gcr_09(5544);

  /**
   * generated from characteristics.clientrects_range_gcr_10
   * DOMRect JSON from Range.getClientRects()[0] after Range.selectNode() for test element 10. Format: {"b":N,"h":N,"l":N,"r":N,"t":N,"w":N,"x":N,"y":N}
   */
  constexpr impl::StringMetric clientrects_range_gcr_10(5545);

  /**
   * generated from characteristics.clientrects_range_gcr_11
   * DOMRect JSON from Range.getClientRects()[0] after Range.selectNode() for test element 11. Format: {"b":N,"h":N,"l":N,"r":N,"t":N,"w":N,"x":N,"y":N}
   */
  constexpr impl::StringMetric clientrects_range_gcr_11(5546);

  /**
   * generated from characteristics.clientrects_range_gcr_12
   * DOMRect JSON from Range.getClientRects()[0] after Range.selectNode() for test element 12. Format: {"b":N,"h":N,"l":N,"r":N,"t":N,"w":N,"x":N,"y":N}
   */
  constexpr impl::StringMetric clientrects_range_gcr_12(5547);

  /**
   * generated from characteristics.clientrects_text_font_family
   * The computed font-family used for text elements in clientrects measurements.
   */
  constexpr impl::StringMetric clientrects_text_font_family(5548);

  /**
   * generated from characteristics.color_accentcolor
   * The CSS system-color Accentcolor.
   */
  constexpr impl::QuantityMetric color_accentcolor(5549);

  /**
   * generated from characteristics.color_accentcolortext
   * The CSS system-color Accentcolortext.
   */
  constexpr impl::QuantityMetric color_accentcolortext(5550);

  /**
   * generated from characteristics.color_canvas
   * The CSS system-color Canvas.
   */
  constexpr impl::QuantityMetric color_canvas(5551);

  /**
   * generated from characteristics.color_canvastext
   * The CSS system-color Canvastext.
   */
  constexpr impl::QuantityMetric color_canvastext(5552);

  /**
   * generated from characteristics.color_highlight
   * The CSS system-color Highlight.
   */
  constexpr impl::QuantityMetric color_highlight(5553);

  /**
   * generated from characteristics.color_highlighttext
   * The CSS system-color Highlighttext.
   */
  constexpr impl::QuantityMetric color_highlighttext(5554);

  /**
   * generated from characteristics.color_scheme
   * The Color Scheme used for Content, from ContentPrefs() Preference Sheet.
   */
  constexpr impl::QuantityMetric color_scheme(5555);

  /**
   * generated from characteristics.color_selecteditem
   * The CSS system-color Selecteditem.
   */
  constexpr impl::QuantityMetric color_selecteditem(5556);

  /**
   * generated from characteristics.color_selecteditemtext
   * The CSS system-color Selecteditemtext.
   */
  constexpr impl::QuantityMetric color_selecteditemtext(5557);

  /**
   * generated from characteristics.cpu_arch
   * Arch of the user's device
   */
  constexpr impl::StringMetric cpu_arch(5558);

  /**
   * generated from characteristics.cpu_model
   * CPU model of the user's device
   */
  constexpr impl::StringMetric cpu_model(5559);

  /**
   * generated from characteristics.css_system_colors
   * JSON array containing CSS system color keywords and their computed values as uppercase hex (without # prefix). System colors (like Canvas, ButtonFace, LinkText, etc.) are CSS keywords that resolve to theme/OS-specific colors and can be used for fingerprinting. This metric collects the computed backgroundColor for each system color keyword. Data format: [{"Canvas": "FFFFFF"}, {"ButtonFace": "F0F0F0"}, ...].
   */
  constexpr impl::TextMetric css_system_colors(5560);

  /**
   * generated from characteristics.css_system_fonts
   * JSON array containing CSS system font keywords and their computed font properties. System fonts (like caption, icon, menu, etc.) and common font families are tested to determine their rendered fontSize and fontFamily values, which can vary by OS and be used for fingerprinting. This metric collects computed fontSize + fontFamily for each font keyword/name tested. Data format: [{"caption": "11px system-ui"}, {"Arial": "16px Arial"}, ...].
   */
  constexpr impl::TextMetric css_system_fonts(5561);

  /**
   * generated from characteristics.errors
   * Errors occured on C++ side of data collection
   */
  constexpr impl::TextMetric errors(5562);

  /**
   * generated from characteristics.firefox_binary_arch
   * Architecture of the Firefox binary itself (not the CPU). This can differ from cpu_arch when running under emulation (e.g., x86-64 Firefox via Rosetta 2 on ARM64 Mac) or when running 32-bit Firefox on 64-bit CPU. Format: "xpcomabi:<abi>|is64bit:<bool>" where abi is from XPCOMABI (e.g., "Darwin_x86_64-gcc3") and is64bit indicates 64-bit build.
   */
  constexpr impl::StringMetric firefox_binary_arch(5563);

  /**
   * generated from characteristics.font_default_default_group
   * The value of the font.default.<default language group> pref
   */
  constexpr impl::StringMetric font_default_default_group(5564);

  /**
   * generated from characteristics.font_default_modified
   * The number of other modified font.default prefs.
   */
  constexpr impl::QuantityMetric font_default_modified(5565);

  /**
   * generated from characteristics.font_default_western
   * The value of the font.default.x-western pref
   */
  constexpr impl::StringMetric font_default_western(5566);

  /**
   * generated from characteristics.font_minimum_size_default_group
   * The value of the font.minimum-size.<default language group> pref
   */
  constexpr impl::StringMetric font_minimum_size_default_group(5567);

  /**
   * generated from characteristics.font_minimum_size_modified
   * The number of other modified font.minimum-size prefs.
   */
  constexpr impl::QuantityMetric font_minimum_size_modified(5568);

  /**
   * generated from characteristics.font_minimum_size_western
   * The value of the font.minimum-size.x-western pref
   */
  constexpr impl::StringMetric font_minimum_size_western(5569);

  /**
   * generated from characteristics.font_name_list_cursive_modified
   * The number of modified font.name-list.cursive. prefs.
   */
  constexpr impl::QuantityMetric font_name_list_cursive_modified(5570);

  /**
   * generated from characteristics.font_name_list_emoji_modified
   * Whether the pref font.name-list.emoji was modified.
   */
  constexpr impl::BooleanMetric font_name_list_emoji_modified(5571);

  /**
   * generated from characteristics.font_name_list_monospace_modified
   * The number of modified font.name-list.monospace. prefs.
   */
  constexpr impl::QuantityMetric font_name_list_monospace_modified(5572);

  /**
   * generated from characteristics.font_name_list_sans_serif_modified
   * The number of modified font.name-list.sans-serif. prefs.
   */
  constexpr impl::QuantityMetric font_name_list_sans_serif_modified(5573);

  /**
   * generated from characteristics.font_name_list_serif_modified
   * The number of modified font.name-list.serif. prefs.
   */
  constexpr impl::QuantityMetric font_name_list_serif_modified(5574);

  /**
   * generated from characteristics.font_name_monospace_default_group
   * The value of the font.name.monospace.<default language group> pref
   */
  constexpr impl::StringMetric font_name_monospace_default_group(5575);

  /**
   * generated from characteristics.font_name_monospace_modified
   * The number of other modified font.name.monospace prefs.
   */
  constexpr impl::QuantityMetric font_name_monospace_modified(5576);

  /**
   * generated from characteristics.font_name_monospace_western
   * The value of the font.name.monospace.x-western pref
   */
  constexpr impl::StringMetric font_name_monospace_western(5577);

  /**
   * generated from characteristics.font_name_sans_serif_default_group
   * The value of the font.name.sans-serif.<default language group> pref
   */
  constexpr impl::StringMetric font_name_sans_serif_default_group(5578);

  /**
   * generated from characteristics.font_name_sans_serif_modified
   * The number of other modified font.name.sans-serif prefs.
   */
  constexpr impl::QuantityMetric font_name_sans_serif_modified(5579);

  /**
   * generated from characteristics.font_name_sans_serif_western
   * The value of the font.name.sans-serif.x-western pref
   */
  constexpr impl::StringMetric font_name_sans_serif_western(5580);

  /**
   * generated from characteristics.font_name_serif_default_group
   * The value of the font.name.serif.<default language group> pref
   */
  constexpr impl::StringMetric font_name_serif_default_group(5581);

  /**
   * generated from characteristics.font_name_serif_modified
   * The number of other modified font.name.serif prefs.
   */
  constexpr impl::QuantityMetric font_name_serif_modified(5582);

  /**
   * generated from characteristics.font_name_serif_western
   * The value of the font.name.serif.x-western pref
   */
  constexpr impl::StringMetric font_name_serif_western(5583);

  /**
   * generated from characteristics.font_size_monospace_default_group
   * The value of the font.size.monospace.<default language group> pref
   */
  constexpr impl::StringMetric font_size_monospace_default_group(5584);

  /**
   * generated from characteristics.font_size_monospace_modified
   * The number of other modified font.size.monospace prefs.
   */
  constexpr impl::QuantityMetric font_size_monospace_modified(5585);

  /**
   * generated from characteristics.font_size_monospace_western
   * The value of the font.size.monospace.x-western pref
   */
  constexpr impl::StringMetric font_size_monospace_western(5586);

  /**
   * generated from characteristics.font_size_variable_default_group
   * The value of the font.size.variable.<default language group> pref
   */
  constexpr impl::StringMetric font_size_variable_default_group(5587);

  /**
   * generated from characteristics.font_size_variable_modified
   * The number of other modified font.size.variable prefs.
   */
  constexpr impl::QuantityMetric font_size_variable_modified(5588);

  /**
   * generated from characteristics.font_size_variable_western
   * The value of the font.size.variable.x-western pref
   */
  constexpr impl::StringMetric font_size_variable_western(5589);

  /**
   * generated from characteristics.fonts_fpjs_allowlisted
   * SHA256 of allowlisted fonts queried by FPJS
   */
  constexpr impl::StringMetric fonts_fpjs_allowlisted(5590);

  /**
   * generated from characteristics.fonts_fpjs_nonallowlisted
   * SHA256 of non-allowlisted fonts queried by FPJS
   */
  constexpr impl::StringMetric fonts_fpjs_nonallowlisted(5591);

  /**
   * generated from characteristics.fonts_variant_a_allowlisted
   * SHA256 of allowlisted fonts queried of variant A
   */
  constexpr impl::StringMetric fonts_variant_a_allowlisted(5592);

  /**
   * generated from characteristics.fonts_variant_a_nonallowlisted
   * SHA256 of non-allowlisted fonts queried of variant A
   */
  constexpr impl::StringMetric fonts_variant_a_nonallowlisted(5593);

  /**
   * generated from characteristics.fonts_variant_b_allowlisted
   * SHA256 of allowlisted fonts queried of variant B
   */
  constexpr impl::StringMetric fonts_variant_b_allowlisted(5594);

  /**
   * generated from characteristics.fonts_variant_b_nonallowlisted
   * SHA256 of non-allowlisted fonts queried of variant B
   */
  constexpr impl::StringMetric fonts_variant_b_nonallowlisted(5595);

  /**
   * generated from characteristics.fonts_variant_c_allowlisted
   * SHA256 of allowlisted fonts queried of variant C
   */
  constexpr impl::StringMetric fonts_variant_c_allowlisted(5596);

  /**
   * generated from characteristics.fonts_variant_c_nonallowlisted
   * SHA256 of non-allowlisted fonts queried of variant C
   */
  constexpr impl::StringMetric fonts_variant_c_nonallowlisted(5597);

  /**
   * generated from characteristics.fonts_variant_d_allowlisted
   * SHA256 of allowlisted fonts queried of variant D
   */
  constexpr impl::StringMetric fonts_variant_d_allowlisted(5598);

  /**
   * generated from characteristics.fonts_variant_d_nonallowlisted
   * SHA256 of non-allowlisted fonts queried of variant D
   */
  constexpr impl::StringMetric fonts_variant_d_nonallowlisted(5599);

  /**
   * generated from characteristics.fonts_variant_e_allowlisted
   * SHA256 of allowlisted fonts queried of variant E
   */
  constexpr impl::StringMetric fonts_variant_e_allowlisted(5600);

  /**
   * generated from characteristics.fonts_variant_e_nonallowlisted
   * SHA256 of non-allowlisted fonts queried of variant E
   */
  constexpr impl::StringMetric fonts_variant_e_nonallowlisted(5601);

  /**
   * generated from characteristics.fonts_variant_f_allowlisted
   * SHA256 of allowlisted fonts used to render "A" with variant F font list
   */
  constexpr impl::StringMetric fonts_variant_f_allowlisted(5602);

  /**
   * generated from characteristics.fonts_variant_f_nonallowlisted
   * SHA256 of non-allowlisted fonts used to render "A" with variant F font list
   */
  constexpr impl::StringMetric fonts_variant_f_nonallowlisted(5603);

  /**
   * generated from characteristics.fonts_variant_g_allowlisted
   * SHA256 of allowlisted fonts used to render emoji (U+1F47E) with variant F font list
   */
  constexpr impl::StringMetric fonts_variant_g_allowlisted(5604);

  /**
   * generated from characteristics.fonts_variant_g_nonallowlisted
   * SHA256 of non-allowlisted fonts used to render emoji (U+1F47E) with variant F font list
   */
  constexpr impl::StringMetric fonts_variant_g_nonallowlisted(5605);

  /**
   * generated from characteristics.fonts_variant_h_allowlisted
   * SHA256 of allowlisted fonts used to render 89 emojis with variant F font list
   */
  constexpr impl::StringMetric fonts_variant_h_allowlisted(5606);

  /**
   * generated from characteristics.fonts_variant_h_nonallowlisted
   * SHA256 of non-allowlisted fonts used to render 89 emojis with variant F font list
   */
  constexpr impl::StringMetric fonts_variant_h_nonallowlisted(5607);

  /**
   * generated from characteristics.fonts_variant_i_allowlisted
   * SHA256 of allowlisted fonts used to render SVG emojis with emoji-specific font list
   */
  constexpr impl::StringMetric fonts_variant_i_allowlisted(5608);

  /**
   * generated from characteristics.fonts_variant_i_nonallowlisted
   * SHA256 of non-allowlisted fonts used to render SVG emojis with emoji-specific font list
   */
  constexpr impl::StringMetric fonts_variant_i_nonallowlisted(5609);

  /**
   * generated from characteristics.fpu_control_state
   * The current FPU (Floating-Point Unit) rounding mode and precision settings. Format depends on architecture: - x86/x86-64: "std:X;x87:Y;sse:Z;prec:P" where X,Y,Z are rounding modes (0-3)
   *   and P is precision (single/double/extended)
   * - ARM: "std:X;arm:Y" where X,Y are rounding modes (0-3) Rounding modes: 0=nearest, 1=down/negative, 2=up/positive, 3=toward-zero This helps identify unusual FPU configurations that may cause math variations.
   */
  constexpr impl::StringMetric fpu_control_state(5610);

  /**
   * generated from characteristics.gamepads
   * The information of the gamepads inserted on the user device. Each string represents one gamepad. We use a JSON array to describe a gamepad, every value represents one property of the gamepad. Following are the details:
   *   index 0: The ID of the game pad
   *   index 1: Which hand for the gamepad.
   *   index 2: Number of buttons
   *   index 3: Number of axes
   *   index 4: Number of haptics
   *   index 5: Number of lights
   *   index 6: Number of touches
   */
  constexpr impl::StringListMetric gamepads(5611);

  /**
   * generated from characteristics.gl2_context_type
   * The type of the GL context (EGL, GLX, WGL, etc).
   */
  constexpr impl::StringMetric gl2_context_type(5612);

  /**
   * generated from characteristics.gl2_context_type_software
   * The type of the GL context (EGL, GLX, WGL, etc).
   */
  constexpr impl::StringMetric gl2_context_type_software(5613);

  /**
   * generated from characteristics.gl2_extensions
   * The list of OpenGL extensions supported by the user's system.
   */
  constexpr impl::TextMetric gl2_extensions(5614);

  /**
   * generated from characteristics.gl2_extensions_raw
   * The raw list of OpenGL extensions supported by the user's system.
   */
  constexpr impl::TextMetric gl2_extensions_raw(5615);

  /**
   * generated from characteristics.gl2_extensions_raw_software
   * The raw list of OpenGL extensions supported by the user's system.
   */
  constexpr impl::TextMetric gl2_extensions_raw_software(5616);

  /**
   * generated from characteristics.gl2_extensions_software
   * The list of OpenGL extensions supported by the user's system.
   */
  constexpr impl::TextMetric gl2_extensions_software(5617);

  /**
   * generated from characteristics.gl2_fragment_shader
   * Hash of the transformed source of the fragment shader.
   */
  constexpr impl::StringMetric gl2_fragment_shader(5618);

  /**
   * generated from characteristics.gl2_fragment_shader_software
   * Hash of the transformed source of the fragment shader.
   */
  constexpr impl::StringMetric gl2_fragment_shader_software(5619);

  /**
   * generated from characteristics.gl2_minimal_source
   * Transformed source of the minimal shader.
   */
  constexpr impl::TextMetric gl2_minimal_source(5620);

  /**
   * generated from characteristics.gl2_minimal_source_software
   * Transformed source of the minimal shader.
   */
  constexpr impl::TextMetric gl2_minimal_source_software(5621);

  /**
   * generated from characteristics.gl2_params
   * The list of GL parameters of GL2.
   */
  constexpr impl::TextMetric gl2_params(5622);

  /**
   * generated from characteristics.gl2_params_extensions
   * The list of GL parameters of the extensions.
   */
  constexpr impl::TextMetric gl2_params_extensions(5623);

  /**
   * generated from characteristics.gl2_params_extensions_software
   * The list of GL parameters of the extensions.
   */
  constexpr impl::TextMetric gl2_params_extensions_software(5624);

  /**
   * generated from characteristics.gl2_params_software
   * The list of GL parameters of GL2.
   */
  constexpr impl::TextMetric gl2_params_software(5625);

  /**
   * generated from characteristics.gl2_precision_fragment
   * Precisions of the fragment shader.
   */
  constexpr impl::TextMetric gl2_precision_fragment(5626);

  /**
   * generated from characteristics.gl2_precision_fragment_software
   * Precisions of the fragment shader.
   */
  constexpr impl::TextMetric gl2_precision_fragment_software(5627);

  /**
   * generated from characteristics.gl2_precision_vertex
   * Precisions of the vertex shader.
   */
  constexpr impl::TextMetric gl2_precision_vertex(5628);

  /**
   * generated from characteristics.gl2_precision_vertex_software
   * Precisions of the vertex shader.
   */
  constexpr impl::TextMetric gl2_precision_vertex_software(5629);

  /**
   * generated from characteristics.gl2_renderer
   * The OpenGL renderer string.
   */
  constexpr impl::StringMetric gl2_renderer(5630);

  /**
   * generated from characteristics.gl2_renderer_raw
   * The raw OpenGL renderer string.
   */
  constexpr impl::StringMetric gl2_renderer_raw(5631);

  /**
   * generated from characteristics.gl2_renderer_raw_software
   * The raw OpenGL renderer string.
   */
  constexpr impl::StringMetric gl2_renderer_raw_software(5632);

  /**
   * generated from characteristics.gl2_renderer_software
   * The OpenGL renderer string.
   */
  constexpr impl::StringMetric gl2_renderer_software(5633);

  /**
   * generated from characteristics.gl2_vendor
   * The OpenGL vendor string.
   */
  constexpr impl::StringMetric gl2_vendor(5634);

  /**
   * generated from characteristics.gl2_vendor_raw
   * The raw OpenGL vendor string.
   */
  constexpr impl::StringMetric gl2_vendor_raw(5635);

  /**
   * generated from characteristics.gl2_vendor_raw_software
   * The raw OpenGL vendor string.
   */
  constexpr impl::StringMetric gl2_vendor_raw_software(5636);

  /**
   * generated from characteristics.gl2_vendor_software
   * The OpenGL vendor string.
   */
  constexpr impl::StringMetric gl2_vendor_software(5637);

  /**
   * generated from characteristics.gl2_version_raw
   * The raw OpenGL version string.
   */
  constexpr impl::StringMetric gl2_version_raw(5638);

  /**
   * generated from characteristics.gl2_version_raw_software
   * The raw OpenGL version string.
   */
  constexpr impl::StringMetric gl2_version_raw_software(5639);

  /**
   * generated from characteristics.gl2_vertex_shader
   * Hash of the transformed source of the vertex shader.
   */
  constexpr impl::StringMetric gl2_vertex_shader(5640);

  /**
   * generated from characteristics.gl2_vertex_shader_software
   * Hash of the transformed source of the vertex shader.
   */
  constexpr impl::StringMetric gl2_vertex_shader_software(5641);

  /**
   * generated from characteristics.gl_context_type
   * The type of the GL context (EGL, GLX, WGL, etc).
   */
  constexpr impl::StringMetric gl_context_type(5642);

  /**
   * generated from characteristics.gl_context_type_software
   * The type of the GL context (EGL, GLX, WGL, etc).
   */
  constexpr impl::StringMetric gl_context_type_software(5643);

  /**
   * generated from characteristics.gl_extensions
   * The list of OpenGL extensions supported by the user's system.
   */
  constexpr impl::TextMetric gl_extensions(5644);

  /**
   * generated from characteristics.gl_extensions_raw
   * The raw list of OpenGL extensions supported by the user's system.
   */
  constexpr impl::TextMetric gl_extensions_raw(5645);

  /**
   * generated from characteristics.gl_extensions_raw_software
   * The raw list of OpenGL extensions supported by the user's system.
   */
  constexpr impl::TextMetric gl_extensions_raw_software(5646);

  /**
   * generated from characteristics.gl_extensions_software
   * The list of OpenGL extensions supported by the user's system.
   */
  constexpr impl::TextMetric gl_extensions_software(5647);

  /**
   * generated from characteristics.gl_fragment_shader
   * Hash of the transformed source of the fragment shader.
   */
  constexpr impl::StringMetric gl_fragment_shader(5648);

  /**
   * generated from characteristics.gl_fragment_shader_software
   * Hash of the transformed source of the fragment shader.
   */
  constexpr impl::StringMetric gl_fragment_shader_software(5649);

  /**
   * generated from characteristics.gl_minimal_source
   * Transformed source of the minimal shader.
   */
  constexpr impl::TextMetric gl_minimal_source(5650);

  /**
   * generated from characteristics.gl_minimal_source_software
   * Transformed source of the minimal shader.
   */
  constexpr impl::TextMetric gl_minimal_source_software(5651);

  /**
   * generated from characteristics.gl_params
   * The list of GL parameters of GL1. Parameters: ALIASED_LINE_WIDTH_RANGE, ALIASED_POINT_SIZE_RANGE, MAX_COMBINED_TEXTURE_IMAGE_UNITS, MAX_CUBE_MAP_TEXTURE_SIZE, MAX_FRAGMENT_UNIFORM_VECTORS, MAX_RENDERBUFFER_SIZE, MAX_TEXTURE_IMAGE_UNITS, MAX_TEXTURE_SIZE, MAX_VARYING_VECTORS, MAX_VERTEX_ATTRIBS, MAX_VERTEX_TEXTURE_IMAGE_UNITS, MAX_VERTEX_UNIFORM_VECTORS, MAX_VIEWPORT_DIMS, SHADING_LANGUAGE_VERSION, STENCIL_BACK_VALUE_MASK, STENCIL_BACK_WRITEMASK, STENCIL_VALUE_MASK, STENCIL_WRITEMASK, SUBPIXEL_BITS.
   */
  constexpr impl::TextMetric gl_params(5652);

  /**
   * generated from characteristics.gl_params_extensions
   * The list of GL parameters of the extensions.
   */
  constexpr impl::TextMetric gl_params_extensions(5653);

  /**
   * generated from characteristics.gl_params_extensions_software
   * The list of GL parameters of the extensions.
   */
  constexpr impl::TextMetric gl_params_extensions_software(5654);

  /**
   * generated from characteristics.gl_params_software
   * The list of GL parameters of GL1.
   */
  constexpr impl::TextMetric gl_params_software(5655);

  /**
   * generated from characteristics.gl_precision_fragment
   * Precisions of the fragment shader.
   */
  constexpr impl::TextMetric gl_precision_fragment(5656);

  /**
   * generated from characteristics.gl_precision_fragment_software
   * Precisions of the fragment shader.
   */
  constexpr impl::TextMetric gl_precision_fragment_software(5657);

  /**
   * generated from characteristics.gl_precision_vertex
   * Precisions of the vertex shader.
   */
  constexpr impl::TextMetric gl_precision_vertex(5658);

  /**
   * generated from characteristics.gl_precision_vertex_software
   * Precisions of the vertex shader.
   */
  constexpr impl::TextMetric gl_precision_vertex_software(5659);

  /**
   * generated from characteristics.gl_renderer
   * The OpenGL renderer string.
   */
  constexpr impl::StringMetric gl_renderer(5660);

  /**
   * generated from characteristics.gl_renderer_raw
   * The raw OpenGL renderer string.
   */
  constexpr impl::StringMetric gl_renderer_raw(5661);

  /**
   * generated from characteristics.gl_renderer_raw_software
   * The raw OpenGL renderer string.
   */
  constexpr impl::StringMetric gl_renderer_raw_software(5662);

  /**
   * generated from characteristics.gl_renderer_software
   * The OpenGL renderer string.
   */
  constexpr impl::StringMetric gl_renderer_software(5663);

  /**
   * generated from characteristics.gl_vendor
   * The OpenGL vendor string.
   */
  constexpr impl::StringMetric gl_vendor(5664);

  /**
   * generated from characteristics.gl_vendor_raw
   * The raw OpenGL vendor string.
   */
  constexpr impl::StringMetric gl_vendor_raw(5665);

  /**
   * generated from characteristics.gl_vendor_raw_software
   * The raw OpenGL vendor string.
   */
  constexpr impl::StringMetric gl_vendor_raw_software(5666);

  /**
   * generated from characteristics.gl_vendor_software
   * The OpenGL vendor string.
   */
  constexpr impl::StringMetric gl_vendor_software(5667);

  /**
   * generated from characteristics.gl_version_raw
   * The raw OpenGL version string.
   */
  constexpr impl::StringMetric gl_version_raw(5668);

  /**
   * generated from characteristics.gl_version_raw_software
   * The raw OpenGL version string.
   */
  constexpr impl::StringMetric gl_version_raw_software(5669);

  /**
   * generated from characteristics.gl_vertex_shader
   * Hash of the transformed source of the vertex shader.
   */
  constexpr impl::StringMetric gl_vertex_shader(5670);

  /**
   * generated from characteristics.gl_vertex_shader_software
   * Hash of the transformed source of the vertex shader.
   */
  constexpr impl::StringMetric gl_vertex_shader_software(5671);

  /**
   * generated from characteristics.group_count
   * Number of device groups reported by the device.
   */
  constexpr impl::QuantityMetric group_count(5672);

  /**
   * generated from characteristics.group_count_wo_speakers
   * Number of device groups without speakers reported by the device.
   */
  constexpr impl::QuantityMetric group_count_wo_speakers(5673);

  /**
   * generated from characteristics.ice_order
   * Unique ICE foundations occurrence count
   */
  constexpr impl::QuantityMetric ice_order(5674);

  /**
   * generated from characteristics.ice_sd
   * ICE foundation discovery latency standard deviation sum multiplied by 1000
   */
  constexpr impl::QuantityMetric ice_sd(5675);

  /**
   * generated from characteristics.inner_height
   * Inner height of user's browser.
   */
  constexpr impl::QuantityMetric inner_height(5676);

  /**
   * generated from characteristics.inner_width
   * Inner width of user's browser.
   */
  constexpr impl::QuantityMetric inner_width(5677);

  /**
   * generated from characteristics.intl_locale
   * Locale information provided by Intl
   */
  constexpr impl::StringMetric intl_locale(5678);

  /**
   * generated from characteristics.inverted_colors
   * What LookAndFeel(InvertedColors) reports.
   */
  constexpr impl::BooleanMetric inverted_colors(5679);

  /**
   * generated from characteristics.js_errors
   * Errors occured on JavaScript side of data collection
   */
  constexpr impl::TextMetric js_errors(5680);

  /**
   * generated from characteristics.keyboard_layout
   * Name of the current keyboard layout.
   */
  constexpr impl::StringMetric keyboard_layout(5681);

  /**
   * generated from characteristics.languages
   * Languages the user set. Returns intl.accept_languages pref, if it is empty, returns the first matched OS's language or the default language.
   */
  constexpr impl::StringMetric languages(5682);

  /**
   * generated from characteristics.machine_model_name
   * Machine model name
   */
  constexpr impl::StringMetric machine_model_name(5683);

  /**
   * generated from characteristics.math_ops
   * Result of fingerprintable math operations
   */
  constexpr impl::TextMetric math_ops(5684);

  /**
   * generated from characteristics.math_ops_fdlibm
   * Windows only fdlibm math operation results
   */
  constexpr impl::TextMetric math_ops_fdlibm(5685);

  /**
   * generated from characteristics.math_ops_fdlibm_2
   * Result of additional fingerprintable math operations, with fdlibm enabled
   */
  constexpr impl::TextMetric math_ops_fdlibm_2(5686);

  /**
   * generated from characteristics.mathml1
   * Width of the drawn MathML element
   */
  constexpr impl::StringMetric mathml1(5687);

  /**
   * generated from characteristics.mathml10
   * Width of the drawn MathML element
   */
  constexpr impl::StringMetric mathml10(5688);

  /**
   * generated from characteristics.mathml2
   * Width of the drawn MathML element
   */
  constexpr impl::StringMetric mathml2(5689);

  /**
   * generated from characteristics.mathml3
   * Width of the drawn MathML element
   */
  constexpr impl::StringMetric mathml3(5690);

  /**
   * generated from characteristics.mathml4
   * Width of the drawn MathML element
   */
  constexpr impl::StringMetric mathml4(5691);

  /**
   * generated from characteristics.mathml5
   * Width of the drawn MathML element
   */
  constexpr impl::StringMetric mathml5(5692);

  /**
   * generated from characteristics.mathml6
   * Width of the drawn MathML element
   */
  constexpr impl::StringMetric mathml6(5693);

  /**
   * generated from characteristics.mathml7
   * Width of the drawn MathML element
   */
  constexpr impl::StringMetric mathml7(5694);

  /**
   * generated from characteristics.mathml8
   * Width of the drawn MathML element
   */
  constexpr impl::StringMetric mathml8(5695);

  /**
   * generated from characteristics.mathml9
   * Width of the drawn MathML element
   */
  constexpr impl::StringMetric mathml9(5696);

  /**
   * generated from characteristics.mathml_diag_font_family
   * The computed font-family value from a MathML element on the page. Shows what font is actually being used for MathML rendering.
   */
  constexpr impl::StringMetric mathml_diag_font_family(5697);

  /**
   * generated from characteristics.mathml_diag_prefs_modified
   * MathML prefs that have been modified from defaults. Format is "shortname=val,..." (e.g. "dis=1,fnt=0"). Empty if no prefs modified. Shortnames: dis=disabled, str=scale_stretchy_operators, spc=mathspace_names, rtl=rtl_operator_mirroring, var=mathvariant_styling_fallback, shf=math_shift, acc=operator_dictionary_accent, leg=legacy_mathvariant_attribute, fnt=font_family_math. Values are 1 (true) or 0 (false).
   */
  constexpr impl::StringMetric mathml_diag_prefs_modified(5698);

  /**
   * generated from characteristics.mathml_diag_values
   * Array of widths from all MathML elements, collected similar to math_ops. Each element represents the getBoundingClientRect().width of a rendered MathML element. The array index corresponds to the element's id number. Format is a JSON stringified array like: ["123.456", "789.012", ...]
   */
  constexpr impl::TextMetric mathml_diag_values(5699);

  /**
   * generated from characteristics.max_touch_points
   * The number of touch points we will report to the web. On Android, this is based on Android's FEATURE_TOUCHSCREEN* constants - Mozilla caps this at 5 as Android stops distinguishing between numbers greater than 5.  On Windows this comes from the SM_MAXIMUMTOUCHES System Metric.
   */
  constexpr impl::QuantityMetric max_touch_points(5700);

  /**
   * generated from characteristics.media_capabilities_h264
   * Levels of support for H264 codec.
   */
  constexpr impl::TextMetric media_capabilities_h264(5701);

  /**
   * generated from characteristics.media_capabilities_not_efficient
   * Which, if any, media types are not power efficient.
   */
  constexpr impl::TextMetric media_capabilities_not_efficient(5702);

  /**
   * generated from characteristics.media_capabilities_not_smooth
   * Which, if any, media types are not smooth.
   */
  constexpr impl::TextMetric media_capabilities_not_smooth(5703);

  /**
   * generated from characteristics.media_capabilities_unsupported
   * Which, if any, media types are not supported.
   */
  constexpr impl::TextMetric media_capabilities_unsupported(5704);

  /**
   * generated from characteristics.microphone_count
   * Number of microphones available on the device.
   */
  constexpr impl::QuantityMetric microphone_count(5705);

  /**
   * generated from characteristics.missing_fonts
   * If a Font List is available for the user's platform, this string_list contains the fonts that are missing from the user's computer.
   */
  constexpr impl::TextMetric missing_fonts(5706);

  /**
   * generated from characteristics.monochrome
   * Whether the user's device is monochrome
   */
  constexpr impl::BooleanMetric monochrome(5707);

  /**
   * generated from characteristics.motion_decimals
   * devicemotion event's decimal places count
   */
  constexpr impl::QuantityMetric motion_decimals(5708);

  /**
   * generated from characteristics.motion_freq
   * devicemotion event's frequency
   */
  constexpr impl::QuantityMetric motion_freq(5709);

  /**
   * generated from characteristics.orientation_decimals
   * deviceorientation event's decimal places count
   */
  constexpr impl::QuantityMetric orientation_decimals(5710);

  /**
   * generated from characteristics.orientation_freq
   * deviceorientation event's frequency
   */
  constexpr impl::QuantityMetric orientation_freq(5711);

  /**
   * generated from characteristics.orientationabs_decimals
   * deviceorientationabsolute event's decimal places count
   */
  constexpr impl::QuantityMetric orientationabs_decimals(5712);

  /**
   * generated from characteristics.orientationabs_freq
   * deviceorientationabsolute event's frequency
   */
  constexpr impl::QuantityMetric orientationabs_freq(5713);

  /**
   * generated from characteristics.os_distro
   * User's OS distribution, as reported by lsb_release (Linux only, blank otherwise)
   */
  constexpr impl::StringMetric os_distro(5714);

  /**
   * generated from characteristics.os_distro_id
   * User's OS distribution, as reported by MOZ_DISTRIBUTION_ID
   */
  constexpr impl::StringMetric os_distro_id(5715);

  /**
   * generated from characteristics.os_distro_version
   * User's OS distribution version, as reported by lsb_release (Linux only, blank otherwise)
   */
  constexpr impl::StringMetric os_distro_version(5716);

  /**
   * generated from characteristics.os_name
   * User's OS name
   */
  constexpr impl::StringMetric os_name(5717);

  /**
   * generated from characteristics.os_version
   * User's OS version
   */
  constexpr impl::StringMetric os_version(5718);

  /**
   * generated from characteristics.oscpu
   * User's OS CPU reported by the navigator
   */
  constexpr impl::StringMetric oscpu(5719);

  /**
   * generated from characteristics.outer_height
   * Outer height of user's browser.
   */
  constexpr impl::QuantityMetric outer_height(5720);

  /**
   * generated from characteristics.outer_width
   * Outer width of user's browser.
   */
  constexpr impl::QuantityMetric outer_width(5721);

  /**
   * generated from characteristics.pdf_viewer
   * PDF viewer support reported by the navigator
   */
  constexpr impl::BooleanMetric pdf_viewer(5722);

  /**
   * generated from characteristics.pixel_ratio
   * The value of window.devicePixelRatio
   */
  constexpr impl::StringMetric pixel_ratio(5723);

  /**
   * generated from characteristics.platform
   * Platform reported by the navigator
   */
  constexpr impl::StringMetric platform(5724);

  /**
   * generated from characteristics.pointer_height
   * Height of user's pointer
   */
  constexpr impl::QuantityMetric pointer_height(5725);

  /**
   * generated from characteristics.pointer_pressure
   * Pressure of user's pointer
   */
  constexpr impl::StringMetric pointer_pressure(5726);

  /**
   * generated from characteristics.pointer_tangentinal_pressure
   * Tangential Pressure of user's pointer
   */
  constexpr impl::StringMetric pointer_tangentinal_pressure(5727);

  /**
   * generated from characteristics.pointer_tiltx
   * TiltX of user's pointer
   */
  constexpr impl::QuantityMetric pointer_tiltx(5728);

  /**
   * generated from characteristics.pointer_tilty
   * TiltY of user's pointer
   */
  constexpr impl::QuantityMetric pointer_tilty(5729);

  /**
   * generated from characteristics.pointer_twist
   * Twist of user's pointer
   */
  constexpr impl::QuantityMetric pointer_twist(5730);

  /**
   * generated from characteristics.pointer_type
   * Pointer type of the user's primary pointer device.
   */
  constexpr impl::QuantityMetric pointer_type(5731);

  /**
   * generated from characteristics.pointer_width
   * Width of user's pointer
   */
  constexpr impl::QuantityMetric pointer_width(5732);

  /**
   * generated from characteristics.prefers_contrast
   * What Gecko_MediaFeatures_PrefersContrast reports for a ContentDocument
   */
  constexpr impl::QuantityMetric prefers_contrast(5733);

  /**
   * generated from characteristics.prefers_reduced_motion
   * What LookAndFeel(PrefersReducedMotion) reports.
   */
  constexpr impl::BooleanMetric prefers_reduced_motion(5734);

  /**
   * generated from characteristics.prefers_reduced_transparency
   * What LookAndFeel(PrefersReducedTransparency) reports.
   */
  constexpr impl::BooleanMetric prefers_reduced_transparency(5735);

  /**
   * generated from characteristics.prefs_block_popups
   * Block pop-up windows (The dom.disable_open_during_load pref)
   */
  constexpr impl::BooleanMetric prefs_block_popups(5736);

  /**
   * generated from characteristics.prefs_browser_display_use_document_fonts
   * Allow pages to choose their own fonts.
   */
  constexpr impl::BooleanMetric prefs_browser_display_use_document_fonts(5737);

  /**
   * generated from characteristics.prefs_general_autoscroll
   * Use autoscrolling
   */
  constexpr impl::BooleanMetric prefs_general_autoscroll(5738);

  /**
   * generated from characteristics.prefs_general_smoothscroll
   * Use smooth scrolling
   */
  constexpr impl::BooleanMetric prefs_general_smoothscroll(5739);

  /**
   * generated from characteristics.prefs_intl_accept_languages
   * Value of the intl.accept_languages pref.
   */
  constexpr impl::StringMetric prefs_intl_accept_languages(5740);

  /**
   * generated from characteristics.prefs_media_eme_enabled
   * Value of the media.eme.enabled pref.
   */
  constexpr impl::BooleanMetric prefs_media_eme_enabled(5741);

  /**
   * generated from characteristics.prefs_network_cookie_cookiebehavior
   * Value of the network.cookie.cookieBehavior pref.
   */
  constexpr impl::QuantityMetric prefs_network_cookie_cookiebehavior(5742);

  /**
   * generated from characteristics.prefs_overlay_scrollbars
   * Use overlay scrollbars (or otherwise "Always show scrollbars")
   */
  constexpr impl::BooleanMetric prefs_overlay_scrollbars(5743);

  /**
   * generated from characteristics.prefs_privacy_donottrackheader_enabled
   * Sending "do not track" HTTP header
   */
  constexpr impl::BooleanMetric prefs_privacy_donottrackheader_enabled(5744);

  /**
   * generated from characteristics.prefs_privacy_globalprivacycontrol_enabled
   * Sending "global privacy control" HTTP header
   */
  constexpr impl::BooleanMetric prefs_privacy_globalprivacycontrol_enabled(5745);

  /**
   * generated from characteristics.prefs_zoom_text_only
   * Text-only zoom enabled (vs. full-zoom)
   */
  constexpr impl::BooleanMetric prefs_zoom_text_only(5746);

  /**
   * generated from characteristics.processor_count
   * Number of processors.
   */
  constexpr impl::QuantityMetric processor_count(5747);

  /**
   * generated from characteristics.screen_height
   * Screen height from a window.
   */
  constexpr impl::QuantityMetric screen_height(5748);

  /**
   * generated from characteristics.screen_width
   * Screen width from a window.
   */
  constexpr impl::QuantityMetric screen_width(5749);

  /**
   * generated from characteristics.screens
   * JSON string of screen properties
   */
  constexpr impl::TextMetric screens(5750);

  /**
   * generated from characteristics.sdp_codec_list
   * JSON-stringified SDP codec section from RTCPeerConnection.createOffer(). Contains m-lines, a=rtpmap, a=fmtp, and a=rtcp-fb lines with session-specific values (ICE credentials, DTLS fingerprint) stripped.
   */
  constexpr impl::TextMetric sdp_codec_list(5751);

  /**
   * generated from characteristics.size_mode
   * Whether window is maximized, minimized, normal or fullscreen
   */
  constexpr impl::QuantityMetric size_mode(5752);

  /**
   * generated from characteristics.speaker_count
   * Number of speakers available on the device.
   */
  constexpr impl::QuantityMetric speaker_count(5753);

  /**
   * generated from characteristics.storage_quota
   * Storage quota in MB from StorageManager.estimate(), rounded to integer. Acts as a disk-size proxy for fingerprinting entropy analysis.
   */
  constexpr impl::QuantityMetric storage_quota(5754);

  /**
   * generated from characteristics.submission_schema
   * An incrementing constant that represents the current schema/source of the data present in a ping. By referring to this value in a ping, one can know for certain the provenance of other data present in the ping, and what data may or may not be present.
   */
  constexpr impl::QuantityMetric submission_schema(5755);

  /**
   * generated from characteristics.svg_bbox
   * JSON object from SVGGraphicsElement.getBBox(). Format: {"x":N,"y":N,"w":N,"h":N}. Varies by browser rendering engine.
   */
  constexpr impl::StringMetric svg_bbox(5756);

  /**
   * generated from characteristics.svg_computed_text_length
   * SVGTextContentElement.getComputedTextLength() for emoji text element. Returns the total length of rendered text, varies by font rendering.
   */
  constexpr impl::StringMetric svg_computed_text_length(5757);

  /**
   * generated from characteristics.svg_emoji_set
   * JSON array of emojis with unique rendering dimensions. Tests which emojis render at distinct sizes, varies by OS/font support.
   */
  constexpr impl::StringMetric svg_emoji_set(5758);

  /**
   * generated from characteristics.svg_extent_of_char
   * JSON object from SVGTextContentElement.getExtentOfChar(0). Format: {"x":N,"y":N,"w":N,"h":N}. Varies by emoji rendering.
   */
  constexpr impl::StringMetric svg_extent_of_char(5759);

  /**
   * generated from characteristics.svg_substring_length
   * SVGTextContentElement.getSubStringLength(0, 10) for first 10 characters. Varies by font metrics and text shaping.
   */
  constexpr impl::StringMetric svg_substring_length(5760);

  /**
   * generated from characteristics.system_locale
   * The locale used by the host OS for localization.
   */
  constexpr impl::StringMetric system_locale(5761);

  /**
   * generated from characteristics.target_frame_rate
   * The target frame rate in frames-per-second.
   */
  constexpr impl::QuantityMetric target_frame_rate(5762);

  /**
   * generated from characteristics.text_anti_aliasing
   * Font anti aliasing level
   */
  constexpr impl::StringMetric text_anti_aliasing(5763);

  /**
   * generated from characteristics.timezone
   * The the current timezone of the system
   */
  constexpr impl::StringMetric timezone(5764);

  /**
   * generated from characteristics.timezone_offset_web
   * The timezone offset in minutes exposed to web content via getTimezoneOffset()
   */
  constexpr impl::StringMetric timezone_offset_web(5765);

  /**
   * generated from characteristics.timezone_web
   * The timezone string reported via the web using Intl API (e.g. America/New_York)
   */
  constexpr impl::StringMetric timezone_web(5766);

  /**
   * generated from characteristics.touch_rotation_angle
   * Rotation angle of user's touch
   */
  constexpr impl::StringMetric touch_rotation_angle(5767);

  /**
   * generated from characteristics.use_document_colors
   * This is the derived PreferenceSheet::Prefs::mUseDocumentColors value.
   */
  constexpr impl::BooleanMetric use_document_colors(5768);

  /**
   * generated from characteristics.user_agent
   * User agent string
   */
  constexpr impl::TextMetric user_agent(5769);

  /**
   * generated from characteristics.using_accelerated_canvas
   * Whether the user's device is using accelerated canvas
   */
  constexpr impl::BooleanMetric using_accelerated_canvas(5770);

  /**
   * generated from characteristics.version
   * Firefox build version
   */
  constexpr impl::StringMetric version(5771);

  /**
   * generated from characteristics.voices_all_ssdeep
   * ssdeep hash of all speechSynthesis voices.
   */
  constexpr impl::StringMetric voices_all_ssdeep(5772);

  /**
   * generated from characteristics.voices_count
   * Number of speechSynthesis voices available to the user.
   */
  constexpr impl::QuantityMetric voices_count(5773);

  /**
   * generated from characteristics.voices_default
   * The default speechSynthesis voice.
   */
  constexpr impl::StringMetric voices_default(5774);

  /**
   * generated from characteristics.voices_local_count
   * Number of local speechSynthesis voices available to the user.
   */
  constexpr impl::QuantityMetric voices_local_count(5775);

  /**
   * generated from characteristics.voices_local_ssdeep
   * ssdeep hash of local speechSynthesis voices.
   */
  constexpr impl::StringMetric voices_local_ssdeep(5776);

  /**
   * generated from characteristics.voices_nonlocal_ssdeep
   * ssdeep hash of non-local speechSynthesis voices.
   */
  constexpr impl::StringMetric voices_nonlocal_ssdeep(5777);

  /**
   * generated from characteristics.voices_sample
   * Names of 5 sample speechSynthesis voices.
   */
  constexpr impl::TextMetric voices_sample(5778);

  /**
   * generated from characteristics.voices_sha1
   * SHA1 hash of all the voices.
   */
  constexpr impl::TextMetric voices_sha1(5779);

  /**
   * generated from characteristics.webauthn_capabilities
   * JSON-stringified dictionary from PublicKeyCredential.getClientCapabilities(). Contains boolean values indicating passkey and authenticator support.
   */
  constexpr impl::TextMetric webauthn_capabilities(5780);

  /**
   * generated from characteristics.wgpu_is_fallback_adapter
   * WebGPU adapter isFallbackAdapter property. Indicates whether the adapter is a software renderer (true) or hardware GPU (false).
   */
  constexpr impl::BooleanMetric wgpu_is_fallback_adapter(5781);

  /**
   * generated from characteristics.wgpu_maxbindgroups
   * WebGPU limit maxBindGroups
   */
  constexpr impl::QuantityMetric wgpu_maxbindgroups(5782);

  /**
   * generated from characteristics.wgpu_maxbindgroupsplusvertexbuffers
   * WebGPU limit maxBindGroupsPlusVertexBuffers
   */
  constexpr impl::QuantityMetric wgpu_maxbindgroupsplusvertexbuffers(5783);

  /**
   * generated from characteristics.wgpu_maxbindingsperbindgroup
   * WebGPU limit maxBindingsPerBindGroup
   */
  constexpr impl::QuantityMetric wgpu_maxbindingsperbindgroup(5784);

  /**
   * generated from characteristics.wgpu_maxbuffersize
   * WebGPU limit maxBufferSize
   */
  constexpr impl::QuantityMetric wgpu_maxbuffersize(5785);

  /**
   * generated from characteristics.wgpu_maxcolorattachmentbytespersample
   * WebGPU limit maxColorAttachmentBytesPerSample
   */
  constexpr impl::QuantityMetric wgpu_maxcolorattachmentbytespersample(5786);

  /**
   * generated from characteristics.wgpu_maxcolorattachments
   * WebGPU limit maxColorAttachments
   */
  constexpr impl::QuantityMetric wgpu_maxcolorattachments(5787);

  /**
   * generated from characteristics.wgpu_maxcomputeinvocationsperworkgroup
   * WebGPU limit maxComputeInvocationsPerWorkgroup
   */
  constexpr impl::QuantityMetric wgpu_maxcomputeinvocationsperworkgroup(5788);

  /**
   * generated from characteristics.wgpu_maxcomputeworkgroupsizex
   * WebGPU limit maxComputeWorkgroupSizeX
   */
  constexpr impl::QuantityMetric wgpu_maxcomputeworkgroupsizex(5789);

  /**
   * generated from characteristics.wgpu_maxcomputeworkgroupsizey
   * WebGPU limit maxComputeWorkgroupSizeY
   */
  constexpr impl::QuantityMetric wgpu_maxcomputeworkgroupsizey(5790);

  /**
   * generated from characteristics.wgpu_maxcomputeworkgroupsizez
   * WebGPU limit maxComputeWorkgroupSizeZ
   */
  constexpr impl::QuantityMetric wgpu_maxcomputeworkgroupsizez(5791);

  /**
   * generated from characteristics.wgpu_maxcomputeworkgroupsperdimension
   * WebGPU limit maxComputeWorkgroupsPerDimension
   */
  constexpr impl::QuantityMetric wgpu_maxcomputeworkgroupsperdimension(5792);

  /**
   * generated from characteristics.wgpu_maxcomputeworkgroupstoragesize
   * WebGPU limit maxComputeWorkgroupStorageSize
   */
  constexpr impl::QuantityMetric wgpu_maxcomputeworkgroupstoragesize(5793);

  /**
   * generated from characteristics.wgpu_maxdynamicstoragebuffersperpipelinelayout
   * WebGPU limit maxDynamicStorageBuffersPerPipelineLayout
   */
  constexpr impl::QuantityMetric wgpu_maxdynamicstoragebuffersperpipelinelayout(5794);

  /**
   * generated from characteristics.wgpu_maxdynamicuniformbuffersperpipelinelayout
   * WebGPU limit maxDynamicUniformBuffersPerPipelineLayout
   */
  constexpr impl::QuantityMetric wgpu_maxdynamicuniformbuffersperpipelinelayout(5795);

  /**
   * generated from characteristics.wgpu_maxinterstageshadervariables
   * WebGPU limit maxInterStageShaderVariables
   */
  constexpr impl::QuantityMetric wgpu_maxinterstageshadervariables(5796);

  /**
   * generated from characteristics.wgpu_maxsampledtexturespershaderstage
   * WebGPU limit maxSampledTexturesPerShaderStage
   */
  constexpr impl::QuantityMetric wgpu_maxsampledtexturespershaderstage(5797);

  /**
   * generated from characteristics.wgpu_maxsamplerspershaderstage
   * WebGPU limit maxSamplersPerShaderStage
   */
  constexpr impl::QuantityMetric wgpu_maxsamplerspershaderstage(5798);

  /**
   * generated from characteristics.wgpu_maxstoragebufferbindingsize
   * WebGPU limit maxStorageBufferBindingSize
   */
  constexpr impl::QuantityMetric wgpu_maxstoragebufferbindingsize(5799);

  /**
   * generated from characteristics.wgpu_maxstoragebufferspershaderstage
   * WebGPU limit maxStorageBuffersPerShaderStage
   */
  constexpr impl::QuantityMetric wgpu_maxstoragebufferspershaderstage(5800);

  /**
   * generated from characteristics.wgpu_maxstoragetexturespershaderstage
   * WebGPU limit maxStorageTexturesPerShaderStage
   */
  constexpr impl::QuantityMetric wgpu_maxstoragetexturespershaderstage(5801);

  /**
   * generated from characteristics.wgpu_maxtexturearraylayers
   * WebGPU limit maxTextureArrayLayers
   */
  constexpr impl::QuantityMetric wgpu_maxtexturearraylayers(5802);

  /**
   * generated from characteristics.wgpu_maxtexturedimension1d
   * WebGPU limit maxTextureDimension1D
   */
  constexpr impl::QuantityMetric wgpu_maxtexturedimension1d(5803);

  /**
   * generated from characteristics.wgpu_maxtexturedimension2d
   * WebGPU limit maxTextureDimension2D
   */
  constexpr impl::QuantityMetric wgpu_maxtexturedimension2d(5804);

  /**
   * generated from characteristics.wgpu_maxtexturedimension3d
   * WebGPU limit maxTextureDimension3D
   */
  constexpr impl::QuantityMetric wgpu_maxtexturedimension3d(5805);

  /**
   * generated from characteristics.wgpu_maxuniformbufferbindingsize
   * WebGPU limit maxUniformBufferBindingSize
   */
  constexpr impl::QuantityMetric wgpu_maxuniformbufferbindingsize(5806);

  /**
   * generated from characteristics.wgpu_maxuniformbufferspershaderstage
   * WebGPU limit maxUniformBuffersPerShaderStage
   */
  constexpr impl::QuantityMetric wgpu_maxuniformbufferspershaderstage(5807);

  /**
   * generated from characteristics.wgpu_maxvertexattributes
   * WebGPU limit maxVertexAttributes
   */
  constexpr impl::QuantityMetric wgpu_maxvertexattributes(5808);

  /**
   * generated from characteristics.wgpu_maxvertexbufferarraystride
   * WebGPU limit maxVertexBufferArrayStride
   */
  constexpr impl::QuantityMetric wgpu_maxvertexbufferarraystride(5809);

  /**
   * generated from characteristics.wgpu_maxvertexbuffers
   * WebGPU limit maxVertexBuffers
   */
  constexpr impl::QuantityMetric wgpu_maxvertexbuffers(5810);

  /**
   * generated from characteristics.wgpu_minstoragebufferoffsetalignment
   * WebGPU limit minStorageBufferOffsetAlignment
   */
  constexpr impl::QuantityMetric wgpu_minstoragebufferoffsetalignment(5811);

  /**
   * generated from characteristics.wgpu_minuniformbufferoffsetalignment
   * WebGPU limit minUniformBufferOffsetAlignment
   */
  constexpr impl::QuantityMetric wgpu_minuniformbufferoffsetalignment(5812);

  /**
   * generated from characteristics.wgpu_missing_features
   * Missing features of WebGPU as a bitset
   */
  constexpr impl::StringMetric wgpu_missing_features(5813);

  /**
   * generated from characteristics.zoom_count
   * Number of domains the users has a non-default zoom level.
   */
  constexpr impl::QuantityMetric zoom_count(5814);
}

namespace fingerprinting_protection {
  /**
   * generated from fingerprinting.protection.canvas_noise_calculate_time_2
   * Counts how long to generate canvas random noises.
   */
  constexpr impl::TimingDistributionMetric canvas_noise_calculate_time_2(5815);
}

} // namespace mozilla::glean

#endif // mozilla_GleanResistfingerprintingMetrics_h
