/*
 * DO NOT EDIT.  THIS FILE IS GENERATED FROM $SRCDIR/xpcom/io/nsIBinaryInputStream.idl
 */

#ifndef __gen_nsIBinaryInputStream_h__
#define __gen_nsIBinaryInputStream_h__


#include "nsIInputStream.h"

#include "nsTArray.h"

#include "js/Value.h"

/* For IDL files that don't want to include root IDL files. */
#ifndef NS_NO_VTABLE
#define NS_NO_VTABLE
#endif

/* starting interface:    nsIBinaryInputStream */
#define NS_IBINARYINPUTSTREAM_IID_STR "899b826b-2eb3-469c-8b31-4c29f5d341a6"

#define NS_IBINARYINPUTSTREAM_IID \
  {0x899b826b, 0x2eb3, 0x469c, \
    { 0x8b, 0x31, 0x4c, 0x29, 0xf5, 0xd3, 0x41, 0xa6 }}

class NS_NO_VTABLE nsIBinaryInputStream : public nsIInputStream {
 public:

  NS_INLINE_DECL_STATIC_IID(NS_IBINARYINPUTSTREAM_IID)

  /* Used by ToJSValue to check which scriptable interface is implemented. */
  using ScriptableInterfaceType = nsIBinaryInputStream;

  /* void setInputStream (in nsIInputStream aInputStream); */
  NS_IMETHOD SetInputStream(nsIInputStream *aInputStream) = 0;

  /* [must_use] boolean readBoolean (); */
  [[nodiscard]] NS_IMETHOD ReadBoolean(bool *_retval) = 0;

  /* [must_use] uint8_t read8 (); */
  [[nodiscard]] NS_IMETHOD Read8(uint8_t *_retval) = 0;

  /* [must_use] uint16_t read16 (); */
  [[nodiscard]] NS_IMETHOD Read16(uint16_t *_retval) = 0;

  /* [must_use] uint32_t read32 (); */
  [[nodiscard]] NS_IMETHOD Read32(uint32_t *_retval) = 0;

  /* [must_use] uint64_t read64 (); */
  [[nodiscard]] NS_IMETHOD Read64(uint64_t *_retval) = 0;

  /* [must_use] float readFloat (); */
  [[nodiscard]] NS_IMETHOD ReadFloat(float *_retval) = 0;

  /* [must_use] double readDouble (); */
  [[nodiscard]] NS_IMETHOD ReadDouble(double *_retval) = 0;

  /* [must_use] ACString readCString (); */
  [[nodiscard]] NS_IMETHOD ReadCString(nsACString& _retval) = 0;

  /* [must_use] AString readString (); */
  [[nodiscard]] NS_IMETHOD ReadString(nsAString& _retval) = 0;

  /* [must_use] void readBytes (in uint32_t aLength, [size_is (aLength), retval] out string aString); */
  [[nodiscard]] NS_IMETHOD ReadBytes(uint32_t aLength, char * *aString) = 0;

  /* [must_use] Array<uint8_t> readByteArray (in uint32_t aLength); */
  [[nodiscard]] NS_IMETHOD ReadByteArray(uint32_t aLength, nsTArray<uint8_t >& _retval) = 0;

  /* [implicit_jscontext,must_use] uint64_t readArrayBuffer (in uint64_t aLength, in jsval aArrayBuffer); */
  [[nodiscard]] NS_IMETHOD ReadArrayBuffer(uint64_t aLength, JS::Handle<JS::Value> aArrayBuffer, JSContext* cx, uint64_t *_retval) = 0;

};


/* Use this macro when declaring classes that implement this interface. */
#define NS_DECL_NSIBINARYINPUTSTREAM \
  NS_IMETHOD SetInputStream(nsIInputStream *aInputStream) override; \
  [[nodiscard]] NS_IMETHOD ReadBoolean(bool *_retval) override; \
  [[nodiscard]] NS_IMETHOD Read8(uint8_t *_retval) override; \
  [[nodiscard]] NS_IMETHOD Read16(uint16_t *_retval) override; \
  [[nodiscard]] NS_IMETHOD Read32(uint32_t *_retval) override; \
  [[nodiscard]] NS_IMETHOD Read64(uint64_t *_retval) override; \
  [[nodiscard]] NS_IMETHOD ReadFloat(float *_retval) override; \
  [[nodiscard]] NS_IMETHOD ReadDouble(double *_retval) override; \
  [[nodiscard]] NS_IMETHOD ReadCString(nsACString& _retval) override; \
  [[nodiscard]] NS_IMETHOD ReadString(nsAString& _retval) override; \
  [[nodiscard]] NS_IMETHOD ReadBytes(uint32_t aLength, char * *aString) override; \
  [[nodiscard]] NS_IMETHOD ReadByteArray(uint32_t aLength, nsTArray<uint8_t >& _retval) override; \
  [[nodiscard]] NS_IMETHOD ReadArrayBuffer(uint64_t aLength, JS::Handle<JS::Value> aArrayBuffer, JSContext* cx, uint64_t *_retval) override; 

/* Use this macro when declaring the members of this interface when the
   class doesn't implement the interface. This is useful for forwarding. */
#define NS_DECL_NON_VIRTUAL_NSIBINARYINPUTSTREAM \
  nsresult SetInputStream(nsIInputStream *aInputStream); \
  [[nodiscard]] nsresult ReadBoolean(bool *_retval); \
  [[nodiscard]] nsresult Read8(uint8_t *_retval); \
  [[nodiscard]] nsresult Read16(uint16_t *_retval); \
  [[nodiscard]] nsresult Read32(uint32_t *_retval); \
  [[nodiscard]] nsresult Read64(uint64_t *_retval); \
  [[nodiscard]] nsresult ReadFloat(float *_retval); \
  [[nodiscard]] nsresult ReadDouble(double *_retval); \
  [[nodiscard]] nsresult ReadCString(nsACString& _retval); \
  [[nodiscard]] nsresult ReadString(nsAString& _retval); \
  [[nodiscard]] nsresult ReadBytes(uint32_t aLength, char * *aString); \
  [[nodiscard]] nsresult ReadByteArray(uint32_t aLength, nsTArray<uint8_t >& _retval); \
  [[nodiscard]] nsresult ReadArrayBuffer(uint64_t aLength, JS::Handle<JS::Value> aArrayBuffer, JSContext* cx, uint64_t *_retval); 

/* Use this macro to declare functions that forward the behavior of this interface to another object. */
#define NS_FORWARD_NSIBINARYINPUTSTREAM(_to) \
  NS_IMETHOD SetInputStream(nsIInputStream *aInputStream) override { return _to SetInputStream(aInputStream); } \
  [[nodiscard]] NS_IMETHOD ReadBoolean(bool *_retval) override { return _to ReadBoolean(_retval); } \
  [[nodiscard]] NS_IMETHOD Read8(uint8_t *_retval) override { return _to Read8(_retval); } \
  [[nodiscard]] NS_IMETHOD Read16(uint16_t *_retval) override { return _to Read16(_retval); } \
  [[nodiscard]] NS_IMETHOD Read32(uint32_t *_retval) override { return _to Read32(_retval); } \
  [[nodiscard]] NS_IMETHOD Read64(uint64_t *_retval) override { return _to Read64(_retval); } \
  [[nodiscard]] NS_IMETHOD ReadFloat(float *_retval) override { return _to ReadFloat(_retval); } \
  [[nodiscard]] NS_IMETHOD ReadDouble(double *_retval) override { return _to ReadDouble(_retval); } \
  [[nodiscard]] NS_IMETHOD ReadCString(nsACString& _retval) override { return _to ReadCString(_retval); } \
  [[nodiscard]] NS_IMETHOD ReadString(nsAString& _retval) override { return _to ReadString(_retval); } \
  [[nodiscard]] NS_IMETHOD ReadBytes(uint32_t aLength, char * *aString) override { return _to ReadBytes(aLength, aString); } \
  [[nodiscard]] NS_IMETHOD ReadByteArray(uint32_t aLength, nsTArray<uint8_t >& _retval) override { return _to ReadByteArray(aLength, _retval); } \
  [[nodiscard]] NS_IMETHOD ReadArrayBuffer(uint64_t aLength, JS::Handle<JS::Value> aArrayBuffer, JSContext* cx, uint64_t *_retval) override { return _to ReadArrayBuffer(aLength, aArrayBuffer, cx, _retval); } 

/* Use this macro to declare functions that forward the behavior of this interface to another object in a safe way. */
#define NS_FORWARD_SAFE_NSIBINARYINPUTSTREAM(_to) \
  NS_IMETHOD SetInputStream(nsIInputStream *aInputStream) override { return !_to ? NS_ERROR_NULL_POINTER : _to->SetInputStream(aInputStream); } \
  [[nodiscard]] NS_IMETHOD ReadBoolean(bool *_retval) override { return !_to ? NS_ERROR_NULL_POINTER : _to->ReadBoolean(_retval); } \
  [[nodiscard]] NS_IMETHOD Read8(uint8_t *_retval) override { return !_to ? NS_ERROR_NULL_POINTER : _to->Read8(_retval); } \
  [[nodiscard]] NS_IMETHOD Read16(uint16_t *_retval) override { return !_to ? NS_ERROR_NULL_POINTER : _to->Read16(_retval); } \
  [[nodiscard]] NS_IMETHOD Read32(uint32_t *_retval) override { return !_to ? NS_ERROR_NULL_POINTER : _to->Read32(_retval); } \
  [[nodiscard]] NS_IMETHOD Read64(uint64_t *_retval) override { return !_to ? NS_ERROR_NULL_POINTER : _to->Read64(_retval); } \
  [[nodiscard]] NS_IMETHOD ReadFloat(float *_retval) override { return !_to ? NS_ERROR_NULL_POINTER : _to->ReadFloat(_retval); } \
  [[nodiscard]] NS_IMETHOD ReadDouble(double *_retval) override { return !_to ? NS_ERROR_NULL_POINTER : _to->ReadDouble(_retval); } \
  [[nodiscard]] NS_IMETHOD ReadCString(nsACString& _retval) override { return !_to ? NS_ERROR_NULL_POINTER : _to->ReadCString(_retval); } \
  [[nodiscard]] NS_IMETHOD ReadString(nsAString& _retval) override { return !_to ? NS_ERROR_NULL_POINTER : _to->ReadString(_retval); } \
  [[nodiscard]] NS_IMETHOD ReadBytes(uint32_t aLength, char * *aString) override { return !_to ? NS_ERROR_NULL_POINTER : _to->ReadBytes(aLength, aString); } \
  [[nodiscard]] NS_IMETHOD ReadByteArray(uint32_t aLength, nsTArray<uint8_t >& _retval) override { return !_to ? NS_ERROR_NULL_POINTER : _to->ReadByteArray(aLength, _retval); } \
  [[nodiscard]] NS_IMETHOD ReadArrayBuffer(uint64_t aLength, JS::Handle<JS::Value> aArrayBuffer, JSContext* cx, uint64_t *_retval) override { return !_to ? NS_ERROR_NULL_POINTER : _to->ReadArrayBuffer(aLength, aArrayBuffer, cx, _retval); } 

// %{C++:85-116

#ifdef MOZILLA_INTERNAL_API
#include "nsString.h"

inline nsresult
NS_ReadOptionalCString(nsIBinaryInputStream* aStream, nsACString& aResult)
{
    bool nonnull;
    nsresult rv = aStream->ReadBoolean(&nonnull);
    if (NS_SUCCEEDED(rv)) {
        if (nonnull)
            rv = aStream->ReadCString(aResult);
        else
            aResult.Truncate();
    }
    return rv;
}

inline nsresult
NS_ReadOptionalString(nsIBinaryInputStream* aStream, nsAString& aResult)
{
    bool nonnull;
    nsresult rv = aStream->ReadBoolean(&nonnull);
    if (NS_SUCCEEDED(rv)) {
        if (nonnull)
            rv = aStream->ReadString(aResult);
        else
            aResult.Truncate();
    }
    return rv;
}
#endif
// %}

#endif /* __gen_nsIBinaryInputStream_h__ */
