/*
 * DO NOT EDIT.  THIS FILE IS GENERATED FROM $SRCDIR/netwerk/base/nsIURIMutator.idl
 */

#ifndef __gen_nsIURIMutator_h__
#define __gen_nsIURIMutator_h__


#include "nsISupports.h"

/* For IDL files that don't want to include root IDL files. */
#ifndef NS_NO_VTABLE
#define NS_NO_VTABLE
#endif
class nsIURI; /* forward declaration */

class nsIObjectInputStream; /* forward declaration */

class nsIURIMutator; /* forward declaration */

// %{C++:12-148
#include "nsString.h"
#include "nsCOMPtr.h"
#include <utility>

#undef SetPort  // XXX Windows!

namespace mozilla {
class Encoding;
}

namespace mozilla {
namespace ipc {
class URIParams;
} // namespace ipc
} // namespace mozilla

template <class T>
class BaseURIMutator
{
// This is the base class that can be extended by implementors of nsIURIMutator
// in order to avoid code duplication
// Class type T should be the type of the class that implements nsIURI
protected:
  virtual T* Create()
  {
    return new T();
  }

  [[nodiscard]] nsresult InitFromURI(T* aURI)
  {
    nsCOMPtr<nsIURI> clone;
    nsresult rv = aURI->Clone(getter_AddRefs(clone));
    if (NS_FAILED(rv)) {
      return rv;
    }
    mURI = static_cast<T*>(clone.get());
    return NS_OK;
  }

  [[nodiscard]] nsresult InitFromInputStream(nsIObjectInputStream* aStream)
  {
    RefPtr<T> uri = Create();
    nsresult rv = uri->ReadPrivate(aStream);
    if (NS_FAILED(rv)) {
      return rv;
    }
    mURI = std::move(uri);
    return NS_OK;
  }

  [[nodiscard]] nsresult InitFromIPCParams(const mozilla::ipc::URIParams& aParams)
  {
    RefPtr<T> uri = Create();
    bool ret = uri->Deserialize(aParams);
    if (!ret) {
      return NS_ERROR_FAILURE;
    }
    mURI = std::move(uri);
    return NS_OK;
  }

  [[nodiscard]] nsresult InitFromSpec(const nsACString& aSpec)
  {
    nsresult rv = NS_OK;
    RefPtr<T> uri;
    if (mURI) {
      // This only works because all other Init methods create a new object
      mURI.swap(uri);
    } else {
      uri = Create();
    }

    rv = uri->SetSpecInternal(aSpec);
    if (NS_FAILED(rv)) {
      return rv;
    }
    mURI = std::move(uri);
    return NS_OK;
  }

  RefPtr<T> mURI;
};

// Since most implementations of nsIURIMutator would extend BaseURIMutator,
// some methods would have the same implementation. We provide a useful macro
// to avoid code duplication.
#define NS_DEFINE_NSIMUTATOR_COMMON                                           \
  [[nodiscard]] NS_IMETHOD                                                    \
  Deserialize(const mozilla::ipc::URIParams& aParams) override                \
  {                                                                           \
    return InitFromIPCParams(aParams);                                        \
  }                                                                           \
                                                                              \
  [[nodiscard]] NS_IMETHOD                                                    \
  Finalize(nsIURI** aURI) override                                            \
  {                                                                           \
    mURI.forget(aURI); return NS_OK;                                          \
  }                                                                           \
                                                                              \
  [[nodiscard]] NS_IMETHOD                                                    \
  SetSpec(const nsACString& aSpec, nsIURIMutator** aMutator) override         \
  {                                                                           \
    if (aMutator) NS_ADDREF(*aMutator = this);                                \
    return InitFromSpec(aSpec);                                               \
  }                                                                           \

// Implements AddRef, Release and QueryInterface for the mutator
#define NS_IMPL_NSIURIMUTATOR_ISUPPORTS(aClass, ...)                          \
  NS_IMPL_ADDREF(aClass)                                                      \
  NS_IMPL_RELEASE(aClass)                                                     \
  NS_IMPL_NSIURIMUTATOR_QUERY_INTERFACE(aClass, __VA_ARGS__)                  \

// The list of interfaces is queried and an AddRef-ed pointer is returned if
// there is a match. Otherwise, we call QueryInterface on mURI and return.
// The reason for this specialized QueryInterface implementation is that we
// we want to be able to instantiate the mutator for a given CID of a
// nsIURI implementation, call nsISerializable.Read() on the mutator to
// deserialize the URI then QueryInterface the mutator to an nsIURI interface.
// See bug 1442239.
// If you QueryInterface a mutator to an interface of the URI
// implementation this is similar to calling Finalize.
#define NS_IMPL_NSIURIMUTATOR_QUERY_INTERFACE(aClass, ...)                    \
  static_assert(MOZ_ARG_COUNT(__VA_ARGS__) > 0,                               \
                "Need more arguments");                                       \
  NS_INTERFACE_MAP_BEGIN(aClass)                                              \
    nsCOMPtr<nsIURI> uri;                                                     \
    NS_INTERFACE_MAP_ENTRY_AMBIGUOUS(nsISupports, nsIURIMutator)              \
    MOZ_FOR_EACH(NS_INTERFACE_MAP_ENTRY, (), (__VA_ARGS__))                   \
    if (aIID.Equals(NS_GET_IID(nsIClassInfo))) {                              \
      foundInterface = nullptr;                                               \
    } else                                                                    \
    if (mURI &&                                                               \
        NS_SUCCEEDED(mURI->QueryInterface(aIID, getter_AddRefs(uri)))) {      \
        mURI = nullptr;                                                       \
        foundInterface = uri.get();                                           \
    } else                                                                    \
  NS_INTERFACE_MAP_END                                                        \
// %}

/* starting interface:    nsIURISetSpec */
#define NS_IURISETSPEC_IID_STR "1fc53257-898b-4c5e-b69c-05bc84b4cd8f"

#define NS_IURISETSPEC_IID \
  {0x1fc53257, 0x898b, 0x4c5e, \
    { 0xb6, 0x9c, 0x05, 0xbc, 0x84, 0xb4, 0xcd, 0x8f }}

class NS_NO_VTABLE nsIURISetSpec : public nsISupports {
 public:

  NS_INLINE_DECL_STATIC_IID(NS_IURISETSPEC_IID)

  /* Used by ToJSValue to check which scriptable interface is implemented. */
  using ScriptableInterfaceType = nsIURISetSpec;

  /* [must_use] nsIURIMutator setSpec (in AUTF8String aSpec); */
  [[nodiscard]] NS_IMETHOD SetSpec(const nsACString& aSpec, nsIURIMutator **_retval) = 0;

};


/* Use this macro when declaring classes that implement this interface. */
#define NS_DECL_NSIURISETSPEC \
  [[nodiscard]] NS_IMETHOD SetSpec(const nsACString& aSpec, nsIURIMutator **_retval) override; 

/* Use this macro when declaring the members of this interface when the
   class doesn't implement the interface. This is useful for forwarding. */
#define NS_DECL_NON_VIRTUAL_NSIURISETSPEC \
  [[nodiscard]] nsresult SetSpec(const nsACString& aSpec, nsIURIMutator **_retval); 

/* Use this macro to declare functions that forward the behavior of this interface to another object. */
#define NS_FORWARD_NSIURISETSPEC(_to) \
  [[nodiscard]] NS_IMETHOD SetSpec(const nsACString& aSpec, nsIURIMutator **_retval) override { return _to SetSpec(aSpec, _retval); } 

/* Use this macro to declare functions that forward the behavior of this interface to another object in a safe way. */
#define NS_FORWARD_SAFE_NSIURISETSPEC(_to) \
  [[nodiscard]] NS_IMETHOD SetSpec(const nsACString& aSpec, nsIURIMutator **_retval) override { return !_to ? NS_ERROR_NULL_POINTER : _to->SetSpec(aSpec, _retval); } 


/* starting interface:    nsIURISetters */
#define NS_IURISETTERS_IID_STR "5403a6ec-99d7-405e-8b45-9f805bbdfcef"

#define NS_IURISETTERS_IID \
  {0x5403a6ec, 0x99d7, 0x405e, \
    { 0x8b, 0x45, 0x9f, 0x80, 0x5b, 0xbd, 0xfc, 0xef }}

class NS_NO_VTABLE nsIURISetters : public nsIURISetSpec {
 public:

  NS_INLINE_DECL_STATIC_IID(NS_IURISETTERS_IID)

  /* Used by ToJSValue to check which scriptable interface is implemented. */
  using ScriptableInterfaceType = nsIURISetters;

  /* [must_use] nsIURIMutator setScheme (in AUTF8String aScheme); */
  [[nodiscard]] NS_IMETHOD SetScheme(const nsACString& aScheme, nsIURIMutator **_retval) = 0;

  /* [must_use] nsIURIMutator setUserPass (in AUTF8String aUserPass); */
  [[nodiscard]] NS_IMETHOD SetUserPass(const nsACString& aUserPass, nsIURIMutator **_retval) = 0;

  /* [must_use] nsIURIMutator setUsername (in AUTF8String aUsername); */
  [[nodiscard]] NS_IMETHOD SetUsername(const nsACString& aUsername, nsIURIMutator **_retval) = 0;

  /* [must_use] nsIURIMutator setPassword (in AUTF8String aPassword); */
  [[nodiscard]] NS_IMETHOD SetPassword(const nsACString& aPassword, nsIURIMutator **_retval) = 0;

  /* [must_use] nsIURIMutator setHostPort (in AUTF8String aHostPort); */
  [[nodiscard]] NS_IMETHOD SetHostPort(const nsACString& aHostPort, nsIURIMutator **_retval) = 0;

  /* [must_use] nsIURIMutator setHost (in AUTF8String aHost); */
  [[nodiscard]] NS_IMETHOD SetHost(const nsACString& aHost, nsIURIMutator **_retval) = 0;

  /* [must_use] nsIURIMutator setPort (in long aPort); */
  [[nodiscard]] NS_IMETHOD SetPort(int32_t aPort, nsIURIMutator **_retval) = 0;

  /* [must_use] nsIURIMutator setPathQueryRef (in AUTF8String aPathQueryRef); */
  [[nodiscard]] NS_IMETHOD SetPathQueryRef(const nsACString& aPathQueryRef, nsIURIMutator **_retval) = 0;

  /* [must_use] nsIURIMutator setRef (in AUTF8String aRef); */
  [[nodiscard]] NS_IMETHOD SetRef(const nsACString& aRef, nsIURIMutator **_retval) = 0;

  /* [must_use] nsIURIMutator setFilePath (in AUTF8String aFilePath); */
  [[nodiscard]] NS_IMETHOD SetFilePath(const nsACString& aFilePath, nsIURIMutator **_retval) = 0;

  /* [must_use] nsIURIMutator setQuery (in AUTF8String aQuery); */
  [[nodiscard]] NS_IMETHOD SetQuery(const nsACString& aQuery, nsIURIMutator **_retval) = 0;

  /* [must_use,noscript] nsIURIMutator setQueryWithEncoding (in AUTF8String query, in Encoding encoding); */
  [[nodiscard]] NS_IMETHOD SetQueryWithEncoding(const nsACString& query, const mozilla::Encoding * encoding, nsIURIMutator **_retval) = 0;

};


/* Use this macro when declaring classes that implement this interface. */
#define NS_DECL_NSIURISETTERS \
  [[nodiscard]] NS_IMETHOD SetScheme(const nsACString& aScheme, nsIURIMutator **_retval) override; \
  [[nodiscard]] NS_IMETHOD SetUserPass(const nsACString& aUserPass, nsIURIMutator **_retval) override; \
  [[nodiscard]] NS_IMETHOD SetUsername(const nsACString& aUsername, nsIURIMutator **_retval) override; \
  [[nodiscard]] NS_IMETHOD SetPassword(const nsACString& aPassword, nsIURIMutator **_retval) override; \
  [[nodiscard]] NS_IMETHOD SetHostPort(const nsACString& aHostPort, nsIURIMutator **_retval) override; \
  [[nodiscard]] NS_IMETHOD SetHost(const nsACString& aHost, nsIURIMutator **_retval) override; \
  [[nodiscard]] NS_IMETHOD SetPort(int32_t aPort, nsIURIMutator **_retval) override; \
  [[nodiscard]] NS_IMETHOD SetPathQueryRef(const nsACString& aPathQueryRef, nsIURIMutator **_retval) override; \
  [[nodiscard]] NS_IMETHOD SetRef(const nsACString& aRef, nsIURIMutator **_retval) override; \
  [[nodiscard]] NS_IMETHOD SetFilePath(const nsACString& aFilePath, nsIURIMutator **_retval) override; \
  [[nodiscard]] NS_IMETHOD SetQuery(const nsACString& aQuery, nsIURIMutator **_retval) override; \
  [[nodiscard]] NS_IMETHOD SetQueryWithEncoding(const nsACString& query, const mozilla::Encoding * encoding, nsIURIMutator **_retval) override; 

/* Use this macro when declaring the members of this interface when the
   class doesn't implement the interface. This is useful for forwarding. */
#define NS_DECL_NON_VIRTUAL_NSIURISETTERS \
  [[nodiscard]] nsresult SetScheme(const nsACString& aScheme, nsIURIMutator **_retval); \
  [[nodiscard]] nsresult SetUserPass(const nsACString& aUserPass, nsIURIMutator **_retval); \
  [[nodiscard]] nsresult SetUsername(const nsACString& aUsername, nsIURIMutator **_retval); \
  [[nodiscard]] nsresult SetPassword(const nsACString& aPassword, nsIURIMutator **_retval); \
  [[nodiscard]] nsresult SetHostPort(const nsACString& aHostPort, nsIURIMutator **_retval); \
  [[nodiscard]] nsresult SetHost(const nsACString& aHost, nsIURIMutator **_retval); \
  [[nodiscard]] nsresult SetPort(int32_t aPort, nsIURIMutator **_retval); \
  [[nodiscard]] nsresult SetPathQueryRef(const nsACString& aPathQueryRef, nsIURIMutator **_retval); \
  [[nodiscard]] nsresult SetRef(const nsACString& aRef, nsIURIMutator **_retval); \
  [[nodiscard]] nsresult SetFilePath(const nsACString& aFilePath, nsIURIMutator **_retval); \
  [[nodiscard]] nsresult SetQuery(const nsACString& aQuery, nsIURIMutator **_retval); \
  [[nodiscard]] nsresult SetQueryWithEncoding(const nsACString& query, const mozilla::Encoding * encoding, nsIURIMutator **_retval); 

/* Use this macro to declare functions that forward the behavior of this interface to another object. */
#define NS_FORWARD_NSIURISETTERS(_to) \
  [[nodiscard]] NS_IMETHOD SetScheme(const nsACString& aScheme, nsIURIMutator **_retval) override { return _to SetScheme(aScheme, _retval); } \
  [[nodiscard]] NS_IMETHOD SetUserPass(const nsACString& aUserPass, nsIURIMutator **_retval) override { return _to SetUserPass(aUserPass, _retval); } \
  [[nodiscard]] NS_IMETHOD SetUsername(const nsACString& aUsername, nsIURIMutator **_retval) override { return _to SetUsername(aUsername, _retval); } \
  [[nodiscard]] NS_IMETHOD SetPassword(const nsACString& aPassword, nsIURIMutator **_retval) override { return _to SetPassword(aPassword, _retval); } \
  [[nodiscard]] NS_IMETHOD SetHostPort(const nsACString& aHostPort, nsIURIMutator **_retval) override { return _to SetHostPort(aHostPort, _retval); } \
  [[nodiscard]] NS_IMETHOD SetHost(const nsACString& aHost, nsIURIMutator **_retval) override { return _to SetHost(aHost, _retval); } \
  [[nodiscard]] NS_IMETHOD SetPort(int32_t aPort, nsIURIMutator **_retval) override { return _to SetPort(aPort, _retval); } \
  [[nodiscard]] NS_IMETHOD SetPathQueryRef(const nsACString& aPathQueryRef, nsIURIMutator **_retval) override { return _to SetPathQueryRef(aPathQueryRef, _retval); } \
  [[nodiscard]] NS_IMETHOD SetRef(const nsACString& aRef, nsIURIMutator **_retval) override { return _to SetRef(aRef, _retval); } \
  [[nodiscard]] NS_IMETHOD SetFilePath(const nsACString& aFilePath, nsIURIMutator **_retval) override { return _to SetFilePath(aFilePath, _retval); } \
  [[nodiscard]] NS_IMETHOD SetQuery(const nsACString& aQuery, nsIURIMutator **_retval) override { return _to SetQuery(aQuery, _retval); } \
  [[nodiscard]] NS_IMETHOD SetQueryWithEncoding(const nsACString& query, const mozilla::Encoding * encoding, nsIURIMutator **_retval) override { return _to SetQueryWithEncoding(query, encoding, _retval); } 

/* Use this macro to declare functions that forward the behavior of this interface to another object in a safe way. */
#define NS_FORWARD_SAFE_NSIURISETTERS(_to) \
  [[nodiscard]] NS_IMETHOD SetScheme(const nsACString& aScheme, nsIURIMutator **_retval) override { return !_to ? NS_ERROR_NULL_POINTER : _to->SetScheme(aScheme, _retval); } \
  [[nodiscard]] NS_IMETHOD SetUserPass(const nsACString& aUserPass, nsIURIMutator **_retval) override { return !_to ? NS_ERROR_NULL_POINTER : _to->SetUserPass(aUserPass, _retval); } \
  [[nodiscard]] NS_IMETHOD SetUsername(const nsACString& aUsername, nsIURIMutator **_retval) override { return !_to ? NS_ERROR_NULL_POINTER : _to->SetUsername(aUsername, _retval); } \
  [[nodiscard]] NS_IMETHOD SetPassword(const nsACString& aPassword, nsIURIMutator **_retval) override { return !_to ? NS_ERROR_NULL_POINTER : _to->SetPassword(aPassword, _retval); } \
  [[nodiscard]] NS_IMETHOD SetHostPort(const nsACString& aHostPort, nsIURIMutator **_retval) override { return !_to ? NS_ERROR_NULL_POINTER : _to->SetHostPort(aHostPort, _retval); } \
  [[nodiscard]] NS_IMETHOD SetHost(const nsACString& aHost, nsIURIMutator **_retval) override { return !_to ? NS_ERROR_NULL_POINTER : _to->SetHost(aHost, _retval); } \
  [[nodiscard]] NS_IMETHOD SetPort(int32_t aPort, nsIURIMutator **_retval) override { return !_to ? NS_ERROR_NULL_POINTER : _to->SetPort(aPort, _retval); } \
  [[nodiscard]] NS_IMETHOD SetPathQueryRef(const nsACString& aPathQueryRef, nsIURIMutator **_retval) override { return !_to ? NS_ERROR_NULL_POINTER : _to->SetPathQueryRef(aPathQueryRef, _retval); } \
  [[nodiscard]] NS_IMETHOD SetRef(const nsACString& aRef, nsIURIMutator **_retval) override { return !_to ? NS_ERROR_NULL_POINTER : _to->SetRef(aRef, _retval); } \
  [[nodiscard]] NS_IMETHOD SetFilePath(const nsACString& aFilePath, nsIURIMutator **_retval) override { return !_to ? NS_ERROR_NULL_POINTER : _to->SetFilePath(aFilePath, _retval); } \
  [[nodiscard]] NS_IMETHOD SetQuery(const nsACString& aQuery, nsIURIMutator **_retval) override { return !_to ? NS_ERROR_NULL_POINTER : _to->SetQuery(aQuery, _retval); } \
  [[nodiscard]] NS_IMETHOD SetQueryWithEncoding(const nsACString& query, const mozilla::Encoding * encoding, nsIURIMutator **_retval) override { return !_to ? NS_ERROR_NULL_POINTER : _to->SetQueryWithEncoding(query, encoding, _retval); } 

// %{C++:205-280

// Using this macro instead of NS_FORWARD_SAFE_NSIURISETTERS makes chaining
// setter operations possible.
#define NS_FORWARD_SAFE_NSIURISETTERS_RET(_to)                                \
  [[nodiscard]] NS_IMETHOD                                                    \
  SetScheme(const nsACString& aScheme, nsIURIMutator** aMutator) override     \
  {                                                                           \
    if (aMutator) NS_ADDREF(*aMutator = this);                                \
    return !_to ? NS_ERROR_NULL_POINTER : _to->SetScheme(aScheme);            \
  }                                                                           \
  [[nodiscard]] NS_IMETHOD                                                    \
  SetUserPass(const nsACString& aUserPass, nsIURIMutator** aMutator) override \
  {                                                                           \
    if (aMutator) NS_ADDREF(*aMutator = this);                                \
    return !_to ? NS_ERROR_NULL_POINTER : _to->SetUserPass(aUserPass);        \
  }                                                                           \
  [[nodiscard]] NS_IMETHOD                                                    \
  SetUsername(const nsACString& aUsername, nsIURIMutator** aMutator) override \
  {                                                                           \
    if (aMutator) NS_ADDREF(*aMutator = this);                                \
    return !_to ? NS_ERROR_NULL_POINTER : _to->SetUsername(aUsername);        \
  }                                                                           \
  [[nodiscard]] NS_IMETHOD                                                    \
  SetPassword(const nsACString& aPassword, nsIURIMutator** aMutator) override \
  {                                                                           \
    if (aMutator) NS_ADDREF(*aMutator = this);                                \
    return !_to ? NS_ERROR_NULL_POINTER : _to->SetPassword(aPassword);        \
  }                                                                           \
  [[nodiscard]] NS_IMETHOD                                                    \
  SetHostPort(const nsACString& aHostPort, nsIURIMutator** aMutator) override \
  {                                                                           \
    if (aMutator) NS_ADDREF(*aMutator = this);                                \
    return !_to ? NS_ERROR_NULL_POINTER : _to->SetHostPort(aHostPort);        \
  }                                                                           \
  [[nodiscard]] NS_IMETHOD                                                    \
  SetHost(const nsACString& aHost, nsIURIMutator** aMutator) override         \
  {                                                                           \
    if (aMutator) NS_ADDREF(*aMutator = this);                                \
    return !_to ? NS_ERROR_NULL_POINTER : _to->SetHost(aHost);                \
  }                                                                           \
  [[nodiscard]] NS_IMETHOD                                                    \
  SetPort(int32_t aPort, nsIURIMutator** aMutator) override                   \
  {                                                                           \
    if (aMutator) NS_ADDREF(*aMutator = this);                                \
    return !_to ? NS_ERROR_NULL_POINTER : _to->SetPort(aPort);                \
  }                                                                           \
  [[nodiscard]] NS_IMETHOD                                                    \
  SetPathQueryRef(const nsACString& aPathQueryRef, nsIURIMutator** aMutator) override \
  {                                                                           \
    if (aMutator) NS_ADDREF(*aMutator = this);                                \
    return !_to ? NS_ERROR_NULL_POINTER : _to->SetPathQueryRef(aPathQueryRef); \
  }                                                                           \
  [[nodiscard]] NS_IMETHOD                                                    \
  SetRef(const nsACString& aRef, nsIURIMutator** aMutator) override           \
  {                                                                           \
    if (aMutator) NS_ADDREF(*aMutator = this);                                \
    return !_to ? NS_ERROR_NULL_POINTER : _to->SetRef(aRef);                  \
  }                                                                           \
  [[nodiscard]] NS_IMETHOD                                                    \
  SetFilePath(const nsACString& aFilePath, nsIURIMutator** aMutator) override \
  {                                                                           \
    if (aMutator) NS_ADDREF(*aMutator = this);                                \
    return !_to ? NS_ERROR_NULL_POINTER : _to->SetFilePath(aFilePath);        \
  }                                                                           \
  [[nodiscard]] NS_IMETHOD                                                    \
  SetQuery(const nsACString& aQuery, nsIURIMutator** aMutator) override       \
  {                                                                           \
    if (aMutator) NS_ADDREF(*aMutator = this);                                \
    return !_to ? NS_ERROR_NULL_POINTER : _to->SetQuery(aQuery);              \
  }                                                                           \
  [[nodiscard]] NS_IMETHOD                                                    \
  SetQueryWithEncoding(const nsACString& query, const mozilla::Encoding *encoding, nsIURIMutator** aMutator) override \
  {                                                                           \
    if (aMutator) NS_ADDREF(*aMutator = this);                                \
    return !_to ? NS_ERROR_NULL_POINTER : _to->SetQueryWithEncoding(query, encoding); \
  }                                                                           \
// %}

/* starting interface:    nsIURIMutator */
#define NS_IURIMUTATOR_IID_STR "4d1f3103-1c44-4dcd-b717-5d22a697a7d9"

#define NS_IURIMUTATOR_IID \
  {0x4d1f3103, 0x1c44, 0x4dcd, \
    { 0xb7, 0x17, 0x5d, 0x22, 0xa6, 0x97, 0xa7, 0xd9 }}

class NS_NO_VTABLE nsIURIMutator : public nsIURISetters {
 public:

  NS_INLINE_DECL_STATIC_IID(NS_IURIMUTATOR_IID)

  /* Used by ToJSValue to check which scriptable interface is implemented. */
  using ScriptableInterfaceType = nsIURIMutator;

  /* [must_use,noscript,notxpcom] nsresult deserialize (in const_URIParams_ref aParams); */
  [[nodiscard]] NS_IMETHOD Deserialize(const mozilla::ipc::URIParams & aParams) = 0;

  /* [must_use] nsIURI finalize (); */
  [[nodiscard]] NS_IMETHOD Finalize(nsIURI **_retval) = 0;

};


/* Use this macro when declaring classes that implement this interface. */
#define NS_DECL_NSIURIMUTATOR \
  [[nodiscard]] NS_IMETHOD Deserialize(const mozilla::ipc::URIParams & aParams) override; \
  [[nodiscard]] NS_IMETHOD Finalize(nsIURI **_retval) override; 

/* Use this macro when declaring the members of this interface when the
   class doesn't implement the interface. This is useful for forwarding. */
#define NS_DECL_NON_VIRTUAL_NSIURIMUTATOR \
  [[nodiscard]] nsresult Deserialize(const mozilla::ipc::URIParams & aParams); \
  [[nodiscard]] nsresult Finalize(nsIURI **_retval); 

/* Use this macro to declare functions that forward the behavior of this interface to another object. */
#define NS_FORWARD_NSIURIMUTATOR(_to) \
  [[nodiscard]] NS_IMETHOD Deserialize(const mozilla::ipc::URIParams & aParams) override { return _to Deserialize(aParams); } \
  [[nodiscard]] NS_IMETHOD Finalize(nsIURI **_retval) override { return _to Finalize(_retval); } 

/* Use this macro to declare functions that forward the behavior of this interface to another object in a safe way. */
#define NS_FORWARD_SAFE_NSIURIMUTATOR(_to) \
  [[nodiscard]] NS_IMETHOD Deserialize(const mozilla::ipc::URIParams & aParams) override; \
  [[nodiscard]] NS_IMETHOD Finalize(nsIURI **_retval) override { return !_to ? NS_ERROR_NULL_POINTER : _to->Finalize(_retval); } 

// %{C++:302-538

// This templated struct is used to extract the class type of the method
template <typename Method>
struct nsMethodTypeTraits;

template <class C, typename R, typename... As>
struct nsMethodTypeTraits<R(C::*)(As...)>
{
  typedef C class_type;
};

#ifdef NS_HAVE_STDCALL
template <class C, typename R, typename... As>
struct nsMethodTypeTraits<R(__stdcall C::*)(As...)>
{
  typedef C class_type;
};
#endif


// This class provides a useful helper that allows chaining of setter operations
class MOZ_STACK_CLASS NS_MutateURI
{
public:
  explicit NS_MutateURI(nsIURI* aURI);
  explicit NS_MutateURI(const char * aContractID);

  explicit NS_MutateURI(nsIURIMutator* m)
  {
    mStatus = m ? NS_OK : NS_ERROR_NULL_POINTER;
    mMutator = m;
    NS_ENSURE_SUCCESS_VOID(mStatus);
  }

  NS_MutateURI& SetSpec(const nsACString& aSpec)
  {
    if (NS_FAILED(mStatus)) {
      return *this;
    }
    mStatus = mMutator->SetSpec(aSpec, nullptr);
    return *this;
  }
  NS_MutateURI& SetScheme(const nsACString& aScheme)
  {
    if (NS_FAILED(mStatus)) {
      return *this;
    }
    mStatus = mMutator->SetScheme(aScheme, nullptr);
    NS_ENSURE_SUCCESS(mStatus, *this);
    return *this;
  }
  NS_MutateURI& SetUserPass(const nsACString& aUserPass)
  {
    if (NS_FAILED(mStatus)) {
      return *this;
    }
    mStatus = mMutator->SetUserPass(aUserPass, nullptr);
    return *this;
  }
  NS_MutateURI& SetUsername(const nsACString& aUsername)
  {
    if (NS_FAILED(mStatus)) {
      return *this;
    }
    mStatus = mMutator->SetUsername(aUsername, nullptr);
    NS_ENSURE_SUCCESS(mStatus, *this);
    return *this;
  }
  NS_MutateURI& SetPassword(const nsACString& aPassword)
  {
    if (NS_FAILED(mStatus)) {
      return *this;
    }
    mStatus = mMutator->SetPassword(aPassword, nullptr);
    NS_ENSURE_SUCCESS(mStatus, *this);
    return *this;
  }
  NS_MutateURI& SetHostPort(const nsACString& aHostPort)
  {
    if (NS_FAILED(mStatus)) {
      return *this;
    }
    mStatus = mMutator->SetHostPort(aHostPort, nullptr);
    NS_ENSURE_SUCCESS(mStatus, *this);
    return *this;
  }
  NS_MutateURI& SetHost(const nsACString& aHost)
  {
    if (NS_FAILED(mStatus)) {
      return *this;
    }
    mStatus = mMutator->SetHost(aHost, nullptr);
    NS_ENSURE_SUCCESS(mStatus, *this);
    return *this;
  }
  NS_MutateURI& SetPort(int32_t aPort)
  {
    if (NS_FAILED(mStatus)) {
      return *this;
    }
    mStatus = mMutator->SetPort(aPort, nullptr);
    NS_ENSURE_SUCCESS(mStatus, *this);
    return *this;
  }
  NS_MutateURI& SetPathQueryRef(const nsACString& aPathQueryRef)
  {
    if (NS_FAILED(mStatus)) {
      return *this;
    }
    mStatus = mMutator->SetPathQueryRef(aPathQueryRef, nullptr);
    NS_ENSURE_SUCCESS(mStatus, *this);
    return *this;
  }
  NS_MutateURI& SetRef(const nsACString& aRef)
  {
    if (NS_FAILED(mStatus)) {
      return *this;
    }
    mStatus = mMutator->SetRef(aRef, nullptr);
    NS_ENSURE_SUCCESS(mStatus, *this);
    return *this;
  }
  NS_MutateURI& SetFilePath(const nsACString& aFilePath)
  {
    if (NS_FAILED(mStatus)) {
      return *this;
    }
    mStatus = mMutator->SetFilePath(aFilePath, nullptr);
    NS_ENSURE_SUCCESS(mStatus, *this);
    return *this;
  }
  NS_MutateURI& SetQuery(const nsACString& aQuery)
  {
    if (NS_FAILED(mStatus)) {
      return *this;
    }
    mStatus = mMutator->SetQuery(aQuery, nullptr);
    NS_ENSURE_SUCCESS(mStatus, *this);
    return *this;
  }
  NS_MutateURI& SetQueryWithEncoding(const nsACString& query, const mozilla::Encoding *encoding)
  {
    if (NS_FAILED(mStatus)) {
      return *this;
    }
    mStatus = mMutator->SetQueryWithEncoding(query, encoding, nullptr);
    NS_ENSURE_SUCCESS(mStatus, *this);
    return *this;
  }

  /**
   * This method allows consumers to call the methods declared in other
   * interfaces implemented by the mutator object.
   *
   * Example:
   * nsCOMPtr<nsIURI> uri;
   * nsresult rv = NS_MutateURI(new URIClass::Mutator())
   *                 .SetSpec(aSpec)
   *                 .Apply(&SomeInterface::Method, arg1, arg2)
   *                 .Finalize(uri);
   *
   * If mMutator does not implement SomeInterface, do_QueryInterface will fail
   * and the method will not be called.
   * If aMethod does not exist, or if there is a mismatch between argument
   * types, or the number of arguments, then there will be a compile error.
   */
  template <typename Method, typename... Args>
  NS_MutateURI& Apply(Method aMethod, Args&&... aArgs)
  {
    typedef typename nsMethodTypeTraits<Method>::class_type Interface;
    NS_ENSURE_SUCCESS(mStatus, *this);
    nsCOMPtr<Interface> target = do_QueryInterface(mMutator, &mStatus);
    MOZ_ASSERT(NS_SUCCEEDED(mStatus), "URL object must implement interface");
    NS_ENSURE_SUCCESS(mStatus, *this);
    mStatus = (target->*aMethod)(std::forward<Args>(aArgs)...);
    return *this;
  }

  template <class C>
  [[nodiscard]] nsresult Finalize(nsCOMPtr<C>& aURI)
  {
    NS_ENSURE_SUCCESS(mStatus, mStatus);

    nsCOMPtr<nsIURI> uri;
    mStatus = mMutator->Finalize(getter_AddRefs(uri));
    NS_ENSURE_SUCCESS(mStatus, mStatus);

    aURI = do_QueryInterface(uri, &mStatus);
    NS_ENSURE_SUCCESS(mStatus, mStatus);

    mStatus = NS_ERROR_NOT_AVAILABLE; // Second call to Finalize should fail.
    return NS_OK;
  }

  // Overload for nsIURI to avoid query interface.
  [[nodiscard]] nsresult Finalize(nsCOMPtr<nsIURI>& aURI)
  {
    if (NS_FAILED(mStatus)) return mStatus;
    mStatus = mMutator->Finalize(getter_AddRefs(aURI));
    NS_ENSURE_SUCCESS(mStatus, mStatus);

    mStatus = NS_ERROR_NOT_AVAILABLE; // Second call to Finalize should fail.
    return NS_OK;
  }

  template <class C>
  [[nodiscard]] nsresult Finalize(C** aURI)
  {
    NS_ENSURE_SUCCESS(mStatus, mStatus);

    nsCOMPtr<nsIURI> uri;
    mStatus = mMutator->Finalize(getter_AddRefs(uri));
    NS_ENSURE_SUCCESS(mStatus, mStatus);

    nsCOMPtr<C> result = do_QueryInterface(uri, &mStatus);
    NS_ENSURE_SUCCESS(mStatus, mStatus);

    result.forget(aURI);
    mStatus = NS_ERROR_NOT_AVAILABLE; // Second call to Finalize should fail.
    return NS_OK;
  }

  [[nodiscard]] nsresult Finalize(nsIURI** aURI)
  {
    if (NS_FAILED(mStatus)) return mStatus;
    mStatus = mMutator->Finalize(aURI);
    NS_ENSURE_SUCCESS(mStatus, mStatus);

    mStatus = NS_ERROR_NOT_AVAILABLE; // Second call to Finalize should fail.
    return NS_OK;
  }

  nsresult GetStatus() { return mStatus; }
private:
  nsresult mStatus;
  nsCOMPtr<nsIURIMutator> mMutator;
};
// %}

#endif /* __gen_nsIURIMutator_h__ */
