/* THIS FILE IS AUTOGENERATED FROM ShadowRoot.webidl BY Codegen.py - DO NOT EDIT */

#include <type_traits>
#include "DocumentFragmentBinding.h"
#include "ElementBinding.h"
#include "EventHandlerBinding.h"
#include "MainThreadUtils.h"
#include "SanitizerBinding.h"
#include "ShadowRootBinding.h"
#include "WrapperFactory.h"
#include "XrayWrapper.h"
#include "js/Array.h"
#include "js/CallAndConstruct.h"
#include "js/Exception.h"
#include "js/ForOfIterator.h"
#include "js/MapAndSet.h"
#include "js/Object.h"
#include "js/PropertyAndElement.h"
#include "js/PropertyDescriptor.h"
#include "js/experimental/JitInfo.h"
#include "jsapi.h"
#include "mozilla/Atomics.h"
#include "mozilla/BasePrincipal.h"
#include "mozilla/FloatingPoint.h"
#include "mozilla/OwningNonNull.h"
#include "mozilla/ProfilerLabels.h"
#include "mozilla/StyleSheet.h"
#include "mozilla/dom/Animation.h"
#include "mozilla/dom/BindingCallContext.h"
#include "mozilla/dom/BindingUtils.h"
#include "mozilla/dom/CustomElementRegistry.h"
#include "mozilla/dom/DOMJSClass.h"
#include "mozilla/dom/DocGroup.h"
#include "mozilla/dom/Element.h"
#include "mozilla/dom/NonRefcountedDOMObject.h"
#include "mozilla/dom/Nullable.h"
#include "mozilla/dom/ObservableArrayProxyHandler.h"
#include "mozilla/dom/PrimitiveConversions.h"
#include "mozilla/dom/ShadowRoot.h"
#include "mozilla/dom/StyleSheetList.h"
#include "mozilla/dom/ToJSValue.h"
#include "mozilla/dom/TrustedHTML.h"
#include "mozilla/dom/UnionTypes.h"
#include "mozilla/dom/WebIDLPrefs.h"
#include "mozilla/dom/XrayExpandoClass.h"
#include "nsContentUtils.h"
#include "nsIContent.h"
#include "nsJSPrincipals.h"

namespace mozilla {

namespace dom {

namespace binding_detail {}; // Just to make sure it's known as a namespace
using namespace mozilla::dom::binding_detail;


namespace binding_detail {
constexpr nsLiteralCString EnumStrings<ShadowRootMode>::Values[2];
} // namespace binding_detail

bool
ToJSValue(JSContext* aCx, ShadowRootMode aArgument, JS::MutableHandle<JS::Value> aValue)
{
  MOZ_ASSERT(uint32_t(aArgument) < std::size(binding_detail::EnumStrings<ShadowRootMode>::Values));
  JSString* resultStr =
    JS_NewStringCopyN(aCx, binding_detail::EnumStrings<ShadowRootMode>::Values[uint32_t(aArgument)].BeginReading(),
                      binding_detail::EnumStrings<ShadowRootMode>::Values[uint32_t(aArgument)].Length());
  if (!resultStr) {
    return false;
  }
  aValue.setString(resultStr);
  return true;
}


namespace binding_detail {
constexpr nsLiteralCString EnumStrings<SlotAssignmentMode>::Values[2];
} // namespace binding_detail

bool
ToJSValue(JSContext* aCx, SlotAssignmentMode aArgument, JS::MutableHandle<JS::Value> aValue)
{
  MOZ_ASSERT(uint32_t(aArgument) < std::size(binding_detail::EnumStrings<SlotAssignmentMode>::Values));
  JSString* resultStr =
    JS_NewStringCopyN(aCx, binding_detail::EnumStrings<SlotAssignmentMode>::Values[uint32_t(aArgument)].BeginReading(),
                      binding_detail::EnumStrings<SlotAssignmentMode>::Values[uint32_t(aArgument)].Length());
  if (!resultStr) {
    return false;
  }
  aValue.setString(resultStr);
  return true;
}


namespace ShadowRoot_Binding {

static_assert(IsRefcounted<NativeType>::value == IsRefcounted<DocumentFragment_Binding::NativeType>::value,
              "Can't inherit from an interface with a different ownership model.");

MOZ_CAN_RUN_SCRIPT static bool
get_mode(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "ShadowRoot", "mode", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::ShadowRoot*>(void_self);
  ShadowRootMode result(MOZ_KnownLive(self)->Mode());
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (!ToJSValue(cx, result, args.rval())) {
    return false;
  }
  return true;
}

static const JSJitInfo mode_getterinfo = {
  { get_mode },
  { prototypes::id::ShadowRoot },
  { PrototypeTraits<prototypes::id::ShadowRoot>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_delegatesFocus(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "ShadowRoot", "delegatesFocus", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::ShadowRoot*>(void_self);
  bool result(MOZ_KnownLive(self)->DelegatesFocus());
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setBoolean(result);
  return true;
}

static const JSJitInfo delegatesFocus_getterinfo = {
  { get_delegatesFocus },
  { prototypes::id::ShadowRoot },
  { PrototypeTraits<prototypes::id::ShadowRoot>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_BOOLEAN,  /* returnType.  Not relevant for setters. */
  true,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_slotAssignment(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "ShadowRoot", "slotAssignment", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::ShadowRoot*>(void_self);
  SlotAssignmentMode result(MOZ_KnownLive(self)->SlotAssignment());
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (!ToJSValue(cx, result, args.rval())) {
    return false;
  }
  return true;
}

static const JSJitInfo slotAssignment_getterinfo = {
  { get_slotAssignment },
  { prototypes::id::ShadowRoot },
  { PrototypeTraits<prototypes::id::ShadowRoot>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_clonable(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "ShadowRoot", "clonable", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::ShadowRoot*>(void_self);
  bool result(MOZ_KnownLive(self)->Clonable());
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setBoolean(result);
  return true;
}

static const JSJitInfo clonable_getterinfo = {
  { get_clonable },
  { prototypes::id::ShadowRoot },
  { PrototypeTraits<prototypes::id::ShadowRoot>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_BOOLEAN,  /* returnType.  Not relevant for setters. */
  true,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_serializable(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "ShadowRoot", "serializable", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::ShadowRoot*>(void_self);
  bool result(MOZ_KnownLive(self)->Serializable());
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setBoolean(result);
  return true;
}

static const JSJitInfo serializable_getterinfo = {
  { get_serializable },
  { prototypes::id::ShadowRoot },
  { PrototypeTraits<prototypes::id::ShadowRoot>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_BOOLEAN,  /* returnType.  Not relevant for setters. */
  true,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_host(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "ShadowRoot", "host", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::ShadowRoot*>(void_self);
  auto result(StrongOrRawPtr<mozilla::dom::Element>(MOZ_KnownLive(self)->Host()));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (!GetOrCreateDOMReflector(cx, result, args.rval())) {
    MOZ_ASSERT(JS_IsExceptionPending(cx));
    return false;
  }
  return true;
}

static const JSJitInfo host_getterinfo = {
  { get_host },
  { prototypes::id::ShadowRoot },
  { PrototypeTraits<prototypes::id::ShadowRoot>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_OBJECT,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_onslotchange(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "ShadowRoot", "onslotchange", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::ShadowRoot*>(void_self);
  RefPtr<EventHandlerNonNull> result(MOZ_KnownLive(self)->GetOnslotchange());
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (result) {
    args.rval().setObjectOrNull(GetCallbackFromCallbackObject(cx, result));
    if (!MaybeWrapObjectOrNullValue(cx, args.rval())) {
      return false;
    }
    return true;
  } else {
    args.rval().setNull();
    return true;
  }
}

MOZ_CAN_RUN_SCRIPT static bool
set_onslotchange(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "ShadowRoot", "onslotchange", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_SETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::ShadowRoot*>(void_self);
  RootedCallback<RefPtr<binding_detail::FastEventHandlerNonNull>> arg0(cx);
  if (args[0].isObject()) {
    { // scope for tempRoot and tempGlobalRoot if needed
      arg0 = new binding_detail::FastEventHandlerNonNull(&args[0].toObject(), JS::CurrentGlobalOrNull(cx));
    }
  } else {
    arg0 = nullptr;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->SetOnslotchange(MOZ_KnownLive(Constify(arg0))))>, "Should be returning void here");
  MOZ_KnownLive(self)->SetOnslotchange(MOZ_KnownLive(Constify(arg0)));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));

  return true;
}

static const JSJitInfo onslotchange_getterinfo = {
  { get_onslotchange },
  { prototypes::id::ShadowRoot },
  { PrototypeTraits<prototypes::id::ShadowRoot>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNKNOWN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo onslotchange_setterinfo = {
  { (JSJitGetterOp)set_onslotchange },
  { prototypes::id::ShadowRoot },
  { PrototypeTraits<prototypes::id::ShadowRoot>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_referenceTarget(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "ShadowRoot", "referenceTarget", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::ShadowRoot*>(void_self);
  DOMString result;
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->GetReferenceTarget(result))>, "Should be returning void here");
  MOZ_KnownLive(self)->GetReferenceTarget(result);
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (!xpc::StringToJsval(cx, result, args.rval())) {
    return false;
  }
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
set_referenceTarget(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "ShadowRoot", "referenceTarget", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_SETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::ShadowRoot*>(void_self);
  binding_detail::FakeString<char16_t> arg0;
  if (!ConvertJSValueToString(cx, args[0], eNull, eNull, arg0)) {
    return false;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->SetReferenceTarget(NonNullHelper(Constify(arg0))))>, "Should be returning void here");
  MOZ_KnownLive(self)->SetReferenceTarget(NonNullHelper(Constify(arg0)));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));

  return true;
}

static const JSJitInfo referenceTarget_getterinfo = {
  { get_referenceTarget },
  { prototypes::id::ShadowRoot },
  { PrototypeTraits<prototypes::id::ShadowRoot>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNKNOWN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo referenceTarget_setterinfo = {
  { (JSJitGetterOp)set_referenceTarget },
  { prototypes::id::ShadowRoot },
  { PrototypeTraits<prototypes::id::ShadowRoot>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
getElementById(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "ShadowRoot", "getElementById", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::ShadowRoot*>(void_self);
  if (!args.requireAtLeast(cx, "ShadowRoot.getElementById", 1)) {
    return false;
  }
  binding_detail::FakeString<char16_t> arg0;
  if (!ConvertJSValueToString(cx, args[0], eStringify, eStringify, arg0)) {
    return false;
  }
  auto result(StrongOrRawPtr<mozilla::dom::Element>(MOZ_KnownLive(self)->GetElementById(NonNullHelper(Constify(arg0)))));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (!result) {
    args.rval().setNull();
    return true;
  }
  if (!GetOrCreateDOMReflector(cx, result, args.rval())) {
    MOZ_ASSERT(JS_IsExceptionPending(cx));
    return false;
  }
  return true;
}

static const JSJitInfo getElementById_methodinfo = {
  { (JSJitGetterOp)getElementById },
  { prototypes::id::ShadowRoot },
  { PrototypeTraits<prototypes::id::ShadowRoot>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNKNOWN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_innerHTML(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "ShadowRoot", "innerHTML", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::ShadowRoot*>(void_self);
  OwningTrustedHTMLOrNullIsEmptyString result;
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->GetInnerHTML(result))>, "Should be returning void here");
  MOZ_KnownLive(self)->GetInnerHTML(result);
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (!result.ToJSVal(cx, obj, args.rval())) {
    return false;
  }
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
set_innerHTML(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  BindingCallContext cx(cx_, "ShadowRoot.innerHTML setter");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "ShadowRoot", "innerHTML", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_SETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::ShadowRoot*>(void_self);
  TrustedHTMLOrNullIsEmptyString arg0;
  if (!arg0.Init(cx, args[0], "Value being assigned", false)) {
    return false;
  }
  Maybe<AutoCEReaction> ceReaction;
  DocGroup* docGroup = self->GetDocGroup();
  if (docGroup) {
    ceReaction.emplace(docGroup->CustomElementReactionsStack(), cx);
  }
  FastErrorResult rv;
  nsIPrincipal* subjectPrincipal;
  {
    JS::Realm* realm = js::GetContextRealm(cx);
    MOZ_ASSERT(realm);
    JSPrincipals* principals = JS::GetRealmPrincipals(realm);
    nsIPrincipal* principal = nsJSPrincipals::get(principals);
    if (principal->IsSystemPrincipal()) {
    principal = nullptr;
  }

    subjectPrincipal = principal;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->SetInnerHTML(Constify(arg0), MOZ_KnownLive(subjectPrincipal), rv))>, "Should be returning void here");
  MOZ_KnownLive(self)->SetInnerHTML(Constify(arg0), MOZ_KnownLive(subjectPrincipal), rv);
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "ShadowRoot.innerHTML setter"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));

  return true;
}

static const JSJitInfo innerHTML_getterinfo = {
  { get_innerHTML },
  { prototypes::id::ShadowRoot },
  { PrototypeTraits<prototypes::id::ShadowRoot>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNKNOWN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo innerHTML_setterinfo = {
  { (JSJitGetterOp)set_innerHTML },
  { prototypes::id::ShadowRoot },
  { PrototypeTraits<prototypes::id::ShadowRoot>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
importNodeAndAppendChildAt(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  BindingCallContext cx(cx_, "ShadowRoot.importNodeAndAppendChildAt");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "ShadowRoot", "importNodeAndAppendChildAt", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::ShadowRoot*>(void_self);
  if (!args.requireAtLeast(cx, "ShadowRoot.importNodeAndAppendChildAt", 2)) {
    return false;
  }
  NonNull<nsINode> arg0;
  if (args[0].isObject()) {
    {
      // Our JSContext should be in the right global to do unwrapping in.
      nsresult rv = UnwrapObject<prototypes::id::Node, nsINode>(args[0], arg0, cx);
      if (NS_FAILED(rv)) {
        cx.ThrowErrorMessage<MSG_DOES_NOT_IMPLEMENT_INTERFACE>("Argument 1", "Node");
        return false;
      }
    }
  } else {
    cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Argument 1");
    return false;
  }
  NonNull<nsINode> arg1;
  if (args[1].isObject()) {
    {
      // Our JSContext should be in the right global to do unwrapping in.
      nsresult rv = UnwrapObject<prototypes::id::Node, nsINode>(args[1], arg1, cx);
      if (NS_FAILED(rv)) {
        cx.ThrowErrorMessage<MSG_DOES_NOT_IMPLEMENT_INTERFACE>("Argument 2", "Node");
        return false;
      }
    }
  } else {
    cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Argument 2");
    return false;
  }
  bool arg2;
  if (args.hasDefined(2)) {
    if (!ValueToPrimitive<bool, eDefault>(cx, args[2], "Argument 3", &arg2)) {
      return false;
    }
  } else {
    arg2 = false;
  }
  Maybe<AutoCEReaction> ceReaction;
  DocGroup* docGroup = self->GetDocGroup();
  if (docGroup) {
    ceReaction.emplace(docGroup->CustomElementReactionsStack(), cx);
  }
  FastErrorResult rv;
  auto result(StrongOrRawPtr<nsINode>(MOZ_KnownLive(self)->ImportNodeAndAppendChildAt(MOZ_KnownLive(NonNullHelper(arg0)), MOZ_KnownLive(NonNullHelper(arg1)), arg2, rv)));
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "ShadowRoot.importNodeAndAppendChildAt"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (!GetOrCreateDOMReflector(cx, result, args.rval())) {
    MOZ_ASSERT(JS_IsExceptionPending(cx));
    return false;
  }
  return true;
}

static const JSJitInfo importNodeAndAppendChildAt_methodinfo = {
  { (JSJitGetterOp)importNodeAndAppendChildAt },
  { prototypes::id::ShadowRoot },
  { PrototypeTraits<prototypes::id::ShadowRoot>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_OBJECT,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
createElementAndAppendChildAt(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  BindingCallContext cx(cx_, "ShadowRoot.createElementAndAppendChildAt");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "ShadowRoot", "createElementAndAppendChildAt", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::ShadowRoot*>(void_self);
  if (!args.requireAtLeast(cx, "ShadowRoot.createElementAndAppendChildAt", 2)) {
    return false;
  }
  NonNull<nsINode> arg0;
  if (args[0].isObject()) {
    {
      // Our JSContext should be in the right global to do unwrapping in.
      nsresult rv = UnwrapObject<prototypes::id::Node, nsINode>(args[0], arg0, cx);
      if (NS_FAILED(rv)) {
        cx.ThrowErrorMessage<MSG_DOES_NOT_IMPLEMENT_INTERFACE>("Argument 1", "Node");
        return false;
      }
    }
  } else {
    cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Argument 1");
    return false;
  }
  binding_detail::FakeString<char16_t> arg1;
  if (!ConvertJSValueToString(cx, args[1], eStringify, eStringify, arg1)) {
    return false;
  }
  Maybe<AutoCEReaction> ceReaction;
  DocGroup* docGroup = self->GetDocGroup();
  if (docGroup) {
    ceReaction.emplace(docGroup->CustomElementReactionsStack(), cx);
  }
  FastErrorResult rv;
  auto result(StrongOrRawPtr<nsINode>(MOZ_KnownLive(self)->CreateElementAndAppendChildAt(MOZ_KnownLive(NonNullHelper(arg0)), NonNullHelper(Constify(arg1)), rv)));
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "ShadowRoot.createElementAndAppendChildAt"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (!GetOrCreateDOMReflector(cx, result, args.rval())) {
    MOZ_ASSERT(JS_IsExceptionPending(cx));
    return false;
  }
  return true;
}

static const JSJitInfo createElementAndAppendChildAt_methodinfo = {
  { (JSJitGetterOp)createElementAndAppendChildAt },
  { prototypes::id::ShadowRoot },
  { PrototypeTraits<prototypes::id::ShadowRoot>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_OBJECT,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
setIsUAWidget(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "ShadowRoot", "setIsUAWidget", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::ShadowRoot*>(void_self);
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->SetIsUAWidget())>, "Should be returning void here");
  MOZ_KnownLive(self)->SetIsUAWidget();
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setUndefined();
  return true;
}

static const JSJitInfo setIsUAWidget_methodinfo = {
  { (JSJitGetterOp)setIsUAWidget },
  { prototypes::id::ShadowRoot },
  { PrototypeTraits<prototypes::id::ShadowRoot>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  true,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
isUAWidget(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "ShadowRoot", "isUAWidget", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::ShadowRoot*>(void_self);
  bool result(MOZ_KnownLive(self)->IsUAWidget());
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setBoolean(result);
  return true;
}

static const JSJitInfo isUAWidget_methodinfo = {
  { (JSJitGetterOp)isUAWidget },
  { prototypes::id::ShadowRoot },
  { PrototypeTraits<prototypes::id::ShadowRoot>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_BOOLEAN,  /* returnType.  Not relevant for setters. */
  true,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
setHTML(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  BindingCallContext cx(cx_, "ShadowRoot.setHTML");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "ShadowRoot", "setHTML", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::ShadowRoot*>(void_self);
  if (!args.requireAtLeast(cx, "ShadowRoot.setHTML", 1)) {
    return false;
  }
  binding_detail::FakeString<char16_t> arg0;
  if (!ConvertJSValueToString(cx, args[0], eStringify, eStringify, arg0)) {
    return false;
  }
  binding_detail::FastSetHTMLOptions arg1;
  if (!arg1.Init(cx, (args.hasDefined(1)) ? args[1] : JS::NullHandleValue, "Argument 2", false)) {
    return false;
  }
  FastErrorResult rv;
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->SetHTML(NonNullHelper(Constify(arg0)), Constify(arg1), rv))>, "Should be returning void here");
  MOZ_KnownLive(self)->SetHTML(NonNullHelper(Constify(arg0)), Constify(arg1), rv);
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "ShadowRoot.setHTML"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setUndefined();
  return true;
}

static const JSJitInfo setHTML_methodinfo = {
  { (JSJitGetterOp)setHTML },
  { prototypes::id::ShadowRoot },
  { PrototypeTraits<prototypes::id::ShadowRoot>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
setHTMLUnsafe(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  BindingCallContext cx(cx_, "ShadowRoot.setHTMLUnsafe");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "ShadowRoot", "setHTMLUnsafe", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::ShadowRoot*>(void_self);
  if (!args.requireAtLeast(cx, "ShadowRoot.setHTMLUnsafe", 1)) {
    return false;
  }
  TrustedHTMLOrString arg0;
  if (!arg0.Init(cx, args[0], "Argument 1", false)) {
    return false;
  }
  binding_detail::FastSetHTMLUnsafeOptions arg1;
  if (!arg1.Init(cx, (args.hasDefined(1)) ? args[1] : JS::NullHandleValue, "Argument 2", false)) {
    return false;
  }
  FastErrorResult rv;
  nsIPrincipal* subjectPrincipal;
  {
    JS::Realm* realm = js::GetContextRealm(cx);
    MOZ_ASSERT(realm);
    JSPrincipals* principals = JS::GetRealmPrincipals(realm);
    nsIPrincipal* principal = nsJSPrincipals::get(principals);
    if (principal->IsSystemPrincipal()) {
    principal = nullptr;
  }

    subjectPrincipal = principal;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->SetHTMLUnsafe(Constify(arg0), Constify(arg1), MOZ_KnownLive(subjectPrincipal), rv))>, "Should be returning void here");
  MOZ_KnownLive(self)->SetHTMLUnsafe(Constify(arg0), Constify(arg1), MOZ_KnownLive(subjectPrincipal), rv);
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "ShadowRoot.setHTMLUnsafe"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setUndefined();
  return true;
}

static const JSJitInfo setHTMLUnsafe_methodinfo = {
  { (JSJitGetterOp)setHTMLUnsafe },
  { prototypes::id::ShadowRoot },
  { PrototypeTraits<prototypes::id::ShadowRoot>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
getHTML(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  BindingCallContext cx(cx_, "ShadowRoot.getHTML");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "ShadowRoot", "getHTML", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::ShadowRoot*>(void_self);
  binding_detail::FastGetHTMLOptions arg0;
  if (!arg0.Init(cx, (args.hasDefined(0)) ? args[0] : JS::NullHandleValue, "Argument 1", false)) {
    return false;
  }
  DOMString result;
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->GetHTML(Constify(arg0), result))>, "Should be returning void here");
  MOZ_KnownLive(self)->GetHTML(Constify(arg0), result);
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (!xpc::NonVoidStringToJsval(cx, result, args.rval())) {
    return false;
  }
  return true;
}

static const JSJitInfo getHTML_methodinfo = {
  { (JSJitGetterOp)getHTML },
  { prototypes::id::ShadowRoot },
  { PrototypeTraits<prototypes::id::ShadowRoot>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_STRING,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
elementFromPoint(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  BindingCallContext cx(cx_, "ShadowRoot.elementFromPoint");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "ShadowRoot", "elementFromPoint", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::ShadowRoot*>(void_self);
  if (!args.requireAtLeast(cx, "ShadowRoot.elementFromPoint", 2)) {
    return false;
  }
  float arg0;
  if (!ValueToPrimitive<float, eDefault>(cx, args[0], "Argument 1", &arg0)) {
    return false;
  } else if (!std::isfinite(arg0)) {
    cx.ThrowErrorMessage<MSG_NOT_FINITE>("Argument 1");
    return false;
  }
  float arg1;
  if (!ValueToPrimitive<float, eDefault>(cx, args[1], "Argument 2", &arg1)) {
    return false;
  } else if (!std::isfinite(arg1)) {
    cx.ThrowErrorMessage<MSG_NOT_FINITE>("Argument 2");
    return false;
  }
  auto result(StrongOrRawPtr<mozilla::dom::Element>(MOZ_KnownLive(self)->ElementFromPoint(arg0, arg1)));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (!result) {
    args.rval().setNull();
    return true;
  }
  if (!GetOrCreateDOMReflector(cx, result, args.rval())) {
    MOZ_ASSERT(JS_IsExceptionPending(cx));
    return false;
  }
  return true;
}

static const JSJitInfo elementFromPoint_methodinfo = {
  { (JSJitGetterOp)elementFromPoint },
  { prototypes::id::ShadowRoot },
  { PrototypeTraits<prototypes::id::ShadowRoot>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNKNOWN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
elementsFromPoint(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  BindingCallContext cx(cx_, "ShadowRoot.elementsFromPoint");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "ShadowRoot", "elementsFromPoint", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::ShadowRoot*>(void_self);
  if (!args.requireAtLeast(cx, "ShadowRoot.elementsFromPoint", 2)) {
    return false;
  }
  float arg0;
  if (!ValueToPrimitive<float, eDefault>(cx, args[0], "Argument 1", &arg0)) {
    return false;
  } else if (!std::isfinite(arg0)) {
    cx.ThrowErrorMessage<MSG_NOT_FINITE>("Argument 1");
    return false;
  }
  float arg1;
  if (!ValueToPrimitive<float, eDefault>(cx, args[1], "Argument 2", &arg1)) {
    return false;
  } else if (!std::isfinite(arg1)) {
    cx.ThrowErrorMessage<MSG_NOT_FINITE>("Argument 2");
    return false;
  }
  nsTArray<StrongPtrForMember<mozilla::dom::Element>> result;
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->ElementsFromPoint(arg0, arg1, result))>, "Should be returning void here");
  MOZ_KnownLive(self)->ElementsFromPoint(arg0, arg1, result);
  MOZ_ASSERT(!JS_IsExceptionPending(cx));

  uint32_t length = result.Length();
  JS::Rooted<JSObject*> returnArray(cx, JS::NewArrayObject(cx, length));
  if (!returnArray) {
    return false;
  }
  // Scope for 'tmp'
  {
    JS::Rooted<JS::Value> tmp(cx);
    for (uint32_t sequenceIdx0 = 0; sequenceIdx0 < length; ++sequenceIdx0) {
      // Control block to let us common up the JS_DefineElement calls when there
      // are different ways to succeed at wrapping the object.
      do {
        if (!GetOrCreateDOMReflector(cx, result[sequenceIdx0], &tmp)) {
          MOZ_ASSERT(JS_IsExceptionPending(cx));
          return false;
        }
        break;
      } while (false);
      if (!JS_DefineElement(cx, returnArray, sequenceIdx0, tmp,
                            JSPROP_ENUMERATE)) {
        return false;
      }
    }
  }
  args.rval().setObject(*returnArray);
  return true;
}

static const JSJitInfo elementsFromPoint_methodinfo = {
  { (JSJitGetterOp)elementsFromPoint },
  { prototypes::id::ShadowRoot },
  { PrototypeTraits<prototypes::id::ShadowRoot>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_OBJECT,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
nodeFromPoint(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  BindingCallContext cx(cx_, "ShadowRoot.nodeFromPoint");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "ShadowRoot", "nodeFromPoint", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::ShadowRoot*>(void_self);
  if (!args.requireAtLeast(cx, "ShadowRoot.nodeFromPoint", 2)) {
    return false;
  }
  float arg0;
  if (!ValueToPrimitive<float, eDefault>(cx, args[0], "Argument 1", &arg0)) {
    return false;
  } else if (!std::isfinite(arg0)) {
    cx.ThrowErrorMessage<MSG_NOT_FINITE>("Argument 1");
    return false;
  }
  float arg1;
  if (!ValueToPrimitive<float, eDefault>(cx, args[1], "Argument 2", &arg1)) {
    return false;
  } else if (!std::isfinite(arg1)) {
    cx.ThrowErrorMessage<MSG_NOT_FINITE>("Argument 2");
    return false;
  }
  auto result(StrongOrRawPtr<nsINode>(MOZ_KnownLive(self)->NodeFromPoint(arg0, arg1)));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (!result) {
    args.rval().setNull();
    return true;
  }
  if (!GetOrCreateDOMReflector(cx, result, args.rval())) {
    MOZ_ASSERT(JS_IsExceptionPending(cx));
    return false;
  }
  return true;
}

static const JSJitInfo nodeFromPoint_methodinfo = {
  { (JSJitGetterOp)nodeFromPoint },
  { prototypes::id::ShadowRoot },
  { PrototypeTraits<prototypes::id::ShadowRoot>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNKNOWN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
nodesFromPoint(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  BindingCallContext cx(cx_, "ShadowRoot.nodesFromPoint");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "ShadowRoot", "nodesFromPoint", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::ShadowRoot*>(void_self);
  if (!args.requireAtLeast(cx, "ShadowRoot.nodesFromPoint", 2)) {
    return false;
  }
  float arg0;
  if (!ValueToPrimitive<float, eDefault>(cx, args[0], "Argument 1", &arg0)) {
    return false;
  } else if (!std::isfinite(arg0)) {
    cx.ThrowErrorMessage<MSG_NOT_FINITE>("Argument 1");
    return false;
  }
  float arg1;
  if (!ValueToPrimitive<float, eDefault>(cx, args[1], "Argument 2", &arg1)) {
    return false;
  } else if (!std::isfinite(arg1)) {
    cx.ThrowErrorMessage<MSG_NOT_FINITE>("Argument 2");
    return false;
  }
  nsTArray<StrongPtrForMember<nsINode>> result;
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->NodesFromPoint(arg0, arg1, result))>, "Should be returning void here");
  MOZ_KnownLive(self)->NodesFromPoint(arg0, arg1, result);
  MOZ_ASSERT(!JS_IsExceptionPending(cx));

  uint32_t length = result.Length();
  JS::Rooted<JSObject*> returnArray(cx, JS::NewArrayObject(cx, length));
  if (!returnArray) {
    return false;
  }
  // Scope for 'tmp'
  {
    JS::Rooted<JS::Value> tmp(cx);
    for (uint32_t sequenceIdx0 = 0; sequenceIdx0 < length; ++sequenceIdx0) {
      // Control block to let us common up the JS_DefineElement calls when there
      // are different ways to succeed at wrapping the object.
      do {
        if (!GetOrCreateDOMReflector(cx, result[sequenceIdx0], &tmp)) {
          MOZ_ASSERT(JS_IsExceptionPending(cx));
          return false;
        }
        break;
      } while (false);
      if (!JS_DefineElement(cx, returnArray, sequenceIdx0, tmp,
                            JSPROP_ENUMERATE)) {
        return false;
      }
    }
  }
  args.rval().setObject(*returnArray);
  return true;
}

static const JSJitInfo nodesFromPoint_methodinfo = {
  { (JSJitGetterOp)nodesFromPoint },
  { prototypes::id::ShadowRoot },
  { PrototypeTraits<prototypes::id::ShadowRoot>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_OBJECT,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_activeElement(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "ShadowRoot", "activeElement", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::ShadowRoot*>(void_self);
  auto result(StrongOrRawPtr<mozilla::dom::Element>(MOZ_KnownLive(self)->GetActiveElement()));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (!result) {
    args.rval().setNull();
    return true;
  }
  if (!GetOrCreateDOMReflector(cx, result, args.rval())) {
    MOZ_ASSERT(JS_IsExceptionPending(cx));
    return false;
  }
  return true;
}

static const JSJitInfo activeElement_getterinfo = {
  { get_activeElement },
  { prototypes::id::ShadowRoot },
  { PrototypeTraits<prototypes::id::ShadowRoot>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNKNOWN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_styleSheets(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "ShadowRoot", "styleSheets", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::ShadowRoot*>(void_self);
  auto result(StrongOrRawPtr<mozilla::dom::StyleSheetList>(MOZ_KnownLive(self)->StyleSheets()));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (!GetOrCreateDOMReflector(cx, result, args.rval())) {
    MOZ_ASSERT(JS_IsExceptionPending(cx));
    return false;
  }
  return true;
}

static const JSJitInfo styleSheets_getterinfo = {
  { get_styleSheets },
  { prototypes::id::ShadowRoot },
  { PrototypeTraits<prototypes::id::ShadowRoot>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_OBJECT,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_pointerLockElement(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "ShadowRoot", "pointerLockElement", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::ShadowRoot*>(void_self);
  auto result(StrongOrRawPtr<mozilla::dom::Element>(MOZ_KnownLive(self)->GetPointerLockElement()));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (!result) {
    args.rval().setNull();
    return true;
  }
  if (!GetOrCreateDOMReflector(cx, result, args.rval())) {
    MOZ_ASSERT(JS_IsExceptionPending(cx));
    return false;
  }
  return true;
}

static const JSJitInfo pointerLockElement_getterinfo = {
  { get_pointerLockElement },
  { prototypes::id::ShadowRoot },
  { PrototypeTraits<prototypes::id::ShadowRoot>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNKNOWN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_fullscreenElement(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "ShadowRoot", "fullscreenElement", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::ShadowRoot*>(void_self);
  auto result(StrongOrRawPtr<mozilla::dom::Element>(MOZ_KnownLive(self)->GetFullscreenElement()));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (!result) {
    args.rval().setNull();
    return true;
  }
  if (!GetOrCreateDOMReflector(cx, result, args.rval())) {
    MOZ_ASSERT(JS_IsExceptionPending(cx));
    return false;
  }
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
set_fullscreenElement(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "ShadowRoot", "fullscreenElement", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_SETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  DeprecationWarning(cx, obj, DeprecatedOperations::eLenientSetter);
  return true;
}

static const JSJitInfo fullscreenElement_getterinfo = {
  { get_fullscreenElement },
  { prototypes::id::ShadowRoot },
  { PrototypeTraits<prototypes::id::ShadowRoot>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNKNOWN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static const JSJitInfo fullscreenElement_setterinfo = {
  { (JSJitGetterOp)set_fullscreenElement },
  { prototypes::id::ShadowRoot },
  { PrototypeTraits<prototypes::id::ShadowRoot>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_mozFullScreenElement(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "ShadowRoot", "mozFullScreenElement", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::ShadowRoot*>(void_self);
  auto result(StrongOrRawPtr<mozilla::dom::Element>(MOZ_KnownLive(self)->GetFullscreenElement()));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (!result) {
    args.rval().setNull();
    return true;
  }
  if (!GetOrCreateDOMReflector(cx, result, args.rval())) {
    MOZ_ASSERT(JS_IsExceptionPending(cx));
    return false;
  }
  return true;
}

static const JSJitInfo mozFullScreenElement_getterinfo = {
  { get_mozFullScreenElement },
  { prototypes::id::ShadowRoot },
  { PrototypeTraits<prototypes::id::ShadowRoot>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNKNOWN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
getAnimations(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "ShadowRoot", "getAnimations", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::ShadowRoot*>(void_self);
  nsTArray<StrongPtrForMember<mozilla::dom::Animation>> result;
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->GetAnimations(result))>, "Should be returning void here");
  MOZ_KnownLive(self)->GetAnimations(result);
  MOZ_ASSERT(!JS_IsExceptionPending(cx));

  uint32_t length = result.Length();
  JS::Rooted<JSObject*> returnArray(cx, JS::NewArrayObject(cx, length));
  if (!returnArray) {
    return false;
  }
  // Scope for 'tmp'
  {
    JS::Rooted<JS::Value> tmp(cx);
    for (uint32_t sequenceIdx0 = 0; sequenceIdx0 < length; ++sequenceIdx0) {
      // Control block to let us common up the JS_DefineElement calls when there
      // are different ways to succeed at wrapping the object.
      do {
        if (!GetOrCreateDOMReflector(cx, result[sequenceIdx0], &tmp)) {
          MOZ_ASSERT(JS_IsExceptionPending(cx));
          return false;
        }
        break;
      } while (false);
      if (!JS_DefineElement(cx, returnArray, sequenceIdx0, tmp,
                            JSPROP_ENUMERATE)) {
        return false;
      }
    }
  }
  args.rval().setObject(*returnArray);
  return true;
}

static const JSJitInfo getAnimations_methodinfo = {
  { (JSJitGetterOp)getAnimations },
  { prototypes::id::ShadowRoot },
  { PrototypeTraits<prototypes::id::ShadowRoot>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_OBJECT,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

namespace AdoptedStyleSheets_Binding {
class ObservableArrayProxyHandler : public mozilla::dom::ObservableArrayProxyHandler
{
protected:
  bool
  OnDeleteItem(JSContext* aCx, JS::Handle<JSObject*> aProxy, JS::Handle<JS::Value> aValue, uint32_t aIndex) const override;

  bool
  SetIndexedValue(JSContext* aCx, JS::Handle<JSObject*> aProxy, JS::Handle<JSObject*> aBackingList, uint32_t aIndex, JS::Handle<JS::Value> aValue, JS::ObjectOpResult& aResult) const override;

public:
  static const ObservableArrayProxyHandler*
  getInstance();
};

bool
ObservableArrayProxyHandler::OnDeleteItem(JSContext* aCx, JS::Handle<JSObject*> aProxy, JS::Handle<JS::Value> aValue, uint32_t aIndex) const
{
  MOZ_ASSERT(IsObservableArrayProxy(aProxy));

  BindingCallContext cx(aCx, "ObservableArray OnDeleteItem");
  NonNull<mozilla::StyleSheet> decl;
  if (aValue.isObject()) {
    {
      // Our JSContext should be in the right global to do unwrapping in.
      nsresult rv = UnwrapObject<prototypes::id::CSSStyleSheet, mozilla::StyleSheet>(aValue, decl, cx);
      if (NS_FAILED(rv)) {
        cx.ThrowErrorMessage<MSG_DOES_NOT_IMPLEMENT_INTERFACE>("Element in ObservableArray backing list", "CSSStyleSheet");
        MOZ_ASSERT_UNREACHABLE("The item in ObservableArray backing list is not CSSStyleSheet (Wrapper)?");
        return false;
      }
    }
  } else {
    cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Element in ObservableArray backing list");
    MOZ_ASSERT_UNREACHABLE("The item in ObservableArray backing list is not CSSStyleSheet (Wrapper)?");
    return false;
  }

  JS::Value val = js::GetProxyReservedSlot(aProxy, OBSERVABLE_ARRAY_DOM_INTERFACE_SLOT);
  auto* interface = static_cast<mozilla::dom::ShadowRoot*>(val.toPrivate());
  MOZ_ASSERT(interface);

  ErrorResult rv;
  MOZ_KnownLive(interface)->OnDeleteAdoptedStyleSheets(decl, aIndex, rv);
  return !rv.MaybeSetPendingException(cx);
}

bool
ObservableArrayProxyHandler::SetIndexedValue(JSContext* aCx, JS::Handle<JSObject*> aProxy, JS::Handle<JSObject*> aBackingList, uint32_t aIndex, JS::Handle<JS::Value> aValue, JS::ObjectOpResult& aResult) const
{
  MOZ_ASSERT(IsObservableArrayProxy(aProxy));
  uint32_t oldLen;
  if (!JS::GetArrayLength(aCx, aBackingList, &oldLen)) {
    return false;
  }

  if (aIndex > oldLen) {
    return aResult.failBadIndex();
  }

  BindingCallContext cx(aCx, "ObservableArray SetIndexedValue");
  NonNull<mozilla::StyleSheet> decl;
  if (aValue.isObject()) {
    {
      // Our JSContext should be in the right global to do unwrapping in.
      nsresult rv = UnwrapObject<prototypes::id::CSSStyleSheet, mozilla::StyleSheet>(aValue, decl, cx);
      if (NS_FAILED(rv)) {
        cx.ThrowErrorMessage<MSG_DOES_NOT_IMPLEMENT_INTERFACE>("Element in ObservableArray backing list", "CSSStyleSheet");
        return false;
      }
    }
  } else {
    cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Element in ObservableArray backing list");
    return false;
  }

  if (aIndex < oldLen) {
    JS::Rooted<JS::Value> value(aCx);
    if (!JS_GetElement(aCx, aBackingList, aIndex, &value)) {
      return false;
    }

    if (!OnDeleteItem(aCx, aProxy, value, aIndex)) {
      return false;
    }
  }

  JS::Value val = js::GetProxyReservedSlot(aProxy, OBSERVABLE_ARRAY_DOM_INTERFACE_SLOT);
  auto* interface = static_cast<mozilla::dom::ShadowRoot*>(val.toPrivate());
  MOZ_ASSERT(interface);

  ErrorResult rv;
  MOZ_KnownLive(interface)->OnSetAdoptedStyleSheets(decl, aIndex, rv);
  if (rv.MaybeSetPendingException(cx)) {
    return false;
  }

  if (!JS_SetElement(aCx, aBackingList, aIndex, aValue)) {
    return false;
  }

  return aResult.succeed();
}

const ObservableArrayProxyHandler*
ObservableArrayProxyHandler::getInstance()
{
  static const ObservableArrayProxyHandler instance;
  return &instance;
}
} // namespace AdoptedStyleSheets_Binding

namespace AdoptedStyleSheetsHelpers {
already_AddRefed<StyleSheet>
ElementAt(mozilla::dom::ShadowRoot* self, uint32_t aIndex, ErrorResult& aRv)
{
  MOZ_ASSERT(self);
  AutoJSAPI jsapi;
  jsapi.Init();
  JSContext* cx = jsapi.cx();
  // It's safe to use UnprivilegedJunkScopeOrWorkerGlobal here because
  // all we want is to wrap into _some_ scope and then unwrap to find
  // the reflector, and wrapping has no side-effects.
  JSObject* scope = UnprivilegedJunkScopeOrWorkerGlobal(fallible);
  if (!scope) {
    aRv.Throw(NS_ERROR_UNEXPECTED);
    return nullptr;
  }
  JSAutoRealm tempRealm(cx, scope);
  JS::Rooted<JS::Value> v(cx);
  if(!ToJSValue(cx, self, &v)) {
    aRv.Throw(NS_ERROR_UNEXPECTED);
    return nullptr;
  }
  // This is a reflector, but due to trying to name things
  // similarly across method generators, it's called obj here.
  JS::Rooted<JSObject*> obj(cx);
  obj = js::UncheckedUnwrap(&v.toObject(), /* stopAtWindowProxy = */ false);
  JSAutoRealm reflectorRealm(cx, obj);

  JS::Rooted<JSObject*> backingObj(cx);
  bool created = false;
  if (!GetObservableArrayBackingObject(cx, obj, (DOM_INSTANCE_RESERVED_SLOTS + 0),
          &backingObj, &created, AdoptedStyleSheets_Binding::ObservableArrayProxyHandler::getInstance(),
          self)) {
    aRv.Throw(NS_ERROR_UNEXPECTED);
    return nullptr;
  }
  if (created) {
    PreserveWrapper(self);
  }
  JS::Rooted<JS::Value> result(cx);
  aRv.MightThrowJSException();
  if (!JS_GetElement(cx, backingObj, aIndex, &result)) {
    aRv.StealExceptionFromJSContext(cx);
    return nullptr;
  }
  if (result.isUndefined()) {
    aRv.Throw(NS_ERROR_NOT_AVAILABLE);
    return nullptr;
  }
  RefPtr<mozilla::StyleSheet> rvalDecl;
  static_assert(IsRefcounted<mozilla::StyleSheet>::value, "We can only store refcounted classes.");
  {
    // Our JSContext should be in the right global to do unwrapping in.
    nsresult rv = UnwrapObject<prototypes::id::CSSStyleSheet, mozilla::StyleSheet>(result, rvalDecl, cx);
    if (NS_FAILED(rv)) {
      aRv.Throw(NS_ERROR_UNEXPECTED);
      return nullptr;
    }
  }
  return rvalDecl.forget();
}

void
ReplaceElementAt(mozilla::dom::ShadowRoot* self, uint32_t aIndex, StyleSheet& aValue, ErrorResult& aRv)
{
  MOZ_ASSERT(self);
  AutoJSAPI jsapi;
  jsapi.Init();
  JSContext* cx = jsapi.cx();
  // It's safe to use UnprivilegedJunkScopeOrWorkerGlobal here because
  // all we want is to wrap into _some_ scope and then unwrap to find
  // the reflector, and wrapping has no side-effects.
  JSObject* scope = UnprivilegedJunkScopeOrWorkerGlobal(fallible);
  if (!scope) {
    aRv.Throw(NS_ERROR_UNEXPECTED);
    return;
  }
  JSAutoRealm tempRealm(cx, scope);
  JS::Rooted<JS::Value> v(cx);
  if(!ToJSValue(cx, self, &v)) {
    aRv.Throw(NS_ERROR_UNEXPECTED);
    return;
  }
  // This is a reflector, but due to trying to name things
  // similarly across method generators, it's called obj here.
  JS::Rooted<JSObject*> obj(cx);
  obj = js::UncheckedUnwrap(&v.toObject(), /* stopAtWindowProxy = */ false);
  JSAutoRealm reflectorRealm(cx, obj);
  JS::RootedVector<JS::Value> argv(cx);
  if (!argv.resize(1)) {
    aRv.Throw(NS_ERROR_UNEXPECTED);
    return;
  }
  do {
    if (!GetOrCreateDOMReflector(cx, aValue, argv[0])) {
      MOZ_ASSERT(JS_IsExceptionPending(cx));
      aRv.Throw(NS_ERROR_UNEXPECTED);
      return;
    }
    break;
  } while (false);

  JS::Rooted<JSObject*> backingObj(cx);
  bool created = false;
  if (!GetObservableArrayBackingObject(cx, obj, (DOM_INSTANCE_RESERVED_SLOTS + 0),
          &backingObj, &created, AdoptedStyleSheets_Binding::ObservableArrayProxyHandler::getInstance(),
          self)) {
    aRv.Throw(NS_ERROR_UNEXPECTED);
    return;
  }
  if (created) {
    PreserveWrapper(self);
  }
  uint32_t length;
  aRv.MightThrowJSException();
  if (!JS::GetArrayLength(cx, backingObj, &length)) {
    aRv.StealExceptionFromJSContext(cx);
    return;
  }
  if (aIndex > length) {
    aRv.ThrowRangeError("Invalid index");
    return;
  }
  aRv.MightThrowJSException();
  if (!JS_SetElement(cx, backingObj, aIndex, argv[0])) {
    aRv.StealExceptionFromJSContext(cx);
    return;
  }
}

void
AppendElement(mozilla::dom::ShadowRoot* self, StyleSheet& aValue, ErrorResult& aRv)
{
  MOZ_ASSERT(self);
  AutoJSAPI jsapi;
  jsapi.Init();
  JSContext* cx = jsapi.cx();
  // It's safe to use UnprivilegedJunkScopeOrWorkerGlobal here because
  // all we want is to wrap into _some_ scope and then unwrap to find
  // the reflector, and wrapping has no side-effects.
  JSObject* scope = UnprivilegedJunkScopeOrWorkerGlobal(fallible);
  if (!scope) {
    aRv.Throw(NS_ERROR_UNEXPECTED);
    return;
  }
  JSAutoRealm tempRealm(cx, scope);
  JS::Rooted<JS::Value> v(cx);
  if(!ToJSValue(cx, self, &v)) {
    aRv.Throw(NS_ERROR_UNEXPECTED);
    return;
  }
  // This is a reflector, but due to trying to name things
  // similarly across method generators, it's called obj here.
  JS::Rooted<JSObject*> obj(cx);
  obj = js::UncheckedUnwrap(&v.toObject(), /* stopAtWindowProxy = */ false);
  JSAutoRealm reflectorRealm(cx, obj);
  JS::RootedVector<JS::Value> argv(cx);
  if (!argv.resize(1)) {
    aRv.Throw(NS_ERROR_UNEXPECTED);
    return;
  }
  do {
    if (!GetOrCreateDOMReflector(cx, aValue, argv[0])) {
      MOZ_ASSERT(JS_IsExceptionPending(cx));
      aRv.Throw(NS_ERROR_UNEXPECTED);
      return;
    }
    break;
  } while (false);

  JS::Rooted<JSObject*> backingObj(cx);
  bool created = false;
  if (!GetObservableArrayBackingObject(cx, obj, (DOM_INSTANCE_RESERVED_SLOTS + 0),
          &backingObj, &created, AdoptedStyleSheets_Binding::ObservableArrayProxyHandler::getInstance(),
          self)) {
    aRv.Throw(NS_ERROR_UNEXPECTED);
    return;
  }
  if (created) {
    PreserveWrapper(self);
  }
  uint32_t length;
  aRv.MightThrowJSException();
  if (!JS::GetArrayLength(cx, backingObj, &length)) {
    aRv.StealExceptionFromJSContext(cx);
    return;
  }
  aRv.MightThrowJSException();
  if (!JS_SetElement(cx, backingObj, length, argv[0])) {
    aRv.StealExceptionFromJSContext(cx);
    return;
  }
}

void
RemoveLastElement(mozilla::dom::ShadowRoot* self, ErrorResult& aRv)
{
  MOZ_ASSERT(self);
  AutoJSAPI jsapi;
  jsapi.Init();
  JSContext* cx = jsapi.cx();
  // It's safe to use UnprivilegedJunkScopeOrWorkerGlobal here because
  // all we want is to wrap into _some_ scope and then unwrap to find
  // the reflector, and wrapping has no side-effects.
  JSObject* scope = UnprivilegedJunkScopeOrWorkerGlobal(fallible);
  if (!scope) {
    aRv.Throw(NS_ERROR_UNEXPECTED);
    return;
  }
  JSAutoRealm tempRealm(cx, scope);
  JS::Rooted<JS::Value> v(cx);
  if(!ToJSValue(cx, self, &v)) {
    aRv.Throw(NS_ERROR_UNEXPECTED);
    return;
  }
  // This is a reflector, but due to trying to name things
  // similarly across method generators, it's called obj here.
  JS::Rooted<JSObject*> obj(cx);
  obj = js::UncheckedUnwrap(&v.toObject(), /* stopAtWindowProxy = */ false);
  JSAutoRealm reflectorRealm(cx, obj);

  JS::Rooted<JSObject*> backingObj(cx);
  bool created = false;
  if (!GetObservableArrayBackingObject(cx, obj, (DOM_INSTANCE_RESERVED_SLOTS + 0),
          &backingObj, &created, AdoptedStyleSheets_Binding::ObservableArrayProxyHandler::getInstance(),
          self)) {
    aRv.Throw(NS_ERROR_UNEXPECTED);
    return;
  }
  if (created) {
    PreserveWrapper(self);
  }
  uint32_t length;
  aRv.MightThrowJSException();
  if (!JS::GetArrayLength(cx, backingObj, &length)) {
    aRv.StealExceptionFromJSContext(cx);
    return;
  }
  if (length == 0) {
    aRv.Throw(NS_ERROR_NOT_AVAILABLE);
    return;
  }
  aRv.MightThrowJSException();
  if (!JS::SetArrayLength(cx, backingObj, length - 1)) {
    aRv.StealExceptionFromJSContext(cx);
    return;
  }
}

uint32_t
Length(mozilla::dom::ShadowRoot* self, ErrorResult& aRv)
{
  MOZ_ASSERT(self);
  AutoJSAPI jsapi;
  jsapi.Init();
  JSContext* cx = jsapi.cx();
  // It's safe to use UnprivilegedJunkScopeOrWorkerGlobal here because
  // all we want is to wrap into _some_ scope and then unwrap to find
  // the reflector, and wrapping has no side-effects.
  JSObject* scope = UnprivilegedJunkScopeOrWorkerGlobal(fallible);
  if (!scope) {
    aRv.Throw(NS_ERROR_UNEXPECTED);
    return uint32_t(0);
  }
  JSAutoRealm tempRealm(cx, scope);
  JS::Rooted<JS::Value> v(cx);
  if(!ToJSValue(cx, self, &v)) {
    aRv.Throw(NS_ERROR_UNEXPECTED);
    return uint32_t(0);
  }
  // This is a reflector, but due to trying to name things
  // similarly across method generators, it's called obj here.
  JS::Rooted<JSObject*> obj(cx);
  obj = js::UncheckedUnwrap(&v.toObject(), /* stopAtWindowProxy = */ false);
  JSAutoRealm reflectorRealm(cx, obj);

  JS::Rooted<JSObject*> backingObj(cx);
  bool created = false;
  if (!GetObservableArrayBackingObject(cx, obj, (DOM_INSTANCE_RESERVED_SLOTS + 0),
          &backingObj, &created, AdoptedStyleSheets_Binding::ObservableArrayProxyHandler::getInstance(),
          self)) {
    aRv.Throw(NS_ERROR_UNEXPECTED);
    return uint32_t(0);
  }
  if (created) {
    PreserveWrapper(self);
  }
  uint32_t retVal;
  aRv.MightThrowJSException();
  if (!JS::GetArrayLength(cx, backingObj, &retVal)) {
    aRv.StealExceptionFromJSContext(cx);
    return uint32_t(0);
  }
  return retVal;
}
} // namespace AdoptedStyleSheetsHelpers

MOZ_CAN_RUN_SCRIPT static bool
get_adoptedStyleSheets(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "ShadowRoot", "adoptedStyleSheets", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::ShadowRoot*>(void_self);
  JS::Rooted<JSObject*> backingObj(cx);
  bool created = false;
  if (!GetObservableArrayBackingObject(cx, obj, (DOM_INSTANCE_RESERVED_SLOTS + 0),
          &backingObj, &created, AdoptedStyleSheets_Binding::ObservableArrayProxyHandler::getInstance(),
          self)) {
    return false;
  }
  if (created) {
    PreserveWrapper(self);
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setObject(*backingObj);
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
set_adoptedStyleSheets(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, JSJitSetterCallArgs args)
{
  BindingCallContext cx(cx_, "ShadowRoot.adoptedStyleSheets setter");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "ShadowRoot", "adoptedStyleSheets", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_SETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::ShadowRoot*>(void_self);
  binding_detail::AutoSequence<OwningNonNull<mozilla::StyleSheet>> arg0;
  if (args[0].isObject()) {
    JS::ForOfIterator iter(cx);
    if (!iter.init(args[0], JS::ForOfIterator::AllowNonIterable)) {
      return false;
    }
    if (!iter.valueIsIterable()) {
      cx.ThrowErrorMessage<MSG_CONVERSION_ERROR>("Value being assigned", "observable array");
      return false;
    }
    binding_detail::AutoSequence<OwningNonNull<mozilla::StyleSheet>> &arr = arg0;
    JS::Rooted<JS::Value> temp(cx);
    while (true) {
      bool done;
      if (!iter.next(&temp, &done)) {
        return false;
      }
      if (done) {
        break;
      }
      OwningNonNull<mozilla::StyleSheet>* slotPtr = arr.AppendElement(mozilla::fallible);
      if (!slotPtr) {
        JS_ReportOutOfMemory(cx);
        return false;
      }
      OwningNonNull<mozilla::StyleSheet>& slot = *slotPtr;
      if (temp.isObject()) {
        static_assert(IsRefcounted<mozilla::StyleSheet>::value, "We can only store refcounted classes.");
        {
          // Our JSContext should be in the right global to do unwrapping in.
          nsresult rv = UnwrapObject<prototypes::id::CSSStyleSheet, mozilla::StyleSheet>(&temp, slot, cx);
          if (NS_FAILED(rv)) {
            cx.ThrowErrorMessage<MSG_DOES_NOT_IMPLEMENT_INTERFACE>("Element of value being assigned", "CSSStyleSheet");
            return false;
          }
        }
      } else {
        cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Element of value being assigned");
        return false;
      }
    }
  } else {
    cx.ThrowErrorMessage<MSG_CONVERSION_ERROR>("Value being assigned", "observable array");
    return false;
  }
  if (xpc::WrapperFactory::IsXrayWrapper(obj)) {
    JS_ReportErrorASCII(cx, "Accessing from Xray wrapper is not supported.");
    return false;
  }

  JS::Rooted<JSObject*> backingObj(cx);
  bool created = false;
  if (!GetObservableArrayBackingObject(cx, obj, (DOM_INSTANCE_RESERVED_SLOTS + 0),
          &backingObj, &created, AdoptedStyleSheets_Binding::ObservableArrayProxyHandler::getInstance(),
          self)) {
    return false;
  }
  if (created) {
    PreserveWrapper(self);
  }

  const ObservableArrayProxyHandler* handler = GetObservableArrayProxyHandler(backingObj);
  if (!handler->SetLength(cx, backingObj, 0)) {
    return false;
  }

  JS::Rooted<JS::Value> val(cx);
  for (size_t i = 0; i < arg0.Length(); i++) {
    if (!GetOrCreateDOMReflector(cx, arg0.ElementAt(i), &val)) {
      MOZ_ASSERT(JS_IsExceptionPending(cx));
      return false;
    }
    if (!JS_SetElement(cx, backingObj, i, val)) {
      return false;
    }
  }

  return true;
}

static const JSJitInfo adoptedStyleSheets_getterinfo = {
  { get_adoptedStyleSheets },
  { prototypes::id::ShadowRoot },
  { PrototypeTraits<prototypes::id::ShadowRoot>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_OBJECT,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  true, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  (DOM_INSTANCE_RESERVED_SLOTS + 0)   /* Reserved slot index, if we're stored in a slot, else 0. */
};
static_assert((DOM_INSTANCE_RESERVED_SLOTS + 0) <= JSJitInfo::maxSlotIndex, "We won't fit");
static_assert((DOM_INSTANCE_RESERVED_SLOTS + 0) < 2, "There is no slot for us");
static const JSJitInfo adoptedStyleSheets_setterinfo = {
  { (JSJitGetterOp)set_adoptedStyleSheets },
  { prototypes::id::ShadowRoot },
  { PrototypeTraits<prototypes::id::ShadowRoot>::Depth },
  JSJitInfo::Setter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

static void
_finalize(JS::GCContext* gcx, JSObject* obj)
{
  mozilla::dom::ShadowRoot* self = UnwrapPossiblyNotInitializedDOMObject<mozilla::dom::ShadowRoot>(obj);
  if (self) {
    JS::SetReservedSlot(obj, DOM_OBJECT_SLOT, JS::UndefinedValue());
    {
      JS::Value val = JS::GetReservedSlot(obj, (DOM_INSTANCE_RESERVED_SLOTS + 0));
      if (!val.isUndefined()) {
        JSObject* obj = &val.toObject();
        js::SetProxyReservedSlot(obj, OBSERVABLE_ARRAY_DOM_INTERFACE_SLOT, JS::UndefinedValue());
      }
    }
    ClearWrapper(self, self, obj);
    if (size_t mallocBytes = BindingJSObjectMallocBytes(self)) {
      JS::RemoveAssociatedMemory(obj, mallocBytes,
                                 JS::MemoryUse::DOMBinding);
    }
    AddForDeferredFinalization<mozilla::dom::ShadowRoot>(self);
  }
}

MOZ_GLOBINIT static const JSFunctionSpec sMethods_specs[] = {
  JS_FNSPEC("getElementById", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&getElementById_methodinfo), 1, JSPROP_ENUMERATE, nullptr),
  JS_FS_END,
  JS_FNSPEC("importNodeAndAppendChildAt", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&importNodeAndAppendChildAt_methodinfo), 2, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("createElementAndAppendChildAt", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&createElementAndAppendChildAt_methodinfo), 2, JSPROP_ENUMERATE, nullptr),
  JS_FS_END,
  JS_FNSPEC("setHTML", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&setHTML_methodinfo), 1, JSPROP_ENUMERATE, nullptr),
  JS_FS_END,
  JS_FNSPEC("setHTMLUnsafe", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&setHTMLUnsafe_methodinfo), 1, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("getHTML", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&getHTML_methodinfo), 0, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("elementFromPoint", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&elementFromPoint_methodinfo), 2, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("elementsFromPoint", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&elementsFromPoint_methodinfo), 2, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("getAnimations", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&getAnimations_methodinfo), 0, JSPROP_ENUMERATE, nullptr),
  JS_FS_END
};

static const PrefableDisablers sMethods_disablers2 = {
  WebIDLPrefIndex::NoPref, 0, false, OriginTrial(0), &IsChromeOrUAWidget
};

static const PrefableDisablers sMethods_disablers5 = {
  WebIDLPrefIndex::dom_security_sanitizer_enabled, 0, false, OriginTrial(0), nullptr
};

static const Prefable<const JSFunctionSpec> sMethods[] = {
  { nullptr, &sMethods_specs[0] },
  { &sMethods_disablers2, &sMethods_specs[2] },
  { &sMethods_disablers5, &sMethods_specs[5] },
  { nullptr, &sMethods_specs[7] },
  { nullptr, nullptr }
};

static_assert(4 <= 1ull << NUM_BITS_PROPERTY_INFO_PREF_INDEX,
    "We have a prefable index that is >= (1 << NUM_BITS_PROPERTY_INFO_PREF_INDEX)");
static_assert(5 <= 1ull << NUM_BITS_PROPERTY_INFO_SPEC_INDEX,
    "We have a spec index that is >= (1 << NUM_BITS_PROPERTY_INFO_SPEC_INDEX)");

MOZ_GLOBINIT static const JSFunctionSpec sChromeMethods_specs[] = {
  JS_FNSPEC("setIsUAWidget", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&setIsUAWidget_methodinfo), 0, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("isUAWidget", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&isUAWidget_methodinfo), 0, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("nodeFromPoint", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&nodeFromPoint_methodinfo), 2, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("nodesFromPoint", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&nodesFromPoint_methodinfo), 2, JSPROP_ENUMERATE, nullptr),
  JS_FS_END
};


static const Prefable<const JSFunctionSpec> sChromeMethods[] = {
  { nullptr, &sChromeMethods_specs[0] },
  { nullptr, nullptr }
};

static_assert(1 <= 1ull << NUM_BITS_PROPERTY_INFO_PREF_INDEX,
    "We have a prefable index that is >= (1 << NUM_BITS_PROPERTY_INFO_PREF_INDEX)");
static_assert(4 <= 1ull << NUM_BITS_PROPERTY_INFO_SPEC_INDEX,
    "We have a spec index that is >= (1 << NUM_BITS_PROPERTY_INFO_SPEC_INDEX)");

MOZ_GLOBINIT static const JSPropertySpec sAttributes_specs[] = {
  JSPropertySpec::nativeAccessors("mode", JSPROP_ENUMERATE, GenericGetter<NormalThisPolicy, ThrowExceptions>, &mode_getterinfo, nullptr, nullptr),
  JSPropertySpec::nativeAccessors("delegatesFocus", JSPROP_ENUMERATE, GenericGetter<NormalThisPolicy, ThrowExceptions>, &delegatesFocus_getterinfo, nullptr, nullptr),
  JSPropertySpec::nativeAccessors("slotAssignment", JSPROP_ENUMERATE, GenericGetter<NormalThisPolicy, ThrowExceptions>, &slotAssignment_getterinfo, nullptr, nullptr),
  JSPropertySpec::nativeAccessors("clonable", JSPROP_ENUMERATE, GenericGetter<NormalThisPolicy, ThrowExceptions>, &clonable_getterinfo, nullptr, nullptr),
  JSPropertySpec::nativeAccessors("serializable", JSPROP_ENUMERATE, GenericGetter<NormalThisPolicy, ThrowExceptions>, &serializable_getterinfo, nullptr, nullptr),
  JSPropertySpec::nativeAccessors("host", JSPROP_ENUMERATE, GenericGetter<NormalThisPolicy, ThrowExceptions>, &host_getterinfo, nullptr, nullptr),
  JSPropertySpec::nativeAccessors("onslotchange", JSPROP_ENUMERATE, GenericGetter<NormalThisPolicy, ThrowExceptions>, &onslotchange_getterinfo, GenericSetter<NormalThisPolicy>, &onslotchange_setterinfo),
  JS_PS_END,
  JSPropertySpec::nativeAccessors("referenceTarget", JSPROP_ENUMERATE, GenericGetter<NormalThisPolicy, ThrowExceptions>, &referenceTarget_getterinfo, GenericSetter<NormalThisPolicy>, &referenceTarget_setterinfo),
  JS_PS_END,
  JSPropertySpec::nativeAccessors("innerHTML", JSPROP_ENUMERATE, GenericGetter<NormalThisPolicy, ThrowExceptions>, &innerHTML_getterinfo, GenericSetter<NormalThisPolicy>, &innerHTML_setterinfo),
  JSPropertySpec::nativeAccessors("activeElement", JSPROP_ENUMERATE, GenericGetter<NormalThisPolicy, ThrowExceptions>, &activeElement_getterinfo, nullptr, nullptr),
  JSPropertySpec::nativeAccessors("styleSheets", JSPROP_ENUMERATE, GenericGetter<NormalThisPolicy, ThrowExceptions>, &styleSheets_getterinfo, nullptr, nullptr),
  JSPropertySpec::nativeAccessors("pointerLockElement", JSPROP_ENUMERATE, GenericGetter<NormalThisPolicy, ThrowExceptions>, &pointerLockElement_getterinfo, nullptr, nullptr),
  JSPropertySpec::nativeAccessors("fullscreenElement", JSPROP_ENUMERATE, GenericGetter<NormalThisPolicy, ThrowExceptions>, &fullscreenElement_getterinfo, GenericSetter<NormalThisPolicy>, &fullscreenElement_setterinfo),
  JSPropertySpec::nativeAccessors("mozFullScreenElement", JSPROP_ENUMERATE, GenericGetter<NormalThisPolicy, ThrowExceptions>, &mozFullScreenElement_getterinfo, nullptr, nullptr),
  JSPropertySpec::nativeAccessors("adoptedStyleSheets", JSPROP_ENUMERATE, GenericGetter<NormalThisPolicy, ThrowExceptions>, &adoptedStyleSheets_getterinfo, GenericSetter<NormalThisPolicy>, &adoptedStyleSheets_setterinfo),
  JS_PS_END
};

static const PrefableDisablers sAttributes_disablers8 = {
  WebIDLPrefIndex::dom_shadowdom_referenceTarget_enabled, 0, false, OriginTrial(0), nullptr
};

static const Prefable<const JSPropertySpec> sAttributes[] = {
  { nullptr, &sAttributes_specs[0] },
  { &sAttributes_disablers8, &sAttributes_specs[8] },
  { nullptr, &sAttributes_specs[10] },
  { nullptr, nullptr }
};

static_assert(3 <= 1ull << NUM_BITS_PROPERTY_INFO_PREF_INDEX,
    "We have a prefable index that is >= (1 << NUM_BITS_PROPERTY_INFO_PREF_INDEX)");
static_assert(7 <= 1ull << NUM_BITS_PROPERTY_INFO_SPEC_INDEX,
    "We have a spec index that is >= (1 << NUM_BITS_PROPERTY_INFO_SPEC_INDEX)");


static uint16_t sNativeProperties_sortedPropertyIndices[24];
static PropertyInfo sNativeProperties_propertyInfos[24];

static const NativePropertiesN<2> sNativeProperties = {
  false, 0,
  false, 0,
  true,  0 /* sMethods */,
  true,  1 /* sAttributes */,
  false, 0,
  false, 0,
  false, 0,
  -1,
  24,
  sNativeProperties_sortedPropertyIndices,
  {
    { sMethods, &sNativeProperties_propertyInfos[0] },
    { sAttributes, &sNativeProperties_propertyInfos[9] }
  }
};
static_assert(24 < 1ull << (CHAR_BIT * sizeof(sNativeProperties.propertyInfoCount)),
    "We have a property info count that is oversized");

static uint16_t sChromeOnlyNativeProperties_sortedPropertyIndices[4];
static PropertyInfo sChromeOnlyNativeProperties_propertyInfos[4];

static const NativePropertiesN<1> sChromeOnlyNativeProperties = {
  false, 0,
  false, 0,
  true,  0 /* sChromeMethods */,
  false, 0,
  false, 0,
  false, 0,
  false, 0,
  -1,
  4,
  sChromeOnlyNativeProperties_sortedPropertyIndices,
  {
    { sChromeMethods, &sChromeOnlyNativeProperties_propertyInfos[0] }
  }
};
static_assert(4 < 1ull << (CHAR_BIT * sizeof(sChromeOnlyNativeProperties.propertyInfoCount)),
    "We have a property info count that is oversized");

// This may allocate too many slots, because we only really need
// slots for our non-interface-typed members that we cache.  But
// allocating slots only for those would make the slot index
// computations much more complicated, so let's do this the simple
// way for now.
DEFINE_XRAY_EXPANDO_CLASS_WITH_OPS(static, sXrayExpandoObjectClass, 1,
                                   &xpc::XrayExpandoObjectClassOps);

bool sNativePropertiesInited = false;
const NativePropertyHooks sNativePropertyHooks = {
  nullptr,
  { sNativeProperties.Upcast(), sChromeOnlyNativeProperties.Upcast(), &sNativePropertiesInited },
  prototypes::id::ShadowRoot,
  constructors::id::ShadowRoot,
  &sXrayExpandoObjectClass
};

static const DOMInterfaceInfo sInterfaceObjectInfo = {
  { ThrowingConstructor, &sNativePropertyHooks },
  DocumentFragment_Binding::GetConstructorObjectHandle,
  PrototypeTraits<prototypes::id::ShadowRoot>::Depth,
  prototypes::id::ShadowRoot,
  true,
  0,
  "ShadowRoot",
};

static const DOMIfaceAndProtoJSClass sPrototypeClass = {
  {
    "ShadowRootPrototype",
    JSCLASS_IS_DOMIFACEANDPROTOJSCLASS | JSCLASS_HAS_RESERVED_SLOTS(DOM_INTERFACE_PROTO_SLOTS_BASE),
    JS_NULL_CLASS_OPS,
    JS_NULL_CLASS_SPEC,
    JS_NULL_CLASS_EXT,
    JS_NULL_OBJECT_OPS
  },
  eInterfacePrototype,
  prototypes::id::ShadowRoot,
  PrototypeTraits<prototypes::id::ShadowRoot>::Depth,
  &sNativePropertyHooks,
  DocumentFragment_Binding::GetProtoObject
};

static JS::Handle<JSObject*>
GetProtoObjectHandle(JSContext* aCx);

static const JSClassOps sClassOps = {
  nullptr,               /* addProperty */
  nullptr,               /* delProperty */
  nullptr,               /* enumerate */
  nullptr, /* newEnumerate */
  nullptr, /* resolve */
  nullptr, /* mayResolve */
  _finalize, /* finalize */
  nullptr, /* call */
  nullptr,               /* construct */
  nullptr, /* trace */
};

static const DOMJSClass sClass = {
  { "ShadowRoot",
    JSCLASS_IS_DOMJSCLASS | JSCLASS_FOREGROUND_FINALIZE | JSCLASS_HAS_RESERVED_SLOTS(2) | JSCLASS_PRESERVES_WRAPPER,
    &sClassOps,
    JS_NULL_CLASS_SPEC,
    &NativeTypeHelpers<mozilla::dom::ShadowRoot>::sClassExtension,
    JS_NULL_OBJECT_OPS
  },
  { prototypes::id::EventTarget, prototypes::id::Node, prototypes::id::DocumentFragment, prototypes::id::ShadowRoot, prototypes::id::_ID_Count, prototypes::id::_ID_Count, prototypes::id::_ID_Count, prototypes::id::_ID_Count },
  std::is_base_of_v<nsISupports, mozilla::dom::ShadowRoot>,
  &sNativePropertyHooks,
  FindAssociatedGlobalForNative<mozilla::dom::ShadowRoot>::Get,
  GetProtoObjectHandle,
  GetCCParticipant<mozilla::dom::ShadowRoot>::Get(),
  nullptr,
  NativeTypeHelpers<mozilla::dom::ShadowRoot>::GetWrapperCache
};
static_assert(1 == DOM_INSTANCE_RESERVED_SLOTS,
              "Must have the right minimal number of reserved slots.");
static_assert(2 >= 2,
              "Must have enough reserved slots.");

bool
Wrap(JSContext* aCx, mozilla::dom::ShadowRoot* aObject, nsWrapperCache* aCache, JS::Handle<JSObject*> aGivenProto, JS::MutableHandle<JSObject*> aReflector)
{
  static_assert(!std::is_base_of_v<NonRefcountedDOMObject, mozilla::dom::ShadowRoot>,
                "Shouldn't have wrappercached things that are not refcounted.");
  static_assert(std::is_same_v<decltype(aObject), mozilla::dom::ShadowRoot*>);
  MOZ_ASSERT(static_cast<mozilla::dom::DocumentFragment*>(aObject) ==
             reinterpret_cast<mozilla::dom::DocumentFragment*>(aObject),
             "Multiple inheritance for mozilla::dom::DocumentFragment is broken.");
  MOZ_ASSERT(static_cast<nsINode*>(aObject) ==
             reinterpret_cast<nsINode*>(aObject),
             "Multiple inheritance for nsINode is broken.");
  MOZ_ASSERT(static_cast<mozilla::dom::EventTarget*>(aObject) ==
             reinterpret_cast<mozilla::dom::EventTarget*>(aObject),
             "Multiple inheritance for mozilla::dom::EventTarget is broken.");
  MOZ_ASSERT(ToSupportsIsCorrect(aObject));
  MOZ_ASSERT_IF(aGivenProto, js::IsObjectInContextCompartment(aGivenProto, aCx));
  MOZ_ASSERT(!aCache->GetWrapper(),
             "You should probably not be using Wrap() directly; use "
             "GetOrCreateDOMReflector instead");

  MOZ_ASSERT(ToSupportsIsOnPrimaryInheritanceChain(aObject, aCache),
             "nsISupports must be on our primary inheritance chain");

  // If the wrapper cache contains a dead reflector then finalize that
  // now, ensuring that the finalizer for the old reflector always
  // runs before the new reflector is created and attached. This
  // avoids the awkward situation where there are multiple reflector
  // objects that contain pointers to the same native.

  if (JSObject* oldReflector = aCache->GetWrapperMaybeDead()) {
    _finalize(nullptr /* unused */, oldReflector);
    MOZ_ASSERT(!aCache->GetWrapperMaybeDead());
  }

  JS::Rooted<JSObject*> global(aCx, FindAssociatedGlobal(aCx, aObject->GetParentObject()));
  if (!global) {
    return false;
  }
  MOZ_ASSERT(JS_IsGlobalObject(global));
  JS::AssertObjectIsNotGray(global);

  // That might have ended up wrapping us already, due to the wonders
  // of XBL.  Check for that, and bail out as needed.
  aReflector.set(aCache->GetWrapper());
  if (aReflector) {
#ifdef DEBUG
    AssertReflectorHasGivenProto(aCx, aReflector, aGivenProto);
#endif // DEBUG
    return true;
  }

  JSAutoRealm ar(aCx, global);
  JS::Handle<JSObject*> canonicalProto = GetProtoObjectHandle(aCx);
  if (!canonicalProto) {
    return false;
  }
  JS::Rooted<JSObject*> proto(aCx);
  if (aGivenProto) {
    proto = aGivenProto;
    // Unfortunately, while aGivenProto was in the compartment of aCx
    // coming in, we changed compartments to that of "parent" so may need
    // to wrap the proto here.
    if (js::GetContextCompartment(aCx) != JS::GetCompartment(proto)) {
      if (!JS_WrapObject(aCx, &proto)) {
        return false;
      }
    }
  } else {
    proto = canonicalProto;
  }

  BindingJSObjectCreator<mozilla::dom::ShadowRoot> creator(aCx);
  creator.CreateObject(aCx, sClass.ToJSClass(), proto, aObject, aReflector);
  if (!aReflector) {
    return false;
  }

  aCache->SetWrapper(aReflector);
  creator.InitializationSucceeded();

  MOZ_ASSERT(aCache->GetWrapperPreserveColor() &&
             aCache->GetWrapperPreserveColor() == aReflector);
  // If proto != canonicalProto, we have to preserve our wrapper;
  // otherwise we won't be able to properly recreate it later, since
  // we won't know what proto to use.  Note that we don't check
  // aGivenProto here, since it's entirely possible (and even
  // somewhat common) to have a non-null aGivenProto which is the
  // same as canonicalProto.
  if (proto != canonicalProto) {
    PreserveWrapper(aObject);
  }

  return true;
}

void
ClearCachedAdoptedStyleSheetsValue(mozilla::dom::ShadowRoot* aObject)
{
  JSObject* obj;
  obj = aObject->GetWrapper();
  if (!obj) {
    return;
  }
  JS::SetReservedSlot(obj, (DOM_INSTANCE_RESERVED_SLOTS + 0), JS::UndefinedValue());
  ClearXrayExpandoSlots(RootingCx(), obj, (DOM_EXPANDO_RESERVED_SLOTS + 0));
}

void
CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, DefineInterfaceProperty aDefineOnGlobal)
{
  JS::Heap<JSObject*>* protoCache = &aProtoAndIfaceCache.EntrySlotOrCreate(prototypes::id::ShadowRoot);
  JS::Heap<JSObject*>* interfaceCache = &aProtoAndIfaceCache.EntrySlotOrCreate(constructors::id::ShadowRoot);

  JS::Handle<JSObject*> parentProto(DocumentFragment_Binding::GetProtoObjectHandle(aCx));
  if (!parentProto) {
    return;
  }

  JS::Handle<JSObject*> constructorProto(DocumentFragment_Binding::GetConstructorObjectHandle(aCx));
  if (!constructorProto) {
    return;
  }

  dom::CreateInterfaceObjects(aCx, aGlobal, parentProto,
                              &sPrototypeClass, protoCache,
                              constructorProto, &sInterfaceObjectInfo, 0, false, Span<const LegacyFactoryFunction, 0>{},
                              interfaceCache,
                              sNativeProperties.Upcast(),
                              sChromeOnlyNativeProperties.Upcast(),
                              "ShadowRoot",
                              aDefineOnGlobal != DefineInterfaceProperty::No,
                              nullptr,
                              false,
                              nullptr);
}

static JS::Handle<JSObject*>
GetProtoObjectHandle(JSContext* aCx)
{
  /* Get the interface prototype object for this class.  This will create the
     object as needed. */
  return GetPerInterfaceObjectHandle(aCx, prototypes::id::ShadowRoot,
                                     &CreateInterfaceObjects,
                                     DefineInterfaceProperty::CheckExposure);

}

JS::Handle<JSObject*>
GetConstructorObjectHandle(JSContext* aCx)
{
  /* Get the interface object for this class.  This will create the object as
     needed. */

  return GetPerInterfaceObjectHandle(aCx, constructors::id::ShadowRoot,
                                     &CreateInterfaceObjects,
                                     DefineInterfaceProperty::CheckExposure);
}

} // namespace ShadowRoot_Binding



} // namespace dom


} // namespace mozilla
