
// This file is generated by src/Tools/generateTemplates/templateClassPyExport.py out of the .XML file
// Every change you make here gets lost in the next full rebuild!
// This File is normally built as an include in HLRBRep_PolyAlgoPyImp.cpp! It's not intended to be in a project!

#include <boost/filesystem/path.hpp>
#include <boost/filesystem/operations.hpp>
#include <boost/filesystem/exception.hpp>
#include <Base/PyObjectBase.h>
#include <Base/Console.h>
#include <Base/Exception.h>
#include <CXX/Objects.hxx>

#if defined(__clang__)
# pragma clang diagnostic push
# pragma clang diagnostic ignored "-Wdeprecated-declarations"
#endif

using Base::streq;
using namespace Part;

/// Type structure of HLRBRep_PolyAlgoPy
PyTypeObject HLRBRep_PolyAlgoPy::Type = {
    PyVarObject_HEAD_INIT(&PyType_Type,0)
    "Part.HLRBRep_PolyAlgo",     /*tp_name*/
    sizeof(HLRBRep_PolyAlgoPy),                       /*tp_basicsize*/
    0,                                                /*tp_itemsize*/
    /* methods */
    PyDestructor,                                     /*tp_dealloc*/
#if PY_VERSION_HEX >= 0x03080000
    0,                                                /*tp_vectorcall_offset*/
#else
    nullptr,                                          /*tp_print*/
#endif
    nullptr,                                          /*tp_getattr*/
    nullptr,                                          /*tp_setattr*/
    nullptr,                                          /*tp_compare*/
    __repr,                                           /*tp_repr*/
    nullptr,                                          /*tp_as_number*/
    nullptr,                                          /*tp_as_sequence*/
    nullptr,                                          /*tp_as_mapping*/
    nullptr,                                          /*tp_hash*/
    nullptr,                                          /*tp_call */
    nullptr,                                          /*tp_str  */
    __getattro,                                       /*tp_getattro*/
    __setattro,                                       /*tp_setattro*/
    /* --- Functions to access object as input/output buffer ---------*/
    nullptr,                                          /* tp_as_buffer */
    /* --- Flags to define presence of optional/expanded features */
    Py_TPFLAGS_BASETYPE|Py_TPFLAGS_DEFAULT,        /*tp_flags */
    "PolyAlgo() -> HLRBRep_PolyAlgo\n"
    "\n"
    "A framework to compute the shape as seen in a projection\n"
    "plane. This is done by calculating the visible and the hidden parts of the\n"
    "shape. HLRBRep_PolyAlgo works with three types of entity:\n"
    "\n"
    "- shapes to be visualized (these shapes must have already been triangulated.)\n"
    "- edges in these shapes (these edges are defined as polygonal lines on the\n"
    "  triangulation of the shape, and are the basic entities which will be visualized\n"
    "  or hidden), and\n"
    "- triangles in these shapes which hide the edges.\n"
    "\n"
    "HLRBRep_PolyAlgo is based on the principle of comparing each edge of the shape\n"
    "to be visualized with each of the triangles produced by the triangulation of\n"
    "the shape, and calculating the visible and the hidden parts of each edge. For a\n"
    "given projection, HLRBRep_PolyAlgo calculates a set of lines characteristic of\n"
    "the object being represented. It is also used in conjunction with the\n"
    "HLRBRep_PolyHLRToShape extraction utilities, which reconstruct a new,\n"
    "simplified shape from a selection of calculation results. This new shape is\n"
    "made up of edges, which represent the shape visualized in the\n"
    "projection. HLRBRep_PolyAlgo works with a polyhedral simplification of the\n"
    "shape whereas HLRBRep_Algo takes the shape itself into account. When you use\n"
    "HLRBRep_Algo, you obtain an exact result, whereas, when you use\n"
    "HLRBRep_PolyAlgo, you reduce computation time but obtain polygonal segments. An\n"
    "HLRBRep_PolyAlgo object provides a framework for:\n"
    "\n"
    "- defining the point of view\n"
    "- identifying the shape or shapes to be visualized\n"
    "- calculating the outlines\n"
    "- calculating the visible and hidden lines of the shape. Warning\n"
    "- Superimposed lines are not eliminated by this algorithm.\n"
    "- There must be no unfinished objects inside the shape you wish to visualize.\n"
    "- Points are not treated.\n"
    "- Note that this is not the sort of algorithm used in generating shading, which\n"
    "  calculates the visible and hidden parts of each face in a shape to be\n"
    "  visualized by comparing each face in the shape with every other face in the\n"
    "  same shape.",           /*tp_doc */
    nullptr,                                          /*tp_traverse */
    nullptr,                                          /*tp_clear */
    nullptr,                                          /*tp_richcompare */
    0,                                                /*tp_weaklistoffset */
    nullptr,                                          /*tp_iter */
    nullptr,                                          /*tp_iternext */
    Part::HLRBRep_PolyAlgoPy::Methods,                     /*tp_methods */
    nullptr,                                          /*tp_members */
    Part::HLRBRep_PolyAlgoPy::GetterSetter,                     /*tp_getset */
    &Base::PyObjectBase::Type,                        /*tp_base */
    nullptr,                                          /*tp_dict */
    nullptr,                                          /*tp_descr_get */
    nullptr,                                          /*tp_descr_set */
    0,                                                /*tp_dictoffset */
    __PyInit,                                         /*tp_init */
    nullptr,                                          /*tp_alloc */
    Part::HLRBRep_PolyAlgoPy::PyMake,/*tp_new */
    nullptr,                                          /*tp_free   Low-level free-memory routine */
    nullptr,                                          /*tp_is_gc  For PyObject_IS_GC */
    nullptr,                                          /*tp_bases */
    nullptr,                                          /*tp_mro    method resolution order */
    nullptr,                                          /*tp_cache */
    nullptr,                                          /*tp_subclasses */
    nullptr,                                          /*tp_weaklist */
    nullptr,                                          /*tp_del */
    0,                                                /*tp_version_tag */
    nullptr                                           /*tp_finalize */
#if PY_VERSION_HEX >= 0x03090000
    ,nullptr                                          /*tp_vectorcall */
#if PY_VERSION_HEX >= 0x030c0000
    ,0                                                /*tp_watched */
#endif
#elif PY_VERSION_HEX >= 0x03080000
    ,nullptr                                          /*tp_vectorcall */
    /* bpo-37250: kept for backwards compatibility in CPython 3.8 only */
    ,nullptr                                          /*tp_print */
#endif
};

/// Methods structure of HLRBRep_PolyAlgoPy
PyMethodDef HLRBRep_PolyAlgoPy::Methods[] = {
    {"load",
        reinterpret_cast<PyCFunction>( staticCallback_load ),
        METH_VARARGS,
        "load(S)\n"
        "\n"
        "Loads the shape S into this framework. Warning S must have already been triangulated."
    },
    {"remove",
        reinterpret_cast<PyCFunction>( staticCallback_remove ),
        METH_VARARGS,
        "remove(i)\n"
        "\n"
        "Remove the shape of index i from this framework."
    },
    {"nbShapes",
        reinterpret_cast<PyCFunction>( staticCallback_nbShapes ),
        METH_VARARGS,
        "nbShapes()\n"
        "\n"
        "Returns the number of shapes in the collection.  It does not modify the\n"
        "object's state and is used to retrieve the count of shapes."
    },
    {"shape",
        reinterpret_cast<PyCFunction>( staticCallback_shape ),
        METH_VARARGS,
        "shape(i) -> TopoShape\n"
        "\n"
        "Return the shape of index i."
    },
    {"index",
        reinterpret_cast<PyCFunction>( staticCallback_index ),
        METH_VARARGS,
        "index(S) ->  int\n"
        "\n"
        "Return the index of the Shape S."
    },
    {"setProjector",
        reinterpret_cast<PyCFunction>(reinterpret_cast<void (*) ()>( staticCallback_setProjector )),
        METH_VARARGS|METH_KEYWORDS,
        "setProjector(Origin=(0, 0, 0), ZDir=(0,0,0), XDir=(0,0,0), focus=NaN)\n"
        "\n"
        "Set the projector.  With focus left to NaN, an axonometric projector is\n"
        "created.  Otherwise, a perspective projector is created with focus focus."
    },
    {"update",
        reinterpret_cast<PyCFunction>( staticCallback_update ),
        METH_VARARGS,
        "update()\n"
        "\n"
        "Launches calculation of outlines of the shape visualized by this\n"
        "framework. Used after setting the point of view and defining the shape or\n"
        "shapes to be visualized."
    },
    {"initHide",
        reinterpret_cast<PyCFunction>( staticCallback_initHide ),
        METH_VARARGS,
        "initHide()"
    },
    {"moreHide",
        reinterpret_cast<PyCFunction>( staticCallback_moreHide ),
        METH_VARARGS,
        "moreHide()"
    },
    {"nextHide",
        reinterpret_cast<PyCFunction>( staticCallback_nextHide ),
        METH_VARARGS,
        "nextHide()"
    },
    {"initShow",
        reinterpret_cast<PyCFunction>( staticCallback_initShow ),
        METH_VARARGS,
        "initShow()"
    },
    {"moreShow",
        reinterpret_cast<PyCFunction>( staticCallback_moreShow ),
        METH_VARARGS,
        "moreShow()"
    },
    {"nextShow",
        reinterpret_cast<PyCFunction>( staticCallback_nextShow ),
        METH_VARARGS,
        "nextShow()"
    },
    {"outLinedShape",
        reinterpret_cast<PyCFunction>( staticCallback_outLinedShape ),
        METH_VARARGS,
        "outLinedShape(S) -> TopoShape\n"
        "\n"
        "Make a shape with the internal outlines in each face of shape S."
    },
    {nullptr, nullptr, 0, nullptr}		/* Sentinel */
};



/// Attribute structure of HLRBRep_PolyAlgoPy
PyGetSetDef HLRBRep_PolyAlgoPy::GetterSetter[] = {
    {"Angle",
        (getter) staticCallback_getAngle,
        (setter) staticCallback_setAngle,
        "",
        nullptr
    },
    {"TolAngular",
        (getter) staticCallback_getTolAngular,
        (setter) staticCallback_setTolAngular,
        "",
        nullptr
    },
    {"TolCoef",
        (getter) staticCallback_getTolCoef,
        (setter) staticCallback_setTolCoef,
        "",
        nullptr
    },
    {nullptr, nullptr, nullptr, nullptr, nullptr}		/* Sentinel */
};

// load() callback and implementer
// PyObject*  HLRBRep_PolyAlgoPy::load(PyObject *args){};
// has to be implemented in HLRBRep_PolyAlgoPyImp.cpp
PyObject * HLRBRep_PolyAlgoPy::staticCallback_load (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'load' of 'Part.HLRBRep_PolyAlgo' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    // test if object is set Const
    if (static_cast<PyObjectBase*>(self)->isConst()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a non const method");
        return nullptr;
    }

    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<HLRBRep_PolyAlgoPy*>(self)->load(args);
        if (ret != nullptr)
            static_cast<HLRBRep_PolyAlgoPy*>(self)->startNotify();
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// remove() callback and implementer
// PyObject*  HLRBRep_PolyAlgoPy::remove(PyObject *args){};
// has to be implemented in HLRBRep_PolyAlgoPyImp.cpp
PyObject * HLRBRep_PolyAlgoPy::staticCallback_remove (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'remove' of 'Part.HLRBRep_PolyAlgo' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    // test if object is set Const
    if (static_cast<PyObjectBase*>(self)->isConst()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a non const method");
        return nullptr;
    }

    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<HLRBRep_PolyAlgoPy*>(self)->remove(args);
        if (ret != nullptr)
            static_cast<HLRBRep_PolyAlgoPy*>(self)->startNotify();
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// nbShapes() callback and implementer
// PyObject*  HLRBRep_PolyAlgoPy::nbShapes(PyObject *args){};
// has to be implemented in HLRBRep_PolyAlgoPyImp.cpp
PyObject * HLRBRep_PolyAlgoPy::staticCallback_nbShapes (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'nbShapes' of 'Part.HLRBRep_PolyAlgo' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    // test if object is set Const
    if (static_cast<PyObjectBase*>(self)->isConst()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a non const method");
        return nullptr;
    }

    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<HLRBRep_PolyAlgoPy*>(self)->nbShapes(args);
        if (ret != nullptr)
            static_cast<HLRBRep_PolyAlgoPy*>(self)->startNotify();
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// shape() callback and implementer
// PyObject*  HLRBRep_PolyAlgoPy::shape(PyObject *args){};
// has to be implemented in HLRBRep_PolyAlgoPyImp.cpp
PyObject * HLRBRep_PolyAlgoPy::staticCallback_shape (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'shape' of 'Part.HLRBRep_PolyAlgo' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    // test if object is set Const
    if (static_cast<PyObjectBase*>(self)->isConst()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a non const method");
        return nullptr;
    }

    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<HLRBRep_PolyAlgoPy*>(self)->shape(args);
        if (ret != nullptr)
            static_cast<HLRBRep_PolyAlgoPy*>(self)->startNotify();
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// index() callback and implementer
// PyObject*  HLRBRep_PolyAlgoPy::index(PyObject *args){};
// has to be implemented in HLRBRep_PolyAlgoPyImp.cpp
PyObject * HLRBRep_PolyAlgoPy::staticCallback_index (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'index' of 'Part.HLRBRep_PolyAlgo' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    // test if object is set Const
    if (static_cast<PyObjectBase*>(self)->isConst()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a non const method");
        return nullptr;
    }

    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<HLRBRep_PolyAlgoPy*>(self)->index(args);
        if (ret != nullptr)
            static_cast<HLRBRep_PolyAlgoPy*>(self)->startNotify();
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// setProjector() callback and implementer
// PyObject*  HLRBRep_PolyAlgoPy::setProjector(PyObject *args){};
// has to be implemented in HLRBRep_PolyAlgoPyImp.cpp
PyObject * HLRBRep_PolyAlgoPy::staticCallback_setProjector (PyObject *self, PyObject *args, PyObject * kwd)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'setProjector' of 'Part.HLRBRep_PolyAlgo' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    // test if object is set Const
    if (static_cast<PyObjectBase*>(self)->isConst()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a non const method");
        return nullptr;
    }

    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<HLRBRep_PolyAlgoPy*>(self)->setProjector(args, kwd);
        if (ret != nullptr)
            static_cast<HLRBRep_PolyAlgoPy*>(self)->startNotify();
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// update() callback and implementer
// PyObject*  HLRBRep_PolyAlgoPy::update(PyObject *args){};
// has to be implemented in HLRBRep_PolyAlgoPyImp.cpp
PyObject * HLRBRep_PolyAlgoPy::staticCallback_update (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'update' of 'Part.HLRBRep_PolyAlgo' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    // test if object is set Const
    if (static_cast<PyObjectBase*>(self)->isConst()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a non const method");
        return nullptr;
    }

    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<HLRBRep_PolyAlgoPy*>(self)->update(args);
        if (ret != nullptr)
            static_cast<HLRBRep_PolyAlgoPy*>(self)->startNotify();
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// initHide() callback and implementer
// PyObject*  HLRBRep_PolyAlgoPy::initHide(PyObject *args){};
// has to be implemented in HLRBRep_PolyAlgoPyImp.cpp
PyObject * HLRBRep_PolyAlgoPy::staticCallback_initHide (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'initHide' of 'Part.HLRBRep_PolyAlgo' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    // test if object is set Const
    if (static_cast<PyObjectBase*>(self)->isConst()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a non const method");
        return nullptr;
    }

    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<HLRBRep_PolyAlgoPy*>(self)->initHide(args);
        if (ret != nullptr)
            static_cast<HLRBRep_PolyAlgoPy*>(self)->startNotify();
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// moreHide() callback and implementer
// PyObject*  HLRBRep_PolyAlgoPy::moreHide(PyObject *args){};
// has to be implemented in HLRBRep_PolyAlgoPyImp.cpp
PyObject * HLRBRep_PolyAlgoPy::staticCallback_moreHide (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'moreHide' of 'Part.HLRBRep_PolyAlgo' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    // test if object is set Const
    if (static_cast<PyObjectBase*>(self)->isConst()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a non const method");
        return nullptr;
    }

    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<HLRBRep_PolyAlgoPy*>(self)->moreHide(args);
        if (ret != nullptr)
            static_cast<HLRBRep_PolyAlgoPy*>(self)->startNotify();
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// nextHide() callback and implementer
// PyObject*  HLRBRep_PolyAlgoPy::nextHide(PyObject *args){};
// has to be implemented in HLRBRep_PolyAlgoPyImp.cpp
PyObject * HLRBRep_PolyAlgoPy::staticCallback_nextHide (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'nextHide' of 'Part.HLRBRep_PolyAlgo' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    // test if object is set Const
    if (static_cast<PyObjectBase*>(self)->isConst()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a non const method");
        return nullptr;
    }

    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<HLRBRep_PolyAlgoPy*>(self)->nextHide(args);
        if (ret != nullptr)
            static_cast<HLRBRep_PolyAlgoPy*>(self)->startNotify();
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// initShow() callback and implementer
// PyObject*  HLRBRep_PolyAlgoPy::initShow(PyObject *args){};
// has to be implemented in HLRBRep_PolyAlgoPyImp.cpp
PyObject * HLRBRep_PolyAlgoPy::staticCallback_initShow (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'initShow' of 'Part.HLRBRep_PolyAlgo' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    // test if object is set Const
    if (static_cast<PyObjectBase*>(self)->isConst()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a non const method");
        return nullptr;
    }

    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<HLRBRep_PolyAlgoPy*>(self)->initShow(args);
        if (ret != nullptr)
            static_cast<HLRBRep_PolyAlgoPy*>(self)->startNotify();
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// moreShow() callback and implementer
// PyObject*  HLRBRep_PolyAlgoPy::moreShow(PyObject *args){};
// has to be implemented in HLRBRep_PolyAlgoPyImp.cpp
PyObject * HLRBRep_PolyAlgoPy::staticCallback_moreShow (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'moreShow' of 'Part.HLRBRep_PolyAlgo' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    // test if object is set Const
    if (static_cast<PyObjectBase*>(self)->isConst()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a non const method");
        return nullptr;
    }

    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<HLRBRep_PolyAlgoPy*>(self)->moreShow(args);
        if (ret != nullptr)
            static_cast<HLRBRep_PolyAlgoPy*>(self)->startNotify();
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// nextShow() callback and implementer
// PyObject*  HLRBRep_PolyAlgoPy::nextShow(PyObject *args){};
// has to be implemented in HLRBRep_PolyAlgoPyImp.cpp
PyObject * HLRBRep_PolyAlgoPy::staticCallback_nextShow (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'nextShow' of 'Part.HLRBRep_PolyAlgo' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    // test if object is set Const
    if (static_cast<PyObjectBase*>(self)->isConst()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a non const method");
        return nullptr;
    }

    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<HLRBRep_PolyAlgoPy*>(self)->nextShow(args);
        if (ret != nullptr)
            static_cast<HLRBRep_PolyAlgoPy*>(self)->startNotify();
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// outLinedShape() callback and implementer
// PyObject*  HLRBRep_PolyAlgoPy::outLinedShape(PyObject *args){};
// has to be implemented in HLRBRep_PolyAlgoPyImp.cpp
PyObject * HLRBRep_PolyAlgoPy::staticCallback_outLinedShape (PyObject *self, PyObject *args)
{
    // make sure that not a null pointer is passed
    if (!self) {
        PyErr_SetString(PyExc_TypeError, "descriptor 'outLinedShape' of 'Part.HLRBRep_PolyAlgo' object needs an argument");
        return nullptr;
    }

    // test if twin object isn't already deleted
    if (!static_cast<PyObjectBase*>(self)->isValid()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    // test if object is set Const
    if (static_cast<PyObjectBase*>(self)->isConst()) {
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a non const method");
        return nullptr;
    }

    try { // catches all exceptions coming up from c++ and generate a python exception
        PyObject* ret = static_cast<HLRBRep_PolyAlgoPy*>(self)->outLinedShape(args);
        if (ret != nullptr)
            static_cast<HLRBRep_PolyAlgoPy*>(self)->startNotify();
        return ret;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return nullptr;
    }
#endif
}

// Angle() callback and implementer
// PyObject*  HLRBRep_PolyAlgoPy::Angle(PyObject *args){};
// has to be implemented in HLRBRep_PolyAlgoPyImp.cpp
PyObject * HLRBRep_PolyAlgoPy::staticCallback_getAngle (PyObject *self, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    try {
        return Py::new_reference_to(static_cast<HLRBRep_PolyAlgoPy*>(self)->getAngle());
    } catch (const Py::Exception&) {
        // The exception text is already set
        return nullptr;
    } catch (...) {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown exception while reading attribute 'Angle' of object 'HLRBRep_PolyAlgo'");
        return nullptr;
    }
}

int HLRBRep_PolyAlgoPy::staticCallback_setAngle (PyObject *self, PyObject *value, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return -1;
    }
    if (static_cast<PyObjectBase*>(self)->isConst()){
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a method");
        return -1;
    }

    try {
        static_cast<HLRBRep_PolyAlgoPy*>(self)->setAngle(Py::Float(PyNumber_Float(value),true));
        return 0;
    } catch (const Py::Exception&) {
        // The exception text is already set
        return -1;
    } catch (...) {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown exception while writing attribute 'Angle' of object 'HLRBRep_PolyAlgo'");
        return -1;
    }
}

// TolAngular() callback and implementer
// PyObject*  HLRBRep_PolyAlgoPy::TolAngular(PyObject *args){};
// has to be implemented in HLRBRep_PolyAlgoPyImp.cpp
PyObject * HLRBRep_PolyAlgoPy::staticCallback_getTolAngular (PyObject *self, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    try {
        return Py::new_reference_to(static_cast<HLRBRep_PolyAlgoPy*>(self)->getTolAngular());
    } catch (const Py::Exception&) {
        // The exception text is already set
        return nullptr;
    } catch (...) {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown exception while reading attribute 'TolAngular' of object 'HLRBRep_PolyAlgo'");
        return nullptr;
    }
}

int HLRBRep_PolyAlgoPy::staticCallback_setTolAngular (PyObject *self, PyObject *value, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return -1;
    }
    if (static_cast<PyObjectBase*>(self)->isConst()){
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a method");
        return -1;
    }

    try {
        static_cast<HLRBRep_PolyAlgoPy*>(self)->setTolAngular(Py::Float(PyNumber_Float(value),true));
        return 0;
    } catch (const Py::Exception&) {
        // The exception text is already set
        return -1;
    } catch (...) {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown exception while writing attribute 'TolAngular' of object 'HLRBRep_PolyAlgo'");
        return -1;
    }
}

// TolCoef() callback and implementer
// PyObject*  HLRBRep_PolyAlgoPy::TolCoef(PyObject *args){};
// has to be implemented in HLRBRep_PolyAlgoPyImp.cpp
PyObject * HLRBRep_PolyAlgoPy::staticCallback_getTolCoef (PyObject *self, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return nullptr;
    }

    try {
        return Py::new_reference_to(static_cast<HLRBRep_PolyAlgoPy*>(self)->getTolCoef());
    } catch (const Py::Exception&) {
        // The exception text is already set
        return nullptr;
    } catch (...) {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown exception while reading attribute 'TolCoef' of object 'HLRBRep_PolyAlgo'");
        return nullptr;
    }
}

int HLRBRep_PolyAlgoPy::staticCallback_setTolCoef (PyObject *self, PyObject *value, void * /*closure*/)
{
    if (!static_cast<PyObjectBase*>(self)->isValid()){
        PyErr_SetString(PyExc_ReferenceError, "This object is already deleted most likely through closing a document. This reference is no longer valid!");
        return -1;
    }
    if (static_cast<PyObjectBase*>(self)->isConst()){
        PyErr_SetString(PyExc_ReferenceError, "This object is immutable, you can not set any attribute or call a method");
        return -1;
    }

    try {
        static_cast<HLRBRep_PolyAlgoPy*>(self)->setTolCoef(Py::Float(PyNumber_Float(value),true));
        return 0;
    } catch (const Py::Exception&) {
        // The exception text is already set
        return -1;
    } catch (...) {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown exception while writing attribute 'TolCoef' of object 'HLRBRep_PolyAlgo'");
        return -1;
    }
}




//--------------------------------------------------------------------------
// Constructor
//--------------------------------------------------------------------------
HLRBRep_PolyAlgoPy::HLRBRep_PolyAlgoPy(HLRBRep_PolyAlgo *pcObject, PyTypeObject *T)
    : PyObjectBase(static_cast<PyObjectBase::PointerType>(pcObject), T)
{
}


//--------------------------------------------------------------------------
// destructor
//--------------------------------------------------------------------------
HLRBRep_PolyAlgoPy::~HLRBRep_PolyAlgoPy()                                // Everything handled in parent
{
}

//--------------------------------------------------------------------------
// HLRBRep_PolyAlgoPy representation
//--------------------------------------------------------------------------
PyObject *HLRBRep_PolyAlgoPy::_repr()
{
    return Py_BuildValue("s", representation().c_str());
}

//--------------------------------------------------------------------------
// HLRBRep_PolyAlgoPy Attributes
//--------------------------------------------------------------------------
PyObject *HLRBRep_PolyAlgoPy::_getattr(const char *attr)			// __getattr__ function: note only need to handle new state
{
    try {
        // getter method for special Attributes (e.g. dynamic ones)
        PyObject *r = getCustomAttributes(attr);
        if(r) return r;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return nullptr;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return nullptr;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return nullptr;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError,"Unknown C++ exception");
        return nullptr;
    }
#endif

    PyMethodDef *ml = Methods;
    for (; ml->ml_name != nullptr; ml++) {
        if (attr[0] == ml->ml_name[0] &&
            strcmp(attr+1, ml->ml_name+1) == 0)
            return PyCFunction_New(ml, this);
    }

    PyErr_Clear();
    return PyObjectBase::_getattr(attr);
}

int HLRBRep_PolyAlgoPy::_setattr(const char *attr, PyObject *value) // __setattr__ function: note only need to handle new state
{
    try {
        // setter for special Attributes (e.g. dynamic ones)
        int r = setCustomAttributes(attr, value);
        // r = 1: handled
        // r = -1: error
        // r = 0: ignore
        if (r == 1)
            return 0;
        else if (r == -1)
            return -1;
    } // Please sync the following catch implementation with PY_CATCH
    catch(Base::Exception &e)
    {
        auto pye = e.getPyExceptionType();
        if(!pye)
            pye = Base::PyExc_FC_GeneralError;
        PyErr_SetObject(pye, e.getPyObject());
        return -1;
    }
    catch(const std::exception &e)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, e.what());
        return -1;
    }
    catch(const Py::Exception&)
    {
        // The exception text is already set
        return -1;
    }
#ifndef DONT_CATCH_CXX_EXCEPTIONS
    catch(...)
    {
        PyErr_SetString(Base::PyExc_FC_GeneralError, "Unknown C++ exception");
        return -1;
    }
#endif

    return PyObjectBase::_setattr(attr, value);
}

HLRBRep_PolyAlgo *HLRBRep_PolyAlgoPy::getHLRBRep_PolyAlgoPtr() const
{
    return static_cast<HLRBRep_PolyAlgo *>(_pcTwinPointer);
}

#if defined(__clang__)
# pragma clang diagnostic pop
#endif

#if 0
/* From here on come the methods you have to implement, but NOT in this module. Implement in HLRBRep_PolyAlgoPyImp.cpp! This prototypes
 * are just for convenience when you add a new method.
 */

PyObject *HLRBRep_PolyAlgoPy::PyMake(PyTypeObject* /*type*/, PyObject* /*args*/, PyObject* /*kwds*/)
{
    // create a new instance of HLRBRep_PolyAlgoPy and the Twin object
    return new HLRBRep_PolyAlgoPy(new HLRBRep_PolyAlgo);
}

// constructor method
int HLRBRep_PolyAlgoPy::PyInit(PyObject* /*args*/, PyObject* /*kwd*/)
{
    return 0;
}


// returns a string which represents the object e.g. when printed in python
std::string HLRBRep_PolyAlgoPy::representation() const
{
    return {"<HLRBRep_PolyAlgo object>"};
}

PyObject* HLRBRep_PolyAlgoPy::load(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* HLRBRep_PolyAlgoPy::remove(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* HLRBRep_PolyAlgoPy::nbShapes(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* HLRBRep_PolyAlgoPy::shape(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* HLRBRep_PolyAlgoPy::index(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* HLRBRep_PolyAlgoPy::setProjector(PyObject *args, PyObject *kwds)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* HLRBRep_PolyAlgoPy::update(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* HLRBRep_PolyAlgoPy::initHide(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* HLRBRep_PolyAlgoPy::moreHide(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* HLRBRep_PolyAlgoPy::nextHide(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* HLRBRep_PolyAlgoPy::initShow(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* HLRBRep_PolyAlgoPy::moreShow(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* HLRBRep_PolyAlgoPy::nextShow(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}

PyObject* HLRBRep_PolyAlgoPy::outLinedShape(PyObject *args)
{
    PyErr_SetString(PyExc_NotImplementedError, "Not yet implemented");
    return nullptr;
}



Py::Float HLRBRep_PolyAlgoPy::getAngle() const
{
    //return Py::Float();
    throw Py::AttributeError("Not yet implemented");
}

void  HLRBRep_PolyAlgoPy::setAngle(Py::Float arg)
{
    throw Py::AttributeError("Not yet implemented");
}

Py::Float HLRBRep_PolyAlgoPy::getTolAngular() const
{
    //return Py::Float();
    throw Py::AttributeError("Not yet implemented");
}

void  HLRBRep_PolyAlgoPy::setTolAngular(Py::Float arg)
{
    throw Py::AttributeError("Not yet implemented");
}

Py::Float HLRBRep_PolyAlgoPy::getTolCoef() const
{
    //return Py::Float();
    throw Py::AttributeError("Not yet implemented");
}

void  HLRBRep_PolyAlgoPy::setTolCoef(Py::Float arg)
{
    throw Py::AttributeError("Not yet implemented");
}

PyObject *HLRBRep_PolyAlgoPy::getCustomAttributes(const char* /*attr*/) const
{
    return nullptr;
}

int HLRBRep_PolyAlgoPy::setCustomAttributes(const char* /*attr*/, PyObject* /*obj*/)
{
    return 0;
}


#endif



