/* gitg-credentials-manager.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from gitg-credentials-manager.vala, do not modify */

/*
 * This file is part of gitg
 *
 * Copyright (C) 2014 - Jesse van den Kieboom
 *
 * gitg is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * gitg is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with gitg. If not, see <http://www.gnu.org/licenses/>.
 */

#include "libgitg.h"
#include <libgit2-glib/ggit.h>
#include <gtk/gtk.h>
#include <gee.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <libsecret/secret.h>
#include <stdio.h>
#include <gio/gio.h>
#include "config.h"
#include <gobject/gvaluecollector.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _Block5Data Block5Data;
#define _gitg_credentials_manager_unref0(var) ((var == NULL) ? NULL : (var = (gitg_credentials_manager_unref (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _g_match_info_unref0(var) ((var == NULL) ? NULL : (var = (g_match_info_unref (var), NULL)))
#define _g_uri_unref0(var) ((var == NULL) ? NULL : (var = (g_uri_unref (var), NULL)))
#define _secret_schema_unref0(var) ((var == NULL) ? NULL : (var = (secret_schema_unref (var), NULL)))
typedef struct _GitgParamSpecCredentialsManager GitgParamSpecCredentialsManager;

struct _GitgCredentialsManagerPrivate {
	GgitConfig* d_config;
	GtkWindow* d_window;
	GeeHashMap* d_usermap;
	gboolean d_save_user_in_config;
	gchar* d_last_user;
	GeeHashMap* d_auth_tried;
};

struct _Block5Data {
	int _ref_count_;
	GitgCredentialsManager* self;
	GMutex mutex;
	GCond cond;
	GtkResponseType response;
	gchar* password;
	gchar* newusername;
	GitgAuthenticationLifeTime lifetime;
	gchar* url;
	gchar* username;
};

struct _GitgParamSpecCredentialsManager {
	GParamSpec parent_instance;
};

static gint GitgCredentialsManager_private_offset;
static gpointer gitg_credentials_manager_parent_class = NULL;
static SecretSchema* gitg_credentials_manager_s_secret_schema;
static SecretSchema* gitg_credentials_manager_s_secret_schema = NULL;
static GRegex* gitg_credentials_manager_s_ssh_short_form;
static GRegex* gitg_credentials_manager_s_ssh_short_form = NULL;

static gchar* gitg_credentials_manager_lookup_user (GitgCredentialsManager* self,
                                             const gchar* host);
static gint _____lambda40_ (GitgCredentialsManager* self,
                     GMatchInfo* info,
                     const gchar* value);
static gint ______lambda40__ggit_config_match_callback (GMatchInfo* match_info,
                                                 const gchar* value,
                                                 gpointer self);
static GgitCred* gitg_credentials_manager_user_pass_dialog (GitgCredentialsManager* self,
                                                     const gchar* url,
                                                     const gchar* scheme,
                                                     const gchar* host,
                                                     const gchar* username,
                                                     GError** error);
static Block5Data* block5_data_ref (Block5Data* _data5_);
static void block5_data_unref (void * _userdata_);
static gboolean __lambda41_ (Block5Data* _data5_);
static gboolean ___lambda41__gsource_func (gpointer self);
static void _g_free0_ (gpointer var);
static void ___lambda42_ (GitgCredentialsManager* self,
                   GObject* obj,
                   GAsyncResult* res);
static void ____lambda42__gasync_ready_callback (GObject* source_object,
                                          GAsyncResult* res,
                                          gpointer self);
static void ___lambda43_ (GitgCredentialsManager* self,
                   GObject* obj,
                   GAsyncResult* res);
static void ____lambda43__gasync_ready_callback (GObject* source_object,
                                          GAsyncResult* res,
                                          gpointer self);
static GgitCred* gitg_credentials_manager_query_user_pass (GitgCredentialsManager* self,
                                                    const gchar* url,
                                                    const gchar* username,
                                                    GError** error);
static void gitg_credentials_manager_finalize (GitgCredentialsManager * obj);
static GType gitg_credentials_manager_get_type_once (void);
static void _vala_clear_GMutex (GMutex * mutex);
static void _vala_clear_GRecMutex (GRecMutex * mutex);
static void _vala_clear_GRWLock (GRWLock * mutex);
static void _vala_clear_GCond (GCond * mutex);

GQuark
gitg_credentials_error_quark (void)
{
	return g_quark_from_static_string ("gitg-credentials-error-quark");
}

 G_GNUC_NO_INLINE static GType
gitg_credentials_error_get_type_once (void)
{
	static const GEnumValue values[] = {{GITG_CREDENTIALS_ERROR_CANCELLED, "GITG_CREDENTIALS_ERROR_CANCELLED", "cancelled"}, {0, NULL, NULL}};
	GType gitg_credentials_error_type_id;
	gitg_credentials_error_type_id = g_enum_register_static ("GitgCredentialsError", values);
	return gitg_credentials_error_type_id;
}

GType
gitg_credentials_error_get_type (void)
{
	static gsize gitg_credentials_error_type_id__once = 0;
	if (g_once_init_enter (&gitg_credentials_error_type_id__once)) {
		GType gitg_credentials_error_type_id;
		gitg_credentials_error_type_id = gitg_credentials_error_get_type_once ();
		g_once_init_leave (&gitg_credentials_error_type_id__once, gitg_credentials_error_type_id);
	}
	return gitg_credentials_error_type_id__once;
}

static inline gpointer
gitg_credentials_manager_get_instance_private (GitgCredentialsManager* self)
{
	return G_STRUCT_MEMBER_P (self, GitgCredentialsManager_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

GitgCredentialsManager*
gitg_credentials_manager_construct (GType object_type,
                                    GgitConfig* config,
                                    GtkWindow* window,
                                    gboolean save_user_in_config)
{
	GitgCredentialsManager* self = NULL;
	GgitConfig* _tmp0_;
	GeeHashMap* _tmp1_;
	GtkWindow* _tmp2_;
	g_return_val_if_fail (window != NULL, NULL);
	self = (GitgCredentialsManager*) g_type_create_instance (object_type);
	_tmp0_ = _g_object_ref0 (config);
	_g_object_unref0 (self->priv->d_config);
	self->priv->d_config = _tmp0_;
	self->priv->d_save_user_in_config = save_user_in_config;
	_tmp1_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, ggit_credtype_get_type (), NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->d_auth_tried);
	self->priv->d_auth_tried = _tmp1_;
	_tmp2_ = _g_object_ref0 (window);
	_g_object_unref0 (self->priv->d_window);
	self->priv->d_window = _tmp2_;
	return self;
}

GitgCredentialsManager*
gitg_credentials_manager_new (GgitConfig* config,
                              GtkWindow* window,
                              gboolean save_user_in_config)
{
	return gitg_credentials_manager_construct (GITG_TYPE_CREDENTIALS_MANAGER, config, window, save_user_in_config);
}

static gint
_____lambda40_ (GitgCredentialsManager* self,
                GMatchInfo* info,
                const gchar* value)
{
	GeeHashMap* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gint result;
	g_return_val_if_fail (info != NULL, 0);
	g_return_val_if_fail (value != NULL, 0);
	_tmp0_ = self->priv->d_usermap;
	_tmp1_ = g_match_info_fetch (info, 1);
	_tmp2_ = _tmp1_;
	gee_abstract_map_set ((GeeAbstractMap*) _tmp0_, _tmp2_, value);
	_g_free0 (_tmp2_);
	result = 0;
	return result;
}

static gint
______lambda40__ggit_config_match_callback (GMatchInfo* match_info,
                                            const gchar* value,
                                            gpointer self)
{
	gint result;
	result = _____lambda40_ ((GitgCredentialsManager*) self, match_info, value);
	return result;
}

static gchar*
gitg_credentials_manager_lookup_user (GitgCredentialsManager* self,
                                      const gchar* host)
{
	GeeHashMap* _tmp0_;
	GeeHashMap* _tmp11_;
	gpointer _tmp12_;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (host != NULL, NULL);
	_tmp0_ = self->priv->d_usermap;
	if (_tmp0_ == NULL) {
		GeeHashMap* _tmp1_;
		GgitConfig* _tmp2_;
		_tmp1_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
		_g_object_unref0 (self->priv->d_usermap);
		self->priv->d_usermap = _tmp1_;
		_tmp2_ = self->priv->d_config;
		if (_tmp2_ != NULL) {
			{
				GRegex* r = NULL;
				GRegex* _tmp3_;
				GgitConfig* _tmp4_ = NULL;
				GgitConfig* _tmp5_;
				GgitConfig* _tmp6_;
				GRegex* _tmp7_;
				_tmp3_ = g_regex_new ("credential\\.(.*)\\.username", 0, 0, &_inner_error0_);
				r = _tmp3_;
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					goto __catch0_g_error;
				}
				_tmp5_ = self->priv->d_config;
				_tmp6_ = ggit_config_snapshot (_tmp5_, &_inner_error0_);
				_tmp4_ = _tmp6_;
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					_g_regex_unref0 (r);
					goto __catch0_g_error;
				}
				_tmp7_ = r;
				ggit_config_match_foreach (_tmp4_, _tmp7_, ______lambda40__ggit_config_match_callback, self, &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					_g_object_unref0 (_tmp4_);
					_g_regex_unref0 (r);
					goto __catch0_g_error;
				}
				_g_object_unref0 (_tmp4_);
				_g_regex_unref0 (r);
			}
			goto __finally0;
			__catch0_g_error:
			{
				GError* e = NULL;
				FILE* _tmp8_;
				GError* _tmp9_;
				const gchar* _tmp10_;
				e = _inner_error0_;
				_inner_error0_ = NULL;
				_tmp8_ = stderr;
				_tmp9_ = e;
				_tmp10_ = _tmp9_->message;
				fprintf (_tmp8_, "Could not get username from git config: %s\n", _tmp10_);
				_g_error_free0 (e);
			}
			__finally0:
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return NULL;
			}
		}
	}
	_tmp11_ = self->priv->d_usermap;
	_tmp12_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp11_, host);
	result = (gchar*) _tmp12_;
	return result;
}

static Block5Data*
block5_data_ref (Block5Data* _data5_)
{
	g_atomic_int_inc (&_data5_->_ref_count_);
	return _data5_;
}

static void
block5_data_unref (void * _userdata_)
{
	Block5Data* _data5_;
	_data5_ = (Block5Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data5_->_ref_count_)) {
		GitgCredentialsManager* self;
		self = _data5_->self;
		_g_free0 (_data5_->newusername);
		_g_free0 (_data5_->password);
		_vala_clear_GCond (&_data5_->cond);
		_vala_clear_GMutex (&_data5_->mutex);
		_g_free0 (_data5_->url);
		_g_free0 (_data5_->username);
		_gitg_credentials_manager_unref0 (self);
		g_slice_free (Block5Data, _data5_);
	}
}

static gboolean
__lambda41_ (Block5Data* _data5_)
{
	GitgCredentialsManager* self;
	GgitCredtype tried = 0U;
	GeeHashMap* _tmp0_;
	gpointer _tmp1_;
	GitgAuthenticationDialog* d = NULL;
	GitgAuthenticationDialog* _tmp2_;
	GitgAuthenticationDialog* _tmp3_;
	GtkWindow* _tmp4_;
	GitgAuthenticationDialog* _tmp5_;
	GitgAuthenticationDialog* _tmp17_;
	gboolean result;
	self = _data5_->self;
	_tmp0_ = self->priv->d_auth_tried;
	_tmp1_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp0_, _data5_->username);
	tried = ((GgitCredtype) ((gintptr) _tmp1_)) & (~GGIT_CREDTYPE_SSH_KEY);
	_tmp2_ = gitg_authentication_dialog_new (_data5_->url, _data5_->username, tried != 0);
	g_object_ref_sink (_tmp2_);
	d = _tmp2_;
	_tmp3_ = d;
	_tmp4_ = self->priv->d_window;
	gtk_window_set_transient_for ((GtkWindow*) _tmp3_, _tmp4_);
	_tmp5_ = d;
	_data5_->response = (GtkResponseType) gtk_dialog_run ((GtkDialog*) _tmp5_);
	if (_data5_->response == GTK_RESPONSE_OK) {
		GitgAuthenticationDialog* _tmp6_;
		const gchar* _tmp7_;
		const gchar* _tmp8_;
		gchar* _tmp9_;
		GitgAuthenticationDialog* _tmp10_;
		const gchar* _tmp11_;
		const gchar* _tmp12_;
		gchar* _tmp13_;
		GitgAuthenticationDialog* _tmp14_;
		GitgAuthenticationLifeTime _tmp15_;
		GitgAuthenticationLifeTime _tmp16_;
		_tmp6_ = d;
		_tmp7_ = gitg_authentication_dialog_get_username (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp9_ = g_strdup (_tmp8_);
		_g_free0 (_data5_->newusername);
		_data5_->newusername = _tmp9_;
		_tmp10_ = d;
		_tmp11_ = gitg_authentication_dialog_get_password (_tmp10_);
		_tmp12_ = _tmp11_;
		_tmp13_ = g_strdup (_tmp12_);
		_g_free0 (_data5_->password);
		_data5_->password = _tmp13_;
		_tmp14_ = d;
		_tmp15_ = gitg_authentication_dialog_get_life_time (_tmp14_);
		_tmp16_ = _tmp15_;
		_data5_->lifetime = _tmp16_;
	}
	_tmp17_ = d;
	gtk_widget_destroy ((GtkWidget*) _tmp17_);
	g_mutex_lock (&_data5_->mutex);
	g_cond_signal (&_data5_->cond);
	g_mutex_unlock (&_data5_->mutex);
	result = FALSE;
	_g_object_unref0 (d);
	return result;
}

static gboolean
___lambda41__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda41_ (self);
	return result;
}

static const gchar*
string_to_string (const gchar* self)
{
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}

static void
_g_free0_ (gpointer var)
{
	var = (g_free (var), NULL);
}

static gpointer
_g_hash_table_ref0 (gpointer self)
{
	return self ? g_hash_table_ref (self) : NULL;
}

static void
___lambda42_ (GitgCredentialsManager* self,
              GObject* obj,
              GAsyncResult* res)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (res != NULL);
	{
		secret_password_store_finish (res, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		FILE* _tmp0_;
		GError* _tmp1_;
		const gchar* _tmp2_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp0_ = stderr;
		_tmp1_ = e;
		_tmp2_ = _tmp1_->message;
		fprintf (_tmp0_, "Failed to store secret in keyring: %s\n", _tmp2_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
____lambda42__gasync_ready_callback (GObject* source_object,
                                     GAsyncResult* res,
                                     gpointer self)
{
	___lambda42_ ((GitgCredentialsManager*) self, source_object, res);
	gitg_credentials_manager_unref (self);
}

static void
___lambda43_ (GitgCredentialsManager* self,
              GObject* obj,
              GAsyncResult* res)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (res != NULL);
	{
		secret_password_clear_finish (res, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		FILE* _tmp0_;
		GError* _tmp1_;
		const gchar* _tmp2_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp0_ = stderr;
		_tmp1_ = e;
		_tmp2_ = _tmp1_->message;
		fprintf (_tmp0_, "Failed to clear secret from keyring: %s\n", _tmp2_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
____lambda43__gasync_ready_callback (GObject* source_object,
                                     GAsyncResult* res,
                                     gpointer self)
{
	___lambda43_ ((GitgCredentialsManager*) self, source_object, res);
	gitg_credentials_manager_unref (self);
}

static GgitCred*
gitg_credentials_manager_user_pass_dialog (GitgCredentialsManager* self,
                                           const gchar* url,
                                           const gchar* scheme,
                                           const gchar* host,
                                           const gchar* username,
                                           GError** error)
{
	Block5Data* _data5_;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	gboolean _tmp7_ = FALSE;
	GHashTable* attributes = NULL;
	GHashFunc _tmp29_;
	GEqualFunc _tmp30_;
	GHashTable* _tmp31_;
	GHashTable* _tmp32_;
	gchar* _tmp33_;
	gchar* _tmp34_;
	GHashTable* _tmp35_;
	gchar* _tmp36_;
	gchar* _tmp37_;
	GHashTable* _tmp38_;
	gchar* _tmp39_;
	const gchar* _tmp40_;
	gchar* _tmp41_;
	GeeHashMap* _tmp55_;
	const gchar* _tmp56_;
	GgitCredPlaintext* _tmp57_ = NULL;
	const gchar* _tmp58_;
	const gchar* _tmp59_;
	GgitCredPlaintext* _tmp60_;
	GgitCredPlaintext* _tmp61_;
	GError* _inner_error0_ = NULL;
	GgitCred* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (url != NULL, NULL);
	g_return_val_if_fail (scheme != NULL, NULL);
	g_return_val_if_fail (host != NULL, NULL);
	_data5_ = g_slice_new0 (Block5Data);
	_data5_->_ref_count_ = 1;
	_data5_->self = gitg_credentials_manager_ref (self);
	_tmp0_ = g_strdup (url);
	_g_free0 (_data5_->url);
	_data5_->url = _tmp0_;
	_tmp1_ = g_strdup (username);
	_g_free0 (_data5_->username);
	_data5_->username = _tmp1_;
	g_mutex_init (&_data5_->mutex);
	g_mutex_lock (&_data5_->mutex);
	g_cond_init (&_data5_->cond);
	_data5_->response = GTK_RESPONSE_CANCEL;
	_tmp2_ = g_strdup ("");
	_data5_->password = _tmp2_;
	_tmp3_ = g_strdup ("");
	_data5_->newusername = _tmp3_;
	_data5_->lifetime = GITG_AUTHENTICATION_LIFE_TIME_FORGET;
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ___lambda41__gsource_func, block5_data_ref (_data5_), block5_data_unref);
	g_cond_wait (&_data5_->cond, &_data5_->mutex);
	g_mutex_unlock (&_data5_->mutex);
	if (_data5_->response != GTK_RESPONSE_OK) {
		GError* _tmp4_;
		_tmp4_ = g_error_new_literal (GITG_CREDENTIALS_ERROR, GITG_CREDENTIALS_ERROR_CANCELLED, "cancelled by user");
		_inner_error0_ = _tmp4_;
		g_propagate_error (error, _inner_error0_);
		block5_data_unref (_data5_);
		_data5_ = NULL;
		return NULL;
	}
	_tmp5_ = _data5_->newusername;
	_tmp6_ = g_strdup (_tmp5_);
	_g_free0 (self->priv->d_last_user);
	self->priv->d_last_user = _tmp6_;
	if (_data5_->username == NULL) {
		_tmp7_ = TRUE;
	} else {
		gboolean _tmp8_ = FALSE;
		gboolean _tmp9_ = FALSE;
		const gchar* _tmp10_;
		_tmp10_ = _data5_->newusername;
		if (g_strcmp0 (_tmp10_, _data5_->username) != 0) {
			GgitConfig* _tmp11_;
			_tmp11_ = self->priv->d_config;
			_tmp9_ = _tmp11_ != NULL;
		} else {
			_tmp9_ = FALSE;
		}
		if (_tmp9_) {
			_tmp8_ = self->priv->d_save_user_in_config;
		} else {
			_tmp8_ = FALSE;
		}
		_tmp7_ = _tmp8_;
	}
	if (_tmp7_) {
		GeeHashMap* _tmp12_;
		_tmp12_ = self->priv->d_usermap;
		if (_tmp12_ == NULL) {
			GeeHashMap* _tmp13_;
			_tmp13_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
			_g_object_unref0 (self->priv->d_usermap);
			self->priv->d_usermap = _tmp13_;
		}
		{
			gchar* hid = NULL;
			const gchar* _tmp14_;
			const gchar* _tmp15_;
			gchar* _tmp16_;
			GgitConfig* _tmp17_;
			const gchar* _tmp18_;
			const gchar* _tmp19_;
			gchar* _tmp20_;
			gchar* _tmp21_;
			const gchar* _tmp22_;
			GeeHashMap* _tmp23_;
			const gchar* _tmp24_;
			const gchar* _tmp25_;
			_tmp14_ = string_to_string (scheme);
			_tmp15_ = string_to_string (host);
			_tmp16_ = g_strconcat (_tmp14_, "://", _tmp15_, NULL);
			hid = _tmp16_;
			_tmp17_ = self->priv->d_config;
			_tmp18_ = hid;
			_tmp19_ = string_to_string (_tmp18_);
			_tmp20_ = g_strconcat ("credential.", _tmp19_, ".username", NULL);
			_tmp21_ = _tmp20_;
			_tmp22_ = _data5_->newusername;
			ggit_config_set_string (_tmp17_, _tmp21_, _tmp22_, &_inner_error0_);
			_g_free0 (_tmp21_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_free0 (hid);
				goto __catch0_g_error;
			}
			_tmp23_ = self->priv->d_usermap;
			_tmp24_ = hid;
			_tmp25_ = _data5_->newusername;
			gee_abstract_map_set ((GeeAbstractMap*) _tmp23_, _tmp24_, _tmp25_);
			_g_free0 (hid);
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* e = NULL;
			FILE* _tmp26_;
			GError* _tmp27_;
			const gchar* _tmp28_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp26_ = stderr;
			_tmp27_ = e;
			_tmp28_ = _tmp27_->message;
			fprintf (_tmp26_, "Failed to store username in config: %s\n", _tmp28_);
			_g_error_free0 (e);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			block5_data_unref (_data5_);
			_data5_ = NULL;
			return NULL;
		}
	}
	_tmp29_ = g_str_hash;
	_tmp30_ = g_str_equal;
	_tmp31_ = g_hash_table_new_full (_tmp29_, _tmp30_, _g_free0_, _g_free0_);
	attributes = _tmp31_;
	_tmp32_ = attributes;
	_tmp33_ = g_strdup ("scheme");
	_tmp34_ = g_strdup (scheme);
	g_hash_table_insert (_tmp32_, _tmp33_, _tmp34_);
	_tmp35_ = attributes;
	_tmp36_ = g_strdup ("host");
	_tmp37_ = g_strdup (host);
	g_hash_table_insert (_tmp35_, _tmp36_, _tmp37_);
	_tmp38_ = attributes;
	_tmp39_ = g_strdup ("user");
	_tmp40_ = _data5_->newusername;
	_tmp41_ = g_strdup (_tmp40_);
	g_hash_table_insert (_tmp38_, _tmp39_, _tmp41_);
	if (_data5_->lifetime != GITG_AUTHENTICATION_LIFE_TIME_FORGET) {
		gchar* collection = NULL;
		SecretSchema* _tmp43_;
		GHashTable* _tmp44_;
		GHashTable* _tmp45_;
		const gchar* _tmp46_;
		const gchar* _tmp47_;
		const gchar* _tmp48_;
		gchar* _tmp49_;
		gchar* _tmp50_;
		const gchar* _tmp51_;
		collection = NULL;
		if (_data5_->lifetime == GITG_AUTHENTICATION_LIFE_TIME_SESSION) {
			gchar* _tmp42_;
			_tmp42_ = g_strdup (SECRET_COLLECTION_SESSION);
			_g_free0 (collection);
			collection = _tmp42_;
		}
		_tmp43_ = gitg_credentials_manager_s_secret_schema;
		_tmp44_ = attributes;
		_tmp45_ = _g_hash_table_ref0 (_tmp44_);
		_tmp46_ = collection;
		_tmp47_ = string_to_string (scheme);
		_tmp48_ = string_to_string (host);
		_tmp49_ = g_strconcat (_tmp47_, "://", _tmp48_, NULL);
		_tmp50_ = _tmp49_;
		_tmp51_ = _data5_->password;
		secret_password_storev (_tmp43_, _tmp45_, _tmp46_, _tmp50_, _tmp51_, NULL, ____lambda42__gasync_ready_callback, gitg_credentials_manager_ref (self));
		_g_free0 (_tmp50_);
		_g_free0 (collection);
	} else {
		SecretSchema* _tmp52_;
		GHashTable* _tmp53_;
		GHashTable* _tmp54_;
		_tmp52_ = gitg_credentials_manager_s_secret_schema;
		_tmp53_ = attributes;
		_tmp54_ = _g_hash_table_ref0 (_tmp53_);
		secret_password_clearv (_tmp52_, _tmp54_, NULL, ____lambda43__gasync_ready_callback, gitg_credentials_manager_ref (self));
	}
	_tmp55_ = self->priv->d_auth_tried;
	_tmp56_ = _data5_->newusername;
	gee_abstract_map_set ((GeeAbstractMap*) _tmp55_, _tmp56_, (gpointer) ((gintptr) GGIT_CREDTYPE_USERPASS_PLAINTEXT));
	_tmp58_ = _data5_->newusername;
	_tmp59_ = _data5_->password;
	_tmp60_ = ggit_cred_plaintext_new (_tmp58_, _tmp59_, &_inner_error0_);
	_tmp57_ = _tmp60_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_hash_table_unref0 (attributes);
		block5_data_unref (_data5_);
		_data5_ = NULL;
		return NULL;
	}
	_tmp61_ = _tmp57_;
	_tmp57_ = NULL;
	result = (GgitCred*) _tmp61_;
	_g_object_unref0 (_tmp57_);
	_g_hash_table_unref0 (attributes);
	block5_data_unref (_data5_);
	_data5_ = NULL;
	return result;
}

static gboolean
string_contains (const gchar* self,
                 const gchar* needle)
{
	gchar* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
	result = _tmp0_ != NULL;
	return result;
}

static GgitCred*
gitg_credentials_manager_query_user_pass (GitgCredentialsManager* self,
                                          const gchar* url,
                                          const gchar* username,
                                          GError** error)
{
	gchar* user = NULL;
	gchar* host = NULL;
	gchar* _tmp0_;
	gchar* scheme = NULL;
	gchar* _tmp1_;
	const gchar* _tmp31_;
	GError* _inner_error0_ = NULL;
	GgitCred* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (url != NULL, NULL);
	_tmp0_ = g_strdup ("local");
	host = _tmp0_;
	_tmp1_ = g_strdup ("file");
	scheme = _tmp1_;
	if (!string_contains (url, "://")) {
		GMatchInfo* minfo = NULL;
		GRegex* _tmp2_;
		GMatchInfo* _tmp3_ = NULL;
		gboolean _tmp4_;
		_tmp2_ = gitg_credentials_manager_s_ssh_short_form;
		_tmp4_ = g_regex_match (_tmp2_, url, 0, &_tmp3_);
		_g_match_info_unref0 (minfo);
		minfo = _tmp3_;
		if (_tmp4_) {
			gchar* _tmp5_;
			GMatchInfo* _tmp6_;
			gchar* _tmp7_;
			_tmp5_ = g_strdup ("ssh");
			_g_free0 (scheme);
			scheme = _tmp5_;
			_tmp6_ = minfo;
			_tmp7_ = g_match_info_fetch_named (_tmp6_, "host");
			_g_free0 (host);
			host = _tmp7_;
		}
		_g_match_info_unref0 (minfo);
	} else {
		GUri* uri = NULL;
		GUri* _tmp8_;
		GUri* _tmp9_;
		_tmp8_ = g_uri_parse (url, G_URI_FLAGS_NONE, &_inner_error0_);
		uri = _tmp8_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			_g_free0 (scheme);
			_g_free0 (host);
			_g_free0 (user);
			return NULL;
		}
		_tmp9_ = uri;
		if (_tmp9_ != NULL) {
			GUri* _tmp10_;
			const gchar* _tmp11_;
			gchar* _tmp12_;
			GUri* _tmp13_;
			GUri* _tmp20_;
			const gchar* _tmp21_;
			gchar* _tmp22_;
			_tmp10_ = uri;
			_tmp11_ = g_uri_get_host (_tmp10_);
			_tmp12_ = g_strdup (_tmp11_);
			_g_free0 (host);
			host = _tmp12_;
			_tmp13_ = uri;
			if (g_uri_get_port (_tmp13_) != -1) {
				const gchar* _tmp14_;
				const gchar* _tmp15_;
				GUri* _tmp16_;
				gchar* _tmp17_;
				gchar* _tmp18_;
				gchar* _tmp19_;
				_tmp14_ = host;
				_tmp15_ = string_to_string (_tmp14_);
				_tmp16_ = uri;
				_tmp17_ = g_strdup_printf ("%i", g_uri_get_port (_tmp16_));
				_tmp18_ = _tmp17_;
				_tmp19_ = g_strconcat (_tmp15_, ":", _tmp18_, NULL);
				_g_free0 (host);
				host = _tmp19_;
				_g_free0 (_tmp18_);
			}
			_tmp20_ = uri;
			_tmp21_ = g_uri_get_scheme (_tmp20_);
			_tmp22_ = g_strdup (_tmp21_);
			_g_free0 (scheme);
			scheme = _tmp22_;
		}
		_g_uri_unref0 (uri);
	}
	if (username == NULL) {
		const gchar* _tmp23_;
		const gchar* _tmp24_;
		const gchar* _tmp25_;
		const gchar* _tmp26_;
		gchar* _tmp27_;
		gchar* _tmp28_;
		gchar* _tmp29_;
		_tmp23_ = scheme;
		_tmp24_ = string_to_string (_tmp23_);
		_tmp25_ = host;
		_tmp26_ = string_to_string (_tmp25_);
		_tmp27_ = g_strconcat (_tmp24_, "://", _tmp26_, NULL);
		_tmp28_ = _tmp27_;
		_tmp29_ = gitg_credentials_manager_lookup_user (self, _tmp28_);
		_g_free0 (user);
		user = _tmp29_;
		_g_free0 (_tmp28_);
	} else {
		gchar* _tmp30_;
		_tmp30_ = g_strdup (username);
		_g_free0 (user);
		user = _tmp30_;
	}
	_tmp31_ = user;
	if (_tmp31_ != NULL) {
		GgitCredtype tried = 0U;
		GeeHashMap* _tmp32_;
		const gchar* _tmp33_;
		gpointer _tmp34_;
		_tmp32_ = self->priv->d_auth_tried;
		_tmp33_ = user;
		_tmp34_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp32_, _tmp33_);
		tried = (GgitCredtype) ((gintptr) _tmp34_);
		if ((tried & GGIT_CREDTYPE_USERPASS_PLAINTEXT) == 0) {
			gchar* secret = NULL;
			const gchar* _tmp42_;
			GeeHashMap* _tmp49_;
			const gchar* _tmp50_;
			secret = NULL;
			{
				gchar* _tmp35_ = NULL;
				SecretSchema* _tmp36_;
				const gchar* _tmp37_;
				const gchar* _tmp38_;
				const gchar* _tmp39_;
				gchar* _tmp40_;
				gchar* _tmp41_;
				_tmp36_ = gitg_credentials_manager_s_secret_schema;
				_tmp37_ = scheme;
				_tmp38_ = host;
				_tmp39_ = user;
				_tmp40_ = secret_password_lookup_sync (_tmp36_, NULL, &_inner_error0_, "scheme", _tmp37_, "host", _tmp38_, "user", _tmp39_, NULL);
				_tmp35_ = _tmp40_;
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					goto __catch0_g_error;
				}
				_tmp41_ = _tmp35_;
				_tmp35_ = NULL;
				_g_free0 (secret);
				secret = _tmp41_;
				_g_free0 (_tmp35_);
			}
			goto __finally0;
			__catch0_g_error:
			{
				g_clear_error (&_inner_error0_);
			}
			__finally0:
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				g_propagate_error (error, _inner_error0_);
				_g_free0 (secret);
				_g_free0 (scheme);
				_g_free0 (host);
				_g_free0 (user);
				return NULL;
			}
			_tmp42_ = secret;
			if (_tmp42_ == NULL) {
				GgitCred* _tmp43_ = NULL;
				const gchar* _tmp44_;
				const gchar* _tmp45_;
				const gchar* _tmp46_;
				GgitCred* _tmp47_;
				GgitCred* _tmp48_;
				_tmp44_ = scheme;
				_tmp45_ = host;
				_tmp46_ = user;
				_tmp47_ = gitg_credentials_manager_user_pass_dialog (self, url, _tmp44_, _tmp45_, _tmp46_, &_inner_error0_);
				_tmp43_ = _tmp47_;
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					g_propagate_error (error, _inner_error0_);
					_g_free0 (secret);
					_g_free0 (scheme);
					_g_free0 (host);
					_g_free0 (user);
					return NULL;
				}
				_tmp48_ = _tmp43_;
				_tmp43_ = NULL;
				result = _tmp48_;
				_g_object_unref0 (_tmp43_);
				_g_free0 (secret);
				_g_free0 (scheme);
				_g_free0 (host);
				_g_free0 (user);
				return result;
			}
			_tmp49_ = self->priv->d_auth_tried;
			_tmp50_ = user;
			gee_abstract_map_set ((GeeAbstractMap*) _tmp49_, _tmp50_, (gpointer) ((gintptr) GGIT_CREDTYPE_USERPASS_PLAINTEXT));
			{
				GgitCredPlaintext* _tmp51_ = NULL;
				const gchar* _tmp52_;
				const gchar* _tmp53_;
				GgitCredPlaintext* _tmp54_;
				GgitCredPlaintext* _tmp55_;
				_tmp52_ = user;
				_tmp53_ = secret;
				_tmp54_ = ggit_cred_plaintext_new (_tmp52_, _tmp53_, &_inner_error0_);
				_tmp51_ = _tmp54_;
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					goto __catch1_g_error;
				}
				_tmp55_ = _tmp51_;
				_tmp51_ = NULL;
				result = (GgitCred*) _tmp55_;
				_g_object_unref0 (_tmp51_);
				_g_free0 (secret);
				_g_free0 (scheme);
				_g_free0 (host);
				_g_free0 (user);
				return result;
			}
			goto __finally1;
			__catch1_g_error:
			{
				GgitCred* _tmp56_ = NULL;
				const gchar* _tmp57_;
				const gchar* _tmp58_;
				const gchar* _tmp59_;
				GgitCred* _tmp60_;
				GgitCred* _tmp61_;
				g_clear_error (&_inner_error0_);
				_tmp57_ = scheme;
				_tmp58_ = host;
				_tmp59_ = user;
				_tmp60_ = gitg_credentials_manager_user_pass_dialog (self, url, _tmp57_, _tmp58_, _tmp59_, &_inner_error0_);
				_tmp56_ = _tmp60_;
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					goto __finally1;
				}
				_tmp61_ = _tmp56_;
				_tmp56_ = NULL;
				result = _tmp61_;
				_g_object_unref0 (_tmp56_);
				_g_free0 (secret);
				_g_free0 (scheme);
				_g_free0 (host);
				_g_free0 (user);
				return result;
			}
			__finally1:
			g_propagate_error (error, _inner_error0_);
			_g_free0 (secret);
			_g_free0 (scheme);
			_g_free0 (host);
			_g_free0 (user);
			return NULL;
		} else {
			GgitCred* _tmp62_ = NULL;
			const gchar* _tmp63_;
			const gchar* _tmp64_;
			const gchar* _tmp65_;
			GgitCred* _tmp66_;
			GgitCred* _tmp67_;
			_tmp63_ = scheme;
			_tmp64_ = host;
			_tmp65_ = user;
			_tmp66_ = gitg_credentials_manager_user_pass_dialog (self, url, _tmp63_, _tmp64_, _tmp65_, &_inner_error0_);
			_tmp62_ = _tmp66_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				g_propagate_error (error, _inner_error0_);
				_g_free0 (scheme);
				_g_free0 (host);
				_g_free0 (user);
				return NULL;
			}
			_tmp67_ = _tmp62_;
			_tmp62_ = NULL;
			result = _tmp67_;
			_g_object_unref0 (_tmp62_);
			_g_free0 (scheme);
			_g_free0 (host);
			_g_free0 (user);
			return result;
		}
	} else {
		GgitCred* _tmp68_ = NULL;
		const gchar* _tmp69_;
		const gchar* _tmp70_;
		const gchar* _tmp71_;
		GgitCred* _tmp72_;
		GgitCred* _tmp73_;
		_tmp69_ = scheme;
		_tmp70_ = host;
		_tmp71_ = user;
		_tmp72_ = gitg_credentials_manager_user_pass_dialog (self, url, _tmp69_, _tmp70_, _tmp71_, &_inner_error0_);
		_tmp68_ = _tmp72_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			_g_free0 (scheme);
			_g_free0 (host);
			_g_free0 (user);
			return NULL;
		}
		_tmp73_ = _tmp68_;
		_tmp68_ = NULL;
		result = _tmp73_;
		_g_object_unref0 (_tmp68_);
		_g_free0 (scheme);
		_g_free0 (host);
		_g_free0 (user);
		return result;
	}
}

GgitCred*
gitg_credentials_manager_credentials (GitgCredentialsManager* self,
                                      const gchar* url,
                                      const gchar* username,
                                      GgitCredtype allowed_types,
                                      GError** error)
{
	const gchar* _tmp0_ = NULL;
	gchar* uslookup = NULL;
	gchar* _tmp1_;
	GgitCredtype tried = 0U;
	GeeHashMap* _tmp2_;
	const gchar* _tmp3_;
	gpointer _tmp4_;
	GgitCredtype untried_allowed_types = 0U;
	GError* _inner_error0_ = NULL;
	GgitCred* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (url != NULL, NULL);
	if (username != NULL) {
		_tmp0_ = username;
	} else {
		_tmp0_ = "";
	}
	_tmp1_ = g_strdup (_tmp0_);
	uslookup = _tmp1_;
	_tmp2_ = self->priv->d_auth_tried;
	_tmp3_ = uslookup;
	_tmp4_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp2_, _tmp3_);
	tried = (GgitCredtype) ((gintptr) _tmp4_);
	untried_allowed_types = allowed_types & (~tried);
	if ((untried_allowed_types & GGIT_CREDTYPE_SSH_KEY) != 0) {
		GeeHashMap* _tmp5_;
		const gchar* _tmp6_;
		GgitCredSshKeyFromAgent* _tmp7_ = NULL;
		GgitCredSshKeyFromAgent* _tmp8_;
		GgitCredSshKeyFromAgent* _tmp9_;
		_tmp5_ = self->priv->d_auth_tried;
		_tmp6_ = uslookup;
		gee_abstract_map_set ((GeeAbstractMap*) _tmp5_, _tmp6_, (gpointer) ((gintptr) (tried | GGIT_CREDTYPE_SSH_KEY)));
		_tmp8_ = ggit_cred_ssh_key_from_agent_new (username, &_inner_error0_);
		_tmp7_ = _tmp8_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			_g_free0 (uslookup);
			return NULL;
		}
		_tmp9_ = _tmp7_;
		_tmp7_ = NULL;
		result = (GgitCred*) _tmp9_;
		_g_object_unref0 (_tmp7_);
		_g_free0 (uslookup);
		return result;
	} else {
		if ((allowed_types & GGIT_CREDTYPE_USERPASS_PLAINTEXT) != 0) {
			GgitCred* _tmp10_ = NULL;
			GgitCred* _tmp11_;
			GgitCred* _tmp12_;
			_tmp11_ = gitg_credentials_manager_query_user_pass (self, url, username, &_inner_error0_);
			_tmp10_ = _tmp11_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				g_propagate_error (error, _inner_error0_);
				_g_free0 (uslookup);
				return NULL;
			}
			_tmp12_ = _tmp10_;
			_tmp10_ = NULL;
			result = _tmp12_;
			_g_object_unref0 (_tmp10_);
			_g_free0 (uslookup);
			return result;
		}
	}
	result = NULL;
	_g_free0 (uslookup);
	return result;
}

static void
gitg_value_credentials_manager_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
gitg_value_credentials_manager_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		gitg_credentials_manager_unref (value->data[0].v_pointer);
	}
}

static void
gitg_value_credentials_manager_copy_value (const GValue* src_value,
                                           GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = gitg_credentials_manager_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
gitg_value_credentials_manager_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
gitg_value_credentials_manager_collect_value (GValue* value,
                                              guint n_collect_values,
                                              GTypeCValue* collect_values,
                                              guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		GitgCredentialsManager * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = gitg_credentials_manager_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
gitg_value_credentials_manager_lcopy_value (const GValue* value,
                                            guint n_collect_values,
                                            GTypeCValue* collect_values,
                                            guint collect_flags)
{
	GitgCredentialsManager ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = gitg_credentials_manager_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
gitg_param_spec_credentials_manager (const gchar* name,
                                     const gchar* nick,
                                     const gchar* blurb,
                                     GType object_type,
                                     GParamFlags flags)
{
	GitgParamSpecCredentialsManager* spec;
	g_return_val_if_fail (g_type_is_a (object_type, GITG_TYPE_CREDENTIALS_MANAGER), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
gitg_value_get_credentials_manager (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GITG_TYPE_CREDENTIALS_MANAGER), NULL);
	return value->data[0].v_pointer;
}

void
gitg_value_set_credentials_manager (GValue* value,
                                    gpointer v_object)
{
	GitgCredentialsManager * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GITG_TYPE_CREDENTIALS_MANAGER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, GITG_TYPE_CREDENTIALS_MANAGER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		gitg_credentials_manager_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		gitg_credentials_manager_unref (old);
	}
}

void
gitg_value_take_credentials_manager (GValue* value,
                                     gpointer v_object)
{
	GitgCredentialsManager * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GITG_TYPE_CREDENTIALS_MANAGER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, GITG_TYPE_CREDENTIALS_MANAGER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		gitg_credentials_manager_unref (old);
	}
}

static void
gitg_credentials_manager_class_init (GitgCredentialsManagerClass * klass,
                                     gpointer klass_data)
{
	SecretSchema* _tmp0_;
	GError* _inner_error0_ = NULL;
	gitg_credentials_manager_parent_class = g_type_class_peek_parent (klass);
	((GitgCredentialsManagerClass *) klass)->finalize = gitg_credentials_manager_finalize;
	g_type_class_adjust_private_offset (klass, &GitgCredentialsManager_private_offset);
	_tmp0_ = secret_schema_new (APPLICATION_ID ".Credentials", SECRET_SCHEMA_NONE, "scheme", SECRET_SCHEMA_ATTRIBUTE_STRING, "host", SECRET_SCHEMA_ATTRIBUTE_STRING, "user", SECRET_SCHEMA_ATTRIBUTE_STRING, NULL);
	_secret_schema_unref0 (gitg_credentials_manager_s_secret_schema);
	gitg_credentials_manager_s_secret_schema = _tmp0_;
	{
		GRegex* _tmp1_ = NULL;
		GRegex* _tmp2_;
		GRegex* _tmp3_;
		_tmp2_ = g_regex_new ("^(?:[^: /@]+)@(?P<host>[^:]+)", 0, 0, &_inner_error0_);
		_tmp1_ = _tmp2_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp3_ = _tmp1_;
		_tmp1_ = NULL;
		_g_regex_unref0 (gitg_credentials_manager_s_ssh_short_form);
		gitg_credentials_manager_s_ssh_short_form = _tmp3_;
		_g_regex_unref0 (_tmp1_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		FILE* _tmp4_;
		GError* _tmp5_;
		const gchar* _tmp6_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp4_ = stderr;
		_tmp5_ = e;
		_tmp6_ = _tmp5_->message;
		fprintf (_tmp4_, "regex err: %s\n", _tmp6_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
	}
}

static void
gitg_credentials_manager_instance_init (GitgCredentialsManager * self,
                                        gpointer klass)
{
	self->priv = gitg_credentials_manager_get_instance_private (self);
	self->ref_count = 1;
}

static void
gitg_credentials_manager_finalize (GitgCredentialsManager * obj)
{
	GitgCredentialsManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GITG_TYPE_CREDENTIALS_MANAGER, GitgCredentialsManager);
	g_signal_handlers_destroy (self);
	_g_object_unref0 (self->priv->d_config);
	_g_object_unref0 (self->priv->d_window);
	_g_object_unref0 (self->priv->d_usermap);
	_g_free0 (self->priv->d_last_user);
	_g_object_unref0 (self->priv->d_auth_tried);
}

 G_GNUC_NO_INLINE static GType
gitg_credentials_manager_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { gitg_value_credentials_manager_init, gitg_value_credentials_manager_free_value, gitg_value_credentials_manager_copy_value, gitg_value_credentials_manager_peek_pointer, "p", gitg_value_credentials_manager_collect_value, "p", gitg_value_credentials_manager_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (GitgCredentialsManagerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gitg_credentials_manager_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GitgCredentialsManager), 0, (GInstanceInitFunc) gitg_credentials_manager_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType gitg_credentials_manager_type_id;
	gitg_credentials_manager_type_id = g_type_register_fundamental (g_type_fundamental_next (), "GitgCredentialsManager", &g_define_type_info, &g_define_type_fundamental_info, 0);
	GitgCredentialsManager_private_offset = g_type_add_instance_private (gitg_credentials_manager_type_id, sizeof (GitgCredentialsManagerPrivate));
	return gitg_credentials_manager_type_id;
}

GType
gitg_credentials_manager_get_type (void)
{
	static gsize gitg_credentials_manager_type_id__once = 0;
	if (g_once_init_enter (&gitg_credentials_manager_type_id__once)) {
		GType gitg_credentials_manager_type_id;
		gitg_credentials_manager_type_id = gitg_credentials_manager_get_type_once ();
		g_once_init_leave (&gitg_credentials_manager_type_id__once, gitg_credentials_manager_type_id);
	}
	return gitg_credentials_manager_type_id__once;
}

gpointer
gitg_credentials_manager_ref (gpointer instance)
{
	GitgCredentialsManager * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
gitg_credentials_manager_unref (gpointer instance)
{
	GitgCredentialsManager * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		GITG_CREDENTIALS_MANAGER_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static void
_vala_clear_GMutex (GMutex * mutex)
{
	GMutex zero_mutex = { 0 };
	if (memcmp (mutex, &zero_mutex, sizeof (GMutex))) {
		g_mutex_clear (mutex);
		memset (mutex, 0, sizeof (GMutex));
	}
}

static void
_vala_clear_GRecMutex (GRecMutex * mutex)
{
	GRecMutex zero_mutex = { 0 };
	if (memcmp (mutex, &zero_mutex, sizeof (GRecMutex))) {
		g_rec_mutex_clear (mutex);
		memset (mutex, 0, sizeof (GRecMutex));
	}
}

static void
_vala_clear_GRWLock (GRWLock * mutex)
{
	GRWLock zero_mutex = { 0 };
	if (memcmp (mutex, &zero_mutex, sizeof (GRWLock))) {
		g_rw_lock_clear (mutex);
		memset (mutex, 0, sizeof (GRWLock));
	}
}

static void
_vala_clear_GCond (GCond * mutex)
{
	GCond zero_mutex = { 0 };
	if (memcmp (mutex, &zero_mutex, sizeof (GCond))) {
		g_cond_clear (mutex);
		memset (mutex, 0, sizeof (GCond));
	}
}

