/* media-manager.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from media-manager.vala, do not modify */

/* This file is part of GNOME Boxes. License: LGPLv2+*/

#include <glib-object.h>
#include <gtk/gtk.h>
#include <gudev/gudev.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gio/gio.h>
#include <glib/gi18n-lib.h>
#include <libvirt-gconfig/libvirt-gconfig.h>
#include <osinfo/osinfo.h>
#include "common.h"

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define BOXES_TYPE_MEDIA_MANAGER (boxes_media_manager_get_type ())
#define BOXES_MEDIA_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BOXES_TYPE_MEDIA_MANAGER, BoxesMediaManager))
#define BOXES_MEDIA_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BOXES_TYPE_MEDIA_MANAGER, BoxesMediaManagerClass))
#define BOXES_IS_MEDIA_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BOXES_TYPE_MEDIA_MANAGER))
#define BOXES_IS_MEDIA_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BOXES_TYPE_MEDIA_MANAGER))
#define BOXES_MEDIA_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BOXES_TYPE_MEDIA_MANAGER, BoxesMediaManagerClass))

typedef struct _BoxesMediaManager BoxesMediaManager;
typedef struct _BoxesMediaManagerClass BoxesMediaManagerClass;
typedef struct _BoxesMediaManagerPrivate BoxesMediaManagerPrivate;

#define BOXES_TYPE_OS_DATABASE (boxes_os_database_get_type ())
#define BOXES_OS_DATABASE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BOXES_TYPE_OS_DATABASE, BoxesOSDatabase))
#define BOXES_OS_DATABASE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BOXES_TYPE_OS_DATABASE, BoxesOSDatabaseClass))
#define BOXES_IS_OS_DATABASE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BOXES_TYPE_OS_DATABASE))
#define BOXES_IS_OS_DATABASE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BOXES_TYPE_OS_DATABASE))
#define BOXES_OS_DATABASE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BOXES_TYPE_OS_DATABASE, BoxesOSDatabaseClass))

typedef struct _BoxesOSDatabase BoxesOSDatabase;
typedef struct _BoxesOSDatabaseClass BoxesOSDatabaseClass;
enum  {
	BOXES_MEDIA_MANAGER_0_PROPERTY,
	BOXES_MEDIA_MANAGER_OS_DB_PROPERTY,
	BOXES_MEDIA_MANAGER_CONTENT_TYPES_FILTER_PROPERTY,
	BOXES_MEDIA_MANAGER_CLIENT_PROPERTY,
	BOXES_MEDIA_MANAGER_NUM_PROPERTIES
};
static GParamSpec* boxes_media_manager_properties[BOXES_MEDIA_MANAGER_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define BOXES_TYPE_INSTALLER_MEDIA (boxes_installer_media_get_type ())
#define BOXES_INSTALLER_MEDIA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BOXES_TYPE_INSTALLER_MEDIA, BoxesInstallerMedia))
#define BOXES_INSTALLER_MEDIA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BOXES_TYPE_INSTALLER_MEDIA, BoxesInstallerMediaClass))
#define BOXES_IS_INSTALLER_MEDIA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BOXES_TYPE_INSTALLER_MEDIA))
#define BOXES_IS_INSTALLER_MEDIA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BOXES_TYPE_INSTALLER_MEDIA))
#define BOXES_INSTALLER_MEDIA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BOXES_TYPE_INSTALLER_MEDIA, BoxesInstallerMediaClass))

typedef struct _BoxesInstallerMedia BoxesInstallerMedia;
typedef struct _BoxesInstallerMediaClass BoxesInstallerMediaClass;

#define BOXES_TYPE_INSTALLED_MEDIA (boxes_installed_media_get_type ())
#define BOXES_INSTALLED_MEDIA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BOXES_TYPE_INSTALLED_MEDIA, BoxesInstalledMedia))
#define BOXES_INSTALLED_MEDIA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BOXES_TYPE_INSTALLED_MEDIA, BoxesInstalledMediaClass))
#define BOXES_IS_INSTALLED_MEDIA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BOXES_TYPE_INSTALLED_MEDIA))
#define BOXES_IS_INSTALLED_MEDIA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BOXES_TYPE_INSTALLED_MEDIA))
#define BOXES_INSTALLED_MEDIA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BOXES_TYPE_INSTALLED_MEDIA, BoxesInstalledMediaClass))

typedef struct _BoxesInstalledMedia BoxesInstalledMedia;
typedef struct _BoxesInstalledMediaClass BoxesInstalledMediaClass;
typedef struct _BoxesMediaManagerCreateInstallerMediaForPathData BoxesMediaManagerCreateInstallerMediaForPathData;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define BOXES_TYPE_LIBVIRT_MEDIA (boxes_libvirt_media_get_type ())
#define BOXES_LIBVIRT_MEDIA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BOXES_TYPE_LIBVIRT_MEDIA, BoxesLibvirtMedia))
#define BOXES_LIBVIRT_MEDIA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BOXES_TYPE_LIBVIRT_MEDIA, BoxesLibvirtMediaClass))
#define BOXES_IS_LIBVIRT_MEDIA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BOXES_TYPE_LIBVIRT_MEDIA))
#define BOXES_IS_LIBVIRT_MEDIA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BOXES_TYPE_LIBVIRT_MEDIA))
#define BOXES_LIBVIRT_MEDIA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BOXES_TYPE_LIBVIRT_MEDIA, BoxesLibvirtMediaClass))

typedef struct _BoxesLibvirtMedia BoxesLibvirtMedia;
typedef struct _BoxesLibvirtMediaClass BoxesLibvirtMediaClass;

#define BOXES_TYPE_LIBVIRT_CLONED_MEDIA (boxes_libvirt_cloned_media_get_type ())
#define BOXES_LIBVIRT_CLONED_MEDIA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BOXES_TYPE_LIBVIRT_CLONED_MEDIA, BoxesLibvirtClonedMedia))
#define BOXES_LIBVIRT_CLONED_MEDIA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BOXES_TYPE_LIBVIRT_CLONED_MEDIA, BoxesLibvirtClonedMediaClass))
#define BOXES_IS_LIBVIRT_CLONED_MEDIA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BOXES_TYPE_LIBVIRT_CLONED_MEDIA))
#define BOXES_IS_LIBVIRT_CLONED_MEDIA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BOXES_TYPE_LIBVIRT_CLONED_MEDIA))
#define BOXES_LIBVIRT_CLONED_MEDIA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BOXES_TYPE_LIBVIRT_CLONED_MEDIA, BoxesLibvirtClonedMediaClass))

typedef struct _BoxesLibvirtClonedMedia BoxesLibvirtClonedMedia;
typedef struct _BoxesLibvirtClonedMediaClass BoxesLibvirtClonedMediaClass;

#define BOXES_TYPE_OS_DATABASE_ERROR (boxes_os_database_error_get_type ())
typedef struct _BoxesMediaManagerCreateInstallerMediaFromConfigData BoxesMediaManagerCreateInstallerMediaFromConfigData;
typedef struct _BoxesMediaManagerLoadPhysicalMediasData BoxesMediaManagerLoadPhysicalMediasData;
typedef struct _BoxesInstallerMediaPrivate BoxesInstallerMediaPrivate;

#define BOXES_TYPE_VM_CREATOR (boxes_vm_creator_get_type ())
#define BOXES_VM_CREATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BOXES_TYPE_VM_CREATOR, BoxesVMCreator))
#define BOXES_VM_CREATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BOXES_TYPE_VM_CREATOR, BoxesVMCreatorClass))
#define BOXES_IS_VM_CREATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BOXES_TYPE_VM_CREATOR))
#define BOXES_IS_VM_CREATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BOXES_TYPE_VM_CREATOR))
#define BOXES_VM_CREATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BOXES_TYPE_VM_CREATOR, BoxesVMCreatorClass))

typedef struct _BoxesVMCreator BoxesVMCreator;
typedef struct _BoxesVMCreatorClass BoxesVMCreatorClass;

#define BOXES_TYPE_UNATTENDED_INSTALLER (boxes_unattended_installer_get_type ())
#define BOXES_UNATTENDED_INSTALLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BOXES_TYPE_UNATTENDED_INSTALLER, BoxesUnattendedInstaller))
#define BOXES_UNATTENDED_INSTALLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BOXES_TYPE_UNATTENDED_INSTALLER, BoxesUnattendedInstallerClass))
#define BOXES_IS_UNATTENDED_INSTALLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BOXES_TYPE_UNATTENDED_INSTALLER))
#define BOXES_IS_UNATTENDED_INSTALLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BOXES_TYPE_UNATTENDED_INSTALLER))
#define BOXES_UNATTENDED_INSTALLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BOXES_TYPE_UNATTENDED_INSTALLER, BoxesUnattendedInstallerClass))

typedef struct _BoxesUnattendedInstaller BoxesUnattendedInstaller;
typedef struct _BoxesUnattendedInstallerClass BoxesUnattendedInstallerClass;
typedef void (*BoxesMediaManagerInstallerRecognized) (OsinfoMedia* os_media, OsinfoOs* os, gpointer user_data);

struct _BoxesMediaManager {
	GObject parent_instance;
	BoxesMediaManagerPrivate * priv;
};

struct _BoxesMediaManagerClass {
	GObjectClass parent_class;
};

struct _BoxesMediaManagerPrivate {
	BoxesOSDatabase* _os_db;
	GtkFileFilter* _content_types_filter;
	GUdevClient* _client;
};

struct _BoxesMediaManagerCreateInstallerMediaForPathData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	BoxesMediaManager* self;
	gchar* path;
	GCancellable* cancellable;
	BoxesInstallerMedia* result;
	BoxesInstallerMedia* media;
	BoxesInstallerMedia* _tmp0_;
	BoxesInstallerMedia* _tmp1_;
	BoxesInstallerMedia* _tmp2_;
	gboolean _tmp3_;
	BoxesInstalledMedia* _tmp4_;
	BoxesInstallerMedia* _tmp5_;
	GError* _tmp6_;
	GError* _inner_error0_;
};

typedef enum  {
	BOXES_OS_DATABASE_ERROR_NON_BOOTABLE,
	BOXES_OS_DATABASE_ERROR_DB_LOADING_FAILED,
	BOXES_OS_DATABASE_ERROR_UNKNOWN_OS_ID,
	BOXES_OS_DATABASE_ERROR_UNKNOWN_MEDIA_ID
} BoxesOSDatabaseError;
#define BOXES_OS_DATABASE_ERROR boxes_os_database_error_quark ()

struct _BoxesMediaManagerCreateInstallerMediaFromConfigData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	BoxesMediaManager* self;
	GVirConfigDomain* config;
	BoxesInstallerMedia* result;
	gchar* path;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	BoxesInstalledMedia* _tmp4_;
	BoxesLibvirtMedia* _tmp5_;
	const gchar* _tmp6_;
	BoxesLibvirtMedia* _tmp7_;
	BoxesLibvirtMedia* _tmp8_;
	BoxesLibvirtClonedMedia* _tmp9_;
	const gchar* _tmp10_;
	BoxesLibvirtClonedMedia* _tmp11_;
	BoxesLibvirtClonedMedia* _tmp12_;
	GError* _error_;
	GError* _tmp13_;
	const gchar* _tmp14_;
	gchar* label;
	const gchar* _tmp15_;
	const gchar* _tmp16_;
	gchar* _tmp17_;
	OsinfoOs* os;
	OsinfoMedia* os_media;
	gchar* os_id;
	gchar* _tmp18_;
	const gchar* _tmp19_;
	OsinfoOs* _tmp20_;
	BoxesOSDatabase* _tmp21_;
	const gchar* _tmp22_;
	OsinfoOs* _tmp23_;
	OsinfoOs* _tmp24_;
	gchar* media_id;
	gchar* _tmp25_;
	const gchar* _tmp26_;
	OsinfoMedia* _tmp27_;
	BoxesOSDatabase* _tmp28_;
	OsinfoOs* _tmp29_;
	const gchar* _tmp30_;
	OsinfoMedia* _tmp31_;
	OsinfoMedia* _tmp32_;
	GError* _vala1__error_;
	GError* _tmp33_;
	const gchar* _tmp34_;
	gchar* _tmp35_;
	OsinfoMedia* _tmp36_;
	OsinfoMedia* _tmp37_;
	gchar* _tmp38_;
	gchar* _tmp39_;
	gchar* architecture;
	gchar* _tmp40_;
	OsinfoResources* resources;
	BoxesOSDatabase* _tmp41_;
	OsinfoOs* _tmp42_;
	const gchar* _tmp43_;
	OsinfoResources* _tmp44_;
	BoxesInstallerMedia* media;
	const gchar* _tmp45_;
	const gchar* _tmp46_;
	OsinfoOs* _tmp47_;
	OsinfoMedia* _tmp48_;
	OsinfoResources* _tmp49_;
	BoxesInstallerMedia* _tmp50_;
	BoxesInstallerMedia* _tmp51_;
	BoxesInstallerMedia* _tmp52_;
	BoxesInstallerMedia* _tmp53_;
	BoxesInstallerMedia* _tmp54_;
	BoxesInstallerMedia* _tmp55_;
	GError* _vala2__error_;
	GError* _tmp56_;
	const gchar* _tmp57_;
	GError* _inner_error0_;
};

struct _BoxesMediaManagerLoadPhysicalMediasData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	BoxesMediaManager* self;
	GList* result;
	GList* list;
	GUdevEnumerator* enumerator;
	GUdevClient* _tmp0_;
	GUdevClient* _tmp1_;
	GUdevEnumerator* _tmp2_;
	GUdevEnumerator* _tmp3_;
	GUdevEnumerator* _tmp4_;
	GList* _tmp5_;
	GList* device_collection;
	GList* device_it;
	GUdevDevice* _tmp6_;
	GUdevDevice* device;
	gboolean _tmp7_;
	GUdevDevice* _tmp8_;
	const gchar* _tmp9_;
	GUdevDevice* _tmp10_;
	gchar* path;
	GUdevDevice* _tmp11_;
	const gchar* _tmp12_;
	gchar* _tmp13_;
	GFile* file;
	const gchar* _tmp14_;
	GFile* _tmp15_;
	GFileInfo* info;
	GFile* _tmp16_;
	GFileInfo* _tmp17_;
	GFileInfo* _tmp18_;
	const gchar* _tmp19_;
	BoxesInstallerMedia* media;
	const gchar* _tmp20_;
	BoxesInstallerMedia* _tmp21_;
	BoxesInstallerMedia* _tmp22_;
	BoxesInstallerMedia* _tmp23_;
	BoxesInstallerMedia* _tmp24_;
	GError* _error_;
	const gchar* _tmp25_;
	GError* _tmp26_;
	const gchar* _tmp27_;
	GError* _inner_error0_;
};

struct _BoxesInstallerMedia {
	GObject parent_instance;
	BoxesInstallerMediaPrivate * priv;
	OsinfoOs* os;
	OsinfoResources* resources;
	OsinfoMedia* os_media;
	gchar* label;
	gchar* device_file;
	gchar* mount_point;
	gboolean from_image;
};

struct _BoxesInstallerMediaClass {
	GObjectClass parent_class;
	void (*set_direct_boot_params) (BoxesInstallerMedia* self, GVirConfigDomainOs* os);
	void (*prepare) (BoxesInstallerMedia* self, BoxesActivityProgress* progress, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	gboolean (*prepare_finish) (BoxesInstallerMedia* self, GAsyncResult* _res_);
	void (*prepare_for_installation) (BoxesInstallerMedia* self, const gchar* vm_name, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*prepare_for_installation_finish) (BoxesInstallerMedia* self, GAsyncResult* _res_);
	void (*prepare_to_continue_installation) (BoxesInstallerMedia* self, const gchar* vm_name);
	void (*clean_up) (BoxesInstallerMedia* self);
	void (*clean_up_preparation_cache) (BoxesInstallerMedia* self);
	void (*setup_domain_config) (BoxesInstallerMedia* self, GVirConfigDomain* domain);
	void (*setup_post_install_domain_config) (BoxesInstallerMedia* self, GVirConfigDomain* domain);
	BoxesVMCreator* (*get_vm_creator) (BoxesInstallerMedia* self);
	OsinfoDeviceList* (*get_supported_devices) (BoxesInstallerMedia* self);
	guint64 (*get_installed_size) (BoxesInstallerMedia* self);
	gboolean (*get_need_user_input_for_vm_creation) (BoxesInstallerMedia* self);
	gboolean (*get_prefers_q35) (BoxesInstallerMedia* self);
	gboolean (*get_prefers_ich9) (BoxesInstallerMedia* self);
	gboolean (*get_live) (BoxesInstallerMedia* self);
	gboolean (*get_eject_after_install) (BoxesInstallerMedia* self);
	gchar* (*get_architecture) (BoxesInstallerMedia* self);
};

static gint BoxesMediaManager_private_offset;
static gpointer boxes_media_manager_parent_class = NULL;
static BoxesMediaManager* boxes_media_manager_media_manager;
static BoxesMediaManager* boxes_media_manager_media_manager = NULL;

VALA_EXTERN GType boxes_media_manager_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BoxesMediaManager, g_object_unref)
VALA_EXTERN GType boxes_os_database_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BoxesOSDatabase, g_object_unref)
VALA_EXTERN BoxesMediaManager* boxes_media_manager_get_default (void);
static BoxesMediaManager* boxes_media_manager_new (void);
static BoxesMediaManager* boxes_media_manager_construct (GType object_type);
static void boxes_media_manager_create_installer_media_for_path_data_free (gpointer _data);
VALA_EXTERN GType boxes_installer_media_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BoxesInstallerMedia, g_object_unref)
VALA_EXTERN void boxes_media_manager_create_installer_media_for_path (BoxesMediaManager* self,
                                                          const gchar* path,
                                                          GCancellable* cancellable,
                                                          GAsyncReadyCallback _callback_,
                                                          gpointer _user_data_);
VALA_EXTERN BoxesInstallerMedia* boxes_media_manager_create_installer_media_for_path_finish (BoxesMediaManager* self,
                                                                                 GAsyncResult* _res_,
                                                                                 GError** error);
static gboolean boxes_media_manager_create_installer_media_for_path_co (BoxesMediaManagerCreateInstallerMediaForPathData* _data_);
static gboolean boxes_media_manager_path_is_installer_media (BoxesMediaManager* self,
                                                      const gchar* path);
VALA_EXTERN void boxes_installer_media_new_for_path (const gchar* path,
                                         GCancellable* cancellable,
                                         GAsyncReadyCallback _callback_,
                                         gpointer _user_data_);
VALA_EXTERN BoxesInstallerMedia* boxes_installer_media_new_for_path_finish (GAsyncResult* _res_,
                                                                GError** error);
VALA_EXTERN void boxes_installer_media_construct_for_path (GType object_type,
                                               const gchar* path,
                                               GCancellable* cancellable,
                                               GAsyncReadyCallback _callback_,
                                               gpointer _user_data_);
VALA_EXTERN BoxesInstallerMedia* boxes_installer_media_construct_for_path_finish (GAsyncResult* _res_,
                                                                      GError** error);
static void boxes_media_manager_create_installer_media_for_path_ready (GObject* source_object,
                                                                GAsyncResult* _res_,
                                                                gpointer _user_data_);
static gboolean boxes_media_manager_path_is_installed_media (BoxesMediaManager* self,
                                                      const gchar* path);
static gboolean boxes_media_manager_path_needs_import (BoxesMediaManager* self,
                                                const gchar* path);
VALA_EXTERN BoxesInstalledMedia* boxes_installed_media_new (const gchar* path,
                                                gboolean skip_import);
VALA_EXTERN BoxesInstalledMedia* boxes_installed_media_construct (GType object_type,
                                                      const gchar* path,
                                                      gboolean skip_import);
VALA_EXTERN GType boxes_installed_media_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BoxesInstalledMedia, g_object_unref)
VALA_EXTERN gboolean boxes_media_manager_media_matches_content_type (BoxesMediaManager* self,
                                                         const gchar* path,
                                                         gchar** supported_content_types,
                                                         gint supported_content_types_length1);
VALA_EXTERN gboolean boxes_media_manager_path_is_compressed (BoxesMediaManager* self,
                                                 const gchar* path);
static void boxes_media_manager_create_installer_media_from_config_data_free (gpointer _data);
VALA_EXTERN void boxes_media_manager_create_installer_media_from_config (BoxesMediaManager* self,
                                                             GVirConfigDomain* config,
                                                             GAsyncReadyCallback _callback_,
                                                             gpointer _user_data_);
VALA_EXTERN BoxesInstallerMedia* boxes_media_manager_create_installer_media_from_config_finish (BoxesMediaManager* self,
                                                                                    GAsyncResult* _res_);
static gboolean boxes_media_manager_create_installer_media_from_config_co (BoxesMediaManagerCreateInstallerMediaFromConfigData* _data_);
VALA_EXTERN gchar* boxes_vm_configurator_get_source_media_path (GVirConfigDomain* domain);
VALA_EXTERN gboolean boxes_vm_configurator_is_import_config (GVirConfigDomain* domain);
VALA_EXTERN gboolean boxes_vm_configurator_is_libvirt_system_import_config (GVirConfigDomain* domain);
VALA_EXTERN GType boxes_libvirt_media_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BoxesLibvirtMedia, g_object_unref)
VALA_EXTERN BoxesLibvirtMedia* boxes_libvirt_media_new (const gchar* path,
                                            GVirConfigDomain* domain_config,
                                            gboolean skip_import,
                                            GError** error);
VALA_EXTERN BoxesLibvirtMedia* boxes_libvirt_media_construct (GType object_type,
                                                  const gchar* path,
                                                  GVirConfigDomain* domain_config,
                                                  gboolean skip_import,
                                                  GError** error);
VALA_EXTERN gboolean boxes_vm_configurator_is_libvirt_cloning_config (GVirConfigDomain* domain);
VALA_EXTERN GType boxes_libvirt_cloned_media_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BoxesLibvirtClonedMedia, g_object_unref)
VALA_EXTERN BoxesLibvirtClonedMedia* boxes_libvirt_cloned_media_new (const gchar* path,
                                                         GVirConfigDomain* domain_config,
                                                         GError** error);
VALA_EXTERN BoxesLibvirtClonedMedia* boxes_libvirt_cloned_media_construct (GType object_type,
                                                               const gchar* path,
                                                               GVirConfigDomain* domain_config,
                                                               GError** error);
VALA_EXTERN gchar* boxes_vm_configurator_get_os_id (GVirConfigDomain* domain);
VALA_EXTERN BoxesOSDatabase* boxes_media_manager_get_os_db (BoxesMediaManager* self);
VALA_EXTERN void boxes_os_database_get_os_by_id (BoxesOSDatabase* self,
                                     const gchar* id,
                                     GAsyncReadyCallback _callback_,
                                     gpointer _user_data_);
VALA_EXTERN GQuark boxes_os_database_error_quark (void);
VALA_EXTERN GType boxes_os_database_error_get_type (void) G_GNUC_CONST ;
VALA_EXTERN OsinfoOs* boxes_os_database_get_os_by_id_finish (BoxesOSDatabase* self,
                                                 GAsyncResult* _res_,
                                                 GError** error);
static void boxes_media_manager_create_installer_media_from_config_ready (GObject* source_object,
                                                                   GAsyncResult* _res_,
                                                                   gpointer _user_data_);
VALA_EXTERN gchar* boxes_vm_configurator_get_os_media_id (GVirConfigDomain* domain);
VALA_EXTERN OsinfoMedia* boxes_os_database_get_media_by_id (BoxesOSDatabase* self,
                                                OsinfoOs* os,
                                                const gchar* id,
                                                GError** error);
VALA_EXTERN OsinfoResources* boxes_os_database_get_resources_for_os (BoxesOSDatabase* self,
                                                         OsinfoOs* os,
                                                         const gchar* architecture);
VALA_EXTERN BoxesInstallerMedia* boxes_installer_media_new_from_iso_info (const gchar* path,
                                                              const gchar* label,
                                                              OsinfoOs* os,
                                                              OsinfoMedia* media,
                                                              OsinfoResources* resources);
VALA_EXTERN BoxesInstallerMedia* boxes_installer_media_construct_from_iso_info (GType object_type,
                                                                    const gchar* path,
                                                                    const gchar* label,
                                                                    OsinfoOs* os,
                                                                    OsinfoMedia* media,
                                                                    OsinfoResources* resources);
VALA_EXTERN BoxesInstallerMedia* boxes_media_manager_create_installer_media_from_media (BoxesMediaManager* self,
                                                                            BoxesInstallerMedia* media,
                                                                            OsinfoOs* os,
                                                                            GError** error);
static void _g_object_unref0_ (gpointer var);
static inline void _g_list_free__g_object_unref0_ (GList* self);
static void boxes_media_manager_load_physical_medias_data_free (gpointer _data);
static void boxes_media_manager_load_physical_medias (BoxesMediaManager* self,
                                               GAsyncReadyCallback _callback_,
                                               gpointer _user_data_);
static GList* boxes_media_manager_load_physical_medias_finish (BoxesMediaManager* self,
                                                        GAsyncResult* _res_);
static gboolean boxes_media_manager_load_physical_medias_co (BoxesMediaManagerLoadPhysicalMediasData* _data_);
VALA_EXTERN GUdevClient* boxes_media_manager_get_client (BoxesMediaManager* self);
static void boxes_media_manager_load_physical_medias_ready (GObject* source_object,
                                                     GAsyncResult* _res_,
                                                     gpointer _user_data_);
VALA_EXTERN BoxesInstallerMedia* boxes_media_manager_create_unattended_installer (BoxesInstallerMedia* media,
                                                                      GError** error);
VALA_EXTERN GType boxes_vm_creator_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BoxesVMCreator, g_object_unref)
VALA_EXTERN GType boxes_unattended_installer_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BoxesUnattendedInstaller, g_object_unref)
VALA_EXTERN BoxesUnattendedInstaller* boxes_unattended_installer_new_from_media (BoxesInstallerMedia* media,
                                                                     OsinfoInstallScriptList* scripts,
                                                                     GError** error);
VALA_EXTERN BoxesUnattendedInstaller* boxes_unattended_installer_construct_from_media (GType object_type,
                                                                           BoxesInstallerMedia* media,
                                                                           OsinfoInstallScriptList* scripts,
                                                                           GError** error);
VALA_EXTERN BoxesOSDatabase* boxes_os_database_new (void);
VALA_EXTERN BoxesOSDatabase* boxes_os_database_construct (GType object_type);
static void boxes_media_manager_set_os_db (BoxesMediaManager* self,
                                    BoxesOSDatabase* value);
VALA_EXTERN void boxes_os_database_load (BoxesOSDatabase* self,
                             GAsyncReadyCallback _callback_,
                             gpointer _user_data_);
VALA_EXTERN void boxes_os_database_load_finish (BoxesOSDatabase* self,
                                    GAsyncResult* _res_);
VALA_EXTERN GtkFileFilter* boxes_media_manager_get_content_types_filter (BoxesMediaManager* self);
static void boxes_media_manager_finalize (GObject * obj);
static GType boxes_media_manager_get_type_once (void);
static void _vala_boxes_media_manager_get_property (GObject * object,
                                             guint property_id,
                                             GValue * value,
                                             GParamSpec * pspec);
static void _vala_boxes_media_manager_set_property (GObject * object,
                                             guint property_id,
                                             const GValue * value,
                                             GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static const gchar* BOXES_MEDIA_MANAGER_supported_installed_media_content_types[6] = {"application/x-qemu-disk", "application/x-raw-disk-image", "application/octet-stream", "application/x-tar", "application/xml", "application/ovf"};
static const gchar* BOXES_MEDIA_MANAGER_supported_installer_media_content_types[1] = {"application/x-cd-image"};
static const gchar* BOXES_MEDIA_MANAGER_supported_compression_content_types[1] = {"application/gzip"};

static inline gpointer
boxes_media_manager_get_instance_private (BoxesMediaManager* self)
{
	return G_STRUCT_MEMBER_P (self, BoxesMediaManager_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

BoxesMediaManager*
boxes_media_manager_get_default (void)
{
	BoxesMediaManager* _tmp0_;
	BoxesMediaManager* _tmp2_;
	BoxesMediaManager* _tmp3_;
	BoxesMediaManager* result;
	_tmp0_ = boxes_media_manager_media_manager;
	if (_tmp0_ == NULL) {
		BoxesMediaManager* _tmp1_;
		_tmp1_ = boxes_media_manager_new ();
		_g_object_unref0 (boxes_media_manager_media_manager);
		boxes_media_manager_media_manager = _tmp1_;
	}
	_tmp2_ = boxes_media_manager_media_manager;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	result = _tmp3_;
	return result;
}

static void
boxes_media_manager_create_installer_media_for_path_data_free (gpointer _data)
{
	BoxesMediaManagerCreateInstallerMediaForPathData* _data_;
	_data_ = _data;
	_g_free0 (_data_->path);
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (BoxesMediaManagerCreateInstallerMediaForPathData, _data_);
}

void
boxes_media_manager_create_installer_media_for_path (BoxesMediaManager* self,
                                                     const gchar* path,
                                                     GCancellable* cancellable,
                                                     GAsyncReadyCallback _callback_,
                                                     gpointer _user_data_)
{
	BoxesMediaManagerCreateInstallerMediaForPathData* _data_;
	BoxesMediaManager* _tmp0_;
	gchar* _tmp1_;
	GCancellable* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (path != NULL);
	_data_ = g_slice_new0 (BoxesMediaManagerCreateInstallerMediaForPathData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, boxes_media_manager_create_installer_media_for_path_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = g_strdup (path);
	_g_free0 (_data_->path);
	_data_->path = _tmp1_;
	_tmp2_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp2_;
	boxes_media_manager_create_installer_media_for_path_co (_data_);
}

BoxesInstallerMedia*
boxes_media_manager_create_installer_media_for_path_finish (BoxesMediaManager* self,
                                                            GAsyncResult* _res_,
                                                            GError** error)
{
	BoxesInstallerMedia* result;
	BoxesMediaManagerCreateInstallerMediaForPathData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return NULL;
	}
	result = _data_->result;
	_data_->result = NULL;
	return result;
}

static void
boxes_media_manager_create_installer_media_for_path_ready (GObject* source_object,
                                                           GAsyncResult* _res_,
                                                           gpointer _user_data_)
{
	BoxesMediaManagerCreateInstallerMediaForPathData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	boxes_media_manager_create_installer_media_for_path_co (_data_);
}

static gboolean
boxes_media_manager_create_installer_media_for_path_co (BoxesMediaManagerCreateInstallerMediaForPathData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->media = NULL;
	if (boxes_media_manager_path_is_installer_media (_data_->self, _data_->path)) {
		_data_->_state_ = 1;
		boxes_installer_media_new_for_path (_data_->path, NULL, boxes_media_manager_create_installer_media_for_path_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp1_ = boxes_installer_media_new_for_path_finish (_data_->_res_, &_data_->_inner_error0_);
		_data_->_tmp0_ = _data_->_tmp1_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			_g_object_unref0 (_data_->media);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		_data_->_tmp2_ = _data_->_tmp0_;
		_data_->_tmp0_ = NULL;
		_g_object_unref0 (_data_->media);
		_data_->media = _data_->_tmp2_;
		_g_object_unref0 (_data_->_tmp0_);
	} else {
		if (boxes_media_manager_path_is_installed_media (_data_->self, _data_->path)) {
			_data_->_tmp3_ = TRUE;
		} else {
			_data_->_tmp3_ = g_str_has_prefix (_data_->path, "/dev/");
		}
		if (_data_->_tmp3_) {
			_data_->_tmp4_ = boxes_installed_media_new (_data_->path, !boxes_media_manager_path_needs_import (_data_->self, _data_->path));
			_g_object_unref0 (_data_->media);
			_data_->media = (BoxesInstallerMedia*) _data_->_tmp4_;
		}
	}
	_data_->_tmp5_ = _data_->media;
	if (_data_->_tmp5_ == NULL) {
		_data_->_tmp6_ = g_error_new_literal (G_IO_ERROR, G_IO_ERROR_NOT_SUPPORTED, _ ("Media is not supported"));
		_data_->_inner_error0_ = _data_->_tmp6_;
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_object_unref0 (_data_->media);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->result = _data_->media;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static gboolean
boxes_media_manager_path_is_installed_media (BoxesMediaManager* self,
                                             const gchar* path)
{
	gboolean _tmp0_ = FALSE;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (path != NULL, FALSE);
	if (boxes_media_manager_media_matches_content_type (self, path, BOXES_MEDIA_MANAGER_supported_installed_media_content_types, (gint) G_N_ELEMENTS (BOXES_MEDIA_MANAGER_supported_installed_media_content_types))) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = boxes_media_manager_path_is_compressed (self, path);
	}
	result = _tmp0_;
	return result;
}

static gboolean
boxes_media_manager_path_needs_import (BoxesMediaManager* self,
                                       const gchar* path)
{
	gchar* _tmp0_;
	gchar** _tmp1_;
	gchar** _tmp2_;
	gint _tmp2__length1;
	gboolean _tmp3_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (path != NULL, FALSE);
	_tmp0_ = g_strdup ("application/x-qemu-disk");
	_tmp1_ = g_new0 (gchar*, 1 + 1);
	_tmp1_[0] = _tmp0_;
	_tmp2_ = _tmp1_;
	_tmp2__length1 = 1;
	_tmp3_ = !boxes_media_manager_media_matches_content_type (self, path, _tmp2_, (gint) 1);
	_tmp2_ = (_vala_array_free (_tmp2_, _tmp2__length1, (GDestroyNotify) g_free), NULL);
	result = _tmp3_;
	return result;
}

static gboolean
boxes_media_manager_path_is_installer_media (BoxesMediaManager* self,
                                             const gchar* path)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (path != NULL, FALSE);
	result = boxes_media_manager_media_matches_content_type (self, path, BOXES_MEDIA_MANAGER_supported_installer_media_content_types, (gint) G_N_ELEMENTS (BOXES_MEDIA_MANAGER_supported_installer_media_content_types));
	return result;
}

gboolean
boxes_media_manager_path_is_compressed (BoxesMediaManager* self,
                                        const gchar* path)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (path != NULL, FALSE);
	result = boxes_media_manager_media_matches_content_type (self, path, BOXES_MEDIA_MANAGER_supported_compression_content_types, (gint) G_N_ELEMENTS (BOXES_MEDIA_MANAGER_supported_compression_content_types));
	return result;
}

gboolean
boxes_media_manager_media_matches_content_type (BoxesMediaManager* self,
                                                const gchar* path,
                                                gchar** supported_content_types,
                                                gint supported_content_types_length1)
{
	GFile* file = NULL;
	GFile* _tmp0_;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (path != NULL, FALSE);
	_tmp0_ = g_file_new_for_path (path);
	file = _tmp0_;
	{
		GFileInfo* info = NULL;
		GFile* _tmp1_;
		GFileInfo* _tmp2_;
		_tmp1_ = file;
		_tmp2_ = g_file_query_info (_tmp1_, "standard::content-type,standard::fast-content-type", 0, NULL, &_inner_error0_);
		info = _tmp2_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		{
			gchar** content_type_collection = NULL;
			gint content_type_collection_length1 = 0;
			gint _content_type_collection_size_ = 0;
			gint content_type_it = 0;
			content_type_collection = supported_content_types;
			content_type_collection_length1 = supported_content_types_length1;
			for (content_type_it = 0; content_type_it < content_type_collection_length1; content_type_it = content_type_it + 1) {
				gchar* _tmp3_;
				gchar* content_type = NULL;
				_tmp3_ = g_strdup (content_type_collection[content_type_it]);
				content_type = _tmp3_;
				{
					gboolean _tmp4_ = FALSE;
					GFileInfo* _tmp5_;
					const gchar* _tmp6_;
					const gchar* _tmp7_;
					_tmp5_ = info;
					_tmp6_ = g_file_info_get_content_type (_tmp5_);
					_tmp7_ = content_type;
					if (g_content_type_is_a (_tmp6_, _tmp7_)) {
						_tmp4_ = TRUE;
					} else {
						GFileInfo* _tmp8_;
						const gchar* _tmp9_;
						const gchar* _tmp10_;
						_tmp8_ = info;
						_tmp9_ = g_file_info_get_attribute_string (_tmp8_, "standard::fast-content-type");
						_tmp10_ = content_type;
						_tmp4_ = g_content_type_is_a (_tmp9_, _tmp10_);
					}
					if (_tmp4_) {
						result = TRUE;
						_g_free0 (content_type);
						_g_object_unref0 (info);
						_g_object_unref0 (file);
						return result;
					}
					_g_free0 (content_type);
				}
			}
		}
		_g_object_unref0 (info);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* _error_ = NULL;
		GError* _tmp11_;
		const gchar* _tmp12_;
		_error_ = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp11_ = _error_;
		_tmp12_ = _tmp11_->message;
		g_warning ("media-manager.vala:98: Failed to query file info for '%s': %s", path, _tmp12_);
		_g_error_free0 (_error_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp13_ = FALSE;
		_g_object_unref0 (file);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp13_;
	}
	result = FALSE;
	_g_object_unref0 (file);
	return result;
}

static void
boxes_media_manager_create_installer_media_from_config_data_free (gpointer _data)
{
	BoxesMediaManagerCreateInstallerMediaFromConfigData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->config);
	_g_object_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (BoxesMediaManagerCreateInstallerMediaFromConfigData, _data_);
}

void
boxes_media_manager_create_installer_media_from_config (BoxesMediaManager* self,
                                                        GVirConfigDomain* config,
                                                        GAsyncReadyCallback _callback_,
                                                        gpointer _user_data_)
{
	BoxesMediaManagerCreateInstallerMediaFromConfigData* _data_;
	BoxesMediaManager* _tmp0_;
	GVirConfigDomain* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (config != NULL);
	_data_ = g_slice_new0 (BoxesMediaManagerCreateInstallerMediaFromConfigData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, boxes_media_manager_create_installer_media_from_config_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (config);
	_g_object_unref0 (_data_->config);
	_data_->config = _tmp1_;
	boxes_media_manager_create_installer_media_from_config_co (_data_);
}

BoxesInstallerMedia*
boxes_media_manager_create_installer_media_from_config_finish (BoxesMediaManager* self,
                                                               GAsyncResult* _res_)
{
	BoxesInstallerMedia* result;
	BoxesMediaManagerCreateInstallerMediaFromConfigData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
	result = _data_->result;
	_data_->result = NULL;
	return result;
}

static void
boxes_media_manager_create_installer_media_from_config_ready (GObject* source_object,
                                                              GAsyncResult* _res_,
                                                              gpointer _user_data_)
{
	BoxesMediaManagerCreateInstallerMediaFromConfigData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	boxes_media_manager_create_installer_media_from_config_co (_data_);
}

static gboolean
boxes_media_manager_create_installer_media_from_config_co (BoxesMediaManagerCreateInstallerMediaFromConfigData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = boxes_vm_configurator_get_source_media_path (_data_->config);
	_data_->path = _data_->_tmp0_;
	_data_->_tmp1_ = _data_->path;
	if (_data_->_tmp1_ == NULL) {
		_data_->result = NULL;
		_g_free0 (_data_->path);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	{
		if (boxes_vm_configurator_is_import_config (_data_->config)) {
			_data_->_tmp2_ = _data_->path;
			_data_->_tmp3_ = _data_->path;
			_data_->_tmp4_ = boxes_installed_media_new (_data_->_tmp2_, !boxes_media_manager_path_needs_import (_data_->self, _data_->_tmp3_));
			_data_->result = (BoxesInstallerMedia*) _data_->_tmp4_;
			_g_free0 (_data_->path);
			g_task_return_pointer (_data_->_async_result, _data_, NULL);
			if (_data_->_state_ != 0) {
				while (!g_task_get_completed (_data_->_async_result)) {
					g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
				}
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		} else {
			if (boxes_vm_configurator_is_libvirt_system_import_config (_data_->config)) {
				_data_->_tmp6_ = _data_->path;
				_data_->_tmp7_ = boxes_libvirt_media_new (_data_->_tmp6_, _data_->config, FALSE, &_data_->_inner_error0_);
				_data_->_tmp5_ = _data_->_tmp7_;
				if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
					goto __catch0_g_error;
				}
				_data_->_tmp8_ = _data_->_tmp5_;
				_data_->_tmp5_ = NULL;
				_data_->result = (BoxesInstallerMedia*) _data_->_tmp8_;
				_g_object_unref0 (_data_->_tmp5_);
				_g_free0 (_data_->path);
				g_task_return_pointer (_data_->_async_result, _data_, NULL);
				if (_data_->_state_ != 0) {
					while (!g_task_get_completed (_data_->_async_result)) {
						g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
					}
				}
				g_object_unref (_data_->_async_result);
				return FALSE;
			} else {
				if (boxes_vm_configurator_is_libvirt_cloning_config (_data_->config)) {
					_data_->_tmp10_ = _data_->path;
					_data_->_tmp11_ = boxes_libvirt_cloned_media_new (_data_->_tmp10_, _data_->config, &_data_->_inner_error0_);
					_data_->_tmp9_ = _data_->_tmp11_;
					if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
						goto __catch0_g_error;
					}
					_data_->_tmp12_ = _data_->_tmp9_;
					_data_->_tmp9_ = NULL;
					_data_->result = (BoxesInstallerMedia*) _data_->_tmp12_;
					_g_object_unref0 (_data_->_tmp9_);
					_g_free0 (_data_->path);
					g_task_return_pointer (_data_->_async_result, _data_, NULL);
					if (_data_->_state_ != 0) {
						while (!g_task_get_completed (_data_->_async_result)) {
							g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
						}
					}
					g_object_unref (_data_->_async_result);
					return FALSE;
				}
			}
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->_error_ = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp13_ = _data_->_error_;
		_data_->_tmp14_ = _data_->_tmp13_->message;
		g_debug ("media-manager.vala:118: %s", _data_->_tmp14_);
		_data_->result = NULL;
		_g_error_free0 (_data_->_error_);
		_g_free0 (_data_->path);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		_g_free0 (_data_->path);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp15_ = gvir_config_domain_get_title (_data_->config);
	_data_->_tmp16_ = _data_->_tmp15_;
	_data_->_tmp17_ = g_strdup (_data_->_tmp16_);
	_data_->label = _data_->_tmp17_;
	_data_->os = NULL;
	_data_->os_media = NULL;
	{
		_data_->_tmp18_ = boxes_vm_configurator_get_os_id (_data_->config);
		_data_->os_id = _data_->_tmp18_;
		_data_->_tmp19_ = _data_->os_id;
		if (_data_->_tmp19_ != NULL) {
			_data_->_tmp21_ = _data_->self->priv->_os_db;
			_data_->_tmp22_ = _data_->os_id;
			_data_->_state_ = 1;
			boxes_os_database_get_os_by_id (_data_->_tmp21_, _data_->_tmp22_, boxes_media_manager_create_installer_media_from_config_ready, _data_);
			return FALSE;
			_state_1:
			_data_->_tmp23_ = boxes_os_database_get_os_by_id_finish (_data_->_tmp21_, _data_->_res_, &_data_->_inner_error0_);
			_data_->_tmp20_ = _data_->_tmp23_;
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				_g_free0 (_data_->os_id);
				if (_data_->_inner_error0_->domain == BOXES_OS_DATABASE_ERROR) {
					goto __catch1_boxes_os_database_error;
				}
				_g_object_unref0 (_data_->os_media);
				_g_object_unref0 (_data_->os);
				_g_free0 (_data_->label);
				_g_free0 (_data_->path);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
				g_clear_error (&_data_->_inner_error0_);
				g_object_unref (_data_->_async_result);
				return FALSE;
			}
			_data_->_tmp24_ = _data_->_tmp20_;
			_data_->_tmp20_ = NULL;
			_g_object_unref0 (_data_->os);
			_data_->os = _data_->_tmp24_;
			_data_->_tmp25_ = boxes_vm_configurator_get_os_media_id (_data_->config);
			_data_->media_id = _data_->_tmp25_;
			_data_->_tmp26_ = _data_->media_id;
			if (_data_->_tmp26_ != NULL) {
				_data_->_tmp28_ = _data_->self->priv->_os_db;
				_data_->_tmp29_ = _data_->os;
				_data_->_tmp30_ = _data_->media_id;
				_data_->_tmp31_ = boxes_os_database_get_media_by_id (_data_->_tmp28_, _data_->_tmp29_, _data_->_tmp30_, &_data_->_inner_error0_);
				_data_->_tmp27_ = _data_->_tmp31_;
				if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
					_g_free0 (_data_->media_id);
					_g_object_unref0 (_data_->_tmp20_);
					_g_free0 (_data_->os_id);
					if (_data_->_inner_error0_->domain == BOXES_OS_DATABASE_ERROR) {
						goto __catch1_boxes_os_database_error;
					}
					_g_object_unref0 (_data_->os_media);
					_g_object_unref0 (_data_->os);
					_g_free0 (_data_->label);
					_g_free0 (_data_->path);
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
					g_clear_error (&_data_->_inner_error0_);
					g_object_unref (_data_->_async_result);
					return FALSE;
				}
				_data_->_tmp32_ = _data_->_tmp27_;
				_data_->_tmp27_ = NULL;
				_g_object_unref0 (_data_->os_media);
				_data_->os_media = _data_->_tmp32_;
				_g_object_unref0 (_data_->_tmp27_);
			}
			_g_free0 (_data_->media_id);
			_g_object_unref0 (_data_->_tmp20_);
		}
		_g_free0 (_data_->os_id);
	}
	goto __finally1;
	__catch1_boxes_os_database_error:
	{
		_data_->_vala1__error_ = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp33_ = _data_->_vala1__error_;
		_data_->_tmp34_ = _data_->_tmp33_->message;
		g_warning ("media-manager.vala:138: %s", _data_->_tmp34_);
		_g_error_free0 (_data_->_vala1__error_);
	}
	__finally1:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		_g_object_unref0 (_data_->os_media);
		_g_object_unref0 (_data_->os);
		_g_free0 (_data_->label);
		_g_free0 (_data_->path);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp36_ = _data_->os_media;
	if (_data_->_tmp36_ != NULL) {
		_data_->_tmp37_ = _data_->os_media;
		g_object_get (_data_->_tmp37_, "architecture", &_data_->_tmp38_, NULL);
		_data_->_tmp39_ = _data_->_tmp38_;
		_g_free0 (_data_->_tmp35_);
		_data_->_tmp35_ = _data_->_tmp39_;
	} else {
		_g_free0 (_data_->_tmp35_);
		_data_->_tmp35_ = NULL;
	}
	_data_->_tmp40_ = g_strdup (_data_->_tmp35_);
	_data_->architecture = _data_->_tmp40_;
	_data_->_tmp41_ = _data_->self->priv->_os_db;
	_data_->_tmp42_ = _data_->os;
	_data_->_tmp43_ = _data_->architecture;
	_data_->_tmp44_ = boxes_os_database_get_resources_for_os (_data_->_tmp41_, _data_->_tmp42_, _data_->_tmp43_);
	_data_->resources = _data_->_tmp44_;
	_data_->_tmp45_ = _data_->path;
	_data_->_tmp46_ = _data_->label;
	_data_->_tmp47_ = _data_->os;
	_data_->_tmp48_ = _data_->os_media;
	_data_->_tmp49_ = _data_->resources;
	_data_->_tmp50_ = boxes_installer_media_new_from_iso_info (_data_->_tmp45_, _data_->_tmp46_, _data_->_tmp47_, _data_->_tmp48_, _data_->_tmp49_);
	_data_->media = _data_->_tmp50_;
	_data_->_tmp51_ = _data_->media;
	if (_data_->_tmp51_ == NULL) {
		_data_->result = NULL;
		_g_object_unref0 (_data_->media);
		_g_object_unref0 (_data_->resources);
		_g_free0 (_data_->architecture);
		_g_free0 (_data_->_tmp35_);
		_g_object_unref0 (_data_->os_media);
		_g_object_unref0 (_data_->os);
		_g_free0 (_data_->label);
		_g_free0 (_data_->path);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	{
		_data_->_tmp53_ = _data_->media;
		_data_->_tmp54_ = boxes_media_manager_create_installer_media_from_media (_data_->self, _data_->_tmp53_, NULL, &_data_->_inner_error0_);
		_data_->_tmp52_ = _data_->_tmp54_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch2_g_error;
		}
		_data_->_tmp55_ = _data_->_tmp52_;
		_data_->_tmp52_ = NULL;
		_g_object_unref0 (_data_->media);
		_data_->media = _data_->_tmp55_;
		_g_object_unref0 (_data_->_tmp52_);
	}
	goto __finally2;
	__catch2_g_error:
	{
		_data_->_vala2__error_ = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp56_ = _data_->_vala2__error_;
		_data_->_tmp57_ = _data_->_tmp56_->message;
		g_debug ("media-manager.vala:151: %s", _data_->_tmp57_);
		_g_error_free0 (_data_->_vala2__error_);
	}
	__finally2:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		_g_object_unref0 (_data_->media);
		_g_object_unref0 (_data_->resources);
		_g_free0 (_data_->architecture);
		_g_free0 (_data_->_tmp35_);
		_g_object_unref0 (_data_->os_media);
		_g_object_unref0 (_data_->os);
		_g_free0 (_data_->label);
		_g_free0 (_data_->path);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->result = _data_->media;
	_g_object_unref0 (_data_->resources);
	_g_free0 (_data_->architecture);
	_g_free0 (_data_->_tmp35_);
	_g_object_unref0 (_data_->os_media);
	_g_object_unref0 (_data_->os);
	_g_free0 (_data_->label);
	_g_free0 (_data_->path);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static inline void
_g_list_free__g_object_unref0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_object_unref0_);
}

static void
boxes_media_manager_load_physical_medias_data_free (gpointer _data)
{
	BoxesMediaManagerLoadPhysicalMediasData* _data_;
	_data_ = _data;
	(_data_->result == NULL) ? NULL : (_data_->result = (_g_list_free__g_object_unref0_ (_data_->result), NULL));
	_g_object_unref0 (_data_->self);
	g_slice_free (BoxesMediaManagerLoadPhysicalMediasData, _data_);
}

static void
boxes_media_manager_load_physical_medias (BoxesMediaManager* self,
                                          GAsyncReadyCallback _callback_,
                                          gpointer _user_data_)
{
	BoxesMediaManagerLoadPhysicalMediasData* _data_;
	BoxesMediaManager* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (BoxesMediaManagerLoadPhysicalMediasData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, boxes_media_manager_load_physical_medias_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	boxes_media_manager_load_physical_medias_co (_data_);
}

static GList*
boxes_media_manager_load_physical_medias_finish (BoxesMediaManager* self,
                                                 GAsyncResult* _res_)
{
	GList* result;
	BoxesMediaManagerLoadPhysicalMediasData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
	result = _data_->result;
	_data_->result = NULL;
	return result;
}

static void
boxes_media_manager_load_physical_medias_ready (GObject* source_object,
                                                GAsyncResult* _res_,
                                                gpointer _user_data_)
{
	BoxesMediaManagerLoadPhysicalMediasData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	boxes_media_manager_load_physical_medias_co (_data_);
}

static gboolean
boxes_media_manager_load_physical_medias_co (BoxesMediaManagerLoadPhysicalMediasData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->list = NULL;
	_data_->_tmp0_ = boxes_media_manager_get_client (_data_->self);
	_data_->_tmp1_ = _data_->_tmp0_;
	_data_->_tmp2_ = g_udev_enumerator_new (_data_->_tmp1_);
	_data_->enumerator = _data_->_tmp2_;
	_data_->_tmp3_ = _data_->enumerator;
	g_udev_enumerator_add_match_property (_data_->_tmp3_, "DEVTYPE", "disk");
	_data_->_tmp4_ = _data_->enumerator;
	_data_->_tmp5_ = g_udev_enumerator_execute (_data_->_tmp4_);
	{
		_data_->device_collection = _data_->_tmp5_;
		for (_data_->device_it = _data_->device_collection; _data_->device_it != NULL; _data_->device_it = _data_->device_it->next) {
			_data_->_tmp6_ = _g_object_ref0 ((GUdevDevice*) _data_->device_it->data);
			_data_->device = _data_->_tmp6_;
			{
				_data_->_tmp8_ = _data_->device;
				_data_->_tmp9_ = g_udev_device_get_property (_data_->_tmp8_, "ID_FS_BOOT_SYSTEM_ID");
				if (_data_->_tmp9_ == NULL) {
					_data_->_tmp10_ = _data_->device;
					_data_->_tmp7_ = !g_udev_device_get_property_as_boolean (_data_->_tmp10_, "OSINFO_BOOTABLE");
				} else {
					_data_->_tmp7_ = FALSE;
				}
				if (_data_->_tmp7_) {
					_g_object_unref0 (_data_->device);
					continue;
				}
				_data_->_tmp11_ = _data_->device;
				_data_->_tmp12_ = g_udev_device_get_device_file (_data_->_tmp11_);
				_data_->_tmp13_ = g_strdup (_data_->_tmp12_);
				_data_->path = _data_->_tmp13_;
				_data_->_tmp14_ = _data_->path;
				_data_->_tmp15_ = g_file_new_for_path (_data_->_tmp14_);
				_data_->file = _data_->_tmp15_;
				{
					_data_->_tmp16_ = _data_->file;
					_data_->_state_ = 1;
					g_file_query_info_async (_data_->_tmp16_, G_FILE_ATTRIBUTE_ACCESS_CAN_READ, G_FILE_QUERY_INFO_NONE, G_PRIORITY_DEFAULT, NULL, boxes_media_manager_load_physical_medias_ready, _data_);
					return FALSE;
					_state_1:
					_data_->_tmp17_ = g_file_query_info_finish (_data_->_tmp16_, _data_->_res_, &_data_->_inner_error0_);
					_data_->info = _data_->_tmp17_;
					if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
						goto __catch0_g_error;
					}
					_data_->_tmp18_ = _data_->info;
					if (!g_file_info_get_attribute_boolean (_data_->_tmp18_, G_FILE_ATTRIBUTE_ACCESS_CAN_READ)) {
						_data_->_tmp19_ = _data_->path;
						g_debug ("media-manager.vala:188: No read access to '%s', ignoring..", _data_->_tmp19_);
						_g_object_unref0 (_data_->info);
						_g_object_unref0 (_data_->file);
						_g_free0 (_data_->path);
						_g_object_unref0 (_data_->device);
						continue;
					}
					_data_->_tmp20_ = _data_->path;
					_data_->_state_ = 2;
					boxes_media_manager_create_installer_media_for_path (_data_->self, _data_->_tmp20_, NULL, boxes_media_manager_load_physical_medias_ready, _data_);
					return FALSE;
					_state_2:
					_data_->_tmp21_ = boxes_media_manager_create_installer_media_for_path_finish (_data_->self, _data_->_res_, &_data_->_inner_error0_);
					_data_->media = _data_->_tmp21_;
					if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
						_g_object_unref0 (_data_->info);
						goto __catch0_g_error;
					}
					_data_->_tmp22_ = _data_->media;
					if (_data_->_tmp22_ != NULL) {
						_data_->_tmp23_ = _data_->media;
						_data_->_tmp24_ = _g_object_ref0 (_data_->_tmp23_);
						_data_->list = g_list_append (_data_->list, _data_->_tmp24_);
					}
					_g_object_unref0 (_data_->media);
					_g_object_unref0 (_data_->info);
				}
				goto __finally0;
				__catch0_g_error:
				{
					_data_->_error_ = _data_->_inner_error0_;
					_data_->_inner_error0_ = NULL;
					_data_->_tmp25_ = _data_->path;
					_data_->_tmp26_ = _data_->_error_;
					_data_->_tmp27_ = _data_->_tmp26_->message;
					g_message ("media-manager.vala:197: Failed to get information on device '%s': %s. " \
"Ignoring..", _data_->_tmp25_, _data_->_tmp27_);
					_g_error_free0 (_data_->_error_);
				}
				__finally0:
				if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
					_g_object_unref0 (_data_->file);
					_g_free0 (_data_->path);
					_g_object_unref0 (_data_->device);
					(_data_->device_collection == NULL) ? NULL : (_data_->device_collection = (_g_list_free__g_object_unref0_ (_data_->device_collection), NULL));
					_g_object_unref0 (_data_->enumerator);
					(_data_->list == NULL) ? NULL : (_data_->list = (_g_list_free__g_object_unref0_ (_data_->list), NULL));
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
					g_clear_error (&_data_->_inner_error0_);
					g_object_unref (_data_->_async_result);
					return FALSE;
				}
				_g_object_unref0 (_data_->file);
				_g_free0 (_data_->path);
				_g_object_unref0 (_data_->device);
			}
		}
		(_data_->device_collection == NULL) ? NULL : (_data_->device_collection = (_g_list_free__g_object_unref0_ (_data_->device_collection), NULL));
	}
	_data_->result = _data_->list;
	_g_object_unref0 (_data_->enumerator);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

BoxesInstallerMedia*
boxes_media_manager_create_unattended_installer (BoxesInstallerMedia* media,
                                                 GError** error)
{
	BoxesInstallerMedia* install_media = NULL;
	BoxesInstallerMedia* _tmp0_;
	OsinfoFilter* filter = NULL;
	OsinfoFilter* _tmp1_;
	OsinfoFilter* _tmp2_;
	OsinfoInstallScriptList* install_scripts = NULL;
	OsinfoMedia* _tmp3_;
	OsinfoInstallScriptList* _tmp4_;
	OsinfoInstallScriptList* _tmp5_;
	OsinfoOs* _tmp19_;
	OsinfoInstallScriptList* _tmp20_;
	OsinfoList* osinfo_list = NULL;
	OsinfoInstallScriptList* _tmp21_;
	OsinfoList* _tmp22_;
	OsinfoList* _tmp23_;
	OsinfoFilter* _tmp24_;
	OsinfoList* _tmp25_;
	OsinfoInstallScriptList* _tmp26_;
	OsinfoInstallScriptList* _tmp27_;
	GError* _inner_error0_ = NULL;
	BoxesInstallerMedia* result;
	g_return_val_if_fail (media != NULL, NULL);
	_tmp0_ = _g_object_ref0 (media);
	install_media = _tmp0_;
	_tmp1_ = osinfo_filter_new ();
	filter = _tmp1_;
	_tmp2_ = filter;
	osinfo_filter_add_constraint (_tmp2_, OSINFO_INSTALL_SCRIPT_PROP_PROFILE, OSINFO_INSTALL_SCRIPT_PROFILE_DESKTOP);
	_tmp3_ = media->os_media;
	_tmp4_ = osinfo_media_get_install_script_list (_tmp3_);
	install_scripts = _tmp4_;
	_tmp5_ = install_scripts;
	if (osinfo_list_get_length ((OsinfoList*) _tmp5_) > 0) {
		OsinfoList* osinfo_list = NULL;
		OsinfoInstallScriptList* _tmp6_;
		OsinfoList* _tmp7_;
		OsinfoList* _tmp8_;
		OsinfoFilter* _tmp9_;
		OsinfoList* _tmp10_;
		OsinfoInstallScriptList* _tmp11_;
		OsinfoInstallScriptList* _tmp12_;
		_tmp6_ = install_scripts;
		_tmp7_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp6_, osinfo_list_get_type ()) ? ((OsinfoList*) _tmp6_) : NULL);
		osinfo_list = _tmp7_;
		_tmp8_ = osinfo_list;
		_tmp9_ = filter;
		_tmp10_ = osinfo_list_new_filtered (_tmp8_, _tmp9_);
		_tmp11_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp10_, osinfo_install_scriptlist_get_type ()) ? ((OsinfoInstallScriptList*) _tmp10_) : NULL;
		if (_tmp11_ == NULL) {
			_g_object_unref0 (_tmp10_);
		}
		_g_object_unref0 (install_scripts);
		install_scripts = _tmp11_;
		_tmp12_ = install_scripts;
		if (osinfo_list_get_length ((OsinfoList*) _tmp12_) > 0) {
			{
				BoxesUnattendedInstaller* _tmp13_ = NULL;
				OsinfoInstallScriptList* _tmp14_;
				BoxesUnattendedInstaller* _tmp15_;
				BoxesUnattendedInstaller* _tmp16_;
				_tmp14_ = install_scripts;
				_tmp15_ = boxes_unattended_installer_new_from_media (media, _tmp14_, &_inner_error0_);
				_tmp13_ = _tmp15_;
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					if (g_error_matches (_inner_error0_, G_IO_ERROR, G_IO_ERROR_NOT_SUPPORTED)) {
						goto __catch0_g_io_error_not_supported;
					}
					goto __finally0;
				}
				_tmp16_ = _tmp13_;
				_tmp13_ = NULL;
				_g_object_unref0 (install_media);
				install_media = (BoxesInstallerMedia*) _tmp16_;
				_g_object_unref0 (_tmp13_);
			}
			goto __finally0;
			__catch0_g_io_error_not_supported:
			{
				GError* e = NULL;
				GError* _tmp17_;
				const gchar* _tmp18_;
				e = _inner_error0_;
				_inner_error0_ = NULL;
				_tmp17_ = e;
				_tmp18_ = _tmp17_->message;
				g_debug ("media-manager.vala:224: Unattended installer setup failed: %s", _tmp18_);
				_g_error_free0 (e);
			}
			__finally0:
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				g_propagate_error (error, _inner_error0_);
				_g_object_unref0 (osinfo_list);
				_g_object_unref0 (install_scripts);
				_g_object_unref0 (filter);
				_g_object_unref0 (install_media);
				return NULL;
			}
		}
		result = install_media;
		_g_object_unref0 (osinfo_list);
		_g_object_unref0 (install_scripts);
		_g_object_unref0 (filter);
		return result;
	}
	_tmp19_ = media->os;
	_tmp20_ = osinfo_os_get_install_script_list (_tmp19_);
	_g_object_unref0 (install_scripts);
	install_scripts = _tmp20_;
	_tmp21_ = install_scripts;
	_tmp22_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp21_, osinfo_list_get_type ()) ? ((OsinfoList*) _tmp21_) : NULL);
	osinfo_list = _tmp22_;
	_tmp23_ = osinfo_list;
	_tmp24_ = filter;
	_tmp25_ = osinfo_list_new_filtered (_tmp23_, _tmp24_);
	_tmp26_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp25_, osinfo_install_scriptlist_get_type ()) ? ((OsinfoInstallScriptList*) _tmp25_) : NULL;
	if (_tmp26_ == NULL) {
		_g_object_unref0 (_tmp25_);
	}
	_g_object_unref0 (install_scripts);
	install_scripts = _tmp26_;
	_tmp27_ = install_scripts;
	if (osinfo_list_get_length ((OsinfoList*) _tmp27_) > 0) {
		{
			BoxesUnattendedInstaller* _tmp28_ = NULL;
			OsinfoInstallScriptList* _tmp29_;
			BoxesUnattendedInstaller* _tmp30_;
			BoxesUnattendedInstaller* _tmp31_;
			_tmp29_ = install_scripts;
			_tmp30_ = boxes_unattended_installer_new_from_media (media, _tmp29_, &_inner_error0_);
			_tmp28_ = _tmp30_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (g_error_matches (_inner_error0_, G_IO_ERROR, G_IO_ERROR_NOT_SUPPORTED)) {
					goto __catch1_g_io_error_not_supported;
				}
				goto __finally1;
			}
			_tmp31_ = _tmp28_;
			_tmp28_ = NULL;
			_g_object_unref0 (install_media);
			install_media = (BoxesInstallerMedia*) _tmp31_;
			_g_object_unref0 (_tmp28_);
		}
		goto __finally1;
		__catch1_g_io_error_not_supported:
		{
			GError* e = NULL;
			GError* _tmp32_;
			const gchar* _tmp33_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp32_ = e;
			_tmp33_ = _tmp32_->message;
			g_debug ("media-manager.vala:240: Unattended installer setup failed: %s", _tmp33_);
			_g_error_free0 (e);
		}
		__finally1:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (osinfo_list);
			_g_object_unref0 (install_scripts);
			_g_object_unref0 (filter);
			_g_object_unref0 (install_media);
			return NULL;
		}
	}
	result = install_media;
	_g_object_unref0 (osinfo_list);
	_g_object_unref0 (install_scripts);
	_g_object_unref0 (filter);
	return result;
}

BoxesInstallerMedia*
boxes_media_manager_create_installer_media_from_media (BoxesMediaManager* self,
                                                       BoxesInstallerMedia* media,
                                                       OsinfoOs* os,
                                                       GError** error)
{
	OsinfoOs* _tmp1_;
	OsinfoMedia* _tmp3_;
	OsinfoMedia* _tmp5_;
	BoxesInstallerMedia* _tmp7_ = NULL;
	BoxesInstallerMedia* _tmp8_;
	BoxesInstallerMedia* _tmp9_;
	GError* _inner_error0_ = NULL;
	BoxesInstallerMedia* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (media != NULL, NULL);
	if (os != NULL) {
		OsinfoOs* _tmp0_;
		_tmp0_ = _g_object_ref0 (os);
		_g_object_unref0 (media->os);
		media->os = _tmp0_;
	}
	_tmp1_ = media->os;
	if (_tmp1_ == NULL) {
		BoxesInstallerMedia* _tmp2_;
		_tmp2_ = _g_object_ref0 (media);
		result = _tmp2_;
		return result;
	}
	_tmp3_ = media->os_media;
	if (_tmp3_ == NULL) {
		BoxesInstallerMedia* _tmp4_;
		_tmp4_ = _g_object_ref0 (media);
		result = _tmp4_;
		return result;
	}
	_tmp5_ = media->os_media;
	if (!osinfo_media_supports_installer_script (_tmp5_)) {
		BoxesInstallerMedia* _tmp6_;
		_tmp6_ = _g_object_ref0 (media);
		result = _tmp6_;
		return result;
	}
	_tmp8_ = boxes_media_manager_create_unattended_installer (media, &_inner_error0_);
	_tmp7_ = _tmp8_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return NULL;
	}
	_tmp9_ = _tmp7_;
	_tmp7_ = NULL;
	result = _tmp9_;
	_g_object_unref0 (_tmp7_);
	return result;
}

static BoxesMediaManager*
boxes_media_manager_construct (GType object_type)
{
	BoxesMediaManager * self = NULL;
	BoxesOSDatabase* _tmp0_;
	BoxesOSDatabase* _tmp1_;
	BoxesOSDatabase* _tmp2_;
	self = (BoxesMediaManager*) g_object_new (object_type, NULL);
	_tmp0_ = boxes_os_database_new ();
	_tmp1_ = _tmp0_;
	boxes_media_manager_set_os_db (self, _tmp1_);
	_g_object_unref0 (_tmp1_);
	_tmp2_ = self->priv->_os_db;
	boxes_os_database_load (_tmp2_, NULL, NULL);
	return self;
}

static BoxesMediaManager*
boxes_media_manager_new (void)
{
	return boxes_media_manager_construct (BOXES_TYPE_MEDIA_MANAGER);
}

BoxesOSDatabase*
boxes_media_manager_get_os_db (BoxesMediaManager* self)
{
	BoxesOSDatabase* result;
	BoxesOSDatabase* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_os_db;
	result = _tmp0_;
	return result;
}

static void
boxes_media_manager_set_os_db (BoxesMediaManager* self,
                               BoxesOSDatabase* value)
{
	BoxesOSDatabase* old_value;
	g_return_if_fail (self != NULL);
	old_value = boxes_media_manager_get_os_db (self);
	if (old_value != value) {
		BoxesOSDatabase* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_os_db);
		self->priv->_os_db = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, boxes_media_manager_properties[BOXES_MEDIA_MANAGER_OS_DB_PROPERTY]);
	}
}

GtkFileFilter*
boxes_media_manager_get_content_types_filter (BoxesMediaManager* self)
{
	GtkFileFilter* result;
	GtkFileFilter* _tmp0_;
	GtkFileFilter* _tmp2_;
	GtkFileFilter* _tmp9_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_content_types_filter;
	if (_tmp0_ != NULL) {
		GtkFileFilter* _tmp1_;
		_tmp1_ = self->priv->_content_types_filter;
		result = _tmp1_;
		return result;
	}
	_tmp2_ = gtk_file_filter_new ();
	g_object_ref_sink (_tmp2_);
	_g_object_unref0 (self->priv->_content_types_filter);
	self->priv->_content_types_filter = _tmp2_;
	{
		const gchar** content_type_collection = NULL;
		gint content_type_collection_length1 = 0;
		gint _content_type_collection_size_ = 0;
		gint content_type_it = 0;
		content_type_collection = BOXES_MEDIA_MANAGER_supported_installer_media_content_types;
		content_type_collection_length1 = G_N_ELEMENTS (BOXES_MEDIA_MANAGER_supported_installer_media_content_types);
		for (content_type_it = 0; content_type_it < content_type_collection_length1; content_type_it = content_type_it + 1) {
			const gchar* content_type = NULL;
			content_type = content_type_collection[content_type_it];
			{
				GtkFileFilter* _tmp3_;
				const gchar* _tmp4_;
				_tmp3_ = self->priv->_content_types_filter;
				_tmp4_ = content_type;
				gtk_file_filter_add_mime_type (_tmp3_, _tmp4_);
			}
		}
	}
	{
		const gchar** content_type_collection = NULL;
		gint content_type_collection_length1 = 0;
		gint _content_type_collection_size_ = 0;
		gint content_type_it = 0;
		content_type_collection = BOXES_MEDIA_MANAGER_supported_installed_media_content_types;
		content_type_collection_length1 = G_N_ELEMENTS (BOXES_MEDIA_MANAGER_supported_installed_media_content_types);
		for (content_type_it = 0; content_type_it < content_type_collection_length1; content_type_it = content_type_it + 1) {
			const gchar* content_type = NULL;
			content_type = content_type_collection[content_type_it];
			{
				GtkFileFilter* _tmp5_;
				const gchar* _tmp6_;
				_tmp5_ = self->priv->_content_types_filter;
				_tmp6_ = content_type;
				gtk_file_filter_add_mime_type (_tmp5_, _tmp6_);
			}
		}
	}
	{
		const gchar** content_type_collection = NULL;
		gint content_type_collection_length1 = 0;
		gint _content_type_collection_size_ = 0;
		gint content_type_it = 0;
		content_type_collection = BOXES_MEDIA_MANAGER_supported_compression_content_types;
		content_type_collection_length1 = G_N_ELEMENTS (BOXES_MEDIA_MANAGER_supported_compression_content_types);
		for (content_type_it = 0; content_type_it < content_type_collection_length1; content_type_it = content_type_it + 1) {
			const gchar* content_type = NULL;
			content_type = content_type_collection[content_type_it];
			{
				GtkFileFilter* _tmp7_;
				const gchar* _tmp8_;
				_tmp7_ = self->priv->_content_types_filter;
				_tmp8_ = content_type;
				gtk_file_filter_add_mime_type (_tmp7_, _tmp8_);
			}
		}
	}
	_tmp9_ = self->priv->_content_types_filter;
	result = _tmp9_;
	return result;
}

GUdevClient*
boxes_media_manager_get_client (BoxesMediaManager* self)
{
	GUdevClient* result;
	GUdevClient* _tmp0_;
	GUdevClient* _tmp5_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_client;
	if (_tmp0_ == NULL) {
		gchar* _tmp1_;
		gchar** _tmp2_;
		gchar** _tmp3_;
		gint _tmp3__length1;
		GUdevClient* _tmp4_;
		_tmp1_ = g_strdup ("block");
		_tmp2_ = g_new0 (gchar*, 1 + 1);
		_tmp2_[0] = _tmp1_;
		_tmp3_ = _tmp2_;
		_tmp3__length1 = 1;
		_tmp4_ = g_udev_client_new (_tmp3_);
		_g_object_unref0 (self->priv->_client);
		self->priv->_client = _tmp4_;
		_tmp3_ = (_vala_array_free (_tmp3_, _tmp3__length1, (GDestroyNotify) g_free), NULL);
	}
	_tmp5_ = self->priv->_client;
	result = _tmp5_;
	return result;
}

static void
boxes_media_manager_class_init (BoxesMediaManagerClass * klass,
                                gpointer klass_data)
{
	boxes_media_manager_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &BoxesMediaManager_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_boxes_media_manager_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_boxes_media_manager_set_property;
	G_OBJECT_CLASS (klass)->finalize = boxes_media_manager_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), BOXES_MEDIA_MANAGER_OS_DB_PROPERTY, boxes_media_manager_properties[BOXES_MEDIA_MANAGER_OS_DB_PROPERTY] = g_param_spec_object ("os-db", "os-db", "os-db", BOXES_TYPE_OS_DATABASE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), BOXES_MEDIA_MANAGER_CONTENT_TYPES_FILTER_PROPERTY, boxes_media_manager_properties[BOXES_MEDIA_MANAGER_CONTENT_TYPES_FILTER_PROPERTY] = g_param_spec_object ("content-types-filter", "content-types-filter", "content-types-filter", gtk_file_filter_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), BOXES_MEDIA_MANAGER_CLIENT_PROPERTY, boxes_media_manager_properties[BOXES_MEDIA_MANAGER_CLIENT_PROPERTY] = g_param_spec_object ("client", "client", "client", g_udev_client_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
boxes_media_manager_instance_init (BoxesMediaManager * self,
                                   gpointer klass)
{
	self->priv = boxes_media_manager_get_instance_private (self);
}

static void
boxes_media_manager_finalize (GObject * obj)
{
	BoxesMediaManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BOXES_TYPE_MEDIA_MANAGER, BoxesMediaManager);
	_g_object_unref0 (self->priv->_os_db);
	_g_object_unref0 (self->priv->_content_types_filter);
	_g_object_unref0 (self->priv->_client);
	G_OBJECT_CLASS (boxes_media_manager_parent_class)->finalize (obj);
}

static GType
boxes_media_manager_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BoxesMediaManagerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) boxes_media_manager_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BoxesMediaManager), 0, (GInstanceInitFunc) boxes_media_manager_instance_init, NULL };
	GType boxes_media_manager_type_id;
	boxes_media_manager_type_id = g_type_register_static (G_TYPE_OBJECT, "BoxesMediaManager", &g_define_type_info, 0);
	BoxesMediaManager_private_offset = g_type_add_instance_private (boxes_media_manager_type_id, sizeof (BoxesMediaManagerPrivate));
	return boxes_media_manager_type_id;
}

GType
boxes_media_manager_get_type (void)
{
	static volatile gsize boxes_media_manager_type_id__once = 0;
	if (g_once_init_enter (&boxes_media_manager_type_id__once)) {
		GType boxes_media_manager_type_id;
		boxes_media_manager_type_id = boxes_media_manager_get_type_once ();
		g_once_init_leave (&boxes_media_manager_type_id__once, boxes_media_manager_type_id);
	}
	return boxes_media_manager_type_id__once;
}

static void
_vala_boxes_media_manager_get_property (GObject * object,
                                        guint property_id,
                                        GValue * value,
                                        GParamSpec * pspec)
{
	BoxesMediaManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, BOXES_TYPE_MEDIA_MANAGER, BoxesMediaManager);
	switch (property_id) {
		case BOXES_MEDIA_MANAGER_OS_DB_PROPERTY:
		g_value_set_object (value, boxes_media_manager_get_os_db (self));
		break;
		case BOXES_MEDIA_MANAGER_CONTENT_TYPES_FILTER_PROPERTY:
		g_value_set_object (value, boxes_media_manager_get_content_types_filter (self));
		break;
		case BOXES_MEDIA_MANAGER_CLIENT_PROPERTY:
		g_value_set_object (value, boxes_media_manager_get_client (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_boxes_media_manager_set_property (GObject * object,
                                        guint property_id,
                                        const GValue * value,
                                        GParamSpec * pspec)
{
	BoxesMediaManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, BOXES_TYPE_MEDIA_MANAGER, BoxesMediaManager);
	switch (property_id) {
		case BOXES_MEDIA_MANAGER_OS_DB_PROPERTY:
		boxes_media_manager_set_os_db (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

