/* contacts-im-addresses-chunk.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from contacts-im-addresses-chunk.vala, do not modify */

/*
 * Copyright (C) 2022 Niels De Graef <nielsdegraef@gmail.com>
 *
 * SPDX-License-Identifier: GPL-2.0-or-later
 */

#include "contactscore.h"
#include <gio/gio.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <folks/folks.h>
#include <gee.h>
#include <glib-object.h>
#include <glib/gi18n-lib.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	CONTACTS_IM_ADDRESSES_CHUNK_0_PROPERTY,
	CONTACTS_IM_ADDRESSES_CHUNK_PROPERTY_NAME_PROPERTY,
	CONTACTS_IM_ADDRESSES_CHUNK_DISPLAY_NAME_PROPERTY,
	CONTACTS_IM_ADDRESSES_CHUNK_ICON_NAME_PROPERTY,
	CONTACTS_IM_ADDRESSES_CHUNK_NUM_PROPERTIES
};
static GParamSpec* contacts_im_addresses_chunk_properties[CONTACTS_IM_ADDRESSES_CHUNK_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _ContactsImAddressesChunkSaveToPersonaData ContactsImAddressesChunkSaveToPersonaData;
#define _g_free0(var) (var = (g_free (var), NULL))
enum  {
	CONTACTS_IM_ADDRESS_0_PROPERTY,
	CONTACTS_IM_ADDRESS_PROTOCOL_PROPERTY,
	CONTACTS_IM_ADDRESS_ADDRESS_PROPERTY,
	CONTACTS_IM_ADDRESS_IS_EMPTY_PROPERTY,
	CONTACTS_IM_ADDRESS_ICON_NAME_PROPERTY,
	CONTACTS_IM_ADDRESS_NUM_PROPERTIES
};
static GParamSpec* contacts_im_address_properties[CONTACTS_IM_ADDRESS_NUM_PROPERTIES];
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
#define _g_variant_type_free0(var) ((var == NULL) ? NULL : (var = (g_variant_type_free (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _ContactsImAddressesChunkSaveToPersonaData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	ContactsImAddressesChunk* self;
	FolksPersona* _tmp0_;
	FolksPersona* _tmp1_;
	GeeHashMultiMap* afds;
	GeeHashMultiMap* _tmp2_;
	guint i;
	gboolean _tmp3_;
	guint _tmp4_;
	ContactsImAddress* im_addr;
	GObject* _tmp5_;
	FolksImFieldDetails* afd;
	ContactsImAddress* _tmp6_;
	FolksAbstractFieldDetails* _tmp7_;
	FolksImFieldDetails* _tmp8_;
	GeeHashMultiMap* _tmp9_;
	ContactsImAddress* _tmp10_;
	const gchar* _tmp11_;
	const gchar* _tmp12_;
	FolksImFieldDetails* _tmp13_;
	FolksPersona* _tmp14_;
	FolksPersona* _tmp15_;
	GeeHashMultiMap* _tmp16_;
	GError* _inner_error0_;
};

struct _ContactsImAddressPrivate {
	gchar* _protocol;
	gchar* _address;
};

static gpointer contacts_im_addresses_chunk_parent_class = NULL;
static gint ContactsImAddress_private_offset;
static gpointer contacts_im_address_parent_class = NULL;

static ContactsBinChunkChild* contacts_im_addresses_chunk_real_create_empty_child (ContactsBinChunk* base);
static void contacts_im_addresses_chunk_real_save_to_persona_data_free (gpointer _data);
static void contacts_im_addresses_chunk_real_save_to_persona (ContactsChunk* base,
                                                       GAsyncReadyCallback _callback_,
                                                       gpointer _user_data_);
static gboolean contacts_im_addresses_chunk_real_save_to_persona_co (ContactsImAddressesChunkSaveToPersonaData* _data_);
static void contacts_im_addresses_chunk_save_to_persona_ready (GObject* source_object,
                                                        GAsyncResult* _res_,
                                                        gpointer _user_data_);
static GObject * contacts_im_addresses_chunk_constructor (GType type,
                                                   guint n_construct_properties,
                                                   GObjectConstructParam * construct_properties);
static GType contacts_im_addresses_chunk_get_type_once (void);
static void _vala_contacts_im_addresses_chunk_get_property (GObject * object,
                                                     guint property_id,
                                                     GValue * value,
                                                     GParamSpec * pspec);
static void contacts_im_address_set_protocol (ContactsImAddress* self,
                                       const gchar* value);
static gint contacts_im_address_real_compare_internal (ContactsBinChunkChild* base,
                                                ContactsBinChunkChild* other);
static FolksAbstractFieldDetails* contacts_im_address_real_create_afd (ContactsBinChunkChild* base);
static ContactsBinChunkChild* contacts_im_address_real_copy (ContactsBinChunkChild* base);
static GVariant* contacts_im_address_real_to_gvariant_internal (ContactsBinChunkChild* base);
static void contacts_im_address_real_apply_gvariant (ContactsBinChunkChild* base,
                                              GVariant* variant);
static void contacts_im_address_finalize (GObject * obj);
static GType contacts_im_address_get_type_once (void);
static void _vala_contacts_im_address_get_property (GObject * object,
                                             guint property_id,
                                             GValue * value,
                                             GParamSpec * pspec);
static void _vala_contacts_im_address_set_property (GObject * object,
                                             guint property_id,
                                             const GValue * value,
                                             GParamSpec * pspec);

static ContactsBinChunkChild*
contacts_im_addresses_chunk_real_create_empty_child (ContactsBinChunk* base)
{
	ContactsImAddressesChunk * self;
	ContactsImAddress* _tmp0_;
	ContactsBinChunkChild* result;
	self = (ContactsImAddressesChunk*) base;
	_tmp0_ = contacts_im_address_new ();
	result = (ContactsBinChunkChild*) _tmp0_;
	return result;
}

static void
contacts_im_addresses_chunk_real_save_to_persona_data_free (gpointer _data)
{
	ContactsImAddressesChunkSaveToPersonaData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (ContactsImAddressesChunkSaveToPersonaData, _data_);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
contacts_im_addresses_chunk_real_save_to_persona (ContactsChunk* base,
                                                  GAsyncReadyCallback _callback_,
                                                  gpointer _user_data_)
{
	ContactsImAddressesChunk * self;
	ContactsImAddressesChunkSaveToPersonaData* _data_;
	ContactsImAddressesChunk* _tmp0_;
	self = (ContactsImAddressesChunk*) base;
	_data_ = g_slice_new0 (ContactsImAddressesChunkSaveToPersonaData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, contacts_im_addresses_chunk_real_save_to_persona_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	contacts_im_addresses_chunk_real_save_to_persona_co (_data_);
}

static void
contacts_im_addresses_chunk_save_to_persona_finish (ContactsChunk* base,
                                                    GAsyncResult* _res_,
                                                    GError** error)
{
	ContactsImAddressesChunkSaveToPersonaData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

static void
contacts_im_addresses_chunk_save_to_persona_ready (GObject* source_object,
                                                   GAsyncResult* _res_,
                                                   gpointer _user_data_)
{
	ContactsImAddressesChunkSaveToPersonaData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	contacts_im_addresses_chunk_real_save_to_persona_co (_data_);
}

static gboolean
contacts_im_addresses_chunk_real_save_to_persona_co (ContactsImAddressesChunkSaveToPersonaData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = contacts_chunk_get_persona ((ContactsChunk*) _data_->self);
	_data_->_tmp1_ = _data_->_tmp0_;
	_vala_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (_data_->_tmp1_, FOLKS_TYPE_IM_DETAILS), "this.persona is ImDetails", FALSE);
	_data_->_tmp2_ = gee_hash_multi_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, FOLKS_TYPE_IM_FIELD_DETAILS, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_data_->afds = _data_->_tmp2_;
	{
		_data_->i = (guint) 0;
		{
			_data_->_tmp3_ = TRUE;
			while (TRUE) {
				if (!_data_->_tmp3_) {
					_data_->_tmp4_ = _data_->i;
					_data_->i = _data_->_tmp4_ + 1;
				}
				_data_->_tmp3_ = FALSE;
				if (!(_data_->i < g_list_model_get_n_items ((GListModel*) _data_->self))) {
					break;
				}
				_data_->_tmp5_ = g_list_model_get_item ((GListModel*) _data_->self, _data_->i);
				_data_->im_addr = G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp5_, CONTACTS_TYPE_IM_ADDRESS, ContactsImAddress);
				_data_->_tmp6_ = _data_->im_addr;
				_data_->_tmp7_ = contacts_bin_chunk_child_create_afd ((ContactsBinChunkChild*) _data_->_tmp6_);
				_data_->afd = G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp7_, FOLKS_TYPE_IM_FIELD_DETAILS, FolksImFieldDetails);
				_data_->_tmp8_ = _data_->afd;
				if (_data_->_tmp8_ != NULL) {
					_data_->_tmp9_ = _data_->afds;
					_data_->_tmp10_ = _data_->im_addr;
					_data_->_tmp11_ = contacts_im_address_get_protocol (_data_->_tmp10_);
					_data_->_tmp12_ = _data_->_tmp11_;
					_data_->_tmp13_ = _data_->afd;
					gee_multi_map_set ((GeeMultiMap*) _data_->_tmp9_, _data_->_tmp12_, _data_->_tmp13_);
				}
				_g_object_unref0 (_data_->afd);
				_g_object_unref0 (_data_->im_addr);
			}
		}
	}
	_data_->_tmp14_ = contacts_chunk_get_persona ((ContactsChunk*) _data_->self);
	_data_->_tmp15_ = _data_->_tmp14_;
	_data_->_tmp16_ = _data_->afds;
	_data_->_state_ = 1;
	folks_im_details_change_im_addresses (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp15_, FOLKS_TYPE_IM_DETAILS, FolksImDetails), (GeeMultiMap*) _data_->_tmp16_, contacts_im_addresses_chunk_save_to_persona_ready, _data_);
	return FALSE;
	_state_1:
	folks_im_details_change_im_addresses_finish (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp15_, FOLKS_TYPE_IM_DETAILS, FolksImDetails), _data_->_res_, &_data_->_inner_error0_);
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
		_g_object_unref0 (_data_->afds);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	contacts_bin_chunk_update_original_elements ((ContactsBinChunk*) _data_->self);
	_g_object_unref0 (_data_->afds);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

ContactsImAddressesChunk*
contacts_im_addresses_chunk_construct (GType object_type)
{
	ContactsImAddressesChunk * self = NULL;
	self = (ContactsImAddressesChunk*) contacts_bin_chunk_construct (object_type);
	return self;
}

ContactsImAddressesChunk*
contacts_im_addresses_chunk_new (void)
{
	return contacts_im_addresses_chunk_construct (CONTACTS_TYPE_IM_ADDRESSES_CHUNK);
}

static const gchar*
contacts_im_addresses_chunk_real_get_property_name (ContactsChunk* base)
{
	const gchar* result;
	ContactsImAddressesChunk* self;
	self = (ContactsImAddressesChunk*) base;
	result = "im-addresses";
	return result;
}

static const gchar*
contacts_im_addresses_chunk_real_get_display_name (ContactsChunk* base)
{
	const gchar* result;
	ContactsImAddressesChunk* self;
	self = (ContactsImAddressesChunk*) base;
	result = _ ("Instant Messaging addresses");
	return result;
}

static const gchar*
contacts_im_addresses_chunk_real_get_icon_name (ContactsChunk* base)
{
	const gchar* result;
	ContactsImAddressesChunk* self;
	self = (ContactsImAddressesChunk*) base;
	result = "chat-symbolic";
	return result;
}

static GObject *
contacts_im_addresses_chunk_constructor (GType type,
                                         guint n_construct_properties,
                                         GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	ContactsImAddressesChunk * self;
	FolksPersona* _tmp0_;
	FolksPersona* _tmp1_;
	parent_class = G_OBJECT_CLASS (contacts_im_addresses_chunk_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CONTACTS_TYPE_IM_ADDRESSES_CHUNK, ContactsImAddressesChunk);
	_tmp0_ = contacts_chunk_get_persona ((ContactsChunk*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		FolksPersona* _tmp2_;
		FolksPersona* _tmp3_;
		FolksImDetails* im_details = NULL;
		FolksPersona* _tmp4_;
		FolksPersona* _tmp5_;
		GeeMapIterator* iter = NULL;
		FolksImDetails* _tmp6_;
		GeeMultiMap* _tmp7_;
		GeeMultiMap* _tmp8_;
		GeeMapIterator* _tmp9_;
		_tmp2_ = contacts_chunk_get_persona ((ContactsChunk*) self);
		_tmp3_ = _tmp2_;
		_vala_assert (G_TYPE_CHECK_INSTANCE_TYPE (_tmp3_, FOLKS_TYPE_IM_DETAILS), "persona is ImDetails");
		_tmp4_ = contacts_chunk_get_persona ((ContactsChunk*) self);
		_tmp5_ = _tmp4_;
		im_details = G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, FOLKS_TYPE_IM_DETAILS, FolksImDetails);
		_tmp6_ = im_details;
		_tmp7_ = folks_im_details_get_im_addresses (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp9_ = gee_multi_map_map_iterator (_tmp8_);
		iter = _tmp9_;
		while (TRUE) {
			GeeMapIterator* _tmp10_;
			gchar* protocol = NULL;
			GeeMapIterator* _tmp11_;
			gpointer _tmp12_;
			ContactsImAddress* im = NULL;
			GeeMapIterator* _tmp13_;
			gpointer _tmp14_;
			FolksImFieldDetails* _tmp15_;
			const gchar* _tmp16_;
			ContactsImAddress* _tmp17_;
			ContactsImAddress* _tmp18_;
			ContactsImAddress* _tmp19_;
			_tmp10_ = iter;
			if (!gee_map_iterator_next (_tmp10_)) {
				break;
			}
			_tmp11_ = iter;
			_tmp12_ = gee_map_iterator_get_key (_tmp11_);
			protocol = (gchar*) _tmp12_;
			_tmp13_ = iter;
			_tmp14_ = gee_map_iterator_get_value (_tmp13_);
			_tmp15_ = (FolksImFieldDetails*) _tmp14_;
			_tmp16_ = protocol;
			_tmp17_ = contacts_im_address_new_from_field_details (_tmp15_, _tmp16_);
			_tmp18_ = _tmp17_;
			_g_object_unref0 (_tmp15_);
			im = _tmp18_;
			_tmp19_ = im;
			contacts_bin_chunk_add_child ((ContactsBinChunk*) self, (ContactsBinChunkChild*) _tmp19_);
			_g_object_unref0 (im);
			_g_free0 (protocol);
		}
		_g_object_unref0 (iter);
	}
	contacts_bin_chunk_finish_initialization ((ContactsBinChunk*) self);
	return obj;
}

static void
contacts_im_addresses_chunk_class_init (ContactsImAddressesChunkClass * klass,
                                        gpointer klass_data)
{
	contacts_im_addresses_chunk_parent_class = g_type_class_peek_parent (klass);
	((ContactsBinChunkClass *) klass)->create_empty_child = (ContactsBinChunkChild* (*) (ContactsBinChunk*)) contacts_im_addresses_chunk_real_create_empty_child;
	((ContactsChunkClass *) klass)->save_to_persona = (void (*) (ContactsChunk*, GAsyncReadyCallback, gpointer)) contacts_im_addresses_chunk_real_save_to_persona;
	((ContactsChunkClass *) klass)->save_to_persona_finish = (void (*) (ContactsChunk*, GAsyncResult*, GError**)) contacts_im_addresses_chunk_save_to_persona_finish;
	CONTACTS_CHUNK_CLASS (klass)->get_property_name = (const gchar* (*) (ContactsChunk*)) contacts_im_addresses_chunk_real_get_property_name;
	CONTACTS_CHUNK_CLASS (klass)->get_display_name = (const gchar* (*) (ContactsChunk*)) contacts_im_addresses_chunk_real_get_display_name;
	CONTACTS_CHUNK_CLASS (klass)->get_icon_name = (const gchar* (*) (ContactsChunk*)) contacts_im_addresses_chunk_real_get_icon_name;
	G_OBJECT_CLASS (klass)->get_property = _vala_contacts_im_addresses_chunk_get_property;
	G_OBJECT_CLASS (klass)->constructor = contacts_im_addresses_chunk_constructor;
	g_object_class_install_property (G_OBJECT_CLASS (klass), CONTACTS_IM_ADDRESSES_CHUNK_PROPERTY_NAME_PROPERTY, contacts_im_addresses_chunk_properties[CONTACTS_IM_ADDRESSES_CHUNK_PROPERTY_NAME_PROPERTY] = g_param_spec_string ("property-name", "property-name", "property-name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CONTACTS_IM_ADDRESSES_CHUNK_DISPLAY_NAME_PROPERTY, contacts_im_addresses_chunk_properties[CONTACTS_IM_ADDRESSES_CHUNK_DISPLAY_NAME_PROPERTY] = g_param_spec_string ("display-name", "display-name", "display-name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CONTACTS_IM_ADDRESSES_CHUNK_ICON_NAME_PROPERTY, contacts_im_addresses_chunk_properties[CONTACTS_IM_ADDRESSES_CHUNK_ICON_NAME_PROPERTY] = g_param_spec_string ("icon-name", "icon-name", "icon-name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
contacts_im_addresses_chunk_instance_init (ContactsImAddressesChunk * self,
                                           gpointer klass)
{
}

/**
 * A {@link Chunk} that represents the internet messaging (IM) addresses of a
 * contact (similar to {@link Folks.ImDetails}. Each element is a
 * {@link ImAddress}.
 */
 G_GNUC_NO_INLINE static GType
contacts_im_addresses_chunk_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ContactsImAddressesChunkClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) contacts_im_addresses_chunk_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ContactsImAddressesChunk), 0, (GInstanceInitFunc) contacts_im_addresses_chunk_instance_init, NULL };
	GType contacts_im_addresses_chunk_type_id;
	contacts_im_addresses_chunk_type_id = g_type_register_static (CONTACTS_TYPE_BIN_CHUNK, "ContactsImAddressesChunk", &g_define_type_info, 0);
	return contacts_im_addresses_chunk_type_id;
}

GType
contacts_im_addresses_chunk_get_type (void)
{
	static volatile gsize contacts_im_addresses_chunk_type_id__once = 0;
	if (g_once_init_enter (&contacts_im_addresses_chunk_type_id__once)) {
		GType contacts_im_addresses_chunk_type_id;
		contacts_im_addresses_chunk_type_id = contacts_im_addresses_chunk_get_type_once ();
		g_once_init_leave (&contacts_im_addresses_chunk_type_id__once, contacts_im_addresses_chunk_type_id);
	}
	return contacts_im_addresses_chunk_type_id__once;
}

static void
_vala_contacts_im_addresses_chunk_get_property (GObject * object,
                                                guint property_id,
                                                GValue * value,
                                                GParamSpec * pspec)
{
	ContactsImAddressesChunk * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CONTACTS_TYPE_IM_ADDRESSES_CHUNK, ContactsImAddressesChunk);
	switch (property_id) {
		case CONTACTS_IM_ADDRESSES_CHUNK_PROPERTY_NAME_PROPERTY:
		g_value_set_string (value, contacts_chunk_get_property_name ((ContactsChunk*) self));
		break;
		case CONTACTS_IM_ADDRESSES_CHUNK_DISPLAY_NAME_PROPERTY:
		g_value_set_string (value, contacts_chunk_get_display_name ((ContactsChunk*) self));
		break;
		case CONTACTS_IM_ADDRESSES_CHUNK_ICON_NAME_PROPERTY:
		g_value_set_string (value, contacts_chunk_get_icon_name ((ContactsChunk*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
contacts_im_address_get_instance_private (ContactsImAddress* self)
{
	return G_STRUCT_MEMBER_P (self, ContactsImAddress_private_offset);
}

ContactsImAddress*
contacts_im_address_construct (GType object_type)
{
	ContactsImAddress * self = NULL;
	GeeHashMultiMap* _tmp0_;
	GeeHashMultiMap* _tmp1_;
	self = (ContactsImAddress*) contacts_bin_chunk_child_construct (object_type);
	_tmp0_ = gee_hash_multi_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_tmp1_ = _tmp0_;
	contacts_bin_chunk_child_set_parameters ((ContactsBinChunkChild*) self, (GeeMultiMap*) _tmp1_);
	_g_object_unref0 (_tmp1_);
	return self;
}

ContactsImAddress*
contacts_im_address_new (void)
{
	return contacts_im_address_construct (CONTACTS_TYPE_IM_ADDRESS);
}

ContactsImAddress*
contacts_im_address_construct_from_field_details (GType object_type,
                                                  FolksImFieldDetails* im_field,
                                                  const gchar* protocol)
{
	ContactsImAddress * self = NULL;
	gconstpointer _tmp0_;
	gconstpointer _tmp1_;
	GeeMultiMap* _tmp2_;
	GeeMultiMap* _tmp3_;
	g_return_val_if_fail (im_field != NULL, NULL);
	g_return_val_if_fail (protocol != NULL, NULL);
	self = (ContactsImAddress*) contacts_bin_chunk_child_construct (object_type);
	_tmp0_ = folks_abstract_field_details_get_value ((FolksAbstractFieldDetails*) im_field);
	_tmp1_ = _tmp0_;
	contacts_im_address_set_address (self, (const gchar*) _tmp1_);
	contacts_im_address_set_protocol (self, protocol);
	_tmp2_ = folks_abstract_field_details_get_parameters ((FolksAbstractFieldDetails*) im_field);
	_tmp3_ = _tmp2_;
	contacts_bin_chunk_child_set_parameters ((ContactsBinChunkChild*) self, _tmp3_);
	return self;
}

ContactsImAddress*
contacts_im_address_new_from_field_details (FolksImFieldDetails* im_field,
                                            const gchar* protocol)
{
	return contacts_im_address_construct_from_field_details (CONTACTS_TYPE_IM_ADDRESS, im_field, protocol);
}

static gint
contacts_im_address_real_compare_internal (ContactsBinChunkChild* base,
                                           ContactsBinChunkChild* other)
{
	ContactsImAddress * self;
	ContactsImAddress* other_im_addr = NULL;
	gint protocol_cmp = 0;
	GCompareFunc _tmp0_;
	const gchar* _tmp1_;
	ContactsImAddress* _tmp2_;
	const gchar* _tmp3_;
	gint addr_cmp = 0;
	GCompareFunc _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	ContactsImAddress* _tmp7_;
	const gchar* _tmp8_;
	const gchar* _tmp9_;
	gint result;
	self = (ContactsImAddress*) base;
	g_return_val_if_fail (other != NULL, 0);
	_vala_return_val_if_fail (CONTACTS_IS_IM_ADDRESS (other), "other is ImAddress", 0);
	other_im_addr = G_TYPE_CHECK_INSTANCE_CAST (other, CONTACTS_TYPE_IM_ADDRESS, ContactsImAddress);
	_tmp0_ = ((GCompareFunc) g_strcmp0);
	_tmp1_ = self->priv->_protocol;
	_tmp2_ = other_im_addr;
	_tmp3_ = _tmp2_->priv->_protocol;
	protocol_cmp = _tmp0_ (_tmp1_, _tmp3_);
	if (protocol_cmp != 0) {
		result = protocol_cmp;
		return result;
	}
	_tmp4_ = ((GCompareFunc) g_strcmp0);
	_tmp5_ = contacts_im_address_get_address (self);
	_tmp6_ = _tmp5_;
	_tmp7_ = other_im_addr;
	_tmp8_ = contacts_im_address_get_address (_tmp7_);
	_tmp9_ = _tmp8_;
	addr_cmp = _tmp4_ (_tmp6_, _tmp9_);
	if (addr_cmp != 0) {
		result = addr_cmp;
		return result;
	}
	result = contacts_bin_chunk_child_dummy_compare_parameters ((ContactsBinChunkChild*) self, other);
	return result;
}

static FolksAbstractFieldDetails*
contacts_im_address_real_create_afd (ContactsBinChunkChild* base)
{
	ContactsImAddress * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	GeeMultiMap* _tmp4_;
	GeeMultiMap* _tmp5_;
	FolksImFieldDetails* _tmp6_;
	FolksAbstractFieldDetails* result;
	self = (ContactsImAddress*) base;
	_tmp0_ = contacts_bin_chunk_child_get_is_empty ((ContactsBinChunkChild*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		result = NULL;
		return result;
	}
	_tmp2_ = contacts_im_address_get_address (self);
	_tmp3_ = _tmp2_;
	_tmp4_ = contacts_bin_chunk_child_get_parameters ((ContactsBinChunkChild*) self);
	_tmp5_ = _tmp4_;
	_tmp6_ = folks_im_field_details_new (_tmp3_, _tmp5_);
	result = (FolksAbstractFieldDetails*) _tmp6_;
	return result;
}

static ContactsBinChunkChild*
contacts_im_address_real_copy (ContactsBinChunkChild* base)
{
	ContactsImAddress * self;
	ContactsImAddress* ima = NULL;
	ContactsImAddress* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	ContactsBinChunkChild* result;
	self = (ContactsImAddress*) base;
	_tmp0_ = contacts_im_address_new ();
	ima = _tmp0_;
	_tmp1_ = self->priv->_protocol;
	contacts_im_address_set_protocol (ima, _tmp1_);
	_tmp2_ = contacts_im_address_get_address (self);
	_tmp3_ = _tmp2_;
	contacts_im_address_set_address (ima, _tmp3_);
	contacts_bin_chunk_child_copy_parameters ((ContactsBinChunkChild*) self, (ContactsBinChunkChild*) ima);
	result = (ContactsBinChunkChild*) ima;
	return result;
}

static GVariant*
contacts_im_address_real_to_gvariant_internal (ContactsBinChunkChild* base)
{
	ContactsImAddress * self;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	GVariant* _tmp3_;
	GVariant* _tmp4_;
	GVariant* _tmp5_;
	GVariant* _tmp6_;
	GVariant* result;
	self = (ContactsImAddress*) base;
	_tmp0_ = self->priv->_protocol;
	_tmp1_ = contacts_im_address_get_address (self);
	_tmp2_ = _tmp1_;
	_tmp3_ = contacts_bin_chunk_child_parameters_to_gvariant ((ContactsBinChunkChild*) self);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_variant_new ("(ssv)", _tmp0_, _tmp2_, _tmp4_, NULL);
	g_variant_ref_sink (_tmp5_);
	_tmp6_ = _tmp5_;
	_g_variant_unref0 (_tmp4_);
	result = _tmp6_;
	return result;
}

static void
contacts_im_address_real_apply_gvariant (ContactsBinChunkChild* base,
                                         GVariant* variant)
{
	ContactsImAddress * self;
	const GVariantType* _tmp0_;
	GVariantType* _tmp1_;
	GVariantType* _tmp2_;
	gchar* protocol = NULL;
	gchar* address = NULL;
	GVariant* params_variant = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	GVariant* _tmp5_ = NULL;
	self = (ContactsImAddress*) base;
	g_return_if_fail (variant != NULL);
	_tmp0_ = g_variant_get_type (variant);
	_tmp1_ = g_variant_type_new ("(ssv)");
	_tmp2_ = _tmp1_;
	_vala_return_if_fail (g_variant_type_equal (_tmp0_, _tmp2_), "variant.get_type ().equal (new VariantType (\"(ssv)\"))");
	g_variant_get (variant, "(ssv)", &_tmp3_, &_tmp4_, &_tmp5_, NULL);
	_g_free0 (protocol);
	protocol = _tmp3_;
	_g_free0 (address);
	address = _tmp4_;
	_g_variant_unref0 (params_variant);
	params_variant = _tmp5_;
	_g_variant_type_free0 (_tmp2_);
	contacts_im_address_set_protocol (self, protocol);
	contacts_im_address_set_address (self, address);
	contacts_bin_chunk_child_apply_gvariant_parameters ((ContactsBinChunkChild*) self, params_variant);
	_g_variant_unref0 (params_variant);
	_g_free0 (address);
	_g_free0 (protocol);
}

const gchar*
contacts_im_address_get_protocol (ContactsImAddress* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_protocol;
	result = _tmp0_;
	return result;
}

static void
contacts_im_address_set_protocol (ContactsImAddress* self,
                                  const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = contacts_im_address_get_protocol (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_protocol);
		self->priv->_protocol = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, contacts_im_address_properties[CONTACTS_IM_ADDRESS_PROTOCOL_PROPERTY]);
	}
}

const gchar*
contacts_im_address_get_address (ContactsImAddress* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_address;
	result = _tmp0_;
	return result;
}

void
contacts_im_address_set_address (ContactsImAddress* self,
                                 const gchar* value)
{
	g_return_if_fail (self != NULL);
	contacts_bin_chunk_child_change_string_prop ((ContactsBinChunkChild*) self, "address", &self->priv->_address, value);
	g_object_notify_by_pspec ((GObject *) self, contacts_im_address_properties[CONTACTS_IM_ADDRESS_ADDRESS_PROPERTY]);
}

static gchar*
string_strip (const gchar* self)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strstrip (_result_);
	result = _result_;
	return result;
}

static gboolean
contacts_im_address_real_get_is_empty (ContactsBinChunkChild* base)
{
	gboolean result;
	ContactsImAddress* self;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gboolean _tmp4_;
	self = (ContactsImAddress*) base;
	_tmp0_ = contacts_im_address_get_address (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = string_strip (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strcmp0 (_tmp3_, "") == 0;
	_g_free0 (_tmp3_);
	result = _tmp4_;
	return result;
}

static const gchar*
contacts_im_address_real_get_icon_name (ContactsBinChunkChild* base)
{
	const gchar* result;
	ContactsImAddress* self;
	self = (ContactsImAddress*) base;
	result = "chat-symbolic";
	return result;
}

static void
contacts_im_address_class_init (ContactsImAddressClass * klass,
                                gpointer klass_data)
{
	contacts_im_address_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &ContactsImAddress_private_offset);
	((ContactsBinChunkChildClass *) klass)->compare_internal = (gint (*) (ContactsBinChunkChild*, ContactsBinChunkChild*)) contacts_im_address_real_compare_internal;
	((ContactsBinChunkChildClass *) klass)->create_afd = (FolksAbstractFieldDetails* (*) (ContactsBinChunkChild*)) contacts_im_address_real_create_afd;
	((ContactsBinChunkChildClass *) klass)->copy = (ContactsBinChunkChild* (*) (ContactsBinChunkChild*)) contacts_im_address_real_copy;
	((ContactsBinChunkChildClass *) klass)->to_gvariant_internal = (GVariant* (*) (ContactsBinChunkChild*)) contacts_im_address_real_to_gvariant_internal;
	((ContactsBinChunkChildClass *) klass)->apply_gvariant = (void (*) (ContactsBinChunkChild*, GVariant*)) contacts_im_address_real_apply_gvariant;
	CONTACTS_BIN_CHUNK_CHILD_CLASS (klass)->get_is_empty = (gboolean (*) (ContactsBinChunkChild*)) contacts_im_address_real_get_is_empty;
	CONTACTS_BIN_CHUNK_CHILD_CLASS (klass)->get_icon_name = (const gchar* (*) (ContactsBinChunkChild*)) contacts_im_address_real_get_icon_name;
	G_OBJECT_CLASS (klass)->get_property = _vala_contacts_im_address_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_contacts_im_address_set_property;
	G_OBJECT_CLASS (klass)->finalize = contacts_im_address_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), CONTACTS_IM_ADDRESS_PROTOCOL_PROPERTY, contacts_im_address_properties[CONTACTS_IM_ADDRESS_PROTOCOL_PROPERTY] = g_param_spec_string ("protocol", "protocol", "protocol", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CONTACTS_IM_ADDRESS_ADDRESS_PROPERTY, contacts_im_address_properties[CONTACTS_IM_ADDRESS_ADDRESS_PROPERTY] = g_param_spec_string ("address", "address", "address", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CONTACTS_IM_ADDRESS_IS_EMPTY_PROPERTY, contacts_im_address_properties[CONTACTS_IM_ADDRESS_IS_EMPTY_PROPERTY] = g_param_spec_boolean ("is-empty", "is-empty", "is-empty", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CONTACTS_IM_ADDRESS_ICON_NAME_PROPERTY, contacts_im_address_properties[CONTACTS_IM_ADDRESS_ICON_NAME_PROPERTY] = g_param_spec_string ("icon-name", "icon-name", "icon-name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
contacts_im_address_instance_init (ContactsImAddress * self,
                                   gpointer klass)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	self->priv = contacts_im_address_get_instance_private (self);
	_tmp0_ = g_strdup ("");
	self->priv->_protocol = _tmp0_;
	_tmp1_ = g_strdup ("");
	self->priv->_address = _tmp1_;
}

static void
contacts_im_address_finalize (GObject * obj)
{
	ContactsImAddress * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CONTACTS_TYPE_IM_ADDRESS, ContactsImAddress);
	_g_free0 (self->priv->_protocol);
	_g_free0 (self->priv->_address);
	G_OBJECT_CLASS (contacts_im_address_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
contacts_im_address_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ContactsImAddressClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) contacts_im_address_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ContactsImAddress), 0, (GInstanceInitFunc) contacts_im_address_instance_init, NULL };
	GType contacts_im_address_type_id;
	contacts_im_address_type_id = g_type_register_static (CONTACTS_TYPE_BIN_CHUNK_CHILD, "ContactsImAddress", &g_define_type_info, 0);
	ContactsImAddress_private_offset = g_type_add_instance_private (contacts_im_address_type_id, sizeof (ContactsImAddressPrivate));
	return contacts_im_address_type_id;
}

GType
contacts_im_address_get_type (void)
{
	static volatile gsize contacts_im_address_type_id__once = 0;
	if (g_once_init_enter (&contacts_im_address_type_id__once)) {
		GType contacts_im_address_type_id;
		contacts_im_address_type_id = contacts_im_address_get_type_once ();
		g_once_init_leave (&contacts_im_address_type_id__once, contacts_im_address_type_id);
	}
	return contacts_im_address_type_id__once;
}

static void
_vala_contacts_im_address_get_property (GObject * object,
                                        guint property_id,
                                        GValue * value,
                                        GParamSpec * pspec)
{
	ContactsImAddress * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CONTACTS_TYPE_IM_ADDRESS, ContactsImAddress);
	switch (property_id) {
		case CONTACTS_IM_ADDRESS_PROTOCOL_PROPERTY:
		g_value_set_string (value, contacts_im_address_get_protocol (self));
		break;
		case CONTACTS_IM_ADDRESS_ADDRESS_PROPERTY:
		g_value_set_string (value, contacts_im_address_get_address (self));
		break;
		case CONTACTS_IM_ADDRESS_IS_EMPTY_PROPERTY:
		g_value_set_boolean (value, contacts_bin_chunk_child_get_is_empty ((ContactsBinChunkChild*) self));
		break;
		case CONTACTS_IM_ADDRESS_ICON_NAME_PROPERTY:
		g_value_set_string (value, contacts_bin_chunk_child_get_icon_name ((ContactsBinChunkChild*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_contacts_im_address_set_property (GObject * object,
                                        guint property_id,
                                        const GValue * value,
                                        GParamSpec * pspec)
{
	ContactsImAddress * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CONTACTS_TYPE_IM_ADDRESS, ContactsImAddress);
	switch (property_id) {
		case CONTACTS_IM_ADDRESS_PROTOCOL_PROPERTY:
		contacts_im_address_set_protocol (self, g_value_get_string (value));
		break;
		case CONTACTS_IM_ADDRESS_ADDRESS_PROPERTY:
		contacts_im_address_set_address (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

