/* players.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from players.vala, do not modify */

/* -*- Mode: vala; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*-
 * Gnome Nibbles: Gnome Worm Game
 * Copyright (C) 2015 Iulian-Gabriel Radu <iulian.radu67@gmail.com>
 * Copyright (C) 2023-2024 Ben Corby
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <gtk/gtk.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <glib/gi18n-lib.h>

#define PLAYERS_ai0_label _ ("0")
#define PLAYERS_ai1_label _ ("1")
#define PLAYERS_ai2_label _ ("2")
#define PLAYERS_ai3_label _ ("3")
#define PLAYERS_ai4_label _ ("4")
#define PLAYERS_ai5_label _ ("5")
#define NIBBLES_GAME_MAX_WORMS 6
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_PLAYERS (players_get_type ())
#define PLAYERS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PLAYERS, Players))
#define PLAYERS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PLAYERS, PlayersClass))
#define IS_PLAYERS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PLAYERS))
#define IS_PLAYERS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PLAYERS))
#define PLAYERS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PLAYERS, PlayersClass))

typedef struct _Players Players;
typedef struct _PlayersClass PlayersClass;
typedef struct _PlayersPrivate PlayersPrivate;
enum  {
	PLAYERS_0_PROPERTY,
	PLAYERS_NUM_PROPERTIES
};
static GParamSpec* players_properties[PLAYERS_NUM_PROPERTIES];
typedef void (*GSimpleActionChangeStateCallback) (GSimpleAction* action, GVariant* value, gpointer user_data);
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

struct _Players {
	GtkBox parent_instance;
	PlayersPrivate * priv;
};

struct _PlayersClass {
	GtkBoxClass parent_class;
};

struct _PlayersPrivate {
	GtkToggleButton* players1;
	GtkToggleButton* players2;
	GtkToggleButton* players3;
	GtkToggleButton* players4;
	GtkToggleButton* worms2;
	GtkToggleButton* worms3;
	GtkToggleButton* worms4;
	GtkToggleButton* worms5;
	GtkToggleButton* worms6;
	GtkButton* button;
	GSimpleAction* nibbles_number_action;
	GSimpleAction* players_number_action;
};

static gint Players_private_offset;
static gpointer players_parent_class = NULL;

VALA_EXTERN GType players_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Players, g_object_unref)
static inline void players_change_nibbles_number (Players* self,
                                    GSimpleAction* _nibbles_number_action,
                                    GVariant* variant);
static void _players_change_nibbles_number_gsimple_action_change_state_callback (GSimpleAction* action,
                                                                          GVariant* value,
                                                                          gpointer self);
static inline void players_change_players_number (Players* self,
                                    GSimpleAction* _players_number_action,
                                    GVariant* variant);
static void _players_change_players_number_gsimple_action_change_state_callback (GSimpleAction* action,
                                                                          GVariant* value,
                                                                          gpointer self);
VALA_EXTERN void players_set_values (Players* self,
                         gint players_number,
                         gint number_of_ais);
static GVariant* _variant_new3 (gint value);
static GVariant* _variant_new4 (gint value);
static void players_set_player_frames (Players* self,
                                gint player_count);
static void players_set_worm_frames (Players* self,
                              gint players,
                              gint ai);
static void players_update_buttons_labels (Players* self);
VALA_EXTERN void players_get_values (Players* self,
                         gint* players_number,
                         gint* number_of_ais);
static GVariant* _variant_new5 (gint value);
static GVariant* _variant_new6 (gint value);
static GVariant* _variant_new7 (gint32 value);
static gint players_to_ai_count (Players* self,
                          GVariant* v,
                          GVariant* players_count);
VALA_EXTERN Players* players_new (void);
VALA_EXTERN Players* players_construct (GType object_type);
static GObject * players_constructor (GType type,
                               guint n_construct_properties,
                               GObjectConstructParam * construct_properties);
static void players_finalize (GObject * obj);
static GType players_get_type_once (void);

static const GActionEntry PLAYERS_players_action_entries[2] = {{"change-nibbles-number", NULL, "i", "4", _players_change_nibbles_number_gsimple_action_change_state_callback}, {"change-players-number", NULL, "i", "1", _players_change_players_number_gsimple_action_change_state_callback}};

static inline gpointer
players_get_instance_private (Players* self)
{
	return G_STRUCT_MEMBER_P (self, Players_private_offset);
}

static void
_players_change_nibbles_number_gsimple_action_change_state_callback (GSimpleAction* action,
                                                                     GVariant* value,
                                                                     gpointer self)
{
	players_change_nibbles_number ((Players*) self, action, value);
}

static void
_players_change_players_number_gsimple_action_change_state_callback (GSimpleAction* action,
                                                                     GVariant* value,
                                                                     gpointer self)
{
	players_change_players_number ((Players*) self, action, value);
}

static GVariant*
_variant_new3 (gint value)
{
	return g_variant_ref_sink (g_variant_new_int32 (value));
}

static GVariant*
_variant_new4 (gint value)
{
	return g_variant_ref_sink (g_variant_new_int32 (value));
}

void
players_set_values (Players* self,
                    gint players_number,
                    gint number_of_ais)
{
	GSimpleAction* _tmp0_;
	GVariant* _tmp1_;
	GSimpleAction* _tmp2_;
	GVariant* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->nibbles_number_action;
	_tmp1_ = _variant_new3 (players_number + number_of_ais);
	g_simple_action_set_state (_tmp0_, _tmp1_);
	_g_variant_unref0 (_tmp1_);
	_tmp2_ = self->priv->players_number_action;
	_tmp3_ = _variant_new4 (players_number);
	g_simple_action_set_state (_tmp2_, _tmp3_);
	_g_variant_unref0 (_tmp3_);
	players_set_player_frames (self, players_number);
	players_set_worm_frames (self, players_number, number_of_ais);
	players_update_buttons_labels (self);
}

void
players_get_values (Players* self,
                    gint* players_number,
                    gint* number_of_ais)
{
	gint _vala_players_number = 0;
	gint _vala_number_of_ais = 0;
	GSimpleAction* _tmp0_;
	GVariant* _tmp1_;
	GVariant* _tmp2_;
	GSimpleAction* _tmp3_;
	GVariant* _tmp4_;
	GVariant* _tmp5_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->players_number_action;
	_tmp1_ = g_action_get_state ((GAction*) _tmp0_);
	_tmp2_ = _tmp1_;
	_vala_players_number = (gint) g_variant_get_int32 (_tmp2_);
	_g_variant_unref0 (_tmp2_);
	_tmp3_ = self->priv->nibbles_number_action;
	_tmp4_ = g_action_get_state ((GAction*) _tmp3_);
	_tmp5_ = _tmp4_;
	_vala_number_of_ais = (gint) (g_variant_get_int32 (_tmp5_) - _vala_players_number);
	_g_variant_unref0 (_tmp5_);
	if (players_number) {
		*players_number = _vala_players_number;
	}
	if (number_of_ais) {
		*number_of_ais = _vala_number_of_ais;
	}
}

static GVariant*
_variant_new5 (gint value)
{
	return g_variant_ref_sink (g_variant_new_int32 (value));
}

static GVariant*
_variant_new6 (gint value)
{
	return g_variant_ref_sink (g_variant_new_int32 (value));
}

static inline void
players_change_players_number (Players* self,
                               GSimpleAction* _players_number_action,
                               GVariant* variant)
{
	gint players_number = 0;
	gboolean _tmp0_ = FALSE;
	GVariant* _tmp1_;
	gint nibbles_number = 0;
	GSimpleAction* _tmp2_;
	GVariant* _tmp3_;
	GVariant* _tmp4_;
	gint _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (_players_number_action != NULL);
	g_return_if_fail (variant != NULL);
	players_number = (gint) g_variant_get_int32 (variant);
	if (players_number < 1) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = players_number > 4;
	}
	if (_tmp0_) {
		g_assert_not_reached ();
	}
	_tmp1_ = _variant_new5 (players_number);
	g_simple_action_set_state (_players_number_action, _tmp1_);
	_g_variant_unref0 (_tmp1_);
	players_set_player_frames (self, players_number);
	_tmp2_ = self->priv->nibbles_number_action;
	_tmp3_ = g_action_get_state ((GAction*) _tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = (gint) g_variant_get_int32 (_tmp4_);
	_g_variant_unref0 (_tmp4_);
	nibbles_number = _tmp5_;
	if ((nibbles_number + players_number) > NIBBLES_GAME_MAX_WORMS) {
		GSimpleAction* _tmp6_;
		GVariant* _tmp7_;
		nibbles_number = NIBBLES_GAME_MAX_WORMS - players_number;
		_tmp6_ = self->priv->nibbles_number_action;
		_tmp7_ = _variant_new6 (nibbles_number + players_number);
		g_simple_action_set_state (_tmp6_, _tmp7_);
		_g_variant_unref0 (_tmp7_);
		players_set_worm_frames (self, players_number, nibbles_number);
	}
	players_update_buttons_labels (self);
}

static void
players_update_buttons_labels (Players* self)
{
	GSimpleAction* _tmp0_;
	GVariant* _tmp1_;
	GVariant* _tmp2_;
	gint32 _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->players_number_action;
	_tmp1_ = g_action_get_state ((GAction*) _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_variant_get_int32 (_tmp2_);
	_g_variant_unref0 (_tmp2_);
	switch (_tmp3_) {
		case 1:
		{
			GtkToggleButton* _tmp4_;
			GtkToggleButton* _tmp5_;
			GtkToggleButton* _tmp6_;
			GtkWidget* _tmp7_;
			gchar* _tmp8_;
			gchar* _tmp9_;
			gchar* _tmp10_;
			gchar* _tmp11_;
			GtkToggleButton* _tmp12_;
			GtkWidget* _tmp13_;
			gchar* _tmp14_;
			gchar* _tmp15_;
			gchar* _tmp16_;
			gchar* _tmp17_;
			GtkToggleButton* _tmp18_;
			GtkWidget* _tmp19_;
			gchar* _tmp20_;
			gchar* _tmp21_;
			gchar* _tmp22_;
			gchar* _tmp23_;
			GtkToggleButton* _tmp24_;
			GtkWidget* _tmp25_;
			gchar* _tmp26_;
			gchar* _tmp27_;
			gchar* _tmp28_;
			gchar* _tmp29_;
			GtkToggleButton* _tmp30_;
			GtkWidget* _tmp31_;
			gchar* _tmp32_;
			gchar* _tmp33_;
			gchar* _tmp34_;
			gchar* _tmp35_;
			_tmp4_ = self->priv->worms2;
			gtk_widget_set_visible (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, gtk_widget_get_type (), GtkWidget), TRUE);
			_tmp5_ = self->priv->worms3;
			gtk_widget_set_visible (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, gtk_widget_get_type (), GtkWidget), TRUE);
			_tmp6_ = self->priv->worms2;
			_tmp7_ = gtk_button_get_child ((GtkButton*) _tmp6_);
			_tmp8_ = g_strconcat ("<b><span size=\"30.0pt\" font-family=\"Sans\">", _ (PLAYERS_ai1_label), NULL);
			_tmp9_ = _tmp8_;
			_tmp10_ = g_strconcat (_tmp9_, "</span></b>", NULL);
			_tmp11_ = _tmp10_;
			gtk_label_set_markup (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, gtk_label_get_type (), GtkLabel), _tmp11_);
			_g_free0 (_tmp11_);
			_g_free0 (_tmp9_);
			_tmp12_ = self->priv->worms3;
			_tmp13_ = gtk_button_get_child ((GtkButton*) _tmp12_);
			_tmp14_ = g_strconcat ("<b><span size=\"30.0pt\" font-family=\"Sans\">", _ (PLAYERS_ai2_label), NULL);
			_tmp15_ = _tmp14_;
			_tmp16_ = g_strconcat (_tmp15_, "</span></b>", NULL);
			_tmp17_ = _tmp16_;
			gtk_label_set_markup (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, gtk_label_get_type (), GtkLabel), _tmp17_);
			_g_free0 (_tmp17_);
			_g_free0 (_tmp15_);
			_tmp18_ = self->priv->worms4;
			_tmp19_ = gtk_button_get_child ((GtkButton*) _tmp18_);
			_tmp20_ = g_strconcat ("<b><span size=\"30.0pt\" font-family=\"Sans\">", _ (PLAYERS_ai3_label), NULL);
			_tmp21_ = _tmp20_;
			_tmp22_ = g_strconcat (_tmp21_, "</span></b>", NULL);
			_tmp23_ = _tmp22_;
			gtk_label_set_markup (G_TYPE_CHECK_INSTANCE_CAST (_tmp19_, gtk_label_get_type (), GtkLabel), _tmp23_);
			_g_free0 (_tmp23_);
			_g_free0 (_tmp21_);
			_tmp24_ = self->priv->worms5;
			_tmp25_ = gtk_button_get_child ((GtkButton*) _tmp24_);
			_tmp26_ = g_strconcat ("<b><span size=\"30.0pt\" font-family=\"Sans\">", _ (PLAYERS_ai4_label), NULL);
			_tmp27_ = _tmp26_;
			_tmp28_ = g_strconcat (_tmp27_, "</span></b>", NULL);
			_tmp29_ = _tmp28_;
			gtk_label_set_markup (G_TYPE_CHECK_INSTANCE_CAST (_tmp25_, gtk_label_get_type (), GtkLabel), _tmp29_);
			_g_free0 (_tmp29_);
			_g_free0 (_tmp27_);
			_tmp30_ = self->priv->worms6;
			_tmp31_ = gtk_button_get_child ((GtkButton*) _tmp30_);
			_tmp32_ = g_strconcat ("<b><span size=\"30.0pt\" font-family=\"Sans\">", _ (PLAYERS_ai5_label), NULL);
			_tmp33_ = _tmp32_;
			_tmp34_ = g_strconcat (_tmp33_, "</span></b>", NULL);
			_tmp35_ = _tmp34_;
			gtk_label_set_markup (G_TYPE_CHECK_INSTANCE_CAST (_tmp31_, gtk_label_get_type (), GtkLabel), _tmp35_);
			_g_free0 (_tmp35_);
			_g_free0 (_tmp33_);
			break;
		}
		case 2:
		{
			GtkToggleButton* _tmp36_;
			GtkToggleButton* _tmp37_;
			GtkToggleButton* _tmp38_;
			GtkWidget* _tmp39_;
			gchar* _tmp40_;
			gchar* _tmp41_;
			gchar* _tmp42_;
			gchar* _tmp43_;
			GtkToggleButton* _tmp44_;
			GtkWidget* _tmp45_;
			gchar* _tmp46_;
			gchar* _tmp47_;
			gchar* _tmp48_;
			gchar* _tmp49_;
			GtkToggleButton* _tmp50_;
			GtkWidget* _tmp51_;
			gchar* _tmp52_;
			gchar* _tmp53_;
			gchar* _tmp54_;
			gchar* _tmp55_;
			GtkToggleButton* _tmp56_;
			GtkWidget* _tmp57_;
			gchar* _tmp58_;
			gchar* _tmp59_;
			gchar* _tmp60_;
			gchar* _tmp61_;
			GtkToggleButton* _tmp62_;
			GtkWidget* _tmp63_;
			gchar* _tmp64_;
			gchar* _tmp65_;
			gchar* _tmp66_;
			gchar* _tmp67_;
			_tmp36_ = self->priv->worms2;
			gtk_widget_set_visible (G_TYPE_CHECK_INSTANCE_CAST (_tmp36_, gtk_widget_get_type (), GtkWidget), TRUE);
			_tmp37_ = self->priv->worms3;
			gtk_widget_set_visible (G_TYPE_CHECK_INSTANCE_CAST (_tmp37_, gtk_widget_get_type (), GtkWidget), TRUE);
			_tmp38_ = self->priv->worms2;
			_tmp39_ = gtk_button_get_child ((GtkButton*) _tmp38_);
			_tmp40_ = g_strconcat ("<b><span size=\"30.0pt\" font-family=\"Sans\">", _ (PLAYERS_ai0_label), NULL);
			_tmp41_ = _tmp40_;
			_tmp42_ = g_strconcat (_tmp41_, "</span></b>", NULL);
			_tmp43_ = _tmp42_;
			gtk_label_set_markup (G_TYPE_CHECK_INSTANCE_CAST (_tmp39_, gtk_label_get_type (), GtkLabel), _tmp43_);
			_g_free0 (_tmp43_);
			_g_free0 (_tmp41_);
			_tmp44_ = self->priv->worms3;
			_tmp45_ = gtk_button_get_child ((GtkButton*) _tmp44_);
			_tmp46_ = g_strconcat ("<b><span size=\"30.0pt\" font-family=\"Sans\">", _ (PLAYERS_ai1_label), NULL);
			_tmp47_ = _tmp46_;
			_tmp48_ = g_strconcat (_tmp47_, "</span></b>", NULL);
			_tmp49_ = _tmp48_;
			gtk_label_set_markup (G_TYPE_CHECK_INSTANCE_CAST (_tmp45_, gtk_label_get_type (), GtkLabel), _tmp49_);
			_g_free0 (_tmp49_);
			_g_free0 (_tmp47_);
			_tmp50_ = self->priv->worms4;
			_tmp51_ = gtk_button_get_child ((GtkButton*) _tmp50_);
			_tmp52_ = g_strconcat ("<b><span size=\"30.0pt\" font-family=\"Sans\">", _ (PLAYERS_ai2_label), NULL);
			_tmp53_ = _tmp52_;
			_tmp54_ = g_strconcat (_tmp53_, "</span></b>", NULL);
			_tmp55_ = _tmp54_;
			gtk_label_set_markup (G_TYPE_CHECK_INSTANCE_CAST (_tmp51_, gtk_label_get_type (), GtkLabel), _tmp55_);
			_g_free0 (_tmp55_);
			_g_free0 (_tmp53_);
			_tmp56_ = self->priv->worms5;
			_tmp57_ = gtk_button_get_child ((GtkButton*) _tmp56_);
			_tmp58_ = g_strconcat ("<b><span size=\"30.0pt\" font-family=\"Sans\">", _ (PLAYERS_ai3_label), NULL);
			_tmp59_ = _tmp58_;
			_tmp60_ = g_strconcat (_tmp59_, "</span></b>", NULL);
			_tmp61_ = _tmp60_;
			gtk_label_set_markup (G_TYPE_CHECK_INSTANCE_CAST (_tmp57_, gtk_label_get_type (), GtkLabel), _tmp61_);
			_g_free0 (_tmp61_);
			_g_free0 (_tmp59_);
			_tmp62_ = self->priv->worms6;
			_tmp63_ = gtk_button_get_child ((GtkButton*) _tmp62_);
			_tmp64_ = g_strconcat ("<b><span size=\"30.0pt\" font-family=\"Sans\">", _ (PLAYERS_ai4_label), NULL);
			_tmp65_ = _tmp64_;
			_tmp66_ = g_strconcat (_tmp65_, "</span></b>", NULL);
			_tmp67_ = _tmp66_;
			gtk_label_set_markup (G_TYPE_CHECK_INSTANCE_CAST (_tmp63_, gtk_label_get_type (), GtkLabel), _tmp67_);
			_g_free0 (_tmp67_);
			_g_free0 (_tmp65_);
			break;
		}
		case 3:
		{
			GtkToggleButton* _tmp68_;
			GtkToggleButton* _tmp69_;
			GtkToggleButton* _tmp70_;
			GtkWidget* _tmp71_;
			gchar* _tmp72_;
			gchar* _tmp73_;
			gchar* _tmp74_;
			gchar* _tmp75_;
			GtkToggleButton* _tmp76_;
			GtkWidget* _tmp77_;
			gchar* _tmp78_;
			gchar* _tmp79_;
			gchar* _tmp80_;
			gchar* _tmp81_;
			GtkToggleButton* _tmp82_;
			GtkWidget* _tmp83_;
			gchar* _tmp84_;
			gchar* _tmp85_;
			gchar* _tmp86_;
			gchar* _tmp87_;
			GtkToggleButton* _tmp88_;
			GtkWidget* _tmp89_;
			gchar* _tmp90_;
			gchar* _tmp91_;
			gchar* _tmp92_;
			gchar* _tmp93_;
			_tmp68_ = self->priv->worms2;
			gtk_widget_set_visible (G_TYPE_CHECK_INSTANCE_CAST (_tmp68_, gtk_widget_get_type (), GtkWidget), FALSE);
			_tmp69_ = self->priv->worms3;
			gtk_widget_set_visible (G_TYPE_CHECK_INSTANCE_CAST (_tmp69_, gtk_widget_get_type (), GtkWidget), TRUE);
			_tmp70_ = self->priv->worms3;
			_tmp71_ = gtk_button_get_child ((GtkButton*) _tmp70_);
			_tmp72_ = g_strconcat ("<b><span size=\"30.0pt\" font-family=\"Sans\">", _ (PLAYERS_ai0_label), NULL);
			_tmp73_ = _tmp72_;
			_tmp74_ = g_strconcat (_tmp73_, "</span></b>", NULL);
			_tmp75_ = _tmp74_;
			gtk_label_set_markup (G_TYPE_CHECK_INSTANCE_CAST (_tmp71_, gtk_label_get_type (), GtkLabel), _tmp75_);
			_g_free0 (_tmp75_);
			_g_free0 (_tmp73_);
			_tmp76_ = self->priv->worms4;
			_tmp77_ = gtk_button_get_child ((GtkButton*) _tmp76_);
			_tmp78_ = g_strconcat ("<b><span size=\"30.0pt\" font-family=\"Sans\">", _ (PLAYERS_ai1_label), NULL);
			_tmp79_ = _tmp78_;
			_tmp80_ = g_strconcat (_tmp79_, "</span></b>", NULL);
			_tmp81_ = _tmp80_;
			gtk_label_set_markup (G_TYPE_CHECK_INSTANCE_CAST (_tmp77_, gtk_label_get_type (), GtkLabel), _tmp81_);
			_g_free0 (_tmp81_);
			_g_free0 (_tmp79_);
			_tmp82_ = self->priv->worms5;
			_tmp83_ = gtk_button_get_child ((GtkButton*) _tmp82_);
			_tmp84_ = g_strconcat ("<b><span size=\"30.0pt\" font-family=\"Sans\">", _ (PLAYERS_ai2_label), NULL);
			_tmp85_ = _tmp84_;
			_tmp86_ = g_strconcat (_tmp85_, "</span></b>", NULL);
			_tmp87_ = _tmp86_;
			gtk_label_set_markup (G_TYPE_CHECK_INSTANCE_CAST (_tmp83_, gtk_label_get_type (), GtkLabel), _tmp87_);
			_g_free0 (_tmp87_);
			_g_free0 (_tmp85_);
			_tmp88_ = self->priv->worms6;
			_tmp89_ = gtk_button_get_child ((GtkButton*) _tmp88_);
			_tmp90_ = g_strconcat ("<b><span size=\"30.0pt\" font-family=\"Sans\">", _ (PLAYERS_ai3_label), NULL);
			_tmp91_ = _tmp90_;
			_tmp92_ = g_strconcat (_tmp91_, "</span></b>", NULL);
			_tmp93_ = _tmp92_;
			gtk_label_set_markup (G_TYPE_CHECK_INSTANCE_CAST (_tmp89_, gtk_label_get_type (), GtkLabel), _tmp93_);
			_g_free0 (_tmp93_);
			_g_free0 (_tmp91_);
			break;
		}
		case 4:
		{
			GtkToggleButton* _tmp94_;
			GtkToggleButton* _tmp95_;
			GtkToggleButton* _tmp96_;
			GtkWidget* _tmp97_;
			gchar* _tmp98_;
			gchar* _tmp99_;
			gchar* _tmp100_;
			gchar* _tmp101_;
			GtkToggleButton* _tmp102_;
			GtkWidget* _tmp103_;
			gchar* _tmp104_;
			gchar* _tmp105_;
			gchar* _tmp106_;
			gchar* _tmp107_;
			GtkToggleButton* _tmp108_;
			GtkWidget* _tmp109_;
			gchar* _tmp110_;
			gchar* _tmp111_;
			gchar* _tmp112_;
			gchar* _tmp113_;
			_tmp94_ = self->priv->worms2;
			gtk_widget_set_visible (G_TYPE_CHECK_INSTANCE_CAST (_tmp94_, gtk_widget_get_type (), GtkWidget), FALSE);
			_tmp95_ = self->priv->worms3;
			gtk_widget_set_visible (G_TYPE_CHECK_INSTANCE_CAST (_tmp95_, gtk_widget_get_type (), GtkWidget), FALSE);
			_tmp96_ = self->priv->worms4;
			_tmp97_ = gtk_button_get_child ((GtkButton*) _tmp96_);
			_tmp98_ = g_strconcat ("<b><span size=\"30.0pt\" font-family=\"Sans\">", _ (PLAYERS_ai0_label), NULL);
			_tmp99_ = _tmp98_;
			_tmp100_ = g_strconcat (_tmp99_, "</span></b>", NULL);
			_tmp101_ = _tmp100_;
			gtk_label_set_markup (G_TYPE_CHECK_INSTANCE_CAST (_tmp97_, gtk_label_get_type (), GtkLabel), _tmp101_);
			_g_free0 (_tmp101_);
			_g_free0 (_tmp99_);
			_tmp102_ = self->priv->worms5;
			_tmp103_ = gtk_button_get_child ((GtkButton*) _tmp102_);
			_tmp104_ = g_strconcat ("<b><span size=\"30.0pt\" font-family=\"Sans\">", _ (PLAYERS_ai1_label), NULL);
			_tmp105_ = _tmp104_;
			_tmp106_ = g_strconcat (_tmp105_, "</span></b>", NULL);
			_tmp107_ = _tmp106_;
			gtk_label_set_markup (G_TYPE_CHECK_INSTANCE_CAST (_tmp103_, gtk_label_get_type (), GtkLabel), _tmp107_);
			_g_free0 (_tmp107_);
			_g_free0 (_tmp105_);
			_tmp108_ = self->priv->worms6;
			_tmp109_ = gtk_button_get_child ((GtkButton*) _tmp108_);
			_tmp110_ = g_strconcat ("<b><span size=\"30.0pt\" font-family=\"Sans\">", _ (PLAYERS_ai2_label), NULL);
			_tmp111_ = _tmp110_;
			_tmp112_ = g_strconcat (_tmp111_, "</span></b>", NULL);
			_tmp113_ = _tmp112_;
			gtk_label_set_markup (G_TYPE_CHECK_INSTANCE_CAST (_tmp109_, gtk_label_get_type (), GtkLabel), _tmp113_);
			_g_free0 (_tmp113_);
			_g_free0 (_tmp111_);
			break;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
}

static GVariant*
_variant_new7 (gint32 value)
{
	return g_variant_ref_sink (g_variant_new_int32 (value));
}

static inline void
players_change_nibbles_number (Players* self,
                               GSimpleAction* _nibbles_number_action,
                               GVariant* variant)
{
	GVariant* _tmp0_;
	GSimpleAction* _tmp1_;
	GVariant* _tmp2_;
	GVariant* _tmp3_;
	GSimpleAction* _tmp4_;
	GVariant* _tmp5_;
	GVariant* _tmp6_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (_nibbles_number_action != NULL);
	g_return_if_fail (variant != NULL);
	_tmp0_ = _variant_new7 (g_variant_get_int32 (variant));
	g_simple_action_set_state (_nibbles_number_action, _tmp0_);
	_g_variant_unref0 (_tmp0_);
	_tmp1_ = self->priv->players_number_action;
	_tmp2_ = g_action_get_state ((GAction*) _tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = self->priv->players_number_action;
	_tmp5_ = g_action_get_state ((GAction*) _tmp4_);
	_tmp6_ = _tmp5_;
	players_set_worm_frames (self, (gint) g_variant_get_int32 (_tmp3_), players_to_ai_count (self, variant, _tmp6_));
	_g_variant_unref0 (_tmp6_);
	_g_variant_unref0 (_tmp3_);
}

static gint
players_to_ai_count (Players* self,
                     GVariant* v,
                     GVariant* players_count)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (v != NULL, 0);
	g_return_val_if_fail (players_count != NULL, 0);
	result = (gint) (g_variant_get_int32 (v) - g_variant_get_int32 (players_count));
	return result;
}

static void
players_set_player_frames (Players* self,
                           gint player_count)
{
	GtkToggleButton* _tmp0_;
	GtkToggleButton* _tmp1_;
	GtkToggleButton* _tmp2_;
	GtkToggleButton* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->players1;
	gtk_button_set_has_frame ((GtkButton*) _tmp0_, player_count == 1);
	_tmp1_ = self->priv->players2;
	gtk_button_set_has_frame ((GtkButton*) _tmp1_, player_count == 2);
	_tmp2_ = self->priv->players3;
	gtk_button_set_has_frame ((GtkButton*) _tmp2_, player_count == 3);
	_tmp3_ = self->priv->players4;
	gtk_button_set_has_frame ((GtkButton*) _tmp3_, player_count == 4);
}

static void
players_set_worm_frames (Players* self,
                         gint players,
                         gint ai)
{
	g_return_if_fail (self != NULL);
	switch (players) {
		case 1:
		{
			GtkToggleButton* _tmp0_;
			GtkToggleButton* _tmp1_;
			GtkToggleButton* _tmp2_;
			GtkToggleButton* _tmp3_;
			GtkToggleButton* _tmp4_;
			_tmp0_ = self->priv->worms2;
			gtk_button_set_has_frame ((GtkButton*) _tmp0_, ai == 1);
			_tmp1_ = self->priv->worms3;
			gtk_button_set_has_frame ((GtkButton*) _tmp1_, ai == 2);
			_tmp2_ = self->priv->worms4;
			gtk_button_set_has_frame ((GtkButton*) _tmp2_, ai == 3);
			_tmp3_ = self->priv->worms5;
			gtk_button_set_has_frame ((GtkButton*) _tmp3_, ai == 4);
			_tmp4_ = self->priv->worms6;
			gtk_button_set_has_frame ((GtkButton*) _tmp4_, ai == 5);
			break;
		}
		case 2:
		{
			GtkToggleButton* _tmp5_;
			GtkToggleButton* _tmp6_;
			GtkToggleButton* _tmp7_;
			GtkToggleButton* _tmp8_;
			GtkToggleButton* _tmp9_;
			_tmp5_ = self->priv->worms2;
			gtk_button_set_has_frame ((GtkButton*) _tmp5_, ai == 0);
			_tmp6_ = self->priv->worms3;
			gtk_button_set_has_frame ((GtkButton*) _tmp6_, ai == 1);
			_tmp7_ = self->priv->worms4;
			gtk_button_set_has_frame ((GtkButton*) _tmp7_, ai == 2);
			_tmp8_ = self->priv->worms5;
			gtk_button_set_has_frame ((GtkButton*) _tmp8_, ai == 3);
			_tmp9_ = self->priv->worms6;
			gtk_button_set_has_frame ((GtkButton*) _tmp9_, ai == 4);
			break;
		}
		case 3:
		{
			GtkToggleButton* _tmp10_;
			GtkToggleButton* _tmp11_;
			GtkToggleButton* _tmp12_;
			GtkToggleButton* _tmp13_;
			GtkToggleButton* _tmp14_;
			_tmp10_ = self->priv->worms2;
			gtk_button_set_has_frame ((GtkButton*) _tmp10_, FALSE);
			_tmp11_ = self->priv->worms3;
			gtk_button_set_has_frame ((GtkButton*) _tmp11_, ai == 0);
			_tmp12_ = self->priv->worms4;
			gtk_button_set_has_frame ((GtkButton*) _tmp12_, ai == 1);
			_tmp13_ = self->priv->worms5;
			gtk_button_set_has_frame ((GtkButton*) _tmp13_, ai == 2);
			_tmp14_ = self->priv->worms6;
			gtk_button_set_has_frame ((GtkButton*) _tmp14_, ai == 3);
			break;
		}
		case 4:
		{
			GtkToggleButton* _tmp15_;
			GtkToggleButton* _tmp16_;
			GtkToggleButton* _tmp17_;
			GtkToggleButton* _tmp18_;
			GtkToggleButton* _tmp19_;
			_tmp15_ = self->priv->worms2;
			gtk_button_set_has_frame ((GtkButton*) _tmp15_, FALSE);
			_tmp16_ = self->priv->worms3;
			gtk_button_set_has_frame ((GtkButton*) _tmp16_, FALSE);
			_tmp17_ = self->priv->worms4;
			gtk_button_set_has_frame ((GtkButton*) _tmp17_, ai == 0);
			_tmp18_ = self->priv->worms5;
			gtk_button_set_has_frame ((GtkButton*) _tmp18_, ai == 1);
			_tmp19_ = self->priv->worms6;
			gtk_button_set_has_frame ((GtkButton*) _tmp19_, ai == 2);
			break;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
}

Players*
players_construct (GType object_type)
{
	Players * self = NULL;
	self = (Players*) g_object_new (object_type, NULL);
	return self;
}

Players*
players_new (void)
{
	return players_construct (TYPE_PLAYERS);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static GObject *
players_constructor (GType type,
                     guint n_construct_properties,
                     GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	Players * self;
	GtkToggleButton* _tmp0_;
	GtkWidget* _tmp1_;
	GtkToggleButton* _tmp2_;
	GtkWidget* _tmp3_;
	GtkToggleButton* _tmp4_;
	GtkWidget* _tmp5_;
	GtkToggleButton* _tmp6_;
	GtkWidget* _tmp7_;
	GtkButton* _tmp8_;
	GSimpleActionGroup* action_group = NULL;
	GSimpleActionGroup* _tmp11_;
	GSimpleActionGroup* _tmp12_;
	GSimpleActionGroup* _tmp13_;
	GSimpleActionGroup* _tmp14_;
	GAction* _tmp15_;
	GSimpleAction* _tmp16_;
	GSimpleActionGroup* _tmp17_;
	GAction* _tmp18_;
	GSimpleAction* _tmp19_;
	parent_class = G_OBJECT_CLASS (players_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_PLAYERS, Players);
	_tmp0_ = self->priv->players1;
	_tmp1_ = gtk_button_get_child ((GtkButton*) _tmp0_);
	gtk_label_set_markup (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, gtk_label_get_type (), GtkLabel), "<b><span size=\"30.0pt\" font-family=\"Sans\">1</span></b>");
	_tmp2_ = self->priv->players2;
	_tmp3_ = gtk_button_get_child ((GtkButton*) _tmp2_);
	gtk_label_set_markup (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, gtk_label_get_type (), GtkLabel), "<b><span size=\"30.0pt\" font-family=\"Sans\">2</span></b>");
	_tmp4_ = self->priv->players3;
	_tmp5_ = gtk_button_get_child ((GtkButton*) _tmp4_);
	gtk_label_set_markup (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, gtk_label_get_type (), GtkLabel), "<b><span size=\"30.0pt\" font-family=\"Sans\">3</span></b>");
	_tmp6_ = self->priv->players4;
	_tmp7_ = gtk_button_get_child ((GtkButton*) _tmp6_);
	gtk_label_set_markup (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, gtk_label_get_type (), GtkLabel), "<b><span size=\"30.0pt\" font-family=\"Sans\">4</span></b>");
	_tmp8_ = self->priv->button;
	if (gtk_widget_has_css_class ((GtkWidget*) _tmp8_, "play")) {
		GtkButton* _tmp9_;
		GtkButton* _tmp10_;
		_tmp9_ = self->priv->button;
		gtk_widget_remove_css_class ((GtkWidget*) _tmp9_, "play");
		_tmp10_ = self->priv->button;
		gtk_widget_add_css_class ((GtkWidget*) _tmp10_, "pill");
	}
	_tmp11_ = g_simple_action_group_new ();
	action_group = _tmp11_;
	_tmp12_ = action_group;
	g_action_map_add_action_entries ((GActionMap*) _tmp12_, PLAYERS_players_action_entries, (gint) G_N_ELEMENTS (PLAYERS_players_action_entries), self);
	_tmp13_ = action_group;
	gtk_widget_insert_action_group ((GtkWidget*) self, "players", (GActionGroup*) _tmp13_);
	_tmp14_ = action_group;
	_tmp15_ = g_action_map_lookup_action ((GActionMap*) _tmp14_, "change-nibbles-number");
	_tmp16_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, g_simple_action_get_type (), GSimpleAction));
	_g_object_unref0 (self->priv->nibbles_number_action);
	self->priv->nibbles_number_action = _tmp16_;
	_tmp17_ = action_group;
	_tmp18_ = g_action_map_lookup_action ((GActionMap*) _tmp17_, "change-players-number");
	_tmp19_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp18_, g_simple_action_get_type (), GSimpleAction));
	_g_object_unref0 (self->priv->players_number_action);
	self->priv->players_number_action = _tmp19_;
	_g_object_unref0 (action_group);
	return obj;
}

static void
players_class_init (PlayersClass * klass,
                    gpointer klass_data)
{
	players_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &Players_private_offset);
	G_OBJECT_CLASS (klass)->constructor = players_constructor;
	G_OBJECT_CLASS (klass)->finalize = players_finalize;
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/org/gnome/Nibbles/ui/players.ui");
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "players1", FALSE, Players_private_offset + G_STRUCT_OFFSET (PlayersPrivate, players1));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "players2", FALSE, Players_private_offset + G_STRUCT_OFFSET (PlayersPrivate, players2));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "players3", FALSE, Players_private_offset + G_STRUCT_OFFSET (PlayersPrivate, players3));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "players4", FALSE, Players_private_offset + G_STRUCT_OFFSET (PlayersPrivate, players4));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "worms2", FALSE, Players_private_offset + G_STRUCT_OFFSET (PlayersPrivate, worms2));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "worms3", FALSE, Players_private_offset + G_STRUCT_OFFSET (PlayersPrivate, worms3));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "worms4", FALSE, Players_private_offset + G_STRUCT_OFFSET (PlayersPrivate, worms4));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "worms5", FALSE, Players_private_offset + G_STRUCT_OFFSET (PlayersPrivate, worms5));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "worms6", FALSE, Players_private_offset + G_STRUCT_OFFSET (PlayersPrivate, worms6));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "button", FALSE, Players_private_offset + G_STRUCT_OFFSET (PlayersPrivate, button));
}

static void
players_instance_init (Players * self,
                       gpointer klass)
{
	self->priv = players_get_instance_private (self);
	gtk_widget_init_template (GTK_WIDGET (self));
}

static void
players_finalize (GObject * obj)
{
	Players * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_PLAYERS, Players);
	_g_object_unref0 (self->priv->nibbles_number_action);
	_g_object_unref0 (self->priv->players_number_action);
	G_OBJECT_CLASS (players_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
players_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PlayersClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) players_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Players), 0, (GInstanceInitFunc) players_instance_init, NULL };
	GType players_type_id;
	players_type_id = g_type_register_static (gtk_box_get_type (), "Players", &g_define_type_info, 0);
	Players_private_offset = g_type_add_instance_private (players_type_id, sizeof (PlayersPrivate));
	return players_type_id;
}

GType
players_get_type (void)
{
	static gsize players_type_id__once = 0;
	if (g_once_init_enter (&players_type_id__once)) {
		GType players_type_id;
		players_type_id = players_get_type_once ();
		g_once_init_leave (&players_type_id__once, players_type_id);
	}
	return players_type_id__once;
}

