/*
 * Copyright 2020 Free Software Foundation, Inc.
 *
 * This file is part of GNU Radio
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 *
 */
#include "pydoc_macros.h"
#define D(...) DOC(gr, dtv, __VA_ARGS__)
/*
  This file contains placeholders for docstrings for the Python bindings.
  Do not edit! These were automatically extracted during the binding process
  and will be overwritten during the build process
 */


static const char* __doc_gr_dtv_catv_frame_sync_enc_bb = R"doc(Frame Sync Encoder. Adds a 42-bit (64QAM) or 40-bit (256QAM) frame sync pattern with control word.

Input: Scrambled FEC Frame packets of 60 * 128 (64QAM) or 88 * 128 (256QAM) 7-bit symbols.
 Output: Scrambled FEC Frame packets of 60 * 128 (64QAM) or 88 * 128 (256QAM) 7-bit symbols with 42-bit (64QAM) or 40-bit (256QAM) FSYNC word.

Constructor Specific Documentation:

Create an ITU-T J.83B Frame Sync Encoder.

Args:
    constellation : 64QAM or 256QAM constellation.
    ctrlword : convolutional interleaver control word.)doc";


static const char* __doc_gr_dtv_catv_frame_sync_enc_bb_catv_frame_sync_enc_bb =
    R"doc()doc";


static const char* __doc_gr_dtv_catv_frame_sync_enc_bb_make = R"doc(Frame Sync Encoder. Adds a 42-bit (64QAM) or 40-bit (256QAM) frame sync pattern with control word.

Input: Scrambled FEC Frame packets of 60 * 128 (64QAM) or 88 * 128 (256QAM) 7-bit symbols.
 Output: Scrambled FEC Frame packets of 60 * 128 (64QAM) or 88 * 128 (256QAM) 7-bit symbols with 42-bit (64QAM) or 40-bit (256QAM) FSYNC word.

Constructor Specific Documentation:

Create an ITU-T J.83B Frame Sync Encoder.

Args:
    constellation : 64QAM or 256QAM constellation.
    ctrlword : convolutional interleaver control word.)doc";
