/*
 * Copyright 2024 Free Software Foundation, Inc.
 *
 * This file is part of GNU Radio
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 *
 */
#include "pydoc_macros.h"
#define D(...) DOC(gr, uhd, __VA_ARGS__)
/*
  This file contains placeholders for docstrings for the Python bindings.
  Do not edit! These were automatically extracted during the binding process
  and will be overwritten during the build process
 */

static const char* __doc_gr_uhd_rfnoc_rx_radio = R"doc(RFNoC RX Radio


This wraps a radio block into GNU Radio. Note: When doing TX and RX in the same flow graph, simply create an rfnoc_rx_radio and an rfnoc_tx_radio with the same block ID.

Constructor Specific Documentation:



Args:
    graph : Reference to the underlying rfnoc_graph object
    block_args : Additional block arguments
    device_select : Device Selection
    instance : Instance Selection)doc";

static const char* __doc_gr_uhd_rfnoc_rx_radio_rfnoc_rx_radio_0 = R"doc()doc";

static const char* __doc_gr_uhd_rfnoc_rx_radio_rfnoc_rx_radio_1 = R"doc()doc";

static const char* __doc_gr_uhd_rfnoc_rx_radio_make = R"doc(RFNoC RX Radio


This wraps a radio block into GNU Radio. Note: When doing TX and RX in the same flow graph, simply create an rfnoc_rx_radio and an rfnoc_tx_radio with the same block ID.

Constructor Specific Documentation:



Args:
    graph : Reference to the underlying rfnoc_graph object
    block_args : Additional block arguments
    device_select : Device Selection
    instance : Instance Selection)doc";

static const char* __doc_gr_uhd_rfnoc_rx_radio_set_rate = R"doc(Set the output sampling rate of the radio block.)doc";

static const char* __doc_gr_uhd_rfnoc_rx_radio_set_antenna = R"doc(Set the antenna for this radio.)doc";

static const char* __doc_gr_uhd_rfnoc_rx_radio_set_frequency = R"doc(Set the RX frequency for this radio.)doc";

static const char* __doc_gr_uhd_rfnoc_rx_radio_set_tune_args = R"doc(Configure the tune args for this RX radio.)doc";

static const char* __doc_gr_uhd_rfnoc_rx_radio_set_gain_0 = R"doc()doc";

static const char* __doc_gr_uhd_rfnoc_rx_radio_set_gain_1 = R"doc()doc";

static const char* __doc_gr_uhd_rfnoc_rx_radio_set_agc = R"doc(Enable/disable the AGC for this RX radio (if available).)doc";

static const char* __doc_gr_uhd_rfnoc_rx_radio_set_gain_profile = R"doc(Switch the gain profile for this RX radio.)doc";

static const char* __doc_gr_uhd_rfnoc_rx_radio_set_bandwidth = R"doc(Set the analog bandwidth for this RX radio.)doc";

static const char* __doc_gr_uhd_rfnoc_rx_radio_set_lo_source = R"doc(Set the LO source for this RX radio.)doc";

static const char* __doc_gr_uhd_rfnoc_rx_radio_set_lo_export_enabled = R"doc(Enable/disable LO export for this RX radio.)doc";

static const char* __doc_gr_uhd_rfnoc_rx_radio_set_lo_freq = R"doc(Configure the LO frequency explicitly.)doc";

static const char* __doc_gr_uhd_rfnoc_rx_radio_set_dc_offset_0 = R"doc()doc";

static const char* __doc_gr_uhd_rfnoc_rx_radio_set_dc_offset_1 = R"doc()doc";

static const char* __doc_gr_uhd_rfnoc_rx_radio_set_iq_balance_0 = R"doc()doc";

static const char* __doc_gr_uhd_rfnoc_rx_radio_set_iq_balance_1 = R"doc()doc";

static const char* __doc_gr_uhd_rfnoc_rx_radio_issue_stream_cmd = R"doc(Issue a stream command to specific channels


This behaves differently from usrp_source::issue_stream_cmd() in two ways:)doc";

static const char* __doc_gr_uhd_rfnoc_rx_radio_enable_rx_timestamps = R"doc(Enable/disable timestamp generation on a radio channel.)doc";
