{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- @GtkAssistantPage@ is an auxiliary object used by @GtkAssistant@.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gtk.Objects.AssistantPage
    ( 

-- * Exported types
    AssistantPage(..)                       ,
    IsAssistantPage                         ,
    toAssistantPage                         ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [bindProperty]("GI.GObject.Objects.Object#g:method:bindProperty"), [bindPropertyFull]("GI.GObject.Objects.Object#g:method:bindPropertyFull"), [forceFloating]("GI.GObject.Objects.Object#g:method:forceFloating"), [freezeNotify]("GI.GObject.Objects.Object#g:method:freezeNotify"), [getv]("GI.GObject.Objects.Object#g:method:getv"), [isFloating]("GI.GObject.Objects.Object#g:method:isFloating"), [notify]("GI.GObject.Objects.Object#g:method:notify"), [notifyByPspec]("GI.GObject.Objects.Object#g:method:notifyByPspec"), [ref]("GI.GObject.Objects.Object#g:method:ref"), [refSink]("GI.GObject.Objects.Object#g:method:refSink"), [runDispose]("GI.GObject.Objects.Object#g:method:runDispose"), [stealData]("GI.GObject.Objects.Object#g:method:stealData"), [stealQdata]("GI.GObject.Objects.Object#g:method:stealQdata"), [thawNotify]("GI.GObject.Objects.Object#g:method:thawNotify"), [unref]("GI.GObject.Objects.Object#g:method:unref"), [watchClosure]("GI.GObject.Objects.Object#g:method:watchClosure").
-- 
-- ==== Getters
-- [getChild]("GI.Gtk.Objects.AssistantPage#g:method:getChild"), [getData]("GI.GObject.Objects.Object#g:method:getData"), [getProperty]("GI.GObject.Objects.Object#g:method:getProperty"), [getQdata]("GI.GObject.Objects.Object#g:method:getQdata").
-- 
-- ==== Setters
-- [setData]("GI.GObject.Objects.Object#g:method:setData"), [setDataFull]("GI.GObject.Objects.Object#g:method:setDataFull"), [setProperty]("GI.GObject.Objects.Object#g:method:setProperty").

#if defined(ENABLE_OVERLOADING)
    ResolveAssistantPageMethod              ,
#endif

-- ** getChild #method:getChild#

#if defined(ENABLE_OVERLOADING)
    AssistantPageGetChildMethodInfo         ,
#endif
    assistantPageGetChild                   ,




 -- * Properties


-- ** child #attr:child#
-- | The child widget.

#if defined(ENABLE_OVERLOADING)
    AssistantPageChildPropertyInfo          ,
#endif
#if defined(ENABLE_OVERLOADING)
    assistantPageChild                      ,
#endif
    constructAssistantPageChild             ,
    getAssistantPageChild                   ,


-- ** complete #attr:complete#
-- | Whether all required fields are filled in.
-- 
-- GTK uses this information to control the sensitivity
-- of the navigation buttons.

#if defined(ENABLE_OVERLOADING)
    AssistantPageCompletePropertyInfo       ,
#endif
#if defined(ENABLE_OVERLOADING)
    assistantPageComplete                   ,
#endif
    constructAssistantPageComplete          ,
    getAssistantPageComplete                ,
    setAssistantPageComplete                ,


-- ** pageType #attr:pageType#
-- | The type of the assistant page.

#if defined(ENABLE_OVERLOADING)
    AssistantPagePageTypePropertyInfo       ,
#endif
#if defined(ENABLE_OVERLOADING)
    assistantPagePageType                   ,
#endif
    constructAssistantPagePageType          ,
    getAssistantPagePageType                ,
    setAssistantPagePageType                ,


-- ** title #attr:title#
-- | The title of the page.

#if defined(ENABLE_OVERLOADING)
    AssistantPageTitlePropertyInfo          ,
#endif
#if defined(ENABLE_OVERLOADING)
    assistantPageTitle                      ,
#endif
    clearAssistantPageTitle                 ,
    constructAssistantPageTitle             ,
    getAssistantPageTitle                   ,
    setAssistantPageTitle                   ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.Cairo.Structs.Context as Cairo.Context
import qualified GI.Cairo.Structs.FontOptions as Cairo.FontOptions
import qualified GI.GLib.Callbacks as GLib.Callbacks
import qualified GI.GLib.Structs.Bytes as GLib.Bytes
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gdk.Flags as Gdk.Flags
import qualified GI.Gdk.Interfaces.Paintable as Gdk.Paintable
import qualified GI.Gdk.Objects.Clipboard as Gdk.Clipboard
import qualified GI.Gdk.Objects.Cursor as Gdk.Cursor
import qualified GI.Gdk.Objects.Device as Gdk.Device
import qualified GI.Gdk.Objects.Display as Gdk.Display
import qualified GI.Gdk.Objects.Event as Gdk.Event
import qualified GI.Gdk.Objects.FrameClock as Gdk.FrameClock
import qualified GI.Gdk.Objects.Snapshot as Gdk.Snapshot
import qualified GI.Gdk.Objects.Surface as Gdk.Surface
import qualified GI.Gdk.Objects.Texture as Gdk.Texture
import qualified GI.Gdk.Structs.RGBA as Gdk.RGBA
import qualified GI.Gdk.Structs.Rectangle as Gdk.Rectangle
import qualified GI.Gio.Interfaces.ActionGroup as Gio.ActionGroup
import qualified GI.Gio.Interfaces.Icon as Gio.Icon
import qualified GI.Gio.Interfaces.ListModel as Gio.ListModel
import qualified GI.Graphene.Structs.Matrix as Graphene.Matrix
import qualified GI.Graphene.Structs.Point as Graphene.Point
import qualified GI.Graphene.Structs.Point3D as Graphene.Point3D
import qualified GI.Graphene.Structs.Rect as Graphene.Rect
import qualified GI.Graphene.Structs.Size as Graphene.Size
import qualified GI.Graphene.Structs.Vec3 as Graphene.Vec3
import qualified GI.Graphene.Structs.Vec4 as Graphene.Vec4
import qualified GI.Gsk.Enums as Gsk.Enums
import qualified GI.Gsk.Objects.GLShader as Gsk.GLShader
import qualified GI.Gsk.Objects.RenderNode as Gsk.RenderNode
import qualified GI.Gsk.Objects.Renderer as Gsk.Renderer
import qualified GI.Gsk.Structs.ColorStop as Gsk.ColorStop
import qualified GI.Gsk.Structs.ComponentTransfer as Gsk.ComponentTransfer
import qualified GI.Gsk.Structs.Path as Gsk.Path
import qualified GI.Gsk.Structs.RoundedRect as Gsk.RoundedRect
import qualified GI.Gsk.Structs.Shadow as Gsk.Shadow
import qualified GI.Gsk.Structs.Stroke as Gsk.Stroke
import qualified GI.Gsk.Structs.Transform as Gsk.Transform
import qualified GI.Gtk.Callbacks as Gtk.Callbacks
import {-# SOURCE #-} qualified GI.Gtk.Enums as Gtk.Enums
import {-# SOURCE #-} qualified GI.Gtk.Flags as Gtk.Flags
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Accessible as Gtk.Accessible
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Buildable as Gtk.Buildable
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.ConstraintTarget as Gtk.ConstraintTarget
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Native as Gtk.Native
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Root as Gtk.Root
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.StyleProvider as Gtk.StyleProvider
import {-# SOURCE #-} qualified GI.Gtk.Objects.ATContext as Gtk.ATContext
import {-# SOURCE #-} qualified GI.Gtk.Objects.EventController as Gtk.EventController
import {-# SOURCE #-} qualified GI.Gtk.Objects.LayoutChild as Gtk.LayoutChild
import {-# SOURCE #-} qualified GI.Gtk.Objects.LayoutManager as Gtk.LayoutManager
import {-# SOURCE #-} qualified GI.Gtk.Objects.Settings as Gtk.Settings
import {-# SOURCE #-} qualified GI.Gtk.Objects.Snapshot as Gtk.Snapshot
import {-# SOURCE #-} qualified GI.Gtk.Objects.StyleContext as Gtk.StyleContext
import {-# SOURCE #-} qualified GI.Gtk.Objects.Tooltip as Gtk.Tooltip
import {-# SOURCE #-} qualified GI.Gtk.Objects.Widget as Gtk.Widget
import {-# SOURCE #-} qualified GI.Gtk.Structs.Border as Gtk.Border
import {-# SOURCE #-} qualified GI.Gtk.Structs.Requisition as Gtk.Requisition
import qualified GI.Pango.Enums as Pango.Enums
import qualified GI.Pango.Objects.Context as Pango.Context
import qualified GI.Pango.Objects.FontMap as Pango.FontMap
import qualified GI.Pango.Objects.Layout as Pango.Layout

#else
import qualified GI.GObject.Objects.Object as GObject.Object
import {-# SOURCE #-} qualified GI.Gtk.Enums as Gtk.Enums
import {-# SOURCE #-} qualified GI.Gtk.Objects.Widget as Gtk.Widget

#endif

-- | Memory-managed wrapper type.
newtype AssistantPage = AssistantPage (SP.ManagedPtr AssistantPage)
    deriving (Eq)

instance SP.ManagedPtrNewtype AssistantPage where
    toManagedPtr (AssistantPage p) = p

foreign import ccall "gtk_assistant_page_get_type"
    c_gtk_assistant_page_get_type :: IO B.Types.GType

instance B.Types.TypedObject AssistantPage where
    glibType = c_gtk_assistant_page_get_type

instance B.Types.GObject AssistantPage

-- | Type class for types which can be safely cast to t'AssistantPage', for instance with `toAssistantPage`.
class (SP.GObject o, O.IsDescendantOf AssistantPage o) => IsAssistantPage o
instance (SP.GObject o, O.IsDescendantOf AssistantPage o) => IsAssistantPage o

instance O.HasParentTypes AssistantPage
type instance O.ParentTypes AssistantPage = '[GObject.Object.Object]

-- | Cast to t'AssistantPage', for types for which this is known to be safe. For general casts, use 'Data.GI.Base.ManagedPtr.castTo'.
toAssistantPage :: (MIO.MonadIO m, IsAssistantPage o) => o -> m AssistantPage
toAssistantPage = MIO.liftIO . B.ManagedPtr.unsafeCastTo AssistantPage

-- | Convert t'AssistantPage' to and from t'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe AssistantPage) where
    gvalueGType_ = c_gtk_assistant_page_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_object gv (FP.nullPtr :: FP.Ptr AssistantPage)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_object gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_object gv :: IO (FP.Ptr AssistantPage)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newObject AssistantPage ptr
        else return P.Nothing
        
    

#if defined(ENABLE_OVERLOADING)
type family ResolveAssistantPageMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveAssistantPageMethod "bindProperty" o = GObject.Object.ObjectBindPropertyMethodInfo
    ResolveAssistantPageMethod "bindPropertyFull" o = GObject.Object.ObjectBindPropertyFullMethodInfo
    ResolveAssistantPageMethod "forceFloating" o = GObject.Object.ObjectForceFloatingMethodInfo
    ResolveAssistantPageMethod "freezeNotify" o = GObject.Object.ObjectFreezeNotifyMethodInfo
    ResolveAssistantPageMethod "getv" o = GObject.Object.ObjectGetvMethodInfo
    ResolveAssistantPageMethod "isFloating" o = GObject.Object.ObjectIsFloatingMethodInfo
    ResolveAssistantPageMethod "notify" o = GObject.Object.ObjectNotifyMethodInfo
    ResolveAssistantPageMethod "notifyByPspec" o = GObject.Object.ObjectNotifyByPspecMethodInfo
    ResolveAssistantPageMethod "ref" o = GObject.Object.ObjectRefMethodInfo
    ResolveAssistantPageMethod "refSink" o = GObject.Object.ObjectRefSinkMethodInfo
    ResolveAssistantPageMethod "runDispose" o = GObject.Object.ObjectRunDisposeMethodInfo
    ResolveAssistantPageMethod "stealData" o = GObject.Object.ObjectStealDataMethodInfo
    ResolveAssistantPageMethod "stealQdata" o = GObject.Object.ObjectStealQdataMethodInfo
    ResolveAssistantPageMethod "thawNotify" o = GObject.Object.ObjectThawNotifyMethodInfo
    ResolveAssistantPageMethod "unref" o = GObject.Object.ObjectUnrefMethodInfo
    ResolveAssistantPageMethod "watchClosure" o = GObject.Object.ObjectWatchClosureMethodInfo
    ResolveAssistantPageMethod "getChild" o = AssistantPageGetChildMethodInfo
    ResolveAssistantPageMethod "getData" o = GObject.Object.ObjectGetDataMethodInfo
    ResolveAssistantPageMethod "getProperty" o = GObject.Object.ObjectGetPropertyMethodInfo
    ResolveAssistantPageMethod "getQdata" o = GObject.Object.ObjectGetQdataMethodInfo
    ResolveAssistantPageMethod "setData" o = GObject.Object.ObjectSetDataMethodInfo
    ResolveAssistantPageMethod "setDataFull" o = GObject.Object.ObjectSetDataFullMethodInfo
    ResolveAssistantPageMethod "setProperty" o = GObject.Object.ObjectSetPropertyMethodInfo
    ResolveAssistantPageMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveAssistantPageMethod t AssistantPage, O.OverloadedMethod info AssistantPage p) => OL.IsLabel t (AssistantPage -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveAssistantPageMethod t AssistantPage, O.OverloadedMethod info AssistantPage p, R.HasField t AssistantPage p) => R.HasField t AssistantPage p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveAssistantPageMethod t AssistantPage, O.OverloadedMethodInfo info AssistantPage) => OL.IsLabel t (O.MethodProxy info AssistantPage) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

-- VVV Prop "child"
   -- Type: TInterface (Name {namespace = "Gtk", name = "Widget"})
   -- Flags: [PropertyReadable,PropertyWritable,PropertyConstructOnly]
   -- Nullable: (Just False,Nothing)

-- | Get the value of the “@child@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' assistantPage #child
-- @
getAssistantPageChild :: (MonadIO m, IsAssistantPage o) => o -> m Gtk.Widget.Widget
getAssistantPageChild obj = MIO.liftIO $ checkUnexpectedNothing "getAssistantPageChild" $ B.Properties.getObjectPropertyObject obj "child" Gtk.Widget.Widget

-- | Construct a t'GValueConstruct' with valid value for the “@child@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructAssistantPageChild :: (IsAssistantPage o, MIO.MonadIO m, Gtk.Widget.IsWidget a) => a -> m (GValueConstruct o)
constructAssistantPageChild val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyObject "child" (P.Just val)

#if defined(ENABLE_OVERLOADING)
data AssistantPageChildPropertyInfo
instance AttrInfo AssistantPageChildPropertyInfo where
    type AttrAllowedOps AssistantPageChildPropertyInfo = '[ 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrBaseTypeConstraint AssistantPageChildPropertyInfo = IsAssistantPage
    type AttrSetTypeConstraint AssistantPageChildPropertyInfo = Gtk.Widget.IsWidget
    type AttrTransferTypeConstraint AssistantPageChildPropertyInfo = Gtk.Widget.IsWidget
    type AttrTransferType AssistantPageChildPropertyInfo = Gtk.Widget.Widget
    type AttrGetType AssistantPageChildPropertyInfo = Gtk.Widget.Widget
    type AttrLabel AssistantPageChildPropertyInfo = "child"
    type AttrOrigin AssistantPageChildPropertyInfo = AssistantPage
    attrGet = getAssistantPageChild
    attrSet = undefined
    attrPut = undefined
    attrTransfer _ v = do
        unsafeCastTo Gtk.Widget.Widget v
    attrConstruct = constructAssistantPageChild
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.AssistantPage.child"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-AssistantPage.html#g:attr:child"
        })
#endif

-- VVV Prop "complete"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Nothing,Nothing)

-- | Get the value of the “@complete@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' assistantPage #complete
-- @
getAssistantPageComplete :: (MonadIO m, IsAssistantPage o) => o -> m Bool
getAssistantPageComplete obj = MIO.liftIO $ B.Properties.getObjectPropertyBool obj "complete"

-- | Set the value of the “@complete@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' assistantPage [ #complete 'Data.GI.Base.Attributes.:=' value ]
-- @
setAssistantPageComplete :: (MonadIO m, IsAssistantPage o) => o -> Bool -> m ()
setAssistantPageComplete obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyBool obj "complete" val

-- | Construct a t'GValueConstruct' with valid value for the “@complete@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructAssistantPageComplete :: (IsAssistantPage o, MIO.MonadIO m) => Bool -> m (GValueConstruct o)
constructAssistantPageComplete val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyBool "complete" val

#if defined(ENABLE_OVERLOADING)
data AssistantPageCompletePropertyInfo
instance AttrInfo AssistantPageCompletePropertyInfo where
    type AttrAllowedOps AssistantPageCompletePropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrPut]
    type AttrBaseTypeConstraint AssistantPageCompletePropertyInfo = IsAssistantPage
    type AttrSetTypeConstraint AssistantPageCompletePropertyInfo = (~) Bool
    type AttrTransferTypeConstraint AssistantPageCompletePropertyInfo = (~) Bool
    type AttrTransferType AssistantPageCompletePropertyInfo = Bool
    type AttrGetType AssistantPageCompletePropertyInfo = Bool
    type AttrLabel AssistantPageCompletePropertyInfo = "complete"
    type AttrOrigin AssistantPageCompletePropertyInfo = AssistantPage
    attrGet = getAssistantPageComplete
    attrSet = setAssistantPageComplete
    attrPut = setAssistantPageComplete
    attrTransfer _ v = do
        return v
    attrConstruct = constructAssistantPageComplete
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.AssistantPage.complete"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-AssistantPage.html#g:attr:complete"
        })
#endif

-- VVV Prop "page-type"
   -- Type: TInterface (Name {namespace = "Gtk", name = "AssistantPageType"})
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Nothing,Nothing)

-- | Get the value of the “@page-type@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' assistantPage #pageType
-- @
getAssistantPagePageType :: (MonadIO m, IsAssistantPage o) => o -> m Gtk.Enums.AssistantPageType
getAssistantPagePageType obj = MIO.liftIO $ B.Properties.getObjectPropertyEnum obj "page-type"

-- | Set the value of the “@page-type@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' assistantPage [ #pageType 'Data.GI.Base.Attributes.:=' value ]
-- @
setAssistantPagePageType :: (MonadIO m, IsAssistantPage o) => o -> Gtk.Enums.AssistantPageType -> m ()
setAssistantPagePageType obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyEnum obj "page-type" val

-- | Construct a t'GValueConstruct' with valid value for the “@page-type@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructAssistantPagePageType :: (IsAssistantPage o, MIO.MonadIO m) => Gtk.Enums.AssistantPageType -> m (GValueConstruct o)
constructAssistantPagePageType val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyEnum "page-type" val

#if defined(ENABLE_OVERLOADING)
data AssistantPagePageTypePropertyInfo
instance AttrInfo AssistantPagePageTypePropertyInfo where
    type AttrAllowedOps AssistantPagePageTypePropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrPut]
    type AttrBaseTypeConstraint AssistantPagePageTypePropertyInfo = IsAssistantPage
    type AttrSetTypeConstraint AssistantPagePageTypePropertyInfo = (~) Gtk.Enums.AssistantPageType
    type AttrTransferTypeConstraint AssistantPagePageTypePropertyInfo = (~) Gtk.Enums.AssistantPageType
    type AttrTransferType AssistantPagePageTypePropertyInfo = Gtk.Enums.AssistantPageType
    type AttrGetType AssistantPagePageTypePropertyInfo = Gtk.Enums.AssistantPageType
    type AttrLabel AssistantPagePageTypePropertyInfo = "page-type"
    type AttrOrigin AssistantPagePageTypePropertyInfo = AssistantPage
    attrGet = getAssistantPagePageType
    attrSet = setAssistantPagePageType
    attrPut = setAssistantPagePageType
    attrTransfer _ v = do
        return v
    attrConstruct = constructAssistantPagePageType
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.AssistantPage.pageType"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-AssistantPage.html#g:attr:pageType"
        })
#endif

-- VVV Prop "title"
   -- Type: TBasicType TUTF8
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Nothing,Nothing)

-- | Get the value of the “@title@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' assistantPage #title
-- @
getAssistantPageTitle :: (MonadIO m, IsAssistantPage o) => o -> m (Maybe T.Text)
getAssistantPageTitle obj = MIO.liftIO $ B.Properties.getObjectPropertyString obj "title"

-- | Set the value of the “@title@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' assistantPage [ #title 'Data.GI.Base.Attributes.:=' value ]
-- @
setAssistantPageTitle :: (MonadIO m, IsAssistantPage o) => o -> T.Text -> m ()
setAssistantPageTitle obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyString obj "title" (Just val)

-- | Construct a t'GValueConstruct' with valid value for the “@title@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructAssistantPageTitle :: (IsAssistantPage o, MIO.MonadIO m) => T.Text -> m (GValueConstruct o)
constructAssistantPageTitle val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyString "title" (P.Just val)

-- | Set the value of the “@title@” property to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #title
-- @
clearAssistantPageTitle :: (MonadIO m, IsAssistantPage o) => o -> m ()
clearAssistantPageTitle obj = liftIO $ B.Properties.setObjectPropertyString obj "title" (Nothing :: Maybe T.Text)

#if defined(ENABLE_OVERLOADING)
data AssistantPageTitlePropertyInfo
instance AttrInfo AssistantPageTitlePropertyInfo where
    type AttrAllowedOps AssistantPageTitlePropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrBaseTypeConstraint AssistantPageTitlePropertyInfo = IsAssistantPage
    type AttrSetTypeConstraint AssistantPageTitlePropertyInfo = (~) T.Text
    type AttrTransferTypeConstraint AssistantPageTitlePropertyInfo = (~) T.Text
    type AttrTransferType AssistantPageTitlePropertyInfo = T.Text
    type AttrGetType AssistantPageTitlePropertyInfo = (Maybe T.Text)
    type AttrLabel AssistantPageTitlePropertyInfo = "title"
    type AttrOrigin AssistantPageTitlePropertyInfo = AssistantPage
    attrGet = getAssistantPageTitle
    attrSet = setAssistantPageTitle
    attrPut = undefined
    attrTransfer _ v = do
        return v
    attrConstruct = constructAssistantPageTitle
    attrClear = clearAssistantPageTitle
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.AssistantPage.title"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-AssistantPage.html#g:attr:title"
        })
#endif

#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList AssistantPage
type instance O.AttributeList AssistantPage = AssistantPageAttributeList
type AssistantPageAttributeList = ('[ '("child", AssistantPageChildPropertyInfo), '("complete", AssistantPageCompletePropertyInfo), '("pageType", AssistantPagePageTypePropertyInfo), '("title", AssistantPageTitlePropertyInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
assistantPageChild :: AttrLabelProxy "child"
assistantPageChild = AttrLabelProxy

assistantPageComplete :: AttrLabelProxy "complete"
assistantPageComplete = AttrLabelProxy

assistantPagePageType :: AttrLabelProxy "pageType"
assistantPagePageType = AttrLabelProxy

assistantPageTitle :: AttrLabelProxy "title"
assistantPageTitle = AttrLabelProxy

#endif

#if defined(ENABLE_OVERLOADING)
type instance O.SignalList AssistantPage = AssistantPageSignalList
type AssistantPageSignalList = ('[ '("notify", GObject.Object.ObjectNotifySignalInfo)] :: [(Symbol, DK.Type)])

#endif

-- method AssistantPage::get_child
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "page"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "AssistantPage" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkAssistantPage`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gtk" , name = "Widget" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_assistant_page_get_child" gtk_assistant_page_get_child :: 
    Ptr AssistantPage ->                    -- page : TInterface (Name {namespace = "Gtk", name = "AssistantPage"})
    IO (Ptr Gtk.Widget.Widget)

{-# DEPRECATED assistantPageGetChild ["(Since version 4.10)","This widget will be removed in GTK 5"] #-}
-- | Returns the child to which /@page@/ belongs.
assistantPageGetChild ::
    (B.CallStack.HasCallStack, MonadIO m, IsAssistantPage a) =>
    a
    -- ^ /@page@/: a @GtkAssistantPage@
    -> m Gtk.Widget.Widget
    -- ^ __Returns:__ the child to which /@page@/ belongs
assistantPageGetChild page = liftIO $ do
    page' <- unsafeManagedPtrCastPtr page
    result <- gtk_assistant_page_get_child page'
    checkUnexpectedReturnNULL "assistantPageGetChild" result
    result' <- (newObject Gtk.Widget.Widget) result
    touchManagedPtr page
    return result'

#if defined(ENABLE_OVERLOADING)
data AssistantPageGetChildMethodInfo
instance (signature ~ (m Gtk.Widget.Widget), MonadIO m, IsAssistantPage a) => O.OverloadedMethod AssistantPageGetChildMethodInfo a signature where
    overloadedMethod = assistantPageGetChild

instance O.OverloadedMethodInfo AssistantPageGetChildMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.AssistantPage.assistantPageGetChild",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-AssistantPage.html#v:assistantPageGetChild"
        })


#endif


