// Copyright 2017 Istio Authors
//
//   Licensed under the Apache License, Version 2.0 (the "License");
//   you may not use this file except in compliance with the License.
//   You may obtain a copy of the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in writing, software
//   distributed under the License is distributed on an "AS IS" BASIS,
//   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//   See the License for the specific language governing permissions and
//   limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.36.11
// 	protoc        (unknown)
// source: mesh/v1alpha1/proxy.proto

package v1alpha1

import (
	duration "github.com/golang/protobuf/ptypes/duration"
	wrappers "github.com/golang/protobuf/ptypes/wrappers"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	v1alpha3 "istio.io/api/networking/v1alpha3"
	v1beta1 "istio.io/api/networking/v1beta1"
	reflect "reflect"
	sync "sync"
	unsafe "unsafe"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// AuthenticationPolicy defines how the proxy is authenticated when it connects to the control plane.
// It can be set for two different scopes, mesh-wide or set on a per-pod basis using the ProxyConfig annotation.
// Mesh policy cannot be INHERIT.
type AuthenticationPolicy int32

const (
	// Do not encrypt proxy to control plane traffic.
	AuthenticationPolicy_NONE AuthenticationPolicy = 0
	// Proxy to control plane traffic is wrapped into mutual TLS connections.
	AuthenticationPolicy_MUTUAL_TLS AuthenticationPolicy = 1
	// Use the policy defined by the parent scope. Should not be used for mesh
	// policy.
	AuthenticationPolicy_INHERIT AuthenticationPolicy = 1000
)

// Enum value maps for AuthenticationPolicy.
var (
	AuthenticationPolicy_name = map[int32]string{
		0:    "NONE",
		1:    "MUTUAL_TLS",
		1000: "INHERIT",
	}
	AuthenticationPolicy_value = map[string]int32{
		"NONE":       0,
		"MUTUAL_TLS": 1,
		"INHERIT":    1000,
	}
)

func (x AuthenticationPolicy) Enum() *AuthenticationPolicy {
	p := new(AuthenticationPolicy)
	*p = x
	return p
}

func (x AuthenticationPolicy) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (AuthenticationPolicy) Descriptor() protoreflect.EnumDescriptor {
	return file_mesh_v1alpha1_proxy_proto_enumTypes[0].Descriptor()
}

func (AuthenticationPolicy) Type() protoreflect.EnumType {
	return &file_mesh_v1alpha1_proxy_proto_enumTypes[0]
}

func (x AuthenticationPolicy) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use AuthenticationPolicy.Descriptor instead.
func (AuthenticationPolicy) EnumDescriptor() ([]byte, []int) {
	return file_mesh_v1alpha1_proxy_proto_rawDescGZIP(), []int{0}
}

// ForwardClientCertDetails controls how the x-forwarded-client-cert (XFCC)
// header is handled by a proxy.
// See [Envoy XFCC](https://www.envoyproxy.io/docs/envoy/latest/api-v3/extensions/filters/network/http_connection_manager/v3/http_connection_manager.proto.html#enum-extensions-filters-network-http-connection-manager-v3-httpconnectionmanager-forwardclientcertdetails)
// header handling for more details.
type ForwardClientCertDetails int32

const (
	// Field is not set
	ForwardClientCertDetails_UNDEFINED ForwardClientCertDetails = 0
	// Do not send the XFCC header to the next hop.
	ForwardClientCertDetails_SANITIZE ForwardClientCertDetails = 1
	// When the client connection is mTLS (Mutual TLS), forward the XFCC header
	// in the request.
	ForwardClientCertDetails_FORWARD_ONLY ForwardClientCertDetails = 2
	// When the client connection is mTLS, append the client certificate
	// information to the request’s XFCC header and forward it. This is the default value for sidecar proxies.
	ForwardClientCertDetails_APPEND_FORWARD ForwardClientCertDetails = 3
	// When the client connection is mTLS, reset the XFCC header with the client
	// certificate information and send it to the next hop. This is the default value for gateway proxies.
	ForwardClientCertDetails_SANITIZE_SET ForwardClientCertDetails = 4
	// Always forward the XFCC header in the request, regardless of whether the
	// client connection is mTLS.
	ForwardClientCertDetails_ALWAYS_FORWARD_ONLY ForwardClientCertDetails = 5
)

// Enum value maps for ForwardClientCertDetails.
var (
	ForwardClientCertDetails_name = map[int32]string{
		0: "UNDEFINED",
		1: "SANITIZE",
		2: "FORWARD_ONLY",
		3: "APPEND_FORWARD",
		4: "SANITIZE_SET",
		5: "ALWAYS_FORWARD_ONLY",
	}
	ForwardClientCertDetails_value = map[string]int32{
		"UNDEFINED":           0,
		"SANITIZE":            1,
		"FORWARD_ONLY":        2,
		"APPEND_FORWARD":      3,
		"SANITIZE_SET":        4,
		"ALWAYS_FORWARD_ONLY": 5,
	}
)

func (x ForwardClientCertDetails) Enum() *ForwardClientCertDetails {
	p := new(ForwardClientCertDetails)
	*p = x
	return p
}

func (x ForwardClientCertDetails) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ForwardClientCertDetails) Descriptor() protoreflect.EnumDescriptor {
	return file_mesh_v1alpha1_proxy_proto_enumTypes[1].Descriptor()
}

func (ForwardClientCertDetails) Type() protoreflect.EnumType {
	return &file_mesh_v1alpha1_proxy_proto_enumTypes[1]
}

func (x ForwardClientCertDetails) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ForwardClientCertDetails.Descriptor instead.
func (ForwardClientCertDetails) EnumDescriptor() ([]byte, []int) {
	return file_mesh_v1alpha1_proxy_proto_rawDescGZIP(), []int{1}
}

// TraceContext selects the context propagation headers used for
// distributed tracing.
type Tracing_OpenCensusAgent_TraceContext int32

const (
	// $hide_from_docs
	// Unspecified context. Should not be used for now, but added to reserve
	// the 0 enum value if TraceContext is used outside of a repeated field.
	Tracing_OpenCensusAgent_UNSPECIFIED Tracing_OpenCensusAgent_TraceContext = 0
	// Use W3C Trace Context propagation using the `traceparent` HTTP header.
	// See the
	// [Trace Context documentation](https://www.w3.org/TR/trace-context/) for details.
	Tracing_OpenCensusAgent_W3C_TRACE_CONTEXT Tracing_OpenCensusAgent_TraceContext = 1
	// Use gRPC binary context propagation using the `grpc-trace-bin` http header.
	Tracing_OpenCensusAgent_GRPC_BIN Tracing_OpenCensusAgent_TraceContext = 2
	// Use Cloud Trace context propagation using the
	// `X-Cloud-Trace-Context` http header.
	Tracing_OpenCensusAgent_CLOUD_TRACE_CONTEXT Tracing_OpenCensusAgent_TraceContext = 3
	// Use multi-header B3 context propagation using the `X-B3-TraceId`,
	// `X-B3-SpanId`, and `X-B3-Sampled` HTTP headers. See
	// [B3 header propagation README](https://github.com/openzipkin/b3-propagation)
	// for details.
	Tracing_OpenCensusAgent_B3 Tracing_OpenCensusAgent_TraceContext = 4
)

// Enum value maps for Tracing_OpenCensusAgent_TraceContext.
var (
	Tracing_OpenCensusAgent_TraceContext_name = map[int32]string{
		0: "UNSPECIFIED",
		1: "W3C_TRACE_CONTEXT",
		2: "GRPC_BIN",
		3: "CLOUD_TRACE_CONTEXT",
		4: "B3",
	}
	Tracing_OpenCensusAgent_TraceContext_value = map[string]int32{
		"UNSPECIFIED":         0,
		"W3C_TRACE_CONTEXT":   1,
		"GRPC_BIN":            2,
		"CLOUD_TRACE_CONTEXT": 3,
		"B3":                  4,
	}
)

func (x Tracing_OpenCensusAgent_TraceContext) Enum() *Tracing_OpenCensusAgent_TraceContext {
	p := new(Tracing_OpenCensusAgent_TraceContext)
	*p = x
	return p
}

func (x Tracing_OpenCensusAgent_TraceContext) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Tracing_OpenCensusAgent_TraceContext) Descriptor() protoreflect.EnumDescriptor {
	return file_mesh_v1alpha1_proxy_proto_enumTypes[2].Descriptor()
}

func (Tracing_OpenCensusAgent_TraceContext) Type() protoreflect.EnumType {
	return &file_mesh_v1alpha1_proxy_proto_enumTypes[2]
}

func (x Tracing_OpenCensusAgent_TraceContext) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Tracing_OpenCensusAgent_TraceContext.Descriptor instead.
func (Tracing_OpenCensusAgent_TraceContext) EnumDescriptor() ([]byte, []int) {
	return file_mesh_v1alpha1_proxy_proto_rawDescGZIP(), []int{0, 4, 0}
}

// Allows specification of various Istio-supported naming schemes for the
// Envoy `service_cluster` value. The `service_cluster` value is primarily used
// by Envoys to provide service names for tracing spans.
type ProxyConfig_TracingServiceName int32

const (
	// Default scheme. Uses the `app` label and workload namespace to construct
	// a cluster name. If the `app` label does not exist `istio-proxy` is used.
	ProxyConfig_APP_LABEL_AND_NAMESPACE ProxyConfig_TracingServiceName = 0
	// Uses the canonical name for a workload (*excluding namespace*).
	ProxyConfig_CANONICAL_NAME_ONLY ProxyConfig_TracingServiceName = 1
	// Uses the canonical name and namespace for a workload.
	ProxyConfig_CANONICAL_NAME_AND_NAMESPACE ProxyConfig_TracingServiceName = 2
)

// Enum value maps for ProxyConfig_TracingServiceName.
var (
	ProxyConfig_TracingServiceName_name = map[int32]string{
		0: "APP_LABEL_AND_NAMESPACE",
		1: "CANONICAL_NAME_ONLY",
		2: "CANONICAL_NAME_AND_NAMESPACE",
	}
	ProxyConfig_TracingServiceName_value = map[string]int32{
		"APP_LABEL_AND_NAMESPACE":      0,
		"CANONICAL_NAME_ONLY":          1,
		"CANONICAL_NAME_AND_NAMESPACE": 2,
	}
)

func (x ProxyConfig_TracingServiceName) Enum() *ProxyConfig_TracingServiceName {
	p := new(ProxyConfig_TracingServiceName)
	*p = x
	return p
}

func (x ProxyConfig_TracingServiceName) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ProxyConfig_TracingServiceName) Descriptor() protoreflect.EnumDescriptor {
	return file_mesh_v1alpha1_proxy_proto_enumTypes[3].Descriptor()
}

func (ProxyConfig_TracingServiceName) Type() protoreflect.EnumType {
	return &file_mesh_v1alpha1_proxy_proto_enumTypes[3]
}

func (x ProxyConfig_TracingServiceName) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ProxyConfig_TracingServiceName.Descriptor instead.
func (ProxyConfig_TracingServiceName) EnumDescriptor() ([]byte, []int) {
	return file_mesh_v1alpha1_proxy_proto_rawDescGZIP(), []int{4, 0}
}

// The mode used to redirect inbound traffic to Envoy.
// This setting has no effect on outbound traffic: iptables `REDIRECT` is always used for
// outbound connections.
type ProxyConfig_InboundInterceptionMode int32

const (
	// The `REDIRECT` mode uses iptables `REDIRECT` to `NAT` and redirect to Envoy. This mode loses
	// source IP addresses during redirection. This is the default redirection mode.
	ProxyConfig_REDIRECT ProxyConfig_InboundInterceptionMode = 0
	// The `TPROXY` mode uses iptables `TPROXY` to redirect to Envoy. This mode preserves both the
	// source and destination IP addresses and ports, so that they can be used for advanced
	// filtering and manipulation. This mode also configures the sidecar to run with the
	// `CAP_NET_ADMIN` capability, which is required to use `TPROXY`.
	ProxyConfig_TPROXY ProxyConfig_InboundInterceptionMode = 1
	// The `NONE` mode does not configure redirect to Envoy at all. This is an advanced
	// configuration that typically requires changes to user applications.
	ProxyConfig_NONE ProxyConfig_InboundInterceptionMode = 2
)

// Enum value maps for ProxyConfig_InboundInterceptionMode.
var (
	ProxyConfig_InboundInterceptionMode_name = map[int32]string{
		0: "REDIRECT",
		1: "TPROXY",
		2: "NONE",
	}
	ProxyConfig_InboundInterceptionMode_value = map[string]int32{
		"REDIRECT": 0,
		"TPROXY":   1,
		"NONE":     2,
	}
)

func (x ProxyConfig_InboundInterceptionMode) Enum() *ProxyConfig_InboundInterceptionMode {
	p := new(ProxyConfig_InboundInterceptionMode)
	*p = x
	return p
}

func (x ProxyConfig_InboundInterceptionMode) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ProxyConfig_InboundInterceptionMode) Descriptor() protoreflect.EnumDescriptor {
	return file_mesh_v1alpha1_proxy_proto_enumTypes[4].Descriptor()
}

func (ProxyConfig_InboundInterceptionMode) Type() protoreflect.EnumType {
	return &file_mesh_v1alpha1_proxy_proto_enumTypes[4]
}

func (x ProxyConfig_InboundInterceptionMode) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ProxyConfig_InboundInterceptionMode.Descriptor instead.
func (ProxyConfig_InboundInterceptionMode) EnumDescriptor() ([]byte, []int) {
	return file_mesh_v1alpha1_proxy_proto_rawDescGZIP(), []int{4, 1}
}

type ProxyConfig_ProxyHeaders_MetadataExchangeMode int32

const (
	// Existing Istio behavior for the metadata exchange headers is unchanged.
	ProxyConfig_ProxyHeaders_UNDEFINED ProxyConfig_ProxyHeaders_MetadataExchangeMode = 0
	// Only append the istio metadata exchange headers for services considered in-mesh.
	// Traffic is considered in-mesh if it is secured with Istio mutual TLS. This means that `MESH_EXTERNAL` services, unmatched passthrough traffic, and requests to workloads without Istio enabled will be considered out of mesh.
	ProxyConfig_ProxyHeaders_IN_MESH ProxyConfig_ProxyHeaders_MetadataExchangeMode = 1
)

// Enum value maps for ProxyConfig_ProxyHeaders_MetadataExchangeMode.
var (
	ProxyConfig_ProxyHeaders_MetadataExchangeMode_name = map[int32]string{
		0: "UNDEFINED",
		1: "IN_MESH",
	}
	ProxyConfig_ProxyHeaders_MetadataExchangeMode_value = map[string]int32{
		"UNDEFINED": 0,
		"IN_MESH":   1,
	}
)

func (x ProxyConfig_ProxyHeaders_MetadataExchangeMode) Enum() *ProxyConfig_ProxyHeaders_MetadataExchangeMode {
	p := new(ProxyConfig_ProxyHeaders_MetadataExchangeMode)
	*p = x
	return p
}

func (x ProxyConfig_ProxyHeaders_MetadataExchangeMode) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ProxyConfig_ProxyHeaders_MetadataExchangeMode) Descriptor() protoreflect.EnumDescriptor {
	return file_mesh_v1alpha1_proxy_proto_enumTypes[5].Descriptor()
}

func (ProxyConfig_ProxyHeaders_MetadataExchangeMode) Type() protoreflect.EnumType {
	return &file_mesh_v1alpha1_proxy_proto_enumTypes[5]
}

func (x ProxyConfig_ProxyHeaders_MetadataExchangeMode) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ProxyConfig_ProxyHeaders_MetadataExchangeMode.Descriptor instead.
func (ProxyConfig_ProxyHeaders_MetadataExchangeMode) EnumDescriptor() ([]byte, []int) {
	return file_mesh_v1alpha1_proxy_proto_rawDescGZIP(), []int{4, 3, 0}
}

// Tracing defines configuration for the tracing performed by Envoy instances.
type Tracing struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// The tracer implementation to be used by Envoy.
	//
	// Types that are valid to be assigned to Tracer:
	//
	//	*Tracing_Zipkin_
	//	*Tracing_Lightstep_
	//	*Tracing_Datadog_
	//	*Tracing_Stackdriver_
	//	*Tracing_OpenCensusAgent_
	Tracer isTracing_Tracer `protobuf_oneof:"tracer"`
	// Configures the custom tags to be added to active span by all proxies (i.e. sidecars
	// and gateways).
	// The key represents the name of the tag.
	// Ex:
	// ```yaml
	// custom_tags:
	//
	//	new_tag_name:
	//	  header:
	//	    name: custom-http-header-name
	//	    default_value: defaulted-value-from-custom-header
	//
	// ```
	// $hide_from_docs
	CustomTags map[string]*Tracing_CustomTag `protobuf:"bytes,5,rep,name=custom_tags,json=customTags,proto3" json:"custom_tags,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	// Configures the maximum length of the request path to extract and include in the
	// HttpUrl tag. Used to truncate length request paths to meet the needs of tracing
	// backend. If not set, then a length of 256 will be used.
	// $hide_from_docs
	MaxPathTagLength uint32 `protobuf:"varint,6,opt,name=max_path_tag_length,json=maxPathTagLength,proto3" json:"max_path_tag_length,omitempty"`
	// The percentage of requests (0.0 - 100.0) that will be randomly selected for trace generation,
	// if not requested by the client or not forced. Default is 1.0.
	Sampling float64 `protobuf:"fixed64,7,opt,name=sampling,proto3" json:"sampling,omitempty"`
	// Use the tlsSettings to specify the tls mode to use. If the remote tracing service
	// uses Istio mutual TLS and shares the root CA with istiod, specify the TLS
	// mode as `ISTIO_MUTUAL`.
	TlsSettings *v1alpha3.ClientTLSSettings `protobuf:"bytes,8,opt,name=tls_settings,json=tlsSettings,proto3" json:"tls_settings,omitempty"`
	// Determines whether or not trace spans generated by Envoy will include Istio specific tags.
	// By default Istio specific tags are included in the trace spans.
	EnableIstioTags *wrappers.BoolValue `protobuf:"bytes,10,opt,name=enable_istio_tags,json=enableIstioTags,proto3" json:"enable_istio_tags,omitempty"`
	unknownFields   protoimpl.UnknownFields
	sizeCache       protoimpl.SizeCache
}

func (x *Tracing) Reset() {
	*x = Tracing{}
	mi := &file_mesh_v1alpha1_proxy_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Tracing) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Tracing) ProtoMessage() {}

func (x *Tracing) ProtoReflect() protoreflect.Message {
	mi := &file_mesh_v1alpha1_proxy_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Tracing.ProtoReflect.Descriptor instead.
func (*Tracing) Descriptor() ([]byte, []int) {
	return file_mesh_v1alpha1_proxy_proto_rawDescGZIP(), []int{0}
}

func (x *Tracing) GetTracer() isTracing_Tracer {
	if x != nil {
		return x.Tracer
	}
	return nil
}

func (x *Tracing) GetZipkin() *Tracing_Zipkin {
	if x != nil {
		if x, ok := x.Tracer.(*Tracing_Zipkin_); ok {
			return x.Zipkin
		}
	}
	return nil
}

func (x *Tracing) GetLightstep() *Tracing_Lightstep {
	if x != nil {
		if x, ok := x.Tracer.(*Tracing_Lightstep_); ok {
			return x.Lightstep
		}
	}
	return nil
}

func (x *Tracing) GetDatadog() *Tracing_Datadog {
	if x != nil {
		if x, ok := x.Tracer.(*Tracing_Datadog_); ok {
			return x.Datadog
		}
	}
	return nil
}

func (x *Tracing) GetStackdriver() *Tracing_Stackdriver {
	if x != nil {
		if x, ok := x.Tracer.(*Tracing_Stackdriver_); ok {
			return x.Stackdriver
		}
	}
	return nil
}

func (x *Tracing) GetOpenCensusAgent() *Tracing_OpenCensusAgent {
	if x != nil {
		if x, ok := x.Tracer.(*Tracing_OpenCensusAgent_); ok {
			return x.OpenCensusAgent
		}
	}
	return nil
}

func (x *Tracing) GetCustomTags() map[string]*Tracing_CustomTag {
	if x != nil {
		return x.CustomTags
	}
	return nil
}

func (x *Tracing) GetMaxPathTagLength() uint32 {
	if x != nil {
		return x.MaxPathTagLength
	}
	return 0
}

func (x *Tracing) GetSampling() float64 {
	if x != nil {
		return x.Sampling
	}
	return 0
}

func (x *Tracing) GetTlsSettings() *v1alpha3.ClientTLSSettings {
	if x != nil {
		return x.TlsSettings
	}
	return nil
}

func (x *Tracing) GetEnableIstioTags() *wrappers.BoolValue {
	if x != nil {
		return x.EnableIstioTags
	}
	return nil
}

type isTracing_Tracer interface {
	isTracing_Tracer()
}

type Tracing_Zipkin_ struct {
	// Use a Zipkin tracer.
	Zipkin *Tracing_Zipkin `protobuf:"bytes,1,opt,name=zipkin,proto3,oneof"`
}

type Tracing_Lightstep_ struct {
	// Use a Lightstep tracer.
	// NOTE: For Istio 1.15+, this configuration option will result
	// in using OpenTelemetry-based Lightstep integration.
	// $hide_from_docs
	Lightstep *Tracing_Lightstep `protobuf:"bytes,2,opt,name=lightstep,proto3,oneof"`
}

type Tracing_Datadog_ struct {
	// Use a Datadog tracer.
	Datadog *Tracing_Datadog `protobuf:"bytes,3,opt,name=datadog,proto3,oneof"`
}

type Tracing_Stackdriver_ struct {
	// Use a Stackdriver tracer.
	// $hide_from_docs
	Stackdriver *Tracing_Stackdriver `protobuf:"bytes,4,opt,name=stackdriver,proto3,oneof"`
}

type Tracing_OpenCensusAgent_ struct {
	// Use an OpenCensus tracer exporting to an OpenCensus agent.
	// $hide_from_docs
	OpenCensusAgent *Tracing_OpenCensusAgent `protobuf:"bytes,9,opt,name=open_census_agent,json=openCensusAgent,proto3,oneof"`
}

func (*Tracing_Zipkin_) isTracing_Tracer() {}

func (*Tracing_Lightstep_) isTracing_Tracer() {}

func (*Tracing_Datadog_) isTracing_Tracer() {}

func (*Tracing_Stackdriver_) isTracing_Tracer() {}

func (*Tracing_OpenCensusAgent_) isTracing_Tracer() {}

// SDS defines secret discovery service(SDS) configuration to be used by the proxy.
// For workload, its values are set in sidecar injector(passed as arguments to istio-proxy container).
// For pilot/mixer, it's passed as arguments to istio-proxy container in pilot/mixer deployment yaml files directly.
// $hide_from_docs
type SDS struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// True if SDS is enabled.
	Enabled bool `protobuf:"varint,1,opt,name=enabled,proto3" json:"enabled,omitempty"`
	// Path of k8s service account JWT path.
	K8SSaJwtPath  string `protobuf:"bytes,2,opt,name=k8s_sa_jwt_path,json=k8sSaJwtPath,proto3" json:"k8s_sa_jwt_path,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *SDS) Reset() {
	*x = SDS{}
	mi := &file_mesh_v1alpha1_proxy_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SDS) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SDS) ProtoMessage() {}

func (x *SDS) ProtoReflect() protoreflect.Message {
	mi := &file_mesh_v1alpha1_proxy_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SDS.ProtoReflect.Descriptor instead.
func (*SDS) Descriptor() ([]byte, []int) {
	return file_mesh_v1alpha1_proxy_proto_rawDescGZIP(), []int{1}
}

func (x *SDS) GetEnabled() bool {
	if x != nil {
		return x.Enabled
	}
	return false
}

func (x *SDS) GetK8SSaJwtPath() string {
	if x != nil {
		return x.K8SSaJwtPath
	}
	return ""
}

// Topology describes the configuration for relative location of a proxy with
// respect to intermediate trusted proxies and the client. These settings
// control how the client attributes are retrieved from the incoming traffic by
// the gateway proxy and propagated to the upstream services in the cluster.
type Topology struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Number of trusted proxies deployed in front of the Istio gateway proxy.
	// When this option is set to value N greater than zero, the trusted client
	// address is assumed to be the Nth address from the right end of the
	// X-Forwarded-For (XFF) header from the incoming request. If the
	// X-Forwarded-For (XFF) header is missing or has fewer than N addresses, the
	// gateway proxy falls back to using the immediate downstream connection's
	// source address as the trusted client address.
	// Note that the gateway proxy will append the downstream connection's source
	// address to the X-Forwarded-For (XFF) address and set the
	// X-Envoy-External-Address header to the trusted client address before
	// forwarding it to the upstream services in the cluster.
	// The default value of numTrustedProxies is 0.
	// See [Envoy XFF](https://www.envoyproxy.io/docs/envoy/latest/configuration/http/http_conn_man/headers#config-http-conn-man-headers-x-forwarded-for)
	// header handling for more details.
	NumTrustedProxies uint32 `protobuf:"varint,1,opt,name=num_trusted_proxies,json=numTrustedProxies,proto3" json:"num_trusted_proxies,omitempty"`
	// Configures how the gateway proxy handles x-forwarded-client-cert (XFCC)
	// header in the incoming request.
	ForwardClientCertDetails ForwardClientCertDetails `protobuf:"varint,2,opt,name=forward_client_cert_details,json=forwardClientCertDetails,proto3,enum=istio.mesh.v1alpha1.ForwardClientCertDetails" json:"forward_client_cert_details,omitempty"`
	// Enables [PROXY protocol](http://www.haproxy.org/download/1.5/doc/proxy-protocol.txt) for
	// downstream connections on a gateway.
	ProxyProtocol *Topology_ProxyProtocolConfiguration `protobuf:"bytes,3,opt,name=proxy_protocol,json=proxyProtocol,proto3" json:"proxy_protocol,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *Topology) Reset() {
	*x = Topology{}
	mi := &file_mesh_v1alpha1_proxy_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Topology) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Topology) ProtoMessage() {}

func (x *Topology) ProtoReflect() protoreflect.Message {
	mi := &file_mesh_v1alpha1_proxy_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Topology.ProtoReflect.Descriptor instead.
func (*Topology) Descriptor() ([]byte, []int) {
	return file_mesh_v1alpha1_proxy_proto_rawDescGZIP(), []int{2}
}

func (x *Topology) GetNumTrustedProxies() uint32 {
	if x != nil {
		return x.NumTrustedProxies
	}
	return 0
}

func (x *Topology) GetForwardClientCertDetails() ForwardClientCertDetails {
	if x != nil {
		return x.ForwardClientCertDetails
	}
	return ForwardClientCertDetails_UNDEFINED
}

func (x *Topology) GetProxyProtocol() *Topology_ProxyProtocolConfiguration {
	if x != nil {
		return x.ProxyProtocol
	}
	return nil
}

// PrivateKeyProvider defines private key configuration for gateways and sidecars. This can be configured
// mesh-wide or individual per-workload basis.
type PrivateKeyProvider struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// REQUIRED. Specifies detailed configuration for the Private key provider.
	//
	// Types that are valid to be assigned to Provider:
	//
	//	*PrivateKeyProvider_Cryptomb
	//	*PrivateKeyProvider_Qat
	Provider      isPrivateKeyProvider_Provider `protobuf_oneof:"provider"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *PrivateKeyProvider) Reset() {
	*x = PrivateKeyProvider{}
	mi := &file_mesh_v1alpha1_proxy_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PrivateKeyProvider) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PrivateKeyProvider) ProtoMessage() {}

func (x *PrivateKeyProvider) ProtoReflect() protoreflect.Message {
	mi := &file_mesh_v1alpha1_proxy_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PrivateKeyProvider.ProtoReflect.Descriptor instead.
func (*PrivateKeyProvider) Descriptor() ([]byte, []int) {
	return file_mesh_v1alpha1_proxy_proto_rawDescGZIP(), []int{3}
}

func (x *PrivateKeyProvider) GetProvider() isPrivateKeyProvider_Provider {
	if x != nil {
		return x.Provider
	}
	return nil
}

func (x *PrivateKeyProvider) GetCryptomb() *PrivateKeyProvider_CryptoMb {
	if x != nil {
		if x, ok := x.Provider.(*PrivateKeyProvider_Cryptomb); ok {
			return x.Cryptomb
		}
	}
	return nil
}

func (x *PrivateKeyProvider) GetQat() *PrivateKeyProvider_QAT {
	if x != nil {
		if x, ok := x.Provider.(*PrivateKeyProvider_Qat); ok {
			return x.Qat
		}
	}
	return nil
}

type isPrivateKeyProvider_Provider interface {
	isPrivateKeyProvider_Provider()
}

type PrivateKeyProvider_Cryptomb struct {
	// Use CryptoMb private key provider
	Cryptomb *PrivateKeyProvider_CryptoMb `protobuf:"bytes,2,opt,name=cryptomb,proto3,oneof"`
}

type PrivateKeyProvider_Qat struct {
	// Use QAT private key provider
	Qat *PrivateKeyProvider_QAT `protobuf:"bytes,3,opt,name=qat,proto3,oneof"`
}

func (*PrivateKeyProvider_Cryptomb) isPrivateKeyProvider_Provider() {}

func (*PrivateKeyProvider_Qat) isPrivateKeyProvider_Provider() {}

// ProxyConfig defines variables for individual Envoy instances. This can be configured on a per-workload basis
// as well as by the mesh-wide defaults.
// To set the mesh-wide defaults, configure the `defaultConfig` section of `meshConfig`. For example:
//
// ```
// meshConfig:
//
//	defaultConfig:
//	  discoveryAddress: istiod:15012
//
// ```
//
// This can also be configured on a per-workload basis by configuring the `proxy.istio.io/config` annotation on the pod. For example:
//
// ```
// annotations:
//
//	proxy.istio.io/config: |
//	  discoveryAddress: istiod:15012
//
// ```
//
// If both are configured, the two are merged with per field semantics; the field set in annotation will fully replace the field from mesh config defaults.
// This is different than a deep merge provided by protobuf.
// For example, `"tracing": { "sampling": 5 }` would completely override a setting configuring a tracing provider
// such as `"tracing": { "zipkin": { "address": "..." } }`.
//
// Note: fields in ProxyConfig are not dynamically configured; changes will require restart of workloads to take effect.
type ProxyConfig struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Path to the generated configuration file directory.
	// Proxy agent generates the actual configuration and stores it in this directory.
	ConfigPath string `protobuf:"bytes,1,opt,name=config_path,json=configPath,proto3" json:"config_path,omitempty"`
	// Path to the proxy binary
	BinaryPath string `protobuf:"bytes,2,opt,name=binary_path,json=binaryPath,proto3" json:"binary_path,omitempty"`
	// Types that are valid to be assigned to ClusterName:
	//
	//	*ProxyConfig_ServiceCluster
	//	*ProxyConfig_TracingServiceName_
	ClusterName isProxyConfig_ClusterName `protobuf_oneof:"cluster_name"`
	// The time in seconds that Envoy will drain connections during a hot
	// restart. MUST be >=1s (e.g., _1s/1m/1h_)
	// Default drain duration is `45s`.
	DrainDuration *duration.Duration `protobuf:"bytes,4,opt,name=drain_duration,json=drainDuration,proto3" json:"drain_duration,omitempty"`
	// Address of the discovery service exposing xDS with mTLS connection.
	// The inject configuration may override this value.
	DiscoveryAddress string `protobuf:"bytes,6,opt,name=discovery_address,json=discoveryAddress,proto3" json:"discovery_address,omitempty"`
	// $hide_from_docs
	//
	// Deprecated: Marked as deprecated in mesh/v1alpha1/proxy.proto.
	DiscoveryRefreshDelay *duration.Duration `protobuf:"bytes,7,opt,name=discovery_refresh_delay,json=discoveryRefreshDelay,proto3" json:"discovery_refresh_delay,omitempty"`
	// Address of the Zipkin service (e.g. _zipkin:9411_).
	// DEPRECATED: Use [tracing][istio.mesh.v1alpha1.ProxyConfig.tracing] instead.
	//
	// Deprecated: Marked as deprecated in mesh/v1alpha1/proxy.proto.
	ZipkinAddress string `protobuf:"bytes,8,opt,name=zipkin_address,json=zipkinAddress,proto3" json:"zipkin_address,omitempty"`
	// IP Address and Port of a statsd UDP listener (e.g. `10.75.241.127:9125`).
	StatsdUdpAddress string `protobuf:"bytes,10,opt,name=statsd_udp_address,json=statsdUdpAddress,proto3" json:"statsd_udp_address,omitempty"`
	// $hide_from_docs
	//
	// Deprecated: Marked as deprecated in mesh/v1alpha1/proxy.proto.
	EnvoyMetricsServiceAddress string `protobuf:"bytes,20,opt,name=envoy_metrics_service_address,json=envoyMetricsServiceAddress,proto3" json:"envoy_metrics_service_address,omitempty"`
	// Port on which Envoy should listen for administrative commands.
	// Default port is `15000`.
	ProxyAdminPort int32 `protobuf:"varint,11,opt,name=proxy_admin_port,json=proxyAdminPort,proto3" json:"proxy_admin_port,omitempty"`
	// $hide_from_docs
	//
	// Deprecated: Marked as deprecated in mesh/v1alpha1/proxy.proto.
	AvailabilityZone string `protobuf:"bytes,12,opt,name=availability_zone,json=availabilityZone,proto3" json:"availability_zone,omitempty"`
	// AuthenticationPolicy defines how the proxy is authenticated when it connects to the control plane.
	// Default is set to `MUTUAL_TLS`.
	ControlPlaneAuthPolicy AuthenticationPolicy `protobuf:"varint,13,opt,name=control_plane_auth_policy,json=controlPlaneAuthPolicy,proto3,enum=istio.mesh.v1alpha1.AuthenticationPolicy" json:"control_plane_auth_policy,omitempty"`
	// File path of custom proxy configuration, currently used by proxies
	// in front of istiod.
	CustomConfigFile string `protobuf:"bytes,14,opt,name=custom_config_file,json=customConfigFile,proto3" json:"custom_config_file,omitempty"`
	// Maximum length of name field in Envoy's metrics. The length of the name field
	// is determined by the length of a name field in a service and the set of labels that
	// comprise a particular version of the service. The default value is set to 189 characters.
	// Envoy's internal metrics take up 67 characters, for a total of 256 character name per metric.
	// Increase the value of this field if you find that the metrics from Envoys are truncated.
	StatNameLength int32 `protobuf:"varint,15,opt,name=stat_name_length,json=statNameLength,proto3" json:"stat_name_length,omitempty"`
	// The number of worker threads to run.
	// If unset, which is recommended, this will be automatically determined based on CPU requests/limits.
	// If set to 0, all cores on the machine will be used, ignoring CPU requests or limits. This can lead to major performance
	// issues if CPU limits are also set.
	Concurrency *wrappers.Int32Value `protobuf:"bytes,16,opt,name=concurrency,proto3" json:"concurrency,omitempty"`
	// Path to the proxy bootstrap template file
	ProxyBootstrapTemplatePath string `protobuf:"bytes,17,opt,name=proxy_bootstrap_template_path,json=proxyBootstrapTemplatePath,proto3" json:"proxy_bootstrap_template_path,omitempty"`
	// The mode used to redirect inbound traffic to Envoy.
	InterceptionMode ProxyConfig_InboundInterceptionMode `protobuf:"varint,18,opt,name=interception_mode,json=interceptionMode,proto3,enum=istio.mesh.v1alpha1.ProxyConfig_InboundInterceptionMode" json:"interception_mode,omitempty"`
	// Tracing configuration to be used by the proxy.
	Tracing *Tracing `protobuf:"bytes,19,opt,name=tracing,proto3" json:"tracing,omitempty"`
	// Secret Discovery Service(SDS) configuration to be used by the proxy.
	// $hide_from_docs
	//
	// Deprecated: Marked as deprecated in mesh/v1alpha1/proxy.proto.
	Sds *SDS `protobuf:"bytes,21,opt,name=sds,proto3" json:"sds,omitempty"`
	// Address of the service to which access logs from Envoys should be
	// sent. (e.g. `accesslog-service:15000`). See [Access Log
	// Service](https://www.envoyproxy.io/docs/envoy/latest/api-v2/config/accesslog/v2/als.proto)
	// for details about Envoy's gRPC Access Log Service API.
	EnvoyAccessLogService *RemoteService `protobuf:"bytes,22,opt,name=envoy_access_log_service,json=envoyAccessLogService,proto3" json:"envoy_access_log_service,omitempty"`
	// Address of the Envoy Metrics Service implementation (e.g. `metrics-service:15000`).
	// See [Metric Service](https://www.envoyproxy.io/docs/envoy/latest/api-v2/config/metrics/v2/metrics_service.proto)
	// for details about Envoy's Metrics Service API.
	EnvoyMetricsService *RemoteService `protobuf:"bytes,23,opt,name=envoy_metrics_service,json=envoyMetricsService,proto3" json:"envoy_metrics_service,omitempty"`
	// Additional environment variables for the proxy.
	// Names starting with `ISTIO_META_` will be included in the generated bootstrap and sent to the XDS server.
	ProxyMetadata map[string]string `protobuf:"bytes,24,rep,name=proxy_metadata,json=proxyMetadata,proto3" json:"proxy_metadata,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	// Envoy [runtime configuration](https://www.envoyproxy.io/docs/envoy/latest/intro/arch_overview/operations/runtime) to set during bootstrapping.
	// This enables setting experimental, unsafe, unsupported, and deprecated features that should be used with extreme caution.
	RuntimeValues map[string]string `protobuf:"bytes,37,rep,name=runtime_values,json=runtimeValues,proto3" json:"runtime_values,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	// Port on which the agent should listen for administrative commands such as readiness probe.
	// Default is set to port `15020`.
	StatusPort int32 `protobuf:"varint,26,opt,name=status_port,json=statusPort,proto3" json:"status_port,omitempty"`
	// An additional list of tags to extract from the in-proxy Istio telemetry. These extra tags can be
	// added by configuring the telemetry extension. Each additional tag needs to be present in this list.
	// Extra tags emitted by the telemetry extensions must be listed here so that they can be processed
	// and exposed as Prometheus metrics.
	// Deprecated: `istio.stats` is a native filter now, this field is no longer needed.
	ExtraStatTags []string `protobuf:"bytes,27,rep,name=extra_stat_tags,json=extraStatTags,proto3" json:"extra_stat_tags,omitempty"`
	// Topology encapsulates the configuration which describes where the proxy is
	// located i.e. behind a (or N) trusted proxy (proxies) or directly exposed
	// to the internet. This configuration only effects gateways and is applied
	// to all the gateways in the cluster unless overridden via annotations of the
	// gateway workloads.
	GatewayTopology *Topology `protobuf:"bytes,28,opt,name=gateway_topology,json=gatewayTopology,proto3" json:"gateway_topology,omitempty"`
	// The amount of time allowed for connections to complete on proxy shutdown.
	// On receiving `SIGTERM` or `SIGINT`, `istio-agent` tells the active Envoy to start gracefully draining,
	// discouraging any new connections and allowing existing connections to complete. It then
	// sleeps for the `terminationDrainDuration` and then kills any remaining active Envoy processes.
	// If not set, a default of `5s` will be applied.
	TerminationDrainDuration *duration.Duration `protobuf:"bytes,29,opt,name=termination_drain_duration,json=terminationDrainDuration,proto3" json:"termination_drain_duration,omitempty"`
	// The unique identifier for the [service mesh](https://istio.io/docs/reference/glossary/#service-mesh)
	// All control planes running in the same service mesh should specify the same mesh ID.
	// Mesh ID is used to label telemetry reports for cases where telemetry from multiple meshes is mixed together.
	MeshId string `protobuf:"bytes,30,opt,name=mesh_id,json=meshId,proto3" json:"mesh_id,omitempty"`
	// VM Health Checking readiness probe. This health check config exactly mirrors the
	// kubernetes readiness probe configuration both in schema and logic.
	// Only one health check method of 3 can be set at a time.
	ReadinessProbe *v1alpha3.ReadinessProbe `protobuf:"bytes,31,opt,name=readiness_probe,json=readinessProbe,proto3" json:"readiness_probe,omitempty"`
	// Proxy stats matcher defines configuration for reporting custom Envoy stats.
	// To reduce memory and CPU overhead from Envoy stats system, Istio proxies by
	// default create and expose only a subset of Envoy stats. This option is to
	// control creation of additional Envoy stats with prefix, suffix, and regex
	// expressions match on the name of the stats. This replaces the stats
	// inclusion annotations
	// (`sidecar.istio.io/statsInclusionPrefixes`,
	// `sidecar.istio.io/statsInclusionRegexps`, and
	// `sidecar.istio.io/statsInclusionSuffixes`). For example, to enable stats
	// for circuit breakers, request retries, upstream connections, and request timeouts,
	// you can specify stats matcher as follows:
	// ```yaml
	// proxyStatsMatcher:
	//
	//	inclusionRegexps:
	//	  - .*outlier_detection.*
	//	  - .*upstream_rq_retry.*
	//	  - .*upstream_cx_.*
	//	inclusionSuffixes:
	//	  - upstream_rq_timeout
	//
	// ```
	// Note including more Envoy stats might increase number of time series
	// collected by prometheus significantly. Care needs to be taken on Prometheus
	// resource provision and configuration to reduce cardinality.
	ProxyStatsMatcher *ProxyConfig_ProxyStatsMatcher `protobuf:"bytes,32,opt,name=proxy_stats_matcher,json=proxyStatsMatcher,proto3" json:"proxy_stats_matcher,omitempty"`
	// Boolean flag for enabling/disabling the holdApplicationUntilProxyStarts behavior.
	// This feature adds hooks to delay application startup until the pod proxy
	// is ready to accept traffic, mitigating some startup race conditions.
	// Default value is 'false'.
	HoldApplicationUntilProxyStarts *wrappers.BoolValue `protobuf:"bytes,33,opt,name=hold_application_until_proxy_starts,json=holdApplicationUntilProxyStarts,proto3" json:"hold_application_until_proxy_starts,omitempty"`
	// The PEM data of the extra root certificates for workload-to-workload communication.
	// This includes the certificates defined in MeshConfig and any other certificates that Istiod uses as CA.
	// The plugin certificates (the 'cacerts' secret), self-signed certificates (the 'istio-ca-secret' secret)
	// are added automatically by Istiod.
	CaCertificatesPem []string `protobuf:"bytes,34,rep,name=ca_certificates_pem,json=caCertificatesPem,proto3" json:"ca_certificates_pem,omitempty"`
	// Specifies the details of the proxy image.
	Image *v1beta1.ProxyImage `protobuf:"bytes,35,opt,name=image,proto3" json:"image,omitempty"`
	// Specifies the details of the Private Key Provider configuration for gateway and sidecar proxies.
	PrivateKeyProvider *PrivateKeyProvider `protobuf:"bytes,38,opt,name=private_key_provider,json=privateKeyProvider,proto3" json:"private_key_provider,omitempty"`
	// Define the set of headers to add/modify for HTTP request/responses.
	//
	// To enable an optional header, simply set the field. If no specific configuration is required, an empty object (`{}`) will enable it.
	// Note: currently all headers are enabled by default.
	//
	// Below shows an example of customizing the `server` header and disabling the `X-Envoy-Attempt-Count` header:
	//
	// ```yaml
	// proxyHeaders:
	//
	//	server:
	//	  value: "my-custom-server"
	//	# Explicitly enable Request IDs.
	//	# As this is the default, this has no effect.
	//	requestId: {}
	//	attemptCount:
	//	  disabled: true
	//
	// ```
	//
	// # Below shows an example of preserving the header case for HTTP 1.x requests
	//
	// ```yaml
	// proxyHeaders:
	//
	//	preserveHttp1HeaderCase: true
	//
	// ```
	//
	// Some headers are enabled by default, and require explicitly disabling. See below for an example of disabling all default-enabled headers:
	//
	// ```yaml
	// proxyHeaders:
	//
	//	forwardedClientCert: SANITIZE
	//	server:
	//	  disabled: true
	//	requestId:
	//	  disabled: true
	//	attemptCount:
	//	  disabled: true
	//	envoyDebugHeaders:
	//	  disabled: true
	//	metadataExchangeHeaders:
	//	  mode: IN_MESH
	//
	// ```
	ProxyHeaders *ProxyConfig_ProxyHeaders `protobuf:"bytes,39,opt,name=proxy_headers,json=proxyHeaders,proto3" json:"proxy_headers,omitempty"`
	// File flush interval for envoy flushes buffers to disk in milliseconds.
	// The duration needs to be set to a value greater than or equal to 1 millisecond.
	// Default is 1000ms.
	// Optional.
	FileFlushInterval *duration.Duration `protobuf:"bytes,40,opt,name=file_flush_interval,json=fileFlushInterval,proto3" json:"file_flush_interval,omitempty"`
	// File flush buffer size for envoy flushes buffers to disk in kilobytes.
	// Defaults to 64.
	// Optional.
	FileFlushMinSizeKb uint32 `protobuf:"varint,41,opt,name=file_flush_min_size_kb,json=fileFlushMinSizeKb,proto3" json:"file_flush_min_size_kb,omitempty"`
	// Offer HTTP compression for stats
	// Defaults to true.
	// Optional.
	StatsCompression *wrappers.BoolValue `protobuf:"bytes,42,opt,name=stats_compression,json=statsCompression,proto3" json:"stats_compression,omitempty"`
	unknownFields    protoimpl.UnknownFields
	sizeCache        protoimpl.SizeCache
}

func (x *ProxyConfig) Reset() {
	*x = ProxyConfig{}
	mi := &file_mesh_v1alpha1_proxy_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ProxyConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ProxyConfig) ProtoMessage() {}

func (x *ProxyConfig) ProtoReflect() protoreflect.Message {
	mi := &file_mesh_v1alpha1_proxy_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ProxyConfig.ProtoReflect.Descriptor instead.
func (*ProxyConfig) Descriptor() ([]byte, []int) {
	return file_mesh_v1alpha1_proxy_proto_rawDescGZIP(), []int{4}
}

func (x *ProxyConfig) GetConfigPath() string {
	if x != nil {
		return x.ConfigPath
	}
	return ""
}

func (x *ProxyConfig) GetBinaryPath() string {
	if x != nil {
		return x.BinaryPath
	}
	return ""
}

func (x *ProxyConfig) GetClusterName() isProxyConfig_ClusterName {
	if x != nil {
		return x.ClusterName
	}
	return nil
}

func (x *ProxyConfig) GetServiceCluster() string {
	if x != nil {
		if x, ok := x.ClusterName.(*ProxyConfig_ServiceCluster); ok {
			return x.ServiceCluster
		}
	}
	return ""
}

func (x *ProxyConfig) GetTracingServiceName() ProxyConfig_TracingServiceName {
	if x != nil {
		if x, ok := x.ClusterName.(*ProxyConfig_TracingServiceName_); ok {
			return x.TracingServiceName
		}
	}
	return ProxyConfig_APP_LABEL_AND_NAMESPACE
}

func (x *ProxyConfig) GetDrainDuration() *duration.Duration {
	if x != nil {
		return x.DrainDuration
	}
	return nil
}

func (x *ProxyConfig) GetDiscoveryAddress() string {
	if x != nil {
		return x.DiscoveryAddress
	}
	return ""
}

// Deprecated: Marked as deprecated in mesh/v1alpha1/proxy.proto.
func (x *ProxyConfig) GetDiscoveryRefreshDelay() *duration.Duration {
	if x != nil {
		return x.DiscoveryRefreshDelay
	}
	return nil
}

// Deprecated: Marked as deprecated in mesh/v1alpha1/proxy.proto.
func (x *ProxyConfig) GetZipkinAddress() string {
	if x != nil {
		return x.ZipkinAddress
	}
	return ""
}

func (x *ProxyConfig) GetStatsdUdpAddress() string {
	if x != nil {
		return x.StatsdUdpAddress
	}
	return ""
}

// Deprecated: Marked as deprecated in mesh/v1alpha1/proxy.proto.
func (x *ProxyConfig) GetEnvoyMetricsServiceAddress() string {
	if x != nil {
		return x.EnvoyMetricsServiceAddress
	}
	return ""
}

func (x *ProxyConfig) GetProxyAdminPort() int32 {
	if x != nil {
		return x.ProxyAdminPort
	}
	return 0
}

// Deprecated: Marked as deprecated in mesh/v1alpha1/proxy.proto.
func (x *ProxyConfig) GetAvailabilityZone() string {
	if x != nil {
		return x.AvailabilityZone
	}
	return ""
}

func (x *ProxyConfig) GetControlPlaneAuthPolicy() AuthenticationPolicy {
	if x != nil {
		return x.ControlPlaneAuthPolicy
	}
	return AuthenticationPolicy_NONE
}

func (x *ProxyConfig) GetCustomConfigFile() string {
	if x != nil {
		return x.CustomConfigFile
	}
	return ""
}

func (x *ProxyConfig) GetStatNameLength() int32 {
	if x != nil {
		return x.StatNameLength
	}
	return 0
}

func (x *ProxyConfig) GetConcurrency() *wrappers.Int32Value {
	if x != nil {
		return x.Concurrency
	}
	return nil
}

func (x *ProxyConfig) GetProxyBootstrapTemplatePath() string {
	if x != nil {
		return x.ProxyBootstrapTemplatePath
	}
	return ""
}

func (x *ProxyConfig) GetInterceptionMode() ProxyConfig_InboundInterceptionMode {
	if x != nil {
		return x.InterceptionMode
	}
	return ProxyConfig_REDIRECT
}

func (x *ProxyConfig) GetTracing() *Tracing {
	if x != nil {
		return x.Tracing
	}
	return nil
}

// Deprecated: Marked as deprecated in mesh/v1alpha1/proxy.proto.
func (x *ProxyConfig) GetSds() *SDS {
	if x != nil {
		return x.Sds
	}
	return nil
}

func (x *ProxyConfig) GetEnvoyAccessLogService() *RemoteService {
	if x != nil {
		return x.EnvoyAccessLogService
	}
	return nil
}

func (x *ProxyConfig) GetEnvoyMetricsService() *RemoteService {
	if x != nil {
		return x.EnvoyMetricsService
	}
	return nil
}

func (x *ProxyConfig) GetProxyMetadata() map[string]string {
	if x != nil {
		return x.ProxyMetadata
	}
	return nil
}

func (x *ProxyConfig) GetRuntimeValues() map[string]string {
	if x != nil {
		return x.RuntimeValues
	}
	return nil
}

func (x *ProxyConfig) GetStatusPort() int32 {
	if x != nil {
		return x.StatusPort
	}
	return 0
}

func (x *ProxyConfig) GetExtraStatTags() []string {
	if x != nil {
		return x.ExtraStatTags
	}
	return nil
}

func (x *ProxyConfig) GetGatewayTopology() *Topology {
	if x != nil {
		return x.GatewayTopology
	}
	return nil
}

func (x *ProxyConfig) GetTerminationDrainDuration() *duration.Duration {
	if x != nil {
		return x.TerminationDrainDuration
	}
	return nil
}

func (x *ProxyConfig) GetMeshId() string {
	if x != nil {
		return x.MeshId
	}
	return ""
}

func (x *ProxyConfig) GetReadinessProbe() *v1alpha3.ReadinessProbe {
	if x != nil {
		return x.ReadinessProbe
	}
	return nil
}

func (x *ProxyConfig) GetProxyStatsMatcher() *ProxyConfig_ProxyStatsMatcher {
	if x != nil {
		return x.ProxyStatsMatcher
	}
	return nil
}

func (x *ProxyConfig) GetHoldApplicationUntilProxyStarts() *wrappers.BoolValue {
	if x != nil {
		return x.HoldApplicationUntilProxyStarts
	}
	return nil
}

func (x *ProxyConfig) GetCaCertificatesPem() []string {
	if x != nil {
		return x.CaCertificatesPem
	}
	return nil
}

func (x *ProxyConfig) GetImage() *v1beta1.ProxyImage {
	if x != nil {
		return x.Image
	}
	return nil
}

func (x *ProxyConfig) GetPrivateKeyProvider() *PrivateKeyProvider {
	if x != nil {
		return x.PrivateKeyProvider
	}
	return nil
}

func (x *ProxyConfig) GetProxyHeaders() *ProxyConfig_ProxyHeaders {
	if x != nil {
		return x.ProxyHeaders
	}
	return nil
}

func (x *ProxyConfig) GetFileFlushInterval() *duration.Duration {
	if x != nil {
		return x.FileFlushInterval
	}
	return nil
}

func (x *ProxyConfig) GetFileFlushMinSizeKb() uint32 {
	if x != nil {
		return x.FileFlushMinSizeKb
	}
	return 0
}

func (x *ProxyConfig) GetStatsCompression() *wrappers.BoolValue {
	if x != nil {
		return x.StatsCompression
	}
	return nil
}

type isProxyConfig_ClusterName interface {
	isProxyConfig_ClusterName()
}

type ProxyConfig_ServiceCluster struct {
	// Service cluster defines the name for the `service_cluster` that is
	// shared by all Envoy instances. This setting corresponds to
	// `--service-cluster` flag in Envoy.  In a typical Envoy deployment, the
	// `service-cluster` flag is used to identify the caller, for
	// source-based routing scenarios.
	//
	// Since Istio does not assign a local `service/service` version to each
	// Envoy instance, the name is same for all of them.  However, the
	// source/caller's identity (e.g., IP address) is encoded in the
	// `--service-node` flag when launching Envoy.  When the RDS service
	// receives API calls from Envoy, it uses the value of the `service-node`
	// flag to compute routes that are relative to the service instances
	// located at that IP address.
	ServiceCluster string `protobuf:"bytes,3,opt,name=service_cluster,json=serviceCluster,proto3,oneof"`
}

type ProxyConfig_TracingServiceName_ struct {
	// Used by Envoy proxies to assign the values for the service names in trace
	// spans.
	TracingServiceName ProxyConfig_TracingServiceName `protobuf:"varint,36,opt,name=tracing_service_name,json=tracingServiceName,proto3,enum=istio.mesh.v1alpha1.ProxyConfig_TracingServiceName,oneof"`
}

func (*ProxyConfig_ServiceCluster) isProxyConfig_ClusterName() {}

func (*ProxyConfig_TracingServiceName_) isProxyConfig_ClusterName() {}

type RemoteService struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Address of a remove service used for various purposes (access log
	// receiver, metrics receiver, etc.). Can be IP address or a fully
	// qualified DNS name.
	Address string `protobuf:"bytes,1,opt,name=address,proto3" json:"address,omitempty"`
	// Use the `tlsSettings` to specify the tls mode to use. If the remote service
	// uses Istio mutual TLS and shares the root CA with istiod, specify the TLS
	// mode as `ISTIO_MUTUAL`.
	TlsSettings *v1alpha3.ClientTLSSettings `protobuf:"bytes,2,opt,name=tls_settings,json=tlsSettings,proto3" json:"tls_settings,omitempty"`
	// If set then set `SO_KEEPALIVE` on the socket to enable TCP Keepalives.
	TcpKeepalive  *v1alpha3.ConnectionPoolSettings_TCPSettings_TcpKeepalive `protobuf:"bytes,3,opt,name=tcp_keepalive,json=tcpKeepalive,proto3" json:"tcp_keepalive,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *RemoteService) Reset() {
	*x = RemoteService{}
	mi := &file_mesh_v1alpha1_proxy_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RemoteService) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RemoteService) ProtoMessage() {}

func (x *RemoteService) ProtoReflect() protoreflect.Message {
	mi := &file_mesh_v1alpha1_proxy_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RemoteService.ProtoReflect.Descriptor instead.
func (*RemoteService) Descriptor() ([]byte, []int) {
	return file_mesh_v1alpha1_proxy_proto_rawDescGZIP(), []int{5}
}

func (x *RemoteService) GetAddress() string {
	if x != nil {
		return x.Address
	}
	return ""
}

func (x *RemoteService) GetTlsSettings() *v1alpha3.ClientTLSSettings {
	if x != nil {
		return x.TlsSettings
	}
	return nil
}

func (x *RemoteService) GetTcpKeepalive() *v1alpha3.ConnectionPoolSettings_TCPSettings_TcpKeepalive {
	if x != nil {
		return x.TcpKeepalive
	}
	return nil
}

// Zipkin defines configuration for a Zipkin tracer.
type Tracing_Zipkin struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Address of the Zipkin service (e.g. _zipkin:9411_).
	Address       string `protobuf:"bytes,1,opt,name=address,proto3" json:"address,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *Tracing_Zipkin) Reset() {
	*x = Tracing_Zipkin{}
	mi := &file_mesh_v1alpha1_proxy_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Tracing_Zipkin) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Tracing_Zipkin) ProtoMessage() {}

func (x *Tracing_Zipkin) ProtoReflect() protoreflect.Message {
	mi := &file_mesh_v1alpha1_proxy_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Tracing_Zipkin.ProtoReflect.Descriptor instead.
func (*Tracing_Zipkin) Descriptor() ([]byte, []int) {
	return file_mesh_v1alpha1_proxy_proto_rawDescGZIP(), []int{0, 0}
}

func (x *Tracing_Zipkin) GetAddress() string {
	if x != nil {
		return x.Address
	}
	return ""
}

// $hide_from_docs
// Defines configuration for a Lightstep tracer.
type Tracing_Lightstep struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Address of the Lightstep Satellite pool.
	Address string `protobuf:"bytes,1,opt,name=address,proto3" json:"address,omitempty"`
	// The Lightstep access token.
	AccessToken   string `protobuf:"bytes,2,opt,name=access_token,json=accessToken,proto3" json:"access_token,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *Tracing_Lightstep) Reset() {
	*x = Tracing_Lightstep{}
	mi := &file_mesh_v1alpha1_proxy_proto_msgTypes[7]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Tracing_Lightstep) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Tracing_Lightstep) ProtoMessage() {}

func (x *Tracing_Lightstep) ProtoReflect() protoreflect.Message {
	mi := &file_mesh_v1alpha1_proxy_proto_msgTypes[7]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Tracing_Lightstep.ProtoReflect.Descriptor instead.
func (*Tracing_Lightstep) Descriptor() ([]byte, []int) {
	return file_mesh_v1alpha1_proxy_proto_rawDescGZIP(), []int{0, 1}
}

func (x *Tracing_Lightstep) GetAddress() string {
	if x != nil {
		return x.Address
	}
	return ""
}

func (x *Tracing_Lightstep) GetAccessToken() string {
	if x != nil {
		return x.AccessToken
	}
	return ""
}

// Datadog defines configuration for a Datadog tracer.
type Tracing_Datadog struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Address of the Datadog Agent.
	Address       string `protobuf:"bytes,1,opt,name=address,proto3" json:"address,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *Tracing_Datadog) Reset() {
	*x = Tracing_Datadog{}
	mi := &file_mesh_v1alpha1_proxy_proto_msgTypes[8]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Tracing_Datadog) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Tracing_Datadog) ProtoMessage() {}

func (x *Tracing_Datadog) ProtoReflect() protoreflect.Message {
	mi := &file_mesh_v1alpha1_proxy_proto_msgTypes[8]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Tracing_Datadog.ProtoReflect.Descriptor instead.
func (*Tracing_Datadog) Descriptor() ([]byte, []int) {
	return file_mesh_v1alpha1_proxy_proto_rawDescGZIP(), []int{0, 2}
}

func (x *Tracing_Datadog) GetAddress() string {
	if x != nil {
		return x.Address
	}
	return ""
}

// Stackdriver defines configuration for a Stackdriver tracer.
// See [Envoy's OpenCensus trace configuration](https://www.envoyproxy.io/docs/envoy/latest/api-v3/config/trace/v3/opencensus.proto)
// and
// [OpenCensus trace config](https://github.com/census-instrumentation/opencensus-proto/blob/master/src/opencensus/proto/trace/v1/trace_config.proto) for details.
type Tracing_Stackdriver struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// debug enables trace output to stdout.
	// $hide_from_docs
	Debug bool `protobuf:"varint,1,opt,name=debug,proto3" json:"debug,omitempty"`
	// The global default max number of attributes per span.
	// default is 200.
	// $hide_from_docs
	MaxNumberOfAttributes *wrappers.Int64Value `protobuf:"bytes,2,opt,name=max_number_of_attributes,json=maxNumberOfAttributes,proto3" json:"max_number_of_attributes,omitempty"`
	// The global default max number of annotation events per span.
	// default is 200.
	// $hide_from_docs
	MaxNumberOfAnnotations *wrappers.Int64Value `protobuf:"bytes,3,opt,name=max_number_of_annotations,json=maxNumberOfAnnotations,proto3" json:"max_number_of_annotations,omitempty"`
	// The global default max number of message events per span.
	// default is 200.
	// $hide_from_docs
	MaxNumberOfMessageEvents *wrappers.Int64Value `protobuf:"bytes,4,opt,name=max_number_of_message_events,json=maxNumberOfMessageEvents,proto3" json:"max_number_of_message_events,omitempty"`
	unknownFields            protoimpl.UnknownFields
	sizeCache                protoimpl.SizeCache
}

func (x *Tracing_Stackdriver) Reset() {
	*x = Tracing_Stackdriver{}
	mi := &file_mesh_v1alpha1_proxy_proto_msgTypes[9]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Tracing_Stackdriver) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Tracing_Stackdriver) ProtoMessage() {}

func (x *Tracing_Stackdriver) ProtoReflect() protoreflect.Message {
	mi := &file_mesh_v1alpha1_proxy_proto_msgTypes[9]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Tracing_Stackdriver.ProtoReflect.Descriptor instead.
func (*Tracing_Stackdriver) Descriptor() ([]byte, []int) {
	return file_mesh_v1alpha1_proxy_proto_rawDescGZIP(), []int{0, 3}
}

func (x *Tracing_Stackdriver) GetDebug() bool {
	if x != nil {
		return x.Debug
	}
	return false
}

func (x *Tracing_Stackdriver) GetMaxNumberOfAttributes() *wrappers.Int64Value {
	if x != nil {
		return x.MaxNumberOfAttributes
	}
	return nil
}

func (x *Tracing_Stackdriver) GetMaxNumberOfAnnotations() *wrappers.Int64Value {
	if x != nil {
		return x.MaxNumberOfAnnotations
	}
	return nil
}

func (x *Tracing_Stackdriver) GetMaxNumberOfMessageEvents() *wrappers.Int64Value {
	if x != nil {
		return x.MaxNumberOfMessageEvents
	}
	return nil
}

// OpenCensusAgent defines configuration for an OpenCensus tracer writing to
// an OpenCensus agent backend. See
// [Envoy's OpenCensus trace configuration](https://www.envoyproxy.io/docs/envoy/latest/api-v3/config/trace/v3/opencensus.proto)
// and
// [OpenCensus trace config](https://github.com/census-instrumentation/opencensus-proto/blob/master/src/opencensus/proto/trace/v1/trace_config.proto)
// for details.
type Tracing_OpenCensusAgent struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// gRPC address for the OpenCensus agent (e.g. dns://authority/host:port or
	// unix:path). See [gRPC naming
	// docs](https://github.com/grpc/grpc/blob/master/doc/naming.md) for
	// details.
	Address string `protobuf:"bytes,1,opt,name=address,proto3" json:"address,omitempty"`
	// Specifies the set of context propagation headers used for distributed
	// tracing. Default is `["W3C_TRACE_CONTEXT"]`. If multiple values are specified,
	// the proxy will attempt to read each header for each request and will
	// write all headers.
	Context       []Tracing_OpenCensusAgent_TraceContext `protobuf:"varint,2,rep,packed,name=context,proto3,enum=istio.mesh.v1alpha1.Tracing_OpenCensusAgent_TraceContext" json:"context,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *Tracing_OpenCensusAgent) Reset() {
	*x = Tracing_OpenCensusAgent{}
	mi := &file_mesh_v1alpha1_proxy_proto_msgTypes[10]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Tracing_OpenCensusAgent) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Tracing_OpenCensusAgent) ProtoMessage() {}

func (x *Tracing_OpenCensusAgent) ProtoReflect() protoreflect.Message {
	mi := &file_mesh_v1alpha1_proxy_proto_msgTypes[10]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Tracing_OpenCensusAgent.ProtoReflect.Descriptor instead.
func (*Tracing_OpenCensusAgent) Descriptor() ([]byte, []int) {
	return file_mesh_v1alpha1_proxy_proto_rawDescGZIP(), []int{0, 4}
}

func (x *Tracing_OpenCensusAgent) GetAddress() string {
	if x != nil {
		return x.Address
	}
	return ""
}

func (x *Tracing_OpenCensusAgent) GetContext() []Tracing_OpenCensusAgent_TraceContext {
	if x != nil {
		return x.Context
	}
	return nil
}

// Configure custom tags that will be added to any active span.
// Tags can be generated via literals, environment variables or an incoming request header.
// $hide_from_docs
type Tracing_CustomTag struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Specify how to populate the value in a custom tag
	//
	// Types that are valid to be assigned to Type:
	//
	//	*Tracing_CustomTag_Literal
	//	*Tracing_CustomTag_Environment
	//	*Tracing_CustomTag_Header
	Type          isTracing_CustomTag_Type `protobuf_oneof:"type"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *Tracing_CustomTag) Reset() {
	*x = Tracing_CustomTag{}
	mi := &file_mesh_v1alpha1_proxy_proto_msgTypes[11]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Tracing_CustomTag) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Tracing_CustomTag) ProtoMessage() {}

func (x *Tracing_CustomTag) ProtoReflect() protoreflect.Message {
	mi := &file_mesh_v1alpha1_proxy_proto_msgTypes[11]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Tracing_CustomTag.ProtoReflect.Descriptor instead.
func (*Tracing_CustomTag) Descriptor() ([]byte, []int) {
	return file_mesh_v1alpha1_proxy_proto_rawDescGZIP(), []int{0, 5}
}

func (x *Tracing_CustomTag) GetType() isTracing_CustomTag_Type {
	if x != nil {
		return x.Type
	}
	return nil
}

func (x *Tracing_CustomTag) GetLiteral() *Tracing_Literal {
	if x != nil {
		if x, ok := x.Type.(*Tracing_CustomTag_Literal); ok {
			return x.Literal
		}
	}
	return nil
}

func (x *Tracing_CustomTag) GetEnvironment() *Tracing_Environment {
	if x != nil {
		if x, ok := x.Type.(*Tracing_CustomTag_Environment); ok {
			return x.Environment
		}
	}
	return nil
}

func (x *Tracing_CustomTag) GetHeader() *Tracing_RequestHeader {
	if x != nil {
		if x, ok := x.Type.(*Tracing_CustomTag_Header); ok {
			return x.Header
		}
	}
	return nil
}

type isTracing_CustomTag_Type interface {
	isTracing_CustomTag_Type()
}

type Tracing_CustomTag_Literal struct {
	// The custom tag's value is the specified literal.
	Literal *Tracing_Literal `protobuf:"bytes,1,opt,name=literal,proto3,oneof"`
}

type Tracing_CustomTag_Environment struct {
	// The custom tag's value should be populated from an environmental
	// variable
	Environment *Tracing_Environment `protobuf:"bytes,2,opt,name=environment,proto3,oneof"`
}

type Tracing_CustomTag_Header struct {
	// The custom tag's value is populated by an http header from
	// an incoming request.
	Header *Tracing_RequestHeader `protobuf:"bytes,3,opt,name=header,proto3,oneof"`
}

func (*Tracing_CustomTag_Literal) isTracing_CustomTag_Type() {}

func (*Tracing_CustomTag_Environment) isTracing_CustomTag_Type() {}

func (*Tracing_CustomTag_Header) isTracing_CustomTag_Type() {}

// Literal type represents a static value.
// $hide_from_docs
type Tracing_Literal struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Static literal value used to populate the tag value.
	Value         string `protobuf:"bytes,1,opt,name=value,proto3" json:"value,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *Tracing_Literal) Reset() {
	*x = Tracing_Literal{}
	mi := &file_mesh_v1alpha1_proxy_proto_msgTypes[12]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Tracing_Literal) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Tracing_Literal) ProtoMessage() {}

func (x *Tracing_Literal) ProtoReflect() protoreflect.Message {
	mi := &file_mesh_v1alpha1_proxy_proto_msgTypes[12]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Tracing_Literal.ProtoReflect.Descriptor instead.
func (*Tracing_Literal) Descriptor() ([]byte, []int) {
	return file_mesh_v1alpha1_proxy_proto_rawDescGZIP(), []int{0, 6}
}

func (x *Tracing_Literal) GetValue() string {
	if x != nil {
		return x.Value
	}
	return ""
}

// Environment is the proxy's environment variable to be used for populating the custom span tag.
// $hide_from_docs
type Tracing_Environment struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Name of the environment variable used to populate the tag's value
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// When the environment variable is not found,
	// the tag's value will be populated with this default value if specified,
	// otherwise the tag will not be populated.
	DefaultValue  string `protobuf:"bytes,2,opt,name=default_value,json=defaultValue,proto3" json:"default_value,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *Tracing_Environment) Reset() {
	*x = Tracing_Environment{}
	mi := &file_mesh_v1alpha1_proxy_proto_msgTypes[13]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Tracing_Environment) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Tracing_Environment) ProtoMessage() {}

func (x *Tracing_Environment) ProtoReflect() protoreflect.Message {
	mi := &file_mesh_v1alpha1_proxy_proto_msgTypes[13]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Tracing_Environment.ProtoReflect.Descriptor instead.
func (*Tracing_Environment) Descriptor() ([]byte, []int) {
	return file_mesh_v1alpha1_proxy_proto_rawDescGZIP(), []int{0, 7}
}

func (x *Tracing_Environment) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Tracing_Environment) GetDefaultValue() string {
	if x != nil {
		return x.DefaultValue
	}
	return ""
}

// RequestHeader is the HTTP request header which will be used to populate the span tag.
// A default value can be configured if the header does not exist.
// $hide_from_docs
type Tracing_RequestHeader struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// HTTP header name used to obtain the value from to populate the tag value.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Default value to be used for the tag when the named HTTP header does not exist.
	// The tag will be skipped if no default value is provided.
	DefaultValue  string `protobuf:"bytes,2,opt,name=default_value,json=defaultValue,proto3" json:"default_value,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *Tracing_RequestHeader) Reset() {
	*x = Tracing_RequestHeader{}
	mi := &file_mesh_v1alpha1_proxy_proto_msgTypes[14]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Tracing_RequestHeader) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Tracing_RequestHeader) ProtoMessage() {}

func (x *Tracing_RequestHeader) ProtoReflect() protoreflect.Message {
	mi := &file_mesh_v1alpha1_proxy_proto_msgTypes[14]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Tracing_RequestHeader.ProtoReflect.Descriptor instead.
func (*Tracing_RequestHeader) Descriptor() ([]byte, []int) {
	return file_mesh_v1alpha1_proxy_proto_rawDescGZIP(), []int{0, 8}
}

func (x *Tracing_RequestHeader) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Tracing_RequestHeader) GetDefaultValue() string {
	if x != nil {
		return x.DefaultValue
	}
	return ""
}

// PROXY protocol configuration.
type Topology_ProxyProtocolConfiguration struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *Topology_ProxyProtocolConfiguration) Reset() {
	*x = Topology_ProxyProtocolConfiguration{}
	mi := &file_mesh_v1alpha1_proxy_proto_msgTypes[16]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Topology_ProxyProtocolConfiguration) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Topology_ProxyProtocolConfiguration) ProtoMessage() {}

func (x *Topology_ProxyProtocolConfiguration) ProtoReflect() protoreflect.Message {
	mi := &file_mesh_v1alpha1_proxy_proto_msgTypes[16]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Topology_ProxyProtocolConfiguration.ProtoReflect.Descriptor instead.
func (*Topology_ProxyProtocolConfiguration) Descriptor() ([]byte, []int) {
	return file_mesh_v1alpha1_proxy_proto_rawDescGZIP(), []int{2, 0}
}

// CryptoMb PrivateKeyProvider configuration
type PrivateKeyProvider_CryptoMb struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// How long to wait until the per-thread processing queue should be processed. If the processing queue
	// gets full (eight sign or decrypt requests are received) it is processed immediately.
	// However, if the queue is not filled before the delay has expired, the requests already in the queue
	// are processed, even if the queue is not full.
	// In effect, this value controls the balance between latency and throughput.
	// The duration needs to be set to a value greater than or equal to 1 millisecond.
	PollDelay *duration.Duration `protobuf:"bytes,1,opt,name=poll_delay,json=pollDelay,proto3" json:"poll_delay,omitempty"`
	// If the private key provider isn’t available (eg. the required hardware capability doesn’t existed)
	// Envoy will fallback to the BoringSSL default implementation when the fallback is true.
	// The default value is false.
	Fallback      *wrappers.BoolValue `protobuf:"bytes,2,opt,name=fallback,proto3" json:"fallback,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *PrivateKeyProvider_CryptoMb) Reset() {
	*x = PrivateKeyProvider_CryptoMb{}
	mi := &file_mesh_v1alpha1_proxy_proto_msgTypes[17]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PrivateKeyProvider_CryptoMb) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PrivateKeyProvider_CryptoMb) ProtoMessage() {}

func (x *PrivateKeyProvider_CryptoMb) ProtoReflect() protoreflect.Message {
	mi := &file_mesh_v1alpha1_proxy_proto_msgTypes[17]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PrivateKeyProvider_CryptoMb.ProtoReflect.Descriptor instead.
func (*PrivateKeyProvider_CryptoMb) Descriptor() ([]byte, []int) {
	return file_mesh_v1alpha1_proxy_proto_rawDescGZIP(), []int{3, 0}
}

func (x *PrivateKeyProvider_CryptoMb) GetPollDelay() *duration.Duration {
	if x != nil {
		return x.PollDelay
	}
	return nil
}

func (x *PrivateKeyProvider_CryptoMb) GetFallback() *wrappers.BoolValue {
	if x != nil {
		return x.Fallback
	}
	return nil
}

// QAT (QuickAssist Technology) PrivateKeyProvider configuration
type PrivateKeyProvider_QAT struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// How long to wait before polling the hardware accelerator after a request has been submitted there.
	// Having a small value leads to quicker answers from the hardware but causes more polling loop spins,
	// leading to potentially larger CPU usage.
	// The duration needs to be set to a value greater than or equal to 1 millisecond.
	PollDelay *duration.Duration `protobuf:"bytes,1,opt,name=poll_delay,json=pollDelay,proto3" json:"poll_delay,omitempty"`
	// If the private key provider isn’t available (eg. the required hardware capability doesn’t existed)
	// Envoy will fallback to the BoringSSL default implementation when the fallback is true.
	// The default value is false.
	Fallback      *wrappers.BoolValue `protobuf:"bytes,2,opt,name=fallback,proto3" json:"fallback,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *PrivateKeyProvider_QAT) Reset() {
	*x = PrivateKeyProvider_QAT{}
	mi := &file_mesh_v1alpha1_proxy_proto_msgTypes[18]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PrivateKeyProvider_QAT) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PrivateKeyProvider_QAT) ProtoMessage() {}

func (x *PrivateKeyProvider_QAT) ProtoReflect() protoreflect.Message {
	mi := &file_mesh_v1alpha1_proxy_proto_msgTypes[18]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PrivateKeyProvider_QAT.ProtoReflect.Descriptor instead.
func (*PrivateKeyProvider_QAT) Descriptor() ([]byte, []int) {
	return file_mesh_v1alpha1_proxy_proto_rawDescGZIP(), []int{3, 1}
}

func (x *PrivateKeyProvider_QAT) GetPollDelay() *duration.Duration {
	if x != nil {
		return x.PollDelay
	}
	return nil
}

func (x *PrivateKeyProvider_QAT) GetFallback() *wrappers.BoolValue {
	if x != nil {
		return x.Fallback
	}
	return nil
}

// Proxy stats name matchers for stats creation. Note this is in addition to
// the minimum Envoy stats that Istio generates by default.
type ProxyConfig_ProxyStatsMatcher struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Proxy stats name prefix matcher for inclusion.
	InclusionPrefixes []string `protobuf:"bytes,1,rep,name=inclusion_prefixes,json=inclusionPrefixes,proto3" json:"inclusion_prefixes,omitempty"`
	// Proxy stats name suffix matcher for inclusion.
	InclusionSuffixes []string `protobuf:"bytes,2,rep,name=inclusion_suffixes,json=inclusionSuffixes,proto3" json:"inclusion_suffixes,omitempty"`
	// Proxy stats name regexps matcher for inclusion.
	InclusionRegexps []string `protobuf:"bytes,3,rep,name=inclusion_regexps,json=inclusionRegexps,proto3" json:"inclusion_regexps,omitempty"`
	unknownFields    protoimpl.UnknownFields
	sizeCache        protoimpl.SizeCache
}

func (x *ProxyConfig_ProxyStatsMatcher) Reset() {
	*x = ProxyConfig_ProxyStatsMatcher{}
	mi := &file_mesh_v1alpha1_proxy_proto_msgTypes[21]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ProxyConfig_ProxyStatsMatcher) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ProxyConfig_ProxyStatsMatcher) ProtoMessage() {}

func (x *ProxyConfig_ProxyStatsMatcher) ProtoReflect() protoreflect.Message {
	mi := &file_mesh_v1alpha1_proxy_proto_msgTypes[21]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ProxyConfig_ProxyStatsMatcher.ProtoReflect.Descriptor instead.
func (*ProxyConfig_ProxyStatsMatcher) Descriptor() ([]byte, []int) {
	return file_mesh_v1alpha1_proxy_proto_rawDescGZIP(), []int{4, 2}
}

func (x *ProxyConfig_ProxyStatsMatcher) GetInclusionPrefixes() []string {
	if x != nil {
		return x.InclusionPrefixes
	}
	return nil
}

func (x *ProxyConfig_ProxyStatsMatcher) GetInclusionSuffixes() []string {
	if x != nil {
		return x.InclusionSuffixes
	}
	return nil
}

func (x *ProxyConfig_ProxyStatsMatcher) GetInclusionRegexps() []string {
	if x != nil {
		return x.InclusionRegexps
	}
	return nil
}

type ProxyConfig_ProxyHeaders struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Controls the `X-Forwarded-Client-Cert` header for inbound sidecar requests. To set this on gateways, use the `Topology` setting.
	// To disable the header, configure either `SANITIZE` (to always remove the header, if present) or `FORWARD_ONLY` (to leave the header as-is).
	// By default, `APPEND_FORWARD` will be used.
	ForwardedClientCert ForwardClientCertDetails `protobuf:"varint,1,opt,name=forwarded_client_cert,json=forwardedClientCert,proto3,enum=istio.mesh.v1alpha1.ForwardClientCertDetails" json:"forwarded_client_cert,omitempty"`
	// This field is valid only when forward_client_cert_details is APPEND_FORWARD or SANITIZE_SET
	// and the client connection is mTLS. It specifies the fields in
	// the client certificate to be forwarded. Note that `Hash` is always set, and
	// `By` is always set when the client certificate presents the URI type Subject Alternative Name value.
	SetCurrentClientCertDetails *ProxyConfig_ProxyHeaders_SetCurrentClientCertDetails `protobuf:"bytes,7,opt,name=set_current_client_cert_details,json=setCurrentClientCertDetails,proto3" json:"set_current_client_cert_details,omitempty"`
	// Controls the `X-Request-Id` header. If enabled, a request ID is generated for each request if one is not already set.
	// This applies to all types of traffic (inbound, outbound, and gateways).
	// If disabled, no request ID will be generate for the request. If it is already present, it will be preserved.
	// Warning: request IDs are a critical component to mesh tracing and logging, so disabling this is not recommended.
	// This header is enabled by default if not configured.
	RequestId *ProxyConfig_ProxyHeaders_RequestId `protobuf:"bytes,3,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
	// Controls the `server` header. If enabled, the `Server: istio-envoy` header is set in response headers for inbound traffic (including gateways).
	// If disabled, the `Server` header is not modified. If it is already present, it will be preserved.
	Server *ProxyConfig_ProxyHeaders_Server `protobuf:"bytes,2,opt,name=server,proto3" json:"server,omitempty"`
	// Controls the `X-Envoy-Attempt-Count` header.
	// If enabled, this header will be added on outbound request headers (including gateways) that have retries configured.
	// If disabled, this header will not be set. If it is already present, it will be preserved.
	// This header is enabled by default if not configured.
	AttemptCount *ProxyConfig_ProxyHeaders_AttemptCount `protobuf:"bytes,4,opt,name=attempt_count,json=attemptCount,proto3" json:"attempt_count,omitempty"`
	// Controls various `X-Envoy-*` headers, such as `X-Envoy-Overloaded` and `X-Envoy-Upstream-Service-Time`. If enabled,
	// these headers will be included.
	// If disabled, these headers will not be set. If they are already present, they will be preserved.
	// See the [Envoy documentation](https://www.envoyproxy.io/docs/envoy/latest/api-v3/extensions/filters/http/router/v3/router.proto#envoy-v3-api-field-extensions-filters-http-router-v3-router-suppress-envoy-headers) for more details.
	// These headers are enabled by default if not configured.
	EnvoyDebugHeaders *ProxyConfig_ProxyHeaders_EnvoyDebugHeaders `protobuf:"bytes,5,opt,name=envoy_debug_headers,json=envoyDebugHeaders,proto3" json:"envoy_debug_headers,omitempty"`
	// Controls Istio metadata exchange headers `X-Envoy-Peer-Metadata` and `X-Envoy-Peer-Metadata-Id`.
	// By default, the behavior is unspecified.
	// If IN_MESH, these headers will not be appended to outbound requests from sidecars to services not in-mesh.
	MetadataExchangeHeaders *ProxyConfig_ProxyHeaders_MetadataExchangeHeaders `protobuf:"bytes,6,opt,name=metadata_exchange_headers,json=metadataExchangeHeaders,proto3" json:"metadata_exchange_headers,omitempty"`
	// When true, the original case of HTTP/1.x headers will be preserved
	// as they pass through the proxy, rather than normalizing them to lowercase.
	// This field is particularly useful for applications that require case-sensitive
	// headers for interoperability with downstream systems or APIs that expect specific
	// casing.
	// The preserve_http1_header_case option only applies to HTTP/1.x traffic, as HTTP/2 requires all headers
	// to be lowercase per the protocol specification. Envoy will ignore this field for HTTP/2
	// requests and automatically normalize headers to lowercase, ensuring compliance with HTTP/2
	// standards.
	PreserveHttp1HeaderCase *wrappers.BoolValue `protobuf:"bytes,40,opt,name=preserve_http1_header_case,json=preserveHttp1HeaderCase,proto3" json:"preserve_http1_header_case,omitempty"`
	// Controls the `X-Forwarded-Host` header. If enabled, the `X-Forwarded-Host` header is appended
	// with the original host when it is rewritten.
	// This header is disabled by default.
	XForwardedHost *ProxyConfig_ProxyHeaders_XForwardedHost `protobuf:"bytes,41,opt,name=x_forwarded_host,json=xForwardedHost,proto3" json:"x_forwarded_host,omitempty"`
	// Controls the `X-Forwarded-Port` header. If enabled, the `X-Forwarded-Port` header is header with the port value
	// client used to connect to Envoy. It will be ignored if the “x-forwarded-port“ header has been set by any
	// trusted proxy in front of Envoy.
	// This header is disabled by default.
	XForwardedPort *ProxyConfig_ProxyHeaders_XForwardedPort `protobuf:"bytes,42,opt,name=x_forwarded_port,json=xForwardedPort,proto3" json:"x_forwarded_port,omitempty"`
	unknownFields  protoimpl.UnknownFields
	sizeCache      protoimpl.SizeCache
}

func (x *ProxyConfig_ProxyHeaders) Reset() {
	*x = ProxyConfig_ProxyHeaders{}
	mi := &file_mesh_v1alpha1_proxy_proto_msgTypes[22]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ProxyConfig_ProxyHeaders) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ProxyConfig_ProxyHeaders) ProtoMessage() {}

func (x *ProxyConfig_ProxyHeaders) ProtoReflect() protoreflect.Message {
	mi := &file_mesh_v1alpha1_proxy_proto_msgTypes[22]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ProxyConfig_ProxyHeaders.ProtoReflect.Descriptor instead.
func (*ProxyConfig_ProxyHeaders) Descriptor() ([]byte, []int) {
	return file_mesh_v1alpha1_proxy_proto_rawDescGZIP(), []int{4, 3}
}

func (x *ProxyConfig_ProxyHeaders) GetForwardedClientCert() ForwardClientCertDetails {
	if x != nil {
		return x.ForwardedClientCert
	}
	return ForwardClientCertDetails_UNDEFINED
}

func (x *ProxyConfig_ProxyHeaders) GetSetCurrentClientCertDetails() *ProxyConfig_ProxyHeaders_SetCurrentClientCertDetails {
	if x != nil {
		return x.SetCurrentClientCertDetails
	}
	return nil
}

func (x *ProxyConfig_ProxyHeaders) GetRequestId() *ProxyConfig_ProxyHeaders_RequestId {
	if x != nil {
		return x.RequestId
	}
	return nil
}

func (x *ProxyConfig_ProxyHeaders) GetServer() *ProxyConfig_ProxyHeaders_Server {
	if x != nil {
		return x.Server
	}
	return nil
}

func (x *ProxyConfig_ProxyHeaders) GetAttemptCount() *ProxyConfig_ProxyHeaders_AttemptCount {
	if x != nil {
		return x.AttemptCount
	}
	return nil
}

func (x *ProxyConfig_ProxyHeaders) GetEnvoyDebugHeaders() *ProxyConfig_ProxyHeaders_EnvoyDebugHeaders {
	if x != nil {
		return x.EnvoyDebugHeaders
	}
	return nil
}

func (x *ProxyConfig_ProxyHeaders) GetMetadataExchangeHeaders() *ProxyConfig_ProxyHeaders_MetadataExchangeHeaders {
	if x != nil {
		return x.MetadataExchangeHeaders
	}
	return nil
}

func (x *ProxyConfig_ProxyHeaders) GetPreserveHttp1HeaderCase() *wrappers.BoolValue {
	if x != nil {
		return x.PreserveHttp1HeaderCase
	}
	return nil
}

func (x *ProxyConfig_ProxyHeaders) GetXForwardedHost() *ProxyConfig_ProxyHeaders_XForwardedHost {
	if x != nil {
		return x.XForwardedHost
	}
	return nil
}

func (x *ProxyConfig_ProxyHeaders) GetXForwardedPort() *ProxyConfig_ProxyHeaders_XForwardedPort {
	if x != nil {
		return x.XForwardedPort
	}
	return nil
}

type ProxyConfig_ProxyHeaders_Server struct {
	state    protoimpl.MessageState `protogen:"open.v1"`
	Disabled *wrappers.BoolValue    `protobuf:"bytes,1,opt,name=disabled,proto3" json:"disabled,omitempty"`
	// If set, and the server header is enabled, this value will be set as the server header. By default, `istio-envoy` will be used.
	Value         string `protobuf:"bytes,2,opt,name=value,proto3" json:"value,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ProxyConfig_ProxyHeaders_Server) Reset() {
	*x = ProxyConfig_ProxyHeaders_Server{}
	mi := &file_mesh_v1alpha1_proxy_proto_msgTypes[23]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ProxyConfig_ProxyHeaders_Server) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ProxyConfig_ProxyHeaders_Server) ProtoMessage() {}

func (x *ProxyConfig_ProxyHeaders_Server) ProtoReflect() protoreflect.Message {
	mi := &file_mesh_v1alpha1_proxy_proto_msgTypes[23]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ProxyConfig_ProxyHeaders_Server.ProtoReflect.Descriptor instead.
func (*ProxyConfig_ProxyHeaders_Server) Descriptor() ([]byte, []int) {
	return file_mesh_v1alpha1_proxy_proto_rawDescGZIP(), []int{4, 3, 0}
}

func (x *ProxyConfig_ProxyHeaders_Server) GetDisabled() *wrappers.BoolValue {
	if x != nil {
		return x.Disabled
	}
	return nil
}

func (x *ProxyConfig_ProxyHeaders_Server) GetValue() string {
	if x != nil {
		return x.Value
	}
	return ""
}

type ProxyConfig_ProxyHeaders_RequestId struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Disabled      *wrappers.BoolValue    `protobuf:"bytes,1,opt,name=disabled,proto3" json:"disabled,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ProxyConfig_ProxyHeaders_RequestId) Reset() {
	*x = ProxyConfig_ProxyHeaders_RequestId{}
	mi := &file_mesh_v1alpha1_proxy_proto_msgTypes[24]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ProxyConfig_ProxyHeaders_RequestId) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ProxyConfig_ProxyHeaders_RequestId) ProtoMessage() {}

func (x *ProxyConfig_ProxyHeaders_RequestId) ProtoReflect() protoreflect.Message {
	mi := &file_mesh_v1alpha1_proxy_proto_msgTypes[24]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ProxyConfig_ProxyHeaders_RequestId.ProtoReflect.Descriptor instead.
func (*ProxyConfig_ProxyHeaders_RequestId) Descriptor() ([]byte, []int) {
	return file_mesh_v1alpha1_proxy_proto_rawDescGZIP(), []int{4, 3, 1}
}

func (x *ProxyConfig_ProxyHeaders_RequestId) GetDisabled() *wrappers.BoolValue {
	if x != nil {
		return x.Disabled
	}
	return nil
}

type ProxyConfig_ProxyHeaders_AttemptCount struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Disabled      *wrappers.BoolValue    `protobuf:"bytes,1,opt,name=disabled,proto3" json:"disabled,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ProxyConfig_ProxyHeaders_AttemptCount) Reset() {
	*x = ProxyConfig_ProxyHeaders_AttemptCount{}
	mi := &file_mesh_v1alpha1_proxy_proto_msgTypes[25]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ProxyConfig_ProxyHeaders_AttemptCount) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ProxyConfig_ProxyHeaders_AttemptCount) ProtoMessage() {}

func (x *ProxyConfig_ProxyHeaders_AttemptCount) ProtoReflect() protoreflect.Message {
	mi := &file_mesh_v1alpha1_proxy_proto_msgTypes[25]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ProxyConfig_ProxyHeaders_AttemptCount.ProtoReflect.Descriptor instead.
func (*ProxyConfig_ProxyHeaders_AttemptCount) Descriptor() ([]byte, []int) {
	return file_mesh_v1alpha1_proxy_proto_rawDescGZIP(), []int{4, 3, 2}
}

func (x *ProxyConfig_ProxyHeaders_AttemptCount) GetDisabled() *wrappers.BoolValue {
	if x != nil {
		return x.Disabled
	}
	return nil
}

type ProxyConfig_ProxyHeaders_XForwardedHost struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Enabled       *wrappers.BoolValue    `protobuf:"bytes,1,opt,name=enabled,proto3" json:"enabled,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ProxyConfig_ProxyHeaders_XForwardedHost) Reset() {
	*x = ProxyConfig_ProxyHeaders_XForwardedHost{}
	mi := &file_mesh_v1alpha1_proxy_proto_msgTypes[26]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ProxyConfig_ProxyHeaders_XForwardedHost) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ProxyConfig_ProxyHeaders_XForwardedHost) ProtoMessage() {}

func (x *ProxyConfig_ProxyHeaders_XForwardedHost) ProtoReflect() protoreflect.Message {
	mi := &file_mesh_v1alpha1_proxy_proto_msgTypes[26]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ProxyConfig_ProxyHeaders_XForwardedHost.ProtoReflect.Descriptor instead.
func (*ProxyConfig_ProxyHeaders_XForwardedHost) Descriptor() ([]byte, []int) {
	return file_mesh_v1alpha1_proxy_proto_rawDescGZIP(), []int{4, 3, 3}
}

func (x *ProxyConfig_ProxyHeaders_XForwardedHost) GetEnabled() *wrappers.BoolValue {
	if x != nil {
		return x.Enabled
	}
	return nil
}

type ProxyConfig_ProxyHeaders_XForwardedPort struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Enabled       *wrappers.BoolValue    `protobuf:"bytes,1,opt,name=enabled,proto3" json:"enabled,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ProxyConfig_ProxyHeaders_XForwardedPort) Reset() {
	*x = ProxyConfig_ProxyHeaders_XForwardedPort{}
	mi := &file_mesh_v1alpha1_proxy_proto_msgTypes[27]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ProxyConfig_ProxyHeaders_XForwardedPort) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ProxyConfig_ProxyHeaders_XForwardedPort) ProtoMessage() {}

func (x *ProxyConfig_ProxyHeaders_XForwardedPort) ProtoReflect() protoreflect.Message {
	mi := &file_mesh_v1alpha1_proxy_proto_msgTypes[27]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ProxyConfig_ProxyHeaders_XForwardedPort.ProtoReflect.Descriptor instead.
func (*ProxyConfig_ProxyHeaders_XForwardedPort) Descriptor() ([]byte, []int) {
	return file_mesh_v1alpha1_proxy_proto_rawDescGZIP(), []int{4, 3, 4}
}

func (x *ProxyConfig_ProxyHeaders_XForwardedPort) GetEnabled() *wrappers.BoolValue {
	if x != nil {
		return x.Enabled
	}
	return nil
}

type ProxyConfig_ProxyHeaders_EnvoyDebugHeaders struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Disabled      *wrappers.BoolValue    `protobuf:"bytes,1,opt,name=disabled,proto3" json:"disabled,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ProxyConfig_ProxyHeaders_EnvoyDebugHeaders) Reset() {
	*x = ProxyConfig_ProxyHeaders_EnvoyDebugHeaders{}
	mi := &file_mesh_v1alpha1_proxy_proto_msgTypes[28]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ProxyConfig_ProxyHeaders_EnvoyDebugHeaders) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ProxyConfig_ProxyHeaders_EnvoyDebugHeaders) ProtoMessage() {}

func (x *ProxyConfig_ProxyHeaders_EnvoyDebugHeaders) ProtoReflect() protoreflect.Message {
	mi := &file_mesh_v1alpha1_proxy_proto_msgTypes[28]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ProxyConfig_ProxyHeaders_EnvoyDebugHeaders.ProtoReflect.Descriptor instead.
func (*ProxyConfig_ProxyHeaders_EnvoyDebugHeaders) Descriptor() ([]byte, []int) {
	return file_mesh_v1alpha1_proxy_proto_rawDescGZIP(), []int{4, 3, 5}
}

func (x *ProxyConfig_ProxyHeaders_EnvoyDebugHeaders) GetDisabled() *wrappers.BoolValue {
	if x != nil {
		return x.Disabled
	}
	return nil
}

type ProxyConfig_ProxyHeaders_MetadataExchangeHeaders struct {
	state         protoimpl.MessageState                        `protogen:"open.v1"`
	Mode          ProxyConfig_ProxyHeaders_MetadataExchangeMode `protobuf:"varint,1,opt,name=mode,proto3,enum=istio.mesh.v1alpha1.ProxyConfig_ProxyHeaders_MetadataExchangeMode" json:"mode,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ProxyConfig_ProxyHeaders_MetadataExchangeHeaders) Reset() {
	*x = ProxyConfig_ProxyHeaders_MetadataExchangeHeaders{}
	mi := &file_mesh_v1alpha1_proxy_proto_msgTypes[29]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ProxyConfig_ProxyHeaders_MetadataExchangeHeaders) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ProxyConfig_ProxyHeaders_MetadataExchangeHeaders) ProtoMessage() {}

func (x *ProxyConfig_ProxyHeaders_MetadataExchangeHeaders) ProtoReflect() protoreflect.Message {
	mi := &file_mesh_v1alpha1_proxy_proto_msgTypes[29]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ProxyConfig_ProxyHeaders_MetadataExchangeHeaders.ProtoReflect.Descriptor instead.
func (*ProxyConfig_ProxyHeaders_MetadataExchangeHeaders) Descriptor() ([]byte, []int) {
	return file_mesh_v1alpha1_proxy_proto_rawDescGZIP(), []int{4, 3, 6}
}

func (x *ProxyConfig_ProxyHeaders_MetadataExchangeHeaders) GetMode() ProxyConfig_ProxyHeaders_MetadataExchangeMode {
	if x != nil {
		return x.Mode
	}
	return ProxyConfig_ProxyHeaders_UNDEFINED
}

type ProxyConfig_ProxyHeaders_SetCurrentClientCertDetails struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Whether to forward the subject of the client cert. Defaults to true.
	Subject *wrappers.BoolValue `protobuf:"bytes,1,opt,name=subject,proto3" json:"subject,omitempty"`
	// Whether to forward the entire client cert in URL encoded PEM format. This will appear in the
	// XFCC header comma separated from other values with the value Cert="PEM".
	// Defaults to false.
	Cert *wrappers.BoolValue `protobuf:"bytes,2,opt,name=cert,proto3" json:"cert,omitempty"`
	// Whether to forward the entire client cert chain (including the leaf cert) in URL encoded PEM
	// format. This will appear in the XFCC header comma separated from other values with the value
	// Chain="PEM".
	// Defaults to false.
	Chain *wrappers.BoolValue `protobuf:"bytes,3,opt,name=chain,proto3" json:"chain,omitempty"`
	// Whether to forward the DNS type Subject Alternative Names of the client cert.
	// Defaults to true.
	Dns *wrappers.BoolValue `protobuf:"bytes,4,opt,name=dns,proto3" json:"dns,omitempty"`
	// Whether to forward the URI type Subject Alternative Name of the client cert. Defaults to
	// true.
	Uri           *wrappers.BoolValue `protobuf:"bytes,5,opt,name=uri,proto3" json:"uri,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ProxyConfig_ProxyHeaders_SetCurrentClientCertDetails) Reset() {
	*x = ProxyConfig_ProxyHeaders_SetCurrentClientCertDetails{}
	mi := &file_mesh_v1alpha1_proxy_proto_msgTypes[30]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ProxyConfig_ProxyHeaders_SetCurrentClientCertDetails) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ProxyConfig_ProxyHeaders_SetCurrentClientCertDetails) ProtoMessage() {}

func (x *ProxyConfig_ProxyHeaders_SetCurrentClientCertDetails) ProtoReflect() protoreflect.Message {
	mi := &file_mesh_v1alpha1_proxy_proto_msgTypes[30]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ProxyConfig_ProxyHeaders_SetCurrentClientCertDetails.ProtoReflect.Descriptor instead.
func (*ProxyConfig_ProxyHeaders_SetCurrentClientCertDetails) Descriptor() ([]byte, []int) {
	return file_mesh_v1alpha1_proxy_proto_rawDescGZIP(), []int{4, 3, 7}
}

func (x *ProxyConfig_ProxyHeaders_SetCurrentClientCertDetails) GetSubject() *wrappers.BoolValue {
	if x != nil {
		return x.Subject
	}
	return nil
}

func (x *ProxyConfig_ProxyHeaders_SetCurrentClientCertDetails) GetCert() *wrappers.BoolValue {
	if x != nil {
		return x.Cert
	}
	return nil
}

func (x *ProxyConfig_ProxyHeaders_SetCurrentClientCertDetails) GetChain() *wrappers.BoolValue {
	if x != nil {
		return x.Chain
	}
	return nil
}

func (x *ProxyConfig_ProxyHeaders_SetCurrentClientCertDetails) GetDns() *wrappers.BoolValue {
	if x != nil {
		return x.Dns
	}
	return nil
}

func (x *ProxyConfig_ProxyHeaders_SetCurrentClientCertDetails) GetUri() *wrappers.BoolValue {
	if x != nil {
		return x.Uri
	}
	return nil
}

var File_mesh_v1alpha1_proxy_proto protoreflect.FileDescriptor

const file_mesh_v1alpha1_proxy_proto_rawDesc = "" +
	"\n" +
	"\x19mesh/v1alpha1/proxy.proto\x12\x13istio.mesh.v1alpha1\x1a\x1egoogle/protobuf/duration.proto\x1a\x1egoogle/protobuf/wrappers.proto\x1a*networking/v1alpha3/destination_rule.proto\x1a(networking/v1alpha3/workload_group.proto\x1a%networking/v1beta1/proxy_config.proto\"\xed\x0e\n" +
	"\aTracing\x12=\n" +
	"\x06zipkin\x18\x01 \x01(\v2#.istio.mesh.v1alpha1.Tracing.ZipkinH\x00R\x06zipkin\x12F\n" +
	"\tlightstep\x18\x02 \x01(\v2&.istio.mesh.v1alpha1.Tracing.LightstepH\x00R\tlightstep\x12@\n" +
	"\adatadog\x18\x03 \x01(\v2$.istio.mesh.v1alpha1.Tracing.DatadogH\x00R\adatadog\x12L\n" +
	"\vstackdriver\x18\x04 \x01(\v2(.istio.mesh.v1alpha1.Tracing.StackdriverH\x00R\vstackdriver\x12Z\n" +
	"\x11open_census_agent\x18\t \x01(\v2,.istio.mesh.v1alpha1.Tracing.OpenCensusAgentH\x00R\x0fopenCensusAgent\x12M\n" +
	"\vcustom_tags\x18\x05 \x03(\v2,.istio.mesh.v1alpha1.Tracing.CustomTagsEntryR\n" +
	"customTags\x12-\n" +
	"\x13max_path_tag_length\x18\x06 \x01(\rR\x10maxPathTagLength\x12\x1a\n" +
	"\bsampling\x18\a \x01(\x01R\bsampling\x12O\n" +
	"\ftls_settings\x18\b \x01(\v2,.istio.networking.v1alpha3.ClientTLSSettingsR\vtlsSettings\x12F\n" +
	"\x11enable_istio_tags\x18\n" +
	" \x01(\v2\x1a.google.protobuf.BoolValueR\x0fenableIstioTags\x1a\"\n" +
	"\x06Zipkin\x12\x18\n" +
	"\aaddress\x18\x01 \x01(\tR\aaddress\x1aH\n" +
	"\tLightstep\x12\x18\n" +
	"\aaddress\x18\x01 \x01(\tR\aaddress\x12!\n" +
	"\faccess_token\x18\x02 \x01(\tR\vaccessToken\x1a#\n" +
	"\aDatadog\x12\x18\n" +
	"\aaddress\x18\x01 \x01(\tR\aaddress\x1a\xae\x02\n" +
	"\vStackdriver\x12\x14\n" +
	"\x05debug\x18\x01 \x01(\bR\x05debug\x12T\n" +
	"\x18max_number_of_attributes\x18\x02 \x01(\v2\x1b.google.protobuf.Int64ValueR\x15maxNumberOfAttributes\x12V\n" +
	"\x19max_number_of_annotations\x18\x03 \x01(\v2\x1b.google.protobuf.Int64ValueR\x16maxNumberOfAnnotations\x12[\n" +
	"\x1cmax_number_of_message_events\x18\x04 \x01(\v2\x1b.google.protobuf.Int64ValueR\x18maxNumberOfMessageEvents\x1a\xe7\x01\n" +
	"\x0fOpenCensusAgent\x12\x18\n" +
	"\aaddress\x18\x01 \x01(\tR\aaddress\x12S\n" +
	"\acontext\x18\x02 \x03(\x0e29.istio.mesh.v1alpha1.Tracing.OpenCensusAgent.TraceContextR\acontext\"e\n" +
	"\fTraceContext\x12\x0f\n" +
	"\vUNSPECIFIED\x10\x00\x12\x15\n" +
	"\x11W3C_TRACE_CONTEXT\x10\x01\x12\f\n" +
	"\bGRPC_BIN\x10\x02\x12\x17\n" +
	"\x13CLOUD_TRACE_CONTEXT\x10\x03\x12\x06\n" +
	"\x02B3\x10\x04\x1a\xe9\x01\n" +
	"\tCustomTag\x12@\n" +
	"\aliteral\x18\x01 \x01(\v2$.istio.mesh.v1alpha1.Tracing.LiteralH\x00R\aliteral\x12L\n" +
	"\venvironment\x18\x02 \x01(\v2(.istio.mesh.v1alpha1.Tracing.EnvironmentH\x00R\venvironment\x12D\n" +
	"\x06header\x18\x03 \x01(\v2*.istio.mesh.v1alpha1.Tracing.RequestHeaderH\x00R\x06headerB\x06\n" +
	"\x04type\x1a\x1f\n" +
	"\aLiteral\x12\x14\n" +
	"\x05value\x18\x01 \x01(\tR\x05value\x1aF\n" +
	"\vEnvironment\x12\x12\n" +
	"\x04name\x18\x01 \x01(\tR\x04name\x12#\n" +
	"\rdefault_value\x18\x02 \x01(\tR\fdefaultValue\x1aH\n" +
	"\rRequestHeader\x12\x12\n" +
	"\x04name\x18\x01 \x01(\tR\x04name\x12#\n" +
	"\rdefault_value\x18\x02 \x01(\tR\fdefaultValue\x1ae\n" +
	"\x0fCustomTagsEntry\x12\x10\n" +
	"\x03key\x18\x01 \x01(\tR\x03key\x12<\n" +
	"\x05value\x18\x02 \x01(\v2&.istio.mesh.v1alpha1.Tracing.CustomTagR\x05value:\x028\x01B\b\n" +
	"\x06tracer\"F\n" +
	"\x03SDS\x12\x18\n" +
	"\aenabled\x18\x01 \x01(\bR\aenabled\x12%\n" +
	"\x0fk8s_sa_jwt_path\x18\x02 \x01(\tR\fk8sSaJwtPath\"\xa7\x02\n" +
	"\bTopology\x12.\n" +
	"\x13num_trusted_proxies\x18\x01 \x01(\rR\x11numTrustedProxies\x12l\n" +
	"\x1bforward_client_cert_details\x18\x02 \x01(\x0e2-.istio.mesh.v1alpha1.ForwardClientCertDetailsR\x18forwardClientCertDetails\x12_\n" +
	"\x0eproxy_protocol\x18\x03 \x01(\v28.istio.mesh.v1alpha1.Topology.ProxyProtocolConfigurationR\rproxyProtocol\x1a\x1c\n" +
	"\x1aProxyProtocolConfiguration\"\xa8\x03\n" +
	"\x12PrivateKeyProvider\x12N\n" +
	"\bcryptomb\x18\x02 \x01(\v20.istio.mesh.v1alpha1.PrivateKeyProvider.CryptoMbH\x00R\bcryptomb\x12?\n" +
	"\x03qat\x18\x03 \x01(\v2+.istio.mesh.v1alpha1.PrivateKeyProvider.QATH\x00R\x03qat\x1a|\n" +
	"\bCryptoMb\x128\n" +
	"\n" +
	"poll_delay\x18\x01 \x01(\v2\x19.google.protobuf.DurationR\tpollDelay\x126\n" +
	"\bfallback\x18\x02 \x01(\v2\x1a.google.protobuf.BoolValueR\bfallback\x1aw\n" +
	"\x03QAT\x128\n" +
	"\n" +
	"poll_delay\x18\x01 \x01(\v2\x19.google.protobuf.DurationR\tpollDelay\x126\n" +
	"\bfallback\x18\x02 \x01(\v2\x1a.google.protobuf.BoolValueR\bfallbackB\n" +
	"\n" +
	"\bprovider\"\xeb'\n" +
	"\vProxyConfig\x12\x1f\n" +
	"\vconfig_path\x18\x01 \x01(\tR\n" +
	"configPath\x12\x1f\n" +
	"\vbinary_path\x18\x02 \x01(\tR\n" +
	"binaryPath\x12)\n" +
	"\x0fservice_cluster\x18\x03 \x01(\tH\x00R\x0eserviceCluster\x12g\n" +
	"\x14tracing_service_name\x18$ \x01(\x0e23.istio.mesh.v1alpha1.ProxyConfig.TracingServiceNameH\x00R\x12tracingServiceName\x12@\n" +
	"\x0edrain_duration\x18\x04 \x01(\v2\x19.google.protobuf.DurationR\rdrainDuration\x12+\n" +
	"\x11discovery_address\x18\x06 \x01(\tR\x10discoveryAddress\x12U\n" +
	"\x17discovery_refresh_delay\x18\a \x01(\v2\x19.google.protobuf.DurationB\x02\x18\x01R\x15discoveryRefreshDelay\x12)\n" +
	"\x0ezipkin_address\x18\b \x01(\tB\x02\x18\x01R\rzipkinAddress\x12,\n" +
	"\x12statsd_udp_address\x18\n" +
	" \x01(\tR\x10statsdUdpAddress\x12E\n" +
	"\x1denvoy_metrics_service_address\x18\x14 \x01(\tB\x02\x18\x01R\x1aenvoyMetricsServiceAddress\x12(\n" +
	"\x10proxy_admin_port\x18\v \x01(\x05R\x0eproxyAdminPort\x12/\n" +
	"\x11availability_zone\x18\f \x01(\tB\x02\x18\x01R\x10availabilityZone\x12d\n" +
	"\x19control_plane_auth_policy\x18\r \x01(\x0e2).istio.mesh.v1alpha1.AuthenticationPolicyR\x16controlPlaneAuthPolicy\x12,\n" +
	"\x12custom_config_file\x18\x0e \x01(\tR\x10customConfigFile\x12(\n" +
	"\x10stat_name_length\x18\x0f \x01(\x05R\x0estatNameLength\x12=\n" +
	"\vconcurrency\x18\x10 \x01(\v2\x1b.google.protobuf.Int32ValueR\vconcurrency\x12A\n" +
	"\x1dproxy_bootstrap_template_path\x18\x11 \x01(\tR\x1aproxyBootstrapTemplatePath\x12e\n" +
	"\x11interception_mode\x18\x12 \x01(\x0e28.istio.mesh.v1alpha1.ProxyConfig.InboundInterceptionModeR\x10interceptionMode\x126\n" +
	"\atracing\x18\x13 \x01(\v2\x1c.istio.mesh.v1alpha1.TracingR\atracing\x12.\n" +
	"\x03sds\x18\x15 \x01(\v2\x18.istio.mesh.v1alpha1.SDSB\x02\x18\x01R\x03sds\x12[\n" +
	"\x18envoy_access_log_service\x18\x16 \x01(\v2\".istio.mesh.v1alpha1.RemoteServiceR\x15envoyAccessLogService\x12V\n" +
	"\x15envoy_metrics_service\x18\x17 \x01(\v2\".istio.mesh.v1alpha1.RemoteServiceR\x13envoyMetricsService\x12Z\n" +
	"\x0eproxy_metadata\x18\x18 \x03(\v23.istio.mesh.v1alpha1.ProxyConfig.ProxyMetadataEntryR\rproxyMetadata\x12Z\n" +
	"\x0eruntime_values\x18% \x03(\v23.istio.mesh.v1alpha1.ProxyConfig.RuntimeValuesEntryR\rruntimeValues\x12\x1f\n" +
	"\vstatus_port\x18\x1a \x01(\x05R\n" +
	"statusPort\x12&\n" +
	"\x0fextra_stat_tags\x18\x1b \x03(\tR\rextraStatTags\x12H\n" +
	"\x10gateway_topology\x18\x1c \x01(\v2\x1d.istio.mesh.v1alpha1.TopologyR\x0fgatewayTopology\x12W\n" +
	"\x1atermination_drain_duration\x18\x1d \x01(\v2\x19.google.protobuf.DurationR\x18terminationDrainDuration\x12\x17\n" +
	"\amesh_id\x18\x1e \x01(\tR\x06meshId\x12R\n" +
	"\x0freadiness_probe\x18\x1f \x01(\v2).istio.networking.v1alpha3.ReadinessProbeR\x0ereadinessProbe\x12b\n" +
	"\x13proxy_stats_matcher\x18  \x01(\v22.istio.mesh.v1alpha1.ProxyConfig.ProxyStatsMatcherR\x11proxyStatsMatcher\x12h\n" +
	"#hold_application_until_proxy_starts\x18! \x01(\v2\x1a.google.protobuf.BoolValueR\x1fholdApplicationUntilProxyStarts\x12.\n" +
	"\x13ca_certificates_pem\x18\" \x03(\tR\x11caCertificatesPem\x12:\n" +
	"\x05image\x18# \x01(\v2$.istio.networking.v1beta1.ProxyImageR\x05image\x12Y\n" +
	"\x14private_key_provider\x18& \x01(\v2'.istio.mesh.v1alpha1.PrivateKeyProviderR\x12privateKeyProvider\x12R\n" +
	"\rproxy_headers\x18' \x01(\v2-.istio.mesh.v1alpha1.ProxyConfig.ProxyHeadersR\fproxyHeaders\x12I\n" +
	"\x13file_flush_interval\x18( \x01(\v2\x19.google.protobuf.DurationR\x11fileFlushInterval\x122\n" +
	"\x16file_flush_min_size_kb\x18) \x01(\rR\x12fileFlushMinSizeKb\x12G\n" +
	"\x11stats_compression\x18* \x01(\v2\x1a.google.protobuf.BoolValueR\x10statsCompression\x1a@\n" +
	"\x12ProxyMetadataEntry\x12\x10\n" +
	"\x03key\x18\x01 \x01(\tR\x03key\x12\x14\n" +
	"\x05value\x18\x02 \x01(\tR\x05value:\x028\x01\x1a@\n" +
	"\x12RuntimeValuesEntry\x12\x10\n" +
	"\x03key\x18\x01 \x01(\tR\x03key\x12\x14\n" +
	"\x05value\x18\x02 \x01(\tR\x05value:\x028\x01\x1a\x9e\x01\n" +
	"\x11ProxyStatsMatcher\x12-\n" +
	"\x12inclusion_prefixes\x18\x01 \x03(\tR\x11inclusionPrefixes\x12-\n" +
	"\x12inclusion_suffixes\x18\x02 \x03(\tR\x11inclusionSuffixes\x12+\n" +
	"\x11inclusion_regexps\x18\x03 \x03(\tR\x10inclusionRegexps\x1a\xa5\x0f\n" +
	"\fProxyHeaders\x12a\n" +
	"\x15forwarded_client_cert\x18\x01 \x01(\x0e2-.istio.mesh.v1alpha1.ForwardClientCertDetailsR\x13forwardedClientCert\x12\x8f\x01\n" +
	"\x1fset_current_client_cert_details\x18\a \x01(\v2I.istio.mesh.v1alpha1.ProxyConfig.ProxyHeaders.SetCurrentClientCertDetailsR\x1bsetCurrentClientCertDetails\x12V\n" +
	"\n" +
	"request_id\x18\x03 \x01(\v27.istio.mesh.v1alpha1.ProxyConfig.ProxyHeaders.RequestIdR\trequestId\x12L\n" +
	"\x06server\x18\x02 \x01(\v24.istio.mesh.v1alpha1.ProxyConfig.ProxyHeaders.ServerR\x06server\x12_\n" +
	"\rattempt_count\x18\x04 \x01(\v2:.istio.mesh.v1alpha1.ProxyConfig.ProxyHeaders.AttemptCountR\fattemptCount\x12o\n" +
	"\x13envoy_debug_headers\x18\x05 \x01(\v2?.istio.mesh.v1alpha1.ProxyConfig.ProxyHeaders.EnvoyDebugHeadersR\x11envoyDebugHeaders\x12\x81\x01\n" +
	"\x19metadata_exchange_headers\x18\x06 \x01(\v2E.istio.mesh.v1alpha1.ProxyConfig.ProxyHeaders.MetadataExchangeHeadersR\x17metadataExchangeHeaders\x12W\n" +
	"\x1apreserve_http1_header_case\x18( \x01(\v2\x1a.google.protobuf.BoolValueR\x17preserveHttp1HeaderCase\x12f\n" +
	"\x10x_forwarded_host\x18) \x01(\v2<.istio.mesh.v1alpha1.ProxyConfig.ProxyHeaders.XForwardedHostR\x0exForwardedHost\x12f\n" +
	"\x10x_forwarded_port\x18* \x01(\v2<.istio.mesh.v1alpha1.ProxyConfig.ProxyHeaders.XForwardedPortR\x0exForwardedPort\x1aV\n" +
	"\x06Server\x126\n" +
	"\bdisabled\x18\x01 \x01(\v2\x1a.google.protobuf.BoolValueR\bdisabled\x12\x14\n" +
	"\x05value\x18\x02 \x01(\tR\x05value\x1aC\n" +
	"\tRequestId\x126\n" +
	"\bdisabled\x18\x01 \x01(\v2\x1a.google.protobuf.BoolValueR\bdisabled\x1aF\n" +
	"\fAttemptCount\x126\n" +
	"\bdisabled\x18\x01 \x01(\v2\x1a.google.protobuf.BoolValueR\bdisabled\x1aF\n" +
	"\x0eXForwardedHost\x124\n" +
	"\aenabled\x18\x01 \x01(\v2\x1a.google.protobuf.BoolValueR\aenabled\x1aF\n" +
	"\x0eXForwardedPort\x124\n" +
	"\aenabled\x18\x01 \x01(\v2\x1a.google.protobuf.BoolValueR\aenabled\x1aK\n" +
	"\x11EnvoyDebugHeaders\x126\n" +
	"\bdisabled\x18\x01 \x01(\v2\x1a.google.protobuf.BoolValueR\bdisabled\x1aq\n" +
	"\x17MetadataExchangeHeaders\x12V\n" +
	"\x04mode\x18\x01 \x01(\x0e2B.istio.mesh.v1alpha1.ProxyConfig.ProxyHeaders.MetadataExchangeModeR\x04mode\x1a\x91\x02\n" +
	"\x1bSetCurrentClientCertDetails\x124\n" +
	"\asubject\x18\x01 \x01(\v2\x1a.google.protobuf.BoolValueR\asubject\x12.\n" +
	"\x04cert\x18\x02 \x01(\v2\x1a.google.protobuf.BoolValueR\x04cert\x120\n" +
	"\x05chain\x18\x03 \x01(\v2\x1a.google.protobuf.BoolValueR\x05chain\x12,\n" +
	"\x03dns\x18\x04 \x01(\v2\x1a.google.protobuf.BoolValueR\x03dns\x12,\n" +
	"\x03uri\x18\x05 \x01(\v2\x1a.google.protobuf.BoolValueR\x03uri\"2\n" +
	"\x14MetadataExchangeMode\x12\r\n" +
	"\tUNDEFINED\x10\x00\x12\v\n" +
	"\aIN_MESH\x10\x01\"l\n" +
	"\x12TracingServiceName\x12\x1b\n" +
	"\x17APP_LABEL_AND_NAMESPACE\x10\x00\x12\x17\n" +
	"\x13CANONICAL_NAME_ONLY\x10\x01\x12 \n" +
	"\x1cCANONICAL_NAME_AND_NAMESPACE\x10\x02\"=\n" +
	"\x17InboundInterceptionMode\x12\f\n" +
	"\bREDIRECT\x10\x00\x12\n" +
	"\n" +
	"\x06TPROXY\x10\x01\x12\b\n" +
	"\x04NONE\x10\x02B\x0e\n" +
	"\fcluster_nameJ\x04\b\x05\x10\x06J\x04\b\t\x10\n" +
	"R\x18parent_shutdown_durationR\x0fconnect_timeout\"\xeb\x01\n" +
	"\rRemoteService\x12\x18\n" +
	"\aaddress\x18\x01 \x01(\tR\aaddress\x12O\n" +
	"\ftls_settings\x18\x02 \x01(\v2,.istio.networking.v1alpha3.ClientTLSSettingsR\vtlsSettings\x12o\n" +
	"\rtcp_keepalive\x18\x03 \x01(\v2J.istio.networking.v1alpha3.ConnectionPoolSettings.TCPSettings.TcpKeepaliveR\ftcpKeepalive*>\n" +
	"\x14AuthenticationPolicy\x12\b\n" +
	"\x04NONE\x10\x00\x12\x0e\n" +
	"\n" +
	"MUTUAL_TLS\x10\x01\x12\f\n" +
	"\aINHERIT\x10\xe8\a*\x88\x01\n" +
	"\x18ForwardClientCertDetails\x12\r\n" +
	"\tUNDEFINED\x10\x00\x12\f\n" +
	"\bSANITIZE\x10\x01\x12\x10\n" +
	"\fFORWARD_ONLY\x10\x02\x12\x12\n" +
	"\x0eAPPEND_FORWARD\x10\x03\x12\x10\n" +
	"\fSANITIZE_SET\x10\x04\x12\x17\n" +
	"\x13ALWAYS_FORWARD_ONLY\x10\x05B\x1cZ\x1aistio.io/api/mesh/v1alpha1b\x06proto3"

var (
	file_mesh_v1alpha1_proxy_proto_rawDescOnce sync.Once
	file_mesh_v1alpha1_proxy_proto_rawDescData []byte
)

func file_mesh_v1alpha1_proxy_proto_rawDescGZIP() []byte {
	file_mesh_v1alpha1_proxy_proto_rawDescOnce.Do(func() {
		file_mesh_v1alpha1_proxy_proto_rawDescData = protoimpl.X.CompressGZIP(unsafe.Slice(unsafe.StringData(file_mesh_v1alpha1_proxy_proto_rawDesc), len(file_mesh_v1alpha1_proxy_proto_rawDesc)))
	})
	return file_mesh_v1alpha1_proxy_proto_rawDescData
}

var file_mesh_v1alpha1_proxy_proto_enumTypes = make([]protoimpl.EnumInfo, 6)
var file_mesh_v1alpha1_proxy_proto_msgTypes = make([]protoimpl.MessageInfo, 31)
var file_mesh_v1alpha1_proxy_proto_goTypes = []any{
	(AuthenticationPolicy)(0),                                        // 0: istio.mesh.v1alpha1.AuthenticationPolicy
	(ForwardClientCertDetails)(0),                                    // 1: istio.mesh.v1alpha1.ForwardClientCertDetails
	(Tracing_OpenCensusAgent_TraceContext)(0),                        // 2: istio.mesh.v1alpha1.Tracing.OpenCensusAgent.TraceContext
	(ProxyConfig_TracingServiceName)(0),                              // 3: istio.mesh.v1alpha1.ProxyConfig.TracingServiceName
	(ProxyConfig_InboundInterceptionMode)(0),                         // 4: istio.mesh.v1alpha1.ProxyConfig.InboundInterceptionMode
	(ProxyConfig_ProxyHeaders_MetadataExchangeMode)(0),               // 5: istio.mesh.v1alpha1.ProxyConfig.ProxyHeaders.MetadataExchangeMode
	(*Tracing)(nil),                                                  // 6: istio.mesh.v1alpha1.Tracing
	(*SDS)(nil),                                                      // 7: istio.mesh.v1alpha1.SDS
	(*Topology)(nil),                                                 // 8: istio.mesh.v1alpha1.Topology
	(*PrivateKeyProvider)(nil),                                       // 9: istio.mesh.v1alpha1.PrivateKeyProvider
	(*ProxyConfig)(nil),                                              // 10: istio.mesh.v1alpha1.ProxyConfig
	(*RemoteService)(nil),                                            // 11: istio.mesh.v1alpha1.RemoteService
	(*Tracing_Zipkin)(nil),                                           // 12: istio.mesh.v1alpha1.Tracing.Zipkin
	(*Tracing_Lightstep)(nil),                                        // 13: istio.mesh.v1alpha1.Tracing.Lightstep
	(*Tracing_Datadog)(nil),                                          // 14: istio.mesh.v1alpha1.Tracing.Datadog
	(*Tracing_Stackdriver)(nil),                                      // 15: istio.mesh.v1alpha1.Tracing.Stackdriver
	(*Tracing_OpenCensusAgent)(nil),                                  // 16: istio.mesh.v1alpha1.Tracing.OpenCensusAgent
	(*Tracing_CustomTag)(nil),                                        // 17: istio.mesh.v1alpha1.Tracing.CustomTag
	(*Tracing_Literal)(nil),                                          // 18: istio.mesh.v1alpha1.Tracing.Literal
	(*Tracing_Environment)(nil),                                      // 19: istio.mesh.v1alpha1.Tracing.Environment
	(*Tracing_RequestHeader)(nil),                                    // 20: istio.mesh.v1alpha1.Tracing.RequestHeader
	nil,                                                              // 21: istio.mesh.v1alpha1.Tracing.CustomTagsEntry
	(*Topology_ProxyProtocolConfiguration)(nil),                      // 22: istio.mesh.v1alpha1.Topology.ProxyProtocolConfiguration
	(*PrivateKeyProvider_CryptoMb)(nil),                              // 23: istio.mesh.v1alpha1.PrivateKeyProvider.CryptoMb
	(*PrivateKeyProvider_QAT)(nil),                                   // 24: istio.mesh.v1alpha1.PrivateKeyProvider.QAT
	nil,                                                              // 25: istio.mesh.v1alpha1.ProxyConfig.ProxyMetadataEntry
	nil,                                                              // 26: istio.mesh.v1alpha1.ProxyConfig.RuntimeValuesEntry
	(*ProxyConfig_ProxyStatsMatcher)(nil),                            // 27: istio.mesh.v1alpha1.ProxyConfig.ProxyStatsMatcher
	(*ProxyConfig_ProxyHeaders)(nil),                                 // 28: istio.mesh.v1alpha1.ProxyConfig.ProxyHeaders
	(*ProxyConfig_ProxyHeaders_Server)(nil),                          // 29: istio.mesh.v1alpha1.ProxyConfig.ProxyHeaders.Server
	(*ProxyConfig_ProxyHeaders_RequestId)(nil),                       // 30: istio.mesh.v1alpha1.ProxyConfig.ProxyHeaders.RequestId
	(*ProxyConfig_ProxyHeaders_AttemptCount)(nil),                    // 31: istio.mesh.v1alpha1.ProxyConfig.ProxyHeaders.AttemptCount
	(*ProxyConfig_ProxyHeaders_XForwardedHost)(nil),                  // 32: istio.mesh.v1alpha1.ProxyConfig.ProxyHeaders.XForwardedHost
	(*ProxyConfig_ProxyHeaders_XForwardedPort)(nil),                  // 33: istio.mesh.v1alpha1.ProxyConfig.ProxyHeaders.XForwardedPort
	(*ProxyConfig_ProxyHeaders_EnvoyDebugHeaders)(nil),               // 34: istio.mesh.v1alpha1.ProxyConfig.ProxyHeaders.EnvoyDebugHeaders
	(*ProxyConfig_ProxyHeaders_MetadataExchangeHeaders)(nil),         // 35: istio.mesh.v1alpha1.ProxyConfig.ProxyHeaders.MetadataExchangeHeaders
	(*ProxyConfig_ProxyHeaders_SetCurrentClientCertDetails)(nil),     // 36: istio.mesh.v1alpha1.ProxyConfig.ProxyHeaders.SetCurrentClientCertDetails
	(*v1alpha3.ClientTLSSettings)(nil),                               // 37: istio.networking.v1alpha3.ClientTLSSettings
	(*wrappers.BoolValue)(nil),                                       // 38: google.protobuf.BoolValue
	(*duration.Duration)(nil),                                        // 39: google.protobuf.Duration
	(*wrappers.Int32Value)(nil),                                      // 40: google.protobuf.Int32Value
	(*v1alpha3.ReadinessProbe)(nil),                                  // 41: istio.networking.v1alpha3.ReadinessProbe
	(*v1beta1.ProxyImage)(nil),                                       // 42: istio.networking.v1beta1.ProxyImage
	(*v1alpha3.ConnectionPoolSettings_TCPSettings_TcpKeepalive)(nil), // 43: istio.networking.v1alpha3.ConnectionPoolSettings.TCPSettings.TcpKeepalive
	(*wrappers.Int64Value)(nil),                                      // 44: google.protobuf.Int64Value
}
var file_mesh_v1alpha1_proxy_proto_depIdxs = []int32{
	12, // 0: istio.mesh.v1alpha1.Tracing.zipkin:type_name -> istio.mesh.v1alpha1.Tracing.Zipkin
	13, // 1: istio.mesh.v1alpha1.Tracing.lightstep:type_name -> istio.mesh.v1alpha1.Tracing.Lightstep
	14, // 2: istio.mesh.v1alpha1.Tracing.datadog:type_name -> istio.mesh.v1alpha1.Tracing.Datadog
	15, // 3: istio.mesh.v1alpha1.Tracing.stackdriver:type_name -> istio.mesh.v1alpha1.Tracing.Stackdriver
	16, // 4: istio.mesh.v1alpha1.Tracing.open_census_agent:type_name -> istio.mesh.v1alpha1.Tracing.OpenCensusAgent
	21, // 5: istio.mesh.v1alpha1.Tracing.custom_tags:type_name -> istio.mesh.v1alpha1.Tracing.CustomTagsEntry
	37, // 6: istio.mesh.v1alpha1.Tracing.tls_settings:type_name -> istio.networking.v1alpha3.ClientTLSSettings
	38, // 7: istio.mesh.v1alpha1.Tracing.enable_istio_tags:type_name -> google.protobuf.BoolValue
	1,  // 8: istio.mesh.v1alpha1.Topology.forward_client_cert_details:type_name -> istio.mesh.v1alpha1.ForwardClientCertDetails
	22, // 9: istio.mesh.v1alpha1.Topology.proxy_protocol:type_name -> istio.mesh.v1alpha1.Topology.ProxyProtocolConfiguration
	23, // 10: istio.mesh.v1alpha1.PrivateKeyProvider.cryptomb:type_name -> istio.mesh.v1alpha1.PrivateKeyProvider.CryptoMb
	24, // 11: istio.mesh.v1alpha1.PrivateKeyProvider.qat:type_name -> istio.mesh.v1alpha1.PrivateKeyProvider.QAT
	3,  // 12: istio.mesh.v1alpha1.ProxyConfig.tracing_service_name:type_name -> istio.mesh.v1alpha1.ProxyConfig.TracingServiceName
	39, // 13: istio.mesh.v1alpha1.ProxyConfig.drain_duration:type_name -> google.protobuf.Duration
	39, // 14: istio.mesh.v1alpha1.ProxyConfig.discovery_refresh_delay:type_name -> google.protobuf.Duration
	0,  // 15: istio.mesh.v1alpha1.ProxyConfig.control_plane_auth_policy:type_name -> istio.mesh.v1alpha1.AuthenticationPolicy
	40, // 16: istio.mesh.v1alpha1.ProxyConfig.concurrency:type_name -> google.protobuf.Int32Value
	4,  // 17: istio.mesh.v1alpha1.ProxyConfig.interception_mode:type_name -> istio.mesh.v1alpha1.ProxyConfig.InboundInterceptionMode
	6,  // 18: istio.mesh.v1alpha1.ProxyConfig.tracing:type_name -> istio.mesh.v1alpha1.Tracing
	7,  // 19: istio.mesh.v1alpha1.ProxyConfig.sds:type_name -> istio.mesh.v1alpha1.SDS
	11, // 20: istio.mesh.v1alpha1.ProxyConfig.envoy_access_log_service:type_name -> istio.mesh.v1alpha1.RemoteService
	11, // 21: istio.mesh.v1alpha1.ProxyConfig.envoy_metrics_service:type_name -> istio.mesh.v1alpha1.RemoteService
	25, // 22: istio.mesh.v1alpha1.ProxyConfig.proxy_metadata:type_name -> istio.mesh.v1alpha1.ProxyConfig.ProxyMetadataEntry
	26, // 23: istio.mesh.v1alpha1.ProxyConfig.runtime_values:type_name -> istio.mesh.v1alpha1.ProxyConfig.RuntimeValuesEntry
	8,  // 24: istio.mesh.v1alpha1.ProxyConfig.gateway_topology:type_name -> istio.mesh.v1alpha1.Topology
	39, // 25: istio.mesh.v1alpha1.ProxyConfig.termination_drain_duration:type_name -> google.protobuf.Duration
	41, // 26: istio.mesh.v1alpha1.ProxyConfig.readiness_probe:type_name -> istio.networking.v1alpha3.ReadinessProbe
	27, // 27: istio.mesh.v1alpha1.ProxyConfig.proxy_stats_matcher:type_name -> istio.mesh.v1alpha1.ProxyConfig.ProxyStatsMatcher
	38, // 28: istio.mesh.v1alpha1.ProxyConfig.hold_application_until_proxy_starts:type_name -> google.protobuf.BoolValue
	42, // 29: istio.mesh.v1alpha1.ProxyConfig.image:type_name -> istio.networking.v1beta1.ProxyImage
	9,  // 30: istio.mesh.v1alpha1.ProxyConfig.private_key_provider:type_name -> istio.mesh.v1alpha1.PrivateKeyProvider
	28, // 31: istio.mesh.v1alpha1.ProxyConfig.proxy_headers:type_name -> istio.mesh.v1alpha1.ProxyConfig.ProxyHeaders
	39, // 32: istio.mesh.v1alpha1.ProxyConfig.file_flush_interval:type_name -> google.protobuf.Duration
	38, // 33: istio.mesh.v1alpha1.ProxyConfig.stats_compression:type_name -> google.protobuf.BoolValue
	37, // 34: istio.mesh.v1alpha1.RemoteService.tls_settings:type_name -> istio.networking.v1alpha3.ClientTLSSettings
	43, // 35: istio.mesh.v1alpha1.RemoteService.tcp_keepalive:type_name -> istio.networking.v1alpha3.ConnectionPoolSettings.TCPSettings.TcpKeepalive
	44, // 36: istio.mesh.v1alpha1.Tracing.Stackdriver.max_number_of_attributes:type_name -> google.protobuf.Int64Value
	44, // 37: istio.mesh.v1alpha1.Tracing.Stackdriver.max_number_of_annotations:type_name -> google.protobuf.Int64Value
	44, // 38: istio.mesh.v1alpha1.Tracing.Stackdriver.max_number_of_message_events:type_name -> google.protobuf.Int64Value
	2,  // 39: istio.mesh.v1alpha1.Tracing.OpenCensusAgent.context:type_name -> istio.mesh.v1alpha1.Tracing.OpenCensusAgent.TraceContext
	18, // 40: istio.mesh.v1alpha1.Tracing.CustomTag.literal:type_name -> istio.mesh.v1alpha1.Tracing.Literal
	19, // 41: istio.mesh.v1alpha1.Tracing.CustomTag.environment:type_name -> istio.mesh.v1alpha1.Tracing.Environment
	20, // 42: istio.mesh.v1alpha1.Tracing.CustomTag.header:type_name -> istio.mesh.v1alpha1.Tracing.RequestHeader
	17, // 43: istio.mesh.v1alpha1.Tracing.CustomTagsEntry.value:type_name -> istio.mesh.v1alpha1.Tracing.CustomTag
	39, // 44: istio.mesh.v1alpha1.PrivateKeyProvider.CryptoMb.poll_delay:type_name -> google.protobuf.Duration
	38, // 45: istio.mesh.v1alpha1.PrivateKeyProvider.CryptoMb.fallback:type_name -> google.protobuf.BoolValue
	39, // 46: istio.mesh.v1alpha1.PrivateKeyProvider.QAT.poll_delay:type_name -> google.protobuf.Duration
	38, // 47: istio.mesh.v1alpha1.PrivateKeyProvider.QAT.fallback:type_name -> google.protobuf.BoolValue
	1,  // 48: istio.mesh.v1alpha1.ProxyConfig.ProxyHeaders.forwarded_client_cert:type_name -> istio.mesh.v1alpha1.ForwardClientCertDetails
	36, // 49: istio.mesh.v1alpha1.ProxyConfig.ProxyHeaders.set_current_client_cert_details:type_name -> istio.mesh.v1alpha1.ProxyConfig.ProxyHeaders.SetCurrentClientCertDetails
	30, // 50: istio.mesh.v1alpha1.ProxyConfig.ProxyHeaders.request_id:type_name -> istio.mesh.v1alpha1.ProxyConfig.ProxyHeaders.RequestId
	29, // 51: istio.mesh.v1alpha1.ProxyConfig.ProxyHeaders.server:type_name -> istio.mesh.v1alpha1.ProxyConfig.ProxyHeaders.Server
	31, // 52: istio.mesh.v1alpha1.ProxyConfig.ProxyHeaders.attempt_count:type_name -> istio.mesh.v1alpha1.ProxyConfig.ProxyHeaders.AttemptCount
	34, // 53: istio.mesh.v1alpha1.ProxyConfig.ProxyHeaders.envoy_debug_headers:type_name -> istio.mesh.v1alpha1.ProxyConfig.ProxyHeaders.EnvoyDebugHeaders
	35, // 54: istio.mesh.v1alpha1.ProxyConfig.ProxyHeaders.metadata_exchange_headers:type_name -> istio.mesh.v1alpha1.ProxyConfig.ProxyHeaders.MetadataExchangeHeaders
	38, // 55: istio.mesh.v1alpha1.ProxyConfig.ProxyHeaders.preserve_http1_header_case:type_name -> google.protobuf.BoolValue
	32, // 56: istio.mesh.v1alpha1.ProxyConfig.ProxyHeaders.x_forwarded_host:type_name -> istio.mesh.v1alpha1.ProxyConfig.ProxyHeaders.XForwardedHost
	33, // 57: istio.mesh.v1alpha1.ProxyConfig.ProxyHeaders.x_forwarded_port:type_name -> istio.mesh.v1alpha1.ProxyConfig.ProxyHeaders.XForwardedPort
	38, // 58: istio.mesh.v1alpha1.ProxyConfig.ProxyHeaders.Server.disabled:type_name -> google.protobuf.BoolValue
	38, // 59: istio.mesh.v1alpha1.ProxyConfig.ProxyHeaders.RequestId.disabled:type_name -> google.protobuf.BoolValue
	38, // 60: istio.mesh.v1alpha1.ProxyConfig.ProxyHeaders.AttemptCount.disabled:type_name -> google.protobuf.BoolValue
	38, // 61: istio.mesh.v1alpha1.ProxyConfig.ProxyHeaders.XForwardedHost.enabled:type_name -> google.protobuf.BoolValue
	38, // 62: istio.mesh.v1alpha1.ProxyConfig.ProxyHeaders.XForwardedPort.enabled:type_name -> google.protobuf.BoolValue
	38, // 63: istio.mesh.v1alpha1.ProxyConfig.ProxyHeaders.EnvoyDebugHeaders.disabled:type_name -> google.protobuf.BoolValue
	5,  // 64: istio.mesh.v1alpha1.ProxyConfig.ProxyHeaders.MetadataExchangeHeaders.mode:type_name -> istio.mesh.v1alpha1.ProxyConfig.ProxyHeaders.MetadataExchangeMode
	38, // 65: istio.mesh.v1alpha1.ProxyConfig.ProxyHeaders.SetCurrentClientCertDetails.subject:type_name -> google.protobuf.BoolValue
	38, // 66: istio.mesh.v1alpha1.ProxyConfig.ProxyHeaders.SetCurrentClientCertDetails.cert:type_name -> google.protobuf.BoolValue
	38, // 67: istio.mesh.v1alpha1.ProxyConfig.ProxyHeaders.SetCurrentClientCertDetails.chain:type_name -> google.protobuf.BoolValue
	38, // 68: istio.mesh.v1alpha1.ProxyConfig.ProxyHeaders.SetCurrentClientCertDetails.dns:type_name -> google.protobuf.BoolValue
	38, // 69: istio.mesh.v1alpha1.ProxyConfig.ProxyHeaders.SetCurrentClientCertDetails.uri:type_name -> google.protobuf.BoolValue
	70, // [70:70] is the sub-list for method output_type
	70, // [70:70] is the sub-list for method input_type
	70, // [70:70] is the sub-list for extension type_name
	70, // [70:70] is the sub-list for extension extendee
	0,  // [0:70] is the sub-list for field type_name
}

func init() { file_mesh_v1alpha1_proxy_proto_init() }
func file_mesh_v1alpha1_proxy_proto_init() {
	if File_mesh_v1alpha1_proxy_proto != nil {
		return
	}
	file_mesh_v1alpha1_proxy_proto_msgTypes[0].OneofWrappers = []any{
		(*Tracing_Zipkin_)(nil),
		(*Tracing_Lightstep_)(nil),
		(*Tracing_Datadog_)(nil),
		(*Tracing_Stackdriver_)(nil),
		(*Tracing_OpenCensusAgent_)(nil),
	}
	file_mesh_v1alpha1_proxy_proto_msgTypes[3].OneofWrappers = []any{
		(*PrivateKeyProvider_Cryptomb)(nil),
		(*PrivateKeyProvider_Qat)(nil),
	}
	file_mesh_v1alpha1_proxy_proto_msgTypes[4].OneofWrappers = []any{
		(*ProxyConfig_ServiceCluster)(nil),
		(*ProxyConfig_TracingServiceName_)(nil),
	}
	file_mesh_v1alpha1_proxy_proto_msgTypes[11].OneofWrappers = []any{
		(*Tracing_CustomTag_Literal)(nil),
		(*Tracing_CustomTag_Environment)(nil),
		(*Tracing_CustomTag_Header)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: unsafe.Slice(unsafe.StringData(file_mesh_v1alpha1_proxy_proto_rawDesc), len(file_mesh_v1alpha1_proxy_proto_rawDesc)),
			NumEnums:      6,
			NumMessages:   31,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_mesh_v1alpha1_proxy_proto_goTypes,
		DependencyIndexes: file_mesh_v1alpha1_proxy_proto_depIdxs,
		EnumInfos:         file_mesh_v1alpha1_proxy_proto_enumTypes,
		MessageInfos:      file_mesh_v1alpha1_proxy_proto_msgTypes,
	}.Build()
	File_mesh_v1alpha1_proxy_proto = out.File
	file_mesh_v1alpha1_proxy_proto_goTypes = nil
	file_mesh_v1alpha1_proxy_proto_depIdxs = nil
}
