// SPDX-License-Identifier: GPL-2.0-or-later
// SPDX-FileCopyrightText: 2025 Konrad Twardowski

#pragma once

#include <QHBoxLayout>
#include <QLabel>
#include <QLineEdit>
#include <QPushButton>
#include <QStyle>

class UCommandEdit final: public QWidget {
public:
	explicit UCommandEdit();
	QString command() { return m_commandEdit->text().trimmed(); }
	void setCommand(const QString &value) { m_commandEdit->setText(value); }
	void setCommandFocus() { m_commandEdit->setFocus(); }
	void setCompleter(const QList<QString> &commands);
	void setExample(const QString &value);
	void setLabel(const QString &value) { m_commandLabel->setText(value); }
private:
	Q_DISABLE_COPY(UCommandEdit)
	QLabel *m_commandLabel;
	QLineEdit *m_commandEdit;
	void testCommand();
};

// NOTE: moved from ulabel.h
class ULabel final: public QFrame {
public:
	explicit ULabel(QWidget *parent = nullptr);
	QLabel *iconLabel() { return m_iconLabel; }
	QLabel *textLabel() { return m_textLabel; }
	QHBoxLayout *labelLayout();
	void setIcon(const QIcon &value, const int size);
	void setIcon(const QString &iconName, const int size);
	void setIcon(const QStyle::StandardPixmap standardIcon, const int size);
	void setText(const QString &value);
	void setMarginAndSpacing(const int margin, const int spacing);
private:
	Q_DISABLE_COPY(ULabel)
	QLabel *m_iconLabel;
	QLabel *m_textLabel;
};

class UWidgets final {
public:
	inline static const int STYLE_MARGIN  = -1;
	inline static const int STYLE_SPACING = -1;

	inline static const QString CELL_HEADER = "<x-kshutdown-cell-header>";
	inline static const QString CELL_HTML   = "<x-kshutdown-cell-html>";

	static QIcon emptyIcon(const QSize &size);
	static bool isIconThemeSupported();

	[[nodiscard]] static QString makeHTMLTable(QTextEdit *widget, const QList<QStringList> &rows);

	static QHBoxLayout *newHBoxLayout(QWidget *parent, const QList<QObject *> &list, const int spacing, const int margin = 0_px);
	[[nodiscard]] static QHBoxLayout *newHBoxLayout(const QList<QObject *> &list, const int spacing, const int margin = 0_px) {
		return newHBoxLayout(nullptr, list, spacing, margin);
	}

	static QVBoxLayout *newVBoxLayout(QWidget *parent, const QList<QObject *> &list, const int spacing, const int margin = 0_px);
	[[nodiscard]] static QVBoxLayout *newVBoxLayout(const QList<QObject *> &list, const int spacing, const int margin = 0_px) {
		return newVBoxLayout(nullptr, list, spacing, margin);
	}

	[[nodiscard]] static QTextEdit *newHTMLTableView(const QList<QStringList> &rows);
	[[nodiscard]] static QAction *newLinkAction(const QString &text, const QString &url);
	[[nodiscard]] static QPushButton *newLinkButton(const QString &text, const QString &url);
private:
	static void initBoxLayout(QBoxLayout *layout, const QList<QObject *> &list, const int spacing, const int margin);
};
