/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by client-gen. DO NOT EDIT.

package fake

import (
	v1alpha1 "k8s.io/api/rbac/v1alpha1"
	rbacv1alpha1 "k8s.io/client-go/applyconfigurations/rbac/v1alpha1"
	gentype "k8s.io/client-go/gentype"
	typedrbacv1alpha1 "k8s.io/client-go/kubernetes/typed/rbac/v1alpha1"
)

// fakeRoleBindings implements RoleBindingInterface
type fakeRoleBindings struct {
	*gentype.FakeClientWithListAndApply[*v1alpha1.RoleBinding, *v1alpha1.RoleBindingList, *rbacv1alpha1.RoleBindingApplyConfiguration]
	Fake *FakeRbacV1alpha1
}

func newFakeRoleBindings(fake *FakeRbacV1alpha1, namespace string) typedrbacv1alpha1.RoleBindingInterface {
	return &fakeRoleBindings{
		gentype.NewFakeClientWithListAndApply[*v1alpha1.RoleBinding, *v1alpha1.RoleBindingList, *rbacv1alpha1.RoleBindingApplyConfiguration](
			fake.Fake,
			namespace,
			v1alpha1.SchemeGroupVersion.WithResource("rolebindings"),
			v1alpha1.SchemeGroupVersion.WithKind("RoleBinding"),
			func() *v1alpha1.RoleBinding { return &v1alpha1.RoleBinding{} },
			func() *v1alpha1.RoleBindingList { return &v1alpha1.RoleBindingList{} },
			func(dst, src *v1alpha1.RoleBindingList) { dst.ListMeta = src.ListMeta },
			func(list *v1alpha1.RoleBindingList) []*v1alpha1.RoleBinding {
				return gentype.ToPointerSlice(list.Items)
			},
			func(list *v1alpha1.RoleBindingList, items []*v1alpha1.RoleBinding) {
				list.Items = gentype.FromPointerSlice(items)
			},
		),
		fake,
	}
}
