#ifndef SBK_KVIEWSTATESERIALIZERWRAPPER_H
#define SBK_KVIEWSTATESERIALIZERWRAPPER_H

// Workaround to access protected functions
#ifndef protected
#  define protected public
#endif

#include <kviewstateserializer.h>

#include <sbkpython.h>

#include <array>
namespace Shiboken { struct AutoDecRef; class GilState; }

namespace PySide { class DynamicQMetaObject; }

class KViewStateSerializerWrapper : public KViewStateSerializer
{
public:
    KViewStateSerializerWrapper(::QObject * parent = nullptr);
    KViewStateSerializerWrapper(const KViewStateSerializerWrapper &) = delete;
    KViewStateSerializerWrapper& operator=(const KViewStateSerializerWrapper &) = delete;
    KViewStateSerializerWrapper(KViewStateSerializerWrapper &&) = delete;
    KViewStateSerializerWrapper& operator=(KViewStateSerializerWrapper &&) = delete;
    ~KViewStateSerializerWrapper() override;

    void childEvent(::QChildEvent * event) override;
    void connectNotify(const ::QMetaMethod & signal) override;
    void customEvent(::QEvent * event) override;
    void disconnectNotify(const ::QMetaMethod & signal) override;
    bool event(::QEvent * event) override;
    bool eventFilter(::QObject * watched, ::QEvent * event) override;
    ::QModelIndex indexFromConfigString(const ::QAbstractItemModel * model, const ::QString & key) const override;
    static ::QModelIndex sbk_o_indexFromConfigString(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, const ::QAbstractItemModel * model, const ::QString & key);
    ::QString indexToConfigString(const ::QModelIndex & index) const override;
    static ::QString sbk_o_indexToConfigString(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, const ::QModelIndex & index);
    void timerEvent(::QTimerEvent * event) override;

    const ::QMetaObject * metaObject() const override;
    int qt_metacall(QMetaObject::Call call, int id, void **args) override;
    void *qt_metacast(const char *_clname) override;
    static void pysideInitQtMetaTypes();

    void resetPyMethodCache();

private:
    mutable std::array<PyObject *, 9> m_PyMethodCache = {nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr};
};

#endif // SBK_KVIEWSTATESERIALIZERWRAPPER_H
