/* A Bison parser, made by GNU Bison 3.8.2.  */

/* Bison implementation for Yacc-like parsers in C

   Copyright (C) 1984, 1989-1990, 2000-2015, 2018-2021 Free Software Foundation,
   Inc.

   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <https://www.gnu.org/licenses/>.  */

/* As a special exception, you may create a larger work that contains
   part or all of the Bison parser skeleton and distribute that work
   under terms of your choice, so long as that work isn't itself a
   parser generator using the skeleton or a modified version thereof
   as a parser skeleton.  Alternatively, if you modify or redistribute
   the parser skeleton itself, you may (at your option) remove this
   special exception, which will cause the skeleton and the resulting
   Bison output files to be licensed under the GNU General Public
   License without this special exception.

   This special exception was added by the Free Software Foundation in
   version 2.2 of Bison.  */

/* C LALR(1) parser skeleton written by Richard Stallman, by
   simplifying the original so-called "semantic" parser.  */

/* DO NOT RELY ON FEATURES THAT ARE NOT DOCUMENTED in the manual,
   especially those whose name start with YY_ or yy_.  They are
   private implementation details that can be changed or removed.  */

/* All symbols defined below should begin with yy or YY, to avoid
   infringing on user name space.  This should be done even for local
   variables, as they might otherwise be expanded by user macros.
   There are some unavoidable exceptions within include files to
   define necessary library symbols; they are noted "INFRINGES ON
   USER NAME SPACE" below.  */

/* Identify Bison output, and Bison version.  */
#define YYBISON 30802

/* Bison version string.  */
#define YYBISON_VERSION "3.8.2"

/* Skeleton name.  */
#define YYSKELETON_NAME "yacc.c"

/* Pure parsers.  */
#define YYPURE 1

/* Push parsers.  */
#define YYPUSH 0

/* Pull parsers.  */
#define YYPULL 1




/* First part of user prologue.  */
#line 15 "/build/libreoffice-still/src/libreoffice-25.8.5.2/unoidl/source/sourceprovider-parser.y"


#include <sal/config.h>

#include <o3tl/unreachable.hxx>
#include <o3tl/string_view.hxx>
#include <rtl/ustrbuf.hxx>
#include <unoidl/unoidl.hxx>

#include <algorithm>
#include <cassert>
#include <cerrno>
#include <cstddef>
#include <cstdlib>
#include <limits>
#include <new>
#include <utility>
#include <vector>

#include "sourceprovider-parser-requires.hxx"


#line 94 "/build/libreoffice-still/src/libreoffice-25.8.5.2/workdir/YaccTarget/unoidl/source/sourceprovider-parser.cxx"

# ifndef YY_CAST
#  ifdef __cplusplus
#   define YY_CAST(Type, Val) static_cast<Type> (Val)
#   define YY_REINTERPRET_CAST(Type, Val) reinterpret_cast<Type> (Val)
#  else
#   define YY_CAST(Type, Val) ((Type) (Val))
#   define YY_REINTERPRET_CAST(Type, Val) ((Type) (Val))
#  endif
# endif
# ifndef YY_NULLPTR
#  if defined __cplusplus
#   if 201103L <= __cplusplus
#    define YY_NULLPTR nullptr
#   else
#    define YY_NULLPTR 0
#   endif
#  else
#   define YY_NULLPTR ((void*)0)
#  endif
# endif

#include "sourceprovider-parser.hxx"
/* Symbol kind.  */
enum yysymbol_kind_t
{
  YYSYMBOL_YYEMPTY = -2,
  YYSYMBOL_YYEOF = 0,                      /* "end of file"  */
  YYSYMBOL_YYerror = 1,                    /* error  */
  YYSYMBOL_YYUNDEF = 2,                    /* "invalid token"  */
  YYSYMBOL_TOK_ELLIPSIS = 3,               /* TOK_ELLIPSIS  */
  YYSYMBOL_TOK_COLONS = 4,                 /* TOK_COLONS  */
  YYSYMBOL_TOK_LEFTSHIFT = 5,              /* TOK_LEFTSHIFT  */
  YYSYMBOL_TOK_RIGHTSHIFT = 6,             /* TOK_RIGHTSHIFT  */
  YYSYMBOL_TOK_FALSE = 7,                  /* TOK_FALSE  */
  YYSYMBOL_TOK_TRUE = 8,                   /* TOK_TRUE  */
  YYSYMBOL_TOK_ANY = 9,                    /* TOK_ANY  */
  YYSYMBOL_TOK_ATTRIBUTE = 10,             /* TOK_ATTRIBUTE  */
  YYSYMBOL_TOK_BOOLEAN = 11,               /* TOK_BOOLEAN  */
  YYSYMBOL_TOK_BOUND = 12,                 /* TOK_BOUND  */
  YYSYMBOL_TOK_BYTE = 13,                  /* TOK_BYTE  */
  YYSYMBOL_TOK_CHAR = 14,                  /* TOK_CHAR  */
  YYSYMBOL_TOK_CONST = 15,                 /* TOK_CONST  */
  YYSYMBOL_TOK_CONSTANTS = 16,             /* TOK_CONSTANTS  */
  YYSYMBOL_TOK_CONSTRAINED = 17,           /* TOK_CONSTRAINED  */
  YYSYMBOL_TOK_DOUBLE = 18,                /* TOK_DOUBLE  */
  YYSYMBOL_TOK_ENUM = 19,                  /* TOK_ENUM  */
  YYSYMBOL_TOK_EXCEPTION = 20,             /* TOK_EXCEPTION  */
  YYSYMBOL_TOK_FLOAT = 21,                 /* TOK_FLOAT  */
  YYSYMBOL_TOK_GET = 22,                   /* TOK_GET  */
  YYSYMBOL_TOK_HYPER = 23,                 /* TOK_HYPER  */
  YYSYMBOL_TOK_IN = 24,                    /* TOK_IN  */
  YYSYMBOL_TOK_INOUT = 25,                 /* TOK_INOUT  */
  YYSYMBOL_TOK_INTERFACE = 26,             /* TOK_INTERFACE  */
  YYSYMBOL_TOK_LONG = 27,                  /* TOK_LONG  */
  YYSYMBOL_TOK_MAYBEAMBIGUOUS = 28,        /* TOK_MAYBEAMBIGUOUS  */
  YYSYMBOL_TOK_MAYBEDEFAULT = 29,          /* TOK_MAYBEDEFAULT  */
  YYSYMBOL_TOK_MAYBEVOID = 30,             /* TOK_MAYBEVOID  */
  YYSYMBOL_TOK_MODULE = 31,                /* TOK_MODULE  */
  YYSYMBOL_TOK_OPTIONAL = 32,              /* TOK_OPTIONAL  */
  YYSYMBOL_TOK_OUT = 33,                   /* TOK_OUT  */
  YYSYMBOL_TOK_PROPERTY = 34,              /* TOK_PROPERTY  */
  YYSYMBOL_TOK_PUBLISHED = 35,             /* TOK_PUBLISHED  */
  YYSYMBOL_TOK_RAISES = 36,                /* TOK_RAISES  */
  YYSYMBOL_TOK_READONLY = 37,              /* TOK_READONLY  */
  YYSYMBOL_TOK_REMOVABLE = 38,             /* TOK_REMOVABLE  */
  YYSYMBOL_TOK_SEQUENCE = 39,              /* TOK_SEQUENCE  */
  YYSYMBOL_TOK_SERVICE = 40,               /* TOK_SERVICE  */
  YYSYMBOL_TOK_SET = 41,                   /* TOK_SET  */
  YYSYMBOL_TOK_SHORT = 42,                 /* TOK_SHORT  */
  YYSYMBOL_TOK_SINGLETON = 43,             /* TOK_SINGLETON  */
  YYSYMBOL_TOK_STRING = 44,                /* TOK_STRING  */
  YYSYMBOL_TOK_STRUCT = 45,                /* TOK_STRUCT  */
  YYSYMBOL_TOK_TRANSIENT = 46,             /* TOK_TRANSIENT  */
  YYSYMBOL_TOK_TYPE = 47,                  /* TOK_TYPE  */
  YYSYMBOL_TOK_TYPEDEF = 48,               /* TOK_TYPEDEF  */
  YYSYMBOL_TOK_UNSIGNED = 49,              /* TOK_UNSIGNED  */
  YYSYMBOL_TOK_VOID = 50,                  /* TOK_VOID  */
  YYSYMBOL_TOK_IDENTIFIER = 51,            /* TOK_IDENTIFIER  */
  YYSYMBOL_TOK_INTEGER = 52,               /* TOK_INTEGER  */
  YYSYMBOL_TOK_FLOATING = 53,              /* TOK_FLOATING  */
  YYSYMBOL_TOK_DEPRECATED = 54,            /* TOK_DEPRECATED  */
  YYSYMBOL_TOK_ERROR = 55,                 /* TOK_ERROR  */
  YYSYMBOL_56_ = 56,                       /* '{'  */
  YYSYMBOL_57_ = 57,                       /* '}'  */
  YYSYMBOL_58_ = 58,                       /* ';'  */
  YYSYMBOL_59_ = 59,                       /* ','  */
  YYSYMBOL_60_ = 60,                       /* '='  */
  YYSYMBOL_61_ = 61,                       /* '<'  */
  YYSYMBOL_62_ = 62,                       /* '>'  */
  YYSYMBOL_63_ = 63,                       /* '('  */
  YYSYMBOL_64_ = 64,                       /* ')'  */
  YYSYMBOL_65_ = 65,                       /* '['  */
  YYSYMBOL_66_ = 66,                       /* ']'  */
  YYSYMBOL_67_ = 67,                       /* ':'  */
  YYSYMBOL_68_ = 68,                       /* '|'  */
  YYSYMBOL_69_ = 69,                       /* '^'  */
  YYSYMBOL_70_ = 70,                       /* '&'  */
  YYSYMBOL_71_ = 71,                       /* '+'  */
  YYSYMBOL_72_ = 72,                       /* '-'  */
  YYSYMBOL_73_ = 73,                       /* '*'  */
  YYSYMBOL_74_ = 74,                       /* '/'  */
  YYSYMBOL_75_ = 75,                       /* '%'  */
  YYSYMBOL_76_ = 76,                       /* '~'  */
  YYSYMBOL_YYACCEPT = 77,                  /* $accept  */
  YYSYMBOL_definitions = 78,               /* definitions  */
  YYSYMBOL_definition = 79,                /* definition  */
  YYSYMBOL_moduleDecl = 80,                /* moduleDecl  */
  YYSYMBOL_81_1 = 81,                      /* $@1  */
  YYSYMBOL_enumDefn = 82,                  /* enumDefn  */
  YYSYMBOL_83_2 = 83,                      /* $@2  */
  YYSYMBOL_enumMembers = 84,               /* enumMembers  */
  YYSYMBOL_enumMember = 85,                /* enumMember  */
  YYSYMBOL_plainStructDefn = 86,           /* plainStructDefn  */
  YYSYMBOL_87_3 = 87,                      /* $@3  */
  YYSYMBOL_polymorphicStructTemplateDefn = 88, /* polymorphicStructTemplateDefn  */
  YYSYMBOL_89_4 = 89,                      /* $@4  */
  YYSYMBOL_typeParameters = 90,            /* typeParameters  */
  YYSYMBOL_exceptionDefn = 91,             /* exceptionDefn  */
  YYSYMBOL_92_5 = 92,                      /* $@5  */
  YYSYMBOL_structMembers = 93,             /* structMembers  */
  YYSYMBOL_structMember = 94,              /* structMember  */
  YYSYMBOL_interfaceDefn = 95,             /* interfaceDefn  */
  YYSYMBOL_96_6 = 96,                      /* $@6  */
  YYSYMBOL_interfaceMembers = 97,          /* interfaceMembers  */
  YYSYMBOL_interfaceMember = 98,           /* interfaceMember  */
  YYSYMBOL_interfaceBase = 99,             /* interfaceBase  */
  YYSYMBOL_interfaceAttribute = 100,       /* interfaceAttribute  */
  YYSYMBOL_101_7 = 101,                    /* $@7  */
  YYSYMBOL_attributeAccessDecls_opt = 102, /* attributeAccessDecls_opt  */
  YYSYMBOL_attributeAccessDecls = 103,     /* attributeAccessDecls  */
  YYSYMBOL_attributeAccessDecl = 104,      /* attributeAccessDecl  */
  YYSYMBOL_interfaceMethod = 105,          /* interfaceMethod  */
  YYSYMBOL_106_8 = 106,                    /* $@8  */
  YYSYMBOL_methodParams_opt = 107,         /* methodParams_opt  */
  YYSYMBOL_methodParams = 108,             /* methodParams  */
  YYSYMBOL_methodParam = 109,              /* methodParam  */
  YYSYMBOL_direction = 110,                /* direction  */
  YYSYMBOL_typedefDefn = 111,              /* typedefDefn  */
  YYSYMBOL_constantGroupDefn = 112,        /* constantGroupDefn  */
  YYSYMBOL_113_9 = 113,                    /* $@9  */
  YYSYMBOL_constants = 114,                /* constants  */
  YYSYMBOL_constant = 115,                 /* constant  */
  YYSYMBOL_singleInterfaceBasedServiceDefn = 116, /* singleInterfaceBasedServiceDefn  */
  YYSYMBOL_117_10 = 117,                   /* $@10  */
  YYSYMBOL_ctors_opt = 118,                /* ctors_opt  */
  YYSYMBOL_ctors = 119,                    /* ctors  */
  YYSYMBOL_ctor = 120,                     /* ctor  */
  YYSYMBOL_121_11 = 121,                   /* $@11  */
  YYSYMBOL_ctorParams_opt = 122,           /* ctorParams_opt  */
  YYSYMBOL_ctorParams = 123,               /* ctorParams  */
  YYSYMBOL_ctorParam = 124,                /* ctorParam  */
  YYSYMBOL_ellipsis_opt = 125,             /* ellipsis_opt  */
  YYSYMBOL_accumulationBasedServiceDefn = 126, /* accumulationBasedServiceDefn  */
  YYSYMBOL_127_12 = 127,                   /* $@12  */
  YYSYMBOL_serviceMembers = 128,           /* serviceMembers  */
  YYSYMBOL_serviceMember = 129,            /* serviceMember  */
  YYSYMBOL_serviceBase = 130,              /* serviceBase  */
  YYSYMBOL_serviceInterfaceBase = 131,     /* serviceInterfaceBase  */
  YYSYMBOL_serviceProperty = 132,          /* serviceProperty  */
  YYSYMBOL_interfaceBasedSingletonDefn = 133, /* interfaceBasedSingletonDefn  */
  YYSYMBOL_serviceBasedSingletonDefn = 134, /* serviceBasedSingletonDefn  */
  YYSYMBOL_singleInheritance_opt = 135,    /* singleInheritance_opt  */
  YYSYMBOL_singleInheritance = 136,        /* singleInheritance  */
  YYSYMBOL_exceptionSpec_opt = 137,        /* exceptionSpec_opt  */
  YYSYMBOL_exceptionSpec = 138,            /* exceptionSpec  */
  YYSYMBOL_exceptions = 139,               /* exceptions  */
  YYSYMBOL_interfaceDecl = 140,            /* interfaceDecl  */
  YYSYMBOL_published_opt = 141,            /* published_opt  */
  YYSYMBOL_flagSection_opt = 142,          /* flagSection_opt  */
  YYSYMBOL_flagSection = 143,              /* flagSection  */
  YYSYMBOL_flags = 144,                    /* flags  */
  YYSYMBOL_flag = 145,                     /* flag  */
  YYSYMBOL_expr = 146,                     /* expr  */
  YYSYMBOL_orExpr = 147,                   /* orExpr  */
  YYSYMBOL_xorExpr = 148,                  /* xorExpr  */
  YYSYMBOL_andExpr = 149,                  /* andExpr  */
  YYSYMBOL_shiftExpr = 150,                /* shiftExpr  */
  YYSYMBOL_addExpr = 151,                  /* addExpr  */
  YYSYMBOL_multExpr = 152,                 /* multExpr  */
  YYSYMBOL_unaryExpr = 153,                /* unaryExpr  */
  YYSYMBOL_primaryExpr = 154,              /* primaryExpr  */
  YYSYMBOL_typeArguments = 155,            /* typeArguments  */
  YYSYMBOL_type = 156,                     /* type  */
  YYSYMBOL_name = 157,                     /* name  */
  YYSYMBOL_identifier = 158,               /* identifier  */
  YYSYMBOL_deprecated_opt = 159            /* deprecated_opt  */
};
typedef enum yysymbol_kind_t yysymbol_kind_t;


/* Second part of user prologue.  */
#line 58 "/build/libreoffice-still/src/libreoffice-25.8.5.2/unoidl/source/sourceprovider-parser.y"


#include <osl/file.h>
#include <osl/thread.h>
#include <sal/log.hxx>

#include "sourceprovider-scanner.hxx"

#define YYLLOC_DEFAULT(Current, Rhs, N) \
    do { (Current) = YYRHSLOC((Rhs), (N) ? 1 : 0); } while (0)

static void yyerror(YYLTYPE * locp, yyscan_t yyscanner, char const * msg) {
    assert(locp != nullptr);
    unoidl::detail::SourceProviderScannerData * data = yyget_extra(yyscanner);
    data->errorLine = *locp;
    data->parserError = OString(msg);
}

namespace {

void error(YYLTYPE location, yyscan_t yyscanner, OUString const & message) {
    unoidl::detail::SourceProviderScannerData * data = yyget_extra(yyscanner);
    data->errorLine = location;
    data->errorMessage = message;
}

OUString flagName(unoidl::detail::SourceProviderFlags flag) {
    switch (flag) {
    case unoidl::detail::FLAG_ATTRIBUTE:
        return u"attribute"_ustr;
    case unoidl::detail::FLAG_BOUND:
        return u"bound"_ustr;
    case unoidl::detail::FLAG_CONSTRAINED:
        return u"constrained"_ustr;
    case unoidl::detail::FLAG_MAYBEAMBIGUOUS:
        return u"maybeambiguous"_ustr;
    case unoidl::detail::FLAG_MAYBEDEFAULT:
        return u"maybedefault"_ustr;
    case unoidl::detail::FLAG_MAYBEVOID:
        return u"maybevoid"_ustr;
    case unoidl::detail::FLAG_OPTIONAL:
        return u"optional"_ustr;
    case unoidl::detail::FLAG_PROPERTY:
        return u"property"_ustr;
    case unoidl::detail::FLAG_READONLY:
        return u"readonly"_ustr;
    case unoidl::detail::FLAG_REMOVABLE:
        return u"removable"_ustr;
    case unoidl::detail::FLAG_TRANSIENT:
        return u"transient"_ustr;
    default:
        assert(false && "this cannot happen"); for (;;) { std::abort(); }
    }
}

OUString convertName(OString const * name) {
    assert(name != nullptr);
    OUString s(OStringToOUString(*name, RTL_TEXTENCODING_ASCII_US));
    delete name;
    return s;
}

OUString convertToFullName(
    unoidl::detail::SourceProviderScannerData const * data,
    OString const * identifier)
{
    assert(data != nullptr);
    OUString pref;
    if (!data->modules.empty()) {
        pref = data->modules.back() + ".";
    }
    return pref + convertName(identifier);
}

void convertToCurrentName(
    unoidl::detail::SourceProviderScannerData * data,
    OString const * identifier)
{
    assert(data != nullptr);
    assert(data->currentName.isEmpty());
    data->currentName = convertToFullName(data, identifier);
    assert(!data->currentName.isEmpty());
}

void clearCurrentState(unoidl::detail::SourceProviderScannerData * data) {
    assert(data != nullptr);
    data->currentName.clear();
    data->publishedContext = false;
}

unoidl::detail::SourceProviderEntity * getCurrentEntity(
    unoidl::detail::SourceProviderScannerData * data)
{
    assert(data != nullptr);
    assert(!data->currentName.isEmpty());
    std::map<OUString, unoidl::detail::SourceProviderEntity>::iterator i(
        data->entities.find(data->currentName));
    assert(i != data->entities.end());
    assert(i->second.kind == unoidl::detail::SourceProviderEntity::KIND_LOCAL);
    assert(i->second.pad.is());
    return &i->second;
}

template<typename T> rtl::Reference<T> getCurrentPad(
    unoidl::detail::SourceProviderScannerData * data)
{
    rtl::Reference<T> pad(dynamic_cast<T *>(getCurrentEntity(data)->pad.get()));
    assert(pad.is());
    return pad;
}

bool nameHasSameIdentifierAs(std::u16string_view name, std::u16string_view identifier)
{
    std::u16string_view::size_type pos = name.rfind('.');
    size_t i = (pos != std::u16string_view::npos) ? pos + 1 : 0;
    return identifier.size() == name.size() - i
        && o3tl::starts_with(name.substr(i), identifier);
}

bool coerce(
    YYLTYPE location, yyscan_t yyscanner,
    unoidl::detail::SourceProviderExpr * lhs,
    unoidl::detail::SourceProviderExpr * rhs)
{
    assert(lhs != nullptr);
    assert(rhs != nullptr);
    bool ok = bool(); // avoid warnings
    switch (lhs->type) {
    case unoidl::detail::SourceProviderExpr::TYPE_BOOL:
        ok = rhs->type != unoidl::detail::SourceProviderExpr::TYPE_BOOL;
        break;
    case unoidl::detail::SourceProviderExpr::TYPE_INT:
        switch (rhs->type) {
        case unoidl::detail::SourceProviderExpr::TYPE_BOOL:
            ok = false;
            break;
        case unoidl::detail::SourceProviderExpr::TYPE_INT:
            ok = true;
            break;
        case unoidl::detail::SourceProviderExpr::TYPE_UINT:
            if (lhs->ival >= 0) {
                lhs->type = unoidl::detail::SourceProviderExpr::TYPE_UINT;
                ok = true;
            } else if (rhs->uval <= SAL_MAX_INT64) {
                rhs->type = unoidl::detail::SourceProviderExpr::TYPE_INT;
                ok = true;
            } else {
                ok = false;
            }
            break;
        case unoidl::detail::SourceProviderExpr::TYPE_FLOAT:
            {
                auto tmp = lhs->ival;
                lhs->fval = tmp;
                ok = true;
            }
            break;
        }
        break;
    case unoidl::detail::SourceProviderExpr::TYPE_UINT:
        switch (rhs->type) {
        case unoidl::detail::SourceProviderExpr::TYPE_BOOL:
            ok = false;
            break;
        case unoidl::detail::SourceProviderExpr::TYPE_INT:
            if (rhs->ival >= 0) {
                rhs->type = unoidl::detail::SourceProviderExpr::TYPE_UINT;
                ok = true;
            } else if (lhs->uval <= SAL_MAX_INT64) {
                lhs->type = unoidl::detail::SourceProviderExpr::TYPE_INT;
                ok = true;
            } else {
                ok = false;
            }
            break;
        case unoidl::detail::SourceProviderExpr::TYPE_UINT:
            ok = true;
            break;
        case unoidl::detail::SourceProviderExpr::TYPE_FLOAT:
            {
                auto nTmp = lhs->uval;
                lhs->fval = nTmp;
                ok = true;
            }
            break;
        }
        break;
    case unoidl::detail::SourceProviderExpr::TYPE_FLOAT:
        switch (rhs->type) {
        case unoidl::detail::SourceProviderExpr::TYPE_BOOL:
            ok = false;
            break;
        case unoidl::detail::SourceProviderExpr::TYPE_INT:
            {
                auto tmp = rhs->ival;
                rhs->fval = tmp;
                ok = true;
            }
            break;
        case unoidl::detail::SourceProviderExpr::TYPE_UINT:
            {
                auto tmp = rhs->uval;
                rhs->fval = tmp;
                ok = true;
            }
            break;
        case unoidl::detail::SourceProviderExpr::TYPE_FLOAT:
            ok = true;
            break;
        }
        break;
    }
    if (!ok) {
        error(location, yyscanner, u"cannot coerce binary expression arguments"_ustr);
    }
    return ok;
}

unoidl::detail::SourceProviderEntity * findEntity_(
    unoidl::detail::SourceProviderScannerData * data, OUString * name)
{
    assert(data != nullptr);
    assert(name != nullptr);
    OUString n;
    if (!name->startsWith(".", &n)) {
        for (auto i(data->modules.rbegin()); i != data->modules.rend(); ++i) {
            n = *i + "." + *name;
            std::map<OUString, unoidl::detail::SourceProviderEntity>::iterator j(
                data->entities.find(n));
            if (j != data->entities.end()) {
                *name = n;
                return &j->second;
            }
            rtl::Reference<unoidl::Entity> ent(data->manager->findEntity(n));
            if (ent.is()) {
                std::map<OUString, unoidl::detail::SourceProviderEntity>::iterator
                    k(data->entities.emplace(
                              n,
                              unoidl::detail::SourceProviderEntity(
                                  unoidl::detail::SourceProviderEntity::KIND_EXTERNAL,
                                  ent)).
                      first);
                *name = n;
                return &k->second;
            }
        }
        n = *name;
    }
    std::map<OUString, unoidl::detail::SourceProviderEntity>::iterator i(
        data->entities.find(n));
    if (i != data->entities.end()) {
        *name = n;
        return &i->second;
    }
    rtl::Reference<unoidl::Entity> ent(data->manager->findEntity(n));
    if (ent.is()) {
        std::map<OUString, unoidl::detail::SourceProviderEntity>::iterator
            j(data->entities.emplace(
                      n,
                      unoidl::detail::SourceProviderEntity(
                          unoidl::detail::SourceProviderEntity::KIND_EXTERNAL,
                          ent)).
              first);
        *name = n;
        return &j->second;
    }
    return nullptr;
}

enum Found { FOUND_ERROR, FOUND_TYPE, FOUND_ENTITY };

Found findEntity(
    YYLTYPE location, yyscan_t yyscanner,
    unoidl::detail::SourceProviderScannerData * data,
    bool resolveInterfaceDefinitions, OUString * name,
    unoidl::detail::SourceProviderEntity const ** entity, bool * typedefed,
    unoidl::detail::SourceProviderType * typedefedType)
{
    //TODO: avoid recursion
    assert(data != nullptr);
    assert(name != nullptr);
    assert(entity != nullptr);
    unoidl::detail::SourceProviderEntity * e = findEntity_(data, name);
    OUString n(*name);
    OUString typeNucleus;
    std::size_t rank = 0;
    std::vector<unoidl::detail::SourceProviderType> args;
    for (;;) {
        if (e != nullptr) {
            switch (e->kind) {
            case unoidl::detail::SourceProviderEntity::KIND_LOCAL:
                if (e->pad.is()) {
                    break;
                }
                assert(e->entity.is());
                [[fallthrough]];
            case unoidl::detail::SourceProviderEntity::KIND_EXTERNAL:
                if (e->entity->getSort() == unoidl::Entity::SORT_TYPEDEF) {
                    if (typedefed != nullptr) {
                        *typedefed = true;
                    }
                    if (data->publishedContext
                        && !static_cast<unoidl::TypedefEntity *>(
                            e->entity.get())->isPublished())
                    {
                        error(
                            location, yyscanner,
                            ("type " + *name + " based on unpublished typedef "
                             + n + " used in published context"));
                        return FOUND_ERROR;
                    }
                    OUString t(
                        static_cast<unoidl::TypedefEntity *>(e->entity.get())
                        ->getType());
                    typeNucleus = t;
                    while (typeNucleus.startsWith("[]", &typeNucleus)) {
                        if (!args.empty()) {
                            error(
                                location, yyscanner,
                                ("inconsistent type manager: bad type " + *name
                                 + (" based on instantiated polymorphic struct"
                                    " type based on sequence type named ")
                                 + t));
                            return FOUND_ERROR;
                        }
                        if (rank == std::numeric_limits<std::size_t>::max()) {
                            error(
                                location, yyscanner,
                                ("bad type " + *name
                                 + " based on sequence type of too high rank"));
                            return FOUND_ERROR;
                        }
                        ++rank;
                    }
                    sal_Int32 i = typeNucleus.indexOf('<');
                    if (i != -1) {
                        if (!args.empty()) {
                            error(
                                location, yyscanner,
                                ("inconsistent type manager: bad type " + *name
                                 + (" based on instantiated polymorphic struct"
                                    " type based on instantiated polymorphic"
                                    " struct type named ")
                                 + t));
                            return FOUND_ERROR;
                        }
                        std::u16string_view tmpl(typeNucleus.subView(0, i));
                        do {
                            ++i; // skip '<' or ','
                            sal_Int32 j = i;
                            for (sal_Int32 level = 0;
                                 j != typeNucleus.getLength(); ++j)
                            {
                                sal_Unicode c = typeNucleus[j];
                                if (c == ',') {
                                    if (level == 0) {
                                        break;
                                    }
                                } else if (c == '<') {
                                    ++level;
                                } else if (c == '>') {
                                    if (level == 0) {
                                        break;
                                    }
                                    --level;
                                }
                            }
                            if (j != typeNucleus.getLength()) {
                                OUString argName(typeNucleus.copy(i, j - i));
                                unoidl::detail::SourceProviderEntity const *
                                    argEnt;
                                unoidl::detail::SourceProviderType argType;
                                switch (
                                    findEntity(
                                        location, yyscanner, data, false,
                                        &argName, &argEnt, nullptr, &argType))
                                {
                                case FOUND_ERROR:
                                    return FOUND_ERROR;
                                case FOUND_TYPE:
                                    break;
                                case FOUND_ENTITY:
                                    if (argEnt == nullptr) {
                                        error(
                                            location, yyscanner,
                                            (("inconsistent type manager: bad"
                                              " instantiated polymorphic struct"
                                              " type template type argument ")
                                             + argName));
                                        return FOUND_ERROR;
                                    } else {
                                        unoidl::detail::SourceProviderType::Type
                                            argT
                                            = unoidl::detail::SourceProviderType::Type();
                                            // avoid warnings
                                        switch (argEnt->kind) {
                                        case unoidl::detail::SourceProviderEntity::KIND_LOCAL:
                                            if (e->pad.is()) {
                                                error(
                                                    location, yyscanner,
                                                    (("inconsistent type"
                                                      " manager: bad"
                                                      " instantiated"
                                                      " polymorphic struct type"
                                                      " template type"
                                                      " argument ")
                                                     + argName));
                                                return FOUND_ERROR;
                                            }
                                            assert(e->entity.is());
                                            [[fallthrough]];
                                        case unoidl::detail::SourceProviderEntity::KIND_EXTERNAL:
                                            switch (e->entity->getSort()) {
                                            case unoidl::Entity::SORT_ENUM_TYPE:
                                                argT = unoidl::detail::SourceProviderType::TYPE_ENUM;
                                                break;
                                            case unoidl::Entity::SORT_PLAIN_STRUCT_TYPE:
                                                argT = unoidl::detail::SourceProviderType::TYPE_PLAIN_STRUCT;
                                                break;
                                            case unoidl::Entity::SORT_INTERFACE_TYPE:
                                                argT = unoidl::detail::SourceProviderType::TYPE_INTERFACE;
                                                break;
                                            default:
                                                error(
                                                    location, yyscanner,
                                                    (("inconsistent type"
                                                      "manager: bad"
                                                      " instantiated"
                                                      " polymorphic struct type"
                                                      " template type"
                                                      " argument ")
                                                     + argName));
                                                return FOUND_ERROR;
                                            }
                                            break;
                                        case unoidl::detail::SourceProviderEntity::KIND_INTERFACE_DECL:
                                        case unoidl::detail::SourceProviderEntity::KIND_PUBLISHED_INTERFACE_DECL:
                                            argT = unoidl::detail::SourceProviderType::TYPE_INTERFACE;
                                            break;
                                        case unoidl::detail::SourceProviderEntity::KIND_MODULE:
                                            assert(false && "this cannot happen");
                                        }
                                        argType
                                            = unoidl::detail::SourceProviderType(
                                                argT, argName, argEnt);
                                    }
                                    break;
                                }
                                args.push_back(argType);
                            }
                            i = j;
                        } while (i != typeNucleus.getLength()
                                 && typeNucleus[i] != '>');
                        if (i != typeNucleus.getLength() - 1
                            || typeNucleus[i] != '>')
                        {
                            error(
                                location, yyscanner,
                                ("inconsistent type manager: bad type name \""
                                 + t + "\""));
                            return FOUND_ERROR;
                        }
                        assert(!args.empty());
                        typeNucleus = tmpl;
                    }
                    if (typeNucleus.isEmpty()) {
                        error(
                            location, yyscanner,
                            ("inconsistent type manager: bad type name \"" + t
                             + "\""));
                        return FOUND_ERROR;
                    }
                    if (typeNucleus == "void") {
                        error(
                            location, yyscanner,
                            ("inconsistent type manager: bad type " + *name
                             + " based on void"));
                        return FOUND_ERROR;
                    }
                    if (typeNucleus == "boolean" || typeNucleus == "byte"
                        || typeNucleus == "short"
                        || typeNucleus == "unsigned short"
                        || typeNucleus == "long"
                        || typeNucleus == "unsigned long"
                        || typeNucleus == "hyper"
                        || typeNucleus == "unsigned hyper"
                        || typeNucleus == "float" || typeNucleus == "double"
                        || typeNucleus == "char" || typeNucleus == "string"
                        || typeNucleus == "type" || typeNucleus == "any")
                    {
                        if (!args.empty()) {
                            error(
                                location, yyscanner,
                                ("inconsistent type manager: bad type " + *name
                                 + (" based on instantiated polymorphic struct"
                                    " type based on ")
                                 + typeNucleus));
                            return FOUND_ERROR;
                        }
                        break;
                    }
                    n = "." + typeNucleus;
                    typeNucleus.clear();
                    e = findEntity_(data, &n);
                    continue;
                }
                break;
            case unoidl::detail::SourceProviderEntity::KIND_INTERFACE_DECL:
            case unoidl::detail::SourceProviderEntity::KIND_PUBLISHED_INTERFACE_DECL:
                if (resolveInterfaceDefinitions) {
                    rtl::Reference<unoidl::Entity> ent(
                        data->manager->findEntity(n));
                    // Do not allow ent to be of SORT_TYPEDEF:
                    if (!ent.is()
                        || (ent->getSort()
                            != unoidl::Entity::SORT_INTERFACE_TYPE))
                    {
                        error(
                            location, yyscanner,
                            (*name + " is based on interface declaration " + n
                             + " that is not an interface type entity"));
                        return FOUND_ERROR;
                    }
                    e->kind
                        = unoidl::detail::SourceProviderEntity::KIND_EXTERNAL;
                    e->entity = std::move(ent);
                }
                break;
            case unoidl::detail::SourceProviderEntity::KIND_MODULE:
                error(
                    location, yyscanner,
                    *name + " is based on module entity " + n);
                return FOUND_ERROR;
            }
        }
        if (!typeNucleus.isEmpty() || rank != 0 || !args.empty()) {
            if (typeNucleus.isEmpty() && e == nullptr) {
                // Found a type name based on an unknown entity:
                *entity = nullptr;
                return FOUND_ENTITY;
            }
            unoidl::detail::SourceProviderType t;
            if (args.empty()) {
                if (typeNucleus == "boolean") {
                    t = unoidl::detail::SourceProviderType(
                        unoidl::detail::SourceProviderType::TYPE_BOOLEAN);
                } else if (typeNucleus == "byte") {
                    t = unoidl::detail::SourceProviderType(
                        unoidl::detail::SourceProviderType::TYPE_BYTE);
                } else if (typeNucleus == "short") {
                    t = unoidl::detail::SourceProviderType(
                        unoidl::detail::SourceProviderType::TYPE_SHORT);
                } else if (typeNucleus == "unsigned short") {
                    t = unoidl::detail::SourceProviderType(
                        unoidl::detail::SourceProviderType::TYPE_UNSIGNED_SHORT);
                } else if (typeNucleus == "long") {
                    t = unoidl::detail::SourceProviderType(
                        unoidl::detail::SourceProviderType::TYPE_LONG);
                } else if (typeNucleus == "unsigned long") {
                    t = unoidl::detail::SourceProviderType(
                        unoidl::detail::SourceProviderType::TYPE_UNSIGNED_LONG);
                } else if (typeNucleus == "hyper") {
                    t = unoidl::detail::SourceProviderType(
                        unoidl::detail::SourceProviderType::TYPE_HYPER);
                } else if (typeNucleus == "unsigned hyper") {
                    t = unoidl::detail::SourceProviderType(
                        unoidl::detail::SourceProviderType::TYPE_UNSIGNED_HYPER);
                } else if (typeNucleus == "float") {
                    t = unoidl::detail::SourceProviderType(
                        unoidl::detail::SourceProviderType::TYPE_FLOAT);
                } else if (typeNucleus == "double") {
                    t = unoidl::detail::SourceProviderType(
                        unoidl::detail::SourceProviderType::TYPE_DOUBLE);
                } else if (typeNucleus == "char") {
                    t = unoidl::detail::SourceProviderType(
                        unoidl::detail::SourceProviderType::TYPE_CHAR);
                } else if (typeNucleus == "string") {
                    t = unoidl::detail::SourceProviderType(
                        unoidl::detail::SourceProviderType::TYPE_STRING);
                } else if (typeNucleus == "type") {
                    t = unoidl::detail::SourceProviderType(
                        unoidl::detail::SourceProviderType::TYPE_TYPE);
                } else if (typeNucleus == "any") {
                    t = unoidl::detail::SourceProviderType(
                        unoidl::detail::SourceProviderType::TYPE_ANY);
                } else {
                    assert(typeNucleus.isEmpty());
                    assert(e != nullptr);
                    switch (e->kind) {
                    case unoidl::detail::SourceProviderEntity::KIND_LOCAL:
                        if (e->pad.is()) {
                            if (dynamic_cast<unoidl::detail::SourceProviderEnumTypeEntityPad *>(
                                    e->pad.get())
                                != nullptr)
                            {
                                t = unoidl::detail::SourceProviderType(
                                    unoidl::detail::SourceProviderType::TYPE_ENUM,
                                    n, e);
                            } else if (dynamic_cast<unoidl::detail::SourceProviderPlainStructTypeEntityPad *>(
                                           e->pad.get())
                                       != nullptr)
                            {
                                t = unoidl::detail::SourceProviderType(
                                    unoidl::detail::SourceProviderType::TYPE_PLAIN_STRUCT,
                                    n, e);
                            } else if (dynamic_cast<unoidl::detail::SourceProviderPolymorphicStructTypeTemplateEntityPad *>(
                                           e->pad.get())
                                       != nullptr)
                            {
                                error(
                                    location, yyscanner,
                                    ("bad type " + *name
                                     + (" based on recursive reference to"
                                        " polymorphic struct type template ")
                                     + n));
                                return FOUND_ERROR;
                            } else if (dynamic_cast<unoidl::detail::SourceProviderExceptionTypeEntityPad *>(
                                           e->pad.get())
                                       != nullptr)
                            {
                                t = unoidl::detail::SourceProviderType(
                                    unoidl::detail::SourceProviderType::TYPE_EXCEPTION,
                                    n, e);
                            } else if (dynamic_cast<unoidl::detail::SourceProviderInterfaceTypeEntityPad *>(
                                           e->pad.get())
                                       != nullptr)
                            {
                                t = unoidl::detail::SourceProviderType(
                                    unoidl::detail::SourceProviderType::TYPE_INTERFACE,
                                    n, e);
                            } else {
                                error(
                                    location, yyscanner,
                                    ("bad type " + *name
                                     + " based on non-type entity " + n));
                                return FOUND_ERROR;
                            }
                            break;
                        }
                        assert(e->entity.is());
                        [[fallthrough]];
                    case unoidl::detail::SourceProviderEntity::KIND_EXTERNAL:
                        switch (e->entity->getSort()) {
                        case unoidl::Entity::SORT_ENUM_TYPE:
                            t = unoidl::detail::SourceProviderType(
                                unoidl::detail::SourceProviderType::TYPE_ENUM,
                                n, e);
                            break;
                        case unoidl::Entity::SORT_PLAIN_STRUCT_TYPE:
                            t = unoidl::detail::SourceProviderType(
                                unoidl::detail::SourceProviderType::TYPE_PLAIN_STRUCT,
                                n, e);
                            break;
                        case unoidl::Entity::SORT_POLYMORPHIC_STRUCT_TYPE_TEMPLATE:
                            error(
                                location, yyscanner,
                                ("bad type " + *name
                                 + " based on polymorphic struct type template "
                                 + n + " without type arguments"));
                            return FOUND_ERROR;
                        case unoidl::Entity::SORT_EXCEPTION_TYPE:
                            t = unoidl::detail::SourceProviderType(
                                unoidl::detail::SourceProviderType::TYPE_EXCEPTION,
                                n, e);
                            break;
                        case unoidl::Entity::SORT_INTERFACE_TYPE:
                            t = unoidl::detail::SourceProviderType(
                                unoidl::detail::SourceProviderType::TYPE_INTERFACE,
                                n, e);
                            break;
                        default:
                            error(
                                location, yyscanner,
                                ("bad type " + *name
                                 + " based on non-type entity " + n));
                            return FOUND_ERROR;
                        }
                        break;
                    case unoidl::detail::SourceProviderEntity::KIND_INTERFACE_DECL:
                    case unoidl::detail::SourceProviderEntity::KIND_PUBLISHED_INTERFACE_DECL:
                        t = unoidl::detail::SourceProviderType(
                            unoidl::detail::SourceProviderType::TYPE_INTERFACE,
                            n, e);
                        break;
                    case unoidl::detail::SourceProviderEntity::KIND_MODULE:
                        assert(false && "this cannot happen");
                    }
                }
            } else {
                assert(typeNucleus.isEmpty());
                assert(e != nullptr);
                switch (e->kind) {
                case unoidl::detail::SourceProviderEntity::KIND_LOCAL:
                    if (e->pad.is()) {
                        error(
                            location, yyscanner,
                            ("bad type " + *name
                             + (" based on instantiated polymorphic struct type"
                                " based on ")
                             + n
                             + (" that is either not a polymorphic struct type"
                                " template or a recursive reference to a"
                                " polymorphic struct type template")));
                        return FOUND_ERROR;
                    }
                    assert(e->entity.is());
                    [[fallthrough]];
                case unoidl::detail::SourceProviderEntity::KIND_EXTERNAL:
                    if (e->entity->getSort()
                        == unoidl::Entity::SORT_POLYMORPHIC_STRUCT_TYPE_TEMPLATE)
                    {
                        if (args.size()
                            != (static_cast<
                                    unoidl::PolymorphicStructTypeTemplateEntity *>(
                                        e->entity.get())
                                ->getTypeParameters().size()))
                        {
                            error(
                                location, yyscanner,
                                ("bad type " + *name
                                 + (" based on instantiated polymorphic struct"
                                    " type with ")
                                 + OUString::number(args.size())
                                 + (" type arguments based on polymorphic"
                                    " struct type template ")
                                 + n + " with "
                                 + OUString::number(
                                     static_cast<
                                         unoidl::PolymorphicStructTypeTemplateEntity *>(
                                             e->entity.get())
                                     ->getTypeParameters().size())
                                 + " type parameters"));
                            return FOUND_ERROR;
                        }
                        t = unoidl::detail::SourceProviderType(n, e, std::move(args));
                        break;
                    }
                    [[fallthrough]];
                case unoidl::detail::SourceProviderEntity::KIND_INTERFACE_DECL:
                case unoidl::detail::SourceProviderEntity::KIND_PUBLISHED_INTERFACE_DECL:
                    error(
                        location, yyscanner,
                        ("bad type " + *name
                         + (" based on instantiated polymorphic struct type"
                            " based on ")
                         + n
                         + " that is not a polymorphic struct type template"));
                    return FOUND_ERROR;
                case unoidl::detail::SourceProviderEntity::KIND_MODULE:
                    assert(false && "this cannot happen");
                }
            }
            if (typedefedType != nullptr) {
                for (std::size_t i = 0; i != rank; ++i) {
                    t = unoidl::detail::SourceProviderType(&t);
                }
                *typedefedType = std::move(t);
                typedefedType->typedefName = *name;
            }
            *entity = nullptr;
            return FOUND_TYPE;
        }
        *entity = e;
        return FOUND_ENTITY;
    }
}


bool checkTypeArgument(
    YYLTYPE location, yyscan_t yyscanner,
    unoidl::detail::SourceProviderType const & type)
{
    switch (type.type) {
    case unoidl::detail::SourceProviderType::TYPE_VOID:
    case unoidl::detail::SourceProviderType::TYPE_UNSIGNED_SHORT:
    case unoidl::detail::SourceProviderType::TYPE_UNSIGNED_LONG:
    case unoidl::detail::SourceProviderType::TYPE_UNSIGNED_HYPER:
    case unoidl::detail::SourceProviderType::TYPE_EXCEPTION:
    case unoidl::detail::SourceProviderType::TYPE_PARAMETER: //TODO?
        error(
            location, yyscanner,
            u"bad instantiated polymorphic struct type argument"_ustr);
        return false;
    case unoidl::detail::SourceProviderType::TYPE_SEQUENCE:
        return checkTypeArgument(location, yyscanner, type.subtypes.front());
    default:
        return true;
    }
}

bool checkInstantiatedPolymorphicStructTypeArgument(
    unoidl::detail::SourceProviderType const & type, OUString const & name)
{
    if (type.type
        == unoidl::detail::SourceProviderType::TYPE_INSTANTIATED_POLYMORPHIC_STRUCT)
    {
        for (auto & i: type.subtypes) {
            if (checkInstantiatedPolymorphicStructTypeArgument(i, name)
                || i.getName() == name) // no need to worry about typedef
            {
                return true;
            }
        }
    }
    return false;
}

std::vector<OUString> annotations(bool deprecated) {
    std::vector<OUString> ann;
    if (deprecated) {
        ann.push_back(u"deprecated"_ustr);
    }
    return ann;
}

}


#line 1106 "/build/libreoffice-still/src/libreoffice-25.8.5.2/workdir/YaccTarget/unoidl/source/sourceprovider-parser.cxx"


#ifdef short
# undef short
#endif

/* On compilers that do not define __PTRDIFF_MAX__ etc., make sure
   <limits.h> and (if available) <stdint.h> are included
   so that the code can choose integer types of a good width.  */

#ifndef __PTRDIFF_MAX__
# include <limits.h> /* INFRINGES ON USER NAME SPACE */
# if defined __STDC_VERSION__ && 199901 <= __STDC_VERSION__
#  include <stdint.h> /* INFRINGES ON USER NAME SPACE */
#  define YY_STDINT_H
# endif
#endif

/* Narrow types that promote to a signed type and that can represent a
   signed or unsigned integer of at least N bits.  In tables they can
   save space and decrease cache pressure.  Promoting to a signed type
   helps avoid bugs in integer arithmetic.  */

#ifdef __INT_LEAST8_MAX__
typedef __INT_LEAST8_TYPE__ yytype_int8;
#elif defined YY_STDINT_H
typedef int_least8_t yytype_int8;
#else
typedef signed char yytype_int8;
#endif

#ifdef __INT_LEAST16_MAX__
typedef __INT_LEAST16_TYPE__ yytype_int16;
#elif defined YY_STDINT_H
typedef int_least16_t yytype_int16;
#else
typedef short yytype_int16;
#endif

/* Work around bug in HP-UX 11.23, which defines these macros
   incorrectly for preprocessor constants.  This workaround can likely
   be removed in 2023, as HPE has promised support for HP-UX 11.23
   (aka HP-UX 11i v2) only through the end of 2022; see Table 2 of
   <https://h20195.www2.hpe.com/V2/getpdf.aspx/4AA4-7673ENW.pdf>.  */
#ifdef __hpux
# undef UINT_LEAST8_MAX
# undef UINT_LEAST16_MAX
# define UINT_LEAST8_MAX 255
# define UINT_LEAST16_MAX 65535
#endif

#if defined __UINT_LEAST8_MAX__ && __UINT_LEAST8_MAX__ <= __INT_MAX__
typedef __UINT_LEAST8_TYPE__ yytype_uint8;
#elif (!defined __UINT_LEAST8_MAX__ && defined YY_STDINT_H \
       && UINT_LEAST8_MAX <= INT_MAX)
typedef uint_least8_t yytype_uint8;
#elif !defined __UINT_LEAST8_MAX__ && UCHAR_MAX <= INT_MAX
typedef unsigned char yytype_uint8;
#else
typedef short yytype_uint8;
#endif

#if defined __UINT_LEAST16_MAX__ && __UINT_LEAST16_MAX__ <= __INT_MAX__
typedef __UINT_LEAST16_TYPE__ yytype_uint16;
#elif (!defined __UINT_LEAST16_MAX__ && defined YY_STDINT_H \
       && UINT_LEAST16_MAX <= INT_MAX)
typedef uint_least16_t yytype_uint16;
#elif !defined __UINT_LEAST16_MAX__ && USHRT_MAX <= INT_MAX
typedef unsigned short yytype_uint16;
#else
typedef int yytype_uint16;
#endif

#ifndef YYPTRDIFF_T
# if defined __PTRDIFF_TYPE__ && defined __PTRDIFF_MAX__
#  define YYPTRDIFF_T __PTRDIFF_TYPE__
#  define YYPTRDIFF_MAXIMUM __PTRDIFF_MAX__
# elif defined PTRDIFF_MAX
#  ifndef ptrdiff_t
#   include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  endif
#  define YYPTRDIFF_T ptrdiff_t
#  define YYPTRDIFF_MAXIMUM PTRDIFF_MAX
# else
#  define YYPTRDIFF_T long
#  define YYPTRDIFF_MAXIMUM LONG_MAX
# endif
#endif

#ifndef YYSIZE_T
# ifdef __SIZE_TYPE__
#  define YYSIZE_T __SIZE_TYPE__
# elif defined size_t
#  define YYSIZE_T size_t
# elif defined __STDC_VERSION__ && 199901 <= __STDC_VERSION__
#  include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  define YYSIZE_T size_t
# else
#  define YYSIZE_T unsigned
# endif
#endif

#define YYSIZE_MAXIMUM                                  \
  YY_CAST (YYPTRDIFF_T,                                 \
           (YYPTRDIFF_MAXIMUM < YY_CAST (YYSIZE_T, -1)  \
            ? YYPTRDIFF_MAXIMUM                         \
            : YY_CAST (YYSIZE_T, -1)))

#define YYSIZEOF(X) YY_CAST (YYPTRDIFF_T, sizeof (X))


/* Stored state numbers (used for stacks). */
typedef yytype_int16 yy_state_t;

/* State numbers in computations.  */
typedef int yy_state_fast_t;

#ifndef YY_
# if defined YYENABLE_NLS && YYENABLE_NLS
#  if ENABLE_NLS
#   include <libintl.h> /* INFRINGES ON USER NAME SPACE */
#   define YY_(Msgid) dgettext ("bison-runtime", Msgid)
#  endif
# endif
# ifndef YY_
#  define YY_(Msgid) Msgid
# endif
#endif


#ifndef YY_ATTRIBUTE_PURE
# if defined __GNUC__ && 2 < __GNUC__ + (96 <= __GNUC_MINOR__)
#  define YY_ATTRIBUTE_PURE __attribute__ ((__pure__))
# else
#  define YY_ATTRIBUTE_PURE
# endif
#endif

#ifndef YY_ATTRIBUTE_UNUSED
# if defined __GNUC__ && 2 < __GNUC__ + (7 <= __GNUC_MINOR__)
#  define YY_ATTRIBUTE_UNUSED __attribute__ ((__unused__))
# else
#  define YY_ATTRIBUTE_UNUSED
# endif
#endif

/* Suppress unused-variable warnings by "using" E.  */
#if ! defined lint || defined __GNUC__
# define YY_USE(E) ((void) (E))
#else
# define YY_USE(E) /* empty */
#endif

/* Suppress an incorrect diagnostic about yylval being uninitialized.  */
#if defined __GNUC__ && ! defined __ICC && 406 <= __GNUC__ * 100 + __GNUC_MINOR__
# if __GNUC__ * 100 + __GNUC_MINOR__ < 407
#  define YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN                           \
    _Pragma ("GCC diagnostic push")                                     \
    _Pragma ("GCC diagnostic ignored \"-Wuninitialized\"")
# else
#  define YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN                           \
    _Pragma ("GCC diagnostic push")                                     \
    _Pragma ("GCC diagnostic ignored \"-Wuninitialized\"")              \
    _Pragma ("GCC diagnostic ignored \"-Wmaybe-uninitialized\"")
# endif
# define YY_IGNORE_MAYBE_UNINITIALIZED_END      \
    _Pragma ("GCC diagnostic pop")
#else
# define YY_INITIAL_VALUE(Value) Value
#endif
#ifndef YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
# define YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
# define YY_IGNORE_MAYBE_UNINITIALIZED_END
#endif
#ifndef YY_INITIAL_VALUE
# define YY_INITIAL_VALUE(Value) /* Nothing. */
#endif

#if defined __cplusplus && defined __GNUC__ && ! defined __ICC && 6 <= __GNUC__
# define YY_IGNORE_USELESS_CAST_BEGIN                          \
    _Pragma ("GCC diagnostic push")                            \
    _Pragma ("GCC diagnostic ignored \"-Wuseless-cast\"")
# define YY_IGNORE_USELESS_CAST_END            \
    _Pragma ("GCC diagnostic pop")
#endif
#ifndef YY_IGNORE_USELESS_CAST_BEGIN
# define YY_IGNORE_USELESS_CAST_BEGIN
# define YY_IGNORE_USELESS_CAST_END
#endif


#define YY_ASSERT(E) ((void) (0 && (E)))

#if !defined yyoverflow

/* The parser invokes alloca or malloc; define the necessary symbols.  */

# ifdef YYSTACK_USE_ALLOCA
#  if YYSTACK_USE_ALLOCA
#   ifdef __GNUC__
#    define YYSTACK_ALLOC __builtin_alloca
#   elif defined __BUILTIN_VA_ARG_INCR
#    include <alloca.h> /* INFRINGES ON USER NAME SPACE */
#   elif defined _AIX
#    define YYSTACK_ALLOC __alloca
#   elif defined _MSC_VER
#    include <malloc.h> /* INFRINGES ON USER NAME SPACE */
#    define alloca _alloca
#   else
#    define YYSTACK_ALLOC alloca
#    if ! defined _ALLOCA_H && ! defined EXIT_SUCCESS
#     include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
      /* Use EXIT_SUCCESS as a witness for stdlib.h.  */
#     ifndef EXIT_SUCCESS
#      define EXIT_SUCCESS 0
#     endif
#    endif
#   endif
#  endif
# endif

# ifdef YYSTACK_ALLOC
   /* Pacify GCC's 'empty if-body' warning.  */
#  define YYSTACK_FREE(Ptr) do { /* empty */; } while (0)
#  ifndef YYSTACK_ALLOC_MAXIMUM
    /* The OS might guarantee only one guard page at the bottom of the stack,
       and a page size can be as small as 4096 bytes.  So we cannot safely
       invoke alloca (N) if N exceeds 4096.  Use a slightly smaller number
       to allow for a few compiler-allocated temporary stack slots.  */
#   define YYSTACK_ALLOC_MAXIMUM 4032 /* reasonable circa 2006 */
#  endif
# else
#  define YYSTACK_ALLOC YYMALLOC
#  define YYSTACK_FREE YYFREE
#  ifndef YYSTACK_ALLOC_MAXIMUM
#   define YYSTACK_ALLOC_MAXIMUM YYSIZE_MAXIMUM
#  endif
#  if (defined __cplusplus && ! defined EXIT_SUCCESS \
       && ! ((defined YYMALLOC || defined malloc) \
             && (defined YYFREE || defined free)))
#   include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#   ifndef EXIT_SUCCESS
#    define EXIT_SUCCESS 0
#   endif
#  endif
#  ifndef YYMALLOC
#   define YYMALLOC malloc
#   if ! defined malloc && ! defined EXIT_SUCCESS
void *malloc (YYSIZE_T); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
#  ifndef YYFREE
#   define YYFREE free
#   if ! defined free && ! defined EXIT_SUCCESS
void free (void *); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
# endif
#endif /* !defined yyoverflow */

#if (! defined yyoverflow \
     && (! defined __cplusplus \
         || (defined YYLTYPE_IS_TRIVIAL && YYLTYPE_IS_TRIVIAL \
             && defined YYSTYPE_IS_TRIVIAL && YYSTYPE_IS_TRIVIAL)))

/* A type that is properly aligned for any stack member.  */
union yyalloc
{
  yy_state_t yyss_alloc;
  YYSTYPE yyvs_alloc;
  YYLTYPE yyls_alloc;
};

/* The size of the maximum gap between one aligned stack and the next.  */
# define YYSTACK_GAP_MAXIMUM (YYSIZEOF (union yyalloc) - 1)

/* The size of an array large to enough to hold all stacks, each with
   N elements.  */
# define YYSTACK_BYTES(N) \
     ((N) * (YYSIZEOF (yy_state_t) + YYSIZEOF (YYSTYPE) \
             + YYSIZEOF (YYLTYPE)) \
      + 2 * YYSTACK_GAP_MAXIMUM)

# define YYCOPY_NEEDED 1

/* Relocate STACK from its old location to the new one.  The
   local variables YYSIZE and YYSTACKSIZE give the old and new number of
   elements in the stack, and YYPTR gives the new location of the
   stack.  Advance YYPTR to a properly aligned location for the next
   stack.  */
# define YYSTACK_RELOCATE(Stack_alloc, Stack)                           \
    do                                                                  \
      {                                                                 \
        YYPTRDIFF_T yynewbytes;                                         \
        YYCOPY (&yyptr->Stack_alloc, Stack, yysize);                    \
        Stack = &yyptr->Stack_alloc;                                    \
        yynewbytes = yystacksize * YYSIZEOF (*Stack) + YYSTACK_GAP_MAXIMUM; \
        yyptr += yynewbytes / YYSIZEOF (*yyptr);                        \
      }                                                                 \
    while (0)

#endif

#if defined YYCOPY_NEEDED && YYCOPY_NEEDED
/* Copy COUNT objects from SRC to DST.  The source and destination do
   not overlap.  */
# ifndef YYCOPY
#  if defined __GNUC__ && 1 < __GNUC__
#   define YYCOPY(Dst, Src, Count) \
      __builtin_memcpy (Dst, Src, YY_CAST (YYSIZE_T, (Count)) * sizeof (*(Src)))
#  else
#   define YYCOPY(Dst, Src, Count)              \
      do                                        \
        {                                       \
          YYPTRDIFF_T yyi;                      \
          for (yyi = 0; yyi < (Count); yyi++)   \
            (Dst)[yyi] = (Src)[yyi];            \
        }                                       \
      while (0)
#  endif
# endif
#endif /* !YYCOPY_NEEDED */

/* YYFINAL -- State number of the termination state.  */
#define YYFINAL  2
/* YYLAST -- Last index in YYTABLE.  */
#define YYLAST   309

/* YYNTOKENS -- Number of terminals.  */
#define YYNTOKENS  77
/* YYNNTS -- Number of nonterminals.  */
#define YYNNTS  83
/* YYNRULES -- Number of rules.  */
#define YYNRULES  178
/* YYNSTATES -- Number of states.  */
#define YYNSTATES  313

/* YYMAXUTOK -- Last valid token kind.  */
#define YYMAXUTOK   310


/* YYTRANSLATE(TOKEN-NUM) -- Symbol number corresponding to TOKEN-NUM
   as returned by yylex, with out-of-bounds checking.  */
#define YYTRANSLATE(YYX)                                \
  (0 <= (YYX) && (YYX) <= YYMAXUTOK                     \
   ? YY_CAST (yysymbol_kind_t, yytranslate[YYX])        \
   : YYSYMBOL_YYUNDEF)

/* YYTRANSLATE[TOKEN-NUM] -- Symbol number corresponding to TOKEN-NUM
   as returned by yylex.  */
static const yytype_int8 yytranslate[] =
{
       0,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,    75,    70,     2,
      63,    64,    73,    71,    59,    72,     2,    74,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,    67,    58,
      61,    60,    62,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,    65,     2,    66,    69,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,    56,    68,    57,    76,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     1,     2,     3,     4,
       5,     6,     7,     8,     9,    10,    11,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    21,    22,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    32,    33,    34,
      35,    36,    37,    38,    39,    40,    41,    42,    43,    44,
      45,    46,    47,    48,    49,    50,    51,    52,    53,    54,
      55
};

#if YYDEBUG
/* YYRLINE[YYN] -- Source line where rule number YYN was defined.  */
static const yytype_int16 yyrline[] =
{
       0,   951,   951,   952,   956,   957,   958,   959,   960,   961,
     962,   963,   964,   965,   966,   967,   968,   973,   972,   995,
     994,  1025,  1026,  1027,  1031,  1053,  1095,  1094,  1159,  1158,
    1192,  1211,  1225,  1224,  1286,  1287,  1291,  1495,  1494,  1624,
    1625,  1629,  1630,  1631,  1635,  1701,  1700,  1750,  1751,  1755,
    1764,  1768,  1779,  1803,  1802,  1842,  1843,  1847,  1848,  1852,
    1890,  1891,  1893,  1898,  1969,  1968,  2000,  2001,  2005,  2287,
    2286,  2379,  2380,  2384,  2385,  2390,  2389,  2453,  2454,  2458,
    2459,  2463,  2540,  2541,  2545,  2544,  2579,  2580,  2584,  2585,
    2586,  2590,  2648,  2725,  2815,  2881,  2931,  2932,  2935,  2939,
    2940,  2943,  2947,  2987,  3020,  3069,  3070,  3074,  3075,  3078,
    3082,  3090,  3094,  3095,  3096,  3097,  3098,  3099,  3100,  3101,
    3102,  3103,  3104,  3107,  3111,  3129,  3133,  3151,  3155,  3173,
    3177,  3225,  3267,  3271,  3292,  3313,  3317,  3338,  3371,  3397,
    3401,  3409,  3443,  3458,  3462,  3463,  3464,  3465,  3466,  3467,
    3604,  3615,  3628,  3633,  3638,  3643,  3648,  3653,  3658,  3663,
    3668,  3673,  3678,  3683,  3688,  3693,  3698,  3703,  3718,  3890,
    3964,  3965,  3966,  3970,  3971,  3972,  3973,  3977,  3978
};
#endif

/** Accessing symbol of state STATE.  */
#define YY_ACCESSING_SYMBOL(State) YY_CAST (yysymbol_kind_t, yystos[State])

#if YYDEBUG || 0
/* The user-facing name of the symbol whose (internal) number is
   YYSYMBOL.  No bounds checking.  */
static const char *yysymbol_name (yysymbol_kind_t yysymbol) YY_ATTRIBUTE_UNUSED;

/* YYTNAME[SYMBOL-NUM] -- String name of the symbol SYMBOL-NUM.
   First, the terminals, then, starting at YYNTOKENS, nonterminals.  */
static const char *const yytname[] =
{
  "\"end of file\"", "error", "\"invalid token\"", "TOK_ELLIPSIS",
  "TOK_COLONS", "TOK_LEFTSHIFT", "TOK_RIGHTSHIFT", "TOK_FALSE", "TOK_TRUE",
  "TOK_ANY", "TOK_ATTRIBUTE", "TOK_BOOLEAN", "TOK_BOUND", "TOK_BYTE",
  "TOK_CHAR", "TOK_CONST", "TOK_CONSTANTS", "TOK_CONSTRAINED",
  "TOK_DOUBLE", "TOK_ENUM", "TOK_EXCEPTION", "TOK_FLOAT", "TOK_GET",
  "TOK_HYPER", "TOK_IN", "TOK_INOUT", "TOK_INTERFACE", "TOK_LONG",
  "TOK_MAYBEAMBIGUOUS", "TOK_MAYBEDEFAULT", "TOK_MAYBEVOID", "TOK_MODULE",
  "TOK_OPTIONAL", "TOK_OUT", "TOK_PROPERTY", "TOK_PUBLISHED", "TOK_RAISES",
  "TOK_READONLY", "TOK_REMOVABLE", "TOK_SEQUENCE", "TOK_SERVICE",
  "TOK_SET", "TOK_SHORT", "TOK_SINGLETON", "TOK_STRING", "TOK_STRUCT",
  "TOK_TRANSIENT", "TOK_TYPE", "TOK_TYPEDEF", "TOK_UNSIGNED", "TOK_VOID",
  "TOK_IDENTIFIER", "TOK_INTEGER", "TOK_FLOATING", "TOK_DEPRECATED",
  "TOK_ERROR", "'{'", "'}'", "';'", "','", "'='", "'<'", "'>'", "'('",
  "')'", "'['", "']'", "':'", "'|'", "'^'", "'&'", "'+'", "'-'", "'*'",
  "'/'", "'%'", "'~'", "$accept", "definitions", "definition",
  "moduleDecl", "$@1", "enumDefn", "$@2", "enumMembers", "enumMember",
  "plainStructDefn", "$@3", "polymorphicStructTemplateDefn", "$@4",
  "typeParameters", "exceptionDefn", "$@5", "structMembers",
  "structMember", "interfaceDefn", "$@6", "interfaceMembers",
  "interfaceMember", "interfaceBase", "interfaceAttribute", "$@7",
  "attributeAccessDecls_opt", "attributeAccessDecls",
  "attributeAccessDecl", "interfaceMethod", "$@8", "methodParams_opt",
  "methodParams", "methodParam", "direction", "typedefDefn",
  "constantGroupDefn", "$@9", "constants", "constant",
  "singleInterfaceBasedServiceDefn", "$@10", "ctors_opt", "ctors", "ctor",
  "$@11", "ctorParams_opt", "ctorParams", "ctorParam", "ellipsis_opt",
  "accumulationBasedServiceDefn", "$@12", "serviceMembers",
  "serviceMember", "serviceBase", "serviceInterfaceBase",
  "serviceProperty", "interfaceBasedSingletonDefn",
  "serviceBasedSingletonDefn", "singleInheritance_opt",
  "singleInheritance", "exceptionSpec_opt", "exceptionSpec", "exceptions",
  "interfaceDecl", "published_opt", "flagSection_opt", "flagSection",
  "flags", "flag", "expr", "orExpr", "xorExpr", "andExpr", "shiftExpr",
  "addExpr", "multExpr", "unaryExpr", "primaryExpr", "typeArguments",
  "type", "name", "identifier", "deprecated_opt", YY_NULLPTR
};

static const char *
yysymbol_name (yysymbol_kind_t yysymbol)
{
  return yytname[yysymbol];
}
#endif

#define YYPACT_NINF (-181)

#define yypact_value_is_default(Yyn) \
  ((Yyn) == YYPACT_NINF)

#define YYTABLE_NINF (-22)

#define yytable_value_is_error(Yyn) \
  0

/* YYPACT[STATE-NUM] -- Index in YYTABLE of the portion describing
   STATE-NUM.  */
static const yytype_int16 yypact[] =
{
    -181,     8,  -181,    63,  -181,  -181,  -181,  -181,  -181,  -181,
    -181,  -181,  -181,  -181,  -181,  -181,  -181,  -181,  -181,    -1,
    -181,  -181,  -181,  -181,  -181,  -181,   208,    62,    63,    63,
      63,    63,    63,    63,    63,   191,  -181,  -181,  -181,    53,
     -47,    53,   -18,   -15,    63,  -181,  -181,  -181,  -181,  -181,
    -181,  -181,  -181,    78,  -181,  -181,  -181,    61,  -181,    63,
       0,  -181,   -12,    92,   108,    59,  -181,  -181,  -181,  -181,
     147,  -181,    82,   114,  -181,  -181,  -181,   191,  -181,  -181,
    -181,   157,    63,   191,   159,  -181,    96,   218,   169,   173,
    -181,   175,    59,  -181,    63,   180,   177,  -181,  -181,   -45,
    -181,  -181,   -39,   149,  -181,    63,  -181,  -181,    67,  -181,
     179,     9,    72,  -181,  -181,  -181,   191,  -181,   185,  -181,
     229,   187,   192,   189,    86,    87,   194,  -181,  -181,  -181,
    -181,   182,    95,  -181,   197,    63,   199,   129,  -181,  -181,
     191,  -181,  -181,     2,   200,  -181,   191,   202,  -181,  -181,
    -181,  -181,   124,  -181,   150,    -4,   191,  -181,  -181,    63,
     203,  -181,  -181,   204,    63,  -181,  -181,  -181,  -181,     2,
      64,    64,    64,  -181,   196,   188,   195,    42,   -14,    22,
    -181,  -181,   218,  -181,    63,  -181,   240,   191,    63,  -181,
    -181,  -181,  -181,  -181,  -181,  -181,  -181,  -181,  -181,  -181,
      23,  -181,    59,    59,    63,  -181,  -181,   136,  -181,   207,
     205,  -181,  -181,  -181,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,   210,    59,    63,  -181,   150,  -181,
      17,    19,   212,   209,   213,     2,  -181,   188,   195,    42,
     -14,   -14,    22,    22,  -181,  -181,  -181,  -181,    29,  -181,
     211,  -181,  -181,  -181,  -181,   214,  -181,   215,  -181,   219,
     216,    68,   220,   217,  -181,  -181,  -181,   222,    68,   221,
     223,  -181,  -181,  -181,  -181,   224,   242,   214,    -6,  -181,
     225,   242,   216,   191,   226,   228,  -181,  -181,   242,   242,
    -181,  -181,   191,   230,  -181,   280,    59,  -181,   234,   235,
      63,  -181,  -181,    63,    66,   218,  -181,  -181,  -181,  -181,
      59,  -181,   218
};

/* YYDEFACT[STATE-NUM] -- Default reduction number in state STATE-NUM.
   Performed when YYTABLE does not specify something else to do.  Zero
   means the default is an error.  */
static const yytype_uint8 yydefact[] =
{
       3,   178,     1,     0,   177,     2,     4,     5,     6,     7,
       8,     9,    10,    11,    12,    13,    14,    15,    16,   106,
     174,   175,   176,   173,    17,   105,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     3,    64,    19,    97,
      97,    84,     0,    97,     0,   166,   153,   154,   163,   162,
     161,   159,   157,     0,   155,   164,   165,     0,   152,     0,
     168,   172,   178,     0,     0,     0,    32,    96,   104,    37,
       0,    69,     0,     0,    28,    26,   171,     0,   160,   158,
     156,     0,     0,     0,     0,    67,   178,    98,     0,     0,
      87,    72,     0,    94,     0,     0,     0,    63,   170,     0,
     151,    18,   178,     0,    23,     0,    35,    40,   178,    74,
       0,     0,     0,    31,    35,   167,     0,   169,     0,    66,
       0,     0,   178,    24,   178,   178,     0,    86,    88,    89,
      90,   108,   178,    70,     0,     0,     0,   178,   150,    65,
       0,    20,    22,     0,     0,    34,     0,     0,    39,    41,
      42,    43,   108,    85,     0,     0,   107,    71,    73,     0,
       0,    30,    35,     0,     0,   145,   146,   147,   148,     0,
       0,     0,     0,    25,   123,   125,   127,   129,   132,   135,
     139,   143,   149,    33,     0,    38,     0,   107,     0,   112,
     113,   114,   115,   116,   117,   118,   119,   120,   121,   122,
       0,   111,     0,     0,     0,    75,    95,   178,    27,     0,
       0,   140,   141,   142,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    53,     0,   109,
       0,     0,     0,     0,     0,     0,   144,   124,   126,   128,
     130,   131,   133,   134,   136,   137,   138,    36,     0,    45,
       0,   110,    92,    91,    93,    78,    29,     0,    44,    48,
      56,     0,     0,    77,    80,    68,    50,     0,     0,     0,
      55,    58,    60,    62,    61,     0,   100,     0,     0,    46,
       0,   100,     0,     0,     0,     0,    99,    79,     0,     0,
      47,    49,     0,     0,    57,    83,     0,    76,     0,     0,
       0,    54,    82,     0,     0,   103,    51,    52,    59,    81,
       0,   101,   102
};

/* YYPGOTO[NTERM-NUM].  */
static const yytype_int16 yypgoto[] =
{
    -181,   251,  -181,  -181,  -181,  -181,  -181,  -181,   172,  -181,
    -181,  -181,  -181,  -181,  -181,  -181,  -102,  -181,  -181,  -181,
    -181,  -181,  -181,  -181,  -181,  -181,  -181,  -181,  -181,  -181,
    -181,  -181,    13,    28,  -181,  -181,  -181,  -181,  -181,  -181,
    -181,  -181,  -181,  -181,  -181,  -181,  -181,    21,  -181,  -181,
    -181,  -181,  -181,  -181,  -181,  -181,  -181,  -181,   151,   116,
      18,  -180,  -181,  -181,  -181,   152,   153,  -181,    73,  -166,
    -181,    88,    91,    93,   -41,    -9,   -24,    49,  -181,   -76,
     -33,    -3,     4
};

/* YYDEFGOTO[NTERM-NUM].  */
static const yytype_int16 yydefgoto[] =
{
       0,     1,     5,     6,    27,     7,    64,   103,   104,     8,
      95,     9,    94,   112,    10,    88,   124,   145,    11,    89,
     125,   148,   149,   150,   259,   267,   278,   291,   151,   250,
     269,   270,   271,   275,    12,    13,    63,   102,   119,    14,
      91,   110,   132,   158,   233,   262,   263,   264,   303,    15,
      70,   108,   127,   128,   129,   130,    16,    17,    66,    67,
     285,   286,   304,    18,    26,   155,   156,   200,   201,   173,
     174,   175,   176,   177,   178,   179,   180,   181,    99,    59,
     182,    61,   146
};

/* YYTABLE[YYPACT[STATE-NUM]] -- What to do in state STATE-NUM.  If
   positive, shift that token.  If negative, reduce the rule whose
   number is the opposite.  If YYTABLE_NINF, syntax error.  */
static const yytype_int16 yytable[] =
{
      24,    96,    60,   210,    82,    19,    44,   100,     2,   165,
     166,    68,   137,    82,   116,     4,   288,   117,   118,     3,
      65,    82,   202,    82,    20,    37,    38,    39,    40,    41,
      42,    43,    87,    82,    25,   289,   203,    21,    72,     3,
     138,    76,     4,    22,    60,    84,    74,   217,   218,    65,
      60,   290,    65,    23,   167,   168,    81,   219,   220,   111,
     207,    83,     4,    44,   164,   169,    19,   134,    44,   257,
     184,   165,   166,   170,   171,   252,   188,   253,   172,    98,
     204,    20,   228,    60,    78,    20,    20,   258,    79,   229,
     105,   113,   272,   273,    21,   221,   222,   223,    21,    21,
      22,   274,   123,    80,    22,    22,   120,    60,   298,   299,
      23,   226,   131,    60,    23,    23,   167,   168,    36,    60,
      65,     4,    92,    60,   126,   310,   105,   169,    44,   152,
     311,   135,   161,    45,   136,    46,   159,    47,    48,    77,
       4,     4,    49,   144,   147,    50,    20,    51,    85,     4,
       4,    52,   157,   -21,    60,   -21,   205,    71,    73,    21,
     189,   209,   190,    53,    86,    22,    54,   191,    55,   230,
     231,    56,    93,    57,    58,    23,   240,   241,   192,   193,
     194,   224,   195,     4,   196,   227,   163,   197,   198,   154,
       4,    69,   248,   234,    75,    44,   199,   244,   245,   246,
      45,   232,    46,    90,    47,    48,   121,   295,   122,    49,
     242,   243,    50,    20,    51,    97,   300,   101,    52,   211,
     212,   213,    82,   249,    28,   106,    21,    29,    30,   107,
      53,   109,    22,    54,    31,    55,   114,   133,    56,   115,
      57,    58,    23,   139,   140,   141,     4,   154,    32,   143,
      60,    33,   153,    34,   160,   162,    35,   215,   183,    60,
     185,   206,   208,   305,   214,   216,   225,   235,   247,   236,
     254,   256,   255,   265,   260,   266,   277,   312,   284,   261,
     279,   268,   282,   302,   276,   281,   297,    62,   301,   296,
     283,   292,   306,   307,   142,   294,   280,   308,   287,   293,
     309,   251,   237,     0,   186,   187,   238,     0,     0,   239
};

static const yytype_int16 yycheck[] =
{
       3,    77,    35,   169,     4,     1,     4,    83,     0,     7,
       8,    58,   114,     4,    59,    54,    22,    62,    57,    31,
      67,     4,    26,     4,    22,    28,    29,    30,    31,    32,
      33,    34,    65,     4,    35,    41,    40,    35,    56,    31,
     116,    44,    54,    41,    77,    57,    61,     5,     6,    67,
      83,    57,    67,    51,    52,    53,    59,    71,    72,    92,
     162,    61,    54,     4,   140,    63,    62,    58,     4,   235,
     146,     7,     8,    71,    72,    58,   152,    58,    76,    82,
     156,    22,    59,   116,    23,    22,    22,    58,    27,    66,
      86,    94,    24,    25,    35,    73,    74,    75,    35,    35,
      41,    33,   105,    42,    41,    41,   102,   140,   288,   289,
      51,   187,   108,   146,    51,    51,    52,    53,    56,   152,
      67,    54,    40,   156,    57,    59,   122,    63,     4,   125,
      64,    59,   135,     9,    62,    11,   132,    13,    14,    61,
      54,    54,    18,    57,    57,    21,    22,    23,    56,    54,
      54,    27,    57,    57,   187,    59,   159,    41,    42,    35,
      10,   164,    12,    39,    56,    41,    42,    17,    44,   202,
     203,    47,    58,    49,    50,    51,   217,   218,    28,    29,
      30,   184,    32,    54,    34,   188,    57,    37,    38,    65,
      54,    40,   225,    57,    43,     4,    46,   221,   222,   223,
       9,   204,    11,    56,    13,    14,    57,   283,    59,    18,
     219,   220,    21,    22,    23,    58,   292,    58,    27,   170,
     171,   172,     4,   226,    16,    56,    35,    19,    20,    56,
      39,    56,    41,    42,    26,    44,    56,    58,    47,    62,
      49,    50,    51,    58,    15,    58,    54,    65,    40,    60,
     283,    43,    58,    45,    57,    56,    48,    69,    58,   292,
      58,    58,    58,   296,    68,    70,    26,    60,    58,    64,
      58,    58,    63,    58,    63,    56,    59,   310,    36,    65,
      58,    65,    59,     3,    64,    64,    58,    36,    58,    63,
      66,    66,    58,    58,   122,   282,   268,   300,   277,   281,
     303,   228,   214,    -1,   152,   152,   215,    -1,    -1,   216
};

/* YYSTOS[STATE-NUM] -- The symbol kind of the accessing symbol of
   state STATE-NUM.  */
static const yytype_uint8 yystos[] =
{
       0,    78,     0,    31,    54,    79,    80,    82,    86,    88,
      91,    95,   111,   112,   116,   126,   133,   134,   140,   159,
      22,    35,    41,    51,   158,    35,   141,    81,    16,    19,
      20,    26,    40,    43,    45,    48,    56,   158,   158,   158,
     158,   158,   158,   158,     4,     9,    11,    13,    14,    18,
      21,    23,    27,    39,    42,    44,    47,    49,    50,   156,
     157,   158,    78,   113,    83,    67,   135,   136,    58,   135,
     127,   136,    56,   136,    61,   135,   158,    61,    23,    27,
      42,   158,     4,    61,    57,    56,    56,   157,    92,    96,
      56,   117,    40,    58,    89,    87,   156,    58,   158,   155,
     156,    58,   114,    84,    85,   159,    56,    56,   128,    56,
     118,   157,    90,   158,    56,    62,    59,    62,    57,   115,
     159,    57,    59,   158,    93,    97,    57,   129,   130,   131,
     132,   159,   119,    58,    58,    59,    62,    93,   156,    58,
      15,    58,    85,    60,    57,    94,   159,    57,    98,    99,
     100,   105,   159,    58,    65,   142,   143,    57,   120,   159,
      57,   158,    56,    57,   156,     7,     8,    52,    53,    63,
      71,    72,    76,   146,   147,   148,   149,   150,   151,   152,
     153,   154,   157,    58,   156,    58,   142,   143,   156,    10,
      12,    17,    28,    29,    30,    32,    34,    37,    38,    46,
     144,   145,    26,    40,   156,   158,    58,    93,    58,   158,
     146,   154,   154,   154,    68,    69,    70,     5,     6,    71,
      72,    73,    74,    75,   158,    26,   156,   158,    59,    66,
     157,   157,   158,   121,    57,    60,    64,   148,   149,   150,
     151,   151,   152,   152,   153,   153,   153,    58,   157,   158,
     106,   145,    58,    58,    58,    63,    58,   146,    58,   101,
      63,    65,   122,   123,   124,    58,    56,   102,    65,   107,
     108,   109,    24,    25,    33,   110,    64,    59,   103,    58,
     110,    64,    59,    66,    36,   137,   138,   124,    22,    41,
      57,   104,    66,   137,   109,   156,    63,    58,   138,   138,
     156,    58,     3,   125,   139,   157,    58,    58,   158,   158,
      59,    64,   157
};

/* YYR1[RULE-NUM] -- Symbol kind of the left-hand side of rule RULE-NUM.  */
static const yytype_uint8 yyr1[] =
{
       0,    77,    78,    78,    79,    79,    79,    79,    79,    79,
      79,    79,    79,    79,    79,    79,    79,    81,    80,    83,
      82,    84,    84,    84,    85,    85,    87,    86,    89,    88,
      90,    90,    92,    91,    93,    93,    94,    96,    95,    97,
      97,    98,    98,    98,    99,   101,   100,   102,   102,   103,
     103,   104,   104,   106,   105,   107,   107,   108,   108,   109,
     110,   110,   110,   111,   113,   112,   114,   114,   115,   117,
     116,   118,   118,   119,   119,   121,   120,   122,   122,   123,
     123,   124,   125,   125,   127,   126,   128,   128,   129,   129,
     129,   130,   131,   132,   133,   134,   135,   135,   136,   137,
     137,   138,   139,   139,   140,   141,   141,   142,   142,   143,
     144,   144,   145,   145,   145,   145,   145,   145,   145,   145,
     145,   145,   145,   146,   147,   147,   148,   148,   149,   149,
     150,   150,   150,   151,   151,   151,   152,   152,   152,   152,
     153,   153,   153,   153,   154,   154,   154,   154,   154,   154,
     155,   155,   156,   156,   156,   156,   156,   156,   156,   156,
     156,   156,   156,   156,   156,   156,   156,   156,   156,   156,
     157,   157,   157,   158,   158,   158,   158,   159,   159
};

/* YYR2[RULE-NUM] -- Number of symbols on the right-hand side of rule RULE-NUM.  */
static const yytype_int8 yyr2[] =
{
       0,     2,     2,     0,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     0,     7,     0,
       9,     0,     3,     1,     2,     4,     0,    10,     0,    12,
       3,     1,     0,    10,     2,     0,     4,     0,    10,     2,
       0,     1,     1,     1,     5,     0,     7,     3,     0,     2,
       0,     3,     3,     0,     9,     1,     0,     3,     1,     5,
       1,     1,     1,     6,     0,     9,     2,     0,     7,     0,
       8,     3,     0,     2,     0,     0,     8,     1,     0,     3,
       1,     6,     1,     0,     0,     9,     2,     0,     1,     1,
       1,     5,     5,     5,     6,    10,     1,     0,     2,     1,
       0,     4,     3,     1,     5,     1,     0,     1,     0,     3,
       3,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     3,     1,     3,     1,     3,     1,
       3,     3,     1,     3,     3,     1,     3,     3,     3,     1,
       2,     2,     2,     1,     3,     1,     1,     1,     1,     1,
       3,     1,     1,     1,     1,     1,     2,     1,     2,     1,
       2,     1,     1,     1,     1,     1,     1,     4,     1,     4,
       3,     2,     1,     1,     1,     1,     1,     1,     0
};


enum { YYENOMEM = -2 };

#define yyerrok         (yyerrstatus = 0)
#define yyclearin       (yychar = YYEMPTY)

#define YYACCEPT        goto yyacceptlab
#define YYABORT         goto yyabortlab
#define YYERROR         goto yyerrorlab
#define YYNOMEM         goto yyexhaustedlab


#define YYRECOVERING()  (!!yyerrstatus)

#define YYBACKUP(Token, Value)                                    \
  do                                                              \
    if (yychar == YYEMPTY)                                        \
      {                                                           \
        yychar = (Token);                                         \
        yylval = (Value);                                         \
        YYPOPSTACK (yylen);                                       \
        yystate = *yyssp;                                         \
        goto yybackup;                                            \
      }                                                           \
    else                                                          \
      {                                                           \
        yyerror (&yylloc, yyscanner, YY_("syntax error: cannot back up")); \
        YYERROR;                                                  \
      }                                                           \
  while (0)

/* Backward compatibility with an undocumented macro.
   Use YYerror or YYUNDEF. */
#define YYERRCODE YYUNDEF

/* YYLLOC_DEFAULT -- Set CURRENT to span from RHS[1] to RHS[N].
   If N is 0, then set CURRENT to the empty location which ends
   the previous symbol: RHS[0] (always defined).  */

#ifndef YYLLOC_DEFAULT
# define YYLLOC_DEFAULT(Current, Rhs, N)                                \
    do                                                                  \
      if (N)                                                            \
        {                                                               \
          (Current).first_line   = YYRHSLOC (Rhs, 1).first_line;        \
          (Current).first_column = YYRHSLOC (Rhs, 1).first_column;      \
          (Current).last_line    = YYRHSLOC (Rhs, N).last_line;         \
          (Current).last_column  = YYRHSLOC (Rhs, N).last_column;       \
        }                                                               \
      else                                                              \
        {                                                               \
          (Current).first_line   = (Current).last_line   =              \
            YYRHSLOC (Rhs, 0).last_line;                                \
          (Current).first_column = (Current).last_column =              \
            YYRHSLOC (Rhs, 0).last_column;                              \
        }                                                               \
    while (0)
#endif

#define YYRHSLOC(Rhs, K) ((Rhs)[K])


/* Enable debugging if requested.  */
#if YYDEBUG

# ifndef YYFPRINTF
#  include <stdio.h> /* INFRINGES ON USER NAME SPACE */
#  define YYFPRINTF fprintf
# endif

# define YYDPRINTF(Args)                        \
do {                                            \
  if (yydebug)                                  \
    YYFPRINTF Args;                             \
} while (0)


/* YYLOCATION_PRINT -- Print the location on the stream.
   This macro was not mandated originally: define only if we know
   we won't break user code: when these are the locations we know.  */

# ifndef YYLOCATION_PRINT

#  if defined YY_LOCATION_PRINT

   /* Temporary convenience wrapper in case some people defined the
      undocumented and private YY_LOCATION_PRINT macros.  */
#   define YYLOCATION_PRINT(File, Loc)  YY_LOCATION_PRINT(File, *(Loc))

#  elif defined YYLTYPE_IS_TRIVIAL && YYLTYPE_IS_TRIVIAL

/* Print *YYLOCP on YYO.  Private, do not rely on its existence. */

YY_ATTRIBUTE_UNUSED
static int
yy_location_print_ (FILE *yyo, YYLTYPE const * const yylocp)
{
  int res = 0;
  int end_col = 0 != yylocp->last_column ? yylocp->last_column - 1 : 0;
  if (0 <= yylocp->first_line)
    {
      res += YYFPRINTF (yyo, "%d", yylocp->first_line);
      if (0 <= yylocp->first_column)
        res += YYFPRINTF (yyo, ".%d", yylocp->first_column);
    }
  if (0 <= yylocp->last_line)
    {
      if (yylocp->first_line < yylocp->last_line)
        {
          res += YYFPRINTF (yyo, "-%d", yylocp->last_line);
          if (0 <= end_col)
            res += YYFPRINTF (yyo, ".%d", end_col);
        }
      else if (0 <= end_col && yylocp->first_column < end_col)
        res += YYFPRINTF (yyo, "-%d", end_col);
    }
  return res;
}

#   define YYLOCATION_PRINT  yy_location_print_

    /* Temporary convenience wrapper in case some people defined the
       undocumented and private YY_LOCATION_PRINT macros.  */
#   define YY_LOCATION_PRINT(File, Loc)  YYLOCATION_PRINT(File, &(Loc))

#  else

#   define YYLOCATION_PRINT(File, Loc) ((void) 0)
    /* Temporary convenience wrapper in case some people defined the
       undocumented and private YY_LOCATION_PRINT macros.  */
#   define YY_LOCATION_PRINT  YYLOCATION_PRINT

#  endif
# endif /* !defined YYLOCATION_PRINT */


# define YY_SYMBOL_PRINT(Title, Kind, Value, Location)                    \
do {                                                                      \
  if (yydebug)                                                            \
    {                                                                     \
      YYFPRINTF (stderr, "%s ", Title);                                   \
      yy_symbol_print (stderr,                                            \
                  Kind, Value, Location, yyscanner); \
      YYFPRINTF (stderr, "\n");                                           \
    }                                                                     \
} while (0)


/*-----------------------------------.
| Print this symbol's value on YYO.  |
`-----------------------------------*/

static void
yy_symbol_value_print (FILE *yyo,
                       yysymbol_kind_t yykind, YYSTYPE const * const yyvaluep, YYLTYPE const * const yylocationp, yyscan_t yyscanner)
{
  FILE *yyoutput = yyo;
  YY_USE (yyoutput);
  YY_USE (yylocationp);
  YY_USE (yyscanner);
  if (!yyvaluep)
    return;
  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  YY_USE (yykind);
  YY_IGNORE_MAYBE_UNINITIALIZED_END
}


/*---------------------------.
| Print this symbol on YYO.  |
`---------------------------*/

static void
yy_symbol_print (FILE *yyo,
                 yysymbol_kind_t yykind, YYSTYPE const * const yyvaluep, YYLTYPE const * const yylocationp, yyscan_t yyscanner)
{
  YYFPRINTF (yyo, "%s %s (",
             yykind < YYNTOKENS ? "token" : "nterm", yysymbol_name (yykind));

  YYLOCATION_PRINT (yyo, yylocationp);
  YYFPRINTF (yyo, ": ");
  yy_symbol_value_print (yyo, yykind, yyvaluep, yylocationp, yyscanner);
  YYFPRINTF (yyo, ")");
}

/*------------------------------------------------------------------.
| yy_stack_print -- Print the state stack from its BOTTOM up to its |
| TOP (included).                                                   |
`------------------------------------------------------------------*/

static void
yy_stack_print (yy_state_t *yybottom, yy_state_t *yytop)
{
  YYFPRINTF (stderr, "Stack now");
  for (; yybottom <= yytop; yybottom++)
    {
      int yybot = *yybottom;
      YYFPRINTF (stderr, " %d", yybot);
    }
  YYFPRINTF (stderr, "\n");
}

# define YY_STACK_PRINT(Bottom, Top)                            \
do {                                                            \
  if (yydebug)                                                  \
    yy_stack_print ((Bottom), (Top));                           \
} while (0)


/*------------------------------------------------.
| Report that the YYRULE is going to be reduced.  |
`------------------------------------------------*/

static void
yy_reduce_print (yy_state_t *yyssp, YYSTYPE *yyvsp, YYLTYPE *yylsp,
                 int yyrule, yyscan_t yyscanner)
{
  int yylno = yyrline[yyrule];
  int yynrhs = yyr2[yyrule];
  int yyi;
  YYFPRINTF (stderr, "Reducing stack by rule %d (line %d):\n",
             yyrule - 1, yylno);
  /* The symbols being reduced.  */
  for (yyi = 0; yyi < yynrhs; yyi++)
    {
      YYFPRINTF (stderr, "   $%d = ", yyi + 1);
      yy_symbol_print (stderr,
                       YY_ACCESSING_SYMBOL (+yyssp[yyi + 1 - yynrhs]),
                       &yyvsp[(yyi + 1) - (yynrhs)],
                       &(yylsp[(yyi + 1) - (yynrhs)]), yyscanner);
      YYFPRINTF (stderr, "\n");
    }
}

# define YY_REDUCE_PRINT(Rule)          \
do {                                    \
  if (yydebug)                          \
    yy_reduce_print (yyssp, yyvsp, yylsp, Rule, yyscanner); \
} while (0)

/* Nonzero means print parse trace.  It is left uninitialized so that
   multiple parsers can coexist.  */
int yydebug;
#else /* !YYDEBUG */
# define YYDPRINTF(Args) ((void) 0)
# define YY_SYMBOL_PRINT(Title, Kind, Value, Location)
# define YY_STACK_PRINT(Bottom, Top)
# define YY_REDUCE_PRINT(Rule)
#endif /* !YYDEBUG */


/* YYINITDEPTH -- initial size of the parser's stacks.  */
#ifndef YYINITDEPTH
# define YYINITDEPTH 200
#endif

/* YYMAXDEPTH -- maximum size the stacks can grow to (effective only
   if the built-in stack extension method is used).

   Do not make this value too large; the results are undefined if
   YYSTACK_ALLOC_MAXIMUM < YYSTACK_BYTES (YYMAXDEPTH)
   evaluated with infinite-precision integer arithmetic.  */

#ifndef YYMAXDEPTH
# define YYMAXDEPTH 10000
#endif






/*-----------------------------------------------.
| Release the memory associated to this symbol.  |
`-----------------------------------------------*/

static void
yydestruct (const char *yymsg,
            yysymbol_kind_t yykind, YYSTYPE *yyvaluep, YYLTYPE *yylocationp, yyscan_t yyscanner)
{
  YY_USE (yyvaluep);
  YY_USE (yylocationp);
  YY_USE (yyscanner);
  if (!yymsg)
    yymsg = "Deleting";
  YY_SYMBOL_PRINT (yymsg, yykind, yyvaluep, yylocationp);

  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  YY_USE (yykind);
  YY_IGNORE_MAYBE_UNINITIALIZED_END
}






/*----------.
| yyparse.  |
`----------*/

int
yyparse (yyscan_t yyscanner)
{
/* Lookahead token kind.  */
int yychar;


/* The semantic value of the lookahead symbol.  */
/* Default value used for initialization, for pacifying older GCCs
   or non-GCC compilers.  */
YY_INITIAL_VALUE (static YYSTYPE yyval_default;)
YYSTYPE yylval YY_INITIAL_VALUE (= yyval_default);

/* Location data for the lookahead symbol.  */
static YYLTYPE yyloc_default
# if defined YYLTYPE_IS_TRIVIAL && YYLTYPE_IS_TRIVIAL
  = { 1, 1, 1, 1 }
# endif
;
YYLTYPE yylloc = yyloc_default;

    /* Number of syntax errors so far.  */
    int yynerrs = 0;

    yy_state_fast_t yystate = 0;
    /* Number of tokens to shift before error messages enabled.  */
    int yyerrstatus = 0;

    /* Refer to the stacks through separate pointers, to allow yyoverflow
       to reallocate them elsewhere.  */

    /* Their size.  */
    YYPTRDIFF_T yystacksize = YYINITDEPTH;

    /* The state stack: array, bottom, top.  */
    yy_state_t yyssa[YYINITDEPTH];
    yy_state_t *yyss = yyssa;
    yy_state_t *yyssp = yyss;

    /* The semantic value stack: array, bottom, top.  */
    YYSTYPE yyvsa[YYINITDEPTH];
    YYSTYPE *yyvs = yyvsa;
    YYSTYPE *yyvsp = yyvs;

    /* The location stack: array, bottom, top.  */
    YYLTYPE yylsa[YYINITDEPTH];
    YYLTYPE *yyls = yylsa;
    YYLTYPE *yylsp = yyls;

  int yyn;
  /* The return value of yyparse.  */
  int yyresult;
  /* Lookahead symbol kind.  */
  yysymbol_kind_t yytoken = YYSYMBOL_YYEMPTY;
  /* The variables used to return semantic value and location from the
     action routines.  */
  YYSTYPE yyval;
  YYLTYPE yyloc;

  /* The locations where the error started and ended.  */
  YYLTYPE yyerror_range[3];



#define YYPOPSTACK(N)   (yyvsp -= (N), yyssp -= (N), yylsp -= (N))

  /* The number of symbols on the RHS of the reduced rule.
     Keep to zero when no symbol should be popped.  */
  int yylen = 0;

  YYDPRINTF ((stderr, "Starting parse\n"));

  yychar = YYEMPTY; /* Cause a token to be read.  */


/* User initialization code.  */
#line 946 "/build/libreoffice-still/src/libreoffice-25.8.5.2/unoidl/source/sourceprovider-parser.y"
{ yylloc = 1; }

#line 2226 "/build/libreoffice-still/src/libreoffice-25.8.5.2/workdir/YaccTarget/unoidl/source/sourceprovider-parser.cxx"

  yylsp[0] = yylloc;
  goto yysetstate;


/*------------------------------------------------------------.
| yynewstate -- push a new state, which is found in yystate.  |
`------------------------------------------------------------*/
yynewstate:
  /* In all cases, when you get here, the value and location stacks
     have just been pushed.  So pushing a state here evens the stacks.  */
  yyssp++;


/*--------------------------------------------------------------------.
| yysetstate -- set current state (the top of the stack) to yystate.  |
`--------------------------------------------------------------------*/
yysetstate:
  YYDPRINTF ((stderr, "Entering state %d\n", yystate));
  YY_ASSERT (0 <= yystate && yystate < YYNSTATES);
  YY_IGNORE_USELESS_CAST_BEGIN
  *yyssp = YY_CAST (yy_state_t, yystate);
  YY_IGNORE_USELESS_CAST_END
  YY_STACK_PRINT (yyss, yyssp);

  if (yyss + yystacksize - 1 <= yyssp)
#if !defined yyoverflow && !defined YYSTACK_RELOCATE
    YYNOMEM;
#else
    {
      /* Get the current used size of the three stacks, in elements.  */
      YYPTRDIFF_T yysize = yyssp - yyss + 1;

# if defined yyoverflow
      {
        /* Give user a chance to reallocate the stack.  Use copies of
           these so that the &'s don't force the real ones into
           memory.  */
        yy_state_t *yyss1 = yyss;
        YYSTYPE *yyvs1 = yyvs;
        YYLTYPE *yyls1 = yyls;

        /* Each stack pointer address is followed by the size of the
           data in use in that stack, in bytes.  This used to be a
           conditional around just the two extra args, but that might
           be undefined if yyoverflow is a macro.  */
        yyoverflow (YY_("memory exhausted"),
                    &yyss1, yysize * YYSIZEOF (*yyssp),
                    &yyvs1, yysize * YYSIZEOF (*yyvsp),
                    &yyls1, yysize * YYSIZEOF (*yylsp),
                    &yystacksize);
        yyss = yyss1;
        yyvs = yyvs1;
        yyls = yyls1;
      }
# else /* defined YYSTACK_RELOCATE */
      /* Extend the stack our own way.  */
      if (YYMAXDEPTH <= yystacksize)
        YYNOMEM;
      yystacksize *= 2;
      if (YYMAXDEPTH < yystacksize)
        yystacksize = YYMAXDEPTH;

      {
        yy_state_t *yyss1 = yyss;
        union yyalloc *yyptr =
          YY_CAST (union yyalloc *,
                   YYSTACK_ALLOC (YY_CAST (YYSIZE_T, YYSTACK_BYTES (yystacksize))));
        if (! yyptr)
          YYNOMEM;
        YYSTACK_RELOCATE (yyss_alloc, yyss);
        YYSTACK_RELOCATE (yyvs_alloc, yyvs);
        YYSTACK_RELOCATE (yyls_alloc, yyls);
#  undef YYSTACK_RELOCATE
        if (yyss1 != yyssa)
          YYSTACK_FREE (yyss1);
      }
# endif

      yyssp = yyss + yysize - 1;
      yyvsp = yyvs + yysize - 1;
      yylsp = yyls + yysize - 1;

      YY_IGNORE_USELESS_CAST_BEGIN
      YYDPRINTF ((stderr, "Stack size increased to %ld\n",
                  YY_CAST (long, yystacksize)));
      YY_IGNORE_USELESS_CAST_END

      if (yyss + yystacksize - 1 <= yyssp)
        YYABORT;
    }
#endif /* !defined yyoverflow && !defined YYSTACK_RELOCATE */


  if (yystate == YYFINAL)
    YYACCEPT;

  goto yybackup;


/*-----------.
| yybackup.  |
`-----------*/
yybackup:
  /* Do appropriate processing given the current state.  Read a
     lookahead token if we need one and don't already have one.  */

  /* First try to decide what to do without reference to lookahead token.  */
  yyn = yypact[yystate];
  if (yypact_value_is_default (yyn))
    goto yydefault;

  /* Not known => get a lookahead token if don't already have one.  */

  /* YYCHAR is either empty, or end-of-input, or a valid lookahead.  */
  if (yychar == YYEMPTY)
    {
      YYDPRINTF ((stderr, "Reading a token\n"));
      yychar = yylex (&yylval, &yylloc, yyscanner);
    }

  if (yychar <= YYEOF)
    {
      yychar = YYEOF;
      yytoken = YYSYMBOL_YYEOF;
      YYDPRINTF ((stderr, "Now at end of input.\n"));
    }
  else if (yychar == YYerror)
    {
      /* The scanner already issued an error message, process directly
         to error recovery.  But do not keep the error token as
         lookahead, it is too special and may lead us to an endless
         loop in error recovery. */
      yychar = YYUNDEF;
      yytoken = YYSYMBOL_YYerror;
      yyerror_range[1] = yylloc;
      goto yyerrlab1;
    }
  else
    {
      yytoken = YYTRANSLATE (yychar);
      YY_SYMBOL_PRINT ("Next token is", yytoken, &yylval, &yylloc);
    }

  /* If the proper action on seeing token YYTOKEN is to reduce or to
     detect an error, take that action.  */
  yyn += yytoken;
  if (yyn < 0 || YYLAST < yyn || yycheck[yyn] != yytoken)
    goto yydefault;
  yyn = yytable[yyn];
  if (yyn <= 0)
    {
      if (yytable_value_is_error (yyn))
        goto yyerrlab;
      yyn = -yyn;
      goto yyreduce;
    }

  /* Count tokens shifted since error; after three, turn off error
     status.  */
  if (yyerrstatus)
    yyerrstatus--;

  /* Shift the lookahead token.  */
  YY_SYMBOL_PRINT ("Shifting", yytoken, &yylval, &yylloc);
  yystate = yyn;
  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  *++yyvsp = yylval;
  YY_IGNORE_MAYBE_UNINITIALIZED_END
  *++yylsp = yylloc;

  /* Discard the shifted token.  */
  yychar = YYEMPTY;
  goto yynewstate;


/*-----------------------------------------------------------.
| yydefault -- do the default action for the current state.  |
`-----------------------------------------------------------*/
yydefault:
  yyn = yydefact[yystate];
  if (yyn == 0)
    goto yyerrlab;
  goto yyreduce;


/*-----------------------------.
| yyreduce -- do a reduction.  |
`-----------------------------*/
yyreduce:
  /* yyn is the number of a rule to reduce with.  */
  yylen = yyr2[yyn];

  /* If YYLEN is nonzero, implement the default value of the action:
     '$$ = $1'.

     Otherwise, the following line sets YYVAL to garbage.
     This behavior is undocumented and Bison
     users should not rely upon it.  Assigning to YYVAL
     unconditionally makes the parser a bit smaller, and it avoids a
     GCC warning that YYVAL may be used uninitialized.  */
  yyval = yyvsp[1-yylen];

  /* Default location. */
  YYLLOC_DEFAULT (yyloc, (yylsp - yylen), yylen);
  yyerror_range[1] = yyloc;
  YY_REDUCE_PRINT (yyn);
  switch (yyn)
    {
  case 17: /* $@1: %empty  */
#line 973 "/build/libreoffice-still/src/libreoffice-25.8.5.2/unoidl/source/sourceprovider-parser.y"
  {
      unoidl::detail::SourceProviderScannerData * data = yyget_extra(yyscanner);
      OUString name(convertToFullName(data, (yyvsp[0].sval)));
      data->modules.push_back(name);
      std::pair<std::map<OUString, unoidl::detail::SourceProviderEntity>::iterator, bool> p(
          data->entities.emplace(
                  name,
                  unoidl::detail::SourceProviderEntity(
                      unoidl::detail::SourceProviderEntity::KIND_MODULE)));
      if (!p.second
          && (p.first->second.kind
              != unoidl::detail::SourceProviderEntity::KIND_MODULE))
      {
          error((yylsp[0]), yyscanner, "multiple entities named " + name);
          YYERROR;
      }
  }
#line 2455 "/build/libreoffice-still/src/libreoffice-25.8.5.2/workdir/YaccTarget/unoidl/source/sourceprovider-parser.cxx"
    break;

  case 18: /* moduleDecl: TOK_MODULE identifier $@1 '{' definitions '}' ';'  */
#line 990 "/build/libreoffice-still/src/libreoffice-25.8.5.2/unoidl/source/sourceprovider-parser.y"
                          { yyget_extra(yyscanner)->modules.pop_back(); }
#line 2461 "/build/libreoffice-still/src/libreoffice-25.8.5.2/workdir/YaccTarget/unoidl/source/sourceprovider-parser.cxx"
    break;

  case 19: /* $@2: %empty  */
#line 995 "/build/libreoffice-still/src/libreoffice-25.8.5.2/unoidl/source/sourceprovider-parser.y"
  {
      unoidl::detail::SourceProviderScannerData * data = yyget_extra(yyscanner);
      data->publishedContext = (yyvsp[-2].bval);
      convertToCurrentName(data, (yyvsp[0].sval));
      if (!data->entities.emplace(
                  data->currentName,
                  unoidl::detail::SourceProviderEntity(
                      new unoidl::detail::SourceProviderEnumTypeEntityPad(
                          (yyvsp[-2].bval)))).
          second)
      {
          error((yylsp[0]), yyscanner, "multiple entities named " + data->currentName);
          YYERROR;
      }
  }
#line 2481 "/build/libreoffice-still/src/libreoffice-25.8.5.2/workdir/YaccTarget/unoidl/source/sourceprovider-parser.cxx"
    break;

  case 20: /* enumDefn: deprecated_opt published_opt TOK_ENUM identifier $@2 '{' enumMembers '}' ';'  */
#line 1011 "/build/libreoffice-still/src/libreoffice-25.8.5.2/unoidl/source/sourceprovider-parser.y"
  {
      unoidl::detail::SourceProviderScannerData * data = yyget_extra(yyscanner);
      unoidl::detail::SourceProviderEntity * ent = getCurrentEntity(data);
      unoidl::detail::SourceProviderEnumTypeEntityPad * pad =
          dynamic_cast<unoidl::detail::SourceProviderEnumTypeEntityPad *>(
              ent->pad.get());
      assert(pad != nullptr);
      ent->entity = new unoidl::EnumTypeEntity(
          pad->isPublished(), std::move(pad->members), annotations((yyvsp[-8].bval)));
      ent->pad.clear();
      clearCurrentState(data);
  }
#line 2498 "/build/libreoffice-still/src/libreoffice-25.8.5.2/workdir/YaccTarget/unoidl/source/sourceprovider-parser.cxx"
    break;

  case 24: /* enumMember: deprecated_opt identifier  */
#line 1032 "/build/libreoffice-still/src/libreoffice-25.8.5.2/unoidl/source/sourceprovider-parser.y"
  {
      OUString id(convertName((yyvsp[0].sval)));
      unoidl::detail::SourceProviderScannerData * data = yyget_extra(yyscanner);
      rtl::Reference<unoidl::detail::SourceProviderEnumTypeEntityPad> pad(
          getCurrentPad<unoidl::detail::SourceProviderEnumTypeEntityPad>(data));
      sal_Int32 v;
      if (pad->members.empty()) {
          v = 0;
      } else {
          v = pad->members.back().value;
          if (v == SAL_MAX_INT32) {
              error(
                  (yylsp[0]), yyscanner,
                  ("enum " + data->currentName + " member " + id
                   + " would have out-of-range value 2^31"));
              YYERROR;
          }
          ++v;
      }
      pad->members.emplace_back(id, v, annotations((yyvsp[-1].bval)));
  }
#line 2524 "/build/libreoffice-still/src/libreoffice-25.8.5.2/workdir/YaccTarget/unoidl/source/sourceprovider-parser.cxx"
    break;

  case 25: /* enumMember: deprecated_opt identifier '=' expr  */
#line 1054 "/build/libreoffice-still/src/libreoffice-25.8.5.2/unoidl/source/sourceprovider-parser.y"
  {
      OUString id(convertName((yyvsp[-2].sval)));
      unoidl::detail::SourceProviderScannerData * data = yyget_extra(yyscanner);
      rtl::Reference<unoidl::detail::SourceProviderEnumTypeEntityPad> pad(
          getCurrentPad<unoidl::detail::SourceProviderEnumTypeEntityPad>(data));
      sal_Int32 v;
      switch ((yyvsp[0].expr).type) {
      case unoidl::detail::SourceProviderExpr::TYPE_INT:
          if ((yyvsp[0].expr).ival < SAL_MIN_INT32 || (yyvsp[0].expr).ival > SAL_MAX_INT32) {
              error(
                  (yylsp[0]), yyscanner,
                  ("out-of-range enum " + data->currentName + " member " + id
                   + " value " + OUString::number((yyvsp[0].expr).ival)));
              YYERROR;
          }
          v = static_cast<sal_Int32>((yyvsp[0].expr).ival);
          break;
      case unoidl::detail::SourceProviderExpr::TYPE_UINT:
          if ((yyvsp[0].expr).uval > SAL_MAX_INT32) {
              error(
                  (yylsp[0]), yyscanner,
                  ("out-of-range enum " + data->currentName + " member " + id
                   + " value " + OUString::number((yyvsp[0].expr).uval)));
              YYERROR;
          }
          v = static_cast<sal_Int32>((yyvsp[0].expr).uval);
          break;
      default:
          error(
              (yylsp[0]), yyscanner,
              ("non-integer enum " + data->currentName + " member " + id
               + " value"));
          YYERROR;
          break;
      }
      pad->members.emplace_back(id, v, annotations((yyvsp[-3].bval)));
  }
#line 2566 "/build/libreoffice-still/src/libreoffice-25.8.5.2/workdir/YaccTarget/unoidl/source/sourceprovider-parser.cxx"
    break;

  case 26: /* $@3: %empty  */
#line 1095 "/build/libreoffice-still/src/libreoffice-25.8.5.2/unoidl/source/sourceprovider-parser.y"
  {
      unoidl::detail::SourceProviderScannerData * data = yyget_extra(yyscanner);
      data->publishedContext = (yyvsp[-3].bval);
      convertToCurrentName(data, (yyvsp[-1].sval));
      OUString baseName;
      rtl::Reference<unoidl::PlainStructTypeEntity> baseEnt;
      if ((yyvsp[0].sval) != nullptr) {
          baseName = convertName((yyvsp[0].sval));
          unoidl::detail::SourceProviderEntity const * p;
          if (findEntity(
                  (yylsp[0]), yyscanner, data, false, &baseName, &p, nullptr, nullptr)
              == FOUND_ERROR)
          {
              YYERROR;
          }
          if (p == nullptr || !p->entity.is()
              || p->entity->getSort() != unoidl::Entity::SORT_PLAIN_STRUCT_TYPE)
          {
              error(
                  (yylsp[0]), yyscanner,
                  ("plain struct type " + data->currentName + " base "
                   + baseName
                   + " does not resolve to an existing plain struct type"));
              YYERROR;
          }
          baseEnt = static_cast<unoidl::PlainStructTypeEntity *>(
              p->entity.get());
          if ((yyvsp[-3].bval) && !baseEnt->isPublished()) {
              error(
                  (yylsp[0]), yyscanner,
                  ("published plain struct type " + data->currentName + " base "
                   + baseName + " is unpublished"));
              YYERROR;
          }
      }
      if (!data->entities.emplace(
                  data->currentName,
                  unoidl::detail::SourceProviderEntity(
                      new unoidl::detail::SourceProviderPlainStructTypeEntityPad(
                          (yyvsp[-3].bval), baseName, baseEnt))).
          second)
      {
          error((yylsp[-1]), yyscanner, "multiple entities named " + data->currentName);
          YYERROR;
      }
  }
#line 2617 "/build/libreoffice-still/src/libreoffice-25.8.5.2/workdir/YaccTarget/unoidl/source/sourceprovider-parser.cxx"
    break;

  case 27: /* plainStructDefn: deprecated_opt published_opt TOK_STRUCT identifier singleInheritance_opt $@3 '{' structMembers '}' ';'  */
#line 1142 "/build/libreoffice-still/src/libreoffice-25.8.5.2/unoidl/source/sourceprovider-parser.y"
  {
      unoidl::detail::SourceProviderScannerData * data = yyget_extra(yyscanner);
      unoidl::detail::SourceProviderEntity * ent = getCurrentEntity(data);
      unoidl::detail::SourceProviderPlainStructTypeEntityPad * pad =
          dynamic_cast<
              unoidl::detail::SourceProviderPlainStructTypeEntityPad *>(
                  ent->pad.get());
      assert(pad != nullptr);
      ent->entity = new unoidl::PlainStructTypeEntity(
          pad->isPublished(), pad->baseName, std::move(pad->members), annotations((yyvsp[-9].bval)));
      ent->pad.clear();
      clearCurrentState(data);
  }
#line 2635 "/build/libreoffice-still/src/libreoffice-25.8.5.2/workdir/YaccTarget/unoidl/source/sourceprovider-parser.cxx"
    break;

  case 28: /* $@4: %empty  */
#line 1159 "/build/libreoffice-still/src/libreoffice-25.8.5.2/unoidl/source/sourceprovider-parser.y"
  {
      unoidl::detail::SourceProviderScannerData * data = yyget_extra(yyscanner);
      data->publishedContext = (yyvsp[-3].bval);
      convertToCurrentName(data, (yyvsp[-1].sval));
      if (!data->entities.emplace(
                  data->currentName,
                  unoidl::detail::SourceProviderEntity(
                      new unoidl::detail::SourceProviderPolymorphicStructTypeTemplateEntityPad(
                          (yyvsp[-3].bval)))).
          second)
      {
          error((yylsp[-1]), yyscanner, "multiple entities named " + data->currentName);
          YYERROR;
      }
  }
#line 2655 "/build/libreoffice-still/src/libreoffice-25.8.5.2/workdir/YaccTarget/unoidl/source/sourceprovider-parser.cxx"
    break;

  case 29: /* polymorphicStructTemplateDefn: deprecated_opt published_opt TOK_STRUCT identifier '<' $@4 typeParameters '>' '{' structMembers '}' ';'  */
#line 1175 "/build/libreoffice-still/src/libreoffice-25.8.5.2/unoidl/source/sourceprovider-parser.y"
  {
      unoidl::detail::SourceProviderScannerData * data = yyget_extra(yyscanner);
      unoidl::detail::SourceProviderEntity * ent = getCurrentEntity(data);
      unoidl::detail::SourceProviderPolymorphicStructTypeTemplateEntityPad *
          pad = dynamic_cast<
              unoidl::detail::SourceProviderPolymorphicStructTypeTemplateEntityPad *>(
                  ent->pad.get());
      assert(pad != nullptr);
      ent->entity = new unoidl::PolymorphicStructTypeTemplateEntity(
          pad->isPublished(), std::move(pad->typeParameters), std::move(pad->members),
          annotations((yyvsp[-11].bval)));
      ent->pad.clear();
      clearCurrentState(data);
  }
#line 2674 "/build/libreoffice-still/src/libreoffice-25.8.5.2/workdir/YaccTarget/unoidl/source/sourceprovider-parser.cxx"
    break;

  case 30: /* typeParameters: typeParameters ',' identifier  */
#line 1193 "/build/libreoffice-still/src/libreoffice-25.8.5.2/unoidl/source/sourceprovider-parser.y"
  {
      unoidl::detail::SourceProviderScannerData * data = yyget_extra(yyscanner);
      rtl::Reference<unoidl::detail::SourceProviderPolymorphicStructTypeTemplateEntityPad>
          pad(getCurrentPad<unoidl::detail::SourceProviderPolymorphicStructTypeTemplateEntityPad>(
                  data));
      OUString id(convertName((yyvsp[0].sval)));
      if (std::find(pad->typeParameters.begin(), pad->typeParameters.end(), id)
          != pad->typeParameters.end())
      {
          error(
              (yylsp[0]), yyscanner,
              ("polymorphic struct type template " + data->currentName
               + " type parameter " + id
               + " has same identifier as another type parameter"));
          YYERROR;
      }
      pad->typeParameters.push_back(id);
  }
#line 2697 "/build/libreoffice-still/src/libreoffice-25.8.5.2/workdir/YaccTarget/unoidl/source/sourceprovider-parser.cxx"
    break;

  case 31: /* typeParameters: identifier  */
#line 1212 "/build/libreoffice-still/src/libreoffice-25.8.5.2/unoidl/source/sourceprovider-parser.y"
  {
      unoidl::detail::SourceProviderScannerData * data = yyget_extra(yyscanner);
      rtl::Reference<unoidl::detail::SourceProviderPolymorphicStructTypeTemplateEntityPad>
          pad(getCurrentPad<unoidl::detail::SourceProviderPolymorphicStructTypeTemplateEntityPad>(
                  data));
      OUString id(convertName((yyvsp[0].sval)));
      assert(pad->typeParameters.empty());
      pad->typeParameters.push_back(id);
  }
#line 2711 "/build/libreoffice-still/src/libreoffice-25.8.5.2/workdir/YaccTarget/unoidl/source/sourceprovider-parser.cxx"
    break;

  case 32: /* $@5: %empty  */
#line 1225 "/build/libreoffice-still/src/libreoffice-25.8.5.2/unoidl/source/sourceprovider-parser.y"
  {
      unoidl::detail::SourceProviderScannerData * data = yyget_extra(yyscanner);
      data->publishedContext = (yyvsp[-3].bval);
      convertToCurrentName(data, (yyvsp[-1].sval));
      OUString baseName;
      rtl::Reference<unoidl::ExceptionTypeEntity> baseEnt;
      if ((yyvsp[0].sval) != nullptr) {
          baseName = convertName((yyvsp[0].sval));
          unoidl::detail::SourceProviderEntity const * p;
          if (findEntity(
                  (yylsp[0]), yyscanner, data, false, &baseName, &p, nullptr, nullptr)
              == FOUND_ERROR)
          {
              YYERROR;
          }
          if (p == nullptr || !p->entity.is()
              || p->entity->getSort() != unoidl::Entity::SORT_EXCEPTION_TYPE)
          {
              error(
                  (yylsp[0]), yyscanner,
                  ("exception type " + data->currentName + " base " + baseName
                   + " does not resolve to an existing exception type"));
              YYERROR;
          }
          baseEnt = static_cast<unoidl::ExceptionTypeEntity *>(
              p->entity.get());
          if ((yyvsp[-3].bval) && !baseEnt->isPublished()) {
              error(
                  (yylsp[0]), yyscanner,
                  ("published exception type " + data->currentName + " base "
                   + baseName + " is unpublished"));
              YYERROR;
          }
      }
      if (!data->entities.emplace(
                  data->currentName,
                  unoidl::detail::SourceProviderEntity(
                      new unoidl::detail::SourceProviderExceptionTypeEntityPad(
                          (yyvsp[-3].bval), baseName, baseEnt))).
          second)
      {
          error((yylsp[-1]), yyscanner, "multiple entities named " + data->currentName);
          YYERROR;
      }
  }
#line 2761 "/build/libreoffice-still/src/libreoffice-25.8.5.2/workdir/YaccTarget/unoidl/source/sourceprovider-parser.cxx"
    break;

  case 33: /* exceptionDefn: deprecated_opt published_opt TOK_EXCEPTION identifier singleInheritance_opt $@5 '{' structMembers '}' ';'  */
#line 1271 "/build/libreoffice-still/src/libreoffice-25.8.5.2/unoidl/source/sourceprovider-parser.y"
  {
      unoidl::detail::SourceProviderScannerData * data = yyget_extra(yyscanner);
      unoidl::detail::SourceProviderEntity * ent = getCurrentEntity(data);
      unoidl::detail::SourceProviderExceptionTypeEntityPad * pad =
          dynamic_cast<unoidl::detail::SourceProviderExceptionTypeEntityPad *>(
              ent->pad.get());
      assert(pad != nullptr);
      ent->entity = new unoidl::ExceptionTypeEntity(
          pad->isPublished(), pad->baseName, std::move(pad->members), annotations((yyvsp[-9].bval)));
      ent->pad.clear();
      clearCurrentState(data);
  }
#line 2778 "/build/libreoffice-still/src/libreoffice-25.8.5.2/workdir/YaccTarget/unoidl/source/sourceprovider-parser.cxx"
    break;

  case 36: /* structMember: deprecated_opt type identifier ';'  */
#line 1292 "/build/libreoffice-still/src/libreoffice-25.8.5.2/unoidl/source/sourceprovider-parser.y"
  {
      unoidl::detail::SourceProviderScannerData * data = yyget_extra(yyscanner);
      unoidl::detail::SourceProviderType t(*(yyvsp[-2].type));
      delete (yyvsp[-2].type);
      OUString id(convertName((yyvsp[-1].sval)));
      switch (t.type) {
      case unoidl::detail::SourceProviderType::TYPE_VOID:
      case unoidl::detail::SourceProviderType::TYPE_EXCEPTION:
          error(
              (yylsp[-2]), yyscanner,
              ("illegal struct/exception type " + data->currentName
               + " direct member " + id + " type"));
          YYERROR;
          break;
      default:
          break;
      }
      if (t.type != unoidl::detail::SourceProviderType::TYPE_PARAMETER
          && t.getName() == data->currentName) // no need to worry about typedef
      {
          error(
              (yylsp[-2]), yyscanner,
              ("struct/exception type " + data->currentName + " direct member "
               + id + " has same type as the type itself"));
          YYERROR;
      }
      if (checkInstantiatedPolymorphicStructTypeArgument(t, data->currentName))
      {
          error(
              (yylsp[-2]), yyscanner,
              ("struct/exception type " + data->currentName + " direct member "
               + id
               + (" has instantiated polymorphic struct type that uses the type"
                  " itself as an argument")));
          YYERROR;
      }
      if (nameHasSameIdentifierAs(data->currentName, id)) {
          error(
              (yylsp[-1]), yyscanner,
              ("struct/exception type " + data->currentName + " direct member "
               + id + " has same unqualified identifier as the type itself"));
          YYERROR;
      }
      unoidl::detail::SourceProviderEntity * ent = getCurrentEntity(data);
      unoidl::detail::SourceProviderPlainStructTypeEntityPad * p1 =
          dynamic_cast<unoidl::detail::SourceProviderPlainStructTypeEntityPad *>(
              ent->pad.get());
      if (p1 != nullptr) {
          for (const auto & i: p1->members) {
              if (id == i.name) {
                  error(
                      (yylsp[-1]), yyscanner,
                      ("plain struct type " + data->currentName
                       + " direct member " + id
                       + " has same identifier as another direct member"));
                  YYERROR;
              }
          }
          if (p1->baseEntity.is()) {
              OUString baseName(p1->baseName);
              for (auto baseEnt(p1->baseEntity);;) {
                  if (nameHasSameIdentifierAs(baseName, id)) {
                      error(
                          (yylsp[-1]), yyscanner,
                          ("plain struct type " + data->currentName
                           + " direct member " + id
                           + " has same unqalified identifier as base "
                           + baseName));
                      YYERROR;
                  }
                  for (auto & i: baseEnt->getDirectMembers()) {
                      if (id == i.name) {
                          error(
                              (yylsp[-1]), yyscanner,
                              ("plain struct type " + data->currentName
                               + " direct member " + id
                               + " has same identifier as a member of base "
                               + baseName));
                          YYERROR;
                      }
                  }
                  baseName = baseEnt->getDirectBase();
                  if (baseName.isEmpty()) {
                      break;
                  }
                  unoidl::detail::SourceProviderEntity const * p;
                  if (findEntity(
                          (yylsp[-2]), yyscanner, data, false, &baseName, &p, nullptr,
                          nullptr)
                      == FOUND_ERROR)
                  {
                      YYERROR;
                  }
                  if (p == nullptr || !p->entity.is()
                      || (p->entity->getSort()
                          != unoidl::Entity::SORT_PLAIN_STRUCT_TYPE))
                  {
                      error(
                          (yylsp[-2]), yyscanner,
                          ("inconsistent type manager: plain struct type "
                           + data->currentName + " base " + baseName
                           + (" does not resolve to an existing plain struct"
                              " type")));
                      YYERROR;
                  }
                  baseEnt = static_cast<unoidl::PlainStructTypeEntity *>(
                      p->entity.get());
              }
          }
          p1->members.emplace_back(id, t.getName(), annotations((yyvsp[-3].bval)));
      } else {
          unoidl::detail::SourceProviderPolymorphicStructTypeTemplateEntityPad *
              p2 = dynamic_cast<unoidl::detail::SourceProviderPolymorphicStructTypeTemplateEntityPad *>(
                  ent->pad.get());
          if (p2 != nullptr) {
              for (const auto & i: p2->members) {
                  if (id == i.name) {
                      error(
                          (yylsp[-1]), yyscanner,
                          ("polymorphic struct type template "
                           + data->currentName + " direct member " + id
                           + " has same identifier as another direct member"));
                      YYERROR;
                  }
              }
              p2->members.emplace_back(
                  id, t.getName(),
                  t.type == unoidl::detail::SourceProviderType::TYPE_PARAMETER,
                  annotations((yyvsp[-3].bval)));
          } else {
              unoidl::detail::SourceProviderExceptionTypeEntityPad * p3
                  = dynamic_cast<unoidl::detail::SourceProviderExceptionTypeEntityPad *>(
                      ent->pad.get());
              assert(p3 != nullptr);
              for (const auto & i: p3->members) {
                  if (id == i.name) {
                      error(
                          (yylsp[-1]), yyscanner,
                          ("exception type " + data->currentName
                           + " direct member " + id
                           + " has same identifier as another direct member"));
                      YYERROR;
                  }
              }
              if (p3->baseEntity.is()) {
                  OUString baseName(p3->baseName);
                  for (auto baseEnt(p3->baseEntity);;) {
                      if (nameHasSameIdentifierAs(baseName, id)) {
                          error(
                              (yylsp[-1]), yyscanner,
                              ("exception type " + data->currentName
                               + " direct member " + id
                               + " has same unqalified identifier as base "
                               + baseName));
                          YYERROR;
                      }
                      for (auto & i: baseEnt->getDirectMembers()) {
                          if (id == i.name) {
                              error(
                                  (yylsp[-1]), yyscanner,
                                  ("exception type " + data->currentName
                                   + " direct member " + id
                                   + " has same identifier as a member of base "
                                   + baseName));
                              YYERROR;
                          }
                      }
                      baseName = baseEnt->getDirectBase();
                      if (baseName.isEmpty()) {
                          break;
                      }
                      unoidl::detail::SourceProviderEntity const * p;
                      if (findEntity(
                              (yylsp[-2]), yyscanner, data, false, &baseName, &p,
                              nullptr, nullptr)
                          == FOUND_ERROR)
                      {
                          YYERROR;
                      }
                      if (p == nullptr || !p->entity.is()
                          || (p->entity->getSort()
                              != unoidl::Entity::SORT_EXCEPTION_TYPE))
                      {
                          error(
                              (yylsp[-2]), yyscanner,
                              ("inconsistent type manager: exception type "
                               + data->currentName + " base " + baseName
                               + (" does not resolve to an existing exception"
                                  " type")));
                          YYERROR;
                      }
                      baseEnt = static_cast<unoidl::ExceptionTypeEntity *>(
                          p->entity.get());
                  }
              }
              p3->members.emplace_back(id, t.getName(), annotations((yyvsp[-3].bval)));
          }
      }
  }
#line 2982 "/build/libreoffice-still/src/libreoffice-25.8.5.2/workdir/YaccTarget/unoidl/source/sourceprovider-parser.cxx"
    break;

  case 37: /* $@6: %empty  */
#line 1495 "/build/libreoffice-still/src/libreoffice-25.8.5.2/unoidl/source/sourceprovider-parser.y"
  {
      unoidl::detail::SourceProviderScannerData * data = yyget_extra(yyscanner);
      data->publishedContext = (yyvsp[-3].bval);
      convertToCurrentName(data, (yyvsp[-1].sval));
      OUString baseName;
      rtl::Reference<unoidl::InterfaceTypeEntity> baseEnt;
      if ((yyvsp[0].sval) != nullptr) {
          baseName = convertName((yyvsp[0].sval));
          unoidl::detail::SourceProviderEntity const * p;
          if (findEntity(
                  (yylsp[0]), yyscanner, data, true, &baseName, &p, nullptr, nullptr)
              == FOUND_ERROR)
          {
              YYERROR;
          }
          if (p == nullptr || !p->entity.is()
              || p->entity->getSort() != unoidl::Entity::SORT_INTERFACE_TYPE)
          {
              error(
                  (yylsp[0]), yyscanner,
                  ("interface type " + data->currentName + " direct base "
                   + baseName
                   + " does not resolve to an existing interface type"));
              YYERROR;
          }
          baseEnt = static_cast<unoidl::InterfaceTypeEntity *>(p->entity.get());
          if ((yyvsp[-3].bval) && !baseEnt->isPublished()) {
              error(
                  (yylsp[0]), yyscanner,
                  ("published interface type " + data->currentName
                   + " direct base " + baseName + " is unpublished"));
              YYERROR;
          }
      }
      std::map<OUString, unoidl::detail::SourceProviderEntity>::iterator i(
          data->entities.find(data->currentName));
      if (i != data->entities.end()) {
          switch (i->second.kind) {
          case unoidl::detail::SourceProviderEntity::KIND_INTERFACE_DECL:
              break;
          case unoidl::detail::SourceProviderEntity::KIND_PUBLISHED_INTERFACE_DECL:
              if (!(yyvsp[-3].bval)) {
                  error(
                      (yylsp[-1]), yyscanner,
                      ("unpublished interface type " + data->currentName
                       + " has been declared published"));
                  YYERROR;
              }
              break;
          default:
              error(
                  (yylsp[-1]), yyscanner,
                  "multiple entities named " + data->currentName);
              YYERROR;
              break;
          }
      }
      rtl::Reference<unoidl::detail::SourceProviderInterfaceTypeEntityPad> pad(
          new unoidl::detail::SourceProviderInterfaceTypeEntityPad(
              (yyvsp[-3].bval), baseEnt.is()));
      if (baseEnt.is()
          && !pad->addDirectBase(
              (yylsp[-1]), yyscanner, data,
              unoidl::detail::SourceProviderInterfaceTypeEntityPad::DirectBase(
                  baseName, baseEnt, std::vector<OUString>()),
              false))
      {
          YYERROR;
      }
      data->entities[data->currentName] = unoidl::detail::SourceProviderEntity(
          pad);
  }
#line 3059 "/build/libreoffice-still/src/libreoffice-25.8.5.2/workdir/YaccTarget/unoidl/source/sourceprovider-parser.cxx"
    break;

  case 38: /* interfaceDefn: deprecated_opt published_opt TOK_INTERFACE identifier singleInheritance_opt $@6 '{' interfaceMembers '}' ';'  */
#line 1568 "/build/libreoffice-still/src/libreoffice-25.8.5.2/unoidl/source/sourceprovider-parser.y"
  {
      unoidl::detail::SourceProviderScannerData * data = yyget_extra(yyscanner);
      unoidl::detail::SourceProviderEntity * ent = getCurrentEntity(data);
      unoidl::detail::SourceProviderInterfaceTypeEntityPad * pad =
          dynamic_cast<unoidl::detail::SourceProviderInterfaceTypeEntityPad *>(
              ent->pad.get());
      assert(pad != nullptr);
      if (pad->directMandatoryBases.empty()
          && data->currentName != "com.sun.star.uno.XInterface")
      {
          OUString base(u".com.sun.star.uno.XInterface"_ustr);
          unoidl::detail::SourceProviderEntity const * p;
          if (findEntity((yylsp[-6]), yyscanner, data, true, &base, &p, nullptr, nullptr)
              == FOUND_ERROR)
          {
              YYERROR;
          }
          if (p == nullptr || !p->entity.is()
              || p->entity->getSort() != unoidl::Entity::SORT_INTERFACE_TYPE)
          {
              error(
                  (yylsp[-7]), yyscanner,
                  ("interface type " + data->currentName
                   + " implicit direct base " + base
                   + " does not resolve to an existing interface type"));
              YYERROR;
          }
          if (!pad->addDirectBase(
                  (yylsp[-7]), yyscanner, data,
                  unoidl::detail::SourceProviderInterfaceTypeEntityPad::DirectBase(
                      base,
                      static_cast<unoidl::InterfaceTypeEntity *>(
                          p->entity.get()),
                      std::vector<OUString>()),
                  false))
          {
              YYERROR;
          }
      }
      std::vector<unoidl::AnnotatedReference> mbases;
      for (auto & i: pad->directMandatoryBases) {
          mbases.emplace_back(i.name, std::move(i.annotations));
      }
      std::vector<unoidl::AnnotatedReference> obases;
      for (auto & i: pad->directOptionalBases) {
          obases.emplace_back(i.name, std::move(i.annotations));
      }
      ent->entity = new unoidl::InterfaceTypeEntity(
          pad->isPublished(), std::move(mbases), std::move(obases), std::move(pad->directAttributes),
          std::move(pad->directMethods), annotations((yyvsp[-9].bval)));
      ent->pad.clear();
      clearCurrentState(data);
  }
#line 3117 "/build/libreoffice-still/src/libreoffice-25.8.5.2/workdir/YaccTarget/unoidl/source/sourceprovider-parser.cxx"
    break;

  case 44: /* interfaceBase: deprecated_opt flagSection_opt TOK_INTERFACE name ';'  */
#line 1636 "/build/libreoffice-still/src/libreoffice-25.8.5.2/unoidl/source/sourceprovider-parser.y"
  {
      unoidl::detail::SourceProviderScannerData * data = yyget_extra(yyscanner);
      OUString name(convertName((yyvsp[-1].sval)));
      rtl::Reference<unoidl::detail::SourceProviderInterfaceTypeEntityPad> pad(
          getCurrentPad<unoidl::detail::SourceProviderInterfaceTypeEntityPad>(
              data));
      if (pad->singleBase) {
          error(
              (yylsp[-2]), yyscanner,
              u"single-inheritance interface cannot have additional bases"_ustr);
          YYERROR;
      }
      if (((yyvsp[-3].flags) & ~unoidl::detail::FLAG_OPTIONAL) != 0) {
          error(
              (yylsp[-3]), yyscanner,
              u"interface base can only be flagged as [optional]"_ustr);
          YYERROR;
      }
      bool opt = ((yyvsp[-3].flags) & unoidl::detail::FLAG_OPTIONAL) != 0;
      OUString orgName(name);
      unoidl::detail::SourceProviderEntity const * p;
      bool typedefed = false;
      if (findEntity((yylsp[-1]), yyscanner, data, true, &name, &p, &typedefed, nullptr)
          == FOUND_ERROR)
      {
          YYERROR;
      }
      if (p == nullptr || !p->entity.is()
          || p->entity->getSort() != unoidl::Entity::SORT_INTERFACE_TYPE)
      {
          error(
              (yylsp[-1]), yyscanner,
              ("interface type " + data->currentName + " direct base " + name
               + " does not resolve to an existing interface type"));
          YYERROR;
      }
      if (typedefed) {
          error(
              (yylsp[-1]), yyscanner,
              ("interface type " + data->currentName + " direct base " + orgName
               + " is a typedef"));
          YYERROR;
      }
      rtl::Reference<unoidl::InterfaceTypeEntity> ent(
          static_cast<unoidl::InterfaceTypeEntity *>(p->entity.get()));
      if (data->publishedContext && !ent->isPublished()) {
          error(
              (yylsp[-1]), yyscanner,
              ("published interface type " + data->currentName + " direct base "
               + name + " is unpublished"));
          YYERROR;
      }
      if (!pad->addDirectBase(
              (yylsp[-1]), yyscanner, data,
              unoidl::detail::SourceProviderInterfaceTypeEntityPad::DirectBase(
                  name, ent, annotations((yyvsp[-4].bval))),
              opt))
      {
          YYERROR;
      }
  }
#line 3183 "/build/libreoffice-still/src/libreoffice-25.8.5.2/workdir/YaccTarget/unoidl/source/sourceprovider-parser.cxx"
    break;

  case 45: /* $@7: %empty  */
#line 1701 "/build/libreoffice-still/src/libreoffice-25.8.5.2/unoidl/source/sourceprovider-parser.y"
  {
      unoidl::detail::SourceProviderScannerData * data = yyget_extra(yyscanner);
      unoidl::detail::SourceProviderType t(*(yyvsp[-1].type));
      delete (yyvsp[-1].type);
      OUString id(convertName((yyvsp[0].sval)));
      if (((yyvsp[-2].flags) & unoidl::detail::FLAG_ATTRIBUTE) == 0) {
          error(
              (yylsp[-2]), yyscanner,
              u"interface attribute must be flagged as [attribute]"_ustr);
          YYERROR;
      }
      if (((yyvsp[-2].flags)
           & ~(unoidl::detail::FLAG_ATTRIBUTE | unoidl::detail::FLAG_BOUND
               | unoidl::detail::FLAG_READONLY))
          != 0)
      {
          error(
              (yylsp[-2]), yyscanner,
              (u"interface attribute can only be flagged as [attribute,"
               " bound, readonly]"_ustr));
          YYERROR;
      }
      switch (t.type) {
      case unoidl::detail::SourceProviderType::TYPE_VOID:
      case unoidl::detail::SourceProviderType::TYPE_EXCEPTION:
          error(
              (yylsp[-1]), yyscanner,
              ("illegal interface type " + data->currentName
               + " direct attribute " + id + " type"));
          YYERROR;
          break;
      default:
          break;
      }
      rtl::Reference<unoidl::detail::SourceProviderInterfaceTypeEntityPad> pad(
          getCurrentPad<unoidl::detail::SourceProviderInterfaceTypeEntityPad>(
              data));
      if (!pad->addDirectMember((yylsp[0]), yyscanner, data, id)) {
          YYERROR;
      }
      pad->directAttributes.emplace_back(
          id, t.getName(), ((yyvsp[-2].flags) & unoidl::detail::FLAG_BOUND) != 0,
          ((yyvsp[-2].flags) & unoidl::detail::FLAG_READONLY) != 0,
          std::vector<OUString>(), std::vector<OUString>(), annotations((yyvsp[-3].bval)));
  }
#line 3233 "/build/libreoffice-still/src/libreoffice-25.8.5.2/workdir/YaccTarget/unoidl/source/sourceprovider-parser.cxx"
    break;

  case 49: /* attributeAccessDecls: attributeAccessDecls attributeAccessDecl  */
#line 1756 "/build/libreoffice-still/src/libreoffice-25.8.5.2/unoidl/source/sourceprovider-parser.y"
  {
      if (((yyvsp[-1].decls) & (yyvsp[0].decls)) != 0) {
          error(
              (yylsp[0]), yyscanner, u"duplicate get/set attribute access declaration"_ustr);
          YYERROR;
      }
      (yyval.decls) = unoidl::detail::SourceProviderAccessDecls((yyvsp[-1].decls) | (yyvsp[0].decls));
  }
#line 3246 "/build/libreoffice-still/src/libreoffice-25.8.5.2/workdir/YaccTarget/unoidl/source/sourceprovider-parser.cxx"
    break;

  case 50: /* attributeAccessDecls: %empty  */
#line 1764 "/build/libreoffice-still/src/libreoffice-25.8.5.2/unoidl/source/sourceprovider-parser.y"
              { (yyval.decls) = unoidl::detail::SourceProviderAccessDecls(0); }
#line 3252 "/build/libreoffice-still/src/libreoffice-25.8.5.2/workdir/YaccTarget/unoidl/source/sourceprovider-parser.cxx"
    break;

  case 51: /* attributeAccessDecl: TOK_GET exceptionSpec ';'  */
#line 1769 "/build/libreoffice-still/src/libreoffice-25.8.5.2/unoidl/source/sourceprovider-parser.y"
  {
      unoidl::detail::SourceProviderScannerData * data = yyget_extra(yyscanner);
      rtl::Reference<unoidl::detail::SourceProviderInterfaceTypeEntityPad>
          pad(getCurrentPad<unoidl::detail::SourceProviderInterfaceTypeEntityPad>(
              data));
      assert(!pad->directAttributes.empty());
      pad->directAttributes.back().getExceptions = *(yyvsp[-1].excns);
      delete (yyvsp[-1].excns);
      (yyval.decls) = unoidl::detail::ACCESS_DECL_GET;
  }
#line 3267 "/build/libreoffice-still/src/libreoffice-25.8.5.2/workdir/YaccTarget/unoidl/source/sourceprovider-parser.cxx"
    break;

  case 52: /* attributeAccessDecl: TOK_SET exceptionSpec ';'  */
#line 1780 "/build/libreoffice-still/src/libreoffice-25.8.5.2/unoidl/source/sourceprovider-parser.y"
  {
      unoidl::detail::SourceProviderScannerData * data = yyget_extra(yyscanner);
      rtl::Reference<unoidl::detail::SourceProviderInterfaceTypeEntityPad>
          pad(getCurrentPad<unoidl::detail::SourceProviderInterfaceTypeEntityPad>(
              data));
      assert(!pad->directAttributes.empty());
      pad->directAttributes.back().setExceptions = *(yyvsp[-1].excns);
      delete (yyvsp[-1].excns);
      if (pad->directAttributes.back().readOnly) {
          error(
              (yylsp[-2]), yyscanner,
              ("interface type " + data->currentName
               + " direct read-only attribute "
               + pad->directAttributes.back().name
               + " cannot have set access declaration"));
          YYERROR;
      }
      (yyval.decls) = unoidl::detail::ACCESS_DECL_SET;
  }
#line 3291 "/build/libreoffice-still/src/libreoffice-25.8.5.2/workdir/YaccTarget/unoidl/source/sourceprovider-parser.cxx"
    break;

  case 53: /* $@8: %empty  */
#line 1803 "/build/libreoffice-still/src/libreoffice-25.8.5.2/unoidl/source/sourceprovider-parser.y"
  {
      unoidl::detail::SourceProviderScannerData * data = yyget_extra(yyscanner);
      unoidl::detail::SourceProviderType t(*(yyvsp[-1].type));
      delete (yyvsp[-1].type);
      OUString id(convertName((yyvsp[0].sval)));
      if (t.type == unoidl::detail::SourceProviderType::TYPE_EXCEPTION) {
          error(
              (yylsp[0]), yyscanner,
              ("illegal interface type " + data->currentName
               + " direct method " + id + " return type"));
          YYERROR;
      }
      rtl::Reference<unoidl::detail::SourceProviderInterfaceTypeEntityPad> pad(
          getCurrentPad<unoidl::detail::SourceProviderInterfaceTypeEntityPad>(
              data));
      if (!pad->addDirectMember((yylsp[0]), yyscanner, data, id)) {
          YYERROR;
      }
      pad->directMethods.emplace_back(
          id, t.getName(),
          std::vector<unoidl::InterfaceTypeEntity::Method::Parameter>(),
          std::vector<OUString>(), annotations((yyvsp[-2].bval)));
  }
#line 3319 "/build/libreoffice-still/src/libreoffice-25.8.5.2/workdir/YaccTarget/unoidl/source/sourceprovider-parser.cxx"
    break;

  case 54: /* interfaceMethod: deprecated_opt type identifier $@8 '(' methodParams_opt ')' exceptionSpec_opt ';'  */
#line 1827 "/build/libreoffice-still/src/libreoffice-25.8.5.2/unoidl/source/sourceprovider-parser.y"
  {
      if ((yyvsp[-1].excns) != nullptr) {
          unoidl::detail::SourceProviderScannerData * data
              = yyget_extra(yyscanner);
          rtl::Reference<unoidl::detail::SourceProviderInterfaceTypeEntityPad>
              pad(getCurrentPad<unoidl::detail::SourceProviderInterfaceTypeEntityPad>(
                  data));
          assert(!pad->directMethods.empty());
          pad->directMethods.back().exceptions = *(yyvsp[-1].excns);
          delete (yyvsp[-1].excns);
      }
  }
#line 3336 "/build/libreoffice-still/src/libreoffice-25.8.5.2/workdir/YaccTarget/unoidl/source/sourceprovider-parser.cxx"
    break;

  case 59: /* methodParam: '[' direction ']' type identifier  */
#line 1853 "/build/libreoffice-still/src/libreoffice-25.8.5.2/unoidl/source/sourceprovider-parser.y"
  {
      unoidl::detail::SourceProviderScannerData * data = yyget_extra(yyscanner);
      unoidl::detail::SourceProviderType t(*(yyvsp[-1].type));
      delete (yyvsp[-1].type);
      OUString id(convertName((yyvsp[0].sval)));
      rtl::Reference<unoidl::detail::SourceProviderInterfaceTypeEntityPad>
          pad(getCurrentPad<unoidl::detail::SourceProviderInterfaceTypeEntityPad>(
              data));
      assert(!pad->directMethods.empty());
      switch (t.type) {
      case unoidl::detail::SourceProviderType::TYPE_VOID:
      case unoidl::detail::SourceProviderType::TYPE_EXCEPTION:
          error(
              (yylsp[-1]), yyscanner,
              ("illegal interface type " + data->currentName
               + " direct method " + pad->directMethods.back().name
               + " parameter " + id + " type"));
          YYERROR;
          break;
      default:
          break;
      }
      for (const auto & i: pad->directMethods.back().parameters) {
          if (id == i.name) {
              error(
                  (yylsp[0]), yyscanner,
                  ("interface type " + data->currentName + " direct method "
                   + pad->directMethods.back().name + " parameter " + id
                   + " has same identifier as another parameter"));
              YYERROR;
          }
      }
      pad->directMethods.back().parameters.emplace_back(id, t.getName(), (yyvsp[-3].dir));
  }
#line 3375 "/build/libreoffice-still/src/libreoffice-25.8.5.2/workdir/YaccTarget/unoidl/source/sourceprovider-parser.cxx"
    break;

  case 60: /* direction: TOK_IN  */
#line 1890 "/build/libreoffice-still/src/libreoffice-25.8.5.2/unoidl/source/sourceprovider-parser.y"
         { (yyval.dir) = unoidl::InterfaceTypeEntity::Method::Parameter::DIRECTION_IN; }
#line 3381 "/build/libreoffice-still/src/libreoffice-25.8.5.2/workdir/YaccTarget/unoidl/source/sourceprovider-parser.cxx"
    break;

  case 61: /* direction: TOK_OUT  */
#line 1892 "/build/libreoffice-still/src/libreoffice-25.8.5.2/unoidl/source/sourceprovider-parser.y"
  { (yyval.dir) = unoidl::InterfaceTypeEntity::Method::Parameter::DIRECTION_OUT; }
#line 3387 "/build/libreoffice-still/src/libreoffice-25.8.5.2/workdir/YaccTarget/unoidl/source/sourceprovider-parser.cxx"
    break;

  case 62: /* direction: TOK_INOUT  */
#line 1894 "/build/libreoffice-still/src/libreoffice-25.8.5.2/unoidl/source/sourceprovider-parser.y"
  { (yyval.dir) = unoidl::InterfaceTypeEntity::Method::Parameter::DIRECTION_IN_OUT; }
#line 3393 "/build/libreoffice-still/src/libreoffice-25.8.5.2/workdir/YaccTarget/unoidl/source/sourceprovider-parser.cxx"
    break;

  case 63: /* typedefDefn: deprecated_opt published_opt TOK_TYPEDEF type identifier ';'  */
#line 1899 "/build/libreoffice-still/src/libreoffice-25.8.5.2/unoidl/source/sourceprovider-parser.y"
  {
      unoidl::detail::SourceProviderScannerData * data = yyget_extra(yyscanner);
      data->publishedContext = (yyvsp[-4].bval);
      unoidl::detail::SourceProviderType t(*(yyvsp[-2].type));
      delete (yyvsp[-2].type);
      OUString name(convertToFullName(data, (yyvsp[-1].sval)));
      // There is no good reason to forbid typedefs to VOID, to instantiated
      // polymorphic struct types, and to exception types, but some old client
      // code of registry data expects this typedef restriction (like the
      // assert(false) default in handleTypedef in
      // codemaker/source/javamaker/javatype.cxx), so forbid them for now:
      switch (t.type) {
      case unoidl::detail::SourceProviderType::TYPE_VOID:
      case unoidl::detail::SourceProviderType::TYPE_EXCEPTION:
      case unoidl::detail::SourceProviderType::TYPE_INSTANTIATED_POLYMORPHIC_STRUCT:
          error((yylsp[-2]), yyscanner, u"bad typedef type"_ustr);
          YYERROR;
          break;
      case unoidl::detail::SourceProviderType::TYPE_ENUM:
      case unoidl::detail::SourceProviderType::TYPE_PLAIN_STRUCT:
      case unoidl::detail::SourceProviderType::TYPE_INTERFACE:
          if ((yyvsp[-4].bval)) {
              bool unpub = false;
              switch (t.entity->kind) {
              case unoidl::detail::SourceProviderEntity::KIND_INTERFACE_DECL:
                  unpub = true;
                  break;
              case unoidl::detail::SourceProviderEntity::KIND_PUBLISHED_INTERFACE_DECL:
                  break;
              case unoidl::detail::SourceProviderEntity::KIND_MODULE:
                  O3TL_UNREACHABLE;
              default:
                  assert(t.entity->entity.is() || t.entity->pad.is());
                  unpub
                      = !(t.entity->entity.is()
                          ? static_cast<unoidl::PublishableEntity *>(
                              t.entity->entity.get())->isPublished()
                          : t.entity->pad->isPublished());
                  break;
              }
              if (unpub) {
                  error(
                      (yylsp[-2]), yyscanner,
                      "published typedef " + name + " type is unpublished");
                  YYERROR;
              }
          }
          break;
      case unoidl::detail::SourceProviderType::TYPE_PARAMETER:
          O3TL_UNREACHABLE;
      default:
          break;
      }
      if (!data->entities.emplace(
                  name,
                  unoidl::detail::SourceProviderEntity(
                      unoidl::detail::SourceProviderEntity::KIND_LOCAL,
                      new unoidl::TypedefEntity(
                          (yyvsp[-4].bval), t.getName(), annotations((yyvsp[-5].bval))))).
          second)
      {
          error((yylsp[-1]), yyscanner, "multiple entities named " + name);
          YYERROR;
      }
      clearCurrentState(data);
  }
#line 3464 "/build/libreoffice-still/src/libreoffice-25.8.5.2/workdir/YaccTarget/unoidl/source/sourceprovider-parser.cxx"
    break;

  case 64: /* $@9: %empty  */
#line 1969 "/build/libreoffice-still/src/libreoffice-25.8.5.2/unoidl/source/sourceprovider-parser.y"
  {
      unoidl::detail::SourceProviderScannerData * data = yyget_extra(yyscanner);
      data->publishedContext = (yyvsp[-2].bval);
      convertToCurrentName(data, (yyvsp[0].sval));
      if (!data->entities.emplace(
                  data->currentName,
                  unoidl::detail::SourceProviderEntity(
                      new unoidl::detail::SourceProviderConstantGroupEntityPad(
                          (yyvsp[-2].bval)))).
          second)
      {
          error((yylsp[0]), yyscanner, "multiple entities named " + data->currentName);
          YYERROR;
      }
  }
#line 3484 "/build/libreoffice-still/src/libreoffice-25.8.5.2/workdir/YaccTarget/unoidl/source/sourceprovider-parser.cxx"
    break;

  case 65: /* constantGroupDefn: deprecated_opt published_opt TOK_CONSTANTS identifier $@9 '{' constants '}' ';'  */
#line 1985 "/build/libreoffice-still/src/libreoffice-25.8.5.2/unoidl/source/sourceprovider-parser.y"
  {
      unoidl::detail::SourceProviderScannerData * data = yyget_extra(yyscanner);
      unoidl::detail::SourceProviderEntity * ent = getCurrentEntity(data);
      unoidl::detail::SourceProviderConstantGroupEntityPad * pad =
          dynamic_cast<unoidl::detail::SourceProviderConstantGroupEntityPad *>(
              ent->pad.get());
      assert(pad != nullptr);
      ent->entity = new unoidl::ConstantGroupEntity(
          pad->isPublished(), std::move(pad->members), annotations((yyvsp[-8].bval)));
      ent->pad.clear();
      clearCurrentState(data);
  }
#line 3501 "/build/libreoffice-still/src/libreoffice-25.8.5.2/workdir/YaccTarget/unoidl/source/sourceprovider-parser.cxx"
    break;

  case 68: /* constant: deprecated_opt TOK_CONST type identifier '=' expr ';'  */
#line 2006 "/build/libreoffice-still/src/libreoffice-25.8.5.2/unoidl/source/sourceprovider-parser.y"
  {
      OUString id(convertName((yyvsp[-3].sval)));
      unoidl::detail::SourceProviderScannerData * data = yyget_extra(yyscanner);
      rtl::Reference<unoidl::detail::SourceProviderConstantGroupEntityPad> pad(
          getCurrentPad<unoidl::detail::SourceProviderConstantGroupEntityPad>(
              data));
      unoidl::detail::SourceProviderType t(*(yyvsp[-4].type));
      delete (yyvsp[-4].type);
      unoidl::ConstantValue v(false); // dummy value
      switch (t.type) {
      case unoidl::detail::SourceProviderType::TYPE_BOOLEAN:
          if ((yyvsp[-1].expr).type != unoidl::detail::SourceProviderExpr::TYPE_BOOL) {
              error(
                  (yylsp[-1]), yyscanner,
                  ("bad value of boolean-typed constant " + data->currentName
                   + "." + id));
              YYERROR;
          }
          v = unoidl::ConstantValue((yyvsp[-1].expr).bval);
          break;
      case unoidl::detail::SourceProviderType::TYPE_BYTE:
          switch ((yyvsp[-1].expr).type) {
          case unoidl::detail::SourceProviderExpr::TYPE_INT:
              if ((yyvsp[-1].expr).ival < SAL_MIN_INT8 || (yyvsp[-1].expr).ival > SAL_MAX_INT8) {
                  error(
                      (yylsp[-1]), yyscanner,
                      ("out-of-range byte-typed constant " + data->currentName
                       + "." + id + " value " + OUString::number((yyvsp[-1].expr).ival)));
                  YYERROR;
              }
              v = unoidl::ConstantValue(static_cast<sal_Int8>((yyvsp[-1].expr).ival));
              break;
          case unoidl::detail::SourceProviderExpr::TYPE_UINT:
              if ((yyvsp[-1].expr).uval > SAL_MAX_INT8) {
                  error(
                      (yylsp[-1]), yyscanner,
                      ("out-of-range byte-typed constant " + data->currentName
                       + "." + id + " value " + OUString::number((yyvsp[-1].expr).uval)));
                  YYERROR;
              }
              v = unoidl::ConstantValue(static_cast<sal_Int8>((yyvsp[-1].expr).uval));
              break;
          default:
              error(
                  (yylsp[-1]), yyscanner,
                  ("bad value of byte-typed constant " + data->currentName + "."
                   + id));
              YYERROR;
              break;
          }
          break;
      case unoidl::detail::SourceProviderType::TYPE_SHORT:
          switch ((yyvsp[-1].expr).type) {
          case unoidl::detail::SourceProviderExpr::TYPE_INT:
              if ((yyvsp[-1].expr).ival < SAL_MIN_INT16 || (yyvsp[-1].expr).ival > SAL_MAX_INT16) {
                  error(
                      (yylsp[-1]), yyscanner,
                      ("out-of-range short-typed constant " + data->currentName
                       + "." + id + " value " + OUString::number((yyvsp[-1].expr).ival)));
                  YYERROR;
              }
              v = unoidl::ConstantValue(static_cast<sal_Int16>((yyvsp[-1].expr).ival));
              break;
          case unoidl::detail::SourceProviderExpr::TYPE_UINT:
              if ((yyvsp[-1].expr).uval > SAL_MAX_INT16) {
                  error(
                      (yylsp[-1]), yyscanner,
                      ("out-of-range short-typed constant " + data->currentName
                       + "." + id + " value " + OUString::number((yyvsp[-1].expr).uval)));
                  YYERROR;
              }
              v = unoidl::ConstantValue(static_cast<sal_Int16>((yyvsp[-1].expr).uval));
              break;
          default:
              error(
                  (yylsp[-1]), yyscanner,
                  ("bad value of short-typed constant " + data->currentName
                   + "." + id));
              YYERROR;
              break;
          }
          break;
      case unoidl::detail::SourceProviderType::TYPE_UNSIGNED_SHORT:
          switch ((yyvsp[-1].expr).type) {
          case unoidl::detail::SourceProviderExpr::TYPE_INT:
              if ((yyvsp[-1].expr).ival < 0 || (yyvsp[-1].expr).ival > SAL_MAX_UINT16) {
                  error(
                      (yylsp[-1]), yyscanner,
                      ("out-of-range unsigned-short-typed constant "
                       + data->currentName + "." + id + " value "
                       + OUString::number((yyvsp[-1].expr).ival)));
                  YYERROR;
              }
              v = unoidl::ConstantValue(static_cast<sal_uInt16>((yyvsp[-1].expr).ival));
              break;
          case unoidl::detail::SourceProviderExpr::TYPE_UINT:
              if ((yyvsp[-1].expr).uval > SAL_MAX_UINT16) {
                  error(
                      (yylsp[-1]), yyscanner,
                      ("out-of-range unsigned-short-typed constant "
                       + data->currentName + "." + id + " value "
                       + OUString::number((yyvsp[-1].expr).uval)));
                  YYERROR;
              }
              v = unoidl::ConstantValue(static_cast<sal_uInt16>((yyvsp[-1].expr).uval));
              break;
          default:
              error(
                  (yylsp[-1]), yyscanner,
                  ("bad value of unsigned-short-typed constant "
                   + data->currentName + "." + id));
              YYERROR;
              break;
          }
          break;
      case unoidl::detail::SourceProviderType::TYPE_LONG:
          switch ((yyvsp[-1].expr).type) {
          case unoidl::detail::SourceProviderExpr::TYPE_INT:
              if ((yyvsp[-1].expr).ival < SAL_MIN_INT32 || (yyvsp[-1].expr).ival > SAL_MAX_INT32) {
                  error(
                      (yylsp[-1]), yyscanner,
                      ("out-of-range long-typed constant " + data->currentName
                       + "." + id + " value " + OUString::number((yyvsp[-1].expr).ival)));
                  YYERROR;
              }
              v = unoidl::ConstantValue(static_cast<sal_Int32>((yyvsp[-1].expr).ival));
              break;
          case unoidl::detail::SourceProviderExpr::TYPE_UINT:
              if ((yyvsp[-1].expr).uval > SAL_MAX_INT32) {
                  error(
                      (yylsp[-1]), yyscanner,
                      ("out-of-range long-typed constant " + data->currentName
                       + "." + id + " value " + OUString::number((yyvsp[-1].expr).uval)));
                  YYERROR;
              }
              v = unoidl::ConstantValue(static_cast<sal_Int32>((yyvsp[-1].expr).uval));
              break;
          default:
              error(
                  (yylsp[-1]), yyscanner,
                  ("bad value of long-typed constant " + data->currentName
                   + "." + id));
              YYERROR;
              break;
          }
          break;
      case unoidl::detail::SourceProviderType::TYPE_UNSIGNED_LONG:
          switch ((yyvsp[-1].expr).type) {
          case unoidl::detail::SourceProviderExpr::TYPE_INT:
              if ((yyvsp[-1].expr).ival < 0 || (yyvsp[-1].expr).ival > SAL_MAX_UINT32) {
                  error(
                      (yylsp[-1]), yyscanner,
                      ("out-of-range unsigned-long-typed constant "
                       + data->currentName + "." + id + " value "
                       + OUString::number((yyvsp[-1].expr).ival)));
                  YYERROR;
              }
              v = unoidl::ConstantValue(static_cast<sal_uInt32>((yyvsp[-1].expr).ival));
              break;
          case unoidl::detail::SourceProviderExpr::TYPE_UINT:
              if ((yyvsp[-1].expr).uval > SAL_MAX_UINT32) {
                  error(
                      (yylsp[-1]), yyscanner,
                      ("out-of-range unsigned-long-typed constant "
                       + data->currentName + "." + id + " value "
                       + OUString::number((yyvsp[-1].expr).uval)));
                  YYERROR;
              }
              v = unoidl::ConstantValue(static_cast<sal_uInt32>((yyvsp[-1].expr).uval));
              break;
          default:
              error(
                  (yylsp[-1]), yyscanner,
                  ("bad value of unsigned-long-typed constant "
                   + data->currentName + "." + id));
              YYERROR;
              break;
          }
          break;
      case unoidl::detail::SourceProviderType::TYPE_HYPER:
          switch ((yyvsp[-1].expr).type) {
          case unoidl::detail::SourceProviderExpr::TYPE_INT:
              v = unoidl::ConstantValue((yyvsp[-1].expr).ival);
              break;
          case unoidl::detail::SourceProviderExpr::TYPE_UINT:
              if ((yyvsp[-1].expr).uval > SAL_MAX_INT64) {
                  error(
                      (yylsp[-1]), yyscanner,
                      ("out-of-range hyper-typed constant " + data->currentName
                       + "." + id + " value " + OUString::number((yyvsp[-1].expr).uval)));
                  YYERROR;
              }
              v = unoidl::ConstantValue(static_cast<sal_Int64>((yyvsp[-1].expr).uval));
              break;
          default:
              error(
                  (yylsp[-1]), yyscanner,
                  ("bad value of hyper-typed constant " + data->currentName
                   + "." + id));
              YYERROR;
              break;
          }
          break;
      case unoidl::detail::SourceProviderType::TYPE_UNSIGNED_HYPER:
          switch ((yyvsp[-1].expr).type) {
          case unoidl::detail::SourceProviderExpr::TYPE_INT:
              if ((yyvsp[-1].expr).ival < 0) {
                  error(
                      (yylsp[-1]), yyscanner,
                      ("out-of-range unsigned-hyper-typed constant "
                       + data->currentName + "." + id + " value "
                       + OUString::number((yyvsp[-1].expr).ival)));
                  YYERROR;
              }
              v = unoidl::ConstantValue(static_cast<sal_uInt64>((yyvsp[-1].expr).ival));
              break;
          case unoidl::detail::SourceProviderExpr::TYPE_UINT:
              v = unoidl::ConstantValue((yyvsp[-1].expr).uval);
              break;
          default:
              error(
                  (yylsp[-1]), yyscanner,
                  ("bad value of unsigned-hyper-typed constant "
                   + data->currentName + "." + id));
              YYERROR;
              break;
          }
          break;
      case unoidl::detail::SourceProviderType::TYPE_FLOAT:
          switch ((yyvsp[-1].expr).type) {
          case unoidl::detail::SourceProviderExpr::TYPE_BOOL:
              error(
                  (yylsp[-1]), yyscanner,
                  ("bad boolean value of float-typed constant "
                   + data->currentName + "." + id));
              YYERROR;
              break;
          case unoidl::detail::SourceProviderExpr::TYPE_INT:
              v = unoidl::ConstantValue(static_cast<float>((yyvsp[-1].expr).ival));
              break;
          case unoidl::detail::SourceProviderExpr::TYPE_UINT:
              v = unoidl::ConstantValue(static_cast<float>((yyvsp[-1].expr).uval));
              break;
          case unoidl::detail::SourceProviderExpr::TYPE_FLOAT:
              v = unoidl::ConstantValue(static_cast<float>((yyvsp[-1].expr).fval));
              break;
          }
          break;
      case unoidl::detail::SourceProviderType::TYPE_DOUBLE:
          switch ((yyvsp[-1].expr).type) {
          case unoidl::detail::SourceProviderExpr::TYPE_BOOL:
              error(
                  (yylsp[-1]), yyscanner,
                  ("bad boolean value of double-typed constant "
                   + data->currentName + "." + id));
              YYERROR;
              break;
          case unoidl::detail::SourceProviderExpr::TYPE_INT:
              v = unoidl::ConstantValue(static_cast<double>((yyvsp[-1].expr).ival));
              break;
          case unoidl::detail::SourceProviderExpr::TYPE_UINT:
              v = unoidl::ConstantValue(static_cast<double>((yyvsp[-1].expr).uval));
              break;
          case unoidl::detail::SourceProviderExpr::TYPE_FLOAT:
              v = unoidl::ConstantValue((yyvsp[-1].expr).fval);
              break;
          }
          break;
      default:
          error(
              (yylsp[-4]), yyscanner,
              "bad type for constant " + data->currentName + "." + id);
          YYERROR;
          break;
      }
      pad->members.emplace_back(id, v, annotations((yyvsp[-6].bval)));
  }
#line 3783 "/build/libreoffice-still/src/libreoffice-25.8.5.2/workdir/YaccTarget/unoidl/source/sourceprovider-parser.cxx"
    break;

  case 69: /* $@10: %empty  */
#line 2287 "/build/libreoffice-still/src/libreoffice-25.8.5.2/unoidl/source/sourceprovider-parser.y"
  {
      unoidl::detail::SourceProviderScannerData * data = yyget_extra(yyscanner);
      data->publishedContext = (yyvsp[-3].bval);
      convertToCurrentName(data, (yyvsp[-1].sval));
      OUString base(convertName((yyvsp[0].sval)));
      unoidl::detail::SourceProviderEntity const * p;
      if (findEntity((yylsp[0]), yyscanner, data, false, &base, &p, nullptr, nullptr)
          == FOUND_ERROR)
      {
          YYERROR;
      }
      bool ifcBase = false;
      bool pubBase = false;
      if (p != nullptr) {
          switch (p->kind) {
          case unoidl::detail::SourceProviderEntity::KIND_INTERFACE_DECL:
              ifcBase = true;
              pubBase = false;
              break;
          case unoidl::detail::SourceProviderEntity::KIND_PUBLISHED_INTERFACE_DECL:
              ifcBase = true;
              pubBase = true;
              break;
          default:
              if (p->entity.is()
                  && (p->entity->getSort()
                      == unoidl::Entity::SORT_INTERFACE_TYPE))
              {
                  ifcBase = true;
                  pubBase = static_cast<unoidl::InterfaceTypeEntity *>(
                      p->entity.get())->isPublished();
              }
              break;
          }
      }
      if (!ifcBase) {
          error(
              (yylsp[0]), yyscanner,
              ("single-interface--based service " + data->currentName + " base "
               + base + " does not resolve to an interface type"));
          YYERROR;
      }
      if ((yyvsp[-3].bval) && !pubBase) {
          error(
              (yylsp[0]), yyscanner,
              ("published single-interface--based service " + data->currentName
               + " base " + base + " is unpublished"));
          YYERROR;
      }
      if (!data->entities.emplace(
                  data->currentName,
                  unoidl::detail::SourceProviderEntity(
                      new unoidl::detail::SourceProviderSingleInterfaceBasedServiceEntityPad(
                          (yyvsp[-3].bval), base))).
          second)
      {
          error((yylsp[-1]), yyscanner, "multiple entities named " + data->currentName);
          YYERROR;
      }
  }
#line 3848 "/build/libreoffice-still/src/libreoffice-25.8.5.2/workdir/YaccTarget/unoidl/source/sourceprovider-parser.cxx"
    break;

  case 70: /* singleInterfaceBasedServiceDefn: deprecated_opt published_opt TOK_SERVICE identifier singleInheritance $@10 ctors_opt ';'  */
#line 2348 "/build/libreoffice-still/src/libreoffice-25.8.5.2/unoidl/source/sourceprovider-parser.y"
  {
      unoidl::detail::SourceProviderScannerData * data = yyget_extra(yyscanner);
      unoidl::detail::SourceProviderEntity * ent = getCurrentEntity(data);
      unoidl::detail::SourceProviderSingleInterfaceBasedServiceEntityPad * pad =
          dynamic_cast<unoidl::detail::SourceProviderSingleInterfaceBasedServiceEntityPad *>(
              ent->pad.get());
      assert(pad != nullptr);
      std::vector<unoidl::SingleInterfaceBasedServiceEntity::Constructor> ctors;
      if ((yyvsp[-1].bval)) {
          for (const auto & i: pad->constructors) {
              std::vector<unoidl::SingleInterfaceBasedServiceEntity::Constructor::Parameter> parms;
              for (auto & j: i.parameters) {
                  parms.emplace_back(j.name, j.type.getName(), j.rest);
              }
              ctors.push_back(
                  unoidl::SingleInterfaceBasedServiceEntity::Constructor(
                      i.name, std::move(parms), std::vector(i.exceptions), std::vector(i.annotations)));
          }
      } else {
          assert(pad->constructors.empty());
          ctors.push_back(
              unoidl::SingleInterfaceBasedServiceEntity::Constructor());
      }
      ent->entity = new unoidl::SingleInterfaceBasedServiceEntity(
          pad->isPublished(), pad->base, std::move(ctors), annotations((yyvsp[-7].bval)));
      ent->pad.clear();
      clearCurrentState(data);
  }
#line 3881 "/build/libreoffice-still/src/libreoffice-25.8.5.2/workdir/YaccTarget/unoidl/source/sourceprovider-parser.cxx"
    break;

  case 71: /* ctors_opt: '{' ctors '}'  */
#line 2379 "/build/libreoffice-still/src/libreoffice-25.8.5.2/unoidl/source/sourceprovider-parser.y"
                { (yyval.bval) = true; }
#line 3887 "/build/libreoffice-still/src/libreoffice-25.8.5.2/workdir/YaccTarget/unoidl/source/sourceprovider-parser.cxx"
    break;

  case 72: /* ctors_opt: %empty  */
#line 2380 "/build/libreoffice-still/src/libreoffice-25.8.5.2/unoidl/source/sourceprovider-parser.y"
              { (yyval.bval) = false; }
#line 3893 "/build/libreoffice-still/src/libreoffice-25.8.5.2/workdir/YaccTarget/unoidl/source/sourceprovider-parser.cxx"
    break;

  case 75: /* $@11: %empty  */
#line 2390 "/build/libreoffice-still/src/libreoffice-25.8.5.2/unoidl/source/sourceprovider-parser.y"
  {
      unoidl::detail::SourceProviderScannerData * data = yyget_extra(yyscanner);
      OUString id(convertName((yyvsp[0].sval)));
      rtl::Reference<unoidl::detail::SourceProviderSingleInterfaceBasedServiceEntityPad>
          pad(getCurrentPad<unoidl::detail::SourceProviderSingleInterfaceBasedServiceEntityPad>(
                  data));
      for (const auto & i: pad->constructors) {
          if (id == i.name) {
              error(
                  (yylsp[0]), yyscanner,
                  ("single-interface--based service " + data->currentName
                   + " constructor " + id
                   + " has same identifier as another constructor"));
              YYERROR;
          }
      }
      pad->constructors.push_back(
          unoidl::detail::SourceProviderSingleInterfaceBasedServiceEntityPad::Constructor(
              id, annotations((yyvsp[-1].bval))));
  }
#line 3918 "/build/libreoffice-still/src/libreoffice-25.8.5.2/workdir/YaccTarget/unoidl/source/sourceprovider-parser.cxx"
    break;

  case 76: /* ctor: deprecated_opt identifier $@11 '(' ctorParams_opt ')' exceptionSpec_opt ';'  */
#line 2411 "/build/libreoffice-still/src/libreoffice-25.8.5.2/unoidl/source/sourceprovider-parser.y"
  {
      unoidl::detail::SourceProviderScannerData * data = yyget_extra(yyscanner);
      rtl::Reference<unoidl::detail::SourceProviderSingleInterfaceBasedServiceEntityPad>
          pad(getCurrentPad<unoidl::detail::SourceProviderSingleInterfaceBasedServiceEntityPad>(
                  data));
      assert(!pad->constructors.empty());
      if ((yyvsp[-1].excns) != nullptr) {
          pad->constructors.back().exceptions = *(yyvsp[-1].excns);
          delete (yyvsp[-1].excns);
      }
      for (auto i(pad->constructors.begin()); i != pad->constructors.end() - 1;
           ++i)
      {
          if (i->parameters.size()
              == pad->constructors.back().parameters.size())
          {
              bool same = true;
              for (auto
                       j(i->parameters.begin()),
                       k(pad->constructors.back().parameters.begin());
                   j != i->parameters.end(); ++j, ++k)
              {
                  if (!j->type.equals(k->type) || j->rest != k->rest) {
                      same = false;
                      break;
                  }
              }
              if (same) {
                  error(
                      (yylsp[-6]), yyscanner,
                      ("single-interface--based service " + data->currentName
                       + " constructor " + pad->constructors.back().name
                       + " has similar parameter list to constructor "
                       + i->name));
                  YYERROR;
              }
          }
      }
  }
#line 3962 "/build/libreoffice-still/src/libreoffice-25.8.5.2/workdir/YaccTarget/unoidl/source/sourceprovider-parser.cxx"
    break;

  case 81: /* ctorParam: '[' direction ']' type ellipsis_opt identifier  */
#line 2464 "/build/libreoffice-still/src/libreoffice-25.8.5.2/unoidl/source/sourceprovider-parser.y"
  {
      unoidl::detail::SourceProviderScannerData * data = yyget_extra(yyscanner);
      unoidl::detail::SourceProviderType t(*(yyvsp[-2].type));
      delete (yyvsp[-2].type);
      OUString id(convertName((yyvsp[0].sval)));
      rtl::Reference<unoidl::detail::SourceProviderSingleInterfaceBasedServiceEntityPad>
          pad(getCurrentPad<unoidl::detail::SourceProviderSingleInterfaceBasedServiceEntityPad>(
              data));
      assert(!pad->constructors.empty());
      if ((yyvsp[-4].dir) != unoidl::InterfaceTypeEntity::Method::Parameter::DIRECTION_IN) {
          error(
              (yylsp[-2]), yyscanner,
              ("single-interface--based service " + data->currentName
               + " constructor " + pad->constructors.back().name + " parameter "
               + id + " direction must be [in]"));
          YYERROR;
      }
      switch (t.type) {
      case unoidl::detail::SourceProviderType::TYPE_VOID:
      case unoidl::detail::SourceProviderType::TYPE_EXCEPTION:
          error(
              (yylsp[-2]), yyscanner,
              ("illegal single-interface--based service " + data->currentName
               + " constructor " + pad->constructors.back().name + " parameter "
               + id + " type"));
          YYERROR;
          break;
      default:
          break;
      }
      if ((yyvsp[-1].bval)) {
          if (t.type != unoidl::detail::SourceProviderType::TYPE_ANY) {
              error(
                  (yylsp[-2]), yyscanner,
                  ("illegal single-interface--based service "
                   + data->currentName + " constructor "
                   + pad->constructors.back().name + " rest parameter " + id
                   + " non-any type"));
              YYERROR;
          }
          if (!pad->constructors.back().parameters.empty()) {
              error(
                  (yylsp[-1]), yyscanner,
                  ("single-interface--based service " + data->currentName
                   + " constructor " + pad->constructors.back().name
                   + " rest parameter " + id + " must be first parameter"));
              YYERROR;
          }
      } else if (!pad->constructors.back().parameters.empty()
                 && pad->constructors.back().parameters.back().rest)
      {
          error(
              (yylsp[-5]), yyscanner,
              ("single-interface--based service " + data->currentName
               + " constructor " + pad->constructors.back().name
               + " rest parameter must be last parameter"));
          YYERROR;
      }
      for (const auto & i: pad->constructors.back().parameters) {
          if (id == i.name) {
              error(
                  (yylsp[0]), yyscanner,
                  ("single-interface--based service " + data->currentName
                   + " constructor " + pad->constructors.back().name
                   + " parameter " + id
                   + " has same identifier as another parameter"));
              YYERROR;
          }
      }
      pad->constructors.back().parameters.push_back(
          unoidl::detail::SourceProviderSingleInterfaceBasedServiceEntityPad::Constructor::Parameter(
              id, std::move(t), (yyvsp[-1].bval)));
  }
#line 4040 "/build/libreoffice-still/src/libreoffice-25.8.5.2/workdir/YaccTarget/unoidl/source/sourceprovider-parser.cxx"
    break;

  case 82: /* ellipsis_opt: TOK_ELLIPSIS  */
#line 2540 "/build/libreoffice-still/src/libreoffice-25.8.5.2/unoidl/source/sourceprovider-parser.y"
               { (yyval.bval) = true; }
#line 4046 "/build/libreoffice-still/src/libreoffice-25.8.5.2/workdir/YaccTarget/unoidl/source/sourceprovider-parser.cxx"
    break;

  case 83: /* ellipsis_opt: %empty  */
#line 2541 "/build/libreoffice-still/src/libreoffice-25.8.5.2/unoidl/source/sourceprovider-parser.y"
              { (yyval.bval) = false; }
#line 4052 "/build/libreoffice-still/src/libreoffice-25.8.5.2/workdir/YaccTarget/unoidl/source/sourceprovider-parser.cxx"
    break;

  case 84: /* $@12: %empty  */
#line 2545 "/build/libreoffice-still/src/libreoffice-25.8.5.2/unoidl/source/sourceprovider-parser.y"
  {
      unoidl::detail::SourceProviderScannerData * data = yyget_extra(yyscanner);
      data->publishedContext = (yyvsp[-2].bval);
      convertToCurrentName(data, (yyvsp[0].sval));
      if (!data->entities.emplace(
                  data->currentName,
                  unoidl::detail::SourceProviderEntity(
                      new unoidl::detail::SourceProviderAccumulationBasedServiceEntityPad(
                          (yyvsp[-2].bval)))).
          second)
      {
          error((yylsp[0]), yyscanner, "multiple entities named " + data->currentName);
          YYERROR;
      }
  }
#line 4072 "/build/libreoffice-still/src/libreoffice-25.8.5.2/workdir/YaccTarget/unoidl/source/sourceprovider-parser.cxx"
    break;

  case 85: /* accumulationBasedServiceDefn: deprecated_opt published_opt TOK_SERVICE identifier $@12 '{' serviceMembers '}' ';'  */
#line 2561 "/build/libreoffice-still/src/libreoffice-25.8.5.2/unoidl/source/sourceprovider-parser.y"
  {
      unoidl::detail::SourceProviderScannerData * data = yyget_extra(yyscanner);
      unoidl::detail::SourceProviderEntity * ent = getCurrentEntity(data);
      unoidl::detail::SourceProviderAccumulationBasedServiceEntityPad * pad =
          dynamic_cast<unoidl::detail::SourceProviderAccumulationBasedServiceEntityPad *>(
              ent->pad.get());
      assert(pad != nullptr);
      ent->entity = new unoidl::AccumulationBasedServiceEntity(
          pad->isPublished(), std::move(pad->directMandatoryBaseServices),
          std::move(pad->directOptionalBaseServices), std::move(pad->directMandatoryBaseInterfaces),
          std::move(pad->directOptionalBaseInterfaces), std::move(pad->directProperties),
          annotations((yyvsp[-8].bval)));
      ent->pad.clear();
      clearCurrentState(data);
  }
#line 4092 "/build/libreoffice-still/src/libreoffice-25.8.5.2/workdir/YaccTarget/unoidl/source/sourceprovider-parser.cxx"
    break;

  case 91: /* serviceBase: deprecated_opt flagSection_opt TOK_SERVICE name ';'  */
#line 2591 "/build/libreoffice-still/src/libreoffice-25.8.5.2/unoidl/source/sourceprovider-parser.y"
  {
      unoidl::detail::SourceProviderScannerData * data = yyget_extra(yyscanner);
      OUString name(convertName((yyvsp[-1].sval)));
      rtl::Reference<unoidl::detail::SourceProviderAccumulationBasedServiceEntityPad> pad(
          getCurrentPad<unoidl::detail::SourceProviderAccumulationBasedServiceEntityPad>(
              data));
      if (((yyvsp[-3].flags) & ~unoidl::detail::FLAG_OPTIONAL) != 0) {
          error(
              (yylsp[-3]), yyscanner,
              u"service base can only be flagged as [optional]"_ustr);
          YYERROR;
      }
      bool opt = ((yyvsp[-3].flags) & unoidl::detail::FLAG_OPTIONAL) != 0;
      unoidl::detail::SourceProviderEntity const * p;
      if (findEntity((yylsp[-1]), yyscanner, data, false, &name, &p, nullptr, nullptr)
          == FOUND_ERROR)
      {
          YYERROR;
      }
      if (p == nullptr || !p->entity.is()
          || (p->entity->getSort()
              != unoidl::Entity::SORT_ACCUMULATION_BASED_SERVICE))
      {
          error(
              (yylsp[-1]), yyscanner,
              ("accumulation-based service " + data->currentName
               + " direct base service " + name
               + " does not resolve to an accumulation-based service"));
          YYERROR;
      }
      if (data->publishedContext
          && !static_cast<unoidl::AccumulationBasedServiceEntity *>(
              p->entity.get())->isPublished())
      {
          error(
              (yylsp[-1]), yyscanner,
              ("published accumulation-based service " + data->currentName
               + " direct base service " + name + " is unpublished"));
          YYERROR;
      }
      std::vector<unoidl::AnnotatedReference> & v(
          opt
          ? pad->directOptionalBaseServices : pad->directMandatoryBaseServices);
      for (const auto & i: v) {
          if (name == i.name) {
              error(
                  (yylsp[-1]), yyscanner,
                  ("accumulation-based service " + data->currentName
                   + " duplicate direct base service " + name));
              YYERROR;
          }
      }
      v.emplace_back(name, annotations((yyvsp[-4].bval)));
  }
#line 4151 "/build/libreoffice-still/src/libreoffice-25.8.5.2/workdir/YaccTarget/unoidl/source/sourceprovider-parser.cxx"
    break;

  case 92: /* serviceInterfaceBase: deprecated_opt flagSection_opt TOK_INTERFACE name ';'  */
#line 2649 "/build/libreoffice-still/src/libreoffice-25.8.5.2/unoidl/source/sourceprovider-parser.y"
  {
      unoidl::detail::SourceProviderScannerData * data = yyget_extra(yyscanner);
      OUString name(convertName((yyvsp[-1].sval)));
      rtl::Reference<unoidl::detail::SourceProviderAccumulationBasedServiceEntityPad> pad(
          getCurrentPad<unoidl::detail::SourceProviderAccumulationBasedServiceEntityPad>(
              data));
      if (((yyvsp[-3].flags) & ~unoidl::detail::FLAG_OPTIONAL) != 0) {
          error(
              (yylsp[-3]), yyscanner,
              u"interface base can only be flagged as [optional]"_ustr);
          YYERROR;
      }
      bool opt = ((yyvsp[-3].flags) & unoidl::detail::FLAG_OPTIONAL) != 0;
      unoidl::detail::SourceProviderEntity const * p;
      if (findEntity((yylsp[-1]), yyscanner, data, false, &name, &p, nullptr, nullptr)
          == FOUND_ERROR)
      {
          YYERROR;
      }
      bool ifcBase = false;
      bool pubBase = false;
      if (p != nullptr) {
          switch (p->kind) {
          case unoidl::detail::SourceProviderEntity::KIND_INTERFACE_DECL:
              ifcBase = true;
              pubBase = false;
              break;
          case unoidl::detail::SourceProviderEntity::KIND_PUBLISHED_INTERFACE_DECL:
              ifcBase = true;
              pubBase = true;
              break;
          default:
              if (p->entity.is()
                  && (p->entity->getSort()
                      == unoidl::Entity::SORT_INTERFACE_TYPE))
              {
                  ifcBase = true;
                  pubBase = static_cast<unoidl::InterfaceTypeEntity *>(
                      p->entity.get())->isPublished();
              }
              break;
          }
      }
      if (!ifcBase) {
          error(
              (yylsp[-1]), yyscanner,
              ("accumulation-based service " + data->currentName
               + " direct base interface " + name
               + " does not resolve to an interface type"));
          YYERROR;
      }
      if (data->publishedContext && !opt && !pubBase) {
          error(
              (yylsp[-1]), yyscanner,
              ("published accumulation-based service " + data->currentName
               + " direct base interface " + name + " is unpublished"));
          YYERROR;
      }
      std::vector<unoidl::AnnotatedReference> & v(
          opt
          ? pad->directOptionalBaseInterfaces
          : pad->directMandatoryBaseInterfaces);
      for (const auto & i: v) {
          if (name == i.name) {
              error(
                  (yylsp[-1]), yyscanner,
                  ("accumulation-based service " + data->currentName
                   + " duplicate direct base interface " + name));
              YYERROR;
          }
      }
      v.emplace_back(name, annotations((yyvsp[-4].bval)));
  }
#line 4229 "/build/libreoffice-still/src/libreoffice-25.8.5.2/workdir/YaccTarget/unoidl/source/sourceprovider-parser.cxx"
    break;

  case 93: /* serviceProperty: deprecated_opt flagSection type identifier ';'  */
#line 2726 "/build/libreoffice-still/src/libreoffice-25.8.5.2/unoidl/source/sourceprovider-parser.y"
  {
      unoidl::detail::SourceProviderScannerData * data = yyget_extra(yyscanner);
      unoidl::detail::SourceProviderType t(*(yyvsp[-2].type));
      delete (yyvsp[-2].type);
      OUString id(convertName((yyvsp[-1].sval)));
      if (((yyvsp[-3].flags) & unoidl::detail::FLAG_PROPERTY) == 0) {
          error(
              (yylsp[-3]), yyscanner,
              (u"accumulation-based service property must be flagged as"
               " [property]"_ustr));
          YYERROR;
      }
      if (((yyvsp[-3].flags)
           & ~(unoidl::detail::FLAG_BOUND | unoidl::detail::FLAG_CONSTRAINED
               | unoidl::detail::FLAG_MAYBEAMBIGUOUS
               | unoidl::detail::FLAG_MAYBEDEFAULT
               | unoidl::detail::FLAG_MAYBEVOID | unoidl::detail::FLAG_OPTIONAL
               | unoidl::detail::FLAG_PROPERTY | unoidl::detail::FLAG_READONLY
               | unoidl::detail::FLAG_REMOVABLE
               | unoidl::detail::FLAG_TRANSIENT))
          != 0)
      {
          error(
              (yylsp[-3]), yyscanner,
              (u"accumulation-based service property can only be flagged as"
               " [property, bound, constrained, maybeambiguous, maybedefault,"
               " maybevoid, optional, readonly, removable, transient]"_ustr));
          YYERROR;
      }
      int att = 0;
      if (((yyvsp[-3].flags) & unoidl::detail::FLAG_BOUND) != 0) {
          att |= unoidl::AccumulationBasedServiceEntity::Property::ATTRIBUTE_BOUND;
      }
      if (((yyvsp[-3].flags) & unoidl::detail::FLAG_CONSTRAINED) != 0) {
          att |= unoidl::AccumulationBasedServiceEntity::Property::ATTRIBUTE_CONSTRAINED;
      }
      if (((yyvsp[-3].flags) & unoidl::detail::FLAG_MAYBEAMBIGUOUS) != 0) {
          att |= unoidl::AccumulationBasedServiceEntity::Property::ATTRIBUTE_MAYBE_AMBIGUOUS;
      }
      if (((yyvsp[-3].flags) & unoidl::detail::FLAG_MAYBEDEFAULT) != 0) {
          att |= unoidl::AccumulationBasedServiceEntity::Property::ATTRIBUTE_MAYBE_DEFAULT;
      }
      if (((yyvsp[-3].flags) & unoidl::detail::FLAG_MAYBEVOID) != 0) {
          att |= unoidl::AccumulationBasedServiceEntity::Property::ATTRIBUTE_MAYBE_VOID;
      }
      if (((yyvsp[-3].flags) & unoidl::detail::FLAG_OPTIONAL) != 0) {
          att |= unoidl::AccumulationBasedServiceEntity::Property::ATTRIBUTE_OPTIONAL;
      }
      if (((yyvsp[-3].flags) & unoidl::detail::FLAG_READONLY) != 0) {
          att |= unoidl::AccumulationBasedServiceEntity::Property::ATTRIBUTE_READ_ONLY;
      }
      if (((yyvsp[-3].flags) & unoidl::detail::FLAG_REMOVABLE) != 0) {
          att |= unoidl::AccumulationBasedServiceEntity::Property::ATTRIBUTE_REMOVABLE;
      }
      if (((yyvsp[-3].flags) & unoidl::detail::FLAG_TRANSIENT) != 0) {
          att |= unoidl::AccumulationBasedServiceEntity::Property::ATTRIBUTE_TRANSIENT;
      }
      switch (t.type) {
      case unoidl::detail::SourceProviderType::TYPE_VOID:
      case unoidl::detail::SourceProviderType::TYPE_EXCEPTION:
          error(
              (yylsp[-2]), yyscanner,
              ("illegal accumulation-based service " + data->currentName
               + " direct property " + id + " type"));
          YYERROR;
          break;
      default:
          break;
      }
      rtl::Reference<unoidl::detail::SourceProviderAccumulationBasedServiceEntityPad>
          pad(getCurrentPad<unoidl::detail::SourceProviderAccumulationBasedServiceEntityPad>(
                  data));
      for (const auto & i: pad->directProperties) {
          if (id == i.name) {
              error(
                  (yylsp[-1]), yyscanner,
                  ("accumulation-based service " + data->currentName
                   + " duplicate direct property " + id));
              YYERROR;
          }
      }
      pad->directProperties.emplace_back(
          id, t.getName(),
          unoidl::AccumulationBasedServiceEntity::Property::Attributes(att),
          annotations((yyvsp[-4].bval)));
  }
#line 4320 "/build/libreoffice-still/src/libreoffice-25.8.5.2/workdir/YaccTarget/unoidl/source/sourceprovider-parser.cxx"
    break;

  case 94: /* interfaceBasedSingletonDefn: deprecated_opt published_opt TOK_SINGLETON identifier singleInheritance ';'  */
#line 2816 "/build/libreoffice-still/src/libreoffice-25.8.5.2/unoidl/source/sourceprovider-parser.y"
  {
      unoidl::detail::SourceProviderScannerData * data = yyget_extra(yyscanner);
      data->publishedContext = (yyvsp[-4].bval);
      OUString name(convertToFullName(data, (yyvsp[-2].sval)));
      OUString base(convertName((yyvsp[-1].sval)));
      unoidl::detail::SourceProviderEntity const * p;
      if (findEntity((yylsp[-1]), yyscanner, data, false, &base, &p, nullptr, nullptr)
          == FOUND_ERROR)
      {
          YYERROR;
      }
      bool ifcBase = false;
      bool pubBase = false;
      if (p != nullptr) {
          switch (p->kind) {
          case unoidl::detail::SourceProviderEntity::KIND_INTERFACE_DECL:
              ifcBase = true;
              pubBase = false;
              break;
          case unoidl::detail::SourceProviderEntity::KIND_PUBLISHED_INTERFACE_DECL:
              ifcBase = true;
              pubBase = true;
              break;
          default:
              if (p->entity.is()
                  && (p->entity->getSort()
                      == unoidl::Entity::SORT_INTERFACE_TYPE))
              {
                  ifcBase = true;
                  pubBase = static_cast<unoidl::InterfaceTypeEntity *>(
                      p->entity.get())->isPublished();
              }
              break;
          }
      }
      if (!ifcBase) {
          error(
              (yylsp[-1]), yyscanner,
              ("interface-based singleton " + name + " base " + base
               + " does not resolve to an interface type"));
          YYERROR;
      }
      if ((yyvsp[-4].bval) && !pubBase) {
          error(
              (yylsp[-1]), yyscanner,
              ("published interface-based singleton " + name + " base " + base
               + " is unpublished"));
          YYERROR;
      }
      if (!data->entities.emplace(
                  name,
                  unoidl::detail::SourceProviderEntity(
                      unoidl::detail::SourceProviderEntity::KIND_LOCAL,
                      new unoidl::InterfaceBasedSingletonEntity(
                          (yyvsp[-4].bval), base, annotations((yyvsp[-5].bval))))).
          second)
      {
          error((yylsp[-2]), yyscanner, "multiple entities named " + name);
          YYERROR;
      }
      clearCurrentState(data);
  }
#line 4387 "/build/libreoffice-still/src/libreoffice-25.8.5.2/workdir/YaccTarget/unoidl/source/sourceprovider-parser.cxx"
    break;

  case 95: /* serviceBasedSingletonDefn: deprecated_opt published_opt TOK_SINGLETON identifier '{' TOK_SERVICE name ';' '}' ';'  */
#line 2883 "/build/libreoffice-still/src/libreoffice-25.8.5.2/unoidl/source/sourceprovider-parser.y"
  {
      unoidl::detail::SourceProviderScannerData * data = yyget_extra(yyscanner);
      data->publishedContext = (yyvsp[-8].bval);
      OUString name(convertToFullName(data, (yyvsp[-6].sval)));
      OUString base(convertName((yyvsp[-3].sval)));
      unoidl::detail::SourceProviderEntity const * p;
      if (findEntity((yylsp[-3]), yyscanner, data, false, &base, &p, nullptr, nullptr)
          == FOUND_ERROR)
      {
          YYERROR;
      }
      if (p == nullptr
          || !p->entity.is()
          || (p->entity->getSort()
              != unoidl::Entity::SORT_ACCUMULATION_BASED_SERVICE))
      {
          error(
              (yylsp[-3]), yyscanner,
              ("service-based singleton " + name + " base " + base
               + " does not resolve to an accumulation-based service"));
          YYERROR;
      }
      if ((yyvsp[-8].bval)
          && !static_cast<unoidl::AccumulationBasedServiceEntity *>(
              p->entity.get())->isPublished())
      {
          error(
              (yylsp[-3]), yyscanner,
              ("published service-based singleton " + name + " base " + base
               + " is unpublished"));
          YYERROR;
      }
      if (!data->entities.emplace(
                  name,
                  unoidl::detail::SourceProviderEntity(
                      unoidl::detail::SourceProviderEntity::KIND_LOCAL,
                      new unoidl::ServiceBasedSingletonEntity(
                          (yyvsp[-8].bval), base, annotations((yyvsp[-9].bval))))).
          second)
      {
          error((yylsp[-6]), yyscanner, "multiple entities named " + name);
          YYERROR;
      }
      clearCurrentState(data);
  }
#line 4437 "/build/libreoffice-still/src/libreoffice-25.8.5.2/workdir/YaccTarget/unoidl/source/sourceprovider-parser.cxx"
    break;

  case 97: /* singleInheritance_opt: %empty  */
#line 2932 "/build/libreoffice-still/src/libreoffice-25.8.5.2/unoidl/source/sourceprovider-parser.y"
              { (yyval.sval) = nullptr; }
#line 4443 "/build/libreoffice-still/src/libreoffice-25.8.5.2/workdir/YaccTarget/unoidl/source/sourceprovider-parser.cxx"
    break;

  case 98: /* singleInheritance: ':' name  */
#line 2935 "/build/libreoffice-still/src/libreoffice-25.8.5.2/unoidl/source/sourceprovider-parser.y"
                            { (yyval.sval) = (yyvsp[0].sval); }
#line 4449 "/build/libreoffice-still/src/libreoffice-25.8.5.2/workdir/YaccTarget/unoidl/source/sourceprovider-parser.cxx"
    break;

  case 100: /* exceptionSpec_opt: %empty  */
#line 2940 "/build/libreoffice-still/src/libreoffice-25.8.5.2/unoidl/source/sourceprovider-parser.y"
              { (yyval.excns) = nullptr; }
#line 4455 "/build/libreoffice-still/src/libreoffice-25.8.5.2/workdir/YaccTarget/unoidl/source/sourceprovider-parser.cxx"
    break;

  case 101: /* exceptionSpec: TOK_RAISES '(' exceptions ')'  */
#line 2943 "/build/libreoffice-still/src/libreoffice-25.8.5.2/unoidl/source/sourceprovider-parser.y"
                                             { (yyval.excns) = (yyvsp[-1].excns); }
#line 4461 "/build/libreoffice-still/src/libreoffice-25.8.5.2/workdir/YaccTarget/unoidl/source/sourceprovider-parser.cxx"
    break;

  case 102: /* exceptions: exceptions ',' name  */
#line 2948 "/build/libreoffice-still/src/libreoffice-25.8.5.2/unoidl/source/sourceprovider-parser.y"
  {
      unoidl::detail::SourceProviderScannerData * data = yyget_extra(yyscanner);
      OUString name(convertName((yyvsp[0].sval)));
      unoidl::detail::SourceProviderEntity const * p;
      if (findEntity((yylsp[0]), yyscanner, data, false, &name, &p, nullptr, nullptr)
          == FOUND_ERROR)
      {
          delete (yyvsp[-2].excns); /* see commented-out %destructor above */
          YYERROR;
      }
      if (p == nullptr
          || !p->entity.is()
          || (p->entity->getSort() != unoidl::Entity::SORT_EXCEPTION_TYPE))
      {
          delete (yyvsp[-2].excns); /* see commented-out %destructor above */
          error(
              (yylsp[0]), yyscanner,
              ("exception " + name + " does not resolve to an exception type"));
          YYERROR;
      }
      if (data->publishedContext
          && !(static_cast<unoidl::ExceptionTypeEntity *>(p->entity.get())
               ->isPublished()))
      {
          delete (yyvsp[-2].excns); /* see commented-out %destructor above */
          error(
              (yylsp[0]), yyscanner,
              ("unpublished exception " + name + " used in published context"));
          YYERROR;
      }
      if (std::find((yyvsp[-2].excns)->begin(), (yyvsp[-2].excns)->end(), name) != (yyvsp[-2].excns)->end()) {
          delete (yyvsp[-2].excns); /* see commented-out %destructor above */
          error(
              (yylsp[0]), yyscanner, ("exception " + name + " listed more than once"));
          YYERROR;
      }
      (yyvsp[-2].excns)->push_back(name);
      (yyval.excns) = (yyvsp[-2].excns);
  }
#line 4505 "/build/libreoffice-still/src/libreoffice-25.8.5.2/workdir/YaccTarget/unoidl/source/sourceprovider-parser.cxx"
    break;

  case 103: /* exceptions: name  */
#line 2988 "/build/libreoffice-still/src/libreoffice-25.8.5.2/unoidl/source/sourceprovider-parser.y"
  {
      unoidl::detail::SourceProviderScannerData * data = yyget_extra(yyscanner);
      OUString name(convertName((yyvsp[0].sval)));
      unoidl::detail::SourceProviderEntity const * p;
      if (findEntity((yylsp[0]), yyscanner, data, false, &name, &p, nullptr, nullptr)
          == FOUND_ERROR)
      {
          YYERROR;
      }
      if (p == nullptr
          || !p->entity.is()
          || (p->entity->getSort() != unoidl::Entity::SORT_EXCEPTION_TYPE))
      {
          error(
              (yylsp[0]), yyscanner,
              ("exception " + name + " does not resolve to an exception type"));
          YYERROR;
      }
      if (data->publishedContext
          && !(static_cast<unoidl::ExceptionTypeEntity *>(p->entity.get())
               ->isPublished()))
      {
          error(
              (yylsp[0]), yyscanner,
              ("unpublished exception " + name + " used in published context"));
          YYERROR;
      }
      (yyval.excns) = new std::vector<OUString>; (yyval.excns)->push_back(name);
  }
#line 4539 "/build/libreoffice-still/src/libreoffice-25.8.5.2/workdir/YaccTarget/unoidl/source/sourceprovider-parser.cxx"
    break;

  case 104: /* interfaceDecl: deprecated_opt published_opt TOK_INTERFACE identifier ';'  */
#line 3021 "/build/libreoffice-still/src/libreoffice-25.8.5.2/unoidl/source/sourceprovider-parser.y"
  {
      unoidl::detail::SourceProviderScannerData * data = yyget_extra(yyscanner);
      data->publishedContext = (yyvsp[-3].bval);
      OUString name(convertToFullName(data, (yyvsp[-1].sval)));
      std::pair<std::map<OUString, unoidl::detail::SourceProviderEntity>::iterator, bool> p(
          data->entities.emplace(
                  name,
                  unoidl::detail::SourceProviderEntity(
                      (yyvsp[-3].bval)
                      ? unoidl::detail::SourceProviderEntity::KIND_PUBLISHED_INTERFACE_DECL
                      : unoidl::detail::SourceProviderEntity::KIND_INTERFACE_DECL)));
      if (!p.second) {
          switch (p.first->second.kind) {
          case unoidl::detail::SourceProviderEntity::KIND_INTERFACE_DECL:
              if ((yyvsp[-3].bval)) {
                  p.first->second.kind
                      = unoidl::detail::SourceProviderEntity::KIND_PUBLISHED_INTERFACE_DECL;
              }
              break;
          case unoidl::detail::SourceProviderEntity::KIND_PUBLISHED_INTERFACE_DECL:
              break;
          default:
              assert(p.first->second.entity.is());
              if (p.first->second.entity->getSort()
                  != unoidl::Entity::SORT_INTERFACE_TYPE)
              {
                  error(
                      (yylsp[-1]), yyscanner,
                      "multiple entities named " + data->currentName);
                  YYERROR;
              }
              if ((yyvsp[-3].bval)
                  && !static_cast<unoidl::InterfaceTypeEntity *>(
                      p.first->second.entity.get())->isPublished())
              {
                  error(
                      (yylsp[-1]), yyscanner,
                      ("published interface type declaration "
                       + data->currentName + " has been defined unpublished"));
                  YYERROR;
              }
          }
      }
      clearCurrentState(data);
  }
#line 4589 "/build/libreoffice-still/src/libreoffice-25.8.5.2/workdir/YaccTarget/unoidl/source/sourceprovider-parser.cxx"
    break;

  case 105: /* published_opt: TOK_PUBLISHED  */
#line 3069 "/build/libreoffice-still/src/libreoffice-25.8.5.2/unoidl/source/sourceprovider-parser.y"
                { (yyval.bval) = true; }
#line 4595 "/build/libreoffice-still/src/libreoffice-25.8.5.2/workdir/YaccTarget/unoidl/source/sourceprovider-parser.cxx"
    break;

  case 106: /* published_opt: %empty  */
#line 3070 "/build/libreoffice-still/src/libreoffice-25.8.5.2/unoidl/source/sourceprovider-parser.y"
              { (yyval.bval) = false; }
#line 4601 "/build/libreoffice-still/src/libreoffice-25.8.5.2/workdir/YaccTarget/unoidl/source/sourceprovider-parser.cxx"
    break;

  case 108: /* flagSection_opt: %empty  */
#line 3075 "/build/libreoffice-still/src/libreoffice-25.8.5.2/unoidl/source/sourceprovider-parser.y"
              { (yyval.flags) = unoidl::detail::SourceProviderFlags(0); }
#line 4607 "/build/libreoffice-still/src/libreoffice-25.8.5.2/workdir/YaccTarget/unoidl/source/sourceprovider-parser.cxx"
    break;

  case 109: /* flagSection: '[' flags ']'  */
#line 3078 "/build/libreoffice-still/src/libreoffice-25.8.5.2/unoidl/source/sourceprovider-parser.y"
                           { (yyval.flags) = (yyvsp[-1].flags); }
#line 4613 "/build/libreoffice-still/src/libreoffice-25.8.5.2/workdir/YaccTarget/unoidl/source/sourceprovider-parser.cxx"
    break;

  case 110: /* flags: flags ',' flag  */
#line 3083 "/build/libreoffice-still/src/libreoffice-25.8.5.2/unoidl/source/sourceprovider-parser.y"
  {
      if (((yyvsp[-2].flags) & (yyvsp[0].flags)) != 0) {
          error((yylsp[0]), yyscanner, "duplicate flag " + flagName((yyvsp[0].flags)));
          YYERROR;
      }
      (yyval.flags) = unoidl::detail::SourceProviderFlags((yyvsp[-2].flags) | (yyvsp[0].flags));
  }
#line 4625 "/build/libreoffice-still/src/libreoffice-25.8.5.2/workdir/YaccTarget/unoidl/source/sourceprovider-parser.cxx"
    break;

  case 112: /* flag: TOK_ATTRIBUTE  */
#line 3094 "/build/libreoffice-still/src/libreoffice-25.8.5.2/unoidl/source/sourceprovider-parser.y"
                { (yyval.flags) = unoidl::detail::FLAG_ATTRIBUTE; }
#line 4631 "/build/libreoffice-still/src/libreoffice-25.8.5.2/workdir/YaccTarget/unoidl/source/sourceprovider-parser.cxx"
    break;

  case 113: /* flag: TOK_BOUND  */
#line 3095 "/build/libreoffice-still/src/libreoffice-25.8.5.2/unoidl/source/sourceprovider-parser.y"
            { (yyval.flags) = unoidl::detail::FLAG_BOUND; }
#line 4637 "/build/libreoffice-still/src/libreoffice-25.8.5.2/workdir/YaccTarget/unoidl/source/sourceprovider-parser.cxx"
    break;

  case 114: /* flag: TOK_CONSTRAINED  */
#line 3096 "/build/libreoffice-still/src/libreoffice-25.8.5.2/unoidl/source/sourceprovider-parser.y"
                  { (yyval.flags) = unoidl::detail::FLAG_CONSTRAINED; }
#line 4643 "/build/libreoffice-still/src/libreoffice-25.8.5.2/workdir/YaccTarget/unoidl/source/sourceprovider-parser.cxx"
    break;

  case 115: /* flag: TOK_MAYBEAMBIGUOUS  */
#line 3097 "/build/libreoffice-still/src/libreoffice-25.8.5.2/unoidl/source/sourceprovider-parser.y"
                     { (yyval.flags) = unoidl::detail::FLAG_MAYBEAMBIGUOUS; }
#line 4649 "/build/libreoffice-still/src/libreoffice-25.8.5.2/workdir/YaccTarget/unoidl/source/sourceprovider-parser.cxx"
    break;

  case 116: /* flag: TOK_MAYBEDEFAULT  */
#line 3098 "/build/libreoffice-still/src/libreoffice-25.8.5.2/unoidl/source/sourceprovider-parser.y"
                   { (yyval.flags) = unoidl::detail::FLAG_MAYBEDEFAULT; }
#line 4655 "/build/libreoffice-still/src/libreoffice-25.8.5.2/workdir/YaccTarget/unoidl/source/sourceprovider-parser.cxx"
    break;

  case 117: /* flag: TOK_MAYBEVOID  */
#line 3099 "/build/libreoffice-still/src/libreoffice-25.8.5.2/unoidl/source/sourceprovider-parser.y"
                { (yyval.flags) = unoidl::detail::FLAG_MAYBEVOID; }
#line 4661 "/build/libreoffice-still/src/libreoffice-25.8.5.2/workdir/YaccTarget/unoidl/source/sourceprovider-parser.cxx"
    break;

  case 118: /* flag: TOK_OPTIONAL  */
#line 3100 "/build/libreoffice-still/src/libreoffice-25.8.5.2/unoidl/source/sourceprovider-parser.y"
               { (yyval.flags) = unoidl::detail::FLAG_OPTIONAL; }
#line 4667 "/build/libreoffice-still/src/libreoffice-25.8.5.2/workdir/YaccTarget/unoidl/source/sourceprovider-parser.cxx"
    break;

  case 119: /* flag: TOK_PROPERTY  */
#line 3101 "/build/libreoffice-still/src/libreoffice-25.8.5.2/unoidl/source/sourceprovider-parser.y"
               { (yyval.flags) = unoidl::detail::FLAG_PROPERTY; }
#line 4673 "/build/libreoffice-still/src/libreoffice-25.8.5.2/workdir/YaccTarget/unoidl/source/sourceprovider-parser.cxx"
    break;

  case 120: /* flag: TOK_READONLY  */
#line 3102 "/build/libreoffice-still/src/libreoffice-25.8.5.2/unoidl/source/sourceprovider-parser.y"
               { (yyval.flags) = unoidl::detail::FLAG_READONLY; }
#line 4679 "/build/libreoffice-still/src/libreoffice-25.8.5.2/workdir/YaccTarget/unoidl/source/sourceprovider-parser.cxx"
    break;

  case 121: /* flag: TOK_REMOVABLE  */
#line 3103 "/build/libreoffice-still/src/libreoffice-25.8.5.2/unoidl/source/sourceprovider-parser.y"
                { (yyval.flags) = unoidl::detail::FLAG_REMOVABLE; }
#line 4685 "/build/libreoffice-still/src/libreoffice-25.8.5.2/workdir/YaccTarget/unoidl/source/sourceprovider-parser.cxx"
    break;

  case 122: /* flag: TOK_TRANSIENT  */
#line 3104 "/build/libreoffice-still/src/libreoffice-25.8.5.2/unoidl/source/sourceprovider-parser.y"
                { (yyval.flags) = unoidl::detail::FLAG_TRANSIENT; }
#line 4691 "/build/libreoffice-still/src/libreoffice-25.8.5.2/workdir/YaccTarget/unoidl/source/sourceprovider-parser.cxx"
    break;

  case 124: /* orExpr: orExpr '|' xorExpr  */
#line 3112 "/build/libreoffice-still/src/libreoffice-25.8.5.2/unoidl/source/sourceprovider-parser.y"
  {
      if (!coerce((yylsp[-2]), yyscanner, &(yyvsp[-2].expr), &(yyvsp[0].expr))) {
          YYERROR;
      }
      switch ((yyvsp[-2].expr).type) {
      case unoidl::detail::SourceProviderExpr::TYPE_INT:
          (yyval.expr) = unoidl::detail::SourceProviderExpr::Int((yyvsp[-2].expr).ival | (yyvsp[0].expr).ival);
          break;
      case unoidl::detail::SourceProviderExpr::TYPE_UINT:
          (yyval.expr) = unoidl::detail::SourceProviderExpr::Uint((yyvsp[-2].expr).uval | (yyvsp[0].expr).uval);
          break;
      default:
          error((yylsp[-2]), yyscanner, u"arguments of non-integer type to \"|\""_ustr);
          YYERROR;
          break;
      }
  }
#line 4713 "/build/libreoffice-still/src/libreoffice-25.8.5.2/workdir/YaccTarget/unoidl/source/sourceprovider-parser.cxx"
    break;

  case 126: /* xorExpr: xorExpr '^' andExpr  */
#line 3134 "/build/libreoffice-still/src/libreoffice-25.8.5.2/unoidl/source/sourceprovider-parser.y"
  {
      if (!coerce((yylsp[-2]), yyscanner, &(yyvsp[-2].expr), &(yyvsp[0].expr))) {
          YYERROR;
      }
      switch ((yyvsp[-2].expr).type) {
      case unoidl::detail::SourceProviderExpr::TYPE_INT:
          (yyval.expr) = unoidl::detail::SourceProviderExpr::Int((yyvsp[-2].expr).ival ^ (yyvsp[0].expr).ival);
          break;
      case unoidl::detail::SourceProviderExpr::TYPE_UINT:
          (yyval.expr) = unoidl::detail::SourceProviderExpr::Uint((yyvsp[-2].expr).uval ^ (yyvsp[0].expr).uval);
          break;
      default:
          error((yylsp[-2]), yyscanner, u"arguments of non-integer type to \"^\""_ustr);
          YYERROR;
          break;
      }
  }
#line 4735 "/build/libreoffice-still/src/libreoffice-25.8.5.2/workdir/YaccTarget/unoidl/source/sourceprovider-parser.cxx"
    break;

  case 128: /* andExpr: andExpr '&' shiftExpr  */
#line 3156 "/build/libreoffice-still/src/libreoffice-25.8.5.2/unoidl/source/sourceprovider-parser.y"
  {
      if (!coerce((yylsp[-2]), yyscanner, &(yyvsp[-2].expr), &(yyvsp[0].expr))) {
          YYERROR;
      }
      switch ((yyvsp[-2].expr).type) {
      case unoidl::detail::SourceProviderExpr::TYPE_INT:
          (yyval.expr) = unoidl::detail::SourceProviderExpr::Int((yyvsp[-2].expr).ival & (yyvsp[0].expr).ival);
          break;
      case unoidl::detail::SourceProviderExpr::TYPE_UINT:
          (yyval.expr) = unoidl::detail::SourceProviderExpr::Uint((yyvsp[-2].expr).uval & (yyvsp[0].expr).uval);
          break;
      default:
          error((yylsp[-2]), yyscanner, u"arguments of non-integer type to \"&\""_ustr);
          YYERROR;
          break;
      }
  }
#line 4757 "/build/libreoffice-still/src/libreoffice-25.8.5.2/workdir/YaccTarget/unoidl/source/sourceprovider-parser.cxx"
    break;

  case 130: /* shiftExpr: shiftExpr TOK_LEFTSHIFT addExpr  */
#line 3178 "/build/libreoffice-still/src/libreoffice-25.8.5.2/unoidl/source/sourceprovider-parser.y"
  {
      int n;
      switch ((yyvsp[0].expr).type) {
      case unoidl::detail::SourceProviderExpr::TYPE_INT:
          if ((yyvsp[0].expr).ival < 0 || (yyvsp[0].expr).ival > 63) {
              error(
                  (yylsp[0]), yyscanner,
                  ("out-of-range shift argument " + OUString::number((yyvsp[0].expr).ival)
                   + " to \"<<\" "));
              YYERROR;
          }
          n = static_cast<int>((yyvsp[0].expr).ival);
          break;
      case unoidl::detail::SourceProviderExpr::TYPE_UINT:
          if ((yyvsp[0].expr).uval > 63) {
              error(
                  (yylsp[0]), yyscanner,
                  ("out-of-range shift argument " + OUString::number((yyvsp[0].expr).uval)
                   + " to \"<<\" "));
              YYERROR;
          }
          n = static_cast<int>((yyvsp[0].expr).uval);
          break;
      default:
          error((yylsp[0]), yyscanner, u"right argument of non-integer type to \"<<\""_ustr);
          YYERROR;
      }
      switch ((yyvsp[-2].expr).type) {
      case unoidl::detail::SourceProviderExpr::TYPE_INT:
          if ((yyvsp[-2].expr).ival < 0) {
              error(
                  (yylsp[-2]), yyscanner,
                  ("cannot left-shift negative argument "
                   + OUString::number((yyvsp[-2].expr).ival)));
              YYERROR;
          }
          (yyval.expr) = unoidl::detail::SourceProviderExpr::Int((yyvsp[-2].expr).ival << n);
          break;
      case unoidl::detail::SourceProviderExpr::TYPE_UINT:
          (yyval.expr) = unoidl::detail::SourceProviderExpr::Uint((yyvsp[-2].expr).uval << n);
          break;
      default:
          error((yylsp[-2]), yyscanner, u"left argument of non-integer type to \"<<\""_ustr);
          YYERROR;
          break;
      }
  }
#line 4809 "/build/libreoffice-still/src/libreoffice-25.8.5.2/workdir/YaccTarget/unoidl/source/sourceprovider-parser.cxx"
    break;

  case 131: /* shiftExpr: shiftExpr TOK_RIGHTSHIFT addExpr  */
#line 3226 "/build/libreoffice-still/src/libreoffice-25.8.5.2/unoidl/source/sourceprovider-parser.y"
  {
      int n;
      switch ((yyvsp[0].expr).type) {
      case unoidl::detail::SourceProviderExpr::TYPE_INT:
          if ((yyvsp[0].expr).ival < 0 || (yyvsp[0].expr).ival > 63) {
              error(
                  (yylsp[0]), yyscanner,
                  ("out-of-range shift argument " + OUString::number((yyvsp[0].expr).ival)
                   + " to \">>\" "));
              YYERROR;
          }
          n = static_cast<int>((yyvsp[0].expr).ival);
          break;
      case unoidl::detail::SourceProviderExpr::TYPE_UINT:
          if ((yyvsp[0].expr).uval > 63) {
              error(
                  (yylsp[0]), yyscanner,
                  ("out-of-range shift argument " + OUString::number((yyvsp[0].expr).uval)
                   + " to \">>\" "));
              YYERROR;
          }
          n = static_cast<int>((yyvsp[0].expr).uval);
          break;
      default:
          error((yylsp[0]), yyscanner, u"right argument of non-integer type to \">>\""_ustr);
          YYERROR;
          break;
      }
      switch ((yyvsp[-2].expr).type) {
      case unoidl::detail::SourceProviderExpr::TYPE_INT:
          (yyval.expr) = unoidl::detail::SourceProviderExpr::Int((yyvsp[-2].expr).ival >> n);
          break;
      case unoidl::detail::SourceProviderExpr::TYPE_UINT:
          (yyval.expr) = unoidl::detail::SourceProviderExpr::Uint((yyvsp[-2].expr).uval >> n);
          break;
      default:
          error((yylsp[-2]), yyscanner, u"left argument of non-integer type to \">>\""_ustr);
          YYERROR;
          break;
      }
  }
#line 4855 "/build/libreoffice-still/src/libreoffice-25.8.5.2/workdir/YaccTarget/unoidl/source/sourceprovider-parser.cxx"
    break;

  case 133: /* addExpr: addExpr '+' multExpr  */
#line 3272 "/build/libreoffice-still/src/libreoffice-25.8.5.2/unoidl/source/sourceprovider-parser.y"
  {
      if (!coerce((yylsp[-2]), yyscanner, &(yyvsp[-2].expr), &(yyvsp[0].expr))) {
          YYERROR;
      }
      switch ((yyvsp[-2].expr).type) {
      case unoidl::detail::SourceProviderExpr::TYPE_BOOL:
          error((yylsp[-2]), yyscanner, u"arguments of boolean type to binary \"+\""_ustr);
          YYERROR;
          break;
      case unoidl::detail::SourceProviderExpr::TYPE_INT:
          (yyval.expr) = unoidl::detail::SourceProviderExpr::Int((yyvsp[-2].expr).ival + (yyvsp[0].expr).ival); //TODO: overflow
          break;
      case unoidl::detail::SourceProviderExpr::TYPE_UINT:
          (yyval.expr) = unoidl::detail::SourceProviderExpr::Uint((yyvsp[-2].expr).uval + (yyvsp[0].expr).uval); //TODO: overflow
          break;
      case unoidl::detail::SourceProviderExpr::TYPE_FLOAT:
          (yyval.expr) = unoidl::detail::SourceProviderExpr::Float((yyvsp[-2].expr).fval + (yyvsp[0].expr).fval);
          break;
      }
  }
#line 4880 "/build/libreoffice-still/src/libreoffice-25.8.5.2/workdir/YaccTarget/unoidl/source/sourceprovider-parser.cxx"
    break;

  case 134: /* addExpr: addExpr '-' multExpr  */
#line 3293 "/build/libreoffice-still/src/libreoffice-25.8.5.2/unoidl/source/sourceprovider-parser.y"
  {
      if (!coerce((yylsp[-2]), yyscanner, &(yyvsp[-2].expr), &(yyvsp[0].expr))) {
          YYERROR;
      }
      switch ((yyvsp[-2].expr).type) {
      case unoidl::detail::SourceProviderExpr::TYPE_BOOL:
          error((yylsp[-2]), yyscanner, u"arguments of boolean type to binary \"-\""_ustr);
          YYERROR;
          break;
      case unoidl::detail::SourceProviderExpr::TYPE_INT:
          (yyval.expr) = unoidl::detail::SourceProviderExpr::Int((yyvsp[-2].expr).ival - (yyvsp[0].expr).ival); //TODO: overflow
          break;
      case unoidl::detail::SourceProviderExpr::TYPE_UINT:
          (yyval.expr) = unoidl::detail::SourceProviderExpr::Uint((yyvsp[-2].expr).uval - (yyvsp[0].expr).uval); //TODO: overflow
          break;
      case unoidl::detail::SourceProviderExpr::TYPE_FLOAT:
          (yyval.expr) = unoidl::detail::SourceProviderExpr::Float((yyvsp[-2].expr).fval - (yyvsp[0].expr).fval);
          break;
      }
  }
#line 4905 "/build/libreoffice-still/src/libreoffice-25.8.5.2/workdir/YaccTarget/unoidl/source/sourceprovider-parser.cxx"
    break;

  case 136: /* multExpr: multExpr '*' unaryExpr  */
#line 3318 "/build/libreoffice-still/src/libreoffice-25.8.5.2/unoidl/source/sourceprovider-parser.y"
  {
      if (!coerce((yylsp[-2]), yyscanner, &(yyvsp[-2].expr), &(yyvsp[0].expr))) {
          YYERROR;
      }
      switch ((yyvsp[-2].expr).type) {
      case unoidl::detail::SourceProviderExpr::TYPE_BOOL:
          error((yylsp[-2]), yyscanner, u"arguments of boolean type to \"*\""_ustr);
          YYERROR;
          break;
      case unoidl::detail::SourceProviderExpr::TYPE_INT:
          (yyval.expr) = unoidl::detail::SourceProviderExpr::Int((yyvsp[-2].expr).ival * (yyvsp[0].expr).ival); //TODO: overflow
          break;
      case unoidl::detail::SourceProviderExpr::TYPE_UINT:
          (yyval.expr) = unoidl::detail::SourceProviderExpr::Uint((yyvsp[-2].expr).uval * (yyvsp[0].expr).uval); //TODO: overflow
          break;
      case unoidl::detail::SourceProviderExpr::TYPE_FLOAT:
          (yyval.expr) = unoidl::detail::SourceProviderExpr::Float((yyvsp[-2].expr).fval * (yyvsp[0].expr).fval);
          break;
      }
  }
#line 4930 "/build/libreoffice-still/src/libreoffice-25.8.5.2/workdir/YaccTarget/unoidl/source/sourceprovider-parser.cxx"
    break;

  case 137: /* multExpr: multExpr '/' unaryExpr  */
#line 3339 "/build/libreoffice-still/src/libreoffice-25.8.5.2/unoidl/source/sourceprovider-parser.y"
  {
      if (!coerce((yylsp[-2]), yyscanner, &(yyvsp[-2].expr), &(yyvsp[0].expr))) {
          YYERROR;
      }
      switch ((yyvsp[-2].expr).type) {
      case unoidl::detail::SourceProviderExpr::TYPE_BOOL:
          error((yylsp[-2]), yyscanner, u"arguments of boolean type to \"/\""_ustr);
          YYERROR;
          break;
      case unoidl::detail::SourceProviderExpr::TYPE_INT:
          if ((yyvsp[0].expr).ival == 0) {
              error((yylsp[0]), yyscanner, u"cannot divide by zero"_ustr);
              YYERROR;
          }
          (yyval.expr) = unoidl::detail::SourceProviderExpr::Int((yyvsp[-2].expr).ival / (yyvsp[0].expr).ival);
          break;
      case unoidl::detail::SourceProviderExpr::TYPE_UINT:
          if ((yyvsp[0].expr).uval == 0) {
              error((yylsp[0]), yyscanner, u"cannot divide by zero"_ustr);
              YYERROR;
          }
          (yyval.expr) = unoidl::detail::SourceProviderExpr::Uint((yyvsp[-2].expr).uval / (yyvsp[0].expr).uval);
          break;
      case unoidl::detail::SourceProviderExpr::TYPE_FLOAT:
          if ((yyvsp[0].expr).fval == 0) {
              error((yylsp[0]), yyscanner, u"cannot divide by zero"_ustr);
              YYERROR;
          }
          (yyval.expr) = unoidl::detail::SourceProviderExpr::Float((yyvsp[-2].expr).fval - (yyvsp[0].expr).fval);
          break;
      }
  }
#line 4967 "/build/libreoffice-still/src/libreoffice-25.8.5.2/workdir/YaccTarget/unoidl/source/sourceprovider-parser.cxx"
    break;

  case 138: /* multExpr: multExpr '%' unaryExpr  */
#line 3372 "/build/libreoffice-still/src/libreoffice-25.8.5.2/unoidl/source/sourceprovider-parser.y"
  {
      if (!coerce((yylsp[-2]), yyscanner, &(yyvsp[-2].expr), &(yyvsp[0].expr))) {
          YYERROR;
      }
      switch ((yyvsp[-2].expr).type) {
      case unoidl::detail::SourceProviderExpr::TYPE_INT:
          if ((yyvsp[0].expr).ival == 0) {
              error((yylsp[0]), yyscanner, u"cannot divide by zero"_ustr);
              YYERROR;
          }
          (yyval.expr) = unoidl::detail::SourceProviderExpr::Int((yyvsp[-2].expr).ival % (yyvsp[0].expr).ival);
          break;
      case unoidl::detail::SourceProviderExpr::TYPE_UINT:
          if ((yyvsp[0].expr).uval == 0) {
              error((yylsp[0]), yyscanner, u"cannot divide by zero"_ustr);
              YYERROR;
          }
          (yyval.expr) = unoidl::detail::SourceProviderExpr::Uint((yyvsp[-2].expr).uval % (yyvsp[0].expr).uval);
          break;
      default:
          error((yylsp[-2]), yyscanner, u"arguments of non-integer type to \"%\""_ustr);
          YYERROR;
          break;
      }
  }
#line 4997 "/build/libreoffice-still/src/libreoffice-25.8.5.2/workdir/YaccTarget/unoidl/source/sourceprovider-parser.cxx"
    break;

  case 140: /* unaryExpr: '+' primaryExpr  */
#line 3402 "/build/libreoffice-still/src/libreoffice-25.8.5.2/unoidl/source/sourceprovider-parser.y"
  {
      if ((yyvsp[0].expr).type == unoidl::detail::SourceProviderExpr::TYPE_BOOL) {
          error((yylsp[0]), yyscanner, u"argument of boolean type to unary \"+\""_ustr);
          YYERROR;
      }
      (yyval.expr) = (yyvsp[0].expr);
  }
#line 5009 "/build/libreoffice-still/src/libreoffice-25.8.5.2/workdir/YaccTarget/unoidl/source/sourceprovider-parser.cxx"
    break;

  case 141: /* unaryExpr: '-' primaryExpr  */
#line 3410 "/build/libreoffice-still/src/libreoffice-25.8.5.2/unoidl/source/sourceprovider-parser.y"
  {
      switch ((yyvsp[0].expr).type) {
      case unoidl::detail::SourceProviderExpr::TYPE_BOOL:
          error((yylsp[0]), yyscanner, u"argument of boolean type to unary \"-\""_ustr);
          YYERROR;
          break;
      case unoidl::detail::SourceProviderExpr::TYPE_INT:
          if ((yyvsp[0].expr).ival == SAL_MIN_INT64) {
              error((yylsp[0]), yyscanner, u"cannot negate -2^63"_ustr);
              YYERROR;
          }
          (yyval.expr) = unoidl::detail::SourceProviderExpr::Int(-(yyvsp[0].expr).ival);
          break;
      case unoidl::detail::SourceProviderExpr::TYPE_UINT:
          if ((yyvsp[0].expr).uval == SAL_CONST_UINT64(0x8000000000000000)) {
              (yyval.expr) = unoidl::detail::SourceProviderExpr::Int(SAL_MIN_INT64);
          } else {
              if ((yyvsp[0].expr).uval > SAL_MAX_INT64) {
                  error(
                      (yylsp[0]), yyscanner,
                      ("cannot negate out-of-range value "
                       + OUString::number((yyvsp[0].expr).uval)));
                  YYERROR;
              }
              (yyval.expr) = unoidl::detail::SourceProviderExpr::Int(
                  -static_cast<sal_Int64>((yyvsp[0].expr).uval));
          }
          break;
      case unoidl::detail::SourceProviderExpr::TYPE_FLOAT:
          (yyval.expr) = unoidl::detail::SourceProviderExpr::Float(-(yyvsp[0].expr).fval);
          break;
      }
  }
#line 5047 "/build/libreoffice-still/src/libreoffice-25.8.5.2/workdir/YaccTarget/unoidl/source/sourceprovider-parser.cxx"
    break;

  case 142: /* unaryExpr: '~' primaryExpr  */
#line 3444 "/build/libreoffice-still/src/libreoffice-25.8.5.2/unoidl/source/sourceprovider-parser.y"
  {
      switch ((yyvsp[0].expr).type) {
      case unoidl::detail::SourceProviderExpr::TYPE_INT:
          (yyval.expr) = unoidl::detail::SourceProviderExpr::Int(~(yyvsp[0].expr).ival);
          break;
      case unoidl::detail::SourceProviderExpr::TYPE_UINT:
          (yyval.expr) = unoidl::detail::SourceProviderExpr::Uint(~(yyvsp[0].expr).uval);
          break;
      default:
          error((yylsp[0]), yyscanner, u"argument of non-integer type to \"~\""_ustr);
          YYERROR;
          break;
      }
  }
#line 5066 "/build/libreoffice-still/src/libreoffice-25.8.5.2/workdir/YaccTarget/unoidl/source/sourceprovider-parser.cxx"
    break;

  case 144: /* primaryExpr: '(' expr ')'  */
#line 3462 "/build/libreoffice-still/src/libreoffice-25.8.5.2/unoidl/source/sourceprovider-parser.y"
               { (yyval.expr) = (yyvsp[-1].expr); }
#line 5072 "/build/libreoffice-still/src/libreoffice-25.8.5.2/workdir/YaccTarget/unoidl/source/sourceprovider-parser.cxx"
    break;

  case 145: /* primaryExpr: TOK_FALSE  */
#line 3463 "/build/libreoffice-still/src/libreoffice-25.8.5.2/unoidl/source/sourceprovider-parser.y"
            { (yyval.expr) = unoidl::detail::SourceProviderExpr::Bool(false); }
#line 5078 "/build/libreoffice-still/src/libreoffice-25.8.5.2/workdir/YaccTarget/unoidl/source/sourceprovider-parser.cxx"
    break;

  case 146: /* primaryExpr: TOK_TRUE  */
#line 3464 "/build/libreoffice-still/src/libreoffice-25.8.5.2/unoidl/source/sourceprovider-parser.y"
           { (yyval.expr) = unoidl::detail::SourceProviderExpr::Bool(true); }
#line 5084 "/build/libreoffice-still/src/libreoffice-25.8.5.2/workdir/YaccTarget/unoidl/source/sourceprovider-parser.cxx"
    break;

  case 147: /* primaryExpr: TOK_INTEGER  */
#line 3465 "/build/libreoffice-still/src/libreoffice-25.8.5.2/unoidl/source/sourceprovider-parser.y"
              { (yyval.expr) = unoidl::detail::SourceProviderExpr::Uint((yyvsp[0].ival)); }
#line 5090 "/build/libreoffice-still/src/libreoffice-25.8.5.2/workdir/YaccTarget/unoidl/source/sourceprovider-parser.cxx"
    break;

  case 148: /* primaryExpr: TOK_FLOATING  */
#line 3466 "/build/libreoffice-still/src/libreoffice-25.8.5.2/unoidl/source/sourceprovider-parser.y"
               { (yyval.expr) = unoidl::detail::SourceProviderExpr::Float((yyvsp[0].fval)); }
#line 5096 "/build/libreoffice-still/src/libreoffice-25.8.5.2/workdir/YaccTarget/unoidl/source/sourceprovider-parser.cxx"
    break;

  case 149: /* primaryExpr: name  */
#line 3468 "/build/libreoffice-still/src/libreoffice-25.8.5.2/unoidl/source/sourceprovider-parser.y"
  {
      OUString name(convertName((yyvsp[0].sval)));
      unoidl::detail::SourceProviderScannerData * data = yyget_extra(yyscanner);
      unoidl::ConstantValue v(false); // dummy value
      bool found = false;
      bool unpub = false;
      sal_Int32 i = name.lastIndexOf('.');
      if (i == -1) {
          rtl::Reference<unoidl::detail::SourceProviderEntityPad> pad(
              getCurrentEntity(data)->pad);
          unoidl::detail::SourceProviderEnumTypeEntityPad * p1 = dynamic_cast<
              unoidl::detail::SourceProviderEnumTypeEntityPad *>(pad.get());
          if (p1 != nullptr) {
              for (const auto & j: p1->members) {
                  if (j.name == name) {
                      v = unoidl::ConstantValue(j.value);
                      found = true;
                      break;
                  }
              }
          } else {
              unoidl::detail::SourceProviderConstantGroupEntityPad * p2
                  = dynamic_cast<
                      unoidl::detail::SourceProviderConstantGroupEntityPad *>(
                          pad.get());
              if (p2 != nullptr) {
                  for (const auto & j: p2->members) {
                      if (j.name == name) {
                          v = j.value;
                          found = true;
                          break;
                      }
                  }
              }
          }
      } else {
          OUString scope(name.copy(0, i));
          unoidl::detail::SourceProviderEntity const * ent;
          if (findEntity(
                  (yylsp[0]), yyscanner, data, false, &scope, &ent, nullptr, nullptr)
              == FOUND_ERROR)
          {
              YYERROR;
          }
          if (ent != nullptr) {
              std::u16string_view id(name.subView(i + 1));
              // No need to check for enum members here, as they cannot be
              // referenced in expressions by qualified name (TODO: is that true?):
              if (ent->entity.is()) {
                  if (ent->entity->getSort()
                      == unoidl::Entity::SORT_CONSTANT_GROUP)
                  {
                      std::vector<unoidl::ConstantGroupEntity::Member> const &
                          mems(
                              static_cast<unoidl::ConstantGroupEntity *>(
                                  ent->entity.get())->
                              getMembers());
                      for (auto & j: mems) {
                          if (j.name == id) {
                              v = j.value;
                              found = true;
                              unpub
                                  = !static_cast<unoidl::ConstantGroupEntity *>(
                                      ent->entity.get())->isPublished();
                              break;
                          }
                      }
                  }
              } else if (ent->pad.is()) {
                  unoidl::detail::SourceProviderConstantGroupEntityPad * pad
                      = dynamic_cast<
                          unoidl::detail::SourceProviderConstantGroupEntityPad *>(
                              ent->pad.get());
                  if (pad != nullptr) {
                      for (const auto & j: pad->members) {
                          if (j.name == id) {
                              v = j.value;
                              found = true;
                              unpub = !ent->pad->isPublished();
                              break;
                          }
                      }
                  }
              }
          }
      }
      if (!found) {
          error(
              (yylsp[0]), yyscanner,
              (name
               + (" does not resolve to neither a constant nor an unqualified"
                  " enum member")));
          YYERROR;
      }
      if (data->publishedContext && unpub) {
          error(
              (yylsp[0]), yyscanner,
              "unpublished value " + name + " used in published context");
          YYERROR;
      }
      switch (v.type) {
      case unoidl::ConstantValue::TYPE_BOOLEAN:
          (yyval.expr) = unoidl::detail::SourceProviderExpr::Bool(v.booleanValue);
          break;
      case unoidl::ConstantValue::TYPE_BYTE:
          (yyval.expr) = unoidl::detail::SourceProviderExpr::Int(v.byteValue);
          break;
      case unoidl::ConstantValue::TYPE_SHORT:
          (yyval.expr) = unoidl::detail::SourceProviderExpr::Int(v.shortValue);
          break;
      case unoidl::ConstantValue::TYPE_UNSIGNED_SHORT:
          (yyval.expr) = unoidl::detail::SourceProviderExpr::Uint(v.unsignedShortValue);
          break;
      case unoidl::ConstantValue::TYPE_LONG:
          (yyval.expr) = unoidl::detail::SourceProviderExpr::Int(v.longValue);
          break;
      case unoidl::ConstantValue::TYPE_UNSIGNED_LONG:
          (yyval.expr) = unoidl::detail::SourceProviderExpr::Uint(v.unsignedLongValue);
          break;
      case unoidl::ConstantValue::TYPE_HYPER:
          (yyval.expr) = unoidl::detail::SourceProviderExpr::Int(v.hyperValue);
          break;
      case unoidl::ConstantValue::TYPE_UNSIGNED_HYPER:
          (yyval.expr) = unoidl::detail::SourceProviderExpr::Uint(v.unsignedHyperValue);
          break;
      case unoidl::ConstantValue::TYPE_FLOAT:
          (yyval.expr) = unoidl::detail::SourceProviderExpr::Float(v.floatValue);
          break;
      case unoidl::ConstantValue::TYPE_DOUBLE:
          (yyval.expr) = unoidl::detail::SourceProviderExpr::Float(v.doubleValue);
          break;
      }
  }
#line 5234 "/build/libreoffice-still/src/libreoffice-25.8.5.2/workdir/YaccTarget/unoidl/source/sourceprovider-parser.cxx"
    break;

  case 150: /* typeArguments: typeArguments ',' type  */
#line 3605 "/build/libreoffice-still/src/libreoffice-25.8.5.2/unoidl/source/sourceprovider-parser.y"
  {
      unoidl::detail::SourceProviderType t(*(yyvsp[0].type));
      delete (yyvsp[0].type);
      if (!checkTypeArgument((yylsp[0]), yyscanner, t)) {
          delete (yyvsp[-2].types); /* see commented-out %destructor above */
          YYERROR;
      }
      (yyvsp[-2].types)->push_back(t);
      (yyval.types) = (yyvsp[-2].types);
  }
#line 5249 "/build/libreoffice-still/src/libreoffice-25.8.5.2/workdir/YaccTarget/unoidl/source/sourceprovider-parser.cxx"
    break;

  case 151: /* typeArguments: type  */
#line 3616 "/build/libreoffice-still/src/libreoffice-25.8.5.2/unoidl/source/sourceprovider-parser.y"
  {
      unoidl::detail::SourceProviderType t(*(yyvsp[0].type));
      delete (yyvsp[0].type);
      if (!checkTypeArgument((yylsp[0]), yyscanner, t)) {
          YYERROR;
      }
      (yyval.types) = new std::vector<unoidl::detail::SourceProviderType>;
      (yyval.types)->push_back(t);
  }
#line 5263 "/build/libreoffice-still/src/libreoffice-25.8.5.2/workdir/YaccTarget/unoidl/source/sourceprovider-parser.cxx"
    break;

  case 152: /* type: TOK_VOID  */
#line 3629 "/build/libreoffice-still/src/libreoffice-25.8.5.2/unoidl/source/sourceprovider-parser.y"
  {
      (yyval.type) = new unoidl::detail::SourceProviderType(
          unoidl::detail::SourceProviderType::TYPE_VOID);
  }
#line 5272 "/build/libreoffice-still/src/libreoffice-25.8.5.2/workdir/YaccTarget/unoidl/source/sourceprovider-parser.cxx"
    break;

  case 153: /* type: TOK_BOOLEAN  */
#line 3634 "/build/libreoffice-still/src/libreoffice-25.8.5.2/unoidl/source/sourceprovider-parser.y"
  {
      (yyval.type) = new unoidl::detail::SourceProviderType(
          unoidl::detail::SourceProviderType::TYPE_BOOLEAN);
  }
#line 5281 "/build/libreoffice-still/src/libreoffice-25.8.5.2/workdir/YaccTarget/unoidl/source/sourceprovider-parser.cxx"
    break;

  case 154: /* type: TOK_BYTE  */
#line 3639 "/build/libreoffice-still/src/libreoffice-25.8.5.2/unoidl/source/sourceprovider-parser.y"
  {
      (yyval.type) = new unoidl::detail::SourceProviderType(
          unoidl::detail::SourceProviderType::TYPE_BYTE);
  }
#line 5290 "/build/libreoffice-still/src/libreoffice-25.8.5.2/workdir/YaccTarget/unoidl/source/sourceprovider-parser.cxx"
    break;

  case 155: /* type: TOK_SHORT  */
#line 3644 "/build/libreoffice-still/src/libreoffice-25.8.5.2/unoidl/source/sourceprovider-parser.y"
  {
      (yyval.type) = new unoidl::detail::SourceProviderType(
          unoidl::detail::SourceProviderType::TYPE_SHORT);
  }
#line 5299 "/build/libreoffice-still/src/libreoffice-25.8.5.2/workdir/YaccTarget/unoidl/source/sourceprovider-parser.cxx"
    break;

  case 156: /* type: TOK_UNSIGNED TOK_SHORT  */
#line 3649 "/build/libreoffice-still/src/libreoffice-25.8.5.2/unoidl/source/sourceprovider-parser.y"
  {
      (yyval.type) = new unoidl::detail::SourceProviderType(
          unoidl::detail::SourceProviderType::TYPE_UNSIGNED_SHORT);
  }
#line 5308 "/build/libreoffice-still/src/libreoffice-25.8.5.2/workdir/YaccTarget/unoidl/source/sourceprovider-parser.cxx"
    break;

  case 157: /* type: TOK_LONG  */
#line 3654 "/build/libreoffice-still/src/libreoffice-25.8.5.2/unoidl/source/sourceprovider-parser.y"
  {
      (yyval.type) = new unoidl::detail::SourceProviderType(
          unoidl::detail::SourceProviderType::TYPE_LONG);
  }
#line 5317 "/build/libreoffice-still/src/libreoffice-25.8.5.2/workdir/YaccTarget/unoidl/source/sourceprovider-parser.cxx"
    break;

  case 158: /* type: TOK_UNSIGNED TOK_LONG  */
#line 3659 "/build/libreoffice-still/src/libreoffice-25.8.5.2/unoidl/source/sourceprovider-parser.y"
  {
      (yyval.type) = new unoidl::detail::SourceProviderType(
          unoidl::detail::SourceProviderType::TYPE_UNSIGNED_LONG);
  }
#line 5326 "/build/libreoffice-still/src/libreoffice-25.8.5.2/workdir/YaccTarget/unoidl/source/sourceprovider-parser.cxx"
    break;

  case 159: /* type: TOK_HYPER  */
#line 3664 "/build/libreoffice-still/src/libreoffice-25.8.5.2/unoidl/source/sourceprovider-parser.y"
  {
      (yyval.type) = new unoidl::detail::SourceProviderType(
          unoidl::detail::SourceProviderType::TYPE_HYPER);
  }
#line 5335 "/build/libreoffice-still/src/libreoffice-25.8.5.2/workdir/YaccTarget/unoidl/source/sourceprovider-parser.cxx"
    break;

  case 160: /* type: TOK_UNSIGNED TOK_HYPER  */
#line 3669 "/build/libreoffice-still/src/libreoffice-25.8.5.2/unoidl/source/sourceprovider-parser.y"
  {
      (yyval.type) = new unoidl::detail::SourceProviderType(
          unoidl::detail::SourceProviderType::TYPE_UNSIGNED_HYPER);
  }
#line 5344 "/build/libreoffice-still/src/libreoffice-25.8.5.2/workdir/YaccTarget/unoidl/source/sourceprovider-parser.cxx"
    break;

  case 161: /* type: TOK_FLOAT  */
#line 3674 "/build/libreoffice-still/src/libreoffice-25.8.5.2/unoidl/source/sourceprovider-parser.y"
  {
      (yyval.type) = new unoidl::detail::SourceProviderType(
          unoidl::detail::SourceProviderType::TYPE_FLOAT);
  }
#line 5353 "/build/libreoffice-still/src/libreoffice-25.8.5.2/workdir/YaccTarget/unoidl/source/sourceprovider-parser.cxx"
    break;

  case 162: /* type: TOK_DOUBLE  */
#line 3679 "/build/libreoffice-still/src/libreoffice-25.8.5.2/unoidl/source/sourceprovider-parser.y"
  {
      (yyval.type) = new unoidl::detail::SourceProviderType(
          unoidl::detail::SourceProviderType::TYPE_DOUBLE);
  }
#line 5362 "/build/libreoffice-still/src/libreoffice-25.8.5.2/workdir/YaccTarget/unoidl/source/sourceprovider-parser.cxx"
    break;

  case 163: /* type: TOK_CHAR  */
#line 3684 "/build/libreoffice-still/src/libreoffice-25.8.5.2/unoidl/source/sourceprovider-parser.y"
  {
      (yyval.type) = new unoidl::detail::SourceProviderType(
          unoidl::detail::SourceProviderType::TYPE_CHAR);
  }
#line 5371 "/build/libreoffice-still/src/libreoffice-25.8.5.2/workdir/YaccTarget/unoidl/source/sourceprovider-parser.cxx"
    break;

  case 164: /* type: TOK_STRING  */
#line 3689 "/build/libreoffice-still/src/libreoffice-25.8.5.2/unoidl/source/sourceprovider-parser.y"
  {
      (yyval.type) = new unoidl::detail::SourceProviderType(
          unoidl::detail::SourceProviderType::TYPE_STRING);
  }
#line 5380 "/build/libreoffice-still/src/libreoffice-25.8.5.2/workdir/YaccTarget/unoidl/source/sourceprovider-parser.cxx"
    break;

  case 165: /* type: TOK_TYPE  */
#line 3694 "/build/libreoffice-still/src/libreoffice-25.8.5.2/unoidl/source/sourceprovider-parser.y"
  {
      (yyval.type) = new unoidl::detail::SourceProviderType(
          unoidl::detail::SourceProviderType::TYPE_TYPE);
  }
#line 5389 "/build/libreoffice-still/src/libreoffice-25.8.5.2/workdir/YaccTarget/unoidl/source/sourceprovider-parser.cxx"
    break;

  case 166: /* type: TOK_ANY  */
#line 3699 "/build/libreoffice-still/src/libreoffice-25.8.5.2/unoidl/source/sourceprovider-parser.y"
  {
      (yyval.type) = new unoidl::detail::SourceProviderType(
          unoidl::detail::SourceProviderType::TYPE_ANY);
  }
#line 5398 "/build/libreoffice-still/src/libreoffice-25.8.5.2/workdir/YaccTarget/unoidl/source/sourceprovider-parser.cxx"
    break;

  case 167: /* type: TOK_SEQUENCE '<' type '>'  */
#line 3704 "/build/libreoffice-still/src/libreoffice-25.8.5.2/unoidl/source/sourceprovider-parser.y"
  {
      switch ((yyvsp[-1].type)->type) {
      case unoidl::detail::SourceProviderType::TYPE_VOID:
      case unoidl::detail::SourceProviderType::TYPE_EXCEPTION:
      case unoidl::detail::SourceProviderType::TYPE_PARAMETER: //TODO?
          error((yylsp[-1]), yyscanner, u"illegal sequence type component type"_ustr);
          YYERROR;
          break;
      default:
          break;
      }
      (yyval.type) = new unoidl::detail::SourceProviderType((yyvsp[-1].type));
      delete (yyvsp[-1].type);
  }
#line 5417 "/build/libreoffice-still/src/libreoffice-25.8.5.2/workdir/YaccTarget/unoidl/source/sourceprovider-parser.cxx"
    break;

  case 168: /* type: name  */
#line 3719 "/build/libreoffice-still/src/libreoffice-25.8.5.2/unoidl/source/sourceprovider-parser.y"
  {
      unoidl::detail::SourceProviderScannerData * data = yyget_extra(yyscanner);
      OUString name(convertName((yyvsp[0].sval)));
      bool done = false;
      if (name.indexOf('.') == -1 && !data->currentName.isEmpty()) {
          unoidl::detail::SourceProviderEntity * ent = getCurrentEntity(data);
          unoidl::detail::SourceProviderPolymorphicStructTypeTemplateEntityPad *
              pad = dynamic_cast<
                  unoidl::detail::SourceProviderPolymorphicStructTypeTemplateEntityPad *>(
                      ent->pad.get());
          if (pad != nullptr
              && (std::find(
                      pad->typeParameters.begin(), pad->typeParameters.end(),
                      name)
                  != pad->typeParameters.end()))
          {
              (yyval.type) = new unoidl::detail::SourceProviderType(name);
              done = true;
          }
      }
      if (!done) {
          unoidl::detail::SourceProviderEntity const * ent;
          unoidl::detail::SourceProviderType t;
          switch (findEntity(
                      (yylsp[0]), yyscanner, data, false, &name, &ent, nullptr, &t))
          {
          case FOUND_ERROR:
              YYERROR;
              break;
          case FOUND_TYPE:
              (yyval.type) = new unoidl::detail::SourceProviderType(t);
              break;
          case FOUND_ENTITY:
              if (ent == nullptr) {
                  error((yylsp[0]), yyscanner, "unknown entity " + name);
                  YYERROR;
              }
              bool ok = false;
              switch (ent->kind) {
              case unoidl::detail::SourceProviderEntity::KIND_LOCAL:
                  if (ent->pad.is()) {
                      if (data->publishedContext && !ent->pad->isPublished()) {
                          error(
                              (yylsp[0]), yyscanner,
                              ("unpublished entity " + name
                               + " used in published context"));
                          YYERROR;
                      }
                      if (dynamic_cast<unoidl::detail::SourceProviderEnumTypeEntityPad *>(
                              ent->pad.get())
                          != nullptr)
                      {
                          (yyval.type) = new unoidl::detail::SourceProviderType(
                              unoidl::detail::SourceProviderType::TYPE_ENUM,
                              name, ent);
                          ok = true;
                      } else if (dynamic_cast<unoidl::detail::SourceProviderPlainStructTypeEntityPad *>(
                                     ent->pad.get())
                                 != nullptr)
                      {
                          (yyval.type) = new unoidl::detail::SourceProviderType(
                              unoidl::detail::SourceProviderType::TYPE_PLAIN_STRUCT,
                              name, ent);
                          ok = true;
                      } else if (dynamic_cast<unoidl::detail::SourceProviderPolymorphicStructTypeTemplateEntityPad *>(
                                     ent->pad.get())
                                 != nullptr)
                      {
                          error(
                              (yylsp[0]), yyscanner,
                              (("recursive reference to polymorphic struct type"
                                " template ")
                               + name));
                          YYERROR;
                      } else if (dynamic_cast<unoidl::detail::SourceProviderExceptionTypeEntityPad *>(
                                     ent->pad.get())
                                 != nullptr)
                      {
                          (yyval.type) = new unoidl::detail::SourceProviderType(
                              unoidl::detail::SourceProviderType::TYPE_EXCEPTION,
                              name, ent);
                          ok = true;
                      } else if (dynamic_cast<unoidl::detail::SourceProviderInterfaceTypeEntityPad *>(
                                     ent->pad.get())
                                 != nullptr)
                      {
                          (yyval.type) = new unoidl::detail::SourceProviderType(
                              unoidl::detail::SourceProviderType::TYPE_INTERFACE,
                              name, ent);
                          ok = true;
                      }
                      break;
                  }
                  assert(ent->entity.is());
                  [[fallthrough]];
              case unoidl::detail::SourceProviderEntity::KIND_EXTERNAL:
                  if (data->publishedContext
                      && ent->entity->getSort() != unoidl::Entity::SORT_MODULE
                      && !static_cast<unoidl::PublishableEntity *>(
                          ent->entity.get())->isPublished())
                  {
                      error(
                          (yylsp[0]), yyscanner,
                          ("unpublished entity " + name
                           + " used in published context"));
                      YYERROR;
                  }
                  switch (ent->entity->getSort()) {
                  case unoidl::Entity::SORT_ENUM_TYPE:
                      (yyval.type) = new unoidl::detail::SourceProviderType(
                          unoidl::detail::SourceProviderType::TYPE_ENUM, name,
                          ent);
                      ok = true;
                      break;
                  case unoidl::Entity::SORT_PLAIN_STRUCT_TYPE:
                      (yyval.type) = new unoidl::detail::SourceProviderType(
                          unoidl::detail::SourceProviderType::TYPE_PLAIN_STRUCT,
                          name, ent);
                      ok = true;
                      break;
                  case unoidl::Entity::SORT_POLYMORPHIC_STRUCT_TYPE_TEMPLATE:
                      error(
                          (yylsp[0]), yyscanner,
                          ("polymorphic struct type template " + name
                           + " without type arguments"));
                      YYERROR;
                      break;
                  case unoidl::Entity::SORT_EXCEPTION_TYPE:
                      (yyval.type) = new unoidl::detail::SourceProviderType(
                          unoidl::detail::SourceProviderType::TYPE_EXCEPTION,
                          name, ent);
                      ok = true;
                      break;
                  case unoidl::Entity::SORT_INTERFACE_TYPE:
                      (yyval.type) = new unoidl::detail::SourceProviderType(
                          unoidl::detail::SourceProviderType::TYPE_INTERFACE,
                          name, ent);
                      ok = true;
                      break;
                  case unoidl::Entity::SORT_TYPEDEF:
                      O3TL_UNREACHABLE;
                  default:
                      break;
                  }
                  break;
              case unoidl::detail::SourceProviderEntity::KIND_INTERFACE_DECL:
                  if (data->publishedContext) {
                      error(
                          (yylsp[0]), yyscanner,
                          ("unpublished entity " + name
                           + " used in published context"));
                      YYERROR;
                  }
                  [[fallthrough]];
              case unoidl::detail::SourceProviderEntity::KIND_PUBLISHED_INTERFACE_DECL:
                  (yyval.type) = new unoidl::detail::SourceProviderType(
                      unoidl::detail::SourceProviderType::TYPE_INTERFACE, name,
                      ent);
                  ok = true;
                  break;
              case unoidl::detail::SourceProviderEntity::KIND_MODULE:
                  assert(false && "this cannot happen");
              }
              if (!ok) {
                  error((yylsp[0]), yyscanner, "non-type entity " + name);
                  YYERROR;
              }
              break;
          }
      }
  }
#line 5593 "/build/libreoffice-still/src/libreoffice-25.8.5.2/workdir/YaccTarget/unoidl/source/sourceprovider-parser.cxx"
    break;

  case 169: /* type: name '<' typeArguments '>'  */
#line 3891 "/build/libreoffice-still/src/libreoffice-25.8.5.2/unoidl/source/sourceprovider-parser.y"
  {
      unoidl::detail::SourceProviderScannerData * data = yyget_extra(yyscanner);
      OUString name(convertName((yyvsp[-3].sval)));
      std::vector<unoidl::detail::SourceProviderType> args(*(yyvsp[-1].types));
      delete (yyvsp[-1].types);
      unoidl::detail::SourceProviderEntity const * ent;
      if (findEntity((yylsp[-3]), yyscanner, data, false, &name, &ent, nullptr, nullptr)
          == FOUND_ERROR)
      {
          YYERROR;
      }
      if (ent == nullptr) {
          error((yylsp[-3]), yyscanner, "unknown entity " + name);
          YYERROR;
      }
      bool ok = false;
      switch (ent->kind) {
      case unoidl::detail::SourceProviderEntity::KIND_LOCAL:
          if (ent->pad.is()) {
              if (dynamic_cast<unoidl::detail::SourceProviderPolymorphicStructTypeTemplateEntityPad *>(
                      ent->pad.get())
                  != nullptr)
              {
                  error(
                      (yylsp[-3]), yyscanner,
                      (("recursive reference to polymorphic struct type"
                        " template ")
                       + name));
                  YYERROR;
              }
              break;
          }
          assert(ent->entity.is());
          [[fallthrough]];
      case unoidl::detail::SourceProviderEntity::KIND_EXTERNAL:
          if (ent->entity->getSort()
              == unoidl::Entity::SORT_POLYMORPHIC_STRUCT_TYPE_TEMPLATE)
          {
              rtl::Reference<unoidl::PolymorphicStructTypeTemplateEntity> e(
                  static_cast<unoidl::PolymorphicStructTypeTemplateEntity *>(
                      ent->entity.get()));
              if (args.size() != e->getTypeParameters().size()) {
                  error(
                      (yylsp[-3]), yyscanner,
                      ("bad number of polymorphic struct type template " + name
                       + " type arguments"));
                  YYERROR;
              }
              if (data->publishedContext && !e->isPublished()) {
                  error(
                      (yylsp[-3]), yyscanner,
                      ("unpublished polymorphic struct type template " + name
                       + " used in published context"));
                  YYERROR;
              }
              (yyval.type) = new unoidl::detail::SourceProviderType(name, ent, std::move(args));
              ok = true;
          }
          break;
      case unoidl::detail::SourceProviderEntity::KIND_INTERFACE_DECL:
      case unoidl::detail::SourceProviderEntity::KIND_PUBLISHED_INTERFACE_DECL:
          break;
      case unoidl::detail::SourceProviderEntity::KIND_MODULE:
          assert(false && "this cannot happen");
      }
      if (!ok) {
          error((yylsp[-3]), yyscanner, "non-type entity " + name);
          YYERROR;
      }
  }
#line 5668 "/build/libreoffice-still/src/libreoffice-25.8.5.2/workdir/YaccTarget/unoidl/source/sourceprovider-parser.cxx"
    break;

  case 170: /* name: name TOK_COLONS identifier  */
#line 3964 "/build/libreoffice-still/src/libreoffice-25.8.5.2/unoidl/source/sourceprovider-parser.y"
                             { *(yyvsp[-2].sval) += "." + *(yyvsp[0].sval); delete (yyvsp[0].sval); (yyval.sval) = (yyvsp[-2].sval); }
#line 5674 "/build/libreoffice-still/src/libreoffice-25.8.5.2/workdir/YaccTarget/unoidl/source/sourceprovider-parser.cxx"
    break;

  case 171: /* name: TOK_COLONS identifier  */
#line 3965 "/build/libreoffice-still/src/libreoffice-25.8.5.2/unoidl/source/sourceprovider-parser.y"
                        { *(yyvsp[0].sval) = "." + *(yyvsp[0].sval); (yyval.sval) = (yyvsp[0].sval); }
#line 5680 "/build/libreoffice-still/src/libreoffice-25.8.5.2/workdir/YaccTarget/unoidl/source/sourceprovider-parser.cxx"
    break;

  case 174: /* identifier: TOK_GET  */
#line 3971 "/build/libreoffice-still/src/libreoffice-25.8.5.2/unoidl/source/sourceprovider-parser.y"
          { (yyval.sval) = new OString("get"_ostr); }
#line 5686 "/build/libreoffice-still/src/libreoffice-25.8.5.2/workdir/YaccTarget/unoidl/source/sourceprovider-parser.cxx"
    break;

  case 175: /* identifier: TOK_PUBLISHED  */
#line 3972 "/build/libreoffice-still/src/libreoffice-25.8.5.2/unoidl/source/sourceprovider-parser.y"
                { (yyval.sval) = new OString("published"_ostr); }
#line 5692 "/build/libreoffice-still/src/libreoffice-25.8.5.2/workdir/YaccTarget/unoidl/source/sourceprovider-parser.cxx"
    break;

  case 176: /* identifier: TOK_SET  */
#line 3973 "/build/libreoffice-still/src/libreoffice-25.8.5.2/unoidl/source/sourceprovider-parser.y"
          { (yyval.sval) = new OString("set"_ostr); }
#line 5698 "/build/libreoffice-still/src/libreoffice-25.8.5.2/workdir/YaccTarget/unoidl/source/sourceprovider-parser.cxx"
    break;

  case 177: /* deprecated_opt: TOK_DEPRECATED  */
#line 3977 "/build/libreoffice-still/src/libreoffice-25.8.5.2/unoidl/source/sourceprovider-parser.y"
                 { (yyval.bval) = true; }
#line 5704 "/build/libreoffice-still/src/libreoffice-25.8.5.2/workdir/YaccTarget/unoidl/source/sourceprovider-parser.cxx"
    break;

  case 178: /* deprecated_opt: %empty  */
#line 3978 "/build/libreoffice-still/src/libreoffice-25.8.5.2/unoidl/source/sourceprovider-parser.y"
              { (yyval.bval) = false; }
#line 5710 "/build/libreoffice-still/src/libreoffice-25.8.5.2/workdir/YaccTarget/unoidl/source/sourceprovider-parser.cxx"
    break;


#line 5714 "/build/libreoffice-still/src/libreoffice-25.8.5.2/workdir/YaccTarget/unoidl/source/sourceprovider-parser.cxx"

      default: break;
    }
  /* User semantic actions sometimes alter yychar, and that requires
     that yytoken be updated with the new translation.  We take the
     approach of translating immediately before every use of yytoken.
     One alternative is translating here after every semantic action,
     but that translation would be missed if the semantic action invokes
     YYABORT, YYACCEPT, or YYERROR immediately after altering yychar or
     if it invokes YYBACKUP.  In the case of YYABORT or YYACCEPT, an
     incorrect destructor might then be invoked immediately.  In the
     case of YYERROR or YYBACKUP, subsequent parser actions might lead
     to an incorrect destructor call or verbose syntax error message
     before the lookahead is translated.  */
  YY_SYMBOL_PRINT ("-> $$ =", YY_CAST (yysymbol_kind_t, yyr1[yyn]), &yyval, &yyloc);

  YYPOPSTACK (yylen);
  yylen = 0;

  *++yyvsp = yyval;
  *++yylsp = yyloc;

  /* Now 'shift' the result of the reduction.  Determine what state
     that goes to, based on the state we popped back to and the rule
     number reduced by.  */
  {
    const int yylhs = yyr1[yyn] - YYNTOKENS;
    const int yyi = yypgoto[yylhs] + *yyssp;
    yystate = (0 <= yyi && yyi <= YYLAST && yycheck[yyi] == *yyssp
               ? yytable[yyi]
               : yydefgoto[yylhs]);
  }

  goto yynewstate;


/*--------------------------------------.
| yyerrlab -- here on detecting error.  |
`--------------------------------------*/
yyerrlab:
  /* Make sure we have latest lookahead translation.  See comments at
     user semantic actions for why this is necessary.  */
  yytoken = yychar == YYEMPTY ? YYSYMBOL_YYEMPTY : YYTRANSLATE (yychar);
  /* If not already recovering from an error, report this error.  */
  if (!yyerrstatus)
    {
      ++yynerrs;
      yyerror (&yylloc, yyscanner, YY_("syntax error"));
    }

  yyerror_range[1] = yylloc;
  if (yyerrstatus == 3)
    {
      /* If just tried and failed to reuse lookahead token after an
         error, discard it.  */

      if (yychar <= YYEOF)
        {
          /* Return failure if at end of input.  */
          if (yychar == YYEOF)
            YYABORT;
        }
      else
        {
          yydestruct ("Error: discarding",
                      yytoken, &yylval, &yylloc, yyscanner);
          yychar = YYEMPTY;
        }
    }

  /* Else will try to reuse lookahead token after shifting the error
     token.  */
  goto yyerrlab1;


/*---------------------------------------------------.
| yyerrorlab -- error raised explicitly by YYERROR.  |
`---------------------------------------------------*/
yyerrorlab:
  /* Pacify compilers when the user code never invokes YYERROR and the
     label yyerrorlab therefore never appears in user code.  */
  if (0)
    YYERROR;
  ++yynerrs;

  /* Do not reclaim the symbols of the rule whose action triggered
     this YYERROR.  */
  YYPOPSTACK (yylen);
  yylen = 0;
  YY_STACK_PRINT (yyss, yyssp);
  yystate = *yyssp;
  goto yyerrlab1;


/*-------------------------------------------------------------.
| yyerrlab1 -- common code for both syntax error and YYERROR.  |
`-------------------------------------------------------------*/
yyerrlab1:
  yyerrstatus = 3;      /* Each real token shifted decrements this.  */

  /* Pop stack until we find a state that shifts the error token.  */
  for (;;)
    {
      yyn = yypact[yystate];
      if (!yypact_value_is_default (yyn))
        {
          yyn += YYSYMBOL_YYerror;
          if (0 <= yyn && yyn <= YYLAST && yycheck[yyn] == YYSYMBOL_YYerror)
            {
              yyn = yytable[yyn];
              if (0 < yyn)
                break;
            }
        }

      /* Pop the current state because it cannot handle the error token.  */
      if (yyssp == yyss)
        YYABORT;

      yyerror_range[1] = *yylsp;
      yydestruct ("Error: popping",
                  YY_ACCESSING_SYMBOL (yystate), yyvsp, yylsp, yyscanner);
      YYPOPSTACK (1);
      yystate = *yyssp;
      YY_STACK_PRINT (yyss, yyssp);
    }

  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  *++yyvsp = yylval;
  YY_IGNORE_MAYBE_UNINITIALIZED_END

  yyerror_range[2] = yylloc;
  ++yylsp;
  YYLLOC_DEFAULT (*yylsp, yyerror_range, 2);

  /* Shift the error token.  */
  YY_SYMBOL_PRINT ("Shifting", YY_ACCESSING_SYMBOL (yyn), yyvsp, yylsp);

  yystate = yyn;
  goto yynewstate;


/*-------------------------------------.
| yyacceptlab -- YYACCEPT comes here.  |
`-------------------------------------*/
yyacceptlab:
  yyresult = 0;
  goto yyreturnlab;


/*-----------------------------------.
| yyabortlab -- YYABORT comes here.  |
`-----------------------------------*/
yyabortlab:
  yyresult = 1;
  goto yyreturnlab;


/*-----------------------------------------------------------.
| yyexhaustedlab -- YYNOMEM (memory exhaustion) comes here.  |
`-----------------------------------------------------------*/
yyexhaustedlab:
  yyerror (&yylloc, yyscanner, YY_("memory exhausted"));
  yyresult = 2;
  goto yyreturnlab;


/*----------------------------------------------------------.
| yyreturnlab -- parsing is finished, clean up and return.  |
`----------------------------------------------------------*/
yyreturnlab:
  if (yychar != YYEMPTY)
    {
      /* Make sure we have latest lookahead translation.  See comments at
         user semantic actions for why this is necessary.  */
      yytoken = YYTRANSLATE (yychar);
      yydestruct ("Cleanup: discarding lookahead",
                  yytoken, &yylval, &yylloc, yyscanner);
    }
  /* Do not reclaim the symbols of the rule whose action triggered
     this YYABORT or YYACCEPT.  */
  YYPOPSTACK (yylen);
  YY_STACK_PRINT (yyss, yyssp);
  while (yyssp != yyss)
    {
      yydestruct ("Cleanup: popping",
                  YY_ACCESSING_SYMBOL (+*yyssp), yyvsp, yylsp, yyscanner);
      YYPOPSTACK (1);
    }
#ifndef yyoverflow
  if (yyss != yyssa)
    YYSTACK_FREE (yyss);
#endif

  return yyresult;
}

#line 3981 "/build/libreoffice-still/src/libreoffice-25.8.5.2/unoidl/source/sourceprovider-parser.y"


namespace unoidl::detail {

OUString SourceProviderType::getName() const {
    if (!typedefName.isEmpty()) {
        return typedefName;
    }
    switch (type) {
    case unoidl::detail::SourceProviderType::TYPE_VOID:
        return u"void"_ustr;
    case unoidl::detail::SourceProviderType::TYPE_BOOLEAN:
        return u"boolean"_ustr;
    case unoidl::detail::SourceProviderType::TYPE_BYTE:
        return u"byte"_ustr;
    case unoidl::detail::SourceProviderType::TYPE_SHORT:
        return u"short"_ustr;
    case unoidl::detail::SourceProviderType::TYPE_UNSIGNED_SHORT:
        return u"unsigned short"_ustr;
    case unoidl::detail::SourceProviderType::TYPE_LONG:
        return u"long"_ustr;
    case unoidl::detail::SourceProviderType::TYPE_UNSIGNED_LONG:
        return u"unsigned long"_ustr;
    case unoidl::detail::SourceProviderType::TYPE_HYPER:
        return u"hyper"_ustr;
    case unoidl::detail::SourceProviderType::TYPE_UNSIGNED_HYPER:
        return u"unsigned hyper"_ustr;
    case unoidl::detail::SourceProviderType::TYPE_FLOAT:
        return u"float"_ustr;
    case unoidl::detail::SourceProviderType::TYPE_DOUBLE:
        return u"double"_ustr;
    case unoidl::detail::SourceProviderType::TYPE_CHAR:
        return u"char"_ustr;
    case unoidl::detail::SourceProviderType::TYPE_STRING:
        return u"string"_ustr;
    case unoidl::detail::SourceProviderType::TYPE_TYPE:
        return u"type"_ustr;
    case unoidl::detail::SourceProviderType::TYPE_ANY:
        return u"any"_ustr;
    case unoidl::detail::SourceProviderType::TYPE_SEQUENCE:
        assert(subtypes.size() == 1);
        return "[]" + subtypes.front().getName();
    case unoidl::detail::SourceProviderType::TYPE_ENUM:
    case unoidl::detail::SourceProviderType::TYPE_PLAIN_STRUCT:
    case unoidl::detail::SourceProviderType::TYPE_EXCEPTION:
    case unoidl::detail::SourceProviderType::TYPE_INTERFACE:
    case unoidl::detail::SourceProviderType::TYPE_PARAMETER:
        return name;
    case unoidl::detail::SourceProviderType::TYPE_INSTANTIATED_POLYMORPHIC_STRUCT:
        {
            OUStringBuffer n(512);
            n.append(name + "<");
            for (auto i(subtypes.begin()); i != subtypes.end(); ++i) {
                if (i != subtypes.begin()) {
                    n.append(",");
                }
                n.append(i->getName());
            }
            return n.append(">").makeStringAndClear();
        }
    default:
        assert(false && "this cannot happen"); for (;;) { std::abort(); }
    }
}

bool SourceProviderType::equals(SourceProviderType const & other) const {
    if (type != other.type || name != other.name
        || subtypes.size() != other.subtypes.size())
    {
        return false;
    }
    for (auto i(subtypes.begin()), j(other.subtypes.begin());
         i != subtypes.end(); ++i, ++j)
    {
        if (!i->equals(*j)) {
            return false;
        }
    }
    return true;
}

bool SourceProviderInterfaceTypeEntityPad::addDirectBase(
    YYLTYPE location, yyscan_t yyscanner, SourceProviderScannerData * data,
    DirectBase const & base, bool optional)
{
    std::set<OUString> seen;
    if (!(checkBaseClashes(
              location, yyscanner, data, base.name, base.entity, true, optional,
              optional, &seen)
          && addBase(
              location, yyscanner, data, base.name, base.name, base.entity,
              true, optional)))
    {
        return false;
    }
    if (optional) {
        addOptionalBaseMembers(
            location, yyscanner, data, base.name, base.entity);
    }
    (optional ? directOptionalBases : directMandatoryBases).push_back(base);
    return true;
}

bool SourceProviderInterfaceTypeEntityPad::addDirectMember(
    YYLTYPE location, yyscan_t yyscanner, SourceProviderScannerData * data,
    OUString const & name)
{
    assert(data != nullptr);
    if (!checkMemberClashes(location, yyscanner, data, u"", name, true)) {
        return false;
    }
    allMembers.emplace(name, Member(data->currentName));
    return true;
}

bool SourceProviderInterfaceTypeEntityPad::checkBaseClashes(
    YYLTYPE location, yyscan_t yyscanner, SourceProviderScannerData * data,
    OUString const & name,
    rtl::Reference<unoidl::InterfaceTypeEntity> const & entity, bool direct,
    bool optional, bool outerOptional, std::set<OUString> * seen) const
{
    assert(data != nullptr);
    assert(entity.is());
    assert(seen != nullptr);
    if (direct || optional || seen->insert(name).second) {
        std::map<OUString, BaseKind>::const_iterator i(allBases.find(name));
        if (i != allBases.end()) {
            switch (i->second) {
            case BASE_INDIRECT_OPTIONAL:
                if (direct && optional) {
                    error(
                        location, yyscanner,
                        ("interface type " + data->currentName
                         + " duplicate base " + name));
                    return false;
                }
                break;
            case BASE_DIRECT_OPTIONAL:
                if (direct || !outerOptional) {
                    error(
                        location, yyscanner,
                        ("interface type " + data->currentName
                         + " duplicate base " + name));
                    return false;
                }
                return true;
            case BASE_INDIRECT_MANDATORY:
                if (direct) {
                    error(
                        location, yyscanner,
                        ("interface type " + data->currentName
                         + " duplicate base " + name));
                    return false;
                }
                return true;
            case BASE_DIRECT_MANDATORY:
                if (direct || (!optional && !outerOptional)) {
                    error(
                        location, yyscanner,
                        ("interface type " + data->currentName
                         + " duplicate base " + name));
                    return false;
                }
                return true;
            }
        }
        if (direct || !optional) {
            for (auto & j: entity->getDirectMandatoryBases()) {
                OUString n("." + j.name);
                unoidl::detail::SourceProviderEntity const * p;
                if (findEntity(
                        location, yyscanner, data, true, &n, &p, nullptr,
                        nullptr)
                    == FOUND_ERROR)
                {
                    return false;
                }
                if (p == nullptr || !p->entity.is()
                    || (p->entity->getSort()
                        != unoidl::Entity::SORT_INTERFACE_TYPE))
                {
                    error(
                        location, yyscanner,
                        ("inconsistent type manager: interface type "
                         + data->currentName + " base " + n
                         + " does not resolve to an existing interface type"));
                    return false;
                }
                if (!checkBaseClashes(
                        location, yyscanner, data, n,
                        static_cast<unoidl::InterfaceTypeEntity *>(
                            p->entity.get()),
                        false, false, outerOptional, seen))
                {
                    return false;
                }
            }
            for (auto & j: entity->getDirectOptionalBases()) {
                OUString n("." + j.name);
                unoidl::detail::SourceProviderEntity const * p;
                if (findEntity(
                        location, yyscanner, data, true, &n, &p, nullptr,
                        nullptr)
                    == FOUND_ERROR)
                {
                    return false;
                }
                if (p == nullptr || !p->entity.is()
                    || (p->entity->getSort()
                        != unoidl::Entity::SORT_INTERFACE_TYPE))
                {
                    error(
                        location, yyscanner,
                        ("inconsistent type manager: interface type "
                         + data->currentName + " base " + n
                         + " does not resolve to an existing interface type"));
                    return false;
                }
                if (!checkBaseClashes(
                        location, yyscanner, data, n,
                        static_cast<unoidl::InterfaceTypeEntity *>(
                            p->entity.get()),
                        false, true, outerOptional, seen))
                {
                    return false;
                }
            }
            for (auto & j: entity->getDirectAttributes()) {
                if (!checkMemberClashes(
                        location, yyscanner, data, name, j.name,
                        !outerOptional))
                {
                    return false;
                }
            }
            for (auto & j: entity->getDirectMethods()) {
                if (!checkMemberClashes(
                        location, yyscanner, data, name, j.name,
                        !outerOptional))
                {
                    return false;
                }
            }
        }
    }
    return true;
}

bool SourceProviderInterfaceTypeEntityPad::checkMemberClashes(
    YYLTYPE location, yyscan_t yyscanner, SourceProviderScannerData * data,
    std::u16string_view interfaceName, OUString const & memberName,
    bool checkOptional) const
{
    std::map<OUString, Member>::const_iterator i(allMembers.find(memberName));
    if (i != allMembers.end()) {
        if (!i->second.mandatory.isEmpty()) {
            // For a direct member, interfaceName will be empty, so this will
            // catch two direct members with the same name:
            if (i->second.mandatory != interfaceName) {
                error(
                    location, yyscanner,
                    ("interface type " + data->currentName
                     + " duplicate member " + memberName));
                return false;
            }
        } else if (checkOptional) {
            for (auto & j: i->second.optional) {
                if (j != interfaceName) {
                    error(
                        location, yyscanner,
                        ("interface type " + data->currentName
                         + " duplicate member " + memberName));
                    return false;
                }
            }
        }
    }
    return true;
}

bool SourceProviderInterfaceTypeEntityPad::addBase(
    YYLTYPE location, yyscan_t yyscanner, SourceProviderScannerData * data,
    OUString const & directBaseName, OUString const & name,
    rtl::Reference<unoidl::InterfaceTypeEntity> const & entity, bool direct,
    bool optional)
{
    assert(data != nullptr);
    assert(entity.is());
    BaseKind kind = optional
        ? direct ? BASE_DIRECT_OPTIONAL : BASE_INDIRECT_OPTIONAL
        : direct ? BASE_DIRECT_MANDATORY : BASE_INDIRECT_MANDATORY;
    std::pair<std::map<OUString, BaseKind>::iterator, bool> p(
        allBases.emplace(name, kind));
    bool seen = !p.second && p.first->second >= BASE_INDIRECT_MANDATORY;
    if (!p.second && kind > p.first->second) {
        p.first->second = kind;
    }
    if (!optional && !seen) {
        for (auto & i: entity->getDirectMandatoryBases()) {
            OUString n("." + i.name);
            unoidl::detail::SourceProviderEntity const * q;
            if (findEntity(
                    location, yyscanner, data, true, &n, &q, nullptr, nullptr)
                == FOUND_ERROR)
            {
                return false;
            }
            if (q == nullptr || !q->entity.is()
                || q->entity->getSort() != unoidl::Entity::SORT_INTERFACE_TYPE)
            {
                error(
                    location, yyscanner,
                    ("inconsistent type manager: interface type "
                     + data->currentName + " base " + n
                     + " does not resolve to an existing interface type"));
                return false;
            }
            if (!addBase(
                    location, yyscanner, data, directBaseName, n,
                    static_cast<unoidl::InterfaceTypeEntity *>(q->entity.get()),
                    false, false))
            {
                return false;
            }
        }
        for (auto & i: entity->getDirectOptionalBases())
        {
            OUString n("." + i.name);
            unoidl::detail::SourceProviderEntity const * q;
            if (findEntity(
                    location, yyscanner, data, true, &n, &q, nullptr, nullptr)
                == FOUND_ERROR)
            {
                return false;
            }
            if (q == nullptr || !q->entity.is()
                || q->entity->getSort() != unoidl::Entity::SORT_INTERFACE_TYPE)
            {
                error(
                    location, yyscanner,
                    ("inconsistent type manager: interface type "
                     + data->currentName + " base " + n
                     + " does not resolve to an existing interface type"));
                return false;
            }
            if (!addBase(
                    location, yyscanner, data, directBaseName, n,
                    static_cast<unoidl::InterfaceTypeEntity *>(q->entity.get()),
                    false, true))
            {
                return false;
            }
        }
        for (auto & i: entity->getDirectAttributes()) {
            allMembers.emplace(i.name, Member(name));
        }
        for (auto & i: entity->getDirectMethods()) {
            allMembers.emplace(i.name, Member(name));
        }
    }
    return true;
}

bool SourceProviderInterfaceTypeEntityPad::addOptionalBaseMembers(
    YYLTYPE location, yyscan_t yyscanner, SourceProviderScannerData * data,
    OUString const & name,
    rtl::Reference<unoidl::InterfaceTypeEntity> const & entity)
{
    assert(entity.is());
    for (auto & i: entity->getDirectMandatoryBases()) {
        OUString n("." + i.name);
        unoidl::detail::SourceProviderEntity const * p;
        if (findEntity(
                location, yyscanner, data, true, &n, &p, nullptr, nullptr)
            == FOUND_ERROR)
        {
            return false;
        }
        if (p == nullptr || !p->entity.is()
            || p->entity->getSort() != unoidl::Entity::SORT_INTERFACE_TYPE)
        {
            error(
                location, yyscanner,
                ("inconsistent type manager: interface type "
                 + data->currentName + " base " + n
                 + " does not resolve to an existing interface type"));
            return false;
        }
        if (!addOptionalBaseMembers(
                location, yyscanner, data, n,
                static_cast<unoidl::InterfaceTypeEntity *>(p->entity.get())))
        {
            return false;
        }
    }
    for (auto & i: entity->getDirectAttributes()) {
        Member & m(
            allMembers.emplace(i.name, Member(u""_ustr))
            .first->second);
        if (m.mandatory.isEmpty()) {
            m.optional.insert(name);
        }
    }
    for (auto & i: entity->getDirectMethods()) {
        Member & m(
            allMembers.emplace(i.name, Member(u""_ustr))
            .first->second);
        if (m.mandatory.isEmpty()) {
            m.optional.insert(name);
        }
    }
    return true;
}

bool parse(OUString const & uri, SourceProviderScannerData * data) {
    assert(data != nullptr);
    oslFileHandle handle;
    oslFileError e = osl_openFile(uri.pData, &handle, osl_File_OpenFlag_Read);
    switch (e) {
    case osl_File_E_None:
        break;
    case osl_File_E_NOENT:
        return false;
    default:
        throw FileFormatException(uri, "cannot open: " + OUString::number(e));
    }
    sal_uInt64 size;
    e = osl_getFileSize(handle, &size);
    if (e != osl_File_E_None) {
        oslFileError e2 = osl_closeFile(handle);
        SAL_WARN_IF(
            e2 != osl_File_E_None, "unoidl",
            "cannot close " << uri << ": " << +e2);
        throw FileFormatException(
            uri, "cannot get size: " + OUString::number(e));
    }
    void * address;
    e = osl_mapFile(handle, &address, size, 0, osl_File_MapFlag_RandomAccess);
    if (e != osl_File_E_None) {
        oslFileError e2 = osl_closeFile(handle);
        SAL_WARN_IF(
            e2 != osl_File_E_None, "unoidl",
            "cannot close " << uri << ": " << +e2);
        throw FileFormatException(uri, "cannot mmap: " + OUString::number(e));
    }
    try {
        data->setSource(address, size);
        yyscan_t yyscanner;
        if (yylex_init_extra(data, &yyscanner) != 0) {
            // Checking errno for the specific EINVAL, ENOMEM documented for
            // yylex_init_extra would not work as those values are not defined
            // by the C++ Standard:
            int e2 = errno;
            throw FileFormatException(
                uri,
                "yylex_init_extra failed with errno " + OUString::number(e2));
        }
        int e2 = yyparse(yyscanner);
        yylex_destroy(yyscanner);
        switch (e2) {
        case 0:
            break;
        default:
            O3TL_UNREACHABLE;
        case 1:
            throw FileFormatException(
                uri,
                ("cannot parse"
                 + (data->errorLine == 0
                    ? OUString() : " line " + OUString::number(data->errorLine))
                 + (data->parserError.isEmpty()
                    ? OUString()
                    : (", "
                       + OStringToOUString(
                           data->parserError, osl_getThreadTextEncoding())))
                 + (data->errorMessage.isEmpty()
                    ? OUString() : ": \"" + data->errorMessage + "\"")));
        case 2:
            throw std::bad_alloc();
        }
    } catch (...) {
        e = osl_unmapMappedFile(handle, address, size);
        SAL_WARN_IF(e != osl_File_E_None, "unoidl", "cannot unmap: " << +e);
        e = osl_closeFile(handle);
        SAL_WARN_IF(e != osl_File_E_None, "unoidl", "cannot close: " << +e);
        throw;
    }
    e = osl_unmapMappedFile(handle, address, size);
    SAL_WARN_IF(e != osl_File_E_None, "unoidl", "cannot unmap: " << +e);
    e = osl_closeFile(handle);
    SAL_WARN_IF(e != osl_File_E_None, "unoidl", "cannot close: " << +e);
    return true;
}

}

/* vim:set shiftwidth=4 softtabstop=4 expandtab: */
