/* Utils.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from Utils.vala, do not modify */

/*
 * Copyright (c) 2011-2016 elementary LLC. (https://github.com/elementary/camera)
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301 USA.
 *
 * Authored by: Marcus Wichelmann <marcus.wichelmann@hotmail.de>
 */

#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <glib/gstdio.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

typedef enum  {
	CAMERA_UTILS_ACTION_TYPE_PHOTO,
	CAMERA_UTILS_ACTION_TYPE_VIDEO
} CameraUtilsActionType;

#define CAMERA_UTILS_TYPE_ACTION_TYPE (camera_utils_action_type_get_type ())
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

VALA_EXTERN GType camera_utils_action_type_get_type (void) G_GNUC_CONST ;
VALA_EXTERN gchar* camera_utils_get_new_media_filename (CameraUtilsActionType action_type);
VALA_EXTERN gchar* camera_utils_build_media_filename (const gchar* filename,
                                          CameraUtilsActionType action_type);
VALA_EXTERN gchar* camera_utils_get_media_directory (CameraUtilsActionType action_type);

static GType
camera_utils_action_type_get_type_once (void)
{
	static const GEnumValue values[] = {{CAMERA_UTILS_ACTION_TYPE_PHOTO, "CAMERA_UTILS_ACTION_TYPE_PHOTO", "photo"}, {CAMERA_UTILS_ACTION_TYPE_VIDEO, "CAMERA_UTILS_ACTION_TYPE_VIDEO", "video"}, {0, NULL, NULL}};
	GType camera_utils_action_type_type_id;
	camera_utils_action_type_type_id = g_enum_register_static ("CameraUtilsActionType", values);
	return camera_utils_action_type_type_id;
}

GType
camera_utils_action_type_get_type (void)
{
	static volatile gsize camera_utils_action_type_type_id__once = 0;
	if (g_once_init_enter (&camera_utils_action_type_type_id__once)) {
		GType camera_utils_action_type_type_id;
		camera_utils_action_type_type_id = camera_utils_action_type_get_type_once ();
		g_once_init_leave (&camera_utils_action_type_type_id__once, camera_utils_action_type_type_id);
	}
	return camera_utils_action_type_type_id__once;
}

gchar*
camera_utils_get_new_media_filename (CameraUtilsActionType action_type)
{
	gchar* time = NULL;
	GDateTime* _tmp0_;
	GDateTime* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gint file_id = 0;
	gchar* next_filename = NULL;
	gchar* _tmp4_;
	const gchar* _tmp18_;
	gchar* _tmp19_;
	gchar* result;
	_tmp0_ = g_date_time_new_now_local ();
	_tmp1_ = _tmp0_;
	_tmp2_ = g_date_time_format (_tmp1_, "%F%H:%M:%S");
	_tmp3_ = _tmp2_;
	_g_date_time_unref0 (_tmp1_);
	time = _tmp3_;
	file_id = 0;
	_tmp4_ = g_strdup ("");
	next_filename = _tmp4_;
	{
		gboolean _tmp5_ = FALSE;
		_tmp5_ = TRUE;
		while (TRUE) {
			gchar* _tmp10_ = NULL;
			const gchar* _tmp15_;
			gchar* _tmp16_;
			gint _tmp17_;
			if (!_tmp5_) {
				const gchar* _tmp6_;
				gchar* _tmp7_;
				gchar* _tmp8_;
				gboolean _tmp9_;
				_tmp6_ = next_filename;
				_tmp7_ = camera_utils_build_media_filename (_tmp6_, action_type);
				_tmp8_ = _tmp7_;
				_tmp9_ = !g_file_test (_tmp8_, G_FILE_TEST_EXISTS);
				_g_free0 (_tmp8_);
				if (_tmp9_) {
					break;
				}
			}
			_tmp5_ = FALSE;
			if (file_id > 0) {
				gchar* _tmp11_;
				gchar* _tmp12_;
				gchar* _tmp13_;
				_tmp11_ = g_strdup_printf ("%i", file_id);
				_tmp12_ = _tmp11_;
				_tmp13_ = g_strconcat ("-", _tmp12_, NULL);
				_g_free0 (_tmp10_);
				_tmp10_ = _tmp13_;
				_g_free0 (_tmp12_);
			} else {
				gchar* _tmp14_;
				_tmp14_ = g_strdup ("");
				_g_free0 (_tmp10_);
				_tmp10_ = _tmp14_;
			}
			_tmp15_ = time;
			_tmp16_ = g_strconcat (_tmp15_, _tmp10_, NULL);
			_g_free0 (next_filename);
			next_filename = _tmp16_;
			_tmp17_ = file_id;
			file_id = _tmp17_ + 1;
			_g_free0 (_tmp10_);
		}
	}
	_tmp18_ = next_filename;
	_tmp19_ = camera_utils_build_media_filename (_tmp18_, action_type);
	result = _tmp19_;
	_g_free0 (next_filename);
	_g_free0 (time);
	return result;
}

gchar*
camera_utils_build_media_filename (const gchar* filename,
                                   CameraUtilsActionType action_type)
{
	const gchar* _tmp0_ = NULL;
	gchar* full_filename = NULL;
	gchar* _tmp1_;
	gchar* media_directory = NULL;
	gchar* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* result;
	g_return_val_if_fail (filename != NULL, NULL);
	if (action_type == CAMERA_UTILS_ACTION_TYPE_PHOTO) {
		_tmp0_ = "jpg";
	} else {
		_tmp0_ = "ogv";
	}
	_tmp1_ = g_strdup_printf ("%s.%s", filename, _tmp0_);
	full_filename = _tmp1_;
	_tmp2_ = camera_utils_get_media_directory (action_type);
	media_directory = _tmp2_;
	_tmp3_ = media_directory;
	if (!g_file_test (_tmp3_, G_FILE_TEST_EXISTS)) {
		const gchar* _tmp4_;
		_tmp4_ = media_directory;
		g_mkdir (_tmp4_, 0777);
	}
	_tmp5_ = media_directory;
	_tmp6_ = full_filename;
	_tmp7_ = g_build_filename (G_DIR_SEPARATOR_S, _tmp5_, _tmp6_, NULL);
	result = _tmp7_;
	_g_free0 (media_directory);
	_g_free0 (full_filename);
	return result;
}

gchar*
camera_utils_get_media_directory (CameraUtilsActionType action_type)
{
	GUserDirectory _tmp0_ = 0;
	GUserDirectory user_dir = 0;
	gchar* media_directory = NULL;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* result;
	if (action_type == CAMERA_UTILS_ACTION_TYPE_PHOTO) {
		_tmp0_ = G_USER_DIRECTORY_PICTURES;
	} else {
		_tmp0_ = G_USER_DIRECTORY_VIDEOS;
	}
	user_dir = _tmp0_;
	_tmp1_ = g_get_user_special_dir (user_dir);
	_tmp2_ = g_strdup (_tmp1_);
	media_directory = _tmp2_;
	_tmp3_ = g_build_path (G_DIR_SEPARATOR_S, media_directory, "Webcam", NULL);
	result = _tmp3_;
	_g_free0 (media_directory);
	return result;
}

