/* Application.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from Application.vala, do not modify */

/*
 * SPDX-License-Identifier: LGPL-3.0-or-later
 * SPDX-FileCopyrightText: 2021 elementary, Inc. (https://elementary.io)
 */

#include <gtk/gtk.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <granite-7.h>
#include <glib/gi18n-lib.h>
#include <glib/gstdio.h>
#include <gst/gst.h>
#include <locale.h>

#define MUSIC_APPLICATION_ACTION_PREFIX "app."
#define MUSIC_APPLICATION_ACTION_NEXT "action-next"
#define MUSIC_APPLICATION_ACTION_PLAY_PAUSE "action-play-pause"
#define MUSIC_APPLICATION_ACTION_PREVIOUS "action-previous"
#define MUSIC_APPLICATION_ACTION_SHUFFLE "action-shuffle"
#define MUSIC_APPLICATION_ACTION_FIND "action-find"
#define MUSIC_APPLICATION_ACTION_CLEAR_QUEUE "action-clear-queue"
#define MUSIC_APPLICATION_ACTION_QUIT "action-quit"
#define CONSTANTS_GETTEXT_PACKAGE "io.elementary.music"
#define CONSTANTS_LOCALEDIR "/usr/share/locale"
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define MUSIC_TYPE_APPLICATION (music_application_get_type ())
#define MUSIC_APPLICATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), MUSIC_TYPE_APPLICATION, MusicApplication))
#define MUSIC_APPLICATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), MUSIC_TYPE_APPLICATION, MusicApplicationClass))
#define MUSIC_IS_APPLICATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MUSIC_TYPE_APPLICATION))
#define MUSIC_IS_APPLICATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MUSIC_TYPE_APPLICATION))
#define MUSIC_APPLICATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), MUSIC_TYPE_APPLICATION, MusicApplicationClass))

typedef struct _MusicApplication MusicApplication;
typedef struct _MusicApplicationClass MusicApplicationClass;
typedef struct _MusicApplicationPrivate MusicApplicationPrivate;

#define MUSIC_TYPE_PLAYBACK_MANAGER (music_playback_manager_get_type ())
#define MUSIC_PLAYBACK_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), MUSIC_TYPE_PLAYBACK_MANAGER, MusicPlaybackManager))
#define MUSIC_PLAYBACK_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), MUSIC_TYPE_PLAYBACK_MANAGER, MusicPlaybackManagerClass))
#define MUSIC_IS_PLAYBACK_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MUSIC_TYPE_PLAYBACK_MANAGER))
#define MUSIC_IS_PLAYBACK_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MUSIC_TYPE_PLAYBACK_MANAGER))
#define MUSIC_PLAYBACK_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), MUSIC_TYPE_PLAYBACK_MANAGER, MusicPlaybackManagerClass))

typedef struct _MusicPlaybackManager MusicPlaybackManager;
typedef struct _MusicPlaybackManagerClass MusicPlaybackManagerClass;
enum  {
	MUSIC_APPLICATION_0_PROPERTY,
	MUSIC_APPLICATION_NUM_PROPERTIES
};
static GParamSpec* music_application_properties[MUSIC_APPLICATION_NUM_PROPERTIES];
typedef void (*GSimpleActionActivateCallback) (GSimpleAction* action, GVariant* parameter, gpointer user_data);
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _Block1Data Block1Data;

#define MUSIC_TYPE_MAIN_WINDOW (music_main_window_get_type ())
#define MUSIC_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), MUSIC_TYPE_MAIN_WINDOW, MusicMainWindow))
#define MUSIC_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), MUSIC_TYPE_MAIN_WINDOW, MusicMainWindowClass))
#define MUSIC_IS_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MUSIC_TYPE_MAIN_WINDOW))
#define MUSIC_IS_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MUSIC_TYPE_MAIN_WINDOW))
#define MUSIC_MAIN_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), MUSIC_TYPE_MAIN_WINDOW, MusicMainWindowClass))

typedef struct _MusicMainWindow MusicMainWindow;
typedef struct _MusicMainWindowClass MusicMainWindowClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_dir_close0(var) ((var == NULL) ? NULL : (var = (g_dir_close (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define MUSIC_TYPE_MPRIS_ROOT (music_mpris_root_get_type ())
#define MUSIC_MPRIS_ROOT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), MUSIC_TYPE_MPRIS_ROOT, MusicMprisRoot))
#define MUSIC_MPRIS_ROOT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), MUSIC_TYPE_MPRIS_ROOT, MusicMprisRootClass))
#define MUSIC_IS_MPRIS_ROOT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MUSIC_TYPE_MPRIS_ROOT))
#define MUSIC_IS_MPRIS_ROOT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MUSIC_TYPE_MPRIS_ROOT))
#define MUSIC_MPRIS_ROOT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), MUSIC_TYPE_MPRIS_ROOT, MusicMprisRootClass))

typedef struct _MusicMprisRoot MusicMprisRoot;
typedef struct _MusicMprisRootClass MusicMprisRootClass;

#define MUSIC_TYPE_MPRIS_PLAYER (music_mpris_player_get_type ())
#define MUSIC_MPRIS_PLAYER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), MUSIC_TYPE_MPRIS_PLAYER, MusicMprisPlayer))
#define MUSIC_MPRIS_PLAYER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), MUSIC_TYPE_MPRIS_PLAYER, MusicMprisPlayerClass))
#define MUSIC_IS_MPRIS_PLAYER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MUSIC_TYPE_MPRIS_PLAYER))
#define MUSIC_IS_MPRIS_PLAYER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MUSIC_TYPE_MPRIS_PLAYER))
#define MUSIC_MPRIS_PLAYER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), MUSIC_TYPE_MPRIS_PLAYER, MusicMprisPlayerClass))

typedef struct _MusicMprisPlayer MusicMprisPlayer;
typedef struct _MusicMprisPlayerClass MusicMprisPlayerClass;

struct _MusicApplication {
	GtkApplication parent_instance;
	MusicApplicationPrivate * priv;
};

struct _MusicApplicationClass {
	GtkApplicationClass parent_class;
};

struct _MusicApplicationPrivate {
	MusicPlaybackManager* playback_manager;
};

struct _Block1Data {
	int _ref_count_;
	MusicApplication* self;
	GraniteSettings* granite_settings;
	GtkSettings* gtk_settings;
};

static gint MusicApplication_private_offset;
static gpointer music_application_parent_class = NULL;

VALA_EXTERN GType music_application_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MusicApplication, g_object_unref)
VALA_EXTERN GType music_playback_manager_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MusicPlaybackManager, g_object_unref)
static void music_application_action_find (MusicApplication* self);
static void _music_application_action_find_gsimple_action_activate_callback (GSimpleAction* action,
                                                                      GVariant* parameter,
                                                                      gpointer self);
static void _g_application_quit_gsimple_action_activate_callback (GSimpleAction* action,
                                                           GVariant* parameter,
                                                           gpointer self);
VALA_EXTERN MusicApplication* music_application_new (void);
VALA_EXTERN MusicApplication* music_application_construct (GType object_type);
static void music_application_real_startup (GApplication* base);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
VALA_EXTERN MusicPlaybackManager* music_playback_manager_get_default (void);
static void __lambda31_ (Block1Data* _data1_);
static void ___lambda31__g_object_notify (GObject* _sender,
                                   GParamSpec* pspec,
                                   gpointer self);
static void music_application_real_activate (GApplication* base);
static void music_application_on_bus_acquired (MusicApplication* self,
                                        GDBusConnection* connection,
                                        const gchar* name);
static void _music_application_on_bus_acquired_gbus_acquired_callback (GDBusConnection* connection,
                                                                const gchar* name,
                                                                gpointer self);
VALA_EXTERN GType music_main_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MusicMainWindow, g_object_unref)
VALA_EXTERN MusicMainWindow* music_main_window_new (void);
VALA_EXTERN MusicMainWindow* music_main_window_construct (GType object_type);
VALA_EXTERN void music_playback_manager_restore_queue (MusicPlaybackManager* self);
static GFile** music_application_list_directory (const gchar* directory,
                                          gint* result_length1);
static void _vala_array_add1 (GFile** * array,
                       gint* length,
                       gint* size,
                       GFile* value);
VALA_EXTERN GFile** music_application_loop_through_files (GFile** files,
                                              gint files_length1,
                                              gint* result_length1);
static void _vala_array_add2 (GFile** * array,
                       gint* length,
                       gint* size,
                       GFile* value);
static void _vala_array_add3 (GFile** * array,
                       gint* length,
                       gint* size,
                       GFile* value);
static void music_application_real_open (GApplication* base,
                                  GFile** files,
                                  gint files_length1,
                                  const gchar* hint);
VALA_EXTERN void music_playback_manager_queue_files (MusicPlaybackManager* self,
                                         GFile** files,
                                         gint files_length1);
VALA_EXTERN void music_main_window_start_search (MusicMainWindow* self);
VALA_EXTERN MusicMprisRoot* music_mpris_root_new (void);
VALA_EXTERN MusicMprisRoot* music_mpris_root_construct (GType object_type);
VALA_EXTERN GType music_mpris_root_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MusicMprisRoot, g_object_unref)
VALA_EXTERN guint music_mpris_root_register_object (void* object,
                                        GDBusConnection* connection,
                                        const gchar* path,
                                        GError** error);
VALA_EXTERN MusicMprisPlayer* music_mpris_player_new (GDBusConnection* connection);
VALA_EXTERN MusicMprisPlayer* music_mpris_player_construct (GType object_type,
                                                GDBusConnection* connection);
VALA_EXTERN GType music_mpris_player_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MusicMprisPlayer, g_object_unref)
VALA_EXTERN guint music_mpris_player_register_object (void* object,
                                          GDBusConnection* connection,
                                          const gchar* path,
                                          GError** error);
static gint music_application_main (gchar** args,
                             gint args_length1);
static GObject * music_application_constructor (GType type,
                                         guint n_construct_properties,
                                         GObjectConstructParam * construct_properties);
static void music_application_finalize (GObject * obj);
static GType music_application_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static const GActionEntry MUSIC_APPLICATION_ACTION_ENTRIES[2] = {{MUSIC_APPLICATION_ACTION_FIND, _music_application_action_find_gsimple_action_activate_callback}, {MUSIC_APPLICATION_ACTION_QUIT, _g_application_quit_gsimple_action_activate_callback}};

static inline gpointer
music_application_get_instance_private (MusicApplication* self)
{
	return G_STRUCT_MEMBER_P (self, MusicApplication_private_offset);
}

static void
_music_application_action_find_gsimple_action_activate_callback (GSimpleAction* action,
                                                                 GVariant* parameter,
                                                                 gpointer self)
{
	music_application_action_find ((MusicApplication*) self);
}

static void
_g_application_quit_gsimple_action_activate_callback (GSimpleAction* action,
                                                      GVariant* parameter,
                                                      gpointer self)
{
	g_application_quit ((GApplication*) self);
}

MusicApplication*
music_application_construct (GType object_type)
{
	MusicApplication * self = NULL;
	self = (MusicApplication*) g_object_new (object_type, "application-id", "io.elementary.music", "flags", G_APPLICATION_HANDLES_OPEN, NULL);
	return self;
}

MusicApplication*
music_application_new (void)
{
	return music_application_construct (MUSIC_TYPE_APPLICATION);
}

static Block1Data*
block1_data_ref (Block1Data* _data1_)
{
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}

static void
block1_data_unref (void * _userdata_)
{
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		MusicApplication* self;
		self = _data1_->self;
		_g_object_unref0 (_data1_->gtk_settings);
		_g_object_unref0 (_data1_->granite_settings);
		_g_object_unref0 (self);
		g_slice_free (Block1Data, _data1_);
	}
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
__lambda31_ (Block1Data* _data1_)
{
	MusicApplication* self;
	GraniteSettingsColorScheme _tmp0_;
	GraniteSettingsColorScheme _tmp1_;
	self = _data1_->self;
	_tmp0_ = granite_settings_get_prefers_color_scheme (_data1_->granite_settings);
	_tmp1_ = _tmp0_;
	g_object_set (_data1_->gtk_settings, "gtk-application-prefer-dark-theme", _tmp1_ == GRANITE_SETTINGS_COLOR_SCHEME_DARK, NULL);
}

static void
___lambda31__g_object_notify (GObject* _sender,
                              GParamSpec* pspec,
                              gpointer self)
{
	__lambda31_ (self);
}

static void
music_application_real_startup (GApplication* base)
{
	MusicApplication * self;
	Block1Data* _data1_;
	MusicPlaybackManager* _tmp0_;
	MusicPlaybackManager* _tmp1_;
	gchar* _tmp2_;
	gchar** _tmp3_;
	gchar** _tmp4_;
	gint _tmp4__length1;
	gchar* _tmp5_;
	gchar** _tmp6_;
	gchar** _tmp7_;
	gint _tmp7__length1;
	GraniteSettings* _tmp8_;
	GraniteSettings* _tmp9_;
	GtkSettings* _tmp10_;
	GtkSettings* _tmp11_;
	GraniteSettingsColorScheme _tmp12_;
	GraniteSettingsColorScheme _tmp13_;
	self = (MusicApplication*) base;
	_data1_ = g_slice_new0 (Block1Data);
	_data1_->_ref_count_ = 1;
	_data1_->self = g_object_ref (self);
	G_APPLICATION_CLASS (music_application_parent_class)->startup ((GApplication*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_get_type (), GtkApplication));
	granite_init ();
	_tmp0_ = music_playback_manager_get_default ();
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->playback_manager);
	self->priv->playback_manager = _tmp1_;
	g_action_map_add_action_entries ((GActionMap*) self, MUSIC_APPLICATION_ACTION_ENTRIES, (gint) G_N_ELEMENTS (MUSIC_APPLICATION_ACTION_ENTRIES), self);
	_tmp2_ = g_strdup ("<Ctrl>F");
	_tmp3_ = g_new0 (gchar*, 1 + 1);
	_tmp3_[0] = _tmp2_;
	_tmp4_ = _tmp3_;
	_tmp4__length1 = 1;
	gtk_application_set_accels_for_action ((GtkApplication*) self, MUSIC_APPLICATION_ACTION_PREFIX MUSIC_APPLICATION_ACTION_FIND, _tmp4_);
	_tmp4_ = (_vala_array_free (_tmp4_, _tmp4__length1, (GDestroyNotify) g_free), NULL);
	_tmp5_ = g_strdup ("<Ctrl>Q");
	_tmp6_ = g_new0 (gchar*, 1 + 1);
	_tmp6_[0] = _tmp5_;
	_tmp7_ = _tmp6_;
	_tmp7__length1 = 1;
	gtk_application_set_accels_for_action ((GtkApplication*) self, MUSIC_APPLICATION_ACTION_PREFIX MUSIC_APPLICATION_ACTION_QUIT, _tmp7_);
	_tmp7_ = (_vala_array_free (_tmp7_, _tmp7__length1, (GDestroyNotify) g_free), NULL);
	_tmp8_ = granite_settings_get_default ();
	_tmp9_ = _g_object_ref0 (_tmp8_);
	_data1_->granite_settings = _tmp9_;
	_tmp10_ = gtk_settings_get_default ();
	_tmp11_ = _g_object_ref0 (_tmp10_);
	_data1_->gtk_settings = _tmp11_;
	g_object_set (_data1_->gtk_settings, "gtk-icon-theme-name", "elementary", NULL);
	g_object_set (_data1_->gtk_settings, "gtk-theme-name", "io.elementary.stylesheet.orange", NULL);
	_tmp12_ = granite_settings_get_prefers_color_scheme (_data1_->granite_settings);
	_tmp13_ = _tmp12_;
	g_object_set (_data1_->gtk_settings, "gtk-application-prefer-dark-theme", _tmp13_ == GRANITE_SETTINGS_COLOR_SCHEME_DARK, NULL);
	g_signal_connect_data ((GObject*) _data1_->granite_settings, "notify::prefers-color-scheme", (GCallback) ___lambda31__g_object_notify, block1_data_ref (_data1_), (GClosureNotify) block1_data_unref, 0);
	block1_data_unref (_data1_);
	_data1_ = NULL;
}

static void
_music_application_on_bus_acquired_gbus_acquired_callback (GDBusConnection* connection,
                                                           const gchar* name,
                                                           gpointer self)
{
	music_application_on_bus_acquired ((MusicApplication*) self, connection, name);
}

static void
music_application_real_activate (GApplication* base)
{
	MusicApplication * self;
	GtkWindow* _tmp0_;
	GtkWindow* _tmp1_;
	guint mpris_id = 0U;
	MusicMainWindow* main_window = NULL;
	gchar* _tmp4_;
	MusicMainWindow* _tmp5_ = NULL;
	MusicMainWindow* _tmp6_;
	MusicMainWindow* _tmp7_;
	GSettings* settings = NULL;
	GSettings* _tmp8_;
	GSettings* _tmp9_;
	MusicMainWindow* _tmp10_;
	GSettings* _tmp11_;
	MusicMainWindow* _tmp12_;
	GSettings* _tmp13_;
	GSettings* _tmp15_;
	MusicMainWindow* _tmp16_;
	MusicPlaybackManager* _tmp17_;
	self = (MusicApplication*) base;
	_tmp0_ = gtk_application_get_active_window ((GtkApplication*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		GtkWindow* _tmp2_;
		GtkWindow* _tmp3_;
		_tmp2_ = gtk_application_get_active_window ((GtkApplication*) self);
		_tmp3_ = _tmp2_;
		gtk_window_present (_tmp3_);
		return;
	}
	mpris_id = g_bus_own_name_with_closures (G_BUS_TYPE_SESSION, "org.mpris.MediaPlayer2.io.elementary.music", G_BUS_NAME_OWNER_FLAGS_NONE, (GClosure*) ((_music_application_on_bus_acquired_gbus_acquired_callback == NULL) ? NULL : g_cclosure_new ((GCallback) _music_application_on_bus_acquired_gbus_acquired_callback, g_object_ref (self), (GClosureNotify) g_object_unref)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	if (mpris_id == ((guint) 0)) {
		g_warning ("Application.vala:82: Could not initialize MPRIS session.\n");
	}
	_tmp4_ = g_strdup (_ ("Music"));
	_tmp5_ = music_main_window_new ();
	gtk_window_set_title ((GtkWindow*) _tmp5_, _tmp4_);
	_g_free0 (_tmp4_);
	g_object_ref_sink (_tmp5_);
	main_window = _tmp5_;
	_tmp6_ = main_window;
	gtk_window_present ((GtkWindow*) _tmp6_);
	_tmp7_ = main_window;
	gtk_application_add_window ((GtkApplication*) self, (GtkWindow*) _tmp7_);
	_tmp8_ = g_settings_new ("io.elementary.music");
	settings = _tmp8_;
	_tmp9_ = settings;
	_tmp10_ = main_window;
	g_settings_bind (_tmp9_, "window-height", (GObject*) _tmp10_, "default-height", G_SETTINGS_BIND_DEFAULT);
	_tmp11_ = settings;
	_tmp12_ = main_window;
	g_settings_bind (_tmp11_, "window-width", (GObject*) _tmp12_, "default-width", G_SETTINGS_BIND_DEFAULT);
	_tmp13_ = settings;
	if (g_settings_get_boolean (_tmp13_, "window-maximized")) {
		MusicMainWindow* _tmp14_;
		_tmp14_ = main_window;
		gtk_window_maximize ((GtkWindow*) _tmp14_);
	}
	_tmp15_ = settings;
	_tmp16_ = main_window;
	g_settings_bind (_tmp15_, "window-maximized", (GObject*) _tmp16_, "maximized", G_SETTINGS_BIND_SET);
	_tmp17_ = self->priv->playback_manager;
	music_playback_manager_restore_queue (_tmp17_);
	_g_object_unref0 (settings);
	_g_object_unref0 (main_window);
}

static void
_vala_array_add1 (GFile** * array,
                  gint* length,
                  gint* size,
                  GFile* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (GFile*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static GFile**
music_application_list_directory (const gchar* directory,
                                  gint* result_length1)
{
	GDir* dir = NULL;
	gchar* name = NULL;
	GFile** elements = NULL;
	GFile** _tmp7_;
	gint elements_length1;
	gint _elements_size_;
	GFile** _tmp18_;
	gint _tmp18__length1;
	GError* _inner_error0_ = NULL;
	GFile** result;
	g_return_val_if_fail (directory != NULL, NULL);
	{
		GDir* _tmp0_ = NULL;
		GDir* _tmp1_;
		GDir* _tmp2_;
		_tmp1_ = g_dir_open (directory, (guint) 0, &_inner_error0_);
		_tmp0_ = _tmp1_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_FILE_ERROR) {
				goto __catch0_g_file_error;
			}
			_g_dir_close0 (dir);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp2_ = _tmp0_;
		_tmp0_ = NULL;
		_g_dir_close0 (dir);
		dir = _tmp2_;
		_g_dir_close0 (_tmp0_);
	}
	goto __finally0;
	__catch0_g_file_error:
	{
		GError* e = NULL;
		GError* _tmp3_;
		const gchar* _tmp4_;
		GFile** _tmp5_;
		GFile** _tmp6_;
		gint _tmp6__length1;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp3_ = e;
		_tmp4_ = _tmp3_->message;
		g_warning ("Application.vala:117: %s", _tmp4_);
		_tmp5_ = g_new0 (GFile*, 0 + 1);
		_tmp6_ = _tmp5_;
		_tmp6__length1 = 0;
		if (result_length1) {
			*result_length1 = _tmp6__length1;
		}
		result = _tmp6_;
		_g_error_free0 (e);
		_g_dir_close0 (dir);
		return result;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_dir_close0 (dir);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	name = NULL;
	_tmp7_ = g_new0 (GFile*, 0 + 1);
	elements = _tmp7_;
	elements_length1 = 0;
	_elements_size_ = elements_length1;
	while (TRUE) {
		GDir* _tmp8_;
		const gchar* _tmp9_;
		gchar* _tmp10_;
		const gchar* _tmp11_;
		gchar* file_path = NULL;
		const gchar* _tmp12_;
		gchar* _tmp13_;
		GFile* file = NULL;
		const gchar* _tmp14_;
		GFile* _tmp15_;
		GFile* _tmp16_;
		GFile* _tmp17_;
		_tmp8_ = dir;
		_tmp9_ = g_dir_read_name (_tmp8_);
		_tmp10_ = g_strdup (_tmp9_);
		_g_free0 (name);
		name = _tmp10_;
		_tmp11_ = name;
		if (!(_tmp11_ != NULL)) {
			break;
		}
		_tmp12_ = name;
		_tmp13_ = g_build_filename (directory, _tmp12_, NULL);
		file_path = _tmp13_;
		_tmp14_ = file_path;
		_tmp15_ = g_file_new_for_path (_tmp14_);
		file = _tmp15_;
		_tmp16_ = file;
		_tmp17_ = _g_object_ref0 (_tmp16_);
		_vala_array_add1 (&elements, &elements_length1, &_elements_size_, _tmp17_);
		_g_object_unref0 (file);
		_g_free0 (file_path);
	}
	_tmp18_ = elements;
	_tmp18__length1 = elements_length1;
	if (result_length1) {
		*result_length1 = _tmp18__length1;
	}
	result = _tmp18_;
	_g_free0 (name);
	_g_dir_close0 (dir);
	return result;
}

static void
_vala_array_add2 (GFile** * array,
                  gint* length,
                  gint* size,
                  GFile* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (GFile*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add3 (GFile** * array,
                  gint* length,
                  gint* size,
                  GFile* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (GFile*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

GFile**
music_application_loop_through_files (GFile** files,
                                      gint files_length1,
                                      gint* result_length1)
{
	GFile** elements = NULL;
	GFile** _tmp0_;
	gint elements_length1;
	gint _elements_size_;
	GFile** _tmp17_;
	gint _tmp17__length1;
	GFile** result;
	_tmp0_ = g_new0 (GFile*, 0 + 1);
	elements = _tmp0_;
	elements_length1 = 0;
	_elements_size_ = elements_length1;
	{
		GFile** file_collection = NULL;
		gint file_collection_length1 = 0;
		gint _file_collection_size_ = 0;
		gint file_it = 0;
		file_collection = files;
		file_collection_length1 = files_length1;
		for (file_it = 0; file_it < file_collection_length1; file_it = file_it + 1) {
			GFile* _tmp1_;
			GFile* file = NULL;
			_tmp1_ = _g_object_ref0 (file_collection[file_it]);
			file = _tmp1_;
			{
				gchar* file_path = NULL;
				GFile* _tmp2_;
				gchar* _tmp3_;
				const gchar* _tmp4_;
				GFile* _tmp15_;
				GFile* _tmp16_;
				_tmp2_ = file;
				_tmp3_ = g_file_get_path (_tmp2_);
				file_path = _tmp3_;
				_tmp4_ = file_path;
				if (g_file_test (_tmp4_, G_FILE_TEST_IS_DIR)) {
					GFile** directory_elements = NULL;
					const gchar* _tmp5_;
					gint _tmp6_ = 0;
					GFile** _tmp7_;
					gint directory_elements_length1;
					gint _directory_elements_size_;
					GFile** directory_files = NULL;
					GFile** _tmp8_;
					gint _tmp8__length1;
					gint _tmp9_ = 0;
					GFile** _tmp10_;
					gint directory_files_length1;
					gint _directory_files_size_;
					GFile** _tmp11_;
					gint _tmp11__length1;
					_tmp5_ = file_path;
					_tmp7_ = music_application_list_directory (_tmp5_, &_tmp6_);
					directory_elements = _tmp7_;
					directory_elements_length1 = _tmp6_;
					_directory_elements_size_ = directory_elements_length1;
					_tmp8_ = directory_elements;
					_tmp8__length1 = directory_elements_length1;
					_tmp10_ = music_application_loop_through_files (_tmp8_, (gint) _tmp8__length1, &_tmp9_);
					directory_files = _tmp10_;
					directory_files_length1 = _tmp9_;
					_directory_files_size_ = directory_files_length1;
					_tmp11_ = directory_files;
					_tmp11__length1 = directory_files_length1;
					{
						GFile** directory_file_collection = NULL;
						gint directory_file_collection_length1 = 0;
						gint _directory_file_collection_size_ = 0;
						gint directory_file_it = 0;
						directory_file_collection = _tmp11_;
						directory_file_collection_length1 = _tmp11__length1;
						for (directory_file_it = 0; directory_file_it < directory_file_collection_length1; directory_file_it = directory_file_it + 1) {
							GFile* _tmp12_;
							GFile* directory_file = NULL;
							_tmp12_ = _g_object_ref0 (directory_file_collection[directory_file_it]);
							directory_file = _tmp12_;
							{
								GFile* _tmp13_;
								GFile* _tmp14_;
								_tmp13_ = directory_file;
								_tmp14_ = _g_object_ref0 (_tmp13_);
								_vala_array_add2 (&elements, &elements_length1, &_elements_size_, _tmp14_);
								_g_object_unref0 (directory_file);
							}
						}
					}
					directory_files = (_vala_array_free (directory_files, directory_files_length1, (GDestroyNotify) g_object_unref), NULL);
					directory_elements = (_vala_array_free (directory_elements, directory_elements_length1, (GDestroyNotify) g_object_unref), NULL);
					_g_free0 (file_path);
					_g_object_unref0 (file);
					continue;
				}
				_tmp15_ = file;
				_tmp16_ = _g_object_ref0 (_tmp15_);
				_vala_array_add3 (&elements, &elements_length1, &_elements_size_, _tmp16_);
				_g_free0 (file_path);
				_g_object_unref0 (file);
			}
		}
	}
	_tmp17_ = elements;
	_tmp17__length1 = elements_length1;
	if (result_length1) {
		*result_length1 = _tmp17__length1;
	}
	result = _tmp17_;
	return result;
}

static void
music_application_real_open (GApplication* base,
                             GFile** files,
                             gint files_length1,
                             const gchar* hint)
{
	MusicApplication * self;
	GtkWindow* _tmp0_;
	GtkWindow* _tmp1_;
	GFile** files_to_play = NULL;
	gint _tmp2_ = 0;
	GFile** _tmp3_;
	gint files_to_play_length1;
	gint _files_to_play_size_;
	MusicPlaybackManager* _tmp4_;
	self = (MusicApplication*) base;
	g_return_if_fail (hint != NULL);
	_tmp0_ = gtk_application_get_active_window ((GtkApplication*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == NULL) {
		g_application_activate ((GApplication*) self);
	}
	_tmp3_ = music_application_loop_through_files (files, (gint) files_length1, &_tmp2_);
	files_to_play = _tmp3_;
	files_to_play_length1 = _tmp2_;
	_files_to_play_size_ = files_to_play_length1;
	g_debug ("Application.vala:164: Application: Number of files to play %u", (guint) files_to_play_length1);
	_tmp4_ = self->priv->playback_manager;
	music_playback_manager_queue_files (_tmp4_, files_to_play, (gint) files_to_play_length1);
	files_to_play = (_vala_array_free (files_to_play, files_to_play_length1, (GDestroyNotify) g_object_unref), NULL);
}

static void
music_application_action_find (MusicApplication* self)
{
	GtkWindow* _tmp0_;
	GtkWindow* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_application_get_active_window ((GtkApplication*) self);
	_tmp1_ = _tmp0_;
	music_main_window_start_search (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, MUSIC_TYPE_MAIN_WINDOW, MusicMainWindow));
}

static void
music_application_on_bus_acquired (MusicApplication* self,
                                   GDBusConnection* connection,
                                   const gchar* name)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (connection != NULL);
	g_return_if_fail (name != NULL);
	{
		MusicMprisRoot* _tmp0_;
		MusicMprisRoot* _tmp1_;
		MusicMprisPlayer* _tmp2_;
		MusicMprisPlayer* _tmp3_;
		_tmp0_ = music_mpris_root_new ();
		_tmp1_ = _tmp0_;
		music_mpris_root_register_object (_tmp1_, connection, "/org/mpris/MediaPlayer2", &_inner_error0_);
		_g_object_unref0 (_tmp1_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_IO_ERROR) {
				goto __catch0_g_io_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
		_tmp2_ = music_mpris_player_new (connection);
		_tmp3_ = _tmp2_;
		music_mpris_player_register_object (_tmp3_, connection, "/org/mpris/MediaPlayer2", &_inner_error0_);
		_g_object_unref0 (_tmp3_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_IO_ERROR) {
				goto __catch0_g_io_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	goto __finally0;
	__catch0_g_io_error:
	{
		GError* e = NULL;
		GError* _tmp4_;
		const gchar* _tmp5_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp4_ = e;
		_tmp5_ = _tmp4_->message;
		g_warning ("Application.vala:177: could not create MPRIS player: %s\n", _tmp5_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static gint
music_application_main (gchar** args,
                        gint args_length1)
{
	MusicApplication* _tmp0_;
	MusicApplication* _tmp1_;
	gint _tmp2_;
	gint result;
	gst_init ((gint*) (&args_length1), &args);
	_tmp0_ = music_application_new ();
	_tmp1_ = _tmp0_;
	_tmp2_ = g_application_run ((GApplication*) _tmp1_, (gint) args_length1, args);
	_g_object_unref0 (_tmp1_);
	result = _tmp2_;
	return result;
}

int
main (int argc,
      char ** argv)
{
	return music_application_main (argv, argc);
}

static GObject *
music_application_constructor (GType type,
                               guint n_construct_properties,
                               GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	MusicApplication * self;
	parent_class = G_OBJECT_CLASS (music_application_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, MUSIC_TYPE_APPLICATION, MusicApplication);
	setlocale (LC_ALL, "");
	bindtextdomain (CONSTANTS_GETTEXT_PACKAGE, CONSTANTS_LOCALEDIR);
	bind_textdomain_codeset (CONSTANTS_GETTEXT_PACKAGE, "UTF-8");
	textdomain (CONSTANTS_GETTEXT_PACKAGE);
	return obj;
}

static void
music_application_class_init (MusicApplicationClass * klass,
                              gpointer klass_data)
{
	music_application_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &MusicApplication_private_offset);
	((GApplicationClass *) klass)->startup = (void (*) (GApplication*)) music_application_real_startup;
	((GApplicationClass *) klass)->activate = (void (*) (GApplication*)) music_application_real_activate;
	((GApplicationClass *) klass)->open = (void (*) (GApplication*, GFile**, gint, const gchar*)) music_application_real_open;
	G_OBJECT_CLASS (klass)->constructor = music_application_constructor;
	G_OBJECT_CLASS (klass)->finalize = music_application_finalize;
}

static void
music_application_instance_init (MusicApplication * self,
                                 gpointer klass)
{
	self->priv = music_application_get_instance_private (self);
	self->priv->playback_manager = NULL;
}

static void
music_application_finalize (GObject * obj)
{
	MusicApplication * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, MUSIC_TYPE_APPLICATION, MusicApplication);
	_g_object_unref0 (self->priv->playback_manager);
	G_OBJECT_CLASS (music_application_parent_class)->finalize (obj);
}

static GType
music_application_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (MusicApplicationClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) music_application_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (MusicApplication), 0, (GInstanceInitFunc) music_application_instance_init, NULL };
	GType music_application_type_id;
	music_application_type_id = g_type_register_static (gtk_application_get_type (), "MusicApplication", &g_define_type_info, 0);
	MusicApplication_private_offset = g_type_add_instance_private (music_application_type_id, sizeof (MusicApplicationPrivate));
	return music_application_type_id;
}

GType
music_application_get_type (void)
{
	static volatile gsize music_application_type_id__once = 0;
	if (g_once_init_enter (&music_application_type_id__once)) {
		GType music_application_type_id;
		music_application_type_id = music_application_get_type_once ();
		g_once_init_leave (&music_application_type_id__once, music_application_type_id);
	}
	return music_application_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

